/* $Id: lxdispatch.c,v 1.2 2002/04/26 23:08:55 smilcke Exp $ */

/*
 * dispatch.c
 * Autor:               Stefan Milcke
 * Erstellt am:         12.11.2001
 * Letzte Aenderung am: 27.04.2002
 *
*/
extern "C" {               // 16-bit header files are not C++ aware
#define INCL_NOPMAPI
#define INCL_DOSMISC
#include <os2.h>
}

#include <devhelp.h>
#include <devtype.h>
#include <devrp.h>
#include <ldefos2.h>
#include "lxdevown.h"
#include <linux/types.h>

extern "C" void OS2_V4lx_close_all_opened_devices(void);

//--------------------------------- StratClose ---------------------------------
ULONG StratClose(RP __far* _rp)
{
 RPOpenClose __far* rp = (RPOpenClose __far*)_rp;
 // only called if device successfully opened
 numOS2Opens--;
 if (numOS2Opens == 0)
 {
  OS2_V4lx_close_all_opened_devices();
  deviceOwner = DEV_NO_OWNER;
 }
 return(RPDONE);
}


#define MAX_SCHEDULES   16

extern "C" int volatile timervecs_initialized;
extern "C" unsigned long volatile jiffies=0;
extern "C" unsigned long schedules[MAX_SCHEDULES]={0};
extern "C" void run_timer_list(void);
extern "C" void run_thread_list(void);

int volatile timer_mode=0;

//--------------------------------- TimerEntry ---------------------------------
VOID __far TimerEntry(VOID);
#pragma aux TimerEntry "TIMER_ENTRY"
VOID __far TimerEntry(VOID)
{
 // increment jiffies
 jiffies++;
 timer_mode=1;
 // run timer list if initialized
 if(timervecs_initialized)
  run_timer_list();
 run_thread_list();
 timer_mode=0;
}

//------------------------------ schedule_timeout ------------------------------
extern "C" signed long schedule_timeout(signed long timeout)
{
 int i;
 signed long rc=0;
 DWORD cpuflags;
 DevPushfCli(&cpuflags);
 if(!timer_mode)
 {
  for(i=0;i<MAX_SCHEDULES;i++)
  {
   if(!schedules[i])
   {
    schedules[i]=(unsigned long)&schedules[i];
    rc=DevBlock(schedules[i],timeout==-1 ? 1 : timeout,0);
    DevCli();
//    DevPopf(cpuflags);
    schedules[i]=0;
    break;
   }
  }
 }
 DevPopf(cpuflags);
 return rc;
}

//---------------------------------- schedule ----------------------------------
extern "C" void schedule(void)
{
 schedule_timeout(-1);
}

//----------------------------------- EoiIrq -----------------------------------
extern "C" void EoiIrq(int irq)
{
 DevEOI(irq);
}

extern "C" FUNCTION IRQ_HDLRPTR;
static int irq_use_count[16]={0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};

//--------------------------------- RequestIrq ---------------------------------
extern "C" int RequestIrq(int irq,int flags)
{
 int rc=0;
 if(irq>=0 && irq<=15)
 {
  if(0==irq_use_count[irq])
  {
   rc=DevIRQSet(irq,IRQ_HDLRPTR,flags);
   if(0==rc)
    irq_use_count[irq]++;
  }
  return rc;
 }
 else
  return -1;
}

//---------------------------------- FreeIrq -----------------------------------
extern "C" void FreeIrq(int irq)
{
 if(irq>=0 && irq<=15)
 {
  if(irq_use_count[irq])
  {
   irq_use_count[irq]--;
   if(0==irq_use_count[irq])
    DevIRQClear(irq);
  }
 }
}
