/* $Id: lxGDTSel.c,v 1.2 2002/04/26 23:08:54 smilcke Exp $ */

/*
 * gdtsel.c
 * Autor:               Stefan Milcke
 * Erstellt am:         05.11.2001
 * Letzte Aenderung am: 15.12.2001
 *
*/
#ifdef __cplusplus
extern "C" {
#define INCL_NOPMAPI
#include <os2.h>
#endif

#include <devhelp.h>
#include <ldefos2.h>

int selectorsUsed[MAX_GDTSELECTORS]={0};

//------------------------------ allocGDTSelector ------------------------------
unsigned short allocGDTSelector(void)
{
 int i;
 unsigned short __far *GDTSelectors=(unsigned short __far *)__Make48Pointer(GDTSelectors32);
 for(i=0;i<MAX_GDTSELECTORS;i++)
  if(!selectorsUsed[i])
  {
   selectorsUsed[i]=1;
   return GDTSelectors[i];
  }
 return 0;
}

//------------------------------ freeGDTSelector -------------------------------
int freeGDTSelector(unsigned short selector)
{
 int i;
 unsigned short __far *GDTSelectors=(unsigned short __far *)__Make48Pointer(GDTSelectors32);
 for(i=0;i<MAX_GDTSELECTORS;i++)
  if(GDTSelectors[i]==selector)
  {
   selectorsUsed[i]=0;
   return TRUE;
  }
 return FALSE;
}


#ifdef __cplusplus
}
#endif
