/****************************************************************************/
/*
 *    PROGRAM NAME: SADMIN32
 *    ------------
 *    OS/2 Lan Server 4.0 API 32-bit sample program.
 *    @Copyright International Business Machines Corp. 1994
 *
 *    What this program does: This program executes a command on a remote
 *    server. The command to be executed on the remote server is passed
 *    as a command line parameter to this program but it must reside
 *    on a disk visible to the target server.
 *
 *    REQUIRED FILES:
 *    --------------
 *    SADMIN32.C     -  Source code for this program
 *
 *    REQUIRED LIBRARIES:
 *    ------------------
 *    NETAPI32.LIB   -  Netapi library (in \IBMLAN\NETSRC\OS2\LIB directory)
 *
 *    NetAPI32 functions used in this program:
 *    ---------------------------------------
 *    Net32ServerAdminCommand
 *
 *    HOW TO COMPILE THIS PROGRAM:
 *    ----------------------------
 *    icc /Gt+ /DPURE_32 /C sadmin32.c
 *
 ****************************************************************************/

/*------- OS/2 include files -----------------------------------------------*/
#define  INCL_BASE
#include <os2.h>

/*------- NET APIs include files -------------------------------------------*/
#include <lanserv\neterr.h>
#include <lanserv\netcons.h>
#include <lanserv\server.h>

/*------- C include files --------------------------------------------------*/
#include <string.h>
#include <stdio.h>

VOID Error_Message(USHORT, PSZ);

/*------- Definitions ------------------------------------------------------*/
#define  BUFLEN 10000                   /* output buffer size */

/****************************************************************************/
/* MAIN C function                                                          */
/*--------------------------------------------------------------------------*/
VOID
main(int argc, char *argv[])
{
    USHORT   usRc          = 0,       /* return code */
             usCmdLen      = 0,       /* command line length */
             usArgc;                  /* arguments counter */
    ULONG    ulBytesRead   = 0,       /* number of bytes read */
             ulTotalAvail  = 0;       /* available entries */
    SHORT    sResult       = 0;       /* exit code of the executed command */
    PCHAR    pcBuf;                   /* pointer to output buffer */
    PCHAR    pcCommand;               /* pointer to command buffer */
    CHAR     servername[UNCLEN+1];    /* server name */

    strupr(argv[0]);

    if (argc < 3)
    {
        printf("\nUsage: %s <\\\\targetservername> <commands>\n", argv[0]);
        DosExit(EXIT_PROCESS, 1);
    }

    strupr(argv[1]);
    strcpy(servername, argv[1]);

    /* calculate the size of command buffer */
    for (usArgc = 2; usArgc < argc ; usArgc++)
    {
        usCmdLen += strlen(argv[usArgc]) + 1;
    }

    /* allocate command buffer */
    usRc = DosAllocMem((PPVOID)&pcCommand,
                       usCmdLen,
                       PAG_READ | PAG_WRITE | PAG_COMMIT);

    /* Print a message and exit if buffer can't be allocated. */
    if (usRc)
    {
        printf("SADMCMD: Unable to allocate memory.\n");
        Error_Message(usRc, "DosAllocMem");
        DosExit(EXIT_PROCESS, (ULONG)usRc);
    }

    /* Set the buffer to all zeroes. */
    memset(pcCommand, '\x00', usCmdLen);

    /* fill command buffer with arguments from command line */
    strcpy(pcCommand, argv[2]);

    for (usArgc = 3; usArgc < argc ; usArgc++)
    {
        strcat(pcCommand," ");
        strcat(pcCommand, argv[usArgc]);
    }

    /* allocate output buffer */
    usRc = DosAllocMem((PPVOID)&pcBuf,
                       BUFLEN,
                       PAG_READ | PAG_WRITE | PAG_COMMIT);

    /* Print a message and exit if buffer can't be allocated. */
    if (usRc)
    {
        printf("SADMCMD: Unable to allocate memory.\n");
        Error_Message(usRc, "DosAllocMem");
        (void)DosFreeMem((PVOID)pcCommand);
        DosExit(EXIT_PROCESS, (ULONG)usRc);
    }

    /* Set the buffer to all zeroes. */
    memset(pcBuf, '\x00', BUFLEN);

    printf("Command sent to %s is: %s\n",servername, pcCommand);

    /* call api function */
    usRc = Net32ServerAdminCommand(servername,    /* name of remote server */
                                   pcCommand,     /* command to be executed */
                                   &sResult,      /* returned exit code */
                                   pcBuf,         /* output buffer */
                                   BUFLEN,        /* output buffer size */
                                   &ulBytesRead,  /* num of bytes returned */
                                   &ulTotalAvail);/* num of bytes available */


    if (usRc == NERR_Success || usRc == ERROR_MORE_DATA)
    {
        if (usRc == ERROR_MORE_DATA)
        {
            printf("The output buffer is too small to hold all the "\
                   "information generated by the \"%s\" command.\n\n",
                   pcCommand);

            printf("\nBytesread = %d TotalAvail = %d\n",
                    ulBytesRead, ulTotalAvail);
        }

        /* Print information in output buffer. */
        printf("Returned exit code = %d (HIGH NIBBLE IS ALWAYS 0)\n\n",
                sResult);

        *(pcBuf+BUFLEN-1) = '\0';    /* null-terminate output buffer */
        printf("%s\n", pcBuf);
    }

    if (usRc && usRc != ERROR_MORE_DATA)
        Error_Message(usRc, "NetServerAdminCommand");

    /* Free memory and return. */
    (void)DosFreeMem((PVOID)pcCommand);
    (void)DosFreeMem((PVOID)pcBuf);
    DosExit(EXIT_PROCESS, (ULONG)usRc);
}
