;--------------------------------------------------------------------           
;*                GENERAL 802.2 DATA DECLARATIONS                   *           
;--------------------------------------------------------------------           
                                                                                
;--------------------------------------------------------------------           
;*                COMMAND_CONTROL_BLOCK                             *           
;*                                                                  *           
;*  THIS DATA DECLARATION MAY BE USED FOR ALL 802.2 COMMANDS.       *           
;--------------------------------------------------------------------           
COMMAND_CONTROL_BLOCK     STRUC                                                 
;                                                                               
 CCB_ADAPTER               DB    ?        ; Adapter number                      
 CCB_COMMAND               DB    ?        ; Command code                        
 CCB_RETCODE               DB    ?        ; Return code                         
 CCB_WORK                  DB    ?        ; Reserved work area                  
 CCB_POINTER               DD    ?        ; CCB chain pointer                   
 CCB_CMPL_FLAG             DD    ?        ; Completion flag                     
 CCB_PARM_OFFSET           DW    ?        ; Parameter table offset              
 CCB_PARAMETER_1           DW    ?        ; Parameter 1                         
 CCB_SEMAPHORE             DD    ?        ; System Semaphore handle             
 CCB_APPL_ID               DB    ?        ; Application ID                      
 CCB_READ_FLAG             DB    ?        ; READ attached indicator             
 CCB_APPL_KEY              DW    ?        ; Application key                     
 CCB_PARAMETER_2           DW    ?        ; Parameter 2                         
;                                                                               
COMMAND_CONTROL_BLOCK     ENDS                                                  
                                                                                
                                                                                
;--------------------------------------------------------------------           
;*  THE FIELD LOCATED AT CCB_CMPL_FLAG IS USED FOR TWO REASONS.     *           
;*  BELOW IS ANOTHER NAME THAT CAN BE USED TO ACCESS THE FIELD      *           
;*  FOR VARIOUS COMMANDS.                                           *           
;--------------------------------------------------------------------           
 CCB_CMPL_APPNDG           EQU   CCB_CMPL_FLAG                                  
                                                                                
                                                                                
;--------------------------------------------------------------------           
;*  THE FIELD LOCATED AT CCB_PARM_OFFSET IS USED FOR MANY REASONS.  *           
;*  BELOW ARE THE DIFFERENT NAMES THAT CAN BE USED TO ACCESS        *           
;*  THE FIELD FOR VARIOUS COMMANDS.                                 *           
;--------------------------------------------------------------------           
 FUNCTIONAL_ADDRESS        EQU   CCB_PARM_OFFSET                                
 GROUP_ADDRESS             EQU   CCB_PARM_OFFSET                                
 READ_CCB_ADDR             EQU   CCB_PARM_OFFSET                                
 TIMER_CCB                 EQU   CCB_PARM_OFFSET                                
 TIMER_CMPL_FLAG           EQU   CCB_PARM_OFFSET                                
 STATION_ID                EQU   CCB_PARM_OFFSET                                
 TIMER_CMPL_APPNDG         EQU   CCB_PARM_OFFSET                                
 TIMER_VALUE               EQU   CCB_PARM_OFFSET                                
                                                                                
                                                                                
;--------------------------------------------------------------------           
;*  THE FIELD LOCATED AT CCB_PARAMETER_1 IS USED FOR MANY REASONS.  *           
;*  BELOW ARE THE DIFFERENT NAMES THAT CAN BE USED TO ACCESS        *           
;*  THE FIELD FOR VARIOUS COMMANDS.                                 *           
;--------------------------------------------------------------------           
 OPEN_STATION_ID           EQU   CCB_PARAMETER_1                                
 RESET_ALL_SAPS            EQU   CCB_PARAMETER_1                                
 FLOW_CONTROL              EQU   CCB_PARAMETER_1                                
                                                                                
                                                                                
;--------------------------------------------------------------------           
;*  THE FIELD LOCATED AT CCB_SEMAPHORE IS USED FOR TWO REASONS.     *           
;*  BELOW IS ANOTHER NAME THAT CAN BE USED TO ACCESS THE FIELD      *           
;*  FOR VARIOUS COMMANDS.                                           *           
;--------------------------------------------------------------------           
 CCB_RESOURCE_ID           EQU   CCB_SEMAPHORE                                  
                                                                                
                                                                                
;--------------------------------------------------------------------           
;*  THE FIELD LOCATED AT CCB_PARAMETER_2 IS USED FOR MANY REASONS.  *           
;*  BELOW ARE THE DIFFERENT NAMES THAT CAN BE USED TO ACCESS        *           
;*  THE FIELD FOR VARIOUS COMMAND REQUESTS.                         *           
;--------------------------------------------------------------------           
 SYSTEM_KEY                EQU   CCB_PARAMETER_2                                
 PURGE_RESOURCE_ID         EQU   CCB_PARAMETER_2                                
                                                                                
                                                                                
;--------------------------------------------------------------------           
;*  COMMAND COMPLETION INFORMATION TABLE IS RETURNED FOR            *           
;*  COMMANDS USING APPENDAGES TO POST COMPLETION OF COMMANDS.       *           
;--------------------------------------------------------------------           
COMMAND_COMPLETION_INFO   STRUC                                                 
;                                                                               
 CCB_COUNT                 DW    ?        ; Count of CCBs chained               
 EVENT_CCB_POINTER         DD    ?        ; Pointer to chain of CCBs            
 BUFFER_COUNT              DW    ?        ; Count of buffers chained            
 FIRST_BUFFER_ADDR         DD    ?        ; Pointer to buffers chained          
;                                                                               
COMMAND_COMPLETION_INFO   ENDS                                                  
                                                                                
                                                                                
BUFFER_FREE_PARMS         STRUC                                                 
;                                                                               
 STATION_ID_BF             DW    ?        ; Station ID                          
 BUFFER_LEFT_BF            DW    ?        ; Number of buffers left              
                           DB  4 DUP(?)   ; RESERVED                            
 FIRST_BUFFER_BF           DD    ?        ; Address of first buffer             
;                                                                               
BUFFER_FREE_PARMS         ENDS                                                  
                                                                                
                                                                                
BUFFER_GET_PARMS          STRUC                                                 
;                                                                               
 STATION_ID_BG             DW    ?        ; Station ID                          
 BUFFER_LEFT_BG            DW    ?        ; Number of buffers left              
 BUFFER_GET_BG             DB    ?        ; Number of buffers to get            
                           DB  3 DUP(?)   ; RESERVED                            
 FIRST_BUFFER_BG           DD    ?        ; Address of first buffer             
;                                                                               
BUFFER_GET_PARMS          ENDS                                                  
                                                                                
READ_PARMS                STRUC                                                 
;                                                                               
 STATION_ID_RP             DW    ?        ; Station ID                          
 OPTION_INDICATOR_RP       DB    ?        ; Read option indicator               
 EVENT_SET_RP              DB    ?        ; notification event set              
 EVENT_RP                  DB    ?        ; Posting event                       
 CRITICAL_SUBSET_RP        DB    ?        ; Event subset identifier             
 NOTIFICATION_FLAG_RP      DD    ?        ; User notification flag              
 CCB_COUNT_RP              DW    ?        ; Count of CCBs attached              
 EVENT_CCB_POINTER_RP      DD    ?        ; Pointer to CCB chain                
 BUFFER_COUNT_RP           DW    ?        ; Count of buffers attached           
 FIRST_BUFFER_ADDR_RP      DD    ?        ; Pointer to buffer chain             
 RCV_FRAME_COUNT_RP        DW    ?        ; Count of frames attached            
 RCV_FRAME_ADDR_RP         DD    ?        ; pointer to frame chain              
 EVENT_ERROR_CODE_RP       DW    ?        ; Exception error code                
 EVENT_ERROR_DATA1_RP      DW    ?        ; Exception error data                
 EVENT_ERROR_DATA2_RP      DW    ?        ; Exception error data                
 EVENT_ERROR_DATA3_RP      DW    ?        ; Exception error data                
;                                                                               
READ_PARMS                ENDS                                                  
                                                                                
                                                                                
RECEIVE_PARMS             STRUC                                                 
;                                                                               
 STATION_ID_RCVP           DW    ?        ; Station ID                          
 USER_LENGTH_RCVP          DW    ?        ; Length of user space                
 RECEIVE_FLAG_RCVP         DB  4 DUP(?)   ; Receive user flag                   
 FIRST_BUFFER_RCVP         DD    ?        ; Address of first buffer             
 OPTIONS_RCVP              DB    ?        ; Receive options                     
                           DB  3 DUP(?)   ; RESERVED                            
 RCV_READ_OPTION_RCVP      DB    ?        ; READ posting option                 
;                                                                               
RECEIVE_PARMS             ENDS                                                  
                                                                                
                                                                                
;--------------------------------------------------------------------           
;*  THE FIELD LOCATED AT RECEIVE_FLAG_RCVP IS USED FOR TWO REASONS. *           
;*  BELOW IS ANOTHER NAME THAT CAN BE USED TO ACCESS THE FIELD      *           
;*  FOR THE RECEIVE COMMAND.                                        *           
;--------------------------------------------------------------------           
 RCV_DATA_APPNDG_RCVP      EQU   RECEIVE_FLAG_RCVP                              
                                                                                
RECEIVE_NOT_CONTIGUOUS    STRUC                                                 
;                                                                               
 BUF_POINTER_RNC           DD    ?        ; Pointer to next buffer              
 RCV_LEN_RNC               DW    ?        ; length of entire frame              
 LENGTH_IN_BUFFER_RNC      DW    ?        ; length of data in buffer            
 USER_OFFSET_RNC           DW    ?        ; offset to user space                
 USER_LENGTH_RNC           DW    ?        ; Length of user space                
 STATION_ID_RNC            DW    ?        ; Receiving station ID                
 OPTIONS_RNC               DB    ?        ; Receive option                      
 MESSAGE_TYPE_RNC          DB    ?        ; Type of message received            
 BUFFERS_LEFT_RNC          DW    ?        ; Number of buffers left              
 RCV_PCFE_RNC              DB    ?        ; Rcv physical control field          
 ADAPTER_NUM_RNC           DB    ?        ; Adapter number                      
 NEXT_FRAME_RNC            DD    ?        ; Pointer to next rcv frame           
 LAN_HEADER_LENGTH_RNC     DB    ?        ; Length of LAN header                
 DLC_HEADER_LENGTH_RNC     DB    ?        ; Length of DLC header                
 LAN_HEADER_RNC            DB 32 DUP(?)   ; LAN header of rcv frame             
 DLC_HEADER_RNC            DB  4 DUP(?)   ; DLC header of rcv frame             
;                                                                               
RECEIVE_NOT_CONTIGUOUS    ENDS                                                  
                                                                                
                                                                                
RECEIVE_CONTIGUOUS        STRUC                                                 
;                                                                               
 BUF_POINTER_RC            DD    ?        ; Pointer to next buffer              
 RCV_LEN_RC                DW    ?        ; length of entire frame              
 LENGTH_IN_BUFFER_RC       DW    ?        ; length of data in buffer            
 USER_OFFSET_RC            DW    ?        ; offset to user space                
 USER_LENGTH_RC            DW    ?        ; Length of user space                
 STATION_ID_RC             DW    ?        ; Receiving station ID                
 OPTIONS_RC                DB    ?        ; Receive option                      
 MESSAGE_TYPE_RC           DB    ?        ; Type of message received            
 BUFFERS_LEFT_RC           DW    ?        ; Number of buffers left              
 RCV_PCFE_RC               DB    ?        ; Rcv physical control field          
 ADAPTER_NUM_RC            DB    ?        ; Adapter number                      
 NEXT_FRAME_RC             DD    ?        ; Pointer to next rcv frame           
;                                                                               
RECEIVE_CONTIGUOUS        ENDS                                                  
                                                                                
                                                                                
RECEIVE_BUFFER_TWO        STRUC                                                 
;                                                                               
 BUF_POINTER_RB2           DD    ?        ; Pointer to next buffer              
 RCV_LEN_RB2               DW    ?        ; length of entire frame              
 LENGTH_IN_BUFFER_RB2      DW    ?        ; length of data in buffer            
 USER_OFFSET_RB2           DW    ?        ; offset to user space                
 USER_LENGTH_RB2           DW    ?        ; Length of user space                
;                                                                               
RECEIVE_BUFFER_TWO        ENDS                                                  
                                                                                
                                                                                
RECEIVE_MODIFY_PARMS      STRUC                                                 
;                                                                               
 STATION_ID_RMP            DW    ?        ; Station ID                          
 USER_LENGTH_RMP           DW    ?        ; Length of user data                 
 RCV_DATA_APPNDG_RMP       DW    ?        ; Receive data appendage offse t      
 RESERVED1_RMP             DW    ?        ; Reserved for application            
 FIRST_BUFFER_RMP          DD    ?        ; Address of first buffer             
 SUBROUTINE_ADDR           DW    ?        ; Subroutine offset                   
 RESERVED2_RMP             DW    ?        ; Reserved for application            
;                                                                               
RECEIVE_MODIFY_PARMS      ENDS                                                  
                                                                                
                                                                                
TRANSMIT_PARMS            STRUC                                                 
;                                                                               
 STATION_ID_TP             DW    ?        ; Station ID                          
 TRANSMIT_PCFE_TP          DB    ?        ; Transmit PCFE information           
 RSAP_TP                   DB    ?        ; Remote SAP value                    
 XMIT_QUEUE_ONE_TP         DD    ?        ; Address of transmit queue           
 XMIT_QUEUE_TWO_TP         DD    ?        ; Address of transmit queue           
 BUFFER_LEN_ONE_TP         DW    ?        ; Length of buffer one                
 BUFFER_LEN_TWO_TP         DW    ?        ; Length of buffer two                
 BUFFER_ONE_TP             DD    ?        ; Transmit buffer one                 
 BUFFER_TWO_TP             DD    ?        ; Transmit buffer two                 
 XMIT_READ_OPTION_TP       DB    ?        ; READ posting option                 
;                                                                               
TRANSMIT_PARMS            ENDS                                                  
                                                                                
                                                                                
TRANSMIT_BUFFER           STRUC                                                 
;                                                                               
 NEXT_BUF_POINTER_TB       DD    ?        ; Pointer to next buffer              
                           DB  2 DUP(?)   ;                                     
 LENGTH_IN_BUFFER_TB       DW    ?        ; Length of data in buffer            
 USER_DATA_TB              DW    ?        ; User data                           
 USER_LENGTH_TB            DW    ?        ; Length of user space                
;                                                                               
TRANSMIT_BUFFER           ENDS                                                  
                                                                                
                                                                                
DIR_INITIALIZE_PARMS      STRUC                                                 
;                                                                               
 BRING_UPS_IP              DW    ?        ; Bring-up error code                 
 SRAM_ADDRESS_IP           DW    ?        ; Configured addr of SRAM             
 SRAM_PAGE_IP              DB    ?        ; Configured SRAM meg page            
                           DB 15 DUP(?)   ; RESERVED                            
 SHARED_RAM_ADDRESS_IP     DD    ?        ; Virtual address of SRAM             
 MMIO_ADDRESS_IP           DD    ?        ; Virtual address of MMIO             
 DATA_SEG_ADDRESS_IP       DD    ?        ; Virtual address of DS               
;                                                                               
DIR_INITIALIZE_PARMS      ENDS                                                  
                                                                                
                                                                                
DIR_OPEN_ADAPTER_PARMS    STRUC                                                 
;                                                                               
 ADAPTER_PARMS_OFFSET_OA   DW    ?        ; Offset to adapter parms             
 RESERVED1_OA              DW    ?        ; Reserved for application            
                           DB  4 DUP(?)   ; RESERVED                            
 DLC_PARMS_OFFSET_OA       DW    ?        ; Offset to DLC parms                 
 RESERVED3_OA              DW    ?        ; Reserved for application            
                           DB  4 DUP(?)   ; RESERVED                            
;                                                                               
DIR_OPEN_ADAPTER_PARMS    ENDS                                                  
                                                                                
                                                                                
DIR_OPEN_AD_PARMS         STRUC                                                 
;                                                                               
 OPEN_ERROR_CODE_AP        DW    ?        ; Open adapter errors                 
 OPEN_OPTIONS_AP           DW    ?        ; Open options                        
 NODE_ADDRESS_AP           DB  6 DUP(?)   ; Station's Node address              
 GROUP_ADDRESS_AP          DD    ?        ; Station's Group address             
 FUNCTIONAL_ADDRESS_AP     DB  4 DUP(?)   ; Station's Functional addr           
 NUM_RCV_BUFFERS_AP        DW    ?        ; Number of receive buffers           
 RCV_BUFFER_LEN_AP         DW    ?        ; Length of receive buffers           
 DHB_BUFFER_LEN_AP         DW    ?        ; Length of DHB buffers               
 DATA_HOLD_BUFFERS_AP      DB    ?        ; Number of DHB buffers               
                           DB  3 DUP(?)   ; RESERVED                            
 PRODUCT_ID_OFFSET_AP      DW    ?        ; Offset to product ID                
 RESERVED_AP               DW    ?        ; Reserved for application            
 BRING_UPS_AP              DW    ?        ; Bring-up errors                     
 INIT_WARNINGS_AP          DW    ?        ; Initialization warnings             
 SEMAPHORE_COUNT_AP        DW    ?        ; Number of semaphores                
 SYS_SEMAPHORE_TABLE_AP    DD    ?        ; Addr to semaphore table             
 DDNAME                    DB  8 DUP(?)   ; Application's device driver         
;                                                                               
DIR_OPEN_AD_PARMS         ENDS                                                  
                                                                                
                                                                                
DIR_OPEN_DLC_PARMS        STRUC                                                 
;                                                                               
 DLC_MAX_SAP_DP            DB    ?        ; Maximum SAPs                        
 DLC_MAX_STATION_DP        DB    ?        ; Maximum link stations               
 DLC_MAX_GSAP_DP           DB    ?        ; Maximum group SAPs                  
 DLC_MAX_GSAP_MEM_DP       DB    ?        ; Maximum Group SAP members           
 DLC_T1_TICK_ONE_DP        DB    ?        ; T1 timer interval, group1           
 DLC_T2_TICK_ONE_DP        DB    ?        ; T2 timer interval, group1           
 DLC_TI_TICK_ONE_DP        DB    ?        ; TI timer interval, group1           
 DLC_T1_TICK_TWO_DP        DB    ?        ; T1 timer interval, group2           
 DLC_T2_TICK_TWO_DP        DB    ?        ; T2 timer interval, group2           
 DLC_TI_TICK_TWO_DP        DB    ?        ; Ti timer interval, group2           
;                                                                               
DIR_OPEN_DLC_PARMS        ENDS                                                  
                                                                                
                                                                                
DIR_OPEN_DIRECT_PARMS     STRUC                                                 
;                                                                               
 DIR_BUF_SIZE_ODP          DW    ?        ; Size of buffers in pool             
 DIR_POOL_LENGTH_ODP       DW    ?        ; Length of buffer pool               
 DIR_POOL_ADDRESS_ODP      DD    ?        ; Address of buffer pool              
 OPEN_OPTIONS_ODP          DW    ?        ; Open options                        
;                                                                               
DIR_OPEN_DIRECT_PARMS     ENDS                                                  
                                                                                
                                                                                
DIR_READ_LOG_PARMS        STRUC                                                 
;                                                                               
 LOG_ID_RLP                DW    ?        ; Identify log to read                
 LOG_BUF_LENGTH_RLP        DW    ?        ; Size of log buffer                  
 LOG_BUF_OFFSET_RLP        DW    ?        ; Offset of log buffer                
 RESERVED_RLP              DW    ?        ; Reserved for application            
 LOG_ACT_LENGTH_RLP        DW    ?        ; Actual length of log                
;                                                                               
DIR_READ_LOG_PARMS        ENDS                                                  
                                                                                
DIR_READ_LOG_TOKENRING    STRUC                                                 
;                                                                               
 LINE_ERRORS_RLT           DB    ?        ; Line error count                    
 INTERNAL_ERRORS_RLT       DB    ?        ; Internal error count                
 BURST_ERRORS_RLT          DB    ?        ; Burst error count                   
 ARI_FCI_DELIMITER_RLT     DB    ?        ; ARI/FCI delimiter                   
 ABORT_DELIMITER_RLT       DB    ?        ; Abort delimiter                     
                           DB    ?        ; RESERVED                            
 LOST_FRAMES_RLT           DB    ?        ; Lost frame count                    
 RECEIVE_CONGESTION_RLT    DB    ?        ; Receive congestion count            
 FRAME_COPIED_ERRORS_RLT   DB    ?        ; Frame copied error count            
 FREQUENCY_ERRORS_RLT      DB    ?        ; Frequency error count               
 TOKEN_ERRORS_RLT          DB    ?        ; Token-Ring error count              
                           DB  3 DUP(?)   ; RESERVED                            
;                                                                               
DIR_READ_LOG_TOKENRING    ENDS                                                  
                                                                                
                                                                                
DIR_READ_LOG_PCNETWORK    STRUC                                                 
;                                                                               
 CRC_ERRORS_RLP            DB    ?        ; CRC error count                     
                           DB    ?        ; RESERVED                            
 ALIGNMENT_ERRORS_RLP      DB    ?        ; Alignment error count               
                           DB    ?        ; RESERVED                            
 TRANSMIT_ERRORS_RLP       DB    ?        ; Transmit error count                
                           DB    ?        ; RESERVED                            
 COLLISION_ERRORS_RLP      DB    ?        ; Collision error count               
 RCV_CONGESTION_ERRORS     DB    ?        ; Receive congestion count            
                           DB  6 DUP(?)   ; RESERVED                            
;                                                                               
DIR_READ_LOG_PCNETWORK    ENDS                                                  
                                                                                
                                                                                
DIR_SET_EXCEPTION_PARMS   STRUC                                                 
;                                                                               
 ADAPTER_CHECK_FLAG        DD    ?        ; Adapter check flag                  
 RING_NETWORK_STATUS_FLAG  DD    ?        ; Ring/Network status flag            
 PC_ERROR_FLAG             DD    ?        ; PC-detected error flag              
 SYSTEM_ACTION_FLAG        DD    ?        ; System action flag                  
;                                                                               
DIR_SET_EXCEPTION_PARMS   ENDS                                                  
                                                                                
                                                                                
;--------------------------------------------------------------------           
;*  THE FIELDS USED FOR THE EXCEPTION FLAGS                         *           
;*   -ADAPTER_CHECK_FLAG          -PC_ERROR_FLAG                    *           
;*   -RING_NETWORK_STATUS_FLAG    -SYSTEM_ACTION_FLAG               *           
;*  ARE USED FOR TWO REASONS.  BELOW ARE OTHER NAMES                *           
;*  THAT CAN BE USED TO ACCESS THE FIELDS FOR THE                   *           
;*  DIR.SET.EXCEPTION_FLAGS command.                                *           
;--------------------------------------------------------------------           
 ADAPTER_CHECK_APPNDG      EQU   ADAPTER_CHECK_FLAG                             
 NETWORK_STATUS_APPNDG     EQU   RING_NETWORK_STATUS_FLAG                       
 PC_ERROR_APPNDG           EQU   PC_ERROR_FLAG                                  
 SYSTEM_ACTION_APPNDG      EQU   SYSTEM_ACTION_FLAG                             
                                                                                
                                                                                
DIR_STATUS_PARMS          STRUC                                                 
;                                                                               
 BURNED_IN_ADDR_SP         DB  6 DUP(?)   ; Adapter's burned in addr            
 NODE_ADDRESS_SP           DB  6 DUP(?)   ; Station's Node address              
 GROUP_ADDRESS_SP          DB  4 DUP(?)   ; Station's Group address             
 FUNCTION_ADDRESS_SP       DB  4 DUP(?)   ; Station's Functional addr           
 MAX_SAP_SP                DB    ?        ; Maximum SAPs                        
 OPEN_SAP_SP               DB    ?        ; Number of opened SAPs               
 MAX_STATION_SP            DB    ?        ; Maximum link stations               
 OPEN_STATION_SP           DB    ?        ; Number of opened link stn           
 AVAIL_STATION_SP          DB    ?        ; Available link stations             
 ADAPTER_CONFIG_SP         DB    ?        ; Adapter configuration               
 MICROCODE_LEVEL_SP        DB 10 DUP(?)   ; Microcode level                     
 ADAPTER_PARMS_ADDR_SP     DD    ?        ; Address of adapter parms            
 ADAPTER_MAC_ADDR_SP       DD    ?        ; Address of adapter MAC              
 TICK_COUNTER_ADDR_SP      DD    ?        ; Address of tick counter             
 LAST_RING_STATUS_SP       DW    ?        ; Last Ring/Network status            
 ADAPTER_TYPE_SP           DW    ?        ; Adapter type                        
;                                                                               
DIR_STATUS_PARMS          ENDS                                                  
                                                                                
                                                                                
DIR_STATUS_TOKENRING      STRUC                                                 
;                                                                               
 PHYS_ADDR_ST              DB  4 DUP(?)   ; Adapter physical address            
 UP_NODE_ADDR_ST           DB  6 DUP(?)   ; Upstream node address               
 UP_PHYS_ADDR_ST           DB  4 DUP(?)   ; Upstream physical address           
 POLL_ADDR_ST              DB  6 DUP(?)   ; Last poll address                   
 AUTH_ENV_ST               DB  2 DUP(?)   ; Authorized environment              
 ACC_PRIORITY_ST           DB  2 DUP(?)   ; Transmit access priority            
 SOURCE_CLASS_ST           DB  2 DUP(?)   ; Source class authorization          
 ATT_CODE_ST               DB  2 DUP(?)   ; Last attention code                 
 SOURCE_ADDR_ST            DB  6 DUP(?)   ; Last source address                 
 BEACON_TYPE_ST            DB  2 DUP(?)   ; Last beacon type                    
 MAJOR_VECTOR_ST           DB  2 DUP(?)   ; Last major vector                   
 RING_STATUS_ST            DB  2 DUP(?)   ; Ring status                         
 SOFT_ERROR_ST             DB  2 DUP(?)   ; Soft error timer value              
 FE_ERROR_ST               DB  2 DUP(?)   ; Front End error count               
 LOCAL_RING_ST             DB  2 DUP(?)   ; Local ring number                   
 MON_ERROR_ST              DB  2 DUP(?)   ; Monitor error code                  
 BEACON_TRANSMIT_ST        DB  2 DUP(?)   ; Beacon transmit type                
 BEACON_RECEIVE_ST         DB  2 DUP(?)   ; Beacon receive type                 
 FRAME_CORREL_ST           DB  2 DUP(?)   ; Frame correlation save              
 BEACON_NAUN_ST            DB  6 DUP(?)   ; Beaconing station NAUN              
                           DB  4 DUP(?)   ; RESERVED                            
 BEACON_PHYS_ST            DB  4 DUP(?)   ; Beaconing stn's phys addr           
;                                                                               
DIR_STATUS_TOKENRING      ENDS                                                  
                                                                                
                                                                                
DIR_STATUS_PCNETWORK      STRUC                                                 
;                                                                               
                           DB 28 DUP(?)   ; RESERVED                            
 SOURCE_ADDR_SP            DB  6 DUP(?)   ; Last source address                 
                           DB  2 DUP(?)   ; RESERVED                            
 MAJOR_VECTOR_SP           DB  2 DUP(?)   ; Last major vector                   
 NETWORK_STATUS_SP         DB  2 DUP(?)   ; Network status                      
 REPORT_ERROR_SP           DB  2 DUP(?)   ; Error report timer value            
 REPORT_ERROR_TICK_SP      DB  2 DUP(?)   ; Error timer tick counter            
 LOCAL_BUS_NUMBER_SP       DB  2 DUP(?)   ; Local bus number                    
                           DB  6 DUP(?)   ; RESERVED                            
 FRAME_CORREL_SP           DB  2 DUP(?)   ; Frame correlation save              
                           DB  6 DUP(?)   ; RESERVED                            
 NETWORK_SAMPLES_SP        DW    ?        ; Number of samples                   
 NETWORK_BUSY_SP           DW    ?        ; Number of busy samples              
                           DB  4 DUP(?)   ; RESERVED                            
;                                                                               
DIR_STATUS_PCNETWORK      ENDS                                                  
                                                                                
                                                                                
DLC_CONNECT_STATION_PARMS STRUC                                                 
;                                                                               
 STATION_ID_CSP            DW    ?        ; Station ID                          
                           DB  2 DUP(?)   ; RESERVED                            
 ROUTING_OFFSET_CSP        DW    ?        ; Offset to routing info              
 RESERVED_CSP              DW    ?        ; Reserved for application            
;                                                                               
DLC_CONNECT_STATION_PARMS ENDS                                                  
                                                                                
                                                                                
DLC_MODIFY_PARMS          STRUC                                                 
;                                                                               
                           DB  2 DUP(?)   ; RESERVED                            
 STATION_ID_MP             DW    ?        ; SAP or Link Station ID              
 TIMER_T1_MP               DB    ?        ; T1 timer value                      
 TIMER_T2_MP               DB    ?        ; T2 timer value                      
 TIMER_TI_MP               DB    ?        ; Ti timer value                      
 MAXOUT_MP                 DB    ?        ; Max transmits without ACK           
 MAXIN_MP                  DB    ?        ; Max receives without ACK            
 MAXOUT_INCR_MP            DB    ?        ; Dynamic window increment            
 MAX_RETRY_COUNT_MP        DB    ?        ; Maximum retry count                 
                           DB  3 DUP(?)   ; RESERVED                            
 ACCESS_PRIORITY_MP        DB    ?        ; Ring access priority                
                           DB  4 DUP(?)   ; RESERVED                            
 GROUP_COUNT_MP            DB    ?        ; Length of group list data           
 GROUP_LIST_OFFSET_MP      DW    ?        ; Offset to group list                
 RESERVED_MP               DW    ?        ; Reserved for application            
;                                                                               
DLC_MODIFY_PARMS          ENDS                                                  
                                                                                
                                                                                
DLC_OPEN_SAP_PARMS        STRUC                                                 
;                                                                               
 SAP_STATION_ID            DW    ?        ; SAP station ID                      
 USER_STAT_VALUE           DW    ?        ; User value for DLC Status           
 TIMER_T1                  DB    ?        ; Ti timer value                      
 TIMER_T2                  DB    ?        ; T2 timer value                      
 TIMER_TI                  DB    ?        ; Ti timer value                      
 MAXOUT                    DB    ?        ; Max transmits without ACK           
 MAXIN                     DB    ?        ; Max receives without ACK            
 MAXOUT_INCR               DB    ?        ; Dynamic window increment            
 MAX_RETRY_COUNT           DB    ?        ; Maximum retry count                 
 MAX_MEMBERS               DB    ?        ; Max SAPs for group list             
 MAX_I_FIELD               DW    ?        ; Max rcv data for I frames           
 SAP_VALUE                 DB    ?        ; SAP value to be assigned            
 OPTIONS_PRIORITY          DB    ?        ; SAP options/ring priority           
 SAP_STATION_COUNT         DB    ?        ; Requested number of stns            
                           DB  2 DUP(?)   ; RESERVED                            
 GROUP_COUNT               DB    ?        ; Length of group list data           
 GROUP_LIST_OFFSET         DW    ?        ; Offset of group list                
 RESERVED_OSAPP            DW    ?        ; Reserved for application            
 DLC_STATUS_FLAG           DD    ?        ; DLC status user flag                
 DLC_BUF_SIZE              DW    ?        ; Size of buffers in pool             
 DLC_POOL_LEN              DW    ?        ; Length of buffer pool               
 DLC_POOL_ADDRESS          DD    ?        ; Address of buffer pool              
 ADAPTER_AVAILABLE_STNS    DB    ?        ; Number of stns available            
;                                                                               
DLC_OPEN_SAP_PARMS        ENDS                                                  
                                                                                
                                                                                
;--------------------------------------------------------------------           
;*  THE FIELD LOCATED AT DLC_STATUS_FLAG IS USED FOR TWO REASONS.   *           
;*  BELOW IS ANOTHER NAME THAT CAN BE USED TO ACCESS THE FIELD      *           
;*  FOR THE DLC_OPEN_SAP COMMAND.                                   *           
;--------------------------------------------------------------------           
 DLC_STATUS_APPNDG         EQU   DLC_STATUS_FLAG                                
                                                                                
                                                                                
DLC_OPEN_STATION_PARMS    STRUC                                                 
;                                                                               
 STATION_ID_OSP            DW    ?        ; SAP station ID                      
 LINK_STATION_ID_OSP       DW    ?        ; Link station ID assigned            
 TIMER_T1_OSP              DB    ?        ; Ti timer value                      
 TIMER_T2_OSP              DB    ?        ; T2 timer value                      
 TIMER_TI_OSP              DB    ?        ; Ti timer value                      
 MAXOUT_OSP                DB    ?        ; Max transmits without ACK           
 MAXIN_OSP                 DB    ?        ; Max receives without ACK            
 MAXOUT_INCR_OSP           DB    ?        ; Dynamic window increment            
 MAX_RETRY_CNT_OSP         DB    ?        ; Maximum retry count                 
 RSAP_VALUE_OSP            DB    ?        ; Remote SAP value                    
 MAX_I_FIELD_OSP           DW    ?        ; Max rcv data for I frames           
 ACCESS_PRIORITY_OSP       DB    ?        ; Ring access priority                
                           DB    ?        ; RESERVED                            
 DESTINATION_OFFSET_OSP    DW    ?        ; Offset to remote dest add           
 RESERVED_OSP              DW    ?        ; Reserved for application            
DLC_OPEN_STATION_PARMS    ENDS                                                  
                                                                                
                                                                                
DLC_REALLOCATE_STNS_PARMS STRUC                                                 
;                                                                               
 STATION_ID_R              DW    ?        ; SAP station ID                      
 OPTION_BYTE_R             DB    ?        ; Increase/decrease flag              
 STATION_COUNT_R           DB    ?        ; Number of link stations             
 ADAPTER_AVAILABLE_STNS_R  DB    ?        ; Adapter: available stns             
 SAP_AVAILABLE_STNS_R      DB    ?        ; SAP: available stns                 
 ADAPTER_STATION_COUNT_R   DB    ?        ; Adapter: configured stns            
 SAP_STATION_COUNT_R       DB    ?        ; SAP: configured stns                
;                                                                               
DLC_REALLOCATE_STNS_PARMS ENDS                                                  
                                                                                
                                                                                
DLC_SET_THRESHOLD_PARMS   STRUC                                                 
;                                                                               
 STATION_ID_ST             DW    ?        ; SAP station ID                      
 BUFFER_THRESHOLD_ST       DW    ?        ; Buffer threshold number             
 ALERT_SEMAPHORE_ST        DD    ?        ; System semaphore handle             
;                                                                               
DLC_SET_THRESHOLD_PARMS   ENDS                                                  
                                                                                
                                                                                
DLC_STATISTICS_PARMS      STRUC                                                 
;                                                                               
 STATION_ID_STATP          DW    ?        ; Identify log to read                
 LOG_BUF_LENGTH_STATP      DW    ?        ; Size of log buffer                  
 LOG_BUF_OFFSET_STATP      DW    ?        ; Offset to log buffer                
 RESERVED_STATP            DW    ?        ; Reserved for application            
 LOG_ACT_LENGTH_STATP      DW    ?        ; Actual length of log                
 OPTIONS_STATP             DB    ?        ; Command options                     
;                                                                               
DLC_STATISTICS_PARMS      ENDS                                                  
                                                                                
                                                                                
SAP_STATION_LOG           STRUC                                                 
;                                                                               
 FRAMES_TRANSMITTED_SSL    DD    ?        ; Frames transmitted count            
 FRAMES_RECEIVED_SSL       DD    ?        ; Frames received count               
 FRAMES_DISCARDED_SSL      DD    ?        ; Frames discarded count              
 LOST_DATA_SSL             DD    ?        ; Lost data count                     
 AVAILABLE_BUFFERS_SSL     DW    ?        ; Number of buffers left              
;                                                                               
SAP_STATION_LOG           ENDS                                                  
                                                                                
                                                                                
LINK_STATION_LOG          STRUC                                                 
;                                                                               
 IFRAMES_TRANSMITTED       DW    ?        ; Iframes transmit count              
 IFRAMES_RECEIVED          DW    ?        ; Iframes received count              
 IFRAMES_RECEIVE_ERRORS    DB    ?        ; Iframes received error              
 IFRAMES_TRANSMIT_ERRORS   DB    ?        ; Iframes transmit errors             
 TI_EXPIRED_COUNT          DW    ?        ; Ti expiration counts                
 LAST_CMND_RESP_RCVED      DB    ?        ; Last command received               
 LAST_CMND_RESP_SENT       DB    ?        ; Last command sent                   
 LINK_PRIMARY_STATE        DB    ?        ; Link primary state                  
 LINK_SECONDARY_STATE      DB    ?        ; Link secondary state                
 SEND_STATE_VARIABLE       DB    ?        ; Send state variable                 
 RECEIVE_STATE_VARIABLE    DB    ?        ; Receive state variable              
 LAST_RECEIVED_NR          DB    ?        ; Last Received NR value              
 LAN_HEADER_LENGTH         DB    ?        ; Length of LAN header                
;                                                                               
LINK_STATION_LOG          ENDS                                                  
                                                                                
                                                                                
DLC_HEADER_IFRAME         STRUC                                                 
;                                                                               
 DSAP                      DB    ?        ; Destination SAP                     
 SSAP                      DB    ?        ; Source SAP                          
 CONTROL                   DB  2 DUP(?)   ; Control information                 
;                                                                               
DLC_HEADER_IFRAME         ENDS                                                  
                                                                                
                                                                                
DLC_HEADER_NON_IFRAME     STRUC                                                 
;                                                                               
 DSAP_NI                   DB    ?        ; Destination SAP                     
 SSAP_NI                   DB    ?        ; Source SAP                          
 CONTROL_NI                DB  1 DUP(?)   ; Control information                 
;                                                                               
DLC_HEADER_NON_IFRAME     ENDS                                                  
                                                                                
                                                                                
LAN_HEADER_STR            STRUC                                                 
;                                                                               
 PCF0                      DB    ?        ; Physical control field 0            
 PCF1                      DB    ?        ; Physical control field 1            
 DEST_ADDR                 DB  6 DUP(?)   ; Destination address                 
 SOURCE_ADDR               DB  6 DUP(?)   ; Source address                      
 ROUTING_INFO_HEADER       DB  2 DUP(?)   ; Routing information hdr             
;                                                                               
LAN_HEADER_STR            ENDS                                                  
                                                                                
                                                                                
LAN_ENVELOPE_START        STRUC                                                 
;                                                                               
 S_DEL_EST                 DB    ?        ; Starting delimiter                  
 PCF0_EST                  DB    ?        ; Physical control field 0            
 PCF1_EST                  DB    ?        ; Physical control field 1            
 DEST_ADDR_EST             DB  6 DUP(?)   ; Destination address                 
 SOURCE_ADDR_EST           DB  6 DUP(?)   ; Source address                      
 ROUTING_INFO_HEADER_EST   DB  2 DUP(?)   ; Routing information hdr             
;                                                                               
LAN_ENVELOPE_START        ENDS                                                  
                                                                                
                                                                                
LAN_ENVELOPE_END          STRUC                                                 
;                                                                               
 FCS                       DB  4 DUP(?)   ; Frame Check Sequence                
 E_DEL                     DB    ?        ; End delimiter                       
 PCF_E                     DB    ?        ; PCF extension                       
;                                                                               
LAN_ENVELOPE_END          ENDS                                                  
                                                                                
