/********************************************************************/
/**                     Microsoft LAN Manager                      **/
/**               Copyright(c) Microsoft Corp., 1987-1990          **/
/********************************************************************/

/********************************************************************
 *                                                                  *
 *  About this file ...  SPOOL.H                                    *
 *                                                                  *
 *  This file contains information about the DosPrint APIs.         *
 *                                                                  *
 *      Function prototypes.                                        *
 *                                                                  *
 *      Data structure templates.                                   *
 *                                                                  *
 *      Definition of special values.                               *
 *                                                                  *
 *                                                                  *
 *  NOTE:  You must include NETCONS.H before this file, since this  *
 *         file depends on values defined in NETCONS.H.             *
 *                                                                  *
 ********************************************************************/


/****************************************************************
 *                                                              *
 *              Function prototypes                             *
 *                                                              *
 ****************************************************************/


#ifndef NO_INCL_PROTOTYPES      /* default is to define everything */

extern API_FUNCTION
 DosPrintDestEnum ( const char FAR *, short, char FAR *, unsigned short,
        unsigned short FAR *, unsigned short FAR * );

extern API_FUNCTION
  DosPrintDestControl ( const char FAR *, char FAR *, int );

extern API_FUNCTION
  DosPrintDestGetInfo ( const char FAR *, char FAR *, short,char FAR *,
        unsigned short, unsigned short FAR * );

extern API_FUNCTION
  DosPrintDestStatus (  char FAR *, unsigned short, unsigned short, char FAR * );

extern API_FUNCTION
 DosPrintQEnum ( const char FAR *, short, char FAR *, unsigned short,
        unsigned short FAR *, unsigned short FAR * );

/* Boca DCR 1400 support */
extern API_FUNCTION
 DosPrintDriverEnum ( const char FAR *, short, char FAR *, unsigned short,
        unsigned short FAR *, unsigned short FAR * );

extern API_FUNCTION
 DosPrintQProcessorEnum ( const char FAR *, short, char FAR *, unsigned short,
        unsigned short FAR *, unsigned short FAR * );

extern API_FUNCTION
 DosPrintPortEnum ( const char FAR *, short, char FAR *, unsigned short,
        unsigned short FAR *, unsigned short FAR * );

extern API_FUNCTION
  DosPrintQGetInfo ( const char FAR *, char FAR *, short, char FAR *, unsigned short, unsigned short FAR * );

extern API_FUNCTION
  DosPrintQSetInfo ( const char FAR *, char FAR *, short, char FAR *, unsigned short, short);

extern API_FUNCTION
  DosPrintQPause ( const char FAR *, char FAR * );

extern API_FUNCTION
  DosPrintQContinue ( const char FAR *, char FAR * );

extern API_FUNCTION
  DosPrintQPurge ( const char FAR *, char FAR * );

extern API_FUNCTION
  DosPrintQAdd ( const char FAR *, short, char FAR *, unsigned short );

extern API_FUNCTION
  DosPrintQDel ( const char FAR *, char FAR * );

extern API_FUNCTION
  DosPrintJobGetInfo ( const char FAR *, unsigned short, short,char FAR *,
        unsigned short, unsigned short FAR * );

extern API_FUNCTION
  DosPrintJobSetInfo ( const char FAR *, unsigned short,short, char FAR *,
        unsigned short, short );

/**INTERNAL_ONLY**/
extern API_FUNCTION
  DosPrintJobAdd ( const char FAR *, char FAR *, char FAR *, unsigned short,
        char FAR *, unsigned short FAR * );

extern API_FUNCTION
  DosPrintJobSchedule ( const char FAR *, unsigned short );

/**END_INTERNAL**/
extern API_FUNCTION
  DosPrintJobPause ( const char FAR *, unsigned short );

extern API_FUNCTION
  DosPrintJobContinue ( const char FAR *, unsigned short );

extern API_FUNCTION
  DosPrintJobDel ( const char FAR *, unsigned short );

extern API_FUNCTION
  DosPrintJobEnum( const char FAR *, const char FAR *, short, char FAR *,
        unsigned short, unsigned short FAR *,unsigned short FAR *);

extern API_FUNCTION
 DosPrintJobGetId(unsigned short, char FAR *, unsigned short);

extern API_FUNCTION
  PeerQueueControl( unsigned short, const char FAR *, unsigned short);

extern API_FUNCTION
  PeerSepControl( unsigned short, const char FAR *, unsigned short);
#endif

/****************************************************************
 *                                                              *
 *              Data structure templates                        *
 *                                                              *
 ****************************************************************/


struct prjob_info {
   unsigned short prjob_id;        /* job ID                                */
   char prjob_username[UNLEN+1];   /* submitting user name                  */
   char prjob_pad_1;               /* byte to pad to word boundary           */
   char prjob_notifyname[CNLEN+1]; /* message name to notify                */
   char prjob_datatype[DTLEN+1];   /* spool file data type name             */
   char FAR * prjob_parms;         /* implementation defined parameter string */
   unsigned short prjob_position;  /* position of the job in the queue        */
                                   /* For SetInfo                                   */
                                   /* 0 means do not change position        */
                                   /* position > # of jobs means the end            */
   unsigned short prjob_status;    /* job status                              */
   char FAR * prjob_status_string; /* status string posted by print processor */
   unsigned long prjob_submitted;  /* time when the job is submitted          */
                                   /* (from 1970-1-1 in seconds)              */
   unsigned long prjob_size;       /* job size                                */
   char FAR *prjob_comment;        /* comment associated with this job      */
}; /* prjob_info */

struct prdest_info {
   char prdest_name[PDLEN+1];       /* name of the print destination         */
   char prdest_username[UNLEN+1];   /* the username of current job.          */
   unsigned short prdest_jobid;     /* current printing job ID or 0 if none  */
   unsigned short prdest_status;    /* status of the destination, a bit mask */
   char FAR * prdest_status_string; /* status string posted by the processor */
   unsigned short prdest_time;      /* printing time in minutes.             */
}; /* prdest_info */

struct prq_info {
  char prq_name[QNLEN+1];        /* queue name                               */
  char prq_pad_1;                /* byte to pad to word boundary             */
  unsigned short prq_priority;   /* Priority (0-9) with 1 lowest             */
  unsigned short prq_starttime;  /* time to start the queue.                 */
                                 /* (from 00:00 of the day in minutes)       */
  unsigned short prq_untiltime;  /* time to stop the queue.                  */
                                 /* (from 00:00 of the day in minutes)       */
  char FAR * prq_separator;      /* separator file name                      */
  char FAR * prq_processor;      /* command string to invoke print processor */
                                 /*   ("PATHNAME PARM1=VAL1 PARM2=VAL2 ...") */
  char FAR * prq_destinations;   /* destination names the queue is routed to */
                                 /*   ("DEST1 DEST2 ...")                    */
  char FAR * prq_parms;          /* implementation defined parameter string  */
  char FAR * prq_comment;        /* comment string                           */
  unsigned short prq_status;     /* queue status mask:                       */
                                 /*   0  Queue active                        */
                                 /*   1  Queue paused                        */
                                 /*   2  Queue unscheduled                   */
                                 /*   3  Queue pending delete                */
  unsigned short prq_jobcount;   /* number of jobs in the queue              */
}; /* prq_info */

/*
 * structure for DosPrintJobGetId
 */
struct prid_info {
        unsigned short prjid_id;
        char prjid_server[CNLEN + 1];   /* server name */
        char prjid_qname[QNLEN+1];      /* queue to which the job is queued */
        char prjid_pad_1;               /* byte to pad to word boundary      */
}; /* prid_info */

/**INTERNAL_ONLY**/
#define PRINTQ     prq_info
#define PRINTDEST  prdest_info
#define PRINTJOB   prjob_info
#define GetPrintId prid_info
/**END_INTERNAL**/

/****************************************************************
 *                                                              *
 *              Special values and constants                    *
 *                                                              *
 ****************************************************************/




/*
 *      Values for parmnum in DosPrintQSetInfo.
 */

#define PRQ_PRIORITY_PARMNUM            2
#define PRQ_STARTTIME_PARMNUM           3
#define PRQ_UNTILTIME_PARMNUM           4
#define PRQ_SEPARATOR_PARMNUM           5
#define PRQ_PROCESSOR_PARMNUM           6
#define PRQ_DESTINATIONS_PARMNUM        7
#define PRQ_PARMS_PARMNUM               8
#define PRQ_COMMENT_PARMNUM             9
#define PRQ_MAXPARMNUM                  11

/*
 *      Print Queue Priority
 */

#define PRQ_MAX_PRIORITY                1
#define PRQ_DEF_PRIORITY                5
#define PRQ_MIN_PRIORITY                9

/*
 *      Print queue status bitmask and values.
 */

#define PRQ_STATUS_MASK                 3
#define PRQ_ACTIVE                      0
#define PRQ_PAUSE                       1
#define PRQ_ERROR                       2
#define PRQ_PENDING                     3

/*
 *      Values for parmnum in DosPrintJobSetInfo.
 */

#define PRJOB_NOTIFYNAME_PARMNUM        3
#define PRJOB_DATATYPE_PARMNUM          4
#define PRJOB_PARMS_PARMNUM             5
#define PRJOB_POSITION_PARMNUM          6
#define PRJOB_COMMENT_PARMNUM          11
#define PRJOB_MAXPARMNUM               11

/*
 *      Bitmap masks for prjob_status field of PRINTJOB.
 */

/* 2-7 bits also used in device status */

#define PRJOB_QSTATUS       0x3         /* Bits 0,1 */
#define PRJOB_DEVSTATUS    0x1fc        /* 2-8 bits */
#define PRJOB_COMPLETE      0x4         /*  Bit 2   */
#define PRJOB_INTERV        0x8         /*  Bit 3   */
#define PRJOB_ERROR        0x10         /*  Bit 4   */
#define PRJOB_DESTOFFLINE  0x20         /*  Bit 5   */
#define PRJOB_DESTPAUSED   0x40         /*  Bit 6   */
#define PRJOB_NOTIFY       0x80         /* BIT 7 */
#define PRJOB_DESTNOPAPER  0x100        /* BIT 8 */
#define PRJOB_DELETED      0x8000       /* BIT 15 */

/*
 *      Values of PRJOB_QSTATUS bits in prjob_status field of PRINTJOB.
 */

#define PRJOB_QS_QUEUED                 0
#define PRJOB_QS_PAUSED                 1
#define PRJOB_QS_SPOOLING               2
#define PRJOB_QS_PRINTING               3

/*
 *      Control codes used in DosPrintDestControl.
 */

#define PRDEST_DELETE                   0
#define PRDEST_PAUSE                    1
#define PRDEST_CONT                     2
#define PRDEST_RESTART                  3

/*
 *      These manifests define a two-bit field in prdest_status, and
 *      two of the values that field may take.
 */

#define PRDEST_STATUS_MASK              0x3
#define PRDEST_PAUSED                   0x1
#define PRDEST_ACTIVE                   0x0


/*
 *      Standard command argument when invoking print processor
 */
#define PPINPUT         "INPUT="
#define PPOUTPUT        "OUTPUT="
#define PPQUEUE         "QUEUE="
#define PPPARMS         "PARMS="
#define PPJOBID         "JOBID="

/**INTERNAL_ONLY**/
/*
 * Default separator file name
 */
#define DEFAULTSEPNAME          "DEFAULT.SEP"
/*
 * New IOctl for get_printQ_id
 */
#define SPOOL_LMCAT                     83
#define SPOOL_LMGetPrintId              0x60


/*
 * Spooler defined string
 */
#define SPOOL_TYPES     "TYPES="
#define SPOOL_EJECT     "EJECT="

/* Possible right hand value of eject option */
#define SPOOL_EJECT_YES  "YES"
#define SPOOL_EJECT_NO   "NO"
#define SPOOL_EJECT_AUTO "AUTO"


/*
 * Range regarding the configuration
 */
#define SPOOL_MIN_JOBS          40
#define SPOOL_MAX_JOBS          700
#define SPOOL_MIN_QS            1
#define SPOOL_MAX_QS            32
#define SPOOL_MIN_DEVS          1
#define SPOOL_MAX_DEVS          32

#define MAXDESTSIZE     (sizeof (struct PRINTDEST) + 17)

/**END_INTERNAL**/
