//******************************************************************************
// LHELLO.C
//
// LARC_S "LARC Examples"
// LARC_D "LARC Example Windows-based 'Hello' Program"
// LARC_V "100"
//
// Revision history:
// kbg 03/12/94 100 - Created.
//
//******************************************************************************

#include <windows.h>
#include <stdlib.h>
#include <string.h>
#include "lhello.h"

//******************************************************************************
//
// Windows Main Routine
//
//******************************************************************************
int PASCAL WinMain (HINSTANCE hInstance, HINSTANCE hPrevInstance, LPSTR lpszCmdLine, int nCmdShow)
    {
    MSG         msg;
    HANDLE      hAccel;

    hInst = hInstance;

    if (hPrevInstance)
        {
        MessageBox (NULL, "LARC 'Hello' is already running on your system!", "WARNING", MB_OK | MB_TASKMODAL);
        return (FALSE);
        }

    if (!SetUpWindowClass (hInstance))
        return (FALSE);

    hWndMain = CreateWindow (szAppName, "LARC Hello Example",
                WS_OVERLAPPEDWINDOW | WS_CLIPCHILDREN | WS_MAXIMIZE,
                0, 0, CW_USEDEFAULT, CW_USEDEFAULT,
                NULL, NULL, hInstance, NULL);

    ShowWindow (hWndMain, nCmdShow);
    UpdateWindow (hWndMain);

    hAccel = LoadAccelerators( hInst, szAppName);
    if (hAccel == NULL)
        {
        MessageBox (NULL, "Load Accellerators Failed", "WARNING", MB_OK | MB_TASKMODAL);
        return( FALSE);
        }

    while (GetMessage (&msg, NULL, 0, 0))
        {
        if (!TranslateAccelerator( hWndMain, hAccel, &msg))
            {
            TranslateMessage( &msg);
            DispatchMessage( &msg);
            }
        }

    return msg.wParam;
    }

//==============================================================================
//
// FUNCTION:    SetUpWindowClass ()
//
// PURPOSE:     Register the window classes used by this program.
//
// RETURNS:     TRUE    - classes registered OK.
//              FALSE   - class registration failed.
//
//==============================================================================
BOOL SetUpWindowClass( HANDLE hInstance )
    {
    WNDCLASS  wc;

    wc.style         = CS_HREDRAW | CS_VREDRAW;
    wc.lpfnWndProc   = WndProc;
    wc.cbClsExtra    = 0;
    wc.cbWndExtra    = 0;
    wc.hInstance     = hInstance;
    wc.hIcon         = LoadIcon (hInstance, szAppName);
    wc.hCursor       = LoadCursor (NULL, IDC_ARROW);
    wc.hbrBackground = GetStockObject (WHITE_BRUSH);
    wc.lpszMenuName  = szAppName;
    wc.lpszClassName = szAppName;
      
    return (RegisterClass (&wc));
    }

//==============================================================================
//
// FUNCTION:    WndProc (hWnd, iMessage, wParam, lParam)
//
// PURPOSE:     Handle messages for main window.
//
//==============================================================================
long FAR PASCAL WndProc( HWND hWnd, UINT iMessage, WPARAM wParam, LPARAM lParam )
    {
    DLGPROC  lpfnDlgProc;

    switch (iMessage)
        {
        case WM_CREATE:
            SendMessage (hWnd, WM_USER+1, 0, 0L);
            break;

        case WM_USER+1:
            PostMessage (hWnd, WM_COMMAND, IDM_ABOUT, 0L);
            break;

        case WM_COMMAND:
            switch (wParam)
                {
                case IDM_EXIT:
                    SendMessage (hWnd, WM_CLOSE, 0, 0L);
                    break;

                case IDM_ABOUT:
                    lpfnDlgProc = (DLGPROC)MakeProcInstance((FARPROC)AboutProc, hInst);
                    if (DialogBox (hInst, "ABOUTLHELLO", hWnd, lpfnDlgProc) < 0)
                        MessageBox (NULL, "About LARC Hello Dialog Box Load Failed", "WARNING", MB_OK | MB_TASKMODAL);
                    FreeProcInstance((FARPROC)lpfnDlgProc);
                    break;

                default:
                    return((LONG) DefWindowProc (hWnd, iMessage, wParam, lParam));
                    break;
                }
            break;

        case WM_CLOSE:
            DestroyWindow( hWnd );
            break;

        case WM_DESTROY:
            PostQuitMessage (0);
            break;

        default:
            return((LONG) DefWindowProc (hWnd, iMessage, wParam, lParam));
        }

    return 0L;
    }

//==============================================================================
//
// FUNCTION:  AboutProc ( )
//
// PURPOSE:   Function to display and process the WinLarc "about box".
//
//==============================================================================
BOOL FAR PASCAL AboutProc (HWND hDlg, UINT iMessage, WPARAM wParam, LPARAM lParam)
    {
    char szBuffer[50];

    switch (iMessage)
        {
        case WM_INITDIALOG:
            GetDlgItemText (hDlg, IDD_VERSION, szBuffer, sizeof(szBuffer));
            if (lstrlen(szBuffer) + lstrlen(szVersion) < sizeof(szBuffer))
                lstrcat (szBuffer, szVersion);
            SetDlgItemText (hDlg, IDD_VERSION, szBuffer);
           break;

        case WM_COMMAND:
            switch (wParam)
                {
                case IDOK:
                    EndDialog (hDlg, IDOK);
                    break;

                case IDCANCEL:
                    EndDialog (hDlg, IDOK);
                    break;

                default:
                    return (FALSE);
                }
            break;

        case WM_DESTROY:
            break;

        default:
            return (FALSE);
        }

    return (TRUE);
    }

/* END */
