@ECHO OFF
REM ============================================================================
REM 
REM LARC-S "LARC Examples"
REM LARC-D "Example Windows-based Release Build File"
REM LARC-V "100"
REM
REM Revision history:
REM kbg 05/14/94 100 - Created.
REM
REM Some general notes about this file follows.
REM
REM This batch file is started by LARC and LARC passes the following parameters:
REM 
REM     %1 = Argument 1 contains the 8 character release identifier that you
REM	     entered when you started building the release.
REM
REM     %2 = Argument 2 contains the release build type that you selected:
REM
REM		"*" = full system build requested.
REM		"T" = test build requested.
REM		"1" thru "5" = individual test build requested.
REM
REM     %3 = Argument 3 contains the two character hard drive name (i.e., "C:").
REM
REM     %4 = Argument 4 contains source file directory name (i.e., "C:\LARCEMP").
REM
REM     %5 = Argument 5 contains release directory name (i.e., "C:\LARCREL").
REM
REM     %6 = Argument 6 contains current system date formatted as mm-dd-yy.
REM
REM     %7 = Argument 7 contains current system time formatted as hh:mm:ss.
REM
REM     %8 = Argument 8 contains the three character source library number.
REM	     This number can be used with LARC utility programs such as
REM	     GETLARC to extract file information from LARC libraries.
REM
REM     %9 = Argument 9 contains the same release identifier that is passed in
REM	     argument 1, but this one has certain characters (such as "V",
REM	     and "." removed.  This argument provides the release identifier in
REM 	     a format that can be used to create file names.
REM
REM LARC allows you complete freedom over how your product is built.  Since
REM LARC executes this standard DOS command batch file, you can use any
REM combination of system commands to build the release.  The only requirement
REM made by LARC is that you must create the file named BUILDFIN.CTL if you
REM believe the build completed successfully.
REM
REM Normally, ECHO OFF is set to keep things like REM lines from being
REM scrolled up the screen.  Then ECHO commands are used to display progress
REM messages.  In addition, piping information to a "build progress" file
REM allows you to retain a record of the build for later inspection.  This
REM example pipes information to a file named MAKE.OUT.
REM
REM Not all development tools support piping, so some information may not get
REM saved.  You will need test your tools to determine if useful information
REM is saved if piping is used.
REM
REM Notice also that you should test DOS ERRORLEVEL after issuing commands
REM whenever possible.  The "GOTO ERRxx" statements allow the build command file
REM to terminate whenever an error is detected.  The error can then be resolved
REM and the build restarted.  Not all tools (especially older ones) set
REM ERRORLEVEL.  If your tool does not set ERRORLEVEL, you will need to use
REM other methods to ensure that the command completed successfully.  For
REM example, if your compiler only creates the object file if no errors are
REM encountered, then you should perform an "IF EXIST" test on the OBJ file.
REM ============================================================================




REM ============================================================================
REM The following set of ECHO commands demonstrates the idea of displaying
REM information to the screen and piping the same information to the build
REM progress file MAKE.OUT.  Notice that the first pipe command uses the ">"
REM character which causes the file to be created.  Since LARC always clears
REM the release directory, you could always use the ">>" characters because the
REM file will be created if it does not exist.
REM ============================================================================
ECHO.
ECHO LARC Examples %1 [%2]
ECHO.
ECHO Build created %6 at %7
ECHO.

ECHO.>MAKE.OUT
ECHO>>MAKE.OUT LARC Examples %1 [%2]
ECHO.>>MAKE.OUT
ECHO>>MAKE.OUT Build created %6 at %7
ECHO.>>MAKE.OUT




REM ============================================================================
REM The next series of SET commands are used to set the environment needed
REM by your development tools in order to build your product.  Ken's Environment
REM Verification utility program is used to make sure that the SET command
REM actually worked.
REM
REM Depending on the number of environment setting you need to make, you may
REM need to increase your space size.  Do this by using the "/E:xxxx" parameter
REM on the SHELL statement in your CONFIG.SYS file.  For example, using:
REM
REM	SHELL=C:\DOS\COMMAND.COM /P /E:2048
REM
REM will assign 2,048 bytes for the environment space.
REM
REM Once other consideration is that you may have to include dummy SET
REM statements in your AUTOEXEC.BAT file in order to reserve room for them in
REM the initial environment region.
REM
REM The following lines set the environment variables so that the Microsoft
REM Visual C/C++ 1.5 compiler can be used.
REM ============================================================================

SET PATH=
SET PATH=C:\MSVC\BIN;C:\SDK\BIN;C:\DOS;C:\WINDOWS;C:\LARC3;
KVERENV PATH=C:\MSVC\BIN;C:\SDK\BIN;C:\DOS;C:\WINDOWS;C:\LARC3;
IF ERRORLEVEL 1 GOTO ERR00

SET LIB=
SET LIB=C:\MSVC\LIB;C:\SDK\LIB;
KVERENV LIB=C:\MSVC\LIB;C:\SDK\LIB;
IF ERRORLEVEL 1 GOTO ERR00

SET INCLUDE=
SET INCLUDE=C:\MSVC\INCLUDE;C:\SDK\INCLUDE;C:\LARCSRC\EXAMPLES
KVERENV INCLUDE=C:\MSVC\INCLUDE;C:\SDK\INCLUDE;C:\LARCSRC\EXAMPLES
IF ERRORLEVEL 1 GOTO ERR00

SET TMP=
SET TMP=C:\MSVC
KVERENV TMP=C:\MSVC
IF ERRORLEVEL 1 GOTO ERR00




REM ============================================================================
REM It's a good idea to pipe the current environment setting into the MAKE.OUT
REM file.  The environment settings may come in handy either in investigating
REM any build problems, or for support when your system finally becomes one of
REM those dreaded "legacy systems".  Notice that the settings are displayed and
REM piped to the MAKE.OUT file.
REM ============================================================================
SET
SET >>MAKE.OUT




REM ============================================================================
REM This example builds a Windows-based program using the Microsoft Visual C/C++
REM version 1.5 compiler.  To keep things simple, the source files that we will
REM compile will be copied from the LARC source library into the release
REM library, NMAKE will be executed, then the sources will be removed from the
REM directory when the build completes.  While it may be possible to compile
REM straight from the source library, some compilers, like MSVC, put the object
REM files they create in the directory specified when with the source file name.
REM So, copying the sources into the release directory keeps the source library 
REM free of files that are not controlled by LARC.
REM 
REM Also, since you are likely to copy and check the files out of LARC into a
REM single local working directory, using this method allows you use a single
REM make file for your development work and for the LARC builds.
REM
REM Here you issue the commands necessary to copy the file from the LARC source
REM library.  You do not need to specify a destination directory because LARC
REM has already established the default to be the release directory.
REM
REM If you keep your sources in compressed libraries, you will need to issue
REM the PKUNZIP command instead of the DOS copy command.  If the example
REM sources were in a compressed library, you would use:
REM	
REM	PKUNZIP C:\LARCEMP\LARCEMP.ZIP
REM	IF ERRORLEVEL 1 GOTO ERR03
REM
REM If you really want to control things, you can copy each file individual,
REM then issue an "IF EXISTS" statement to ensure that it was successfully
REM copied.  However, this isn't really necessary because the compiler and linker
REM should complain if a file was missed.
REM ============================================================================
COPY %4\*.* *.* > NUL:




REM ============================================================================
REM Next a special C/C++ include file is created that contains some of the build
REM information provided by LARC.  "szVersion" contains the release identifier
REM that you entered which LARC passes in as the first argument to this build
REM command file.  "szBuildType" contains the type of build that you requested
REM which LARC passes in as the second argument to this build command file.
REM ============================================================================

ECHO>RELEASE.H //
ECHO>>RELEASE.H // LARC Example %1
ECHO>>RELEASE.H // Release Version Include File
ECHO>>RELEASE.H //
ECHO>>RELEASE.H     char    *szVersion = "%1";         // Current Version
ECHO>>RELEASE.H     char    *szBuildType = "%2";       // Build Type




REM ============================================================================
REM Now the actual build commands will be issued.
REM
REM This example uses the NMAKE utility provided with the Microsoft Visual 
REM C/C++ 1.5 to make the program.
REM ============================================================================

NMAKE -S -f LHELLO.MAK >>MAKE.OUT
IF ERRORLEVEL 1 GOTO ERR04




REM ============================================================================
REM Because NMAKE doesn't always return specific failure codes, we'll check for
REM the existence of the LHELLO.EXE.  For this to work, you will need to set
REM your compiler so that object modules are not created if errors are
REM encountered.  Likewise, set you linker so that executables are not produced
REM if errors are encountered.
REM ============================================================================
IF NOT EXIST LHELLO.EXE GOTO ERR05




REM ============================================================================
REM You might want to compress and save your *.MAP and *.OBJ files.  They might
REM come in handy in the future if a user encounters a problem that requires
REM you to do some low-level tracing.  Depending on the environment for which
REM you are developing, you may also want to save other files, such as debug
REM information files.
REM ============================================================================
PKZIP BLDSTUFF.ZIP *.MAP *.OBJ
IF ERRORLEVEL 1 GOTO ERR06



REM ============================================================================
REM Now get ride of any temporary build files that were created.  This step
REM is useful keeping you disk space usage to a minimum.  Notice that we delete
REM the copy of all of the files that were copied from the source library
REM because we don't need them on the system twice!
REM
REM If you are building more than one program and you keep your sources in
REM separate libraries, you might consider creating a CLEANUP.BAT file that
REM you can CALL after each build.
REM ============================================================================
IF EXIST *.ASM DEL *.ASM >NUL
IF EXIST *.BAT DEL *.BAT >NUL
IF EXIST *.BMP DEL *.BMP >NUL
IF EXIST *.C   DEL *.C   >NUL
IF EXIST *.CUR DEL *.CUR >NUL
IF EXIST *.CUT DEL *.CUT >NUL
IF EXIST *.CV  DEL *.CV  >NUL
IF EXIST *.DAT DEL *.DAT >NUL
IF EXIST *.DEF DEL *.DEF >NUL
IF EXIST *.DLG DEL *.DLG >NUL
IF EXIST *.FNC DEL *.FNC >NUL
IF EXIST *.H   DEL *.H   >NUL
IF EXIST *.HH  DEL *.HH  >NUL
IF EXIST *.ICO DEL *.ICO >NUL
IF EXIST *.LNK DEL *.LNK >NUL
IF EXIST *.MAK DEL *.MAK >NUL
IF EXIST *.MAP DEL *.MAP >NUL
IF EXIST *.NCV DEL *.NCV >NUL
IF EXIST *.OBJ DEL *.OBJ >NUL
IF EXIST *.P   DEL *.P   >NUL
IF EXIST *.PDB DEL *.PDB >NUL
IF EXIST *.RES DEL *.RES >NUL
IF EXIST *.RC  DEL *.RC  >NUL




REM ============================================================================
REM The second argument (%2) is tested.  If this is not a final ("*") build,
REM then you might want to create a test build backup.  You define the tool and
REM directory used for this backup.
REM
REM Note that final releases are always archived because LARC will automatically
REM execute the LARCARC.BAT command file if the build completes successfully.
REM ============================================================================

IF %2 == * GOTO SKIP-BACKUP

MD C:\LARCBACK > NUL:

ECHO.
ECHO Creating backup ZIP file...
ECHO>>MAKE.OUT Creating backup ZIP file...
PKZIP -ES -P -R -U C:\LARCBACK\%9.ZIP C:\LARCSRC\*.*

:SKIP-BACKUP




REM ============================================================================
REM It's a good idea to pipe the contents of this directory, plus any other
REM backup directories you created in the previous step, into the MAKE.OUT file.
REM Again, this listing might come in handy as you are initially creating and
REM debugging the build files.
REM ============================================================================

ECHO>>MAKE.OUT ==================== LISTING OF BACKUP DIRECTORY FILES ====================
DIR C:\LARCBACK\*.* >>MAKE.OUT

ECHO>>MAKE.OUT ==================== LIST OF RELEASE DIRECTORY FILES ====================
DIR *.* >>MAKE.OUT




REM ============================================================================
REM If we made it here, then the build completed sucessfully.  LARC expects
REM the BUILDFIN.CTL file to be created only if the build completes with no
REM (detectable) errors.  LARC also expects the BUILDFIN.CTL file to contain
REM the date, time, build type and release identifier.  You use the arguments
REM provided by LARC to create the file, then jump past the error labels to
REM the end of the file (i.e. "GOTO DONE").
REM ============================================================================
ECHO.>>MAKE.OUT
ECHO>>MAKE.OUT ==================== BUILD COMPLETED ====================
ECHO %6%7%2%1 >BUILDFIN.CTL

GOTO DONE




REM ============================================================================
REM Here is the start of the error message labels that you "GOTO" whenever a
REM build error is detected.  Make sure that you do not create the BUILDFIN.CTL
REM file if you jump to one of these error message labels.  If the BUILDFIN.CTL
REM file is NOT created, then LARC will not record the release identifier, and
REM will can resolve the problem and rebuild the release.
REM
REM You can be as elaborate with error messages as you like, but it is highly
REM recommended that you pipe them into a build progress (MAKE.OUT) file.
REM ============================================================================
:ERR00
ECHO.>>MAKE.OUT
ECHO>>MAKE.OUT *** Error: Failed to properly set environment string
GOTO TERMINATE

:ERR01
ECHO.>>MAKE.OUT
ECHO>>MAKE.OUT *** Error: Source file missing
GOTO TERMINATE

:ERR02
ECHO.>>MAKE.OUT
ECHO>>MAKE.OUT *** Error: LINK failed
GOTO TERMINATE

:ERR03
ECHO.>>MAKE.OUT
ECHO>>MAKE.OUT *** Error: Failed to unzip the source library
GOTO TERMINATE

:ERR04
ECHO.>>MAKE.OUT
ECHO>>MAKE.OUT *** Error: NMAKE failed
GOTO TERMINATE

:ERR05
ECHO.>>MAKE.OUT
ECHO>>MAKE.OUT *** Error: One (or more) components failed to build
GOTO TERMINATE

:ERR06
ECHO.>>MAKE.OUT
ECHO>>MAKE.OUT *** Error: File zip failed
GOTO TERMINATE

:TERMINATE
ECHO.>>MAKE.OUT
ECHO>>MAKE.OUT ******************************************************
ECHO>>MAKE.OUT ******************** BUILD FAILED ********************
ECHO>>MAKE.OUT ******************************************************




REM ============================================================================
REM Finally, we make it to the end of the build file.  Notice that the second
REM argument (the build type) is tested.  If this was a final build, then the
REM MAKE.OUT file will be printed.  It is recommended that the printed MAKE.OUT
REM files be stored along with the full build archives.
REM
REM If this was a test build, them the MAKE.OUT file will not be printed.  It is
REM assumed that many more test builds will be produced and it is not really
REM necessary to waste printer paper on test build results.  The MAKE.OUT file
REM can be always be inspected or manually printed if a test build error is
REM encountered.
REM ============================================================================
:DONE
IF %2 == * PRINT MAKE.OUT
