rem !/bin/csh -f  
rem 
rem  Test program for Wild-LIFE
rem 
rem 	test *.lf
rem    or
rem 	test program
rem 
rem  This program run Wild-LIFE over one or several test programs and records the
rem  differences in the standard and error outputs.
rem 
rem 
rem  Read-only files:
rem 	program.lf	Life source code
rem 	program.in	Life user input
rem 	program.ref	Reference standard output
rem 	program.referr	Reference error output
rem 
rem  Output files:
rem 	program.out	Most recent standard output
rem 	program.err	Most recent error output
rem 	program.refdiff Difference between .out and .ref files
rem 	program.errdiff Difference between .err and .referr files
rem 


rem  Make all files rw by everyone
umask 000


rem  Version of Wild-LIFE to use:
set WLIFE = "../Source/wild_life"


rem  clear
echo "Testing interpreter: $WLIFE"
echo "Date: `date`"
echo ""
rem  echo ""
rem  echo "                       Wild-LIFE test suite"
rem  echo "                       --------------------"
rem  echo ""
rem  echo "interpreter: $WLIFE"
rem  echo ""
rem  echo ""
rem  echo ""




rem  Run the test suite
foreach I ($*)

   echo $I

if(-e LF/$I:r.lf) then

rem  Remove any core dumps
   rm -f core

rem  Run Wild-LIFE
   (echo 'load("LF/' $I:r.lf '")?' | tr -d ' ' ;echo "" ; \
	cat IN/$I:r.in  ; echo "halt?") | \
	($WLIFE |  \
egrep -v '(Loading|already loaded|Version|customizing|Copyright|Garbage|Exiting|X interface)' > OUT/$I:r.out \
        ) |& \
        sed "s/.......s cpu (.*)//" > ERR/$I:r.err

rem  Check for core dump
   if(-e core) then
	echo "          ***    C O R E   D U M P  ! !       ***"
   endif

rem  Calculate the differences
   (diff OUT/$I:r.out REFOUT/$I:r.refout > REFDIFF/$I:r.refdiff) >& /dev/null
   (diff ERR/$I:r.err REFERR/$I:r.referr > ERRDIFF/$I:r.errdiff) >& /dev/null


rem  Report them to the developer
   if(`wc -c < REFDIFF/$I:r.refdiff` != 0) then
        echo "          *** output does not match reference ***"
   else
        rm -f REFDIFF/$I:r.refdiff
   endif

   if(`wc -c < ERRDIFF/$I:r.errdiff` != 0) then
	echo "          ***  errors do not match reference  ***"
   else
        rm -f ERRDIFF/$I:r.errdiff
   endif

else
   echo "          ***  no such test file  ***"
endif

end

echo ""
echo "Test finished: `date`"
echo ""
