/* LIBC example/testcase program */

#include <stdio.h>
#include <stdlib.h>

/* Watcom has two modes, e.g. -3s vs. -3r. The former resembles _System and is
   generally OK as long as the performance is not concerned. The latter is bit
   like _Optlink but it's essential to us that -3r disagrees with _Optlink
   about leading underscores. Therefore, when you compile with -3r, -4r or -5r,
   be sure to include the following patch (add new variables upon demand): */

#ifdef WATCOM_FIX
 #pragma aux stdin "*"
 #pragma aux stdout "*"
 #pragma aux stderr "*"
 #pragma aux stdaux "*"
 #pragma aux stdprn "*"
 #pragma aux _timezone "*"
 #pragma aux _daylight "*"
 #pragma aux errno "*"
#endif

/* Main routine */

int main(int argc, char **argv)
{
 float f=1.5;
 int rc;

 /* Note: if you are writing an interactive application, or an application that
    reports its progress to stdout, be sure to disable stdout/stderr buffering
    with XPG.4 libs: */
 setbuf(stdout, NULL);
 setbuf(stderr, NULL);
 if(argc<2)
 {
  printf("Usage: %s <n>\n"
         "Where: <n> = errorlevel to finish with\n", argv[0]);
  return(0);
 }
 rc=atoi(argv[1]);
 printf("You requested errorlevel %u\n", rc);
 f+=(float)rc;
 printf("Now, for a simple floating-point test: %u + 1.5 = %3.1f\n", rc, f);
 return(rc);
}
