#ifndef PARAM_HANDLER_H
#define PARAM_HANDLER_H

#include <LEDA/string.h>

// this class wraps all param passing within a main program
// we want:
// * a help message if argc == 1 or argc > pnummax
// * easy int and string access to the argv[i] (1 \le i < argc)
// * range checking for param access

class param_handler {
  int _argc;
  char** _argv;

public:
  param_handler(int argc, char** argv, string paramlist, 
                int minpar, int maxpar, string help = "")
  { if ((argc > maxpar+1) || (argc < minpar+1) ||
	(argc >= 2) && (string(argv[1])=="-h" || string(argv[1])=="-?")) {
      cerr << ("   usage: " + string(argv[0]) + " " + paramlist) << endl;
      cerr << ("  " + help) << endl;
      exit(1);
    }
    _argc = argc; _argv = argv; 
  }
  int num() { return _argc-1; }
  // return parameternumber without program name

  void set(int& p, int index) 
  { if (index < _argc) p = atoi(_argv[index]); }
  // this is for optional arguments which we only set 
  // if argc is big enough

  void set(string& p, int index)
  { if (index < _argc) p = string(_argv[index]); }
  // this is for optional arguments which we only set 
  // if argc is big enough



};

#endif // PARAM_HANDLER_H

