#ifndef P_HANDLE_H
#define P_HANDLE_H

#include <LEDA/handle_types.h>

template <class O> class p_handle;

template <class O>
class back_wrapper : public handle_rep {
  friend class p_handle<O>;
public:
  O _p;
  back_wrapper() : _p() {}
  back_wrapper(const O& s) : _p(s) {}
  ~back_wrapper() {}
};

/*{\Manpage {p_handle} {O} {A handle wrapper for objects} {p}}*/

/*{\Mdefinition An object |\Mvar| of type |\Mname| is a handle to an
object of type |O| which allows intelligent reference-to handling.
This type is also a model for the handle types |P_SITE|, |P_VNODE|
needed to adapt the framework above.}*/

template <class O>
class p_handle : public handle_base {
  back_wrapper<O>* ptr() const 
  { return (back_wrapper<O>*)PTR; }
public:
/*{\Mcreation p 3}*/

  p_handle() 
  { PTR = new back_wrapper<O>(); }

  p_handle(const O& s) 
  /*{\Mcreate creates a handle |\Mvar| to |s| of type |O|.}*/
  { PTR = new back_wrapper<O>(s); }

  p_handle(const p_handle<O>& q) : handle_base(q) {}
  ~p_handle() {}
  p_handle<O>& operator=(const p_handle<O>& t) 
  { handle_base::operator=(t); return *this; }

  /*{\Moperations 2 3}*/          

  O& operator*() { return ptr()->_p; }
  /*{\Munop returns the referenced object.}*/ 

  O& operator*() const { return ptr()->_p; }

  O* operator->() { return &(ptr()->_p); }
  O* operator->() const { return &(ptr()->_p); }

  bool operator==(const p_handle<O>& q) const
  { return identical(*this,q); }
  /*{\Mbinop returns true iff |\Mvar| and |q| reference the same object.}*/ 

  bool operator!=(const p_handle<O>& q) const
  /*{\Mbinop returns false iff |\Mvar| and |q| reference the same object.}*/ 
  { return !operator==(q); }

  friend ostream& operator<<(ostream& Out, const p_handle<O>& p)
  { Out << (*p) << ' '; return Out; }
  friend istream& operator>>(istream& In, const p_handle<O>& p)
  { return In; }
  friend void debug(const p_handle<O>& p)
  { ::debug(*p); }
  friend void debug_short(const p_handle<O>& p)
  { ::debug_short(*p); }
};

/*{\Mimplementation We use the standard \emph{handle-rep} scheme
of LEDA which is based on reference counting.}*/

#endif // P_HANDLE_H

