#ifndef ES_PLANE_EXT_H
#define ES_PLANE_EXT_H

#include <math.h>
#include <LEDA/plane.h>
#include <LEDA/rational.h>
#include <LEDA/rat_point.h>
#include <LEDA/rat_segment.h>
#include <LEDA/window.h>



extern int _STEPNR;
const static int ON     = 0;
const static int RIGHT  = -1;
const static int LEFT   =  1;
const static int IN     = -1;
const static int OUT    = 1;
const static int UNDEC  = -2;

#define sq(t) ((t)*(t))


point   perpendicular_base_point(const segment&, const point&);
point   rotate(const point&, double, double);
segment mid_perp_seg(const point&, const point&);
segment end_perp_seg(const point&, const point&);
void    move_seg(segment&, const point&);
void    invert_seg(segment&);


void      min_max(rational&,rational&);
void      invert_seg(rat_segment&);
rat_point perpendicular_base_point(const rat_segment&, const rat_point&);
rat_point other_end(const rat_segment&, const rat_point&);
bool      is_endpnt(const rat_point&, const rat_segment&);
bool      segments_intersect_internally(const rat_segment&, 
          const rat_segment&);
bool      collinear(const rat_segment&, const rat_point&);
bool      collinear(const rat_segment&, const rat_segment&);
bool      collinear_ordered(rat_point, rat_point, rat_point);
int       cmp_pnt_line_distance(const rat_point&, const rat_point&, 
          const rat_segment&);
int       cmp_seg_pnt_distance(const rat_segment&, const rat_segment&, 
          const rat_point&);
bool      endpnts_touch(const rat_segment& s1, const rat_segment& s2, 
          rat_point& tpnt);
void      orient_segs(const rat_segment&, const rat_segment&, int&, int&);

void    draw_parabola(const point&, const segment&, const segment&, 
        window&, color);

#endif


