//#ifndef LEDA_DEBUG_H
//#define LEDA_DEBUG_H

#include <LEDA/stream.h>

#undef TRACE
#undef TRACEN
#undef TRACEV
#undef CTRACE
#undef CTRACEN
#undef ASSERT

#ifdef _DEBUG
#define TRACE(t)   cerr << " " << t  
#else
#define TRACE(t) 
#endif

#ifdef _DEBUG
#define TRACEV(t)   cout << " " << #t << " = " << (t)  << endl
#else
#define TRACEV(t) 
#endif

#ifdef _DEBUG
#define TRACEN(t)   cerr << " " << t << "\n"
#else
#define TRACEN(t) 
#endif

#ifdef _DEBUG
#define CTRACE(b,t)  if(b) cerr << " " << t; else cerr << " 0"
#else
#define CTRACE(b,t) 
#endif

#ifdef _DEBUG
#define CTRACEN(b,t)  if(b) cerr << " " << t << "\n"; else cerr << " 0\n"
#else
#define CTRACEN(b,t) 
#endif

#ifndef _ASSERT
#define  ASSERT(cond,fstr) 
#else
#define ASSERT(cond,fstr)   \
  if (!(cond)) {       \
    cerr << "   ASSERT:   " << #fstr << endl; \
    cerr << "   COND:     " << #cond << endl; \
    cerr << "   POSITION: " << __FILE__ << " at line " << __LINE__ << endl; \
    abort();           \
  }
#endif


//#endif //LEDA_DEBUG_H


