
#include <LEDA/rat_polygon.h>
#include <LEDA/plane.h>
#include <LEDA/plane_alg.h>
#include <LEDA/window.h>
#include <LEDA/pixmaps/button32.h>

static window W(800,900,"LEDA Polygon Creation");

static list<rat_segment> SL;
static list<segment> OutS;
static polygon       OutP;

static color pcol = grey1;
static int grid_mode = 1;

static void A(int, list<point>&, int&, int&, int, int);
static void B(int, list<point>&, int&, int&, int, int);
static void C(int, list<point>&, int&, int&, int, int);
static void D(int, list<point>&, int&, int&, int, int);

static void A(int i, list<point>& L, int& x, int& y, int dx, int dy)
{ if (i > 0)
  { D(i-1,L,x,y,dx,dy); x-=dx; L.append(point(x,y));
    A(i-1,L,x,y,dx,dy); y-=dy; L.append(point(x,y));
    A(i-1,L,x,y,dx,dy); x+=dx; L.append(point(x,y));
    B(i-1,L,x,y,dx,dy);
  }
}

static void B(int i, list<point>& L, int& x, int& y, int dx, int dy)
{ if (i > 0)
  { C(i-1,L,x,y,dx,dy); y+=dy; L.append(point(x,y));
    B(i-1,L,x,y,dx,dy); x+=dx; L.append(point(x,y));
    B(i-1,L,x,y,dx,dy); y-=dy; L.append(point(x,y));
    A(i-1,L,x,y,dx,dy);
  }
}

static void C(int i, list<point>& L, int& x, int& y, int dx, int dy)
{ if (i > 0)
  { B(i-1,L,x,y,dx,dy); x+=dx; L.append(point(x,y));
    C(i-1,L,x,y,dx,dy); y+=dy; L.append(point(x,y));
    C(i-1,L,x,y,dx,dy); x-=dx; L.append(point(x,y));
    D(i-1,L,x,y,dx,dy);
  }
}

static void D(int i, list<point>& L, int& x, int& y, int dx, int dy)
{ if (i > 0)
  { A(i-1,L,x,y,dx,dy); y-=dy; L.append(point(x,y));
    D(i-1,L,x,y,dx,dy); x-=dx; L.append(point(x,y));
    D(i-1,L,x,y,dx,dy); y+=dy; L.append(point(x,y));
    C(i-1,L,x,y,dx,dy);
  }
}



list<point> hilbert(int n) 
{
  int x,y;
  int dx = 5;
  int dy = 5;
  x = y = 5*(1<<n);
  W.message("Computing Hilbert Curve");
  list<point> L;
  L.append(point(x+dx,y));
  L.append(point(x,y));
  A(n,L,x,y,dx,dy);
  L.append(point(x+dx,y));
  W.init(0,x+20,0);
  return L;
}


void gen_hilbert(int i)
{ 
  OutS.clear();
  list<point> L = hilbert(i);
  OutP = polygon(L);
}


void random_boxes(int n)
{ 
  int dx = int(1+(W.xmax() - W.xmin())/10);
  int dy = int(1+(W.ymax() - W.ymin())/10);

  int xmin = int(W.xmin()+dx);
  int xmax = int(W.xmax()-dx);
  int ymin = int(W.ymin()+dy);
  int ymax = int(W.ymax()-dy);

  while (n--) {
    W.del_messages();
    W.message(string(" %3d",n));
    int x1 = rand_int(xmin,xmax);
    int y1 = rand_int(ymin,ymax);
    int x2 = rand_int(xmin,xmax);
    int y2 = rand_int(ymin,ymax);
    SL.append(rat_segment(x1,y1,x1,y2));
    SL.append(rat_segment(x1,y2,x2,y2));
    SL.append(rat_segment(x2,y2,x2,y1));
    SL.append(rat_segment(x2,y1,x1,y1));
  }
  W.set_mode(src_mode);
  W.del_messages();
}

void gen_boxes(int i)
{ 
  W.clear();
  SL.clear();
  OutP=polygon();
  OutS.clear();
  random_boxes(i);
  GRAPH<rat_point,rat_segment> G;
  SWEEP_SEGMENTS(SL,G);
  edge e;
  forall_edges(e,G)
    OutS.append(segment(G[G.source(e)].to_point(),
                        G[G.target(e)].to_point()));
}

void redraw(window* wp)
{ 
  W.clear();
  segment s;
  forall(s,OutS)
    (*wp) << s;
  (*wp) << OutP;
}


int main()
{ 
  int max_c = 1000;

  pcol = W.mono() ? white : grey1;

  menu hilbert_menu;
  hilbert_menu.button("hilbert(2) ",2,gen_hilbert);
  hilbert_menu.button("hilbert(3) ",3,gen_hilbert);
  hilbert_menu.button("hilbert(4) ",4,gen_hilbert);
  hilbert_menu.button("hilbert(5) ",5,gen_hilbert);
  hilbert_menu.button("hilbert(6) ",6,gen_hilbert);

  menu random_menu;
  random_menu.button("5 boxes",5,gen_boxes);
  random_menu.button("12 boxes",12,gen_boxes);
  random_menu.button("25 boxes",25,gen_boxes);
  random_menu.button("50 boxes",50,gen_boxes);
  random_menu.button("100 boxes",100,gen_boxes);


  char* hilb_pr  = W.create_pixrect(maze_xpm);
  char* rand_pr  = W.create_pixrect(blocks_xpm);
  char* exit_pr  = W.create_pixrect(door_exit_xpm);

  enum { HILBB=100, RANDB, HELPB, EXITB };
  W.button(hilb_pr,  hilb_pr,  "hilbert polygons", HILBB, hilbert_menu);  
  W.button(rand_pr,  rand_pr,  "random boxes", RANDB, random_menu);
  W.button(exit_pr,  exit_pr,  "exit", EXITB);
  W.set_redraw(redraw);
  W.set_node_width(2);
  W.set_show_coordinates(true);
  W.init(0,max_c,0,grid_mode);
  W.display(window::center,window::center);
  W.open_status_window();
  W.message("This program creates input for the AVD program.");
  W.message("You can generate a Hilbert polygon via the first button");
  W.message("You can generate random boxes via the second button.");
  W.message("The input for esvd is written to the standard output.");

  bool loop = true;
  while (loop) {
    int but = W.read_mouse();
    redraw(&W);
    if (but == MOUSE_BUTTON(3) || but == EXITB) 
      break;
  }

  if (OutS.size() > 0) {
    int j=5;
    segment s;
    cout << "site ";
    forall (s,OutS) {
      j--;
      if (j == 0) {
        j = 5;
        cout << "\nsite ";
      }
      cout << s.source() << s.target();
    }
    cout << endl;
  } else {
    point v;
    cout << "poly ";
    forall(v,OutP.vertices())
      cout << v;
    cout << endl;
  }
  return 0;

}
