
#include <LEP/avd/expcomp.h>
#include <LEP/avd/debug.h>
#include <LEP/avd/es_adaptation.h>

// we first specialize the following symbols
#define site    es_site
#define vnode   es_vnode
#define p_site  p_handle<es_site>
#define p_vnode p_handle<es_vnode>


//#define _DEBUG
//#define _DEBUG_LOW
//#define _ASSERTS
//#define _DEBUG_DRAW

#ifdef _DEBUG_LOW
#define LTRACE(t) cerr << "     " << (t)
#else
#define LTRACE(t) 
#endif

#ifdef _DEBUG_LOW
#define LTRACEN(t) cerr << "     " << (t) << "\n"
#else
#define LTRACEN(t) 
#endif

int site::count = 0; // -1


inline void seg2line_paras(const rat_segment& s, 
            real& a, real& b, real& c)
{
    ASSERT((s.W1()==1),seg2line_paras);
    ASSERT((s.W2()==1),seg2line_paras);

  a = s.Y1() - s.Y2();
  b = s.X2() - s.X1();
  c = s.X1()*s.Y2() - s.X2()*s.Y1();
}

inline void seg2line_paras(const rat_segment& s, 
            integer& a, integer& b, integer& c)
{
    ASSERT((s.W1()==1),seg2line_paras);
    ASSERT((s.W2()==1),seg2line_paras);

  a = s.Y1() - s.Y2();
  b = s.X2() - s.X1();
  c = s.X1()*s.Y2() - s.X2()*s.Y1();
}


inline int sorted_switch_label_b2(bool b1, bool b2)
{
  int res = 0;
  if (b2) res += 1;
  if (b1) res += 2;
  return res;
}

inline int sorted_switch_label_b3(bool b1, bool b2, bool b3)
{
  int res = 0;
  if (b3) res += 1;
  if (b2) res += 2;
  if (b1) res += 4;
  return res;
}

inline int sorted_switch_label_i23(int i1, int i2)
{ return i1*3+i2; }



site::site(const rat_point& P_init, bool inc)
{
  t = PNT;
  s = rat_segment(P_init,P_init);
  if (inc)
    n = ++count;
  else
    n = -count;
}

site::site(const rat_segment& s_init)
{ 
  if (s_init.start() == s_init.end())
    t = PNT;
  else
    t = SEG;
  s = s_init;
  n = ++count;
}

site::site(integer x, integer y)
{
  t = PNT;
  s = rat_segment(x,y,x,y);
  n = ++count;
}

site::site(integer x0, integer y0, integer x1, integer y1)
{ 
  if (x0 == x1 && y0 == y1)
    t = PNT;
  else
    t = SEG;
  s = rat_segment(x0,y0,x1,y1);
  n = ++count;
}

site::site(const site& s_init)
{
  t = s_init.t;
  s = s_init.s;
  n = s_init.n;
}

site  site::operator= (const site& so)
{
  t = so.t;
  s = so.s;
  n = so.n;  
  return *this;
}

void  site::draw(window& W, color c)
{
#ifdef _DEBUG_DRAW
  W.set_node_width(10);
  if (t == PNT)
    W.draw_int_node(rpnt2pnt(s.start()),n);
  else // t == SEG
  {
    W.draw_segment(rseg2seg(s),c);
    point S((s.start().xcoordD()+s.end().xcoordD())/2.0,
             (s.start().ycoordD()+s.end().ycoordD())/2.0);
    W.draw_int_node(S,n);
  }
#else
  if (t == PNT) {
    W.set_node_width(4);
    W.draw_filled_node(pnt(),c);
  } else {// t == SEG
    W.set_line_width(3);
    W.draw_segment(seg(),c);
    W.set_line_width(1);
  }
#endif
}

bool  operator==(const site& s1, const site& s2)
{
  if (s1.type() != s2.type()) return false;
  return (s1.s == s2.s);
}

bool  operator!=(const site& s1, const site& s2)
{
  return !(s1 == s2);
}

ostream&  operator<<(ostream& out, const site& p)
{
  if (p.nr() == INFNUM)
    out << " infinity"; 
  else if (p.is_pnt())
    out << " pnt #" << p.nr() << " " << p.pnt();
  else // p.is_seg()
    out << " seg #" << p.nr() << " " << p.seg();
  return out;
}


vnode::vnode(p_site p, p_site q, p_site r)
{
  // this is only called in the context that |pqr| exists
  // now |p,q,r != \infty| which means either pnt or seg:
  RealOk=DblOk=IntOk=rat=false;

  switch(sorted_switch_label_b3((*p).is_seg(),(*q).is_seg(),(*r).is_seg())) {
    case ttt_label:
        csites[0]=p; csites[1]=q; csites[2]=r;
        PreCompSSS();
        break;
    case ttf_label:
        csites[0]=p; csites[1]=q; csites[2]=r;
        PreCompSSP();
        break;
    case tft_label:
        csites[0]=r; csites[1]=p; csites[2]=q;
        PreCompSSP();
        break;
    case tff_label:
        csites[0]=p; csites[1]=q; csites[2]=r;
        PreCompSPP();
        break;
    case ftt_label:
        csites[0]=q; csites[1]=r; csites[2]=p;
        PreCompSSP();
        break;
    case ftf_label:
        csites[0]=q; csites[1]=r; csites[2]=p;
        PreCompSPP();
        break;
    case fft_label:
        csites[0]=r; csites[1]=p; csites[2]=q;
        PreCompSPP();
        break;
    case fff_label:
        csites[0]=p; csites[1]=q; csites[2]=r;
        t=PPP;
        break;
  }
  LTRACE("es_vnode construction");
  LTRACE(nt());LTRACE(csite(0));LTRACE(csite(1));LTRACEN(csite(2));
}

vnode::vnode(real xr, real yr, real wr, bool i) 
{
  xCoord=xr;
  yCoord=yr;
  wCoord=wr;  
  RealOk=true;
  error_handler(0,"am I ever called?");
}

vnode::vnode(const vnode& vn)
{
  xCoord = vn.xCoord;
  yCoord = vn.yCoord;
  wCoord = vn.wCoord;

  xCoordI = vn.xCoordI;
  yCoordI = vn.yCoordI;
  wCoordI = vn.wCoordI;

  xCoordD = vn.xCoordD;
  yCoordD = vn.yCoordD;
  wCoordD = vn.wCoordD;

  xCoordDS = vn.xCoordDS;
  yCoordDS = vn.yCoordDS;
  wCoordDS = vn.wCoordDS;

  csites[0] = vn.csites[0];
  csites[1] = vn.csites[1];
  csites[2] = vn.csites[2];
  t = vn.t;
  rat = vn.rat;

  RealOk=vn.RealOk;
  DblOk=vn.DblOk;
  IntOk=vn.IntOk;
}

vnode vnode::operator=(const vnode& vn)
{
  xCoord = vn.xCoord;
  yCoord = vn.yCoord;
  wCoord = vn.wCoord;

  xCoordI = vn.xCoordI;
  yCoordI = vn.yCoordI;
  wCoordI = vn.wCoordI;

  xCoordD = vn.xCoordD;
  yCoordD = vn.yCoordD;
  wCoordD = vn.wCoordD;

  xCoordDS = vn.xCoordDS;
  yCoordDS = vn.yCoordDS;
  wCoordDS = vn.wCoordDS;

  csites[0] = vn.csites[0];
  csites[1] = vn.csites[1];
  csites[2] = vn.csites[2];
  t = vn.t;
  rat = vn.rat;

  RealOk=vn.RealOk;
  DblOk=vn.DblOk;
  IntOk=vn.IntOk;

  return *this;
}

bool vnode::operator==(const vnode& vn)
{
  return ((x()*vn.w() == vn.x()*w()) && (y()*vn.w() == vn.y()*w()));
}

ostream&  operator<<(ostream& out, const vnode& vn)
{
  out << "<";
  out << vn.csite(0) << ",";
  out << vn.csite(1) << ",";
  out << vn.csite(2);
  out << "> = ";
  out << "(" << vn.xd() << "," << vn.yd() << ")";
  return out;
}




void vnode::PreCompSSS()
{
  rat_segment l1=csite(0).rseg();
  rat_segment l2=csite(1).rseg();
  rat_segment l3=csite(2).rseg();
    LTRACE("sss_coords: ");LTRACE(l1);LTRACE(l2);LTRACEN(l3);

  rat_point tpnt12, tpnt13, tpnt23;
  bool touch12 = endpnts_touch(l1,l2,tpnt12);
  bool touch13 = endpnts_touch(l1,l3,tpnt13);
  bool touch23 = endpnts_touch(l2,l3,tpnt23);
  // provides information about common endpoints

  
  /* All segments might touch in one point.  This piece of code checks
     the special case 3 of the above list. As we calculated touch
     conditions and touch points for the three segments this is
     easy. Note that here the node is rational.  */
  if (touch12 && touch13 && (tpnt12 == tpnt13))
  {
      LTRACEN("  all segments touch in one point");
    xCoordI=tpnt12.X();
    yCoordI=tpnt12.Y();
    wCoordI=tpnt12.W();
    if (sign(wCoordI)<0)
    {
      xCoordI=-xCoordI;
      yCoordI=-yCoordI;
      wCoordI=-wCoordI;
    }
    xCoord=xCoordI; 
    yCoord=yCoordI; 
    wCoord=wCoordI;
    xCoordD=xCoordI.to_double(); 
    yCoordD=yCoordI.to_double(); 
    wCoordD=wCoordI.to_double();
    xCoordDS=(abs(xCoordI)).to_double();
    yCoordDS=(abs(yCoordI)).to_double();
    wCoordDS=(abs(wCoordI)).to_double();
    t=SSS_alltouch;
    DblOk=IntOk=RealOk=true;
    rat=true;
    return;
  }


  int l1_rel_l2, l1_rel_l3, l2_rel_l1, l2_rel_l3, l3_rel_l1, l3_rel_l2;
  orient_segs(l1,l2,l1_rel_l2,l2_rel_l1);
  orient_segs(l1,l3,l1_rel_l3,l3_rel_l1);
  orient_segs(l2,l3,l2_rel_l3,l3_rel_l2);
    
  if ((l1_rel_l2 == ON) || (l2_rel_l3 == ON) || (l1_rel_l3 == ON) )
    t=SSS_coltouch; // sss_coords - two segments are collinearly touching
  else
    t=SSS_interior; // sss_coords - node is implied by interior touching points
}



void vnode::PreCompSSP()
{
  rat_segment l1=csite(0).rseg();
  rat_segment l2=csite(1).rseg();
  rat_point   P =csite(2).rpnt();
    LTRACE("ssp_coords: ");LTRACE(l1);LTRACE(l2);LTRACEN(P);

  bool p_is_l1_endpnt = (P == l1.start() || P == l1.end());
  bool p_is_l2_endpnt = (P == l2.start() || P == l2.end());
  
  if (p_is_l1_endpnt && p_is_l2_endpnt) {
    // ssp_coords P is common endpoint
    integer xp = P.X(),
            yp = P.Y(),
            zp = P.W(); // initializes the homogenous coords of P

    if (sign(zp)<0)
    {
      xp=-xp;
      yp=-yp;
      zp=-zp;
    }
    xCoordI=xp; 
    yCoordI=yp; 
    wCoordI=zp;
    xCoord=xCoordI; 
    yCoord=yCoordI; 
    wCoord=wCoordI;
    xCoordD=xCoordI.to_double(); 
    yCoordD=yCoordI.to_double(); 
    wCoordD=wCoordI.to_double();
    xCoordDS=(abs(xCoordI)).to_double();
    yCoordDS=(abs(yCoordI)).to_double();
    wCoordDS=(abs(wCoordI)).to_double();
    t=SSP_alltouch;
    DblOk=IntOk=RealOk=true;
    rat=true;
  }

  else
  {
    integer a1,b1,c1,a2,b2,c2;
    int l1_p_or = orientation(l1,P);
    int l2_p_or = orientation(l2,P);

    if (l1_p_or == RIGHT)
      invert_seg(l1);
    if (l2_p_or == RIGHT)
      invert_seg(l2);

    integer dx1 = l1.dx();
    integer dy1 = l1.dy();
    integer dx2 = l2.dx();
    integer dy2 = l2.dy();
    

    if (l1_p_or == ON)
    {
      if (dx1*dy2 == dx2*dy1 && 
          sign(dx1) == sign(dx2) && sign (dy1) == sign(dy2) ||
          P == l1.start())
        // l1 and l2 are parallel and equally directed or
        // l1 and l2 are not parallel and the node is on the right
        invert_seg(l1);
    }
    if (l2_p_or == ON)
    {
      if (dx1*dy2 == dx2*dy1 && 
          sign(dx1) == sign(dx2) && sign(dy1) == sign(dy2) ||
          P == l2.end())
        invert_seg(l2);
    }
  
    seg2line_paras(l1,a1,b1,c1); // initializes the homogenous coords of l1
    seg2line_paras(l2,a2,b2,c2); // initializes the homogenous coords of l2

    if (((a1*b2-a2*b1)!=0) || ((a1*c2-a2*c1)!=0) || ((b1*c2-b2*c1)!=0))
      t=SSP_notcoll;  // ssp_coords with different segment support lines
    else 
      t=SSP_coltouch; // ssp_coords with one segment support line: l1 == l2
  }
}


void vnode::PreCompSPP()
{
  rat_segment l=csite(0).rseg();
  rat_point   P=csite(1).rpnt();
  rat_point   Q=csite(2).rpnt();

    LTRACE("spp_coords: ");LTRACE(l);LTRACE(P);LTRACEN(Q);
    ASSERT((orientation(l,P)!=-orientation(l,Q)),spp_coords);

  if (right_turn(l.start(),l.end(),P))
    invert_seg(l);
    // care for the right orientation of l

  integer a,b,c;
  seg2line_paras(l,a,b,c);     // initializes the homogenous coords of l
  // first we again translate the configuration according to the
  // translation of P into the origin (0,0,1)
  // the translated coordinates are marked by doubled dir characters

  int sign_res;
  // ******** Begin Expression Compiler Output
// **** Local Variables:
//		aa
//		bb
//		res
//		wp
//		wq
//		xp
//		xq
//		xxq
//		yp
//		yq
//		yyq
// **** External Variables:
//		P.W()
//		P.X()
//		P.Y()
//		Q.W()
//		Q.X()
//		Q.Y()
//		a
//		b
// **** Sign Result Variables:
//		sign_res

{
	// ****** Double evaluation
double P_W___g_val = P.WD();
double P_W___g_sup = float_abs(P_W___g_val);
double P_X___g_val = P.XD();
double P_X___g_sup = float_abs(P_X___g_val);
double P_Y___g_val = P.YD();
double P_Y___g_sup = float_abs(P_Y___g_val);
double Q_W___g_val = Q.WD();
double Q_W___g_sup = float_abs(Q_W___g_val);
double Q_X___g_val = Q.XD();
double Q_X___g_sup = float_abs(Q_X___g_val);
double Q_Y___g_val = Q.YD();
double Q_Y___g_sup = float_abs(Q_Y___g_val);
double a_g_val = a.to_double();
double a_g_sup = float_abs(a_g_val);
double b_g_val = b.to_double();
double b_g_sup = float_abs(b_g_val);




	// ******************* New Declaration
	double xp_val;
	double xp_sup;

	xp_val = P_X___g_val;
	xp_sup = P_X___g_sup;

	// ******************* New Declaration
	double yp_val;
	double yp_sup;

	yp_val = P_Y___g_val;
	yp_sup = P_Y___g_sup;

	// ******************* New Declaration
	double wp_val;
	double wp_sup;

	wp_val = P_W___g_val;
	wp_sup = P_W___g_sup;

	// ******************* New Declaration
	double xq_val;
	double xq_sup;

	xq_val = Q_X___g_val;
	xq_sup = Q_X___g_sup;

	// ******************* New Declaration
	double yq_val;
	double yq_sup;

	yq_val = Q_Y___g_val;
	yq_sup = Q_Y___g_sup;

	// ******************* New Declaration
	double wq_val;
	double wq_sup;

	wq_val = Q_W___g_val;
	wq_sup = Q_W___g_sup;

	// ******************* New Declaration
	double xxq_val;
	double xxq_sup;

	double tmp_8_val = xq_val*wp_val;
	double tmp_8_sup = xq_sup*wp_sup;

	double tmp_11_val = xp_val*wq_val;
	double tmp_11_sup = xp_sup*wq_sup;

	double tmp_12_val = tmp_8_val-tmp_11_val;
	double tmp_12_sup = tmp_8_sup+tmp_11_sup;

	xxq_val = tmp_12_val;
	xxq_sup = tmp_12_sup;

	// ******************* New Declaration
	double yyq_val;
	double yyq_sup;

	double tmp_15_val = yq_val*wp_val;
	double tmp_15_sup = yq_sup*wp_sup;

	double tmp_18_val = yp_val*wq_val;
	double tmp_18_sup = yp_sup*wq_sup;

	double tmp_19_val = tmp_15_val-tmp_18_val;
	double tmp_19_sup = tmp_15_sup+tmp_18_sup;

	yyq_val = tmp_19_val;
	yyq_sup = tmp_19_sup;

	// ******************* New Declaration
	double aa_val;
	double aa_sup;

	double tmp_22_val = a_g_val*wp_val;
	double tmp_22_sup = a_g_sup*wp_sup;

	aa_val = tmp_22_val;
	aa_sup = tmp_22_sup;

	// ******************* New Declaration
	double bb_val;
	double bb_sup;

	double tmp_25_val = b_g_val*wp_val;
	double tmp_25_sup = b_g_sup*wp_sup;

	bb_val = tmp_25_val;
	bb_sup = tmp_25_sup;

	// ******************* New Declaration
	double res_val;
	double res_sup;

	double tmp_28_val = aa_val*xxq_val;
	double tmp_28_sup = aa_sup*xxq_sup;

	double tmp_31_val = bb_val*yyq_val;
	double tmp_31_sup = bb_sup*yyq_sup;

	double tmp_32_val = tmp_28_val+tmp_31_val;
	double tmp_32_sup = tmp_28_sup+tmp_31_sup;

	res_val = tmp_32_val;
	res_sup = tmp_32_sup;

	// ***************** Sign Statement
	// ******* BitLength of Expression is 0
	// ******* Index of Expression is 9
	{
	  static double _upper=9*eps1;
	  if ( float_abs(res_val) > res_sup*_upper*correction )
		sign_res = float_sign(res_val);
	  else if ( res_sup*_upper*correction<1)
		sign_res = 0;
	  else
		sign_res = NO_IDEA;
	}
}
if ((sign_res==NO_IDEA) || FALSE )
	// ***** Exact Evaluation
	{
	integer xp = P.X();
	integer yp = P.Y();
	integer wp = P.W();
	integer xq = Q.X();
	integer yq = Q.Y();
	integer wq = Q.W();
	integer xxq = ((xq*wp)-(xp*wq));
	integer yyq = ((yq*wp)-(yp*wq));
	integer aa = (a*wp);
	integer bb = (b*wp);
	integer res = ((aa*xxq)+(bb*yyq));
	sign_res = sign(res);
	}
// ******** End Expression Compiler Output


  // According to C.Burnikel we have to examine two cases here
  // ((aa*xxq + bb*yyq)!=0) ?
  if (sign_res !=0 )
    t=SPP_distdiff; // spp_coords with different distances of P and Q to l
  else
    t=SPP_disteq;   // spp_coords with equal distance of P and Q to l
}



void vnode::CompDbl()
{
    LTRACE("CompDbl "); 
    if (DblOk) cout<<"DblOk is true"<<endl;

  switch(t) {
    case(SSS_coltouch): SSS_coltouch_Double(); break;
    case(SSS_interior): SSS_interior_Double(); break;
    case(SSP_notcoll):  SSP_notcoll_Double();  break;
    case(SSP_coltouch): SSP_coltouch_Double(); break;
    case(SPP_distdiff): SPP_distdiff_Double(); break;
    case(SPP_disteq):   SPP_disteq_Double();   break;
    case(PPP):          PPP_Double();          break;
    default: error_handler(1,"CompDbl: reached illegal default switch."); break;
  }

  DblOk=true;

  if (float_abs(wCoordD) <= wCoordDS*22*eps1) {
    /* if sign of wCoordD is unsure, invalidate floating-point approximations) */
    xCoordDS=pInf_double;
    yCoordDS=pInf_double;
    wCoordDS=pInf_double;
  }
  else if (sign(wCoordD)<0) {
    xCoordD=-xCoordD;
    yCoordD=-yCoordD;
    wCoordD=-wCoordD;
  }
}


void vnode::CompInt()
{
    LTRACE("CompInt"); LTRACEN(*this);
    ASSERT(!rat, "Error SPP not rational");

  switch(t) {
    case(SSS_coltouch):  rat=SSS_coltouch_Integer(); break;
    case(SSS_interior):  rat=SSS_interior_Integer(); break;
    case(SSP_notcoll):   rat=SSP_notcoll_Integer();  break;
    case(SSP_coltouch):  rat=SSP_coltouch_Integer(); break;
    case(SPP_distdiff):  rat=SPP_distdiff_Integer(); break;
    case(SPP_disteq):    rat=SPP_disteq_Integer();   break;
    case(PPP):           rat=PPP_Integer();          break;
    default: error_handler(1,"CompInteger: reached illegal default switch."); break;
  }

  if (sign(wCoordI)<0) {
    xCoordI=-xCoordI;
    yCoordI=-yCoordI;
    wCoordI=-wCoordI;
  }

  IntOk=true;
  if (rat==true) {
    xCoord=xCoordI; 
    yCoord=yCoordI; 
    wCoord=wCoordI;
    xCoordD=xCoordI.to_double(); 
    yCoordD=yCoordI.to_double(); 
    wCoordD=wCoordI.to_double();
    xCoordDS=(abs(xCoordI)).to_double(); 
    yCoordDS=(abs(yCoordI)).to_double(); 
    wCoordDS=(abs(wCoordI)).to_double();
    DblOk=RealOk=true;
  }
}


void vnode::CompReal()
{
    LTRACE("CompReal ");LTRACEN(*this);

  switch(t) {
    case(SSS_coltouch):  SSS_coltouch_Exact(); break;
    case(SSS_interior):  SSS_interior_Exact(); break;
    case(SSP_notcoll):   SSP_notcoll_Exact();  break;
    case(SSP_coltouch):  SSP_coltouch_Exact(); break;
    case(SPP_distdiff):  SPP_distdiff_Exact(); break;
    case(SPP_disteq):    SPP_disteq_Exact();   break;
    case(PPP):           PPP_Exact();          break;
    default: error_handler(1,"CompReal: reached illegal default switch."); break;
  }

  if (sign(wCoord)<0) {
    xCoord=-xCoord;
    yCoord=-yCoord;
    wCoord=-wCoord;
  }
  xCoordD=xCoord.to_double(); 
  yCoordD=yCoord.to_double(); 
  wCoordD=wCoord.to_double();
  xCoordDS=ceil(fabs(xCoord.to_double())*
                ((xCoord.get_double_error()+eps)/eps));
  yCoordDS=ceil(fabs(yCoord.to_double())*
                ((yCoord.get_double_error()+eps)/eps));
  wCoordDS=ceil(fabs(wCoord.to_double())*
                ((wCoord.get_double_error()+eps)/eps));
  RealOk=DblOk=true;
}



int vnode::PPP_Exact()
// **** Local Variables:
//		wpi
//		wqi
//		wri
//		xpi
//		xqi
//		xri
//		ypi
//		yqi
//		yri
// **** External Variables:
//		P.W()
//		P.X()
//		P.Y()
//		Q.W()
//		Q.X()
//		Q.Y()
//		R.W()
//		R.X()
//		R.Y()
// **** Sign Result Variables:

{


  rat_point P=csite(0).rpnt();
  rat_point Q=csite(1).rpnt();
  rat_point R=csite(2).rpnt();


	{
	real xpi = P.X();
	real ypi = P.Y();
	real wpi = P.W();
	real xqi = Q.X();
	real yqi = Q.Y();
	real wqi = Q.W();
	real xri = R.X();
	real yri = R.Y();
	real wri = R.W();
	xCoord = (((((wqi*wri)*(sq(xpi)+sq(ypi)))*((yqi*wri)-(yri*wqi)))+(((wpi*wri)*(sq(xqi)+sq(yqi)))*((yri*wpi)-(ypi*wri))))+(((wpi*wqi)*(sq(xri)+sq(yri)))*((ypi*wqi)-(yqi*wpi))));
	yCoord = -((((((wqi*wri)*(sq(xpi)+sq(ypi)))*((xqi*wri)-(xri*wqi)))+(((wpi*wri)*(sq(xqi)+sq(yqi)))*((xri*wpi)-(xpi*wri))))+(((wpi*wqi)*(sq(xri)+sq(yri)))*((xpi*wqi)-(xqi*wpi)))));
	wCoord = ((((2*wpi)*wqi)*wri)*(((wpi*((xqi*yri)-(xri*yqi)))+(wqi*((xri*ypi)-(xpi*yri))))+(wri*((xpi*yqi)-(xqi*ypi)))));
	}


return TRUE;
}

int vnode::PPP_Integer()
// **** Local Variables:
//		wpi
//		wqi
//		wri
//		xpi
//		xqi
//		xri
//		ypi
//		yqi
//		yri
// **** External Variables:
//		P.W()
//		P.X()
//		P.Y()
//		Q.W()
//		Q.X()
//		Q.Y()
//		R.W()
//		R.X()
//		R.Y()
// **** Sign Result Variables:

{
	int _valid=TRUE;
	 if (!(1))
		_valid=FALSE;



  rat_point P=csite(0).rpnt();
  rat_point Q=csite(1).rpnt();
  rat_point R=csite(2).rpnt();


	{
integer P_W___g_val = P.W();
integer P_X___g_val = P.X();
integer P_Y___g_val = P.Y();
integer Q_W___g_val = Q.W();
integer Q_X___g_val = Q.X();
integer Q_Y___g_val = Q.Y();
integer R_W___g_val = R.W();
integer R_X___g_val = R.X();
integer R_Y___g_val = R.Y();




	// ******************* New Declaration
	integer xpi_val;

	if (_valid==TRUE)
	{
		xpi_val = P_X___g_val;
	}

	// ******************* New Declaration
	integer ypi_val;

	if (_valid==TRUE)
	{
		ypi_val = P_Y___g_val;
	}

	// ******************* New Declaration
	integer wpi_val;

	if (_valid==TRUE)
	{
		wpi_val = P_W___g_val;
	}

	// ******************* New Declaration
	integer xqi_val;

	if (_valid==TRUE)
	{
		xqi_val = Q_X___g_val;
	}

	// ******************* New Declaration
	integer yqi_val;

	if (_valid==TRUE)
	{
		yqi_val = Q_Y___g_val;
	}

	// ******************* New Declaration
	integer wqi_val;

	if (_valid==TRUE)
	{
		wqi_val = Q_W___g_val;
	}

	// ******************* New Declaration
	integer xri_val;

	if (_valid==TRUE)
	{
		xri_val = R_X___g_val;
	}

	// ******************* New Declaration
	integer yri_val;

	if (_valid==TRUE)
	{
		yri_val = R_Y___g_val;
	}

	// ******************* New Declaration
	integer wri_val;

	if (_valid==TRUE)
	{
		wri_val = R_W___g_val;
	}

	// ********************* New Assignment
	if (_valid==TRUE)
	{
	integer tmp_46_val = wqi_val*wri_val;

	integer tmp_48_val=xpi_val*xpi_val;
	integer tmp_50_val=ypi_val*ypi_val;
	integer tmp_51_val = tmp_48_val+tmp_50_val;

	integer tmp_52_val = tmp_46_val*tmp_51_val;

	integer tmp_55_val = yqi_val*wri_val;

	integer tmp_58_val = yri_val*wqi_val;

	integer tmp_59_val = tmp_55_val-tmp_58_val;

	integer tmp_60_val = tmp_52_val*tmp_59_val;

	integer tmp_63_val = wpi_val*wri_val;

	integer tmp_65_val=xqi_val*xqi_val;
	integer tmp_67_val=yqi_val*yqi_val;
	integer tmp_68_val = tmp_65_val+tmp_67_val;

	integer tmp_69_val = tmp_63_val*tmp_68_val;

	integer tmp_72_val = yri_val*wpi_val;

	integer tmp_75_val = ypi_val*wri_val;

	integer tmp_76_val = tmp_72_val-tmp_75_val;

	integer tmp_77_val = tmp_69_val*tmp_76_val;

	integer tmp_78_val = tmp_60_val+tmp_77_val;

	integer tmp_81_val = wpi_val*wqi_val;

	integer tmp_83_val=xri_val*xri_val;
	integer tmp_85_val=yri_val*yri_val;
	integer tmp_86_val = tmp_83_val+tmp_85_val;

	integer tmp_87_val = tmp_81_val*tmp_86_val;

	integer tmp_90_val = ypi_val*wqi_val;

	integer tmp_93_val = yqi_val*wpi_val;

	integer tmp_94_val = tmp_90_val-tmp_93_val;

	integer tmp_95_val = tmp_87_val*tmp_94_val;

	integer tmp_96_val = tmp_78_val+tmp_95_val;

	xCoordI = tmp_96_val;
	}

	// ********************* New Assignment
	if (_valid==TRUE)
	{
	integer tmp_99_val = wqi_val*wri_val;

	integer tmp_101_val=xpi_val*xpi_val;
	integer tmp_103_val=ypi_val*ypi_val;
	integer tmp_104_val = tmp_101_val+tmp_103_val;

	integer tmp_105_val = tmp_99_val*tmp_104_val;

	integer tmp_108_val = xqi_val*wri_val;

	integer tmp_111_val = xri_val*wqi_val;

	integer tmp_112_val = tmp_108_val-tmp_111_val;

	integer tmp_113_val = tmp_105_val*tmp_112_val;

	integer tmp_116_val = wpi_val*wri_val;

	integer tmp_118_val=xqi_val*xqi_val;
	integer tmp_120_val=yqi_val*yqi_val;
	integer tmp_121_val = tmp_118_val+tmp_120_val;

	integer tmp_122_val = tmp_116_val*tmp_121_val;

	integer tmp_125_val = xri_val*wpi_val;

	integer tmp_128_val = xpi_val*wri_val;

	integer tmp_129_val = tmp_125_val-tmp_128_val;

	integer tmp_130_val = tmp_122_val*tmp_129_val;

	integer tmp_131_val = tmp_113_val+tmp_130_val;

	integer tmp_134_val = wpi_val*wqi_val;

	integer tmp_136_val=xri_val*xri_val;
	integer tmp_138_val=yri_val*yri_val;
	integer tmp_139_val = tmp_136_val+tmp_138_val;

	integer tmp_140_val = tmp_134_val*tmp_139_val;

	integer tmp_143_val = xpi_val*wqi_val;

	integer tmp_146_val = xqi_val*wpi_val;

	integer tmp_147_val = tmp_143_val-tmp_146_val;

	integer tmp_148_val = tmp_140_val*tmp_147_val;

	integer tmp_149_val = tmp_131_val+tmp_148_val;

	integer tmp_150_val = -(tmp_149_val);
	yCoordI = tmp_150_val;
	}

	// ********************* New Assignment
	if (_valid==TRUE)
	{
	integer tmp_153_val = 2*wpi_val;

	integer tmp_155_val = tmp_153_val*wqi_val;

	integer tmp_157_val = tmp_155_val*wri_val;

	integer tmp_161_val = xqi_val*yri_val;

	integer tmp_164_val = xri_val*yqi_val;

	integer tmp_165_val = tmp_161_val-tmp_164_val;

	integer tmp_166_val = wpi_val*tmp_165_val;

	integer tmp_170_val = xri_val*ypi_val;

	integer tmp_173_val = xpi_val*yri_val;

	integer tmp_174_val = tmp_170_val-tmp_173_val;

	integer tmp_175_val = wqi_val*tmp_174_val;

	integer tmp_176_val = tmp_166_val+tmp_175_val;

	integer tmp_180_val = xpi_val*yqi_val;

	integer tmp_183_val = xqi_val*ypi_val;

	integer tmp_184_val = tmp_180_val-tmp_183_val;

	integer tmp_185_val = wri_val*tmp_184_val;

	integer tmp_186_val = tmp_176_val+tmp_185_val;

	integer tmp_187_val = tmp_157_val*tmp_186_val;

	wCoordI = tmp_187_val;
	}
	}


return _valid;
}

int vnode::PPP_Double()
// **** Local Variables:
//		wpi
//		wqi
//		wri
//		xpi
//		xqi
//		xri
//		ypi
//		yqi
//		yri
// **** External Variables:
//		P.W()
//		P.X()
//		P.Y()
//		Q.W()
//		Q.X()
//		Q.Y()
//		R.W()
//		R.X()
//		R.Y()
// **** Sign Result Variables:

{


  rat_point P=csite(0).rpnt();
  rat_point Q=csite(1).rpnt();
  rat_point R=csite(2).rpnt();


double P_W___g_val = P.WD();
double P_W___g_sup = float_abs(P_W___g_val);
double P_X___g_val = P.XD();
double P_X___g_sup = float_abs(P_X___g_val);
double P_Y___g_val = P.YD();
double P_Y___g_sup = float_abs(P_Y___g_val);
double Q_W___g_val = Q.WD();
double Q_W___g_sup = float_abs(Q_W___g_val);
double Q_X___g_val = Q.XD();
double Q_X___g_sup = float_abs(Q_X___g_val);
double Q_Y___g_val = Q.YD();
double Q_Y___g_sup = float_abs(Q_Y___g_val);
double R_W___g_val = R.WD();
double R_W___g_sup = float_abs(R_W___g_val);
double R_X___g_val = R.XD();
double R_X___g_sup = float_abs(R_X___g_val);
double R_Y___g_val = R.YD();
double R_Y___g_sup = float_abs(R_Y___g_val);




	// ******************* New Declaration
	double xpi_val;
	double xpi_sup;

	xpi_val = P_X___g_val;
	xpi_sup = P_X___g_sup;

	// ******************* New Declaration
	double ypi_val;
	double ypi_sup;

	ypi_val = P_Y___g_val;
	ypi_sup = P_Y___g_sup;

	// ******************* New Declaration
	double wpi_val;
	double wpi_sup;

	wpi_val = P_W___g_val;
	wpi_sup = P_W___g_sup;

	// ******************* New Declaration
	double xqi_val;
	double xqi_sup;

	xqi_val = Q_X___g_val;
	xqi_sup = Q_X___g_sup;

	// ******************* New Declaration
	double yqi_val;
	double yqi_sup;

	yqi_val = Q_Y___g_val;
	yqi_sup = Q_Y___g_sup;

	// ******************* New Declaration
	double wqi_val;
	double wqi_sup;

	wqi_val = Q_W___g_val;
	wqi_sup = Q_W___g_sup;

	// ******************* New Declaration
	double xri_val;
	double xri_sup;

	xri_val = R_X___g_val;
	xri_sup = R_X___g_sup;

	// ******************* New Declaration
	double yri_val;
	double yri_sup;

	yri_val = R_Y___g_val;
	yri_sup = R_Y___g_sup;

	// ******************* New Declaration
	double wri_val;
	double wri_sup;

	wri_val = R_W___g_val;
	wri_sup = R_W___g_sup;

	// ********************* New Assignment
	double tmp_46_val = wqi_val*wri_val;
	double tmp_46_sup = wqi_sup*wri_sup;

	double tmp_48_val=xpi_val*xpi_val;
	double tmp_48_sup=xpi_sup*xpi_sup;

	double tmp_50_val=ypi_val*ypi_val;
	double tmp_50_sup=ypi_sup*ypi_sup;

	double tmp_51_val = tmp_48_val+tmp_50_val;
	double tmp_51_sup = tmp_48_sup+tmp_50_sup;
	{
	 static double _upper=4*eps1;
	 if (tmp_51_sup*_upper*correction<1)
	 {  tmp_51_sup = (tmp_51_val);
	   clear_sign_bit(tmp_51_sup);
	 }
	}

	double tmp_52_val = tmp_46_val*tmp_51_val;
	double tmp_52_sup = tmp_46_sup*tmp_51_sup;

	double tmp_55_val = yqi_val*wri_val;
	double tmp_55_sup = yqi_sup*wri_sup;

	double tmp_58_val = yri_val*wqi_val;
	double tmp_58_sup = yri_sup*wqi_sup;

	double tmp_59_val = tmp_55_val-tmp_58_val;
	double tmp_59_sup = tmp_55_sup+tmp_58_sup;
	{
	 static double _upper=4*eps1;
	 if (tmp_59_sup*_upper*correction<1)
	 {  tmp_59_sup = (tmp_59_val);
	   clear_sign_bit(tmp_59_sup);
	 }
	}

	double tmp_60_val = tmp_52_val*tmp_59_val;
	double tmp_60_sup = tmp_52_sup*tmp_59_sup;

	double tmp_63_val = wpi_val*wri_val;
	double tmp_63_sup = wpi_sup*wri_sup;

	double tmp_65_val=xqi_val*xqi_val;
	double tmp_65_sup=xqi_sup*xqi_sup;

	double tmp_67_val=yqi_val*yqi_val;
	double tmp_67_sup=yqi_sup*yqi_sup;

	double tmp_68_val = tmp_65_val+tmp_67_val;
	double tmp_68_sup = tmp_65_sup+tmp_67_sup;
	{
	 static double _upper=4*eps1;
	 if (tmp_68_sup*_upper*correction<1)
	 {  tmp_68_sup = (tmp_68_val);
	   clear_sign_bit(tmp_68_sup);
	 }
	}

	double tmp_69_val = tmp_63_val*tmp_68_val;
	double tmp_69_sup = tmp_63_sup*tmp_68_sup;

	double tmp_72_val = yri_val*wpi_val;
	double tmp_72_sup = yri_sup*wpi_sup;

	double tmp_75_val = ypi_val*wri_val;
	double tmp_75_sup = ypi_sup*wri_sup;

	double tmp_76_val = tmp_72_val-tmp_75_val;
	double tmp_76_sup = tmp_72_sup+tmp_75_sup;
	{
	 static double _upper=4*eps1;
	 if (tmp_76_sup*_upper*correction<1)
	 {  tmp_76_sup = (tmp_76_val);
	   clear_sign_bit(tmp_76_sup);
	 }
	}

	double tmp_77_val = tmp_69_val*tmp_76_val;
	double tmp_77_sup = tmp_69_sup*tmp_76_sup;

	double tmp_78_val = tmp_60_val+tmp_77_val;
	double tmp_78_sup = tmp_60_sup+tmp_77_sup;
	{
	 static double _upper=14*eps1;
	 if (tmp_78_sup*_upper*correction<1)
	 {  tmp_78_sup = (tmp_78_val);
	   clear_sign_bit(tmp_78_sup);
	 }
	}

	double tmp_81_val = wpi_val*wqi_val;
	double tmp_81_sup = wpi_sup*wqi_sup;

	double tmp_83_val=xri_val*xri_val;
	double tmp_83_sup=xri_sup*xri_sup;

	double tmp_85_val=yri_val*yri_val;
	double tmp_85_sup=yri_sup*yri_sup;

	double tmp_86_val = tmp_83_val+tmp_85_val;
	double tmp_86_sup = tmp_83_sup+tmp_85_sup;
	{
	 static double _upper=4*eps1;
	 if (tmp_86_sup*_upper*correction<1)
	 {  tmp_86_sup = (tmp_86_val);
	   clear_sign_bit(tmp_86_sup);
	 }
	}

	double tmp_87_val = tmp_81_val*tmp_86_val;
	double tmp_87_sup = tmp_81_sup*tmp_86_sup;

	double tmp_90_val = ypi_val*wqi_val;
	double tmp_90_sup = ypi_sup*wqi_sup;

	double tmp_93_val = yqi_val*wpi_val;
	double tmp_93_sup = yqi_sup*wpi_sup;

	double tmp_94_val = tmp_90_val-tmp_93_val;
	double tmp_94_sup = tmp_90_sup+tmp_93_sup;
	{
	 static double _upper=4*eps1;
	 if (tmp_94_sup*_upper*correction<1)
	 {  tmp_94_sup = (tmp_94_val);
	   clear_sign_bit(tmp_94_sup);
	 }
	}

	double tmp_95_val = tmp_87_val*tmp_94_val;
	double tmp_95_sup = tmp_87_sup*tmp_94_sup;

	double tmp_96_val = tmp_78_val+tmp_95_val;
	double tmp_96_sup = tmp_78_sup+tmp_95_sup;
	{
	 static double _upper=15*eps1;
	 if (tmp_96_sup*_upper*correction<1)
	 {  tmp_96_sup = (tmp_96_val);
	   clear_sign_bit(tmp_96_sup);
	 }
	}

	xCoordD = tmp_96_val;
	xCoordDS = tmp_96_sup;
/* Index of xCoord is 15 */

	// ********************* New Assignment
	double tmp_99_val = wqi_val*wri_val;
	double tmp_99_sup = wqi_sup*wri_sup;

	double tmp_101_val=xpi_val*xpi_val;
	double tmp_101_sup=xpi_sup*xpi_sup;

	double tmp_103_val=ypi_val*ypi_val;
	double tmp_103_sup=ypi_sup*ypi_sup;

	double tmp_104_val = tmp_101_val+tmp_103_val;
	double tmp_104_sup = tmp_101_sup+tmp_103_sup;
	{
	 static double _upper=4*eps1;
	 if (tmp_104_sup*_upper*correction<1)
	 {  tmp_104_sup = (tmp_104_val);
	   clear_sign_bit(tmp_104_sup);
	 }
	}

	double tmp_105_val = tmp_99_val*tmp_104_val;
	double tmp_105_sup = tmp_99_sup*tmp_104_sup;

	double tmp_108_val = xqi_val*wri_val;
	double tmp_108_sup = xqi_sup*wri_sup;

	double tmp_111_val = xri_val*wqi_val;
	double tmp_111_sup = xri_sup*wqi_sup;

	double tmp_112_val = tmp_108_val-tmp_111_val;
	double tmp_112_sup = tmp_108_sup+tmp_111_sup;
	{
	 static double _upper=4*eps1;
	 if (tmp_112_sup*_upper*correction<1)
	 {  tmp_112_sup = (tmp_112_val);
	   clear_sign_bit(tmp_112_sup);
	 }
	}

	double tmp_113_val = tmp_105_val*tmp_112_val;
	double tmp_113_sup = tmp_105_sup*tmp_112_sup;

	double tmp_116_val = wpi_val*wri_val;
	double tmp_116_sup = wpi_sup*wri_sup;

	double tmp_118_val=xqi_val*xqi_val;
	double tmp_118_sup=xqi_sup*xqi_sup;

	double tmp_120_val=yqi_val*yqi_val;
	double tmp_120_sup=yqi_sup*yqi_sup;

	double tmp_121_val = tmp_118_val+tmp_120_val;
	double tmp_121_sup = tmp_118_sup+tmp_120_sup;
	{
	 static double _upper=4*eps1;
	 if (tmp_121_sup*_upper*correction<1)
	 {  tmp_121_sup = (tmp_121_val);
	   clear_sign_bit(tmp_121_sup);
	 }
	}

	double tmp_122_val = tmp_116_val*tmp_121_val;
	double tmp_122_sup = tmp_116_sup*tmp_121_sup;

	double tmp_125_val = xri_val*wpi_val;
	double tmp_125_sup = xri_sup*wpi_sup;

	double tmp_128_val = xpi_val*wri_val;
	double tmp_128_sup = xpi_sup*wri_sup;

	double tmp_129_val = tmp_125_val-tmp_128_val;
	double tmp_129_sup = tmp_125_sup+tmp_128_sup;
	{
	 static double _upper=4*eps1;
	 if (tmp_129_sup*_upper*correction<1)
	 {  tmp_129_sup = (tmp_129_val);
	   clear_sign_bit(tmp_129_sup);
	 }
	}

	double tmp_130_val = tmp_122_val*tmp_129_val;
	double tmp_130_sup = tmp_122_sup*tmp_129_sup;

	double tmp_131_val = tmp_113_val+tmp_130_val;
	double tmp_131_sup = tmp_113_sup+tmp_130_sup;
	{
	 static double _upper=14*eps1;
	 if (tmp_131_sup*_upper*correction<1)
	 {  tmp_131_sup = (tmp_131_val);
	   clear_sign_bit(tmp_131_sup);
	 }
	}

	double tmp_134_val = wpi_val*wqi_val;
	double tmp_134_sup = wpi_sup*wqi_sup;

	double tmp_136_val=xri_val*xri_val;
	double tmp_136_sup=xri_sup*xri_sup;

	double tmp_138_val=yri_val*yri_val;
	double tmp_138_sup=yri_sup*yri_sup;

	double tmp_139_val = tmp_136_val+tmp_138_val;
	double tmp_139_sup = tmp_136_sup+tmp_138_sup;
	{
	 static double _upper=4*eps1;
	 if (tmp_139_sup*_upper*correction<1)
	 {  tmp_139_sup = (tmp_139_val);
	   clear_sign_bit(tmp_139_sup);
	 }
	}

	double tmp_140_val = tmp_134_val*tmp_139_val;
	double tmp_140_sup = tmp_134_sup*tmp_139_sup;

	double tmp_143_val = xpi_val*wqi_val;
	double tmp_143_sup = xpi_sup*wqi_sup;

	double tmp_146_val = xqi_val*wpi_val;
	double tmp_146_sup = xqi_sup*wpi_sup;

	double tmp_147_val = tmp_143_val-tmp_146_val;
	double tmp_147_sup = tmp_143_sup+tmp_146_sup;
	{
	 static double _upper=4*eps1;
	 if (tmp_147_sup*_upper*correction<1)
	 {  tmp_147_sup = (tmp_147_val);
	   clear_sign_bit(tmp_147_sup);
	 }
	}

	double tmp_148_val = tmp_140_val*tmp_147_val;
	double tmp_148_sup = tmp_140_sup*tmp_147_sup;

	double tmp_149_val = tmp_131_val+tmp_148_val;
	double tmp_149_sup = tmp_131_sup+tmp_148_sup;
	{
	 static double _upper=15*eps1;
	 if (tmp_149_sup*_upper*correction<1)
	 {  tmp_149_sup = (tmp_149_val);
	   clear_sign_bit(tmp_149_sup);
	 }
	}

	double tmp_150_val = -(tmp_149_val);
	double tmp_150_sup = tmp_149_sup;
	yCoordD = tmp_150_val;
	yCoordDS = tmp_150_sup;
/* Index of yCoord is 15 */

	// ********************* New Assignment
	double tmp_153_val = 2*wpi_val;
	double tmp_153_sup = 2*wpi_sup;

	double tmp_155_val = tmp_153_val*wqi_val;
	double tmp_155_sup = tmp_153_sup*wqi_sup;

	double tmp_157_val = tmp_155_val*wri_val;
	double tmp_157_sup = tmp_155_sup*wri_sup;

	double tmp_161_val = xqi_val*yri_val;
	double tmp_161_sup = xqi_sup*yri_sup;

	double tmp_164_val = xri_val*yqi_val;
	double tmp_164_sup = xri_sup*yqi_sup;

	double tmp_165_val = tmp_161_val-tmp_164_val;
	double tmp_165_sup = tmp_161_sup+tmp_164_sup;
	{
	 static double _upper=4*eps1;
	 if (tmp_165_sup*_upper*correction<1)
	 {  tmp_165_sup = (tmp_165_val);
	   clear_sign_bit(tmp_165_sup);
	 }
	}

	double tmp_166_val = wpi_val*tmp_165_val;
	double tmp_166_sup = wpi_sup*tmp_165_sup;

	double tmp_170_val = xri_val*ypi_val;
	double tmp_170_sup = xri_sup*ypi_sup;

	double tmp_173_val = xpi_val*yri_val;
	double tmp_173_sup = xpi_sup*yri_sup;

	double tmp_174_val = tmp_170_val-tmp_173_val;
	double tmp_174_sup = tmp_170_sup+tmp_173_sup;
	{
	 static double _upper=4*eps1;
	 if (tmp_174_sup*_upper*correction<1)
	 {  tmp_174_sup = (tmp_174_val);
	   clear_sign_bit(tmp_174_sup);
	 }
	}

	double tmp_175_val = wqi_val*tmp_174_val;
	double tmp_175_sup = wqi_sup*tmp_174_sup;

	double tmp_176_val = tmp_166_val+tmp_175_val;
	double tmp_176_sup = tmp_166_sup+tmp_175_sup;
	{
	 static double _upper=7*eps1;
	 if (tmp_176_sup*_upper*correction<1)
	 {  tmp_176_sup = (tmp_176_val);
	   clear_sign_bit(tmp_176_sup);
	 }
	}

	double tmp_180_val = xpi_val*yqi_val;
	double tmp_180_sup = xpi_sup*yqi_sup;

	double tmp_183_val = xqi_val*ypi_val;
	double tmp_183_sup = xqi_sup*ypi_sup;

	double tmp_184_val = tmp_180_val-tmp_183_val;
	double tmp_184_sup = tmp_180_sup+tmp_183_sup;
	{
	 static double _upper=4*eps1;
	 if (tmp_184_sup*_upper*correction<1)
	 {  tmp_184_sup = (tmp_184_val);
	   clear_sign_bit(tmp_184_sup);
	 }
	}

	double tmp_185_val = wri_val*tmp_184_val;
	double tmp_185_sup = wri_sup*tmp_184_sup;

	double tmp_186_val = tmp_176_val+tmp_185_val;
	double tmp_186_sup = tmp_176_sup+tmp_185_sup;
	{
	 static double _upper=8*eps1;
	 if (tmp_186_sup*_upper*correction<1)
	 {  tmp_186_sup = (tmp_186_val);
	   clear_sign_bit(tmp_186_sup);
	 }
	}

	double tmp_187_val = tmp_157_val*tmp_186_val;
	double tmp_187_sup = tmp_157_sup*tmp_186_sup;

	wCoordD = tmp_187_val;
	wCoordDS = tmp_187_sup;
/* Index of wCoord is 15 */


return TRUE;
}




int vnode::SPP_distdiff_Exact()
// **** Local Variables:
//		A
//		I
//		J
//		R
//		S
//		S1
//		S2
//		S_W
//		T
//		X
//		aa
//		bb
//		cc
//		xp
//		xq
//		xv_trans
//		xxq
//		yp
//		yq
//		yv_trans
//		yyq
//		zp
//		zq
//		zv_trans
//		zzq
// **** External Variables:
//		P.W()
//		P.X()
//		P.Y()
//		Q.W()
//		Q.X()
//		Q.Y()
//		a
//		b
//		c
// **** Sign Result Variables:

{


  rat_segment l=csite(0).rseg();
  rat_point   P=csite(1).rpnt();
  rat_point   Q=csite(2).rpnt();

  if (right_turn(l.start(),l.end(),P))
    invert_seg(l);  
    /* care for the right orientation of l */

  integer a,b,c;
  seg2line_paras(l,a,b,c);     // initializes the homogenous coords of l


	{
	real xp = P.X();
	real yp = P.Y();
	real zp = P.W();
	real xq = Q.X();
	real yq = Q.Y();
	real zq = Q.W();
	real xxq = ((xq*zp)-(xp*zq));
	real yyq = ((yq*zp)-(yp*zq));
	real R = (sq(xxq)+sq(yyq));
	real S1 = (((a*xp)+(b*yp))+(c*zp));
	real S2 = (((a*xq)+(b*yq))+(c*zq));
	real S = (((((zp*zq)*R)*(sq(a)+sq(b)))*S1)*S2);
	real S_W = sqrt(S);
	real zzq = (zp*zq);
	real aa = (a*zp);
	real bb = (b*zp);
	real cc = (((a*xp)+(b*yp))+(c*zp));
	real A = ((a*xxq)+(b*yyq));
	real X = sq(A);
	real T = (R*A);
	real I = ((b*T)+((((2*cc)*xxq)*zq)*((b*xxq)-(a*yyq))));
	real J = ((a*T)+((((2*cc)*yyq)*zq)*((a*yyq)-(b*xxq))));
	real xv_trans = (J+(((2*1)*yyq)*S_W));
	real yv_trans = (I-(((2*1)*xxq)*S_W));
	real zv_trans = ((2*zzq)*X);
	xCoord = ((xv_trans*zp)+(xp*zv_trans));
	yCoord = ((yv_trans*zp)+(yp*zv_trans));
	wCoord = (zv_trans*zp);
	}


return TRUE;
}

int vnode::SPP_distdiff_Integer()
// **** Local Variables:
//		A
//		I
//		J
//		R
//		S
//		S1
//		S2
//		S_W
//		T
//		X
//		aa
//		bb
//		cc
//		xp
//		xq
//		xv_trans
//		xxq
//		yp
//		yq
//		yv_trans
//		yyq
//		zp
//		zq
//		zv_trans
//		zzq
// **** External Variables:
//		P.W()
//		P.X()
//		P.Y()
//		Q.W()
//		Q.X()
//		Q.Y()
//		a
//		b
//		c
// **** Sign Result Variables:

{
	int _valid=TRUE;
	 if (!(1))
		_valid=FALSE;



  rat_segment l=csite(0).rseg();
  rat_point   P=csite(1).rpnt();
  rat_point   Q=csite(2).rpnt();

  if (right_turn(l.start(),l.end(),P))
    invert_seg(l);  
    /* care for the right orientation of l */

  integer a,b,c;
  seg2line_paras(l,a,b,c);     // initializes the homogenous coords of l


	{
integer P_W___g_val = P.W();
integer P_X___g_val = P.X();
integer P_Y___g_val = P.Y();
integer Q_W___g_val = Q.W();
integer Q_X___g_val = Q.X();
integer Q_Y___g_val = Q.Y();
integer a_g_val = a;
integer b_g_val = b;
integer c_g_val = c;




	// ******************* New Declaration
	integer xp_val;

	if (_valid==TRUE)
	{
		xp_val = P_X___g_val;
	}

	// ******************* New Declaration
	integer yp_val;

	if (_valid==TRUE)
	{
		yp_val = P_Y___g_val;
	}

	// ******************* New Declaration
	integer zp_val;

	if (_valid==TRUE)
	{
		zp_val = P_W___g_val;
	}

	// ******************* New Declaration
	integer xq_val;

	if (_valid==TRUE)
	{
		xq_val = Q_X___g_val;
	}

	// ******************* New Declaration
	integer yq_val;

	if (_valid==TRUE)
	{
		yq_val = Q_Y___g_val;
	}

	// ******************* New Declaration
	integer zq_val;

	if (_valid==TRUE)
	{
		zq_val = Q_W___g_val;
	}

	// ******************* New Declaration
	integer xxq_val;

	if (_valid==TRUE)
	{
	integer tmp_197_val = xq_val*zp_val;

	integer tmp_200_val = xp_val*zq_val;

	integer tmp_201_val = tmp_197_val-tmp_200_val;

		xxq_val = tmp_201_val;
	}

	// ******************* New Declaration
	integer yyq_val;

	if (_valid==TRUE)
	{
	integer tmp_204_val = yq_val*zp_val;

	integer tmp_207_val = yp_val*zq_val;

	integer tmp_208_val = tmp_204_val-tmp_207_val;

		yyq_val = tmp_208_val;
	}

	// ******************* New Declaration
	integer R_val;

	if (_valid==TRUE)
	{
	integer tmp_210_val=xxq_val*xxq_val;
	integer tmp_212_val=yyq_val*yyq_val;
	integer tmp_213_val = tmp_210_val+tmp_212_val;

		R_val = tmp_213_val;
	}

	// ******************* New Declaration
	integer S1_val;

	if (_valid==TRUE)
	{
	integer tmp_216_val = a_g_val*xp_val;

	integer tmp_219_val = b_g_val*yp_val;

	integer tmp_220_val = tmp_216_val+tmp_219_val;

	integer tmp_223_val = c_g_val*zp_val;

	integer tmp_224_val = tmp_220_val+tmp_223_val;

		S1_val = tmp_224_val;
	}

	// ******************* New Declaration
	integer S2_val;

	if (_valid==TRUE)
	{
	integer tmp_227_val = a_g_val*xq_val;

	integer tmp_230_val = b_g_val*yq_val;

	integer tmp_231_val = tmp_227_val+tmp_230_val;

	integer tmp_234_val = c_g_val*zq_val;

	integer tmp_235_val = tmp_231_val+tmp_234_val;

		S2_val = tmp_235_val;
	}

	// ******************* New Declaration
	integer S_val;

	if (_valid==TRUE)
	{
	integer tmp_238_val = zp_val*zq_val;

	integer tmp_240_val = tmp_238_val*R_val;

	integer tmp_242_val=a_g_val*a_g_val;
	integer tmp_244_val=b_g_val*b_g_val;
	integer tmp_245_val = tmp_242_val+tmp_244_val;

	integer tmp_246_val = tmp_240_val*tmp_245_val;

	integer tmp_248_val = tmp_246_val*S1_val;

	integer tmp_250_val = tmp_248_val*S2_val;

		S_val = tmp_250_val;
	}

	// ******************* New Declaration
	integer S_W_val;

	if (_valid==TRUE)
	{
	integer tmp_252_val;
	if (S_val <0) _valid=FALSE;
	else
	{
	  tmp_252_val = sqrt(S_val);
	  if (tmp_252_val*tmp_252_val != S_val) _valid=FALSE;
	}
		S_W_val = tmp_252_val;
	}

	// ******************* New Declaration
	integer zzq_val;

	if (_valid==TRUE)
	{
	integer tmp_255_val = zp_val*zq_val;

		zzq_val = tmp_255_val;
	}

	// ******************* New Declaration
	integer aa_val;

	if (_valid==TRUE)
	{
	integer tmp_258_val = a_g_val*zp_val;

		aa_val = tmp_258_val;
	}

	// ******************* New Declaration
	integer bb_val;

	if (_valid==TRUE)
	{
	integer tmp_261_val = b_g_val*zp_val;

		bb_val = tmp_261_val;
	}

	// ******************* New Declaration
	integer cc_val;

	if (_valid==TRUE)
	{
	integer tmp_264_val = a_g_val*xp_val;

	integer tmp_267_val = b_g_val*yp_val;

	integer tmp_268_val = tmp_264_val+tmp_267_val;

	integer tmp_271_val = c_g_val*zp_val;

	integer tmp_272_val = tmp_268_val+tmp_271_val;

		cc_val = tmp_272_val;
	}

	// ******************* New Declaration
	integer A_val;

	if (_valid==TRUE)
	{
	integer tmp_275_val = a_g_val*xxq_val;

	integer tmp_278_val = b_g_val*yyq_val;

	integer tmp_279_val = tmp_275_val+tmp_278_val;

		A_val = tmp_279_val;
	}

	// ******************* New Declaration
	integer X_val;

	if (_valid==TRUE)
	{
	integer tmp_281_val=A_val*A_val;
		X_val = tmp_281_val;
	}

	// ******************* New Declaration
	integer T_val;

	if (_valid==TRUE)
	{
	integer tmp_284_val = R_val*A_val;

		T_val = tmp_284_val;
	}

	// ******************* New Declaration
	integer I_val;

	if (_valid==TRUE)
	{
	integer tmp_287_val = b_g_val*T_val;

	integer tmp_290_val = 2*cc_val;

	integer tmp_292_val = tmp_290_val*xxq_val;

	integer tmp_294_val = tmp_292_val*zq_val;

	integer tmp_297_val = b_g_val*xxq_val;

	integer tmp_300_val = a_g_val*yyq_val;

	integer tmp_301_val = tmp_297_val-tmp_300_val;

	integer tmp_302_val = tmp_294_val*tmp_301_val;

	integer tmp_303_val = tmp_287_val+tmp_302_val;

		I_val = tmp_303_val;
	}

	// ******************* New Declaration
	integer J_val;

	if (_valid==TRUE)
	{
	integer tmp_306_val = a_g_val*T_val;

	integer tmp_309_val = 2*cc_val;

	integer tmp_311_val = tmp_309_val*yyq_val;

	integer tmp_313_val = tmp_311_val*zq_val;

	integer tmp_316_val = a_g_val*yyq_val;

	integer tmp_319_val = b_g_val*xxq_val;

	integer tmp_320_val = tmp_316_val-tmp_319_val;

	integer tmp_321_val = tmp_313_val*tmp_320_val;

	integer tmp_322_val = tmp_306_val+tmp_321_val;

		J_val = tmp_322_val;
	}

	// ******************* New Declaration
	integer xv_trans_val;

	if (_valid==TRUE)
	{
	integer tmp_326_val = 2*1;

	integer tmp_328_val = tmp_326_val*yyq_val;

	integer tmp_330_val = tmp_328_val*S_W_val;

	integer tmp_331_val = J_val+tmp_330_val;

		xv_trans_val = tmp_331_val;
	}

	// ******************* New Declaration
	integer yv_trans_val;

	if (_valid==TRUE)
	{
	integer tmp_335_val = 2*1;

	integer tmp_337_val = tmp_335_val*xxq_val;

	integer tmp_339_val = tmp_337_val*S_W_val;

	integer tmp_340_val = I_val-tmp_339_val;

		yv_trans_val = tmp_340_val;
	}

	// ******************* New Declaration
	integer zv_trans_val;

	if (_valid==TRUE)
	{
	integer tmp_343_val = 2*zzq_val;

	integer tmp_345_val = tmp_343_val*X_val;

		zv_trans_val = tmp_345_val;
	}

	// ********************* New Assignment
	if (_valid==TRUE)
	{
	integer tmp_348_val = xv_trans_val*zp_val;

	integer tmp_351_val = xp_val*zv_trans_val;

	integer tmp_352_val = tmp_348_val+tmp_351_val;

	xCoordI = tmp_352_val;
	}

	// ********************* New Assignment
	if (_valid==TRUE)
	{
	integer tmp_355_val = yv_trans_val*zp_val;

	integer tmp_358_val = yp_val*zv_trans_val;

	integer tmp_359_val = tmp_355_val+tmp_358_val;

	yCoordI = tmp_359_val;
	}

	// ********************* New Assignment
	if (_valid==TRUE)
	{
	integer tmp_362_val = zv_trans_val*zp_val;

	wCoordI = tmp_362_val;
	}
	}


return _valid;
}

int vnode::SPP_distdiff_Double()
// **** Local Variables:
//		A
//		I
//		J
//		R
//		S
//		S1
//		S2
//		S_W
//		T
//		X
//		aa
//		bb
//		cc
//		xp
//		xq
//		xv_trans
//		xxq
//		yp
//		yq
//		yv_trans
//		yyq
//		zp
//		zq
//		zv_trans
//		zzq
// **** External Variables:
//		P.W()
//		P.X()
//		P.Y()
//		Q.W()
//		Q.X()
//		Q.Y()
//		a
//		b
//		c
// **** Sign Result Variables:

{


  rat_segment l=csite(0).rseg();
  rat_point   P=csite(1).rpnt();
  rat_point   Q=csite(2).rpnt();

  if (right_turn(l.start(),l.end(),P))
    invert_seg(l);  
    /* care for the right orientation of l */

  integer a,b,c;
  seg2line_paras(l,a,b,c);     // initializes the homogenous coords of l


double P_W___g_val = P.WD();
double P_W___g_sup = float_abs(P_W___g_val);
double P_X___g_val = P.XD();
double P_X___g_sup = float_abs(P_X___g_val);
double P_Y___g_val = P.YD();
double P_Y___g_sup = float_abs(P_Y___g_val);
double Q_W___g_val = Q.WD();
double Q_W___g_sup = float_abs(Q_W___g_val);
double Q_X___g_val = Q.XD();
double Q_X___g_sup = float_abs(Q_X___g_val);
double Q_Y___g_val = Q.YD();
double Q_Y___g_sup = float_abs(Q_Y___g_val);
double a_g_val = a.to_double();
double a_g_sup = float_abs(a_g_val);
double b_g_val = b.to_double();
double b_g_sup = float_abs(b_g_val);
double c_g_val = c.to_double();
double c_g_sup = float_abs(c_g_val);




	// ******************* New Declaration
	double xp_val;
	double xp_sup;

	xp_val = P_X___g_val;
	xp_sup = P_X___g_sup;

	// ******************* New Declaration
	double yp_val;
	double yp_sup;

	yp_val = P_Y___g_val;
	yp_sup = P_Y___g_sup;

	// ******************* New Declaration
	double zp_val;
	double zp_sup;

	zp_val = P_W___g_val;
	zp_sup = P_W___g_sup;

	// ******************* New Declaration
	double xq_val;
	double xq_sup;

	xq_val = Q_X___g_val;
	xq_sup = Q_X___g_sup;

	// ******************* New Declaration
	double yq_val;
	double yq_sup;

	yq_val = Q_Y___g_val;
	yq_sup = Q_Y___g_sup;

	// ******************* New Declaration
	double zq_val;
	double zq_sup;

	zq_val = Q_W___g_val;
	zq_sup = Q_W___g_sup;

	// ******************* New Declaration
	double xxq_val;
	double xxq_sup;

	double tmp_197_val = xq_val*zp_val;
	double tmp_197_sup = xq_sup*zp_sup;

	double tmp_200_val = xp_val*zq_val;
	double tmp_200_sup = xp_sup*zq_sup;

	double tmp_201_val = tmp_197_val-tmp_200_val;
	double tmp_201_sup = tmp_197_sup+tmp_200_sup;
	{
	 static double _upper=4*eps1;
	 if (tmp_201_sup*_upper*correction<1)
	 {  tmp_201_sup = (tmp_201_val);
	   clear_sign_bit(tmp_201_sup);
	 }
	}

	xxq_val = tmp_201_val;
	xxq_sup = tmp_201_sup;

	// ******************* New Declaration
	double yyq_val;
	double yyq_sup;

	double tmp_204_val = yq_val*zp_val;
	double tmp_204_sup = yq_sup*zp_sup;

	double tmp_207_val = yp_val*zq_val;
	double tmp_207_sup = yp_sup*zq_sup;

	double tmp_208_val = tmp_204_val-tmp_207_val;
	double tmp_208_sup = tmp_204_sup+tmp_207_sup;
	{
	 static double _upper=4*eps1;
	 if (tmp_208_sup*_upper*correction<1)
	 {  tmp_208_sup = (tmp_208_val);
	   clear_sign_bit(tmp_208_sup);
	 }
	}

	yyq_val = tmp_208_val;
	yyq_sup = tmp_208_sup;

	// ******************* New Declaration
	double R_val;
	double R_sup;

	double tmp_210_val=xxq_val*xxq_val;
	double tmp_210_sup=xxq_sup*xxq_sup;

	double tmp_212_val=yyq_val*yyq_val;
	double tmp_212_sup=yyq_sup*yyq_sup;

	double tmp_213_val = tmp_210_val+tmp_212_val;
	double tmp_213_sup = tmp_210_sup+tmp_212_sup;
	{
	 static double _upper=10*eps1;
	 if (tmp_213_sup*_upper*correction<1)
	 {  tmp_213_sup = (tmp_213_val);
	   clear_sign_bit(tmp_213_sup);
	 }
	}

	R_val = tmp_213_val;
	R_sup = tmp_213_sup;

	// ******************* New Declaration
	double S1_val;
	double S1_sup;

	double tmp_216_val = a_g_val*xp_val;
	double tmp_216_sup = a_g_sup*xp_sup;

	double tmp_219_val = b_g_val*yp_val;
	double tmp_219_sup = b_g_sup*yp_sup;

	double tmp_220_val = tmp_216_val+tmp_219_val;
	double tmp_220_sup = tmp_216_sup+tmp_219_sup;
	{
	 static double _upper=4*eps1;
	 if (tmp_220_sup*_upper*correction<1)
	 {  tmp_220_sup = (tmp_220_val);
	   clear_sign_bit(tmp_220_sup);
	 }
	}

	double tmp_223_val = c_g_val*zp_val;
	double tmp_223_sup = c_g_sup*zp_sup;

	double tmp_224_val = tmp_220_val+tmp_223_val;
	double tmp_224_sup = tmp_220_sup+tmp_223_sup;
	{
	 static double _upper=5*eps1;
	 if (tmp_224_sup*_upper*correction<1)
	 {  tmp_224_sup = (tmp_224_val);
	   clear_sign_bit(tmp_224_sup);
	 }
	}

	S1_val = tmp_224_val;
	S1_sup = tmp_224_sup;

	// ******************* New Declaration
	double S2_val;
	double S2_sup;

	double tmp_227_val = a_g_val*xq_val;
	double tmp_227_sup = a_g_sup*xq_sup;

	double tmp_230_val = b_g_val*yq_val;
	double tmp_230_sup = b_g_sup*yq_sup;

	double tmp_231_val = tmp_227_val+tmp_230_val;
	double tmp_231_sup = tmp_227_sup+tmp_230_sup;
	{
	 static double _upper=4*eps1;
	 if (tmp_231_sup*_upper*correction<1)
	 {  tmp_231_sup = (tmp_231_val);
	   clear_sign_bit(tmp_231_sup);
	 }
	}

	double tmp_234_val = c_g_val*zq_val;
	double tmp_234_sup = c_g_sup*zq_sup;

	double tmp_235_val = tmp_231_val+tmp_234_val;
	double tmp_235_sup = tmp_231_sup+tmp_234_sup;
	{
	 static double _upper=5*eps1;
	 if (tmp_235_sup*_upper*correction<1)
	 {  tmp_235_sup = (tmp_235_val);
	   clear_sign_bit(tmp_235_sup);
	 }
	}

	S2_val = tmp_235_val;
	S2_sup = tmp_235_sup;

	// ******************* New Declaration
	double S_val;
	double S_sup;

	double tmp_238_val = zp_val*zq_val;
	double tmp_238_sup = zp_sup*zq_sup;

	double tmp_240_val = tmp_238_val*R_val;
	double tmp_240_sup = tmp_238_sup*R_sup;

	double tmp_242_val=a_g_val*a_g_val;
	double tmp_242_sup=a_g_sup*a_g_sup;

	double tmp_244_val=b_g_val*b_g_val;
	double tmp_244_sup=b_g_sup*b_g_sup;

	double tmp_245_val = tmp_242_val+tmp_244_val;
	double tmp_245_sup = tmp_242_sup+tmp_244_sup;
	{
	 static double _upper=4*eps1;
	 if (tmp_245_sup*_upper*correction<1)
	 {  tmp_245_sup = (tmp_245_val);
	   clear_sign_bit(tmp_245_sup);
	 }
	}

	double tmp_246_val = tmp_240_val*tmp_245_val;
	double tmp_246_sup = tmp_240_sup*tmp_245_sup;

	double tmp_248_val = tmp_246_val*S1_val;
	double tmp_248_sup = tmp_246_sup*S1_sup;

	double tmp_250_val = tmp_248_val*S2_val;
	double tmp_250_sup = tmp_248_sup*S2_sup;

	S_val = tmp_250_val;
	S_sup = tmp_250_sup;

	// ******************* New Declaration
	double S_W_val;
	double S_W_sup;

	double tmp_252_val=NaN_double;
	double tmp_252_sup=pInf_double;
	if (S_val<0) ;
	else
	if ( S_sup==0 )
	   tmp_252_val=tmp_252_sup=0;
	else
	if (S_sup*(eps1*31)*correction<1)
	{  tmp_252_val = sqrt(S_val);
	   tmp_252_sup = tmp_252_val;
	}
	else
	{   if (S_val==0)
	    { tmp_252_val=0; 
	      tmp_252_sup=sqrt(S_sup)*sqrtMul;
	    }
	    else
	    {
	    tmp_252_val = sqrt(S_val);
	    tmp_252_sup = (S_sup/S_val)*tmp_252_val;
	    }
	}
	S_W_val = tmp_252_val;
	S_W_sup = tmp_252_sup;

	// ******************* New Declaration
	double zzq_val;
	double zzq_sup;

	double tmp_255_val = zp_val*zq_val;
	double tmp_255_sup = zp_sup*zq_sup;

	zzq_val = tmp_255_val;
	zzq_sup = tmp_255_sup;

	// ******************* New Declaration
	double aa_val;
	double aa_sup;

	double tmp_258_val = a_g_val*zp_val;
	double tmp_258_sup = a_g_sup*zp_sup;

	aa_val = tmp_258_val;
	aa_sup = tmp_258_sup;

	// ******************* New Declaration
	double bb_val;
	double bb_sup;

	double tmp_261_val = b_g_val*zp_val;
	double tmp_261_sup = b_g_sup*zp_sup;

	bb_val = tmp_261_val;
	bb_sup = tmp_261_sup;

	// ******************* New Declaration
	double cc_val;
	double cc_sup;

	double tmp_264_val = a_g_val*xp_val;
	double tmp_264_sup = a_g_sup*xp_sup;

	double tmp_267_val = b_g_val*yp_val;
	double tmp_267_sup = b_g_sup*yp_sup;

	double tmp_268_val = tmp_264_val+tmp_267_val;
	double tmp_268_sup = tmp_264_sup+tmp_267_sup;
	{
	 static double _upper=4*eps1;
	 if (tmp_268_sup*_upper*correction<1)
	 {  tmp_268_sup = (tmp_268_val);
	   clear_sign_bit(tmp_268_sup);
	 }
	}

	double tmp_271_val = c_g_val*zp_val;
	double tmp_271_sup = c_g_sup*zp_sup;

	double tmp_272_val = tmp_268_val+tmp_271_val;
	double tmp_272_sup = tmp_268_sup+tmp_271_sup;
	{
	 static double _upper=5*eps1;
	 if (tmp_272_sup*_upper*correction<1)
	 {  tmp_272_sup = (tmp_272_val);
	   clear_sign_bit(tmp_272_sup);
	 }
	}

	cc_val = tmp_272_val;
	cc_sup = tmp_272_sup;

	// ******************* New Declaration
	double A_val;
	double A_sup;

	double tmp_275_val = a_g_val*xxq_val;
	double tmp_275_sup = a_g_sup*xxq_sup;

	double tmp_278_val = b_g_val*yyq_val;
	double tmp_278_sup = b_g_sup*yyq_sup;

	double tmp_279_val = tmp_275_val+tmp_278_val;
	double tmp_279_sup = tmp_275_sup+tmp_278_sup;
	{
	 static double _upper=7*eps1;
	 if (tmp_279_sup*_upper*correction<1)
	 {  tmp_279_sup = (tmp_279_val);
	   clear_sign_bit(tmp_279_sup);
	 }
	}

	A_val = tmp_279_val;
	A_sup = tmp_279_sup;

	// ******************* New Declaration
	double X_val;
	double X_sup;

	double tmp_281_val=A_val*A_val;
	double tmp_281_sup=A_sup*A_sup;

	X_val = tmp_281_val;
	X_sup = tmp_281_sup;

	// ******************* New Declaration
	double T_val;
	double T_sup;

	double tmp_284_val = R_val*A_val;
	double tmp_284_sup = R_sup*A_sup;

	T_val = tmp_284_val;
	T_sup = tmp_284_sup;

	// ******************* New Declaration
	double I_val;
	double I_sup;

	double tmp_287_val = b_g_val*T_val;
	double tmp_287_sup = b_g_sup*T_sup;

	double tmp_290_val = 2*cc_val;
	double tmp_290_sup = 2*cc_sup;

	double tmp_292_val = tmp_290_val*xxq_val;
	double tmp_292_sup = tmp_290_sup*xxq_sup;

	double tmp_294_val = tmp_292_val*zq_val;
	double tmp_294_sup = tmp_292_sup*zq_sup;

	double tmp_297_val = b_g_val*xxq_val;
	double tmp_297_sup = b_g_sup*xxq_sup;

	double tmp_300_val = a_g_val*yyq_val;
	double tmp_300_sup = a_g_sup*yyq_sup;

	double tmp_301_val = tmp_297_val-tmp_300_val;
	double tmp_301_sup = tmp_297_sup+tmp_300_sup;
	{
	 static double _upper=7*eps1;
	 if (tmp_301_sup*_upper*correction<1)
	 {  tmp_301_sup = (tmp_301_val);
	   clear_sign_bit(tmp_301_sup);
	 }
	}

	double tmp_302_val = tmp_294_val*tmp_301_val;
	double tmp_302_sup = tmp_294_sup*tmp_301_sup;

	double tmp_303_val = tmp_287_val+tmp_302_val;
	double tmp_303_sup = tmp_287_sup+tmp_302_sup;
	{
	 static double _upper=22*eps1;
	 if (tmp_303_sup*_upper*correction<1)
	 {  tmp_303_sup = (tmp_303_val);
	   clear_sign_bit(tmp_303_sup);
	 }
	}

	I_val = tmp_303_val;
	I_sup = tmp_303_sup;

	// ******************* New Declaration
	double J_val;
	double J_sup;

	double tmp_306_val = a_g_val*T_val;
	double tmp_306_sup = a_g_sup*T_sup;

	double tmp_309_val = 2*cc_val;
	double tmp_309_sup = 2*cc_sup;

	double tmp_311_val = tmp_309_val*yyq_val;
	double tmp_311_sup = tmp_309_sup*yyq_sup;

	double tmp_313_val = tmp_311_val*zq_val;
	double tmp_313_sup = tmp_311_sup*zq_sup;

	double tmp_316_val = a_g_val*yyq_val;
	double tmp_316_sup = a_g_sup*yyq_sup;

	double tmp_319_val = b_g_val*xxq_val;
	double tmp_319_sup = b_g_sup*xxq_sup;

	double tmp_320_val = tmp_316_val-tmp_319_val;
	double tmp_320_sup = tmp_316_sup+tmp_319_sup;
	{
	 static double _upper=7*eps1;
	 if (tmp_320_sup*_upper*correction<1)
	 {  tmp_320_sup = (tmp_320_val);
	   clear_sign_bit(tmp_320_sup);
	 }
	}

	double tmp_321_val = tmp_313_val*tmp_320_val;
	double tmp_321_sup = tmp_313_sup*tmp_320_sup;

	double tmp_322_val = tmp_306_val+tmp_321_val;
	double tmp_322_sup = tmp_306_sup+tmp_321_sup;
	{
	 static double _upper=22*eps1;
	 if (tmp_322_sup*_upper*correction<1)
	 {  tmp_322_sup = (tmp_322_val);
	   clear_sign_bit(tmp_322_sup);
	 }
	}

	J_val = tmp_322_val;
	J_sup = tmp_322_sup;

	// ******************* New Declaration
	double xv_trans_val;
	double xv_trans_sup;

	double tmp_326_val = 2*1;
	double tmp_326_sup = 2*1;

	double tmp_328_val = tmp_326_val*yyq_val;
	double tmp_328_sup = tmp_326_sup*yyq_sup;

	double tmp_330_val = tmp_328_val*S_W_val;
	double tmp_330_sup = tmp_328_sup*S_W_sup;

	double tmp_331_val = J_val+tmp_330_val;
	double tmp_331_sup = J_sup+tmp_330_sup;
	{
	 static double _upper=39*eps1;
	 if (tmp_331_sup*_upper*correction<1)
	 {  tmp_331_sup = (tmp_331_val);
	   clear_sign_bit(tmp_331_sup);
	 }
	}

	xv_trans_val = tmp_331_val;
	xv_trans_sup = tmp_331_sup;

	// ******************* New Declaration
	double yv_trans_val;
	double yv_trans_sup;

	double tmp_335_val = 2*1;
	double tmp_335_sup = 2*1;

	double tmp_337_val = tmp_335_val*xxq_val;
	double tmp_337_sup = tmp_335_sup*xxq_sup;

	double tmp_339_val = tmp_337_val*S_W_val;
	double tmp_339_sup = tmp_337_sup*S_W_sup;

	double tmp_340_val = I_val-tmp_339_val;
	double tmp_340_sup = I_sup+tmp_339_sup;
	{
	 static double _upper=39*eps1;
	 if (tmp_340_sup*_upper*correction<1)
	 {  tmp_340_sup = (tmp_340_val);
	   clear_sign_bit(tmp_340_sup);
	 }
	}

	yv_trans_val = tmp_340_val;
	yv_trans_sup = tmp_340_sup;

	// ******************* New Declaration
	double zv_trans_val;
	double zv_trans_sup;

	double tmp_343_val = 2*zzq_val;
	double tmp_343_sup = 2*zzq_sup;

	double tmp_345_val = tmp_343_val*X_val;
	double tmp_345_sup = tmp_343_sup*X_sup;

	zv_trans_val = tmp_345_val;
	zv_trans_sup = tmp_345_sup;

	// ********************* New Assignment
	double tmp_348_val = xv_trans_val*zp_val;
	double tmp_348_sup = xv_trans_sup*zp_sup;

	double tmp_351_val = xp_val*zv_trans_val;
	double tmp_351_sup = xp_sup*zv_trans_sup;

	double tmp_352_val = tmp_348_val+tmp_351_val;
	double tmp_352_sup = tmp_348_sup+tmp_351_sup;
	{
	 static double _upper=42*eps1;
	 if (tmp_352_sup*_upper*correction<1)
	 {  tmp_352_sup = (tmp_352_val);
	   clear_sign_bit(tmp_352_sup);
	 }
	}

	xCoordD = tmp_352_val;
	xCoordDS = tmp_352_sup;
/* Index of xCoord is 42 */

	// ********************* New Assignment
	double tmp_355_val = yv_trans_val*zp_val;
	double tmp_355_sup = yv_trans_sup*zp_sup;

	double tmp_358_val = yp_val*zv_trans_val;
	double tmp_358_sup = yp_sup*zv_trans_sup;

	double tmp_359_val = tmp_355_val+tmp_358_val;
	double tmp_359_sup = tmp_355_sup+tmp_358_sup;
	{
	 static double _upper=42*eps1;
	 if (tmp_359_sup*_upper*correction<1)
	 {  tmp_359_sup = (tmp_359_val);
	   clear_sign_bit(tmp_359_sup);
	 }
	}

	yCoordD = tmp_359_val;
	yCoordDS = tmp_359_sup;
/* Index of yCoord is 42 */

	// ********************* New Assignment
	double tmp_362_val = zv_trans_val*zp_val;
	double tmp_362_sup = zv_trans_sup*zp_sup;

	wCoordD = tmp_362_val;
	wCoordDS = tmp_362_sup;
/* Index of wCoord is 22 */


return TRUE;
}





int vnode::SPP_disteq_Exact()
// **** Local Variables:
//		B
//		C
//		aa
//		bb
//		cc
//		xp
//		xq
//		xv_trans
//		xxq
//		yp
//		yq
//		yv_trans
//		yyq
//		zp
//		zq
//		zv_trans
//		zzq
// **** External Variables:
//		P.W()
//		P.X()
//		P.Y()
//		Q.W()
//		Q.X()
//		Q.Y()
//		a
//		b
//		c
// **** Sign Result Variables:

{


  rat_segment l=csite(0).rseg();
  rat_point   P=csite(1).rpnt();
  rat_point   Q=csite(2).rpnt();

  if (right_turn(l.start(),l.end(),P))
    invert_seg(l);  
    /* care for the right orientation of l */

  integer a,b,c;
  seg2line_paras(l,a,b,c);     // initializes the homogenous coords of l


	{
	real xp = P.X();
	real yp = P.Y();
	real zp = P.W();
	real xq = Q.X();
	real yq = Q.Y();
	real zq = Q.W();
	real xxq = ((xq*zp)-(xp*zq));
	real yyq = ((yq*zp)-(yp*zq));
	real zzq = (zp*zq);
	real aa = (a*zp);
	real bb = (b*zp);
	real cc = (((a*xp)+(b*yp))+(c*zp));
	real B = (sq(a)+sq(b));
	real C = (sq(xxq)+sq(yyq));
	real xv_trans = ((((a*B)*C)+((((4*cc)*B)*xxq)*zq))-(((4*a)*sq(cc))*sq(zq)));
	real yv_trans = ((((b*B)*C)+((((4*cc)*B)*yyq)*zq))-(((4*b)*sq(cc))*sq(zq)));
	real zv_trans = ((((8*B)*cc)*sq(zq))*zp);
	xCoord = ((xv_trans*zp)+(xp*zv_trans));
	yCoord = ((yv_trans*zp)+(yp*zv_trans));
	wCoord = (zv_trans*zp);
	}


return TRUE;
}

int vnode::SPP_disteq_Integer()
// **** Local Variables:
//		B
//		C
//		aa
//		bb
//		cc
//		xp
//		xq
//		xv_trans
//		xxq
//		yp
//		yq
//		yv_trans
//		yyq
//		zp
//		zq
//		zv_trans
//		zzq
// **** External Variables:
//		P.W()
//		P.X()
//		P.Y()
//		Q.W()
//		Q.X()
//		Q.Y()
//		a
//		b
//		c
// **** Sign Result Variables:

{
	int _valid=TRUE;
	 if (!(1))
		_valid=FALSE;



  rat_segment l=csite(0).rseg();
  rat_point   P=csite(1).rpnt();
  rat_point   Q=csite(2).rpnt();

  if (right_turn(l.start(),l.end(),P))
    invert_seg(l);  
    /* care for the right orientation of l */

  integer a,b,c;
  seg2line_paras(l,a,b,c);     // initializes the homogenous coords of l


	{
integer P_W___g_val = P.W();
integer P_X___g_val = P.X();
integer P_Y___g_val = P.Y();
integer Q_W___g_val = Q.W();
integer Q_X___g_val = Q.X();
integer Q_Y___g_val = Q.Y();
integer a_g_val = a;
integer b_g_val = b;
integer c_g_val = c;




	// ******************* New Declaration
	integer xp_val;

	if (_valid==TRUE)
	{
		xp_val = P_X___g_val;
	}

	// ******************* New Declaration
	integer yp_val;

	if (_valid==TRUE)
	{
		yp_val = P_Y___g_val;
	}

	// ******************* New Declaration
	integer zp_val;

	if (_valid==TRUE)
	{
		zp_val = P_W___g_val;
	}

	// ******************* New Declaration
	integer xq_val;

	if (_valid==TRUE)
	{
		xq_val = Q_X___g_val;
	}

	// ******************* New Declaration
	integer yq_val;

	if (_valid==TRUE)
	{
		yq_val = Q_Y___g_val;
	}

	// ******************* New Declaration
	integer zq_val;

	if (_valid==TRUE)
	{
		zq_val = Q_W___g_val;
	}

	// ******************* New Declaration
	integer xxq_val;

	if (_valid==TRUE)
	{
	integer tmp_372_val = xq_val*zp_val;

	integer tmp_375_val = xp_val*zq_val;

	integer tmp_376_val = tmp_372_val-tmp_375_val;

		xxq_val = tmp_376_val;
	}

	// ******************* New Declaration
	integer yyq_val;

	if (_valid==TRUE)
	{
	integer tmp_379_val = yq_val*zp_val;

	integer tmp_382_val = yp_val*zq_val;

	integer tmp_383_val = tmp_379_val-tmp_382_val;

		yyq_val = tmp_383_val;
	}

	// ******************* New Declaration
	integer zzq_val;

	if (_valid==TRUE)
	{
	integer tmp_386_val = zp_val*zq_val;

		zzq_val = tmp_386_val;
	}

	// ******************* New Declaration
	integer aa_val;

	if (_valid==TRUE)
	{
	integer tmp_389_val = a_g_val*zp_val;

		aa_val = tmp_389_val;
	}

	// ******************* New Declaration
	integer bb_val;

	if (_valid==TRUE)
	{
	integer tmp_392_val = b_g_val*zp_val;

		bb_val = tmp_392_val;
	}

	// ******************* New Declaration
	integer cc_val;

	if (_valid==TRUE)
	{
	integer tmp_395_val = a_g_val*xp_val;

	integer tmp_398_val = b_g_val*yp_val;

	integer tmp_399_val = tmp_395_val+tmp_398_val;

	integer tmp_402_val = c_g_val*zp_val;

	integer tmp_403_val = tmp_399_val+tmp_402_val;

		cc_val = tmp_403_val;
	}

	// ******************* New Declaration
	integer B_val;

	if (_valid==TRUE)
	{
	integer tmp_405_val=a_g_val*a_g_val;
	integer tmp_407_val=b_g_val*b_g_val;
	integer tmp_408_val = tmp_405_val+tmp_407_val;

		B_val = tmp_408_val;
	}

	// ******************* New Declaration
	integer C_val;

	if (_valid==TRUE)
	{
	integer tmp_410_val=xxq_val*xxq_val;
	integer tmp_412_val=yyq_val*yyq_val;
	integer tmp_413_val = tmp_410_val+tmp_412_val;

		C_val = tmp_413_val;
	}

	// ******************* New Declaration
	integer xv_trans_val;

	if (_valid==TRUE)
	{
	integer tmp_416_val = a_g_val*B_val;

	integer tmp_418_val = tmp_416_val*C_val;

	integer tmp_421_val = 4*cc_val;

	integer tmp_423_val = tmp_421_val*B_val;

	integer tmp_425_val = tmp_423_val*xxq_val;

	integer tmp_427_val = tmp_425_val*zq_val;

	integer tmp_428_val = tmp_418_val+tmp_427_val;

	integer tmp_431_val = 4*a_g_val;

	integer tmp_433_val=cc_val*cc_val;
	integer tmp_434_val = tmp_431_val*tmp_433_val;

	integer tmp_436_val=zq_val*zq_val;
	integer tmp_437_val = tmp_434_val*tmp_436_val;

	integer tmp_438_val = tmp_428_val-tmp_437_val;

		xv_trans_val = tmp_438_val;
	}

	// ******************* New Declaration
	integer yv_trans_val;

	if (_valid==TRUE)
	{
	integer tmp_441_val = b_g_val*B_val;

	integer tmp_443_val = tmp_441_val*C_val;

	integer tmp_446_val = 4*cc_val;

	integer tmp_448_val = tmp_446_val*B_val;

	integer tmp_450_val = tmp_448_val*yyq_val;

	integer tmp_452_val = tmp_450_val*zq_val;

	integer tmp_453_val = tmp_443_val+tmp_452_val;

	integer tmp_456_val = 4*b_g_val;

	integer tmp_458_val=cc_val*cc_val;
	integer tmp_459_val = tmp_456_val*tmp_458_val;

	integer tmp_461_val=zq_val*zq_val;
	integer tmp_462_val = tmp_459_val*tmp_461_val;

	integer tmp_463_val = tmp_453_val-tmp_462_val;

		yv_trans_val = tmp_463_val;
	}

	// ******************* New Declaration
	integer zv_trans_val;

	if (_valid==TRUE)
	{
	integer tmp_466_val = 8*B_val;

	integer tmp_468_val = tmp_466_val*cc_val;

	integer tmp_470_val=zq_val*zq_val;
	integer tmp_471_val = tmp_468_val*tmp_470_val;

	integer tmp_473_val = tmp_471_val*zp_val;

		zv_trans_val = tmp_473_val;
	}

	// ********************* New Assignment
	if (_valid==TRUE)
	{
	integer tmp_476_val = xv_trans_val*zp_val;

	integer tmp_479_val = xp_val*zv_trans_val;

	integer tmp_480_val = tmp_476_val+tmp_479_val;

	xCoordI = tmp_480_val;
	}

	// ********************* New Assignment
	if (_valid==TRUE)
	{
	integer tmp_483_val = yv_trans_val*zp_val;

	integer tmp_486_val = yp_val*zv_trans_val;

	integer tmp_487_val = tmp_483_val+tmp_486_val;

	yCoordI = tmp_487_val;
	}

	// ********************* New Assignment
	if (_valid==TRUE)
	{
	integer tmp_490_val = zv_trans_val*zp_val;

	wCoordI = tmp_490_val;
	}
	}


return _valid;
}

int vnode::SPP_disteq_Double()
// **** Local Variables:
//		B
//		C
//		aa
//		bb
//		cc
//		xp
//		xq
//		xv_trans
//		xxq
//		yp
//		yq
//		yv_trans
//		yyq
//		zp
//		zq
//		zv_trans
//		zzq
// **** External Variables:
//		P.W()
//		P.X()
//		P.Y()
//		Q.W()
//		Q.X()
//		Q.Y()
//		a
//		b
//		c
// **** Sign Result Variables:

{


  rat_segment l=csite(0).rseg();
  rat_point   P=csite(1).rpnt();
  rat_point   Q=csite(2).rpnt();

  if (right_turn(l.start(),l.end(),P))
    invert_seg(l);  
    /* care for the right orientation of l */

  integer a,b,c;
  seg2line_paras(l,a,b,c);     // initializes the homogenous coords of l


double P_W___g_val = P.WD();
double P_W___g_sup = float_abs(P_W___g_val);
double P_X___g_val = P.XD();
double P_X___g_sup = float_abs(P_X___g_val);
double P_Y___g_val = P.YD();
double P_Y___g_sup = float_abs(P_Y___g_val);
double Q_W___g_val = Q.WD();
double Q_W___g_sup = float_abs(Q_W___g_val);
double Q_X___g_val = Q.XD();
double Q_X___g_sup = float_abs(Q_X___g_val);
double Q_Y___g_val = Q.YD();
double Q_Y___g_sup = float_abs(Q_Y___g_val);
double a_g_val = a.to_double();
double a_g_sup = float_abs(a_g_val);
double b_g_val = b.to_double();
double b_g_sup = float_abs(b_g_val);
double c_g_val = c.to_double();
double c_g_sup = float_abs(c_g_val);




	// ******************* New Declaration
	double xp_val;
	double xp_sup;

	xp_val = P_X___g_val;
	xp_sup = P_X___g_sup;

	// ******************* New Declaration
	double yp_val;
	double yp_sup;

	yp_val = P_Y___g_val;
	yp_sup = P_Y___g_sup;

	// ******************* New Declaration
	double zp_val;
	double zp_sup;

	zp_val = P_W___g_val;
	zp_sup = P_W___g_sup;

	// ******************* New Declaration
	double xq_val;
	double xq_sup;

	xq_val = Q_X___g_val;
	xq_sup = Q_X___g_sup;

	// ******************* New Declaration
	double yq_val;
	double yq_sup;

	yq_val = Q_Y___g_val;
	yq_sup = Q_Y___g_sup;

	// ******************* New Declaration
	double zq_val;
	double zq_sup;

	zq_val = Q_W___g_val;
	zq_sup = Q_W___g_sup;

	// ******************* New Declaration
	double xxq_val;
	double xxq_sup;

	double tmp_372_val = xq_val*zp_val;
	double tmp_372_sup = xq_sup*zp_sup;

	double tmp_375_val = xp_val*zq_val;
	double tmp_375_sup = xp_sup*zq_sup;

	double tmp_376_val = tmp_372_val-tmp_375_val;
	double tmp_376_sup = tmp_372_sup+tmp_375_sup;
	{
	 static double _upper=4*eps1;
	 if (tmp_376_sup*_upper*correction<1)
	 {  tmp_376_sup = (tmp_376_val);
	   clear_sign_bit(tmp_376_sup);
	 }
	}

	xxq_val = tmp_376_val;
	xxq_sup = tmp_376_sup;

	// ******************* New Declaration
	double yyq_val;
	double yyq_sup;

	double tmp_379_val = yq_val*zp_val;
	double tmp_379_sup = yq_sup*zp_sup;

	double tmp_382_val = yp_val*zq_val;
	double tmp_382_sup = yp_sup*zq_sup;

	double tmp_383_val = tmp_379_val-tmp_382_val;
	double tmp_383_sup = tmp_379_sup+tmp_382_sup;
	{
	 static double _upper=4*eps1;
	 if (tmp_383_sup*_upper*correction<1)
	 {  tmp_383_sup = (tmp_383_val);
	   clear_sign_bit(tmp_383_sup);
	 }
	}

	yyq_val = tmp_383_val;
	yyq_sup = tmp_383_sup;

	// ******************* New Declaration
	double zzq_val;
	double zzq_sup;

	double tmp_386_val = zp_val*zq_val;
	double tmp_386_sup = zp_sup*zq_sup;

	zzq_val = tmp_386_val;
	zzq_sup = tmp_386_sup;

	// ******************* New Declaration
	double aa_val;
	double aa_sup;

	double tmp_389_val = a_g_val*zp_val;
	double tmp_389_sup = a_g_sup*zp_sup;

	aa_val = tmp_389_val;
	aa_sup = tmp_389_sup;

	// ******************* New Declaration
	double bb_val;
	double bb_sup;

	double tmp_392_val = b_g_val*zp_val;
	double tmp_392_sup = b_g_sup*zp_sup;

	bb_val = tmp_392_val;
	bb_sup = tmp_392_sup;

	// ******************* New Declaration
	double cc_val;
	double cc_sup;

	double tmp_395_val = a_g_val*xp_val;
	double tmp_395_sup = a_g_sup*xp_sup;

	double tmp_398_val = b_g_val*yp_val;
	double tmp_398_sup = b_g_sup*yp_sup;

	double tmp_399_val = tmp_395_val+tmp_398_val;
	double tmp_399_sup = tmp_395_sup+tmp_398_sup;
	{
	 static double _upper=4*eps1;
	 if (tmp_399_sup*_upper*correction<1)
	 {  tmp_399_sup = (tmp_399_val);
	   clear_sign_bit(tmp_399_sup);
	 }
	}

	double tmp_402_val = c_g_val*zp_val;
	double tmp_402_sup = c_g_sup*zp_sup;

	double tmp_403_val = tmp_399_val+tmp_402_val;
	double tmp_403_sup = tmp_399_sup+tmp_402_sup;
	{
	 static double _upper=5*eps1;
	 if (tmp_403_sup*_upper*correction<1)
	 {  tmp_403_sup = (tmp_403_val);
	   clear_sign_bit(tmp_403_sup);
	 }
	}

	cc_val = tmp_403_val;
	cc_sup = tmp_403_sup;

	// ******************* New Declaration
	double B_val;
	double B_sup;

	double tmp_405_val=a_g_val*a_g_val;
	double tmp_405_sup=a_g_sup*a_g_sup;

	double tmp_407_val=b_g_val*b_g_val;
	double tmp_407_sup=b_g_sup*b_g_sup;

	double tmp_408_val = tmp_405_val+tmp_407_val;
	double tmp_408_sup = tmp_405_sup+tmp_407_sup;
	{
	 static double _upper=4*eps1;
	 if (tmp_408_sup*_upper*correction<1)
	 {  tmp_408_sup = (tmp_408_val);
	   clear_sign_bit(tmp_408_sup);
	 }
	}

	B_val = tmp_408_val;
	B_sup = tmp_408_sup;

	// ******************* New Declaration
	double C_val;
	double C_sup;

	double tmp_410_val=xxq_val*xxq_val;
	double tmp_410_sup=xxq_sup*xxq_sup;

	double tmp_412_val=yyq_val*yyq_val;
	double tmp_412_sup=yyq_sup*yyq_sup;

	double tmp_413_val = tmp_410_val+tmp_412_val;
	double tmp_413_sup = tmp_410_sup+tmp_412_sup;
	{
	 static double _upper=10*eps1;
	 if (tmp_413_sup*_upper*correction<1)
	 {  tmp_413_sup = (tmp_413_val);
	   clear_sign_bit(tmp_413_sup);
	 }
	}

	C_val = tmp_413_val;
	C_sup = tmp_413_sup;

	// ******************* New Declaration
	double xv_trans_val;
	double xv_trans_sup;

	double tmp_416_val = a_g_val*B_val;
	double tmp_416_sup = a_g_sup*B_sup;

	double tmp_418_val = tmp_416_val*C_val;
	double tmp_418_sup = tmp_416_sup*C_sup;

	double tmp_421_val = 4*cc_val;
	double tmp_421_sup = 4*cc_sup;

	double tmp_423_val = tmp_421_val*B_val;
	double tmp_423_sup = tmp_421_sup*B_sup;

	double tmp_425_val = tmp_423_val*xxq_val;
	double tmp_425_sup = tmp_423_sup*xxq_sup;

	double tmp_427_val = tmp_425_val*zq_val;
	double tmp_427_sup = tmp_425_sup*zq_sup;

	double tmp_428_val = tmp_418_val+tmp_427_val;
	double tmp_428_sup = tmp_418_sup+tmp_427_sup;
	{
	 static double _upper=19*eps1;
	 if (tmp_428_sup*_upper*correction<1)
	 {  tmp_428_sup = (tmp_428_val);
	   clear_sign_bit(tmp_428_sup);
	 }
	}

	double tmp_431_val = 4*a_g_val;
	double tmp_431_sup = 4*a_g_sup;

	double tmp_433_val=cc_val*cc_val;
	double tmp_433_sup=cc_sup*cc_sup;

	double tmp_434_val = tmp_431_val*tmp_433_val;
	double tmp_434_sup = tmp_431_sup*tmp_433_sup;

	double tmp_436_val=zq_val*zq_val;
	double tmp_436_sup=zq_sup*zq_sup;

	double tmp_437_val = tmp_434_val*tmp_436_val;
	double tmp_437_sup = tmp_434_sup*tmp_436_sup;

	double tmp_438_val = tmp_428_val-tmp_437_val;
	double tmp_438_sup = tmp_428_sup+tmp_437_sup;
	{
	 static double _upper=20*eps1;
	 if (tmp_438_sup*_upper*correction<1)
	 {  tmp_438_sup = (tmp_438_val);
	   clear_sign_bit(tmp_438_sup);
	 }
	}

	xv_trans_val = tmp_438_val;
	xv_trans_sup = tmp_438_sup;

	// ******************* New Declaration
	double yv_trans_val;
	double yv_trans_sup;

	double tmp_441_val = b_g_val*B_val;
	double tmp_441_sup = b_g_sup*B_sup;

	double tmp_443_val = tmp_441_val*C_val;
	double tmp_443_sup = tmp_441_sup*C_sup;

	double tmp_446_val = 4*cc_val;
	double tmp_446_sup = 4*cc_sup;

	double tmp_448_val = tmp_446_val*B_val;
	double tmp_448_sup = tmp_446_sup*B_sup;

	double tmp_450_val = tmp_448_val*yyq_val;
	double tmp_450_sup = tmp_448_sup*yyq_sup;

	double tmp_452_val = tmp_450_val*zq_val;
	double tmp_452_sup = tmp_450_sup*zq_sup;

	double tmp_453_val = tmp_443_val+tmp_452_val;
	double tmp_453_sup = tmp_443_sup+tmp_452_sup;
	{
	 static double _upper=19*eps1;
	 if (tmp_453_sup*_upper*correction<1)
	 {  tmp_453_sup = (tmp_453_val);
	   clear_sign_bit(tmp_453_sup);
	 }
	}

	double tmp_456_val = 4*b_g_val;
	double tmp_456_sup = 4*b_g_sup;

	double tmp_458_val=cc_val*cc_val;
	double tmp_458_sup=cc_sup*cc_sup;

	double tmp_459_val = tmp_456_val*tmp_458_val;
	double tmp_459_sup = tmp_456_sup*tmp_458_sup;

	double tmp_461_val=zq_val*zq_val;
	double tmp_461_sup=zq_sup*zq_sup;

	double tmp_462_val = tmp_459_val*tmp_461_val;
	double tmp_462_sup = tmp_459_sup*tmp_461_sup;

	double tmp_463_val = tmp_453_val-tmp_462_val;
	double tmp_463_sup = tmp_453_sup+tmp_462_sup;
	{
	 static double _upper=20*eps1;
	 if (tmp_463_sup*_upper*correction<1)
	 {  tmp_463_sup = (tmp_463_val);
	   clear_sign_bit(tmp_463_sup);
	 }
	}

	yv_trans_val = tmp_463_val;
	yv_trans_sup = tmp_463_sup;

	// ******************* New Declaration
	double zv_trans_val;
	double zv_trans_sup;

	double tmp_466_val = 8*B_val;
	double tmp_466_sup = 8*B_sup;

	double tmp_468_val = tmp_466_val*cc_val;
	double tmp_468_sup = tmp_466_sup*cc_sup;

	double tmp_470_val=zq_val*zq_val;
	double tmp_470_sup=zq_sup*zq_sup;

	double tmp_471_val = tmp_468_val*tmp_470_val;
	double tmp_471_sup = tmp_468_sup*tmp_470_sup;

	double tmp_473_val = tmp_471_val*zp_val;
	double tmp_473_sup = tmp_471_sup*zp_sup;

	zv_trans_val = tmp_473_val;
	zv_trans_sup = tmp_473_sup;

	// ********************* New Assignment
	double tmp_476_val = xv_trans_val*zp_val;
	double tmp_476_sup = xv_trans_sup*zp_sup;

	double tmp_479_val = xp_val*zv_trans_val;
	double tmp_479_sup = xp_sup*zv_trans_sup;

	double tmp_480_val = tmp_476_val+tmp_479_val;
	double tmp_480_sup = tmp_476_sup+tmp_479_sup;
	{
	 static double _upper=23*eps1;
	 if (tmp_480_sup*_upper*correction<1)
	 {  tmp_480_sup = (tmp_480_val);
	   clear_sign_bit(tmp_480_sup);
	 }
	}

	xCoordD = tmp_480_val;
	xCoordDS = tmp_480_sup;
/* Index of xCoord is 23 */

	// ********************* New Assignment
	double tmp_483_val = yv_trans_val*zp_val;
	double tmp_483_sup = yv_trans_sup*zp_sup;

	double tmp_486_val = yp_val*zv_trans_val;
	double tmp_486_sup = yp_sup*zv_trans_sup;

	double tmp_487_val = tmp_483_val+tmp_486_val;
	double tmp_487_sup = tmp_483_sup+tmp_486_sup;
	{
	 static double _upper=23*eps1;
	 if (tmp_487_sup*_upper*correction<1)
	 {  tmp_487_sup = (tmp_487_val);
	   clear_sign_bit(tmp_487_sup);
	 }
	}

	yCoordD = tmp_487_val;
	yCoordDS = tmp_487_sup;
/* Index of yCoord is 23 */

	// ********************* New Assignment
	double tmp_490_val = zv_trans_val*zp_val;
	double tmp_490_sup = zv_trans_sup*zp_sup;

	wCoordD = tmp_490_val;
	wCoordDS = tmp_490_sup;
/* Index of wCoord is 19 */


return TRUE;
}





int vnode::SSP_notcoll_Exact()
// **** Local Variables:
//		D
//		D12
//		D12_2
//		F
//		F_W
//		G
//		G_W
//		I
//		J
//		X
//		cc1
//		cc2
//		xp
//		xv_trans
//		yp
//		yv_trans
//		zp
//		zv_trans
// **** External Variables:
//		P.W()
//		P.X()
//		P.Y()
//		a1
//		a2
//		b1
//		b2
//		c1
//		c2
//		kappa
//		sign_r
//		sign_s
// **** Sign Result Variables:

{


  rat_segment l1=csite(0).rseg();
  rat_segment l2=csite(1).rseg();
  rat_point   P =csite(2).rpnt();

    int l1_p_or = orientation(l1,P);
    int l2_p_or = orientation(l2,P);


    if (l1_p_or == RIGHT)
      invert_seg(l1);
    if (l2_p_or == RIGHT)
      invert_seg(l2);

    integer dx1 = l1.dx();
    integer dy1 = l1.dy();
    integer dx2 = l2.dx();
    integer dy2 = l2.dy();
    
    if (l1_p_or == ON)
    {
      if (dx1*dy2 == dx2*dy1 && 
          sign(dx1) == sign(dx2) && sign (dy1) == sign(dy2) ||
          P == l1.start())
        // l1 and l2 are parallel and equally directed or
        // l1 and l2 are not parallel and the node is on the right
        invert_seg(l1);
    }
    if (l2_p_or == ON)
    {
      if (dx1*dy2 == dx2*dy1 && 
          sign(dx1) == sign(dx2) && sign(dy1) == sign(dy2) ||
          P == l2.end())
        invert_seg(l2);
    }
    integer a1,b1,c1,a2,b2,c2;
  
    seg2line_paras(l1,a1,b1,c1); // initializes the homogenous coords of l1
    seg2line_paras(l2,a2,b2,c2); // initializes the homogenous coords of l2

    int sign_s, sign_r;
    if (a1 == 0 && a2 == 0) 
      sign_s = sign(b1); 
      // the trivial case with x-axis parallel lines
      // note that |sign(b2) != sign(b1)|
    else
      sign_s = sign(b1*abs(a2) - b2*abs(a1));
      // the previous case

     if (b1 == 0 && b2 == 0) 
      sign_r = sign(a1); 
      // the trivial case with y-axis parallel lines
      // note that |sign(a2) != sign(a1)|
    else
      sign_r = sign(a1*abs(b2) - a2*abs(b1));
      // the previous case

    int kappa = -1; // compare Lemma 12


	{
	real xp = P.X();
	real yp = P.Y();
	real zp = P.W();
	real cc1 = (((a1*xp)+(b1*yp))+(c1*zp));
	real cc2 = (((a2*xp)+(b2*yp))+(c2*zp));
	real D12_2 = ((sq(a1)+sq(b1))*(sq(a2)+sq(b2)));
	real D12 = sqrt(D12_2);
	real D = ((2*cc1)*cc2);
	real F = (D*(((b1*b2)-(a1*a2))+D12));
	real G = (D*(((a1*a2)-(b1*b2))+D12));
	real F_W = sqrt(F);
	real G_W = sqrt(G);
	real X = (((-(a1)*a2)-(b1*b2))+D12);
	real I = ((b1*cc2)+(b2*cc1));
	real J = ((a1*cc2)+(a2*cc1));
	real xv_trans = (J+((kappa*sign_s)*G_W));
	real yv_trans = (I-((kappa*sign_r)*F_W));
	real zv_trans = (zp*X);
	xCoord = ((xv_trans*zp)+(xp*zv_trans));
	yCoord = ((yv_trans*zp)+(yp*zv_trans));
	wCoord = (zv_trans*zp);
	}


return TRUE;
}

int vnode::SSP_notcoll_Integer()
// **** Local Variables:
//		D
//		D12
//		D12_2
//		F
//		F_W
//		G
//		G_W
//		I
//		J
//		X
//		cc1
//		cc2
//		xp
//		xv_trans
//		yp
//		yv_trans
//		zp
//		zv_trans
// **** External Variables:
//		P.W()
//		P.X()
//		P.Y()
//		a1
//		a2
//		b1
//		b2
//		c1
//		c2
//		kappa
//		sign_r
//		sign_s
// **** Sign Result Variables:

{
	int _valid=TRUE;
	 if (!(1))
		_valid=FALSE;



  rat_segment l1=csite(0).rseg();
  rat_segment l2=csite(1).rseg();
  rat_point   P =csite(2).rpnt();

    int l1_p_or = orientation(l1,P);
    int l2_p_or = orientation(l2,P);


    if (l1_p_or == RIGHT)
      invert_seg(l1);
    if (l2_p_or == RIGHT)
      invert_seg(l2);

    integer dx1 = l1.dx();
    integer dy1 = l1.dy();
    integer dx2 = l2.dx();
    integer dy2 = l2.dy();
    
    if (l1_p_or == ON)
    {
      if (dx1*dy2 == dx2*dy1 && 
          sign(dx1) == sign(dx2) && sign (dy1) == sign(dy2) ||
          P == l1.start())
        // l1 and l2 are parallel and equally directed or
        // l1 and l2 are not parallel and the node is on the right
        invert_seg(l1);
    }
    if (l2_p_or == ON)
    {
      if (dx1*dy2 == dx2*dy1 && 
          sign(dx1) == sign(dx2) && sign(dy1) == sign(dy2) ||
          P == l2.end())
        invert_seg(l2);
    }
    integer a1,b1,c1,a2,b2,c2;
  
    seg2line_paras(l1,a1,b1,c1); // initializes the homogenous coords of l1
    seg2line_paras(l2,a2,b2,c2); // initializes the homogenous coords of l2

    int sign_s, sign_r;
    if (a1 == 0 && a2 == 0) 
      sign_s = sign(b1); 
      // the trivial case with x-axis parallel lines
      // note that |sign(b2) != sign(b1)|
    else
      sign_s = sign(b1*abs(a2) - b2*abs(a1));
      // the previous case

     if (b1 == 0 && b2 == 0) 
      sign_r = sign(a1); 
      // the trivial case with y-axis parallel lines
      // note that |sign(a2) != sign(a1)|
    else
      sign_r = sign(a1*abs(b2) - a2*abs(b1));
      // the previous case

    int kappa = -1; // compare Lemma 12


	{
integer P_W___g_val = P.W();
integer P_X___g_val = P.X();
integer P_Y___g_val = P.Y();
integer a1_g_val = a1;
integer a2_g_val = a2;
integer b1_g_val = b1;
integer b2_g_val = b2;
integer c1_g_val = c1;
integer c2_g_val = c2;
integer kappa_g_val = kappa;
integer sign_r_g_val = sign_r;
integer sign_s_g_val = sign_s;




	// ******************* New Declaration
	integer xp_val;

	if (_valid==TRUE)
	{
		xp_val = P_X___g_val;
	}

	// ******************* New Declaration
	integer yp_val;

	if (_valid==TRUE)
	{
		yp_val = P_Y___g_val;
	}

	// ******************* New Declaration
	integer zp_val;

	if (_valid==TRUE)
	{
		zp_val = P_W___g_val;
	}

	// ******************* New Declaration
	integer cc1_val;

	if (_valid==TRUE)
	{
	integer tmp_497_val = a1_g_val*xp_val;

	integer tmp_500_val = b1_g_val*yp_val;

	integer tmp_501_val = tmp_497_val+tmp_500_val;

	integer tmp_504_val = c1_g_val*zp_val;

	integer tmp_505_val = tmp_501_val+tmp_504_val;

		cc1_val = tmp_505_val;
	}

	// ******************* New Declaration
	integer cc2_val;

	if (_valid==TRUE)
	{
	integer tmp_508_val = a2_g_val*xp_val;

	integer tmp_511_val = b2_g_val*yp_val;

	integer tmp_512_val = tmp_508_val+tmp_511_val;

	integer tmp_515_val = c2_g_val*zp_val;

	integer tmp_516_val = tmp_512_val+tmp_515_val;

		cc2_val = tmp_516_val;
	}

	// ******************* New Declaration
	integer D12_2_val;

	if (_valid==TRUE)
	{
	integer tmp_518_val=a1_g_val*a1_g_val;
	integer tmp_520_val=b1_g_val*b1_g_val;
	integer tmp_521_val = tmp_518_val+tmp_520_val;

	integer tmp_523_val=a2_g_val*a2_g_val;
	integer tmp_525_val=b2_g_val*b2_g_val;
	integer tmp_526_val = tmp_523_val+tmp_525_val;

	integer tmp_527_val = tmp_521_val*tmp_526_val;

		D12_2_val = tmp_527_val;
	}

	// ******************* New Declaration
	integer D12_val;

	if (_valid==TRUE)
	{
	integer tmp_529_val;
	if (D12_2_val <0) _valid=FALSE;
	else
	{
	  tmp_529_val = sqrt(D12_2_val);
	  if (tmp_529_val*tmp_529_val != D12_2_val) _valid=FALSE;
	}
		D12_val = tmp_529_val;
	}

	// ******************* New Declaration
	integer D_val;

	if (_valid==TRUE)
	{
	integer tmp_532_val = 2*cc1_val;

	integer tmp_534_val = tmp_532_val*cc2_val;

		D_val = tmp_534_val;
	}

	// ******************* New Declaration
	integer F_val;

	if (_valid==TRUE)
	{
	integer tmp_538_val = b1_g_val*b2_g_val;

	integer tmp_541_val = a1_g_val*a2_g_val;

	integer tmp_542_val = tmp_538_val-tmp_541_val;

	integer tmp_544_val = tmp_542_val+D12_val;

	integer tmp_545_val = D_val*tmp_544_val;

		F_val = tmp_545_val;
	}

	// ******************* New Declaration
	integer G_val;

	if (_valid==TRUE)
	{
	integer tmp_549_val = a1_g_val*a2_g_val;

	integer tmp_552_val = b1_g_val*b2_g_val;

	integer tmp_553_val = tmp_549_val-tmp_552_val;

	integer tmp_555_val = tmp_553_val+D12_val;

	integer tmp_556_val = D_val*tmp_555_val;

		G_val = tmp_556_val;
	}

	// ******************* New Declaration
	integer F_W_val;

	if (_valid==TRUE)
	{
	integer tmp_558_val;
	if (F_val <0) _valid=FALSE;
	else
	{
	  tmp_558_val = sqrt(F_val);
	  if (tmp_558_val*tmp_558_val != F_val) _valid=FALSE;
	}
		F_W_val = tmp_558_val;
	}

	// ******************* New Declaration
	integer G_W_val;

	if (_valid==TRUE)
	{
	integer tmp_560_val;
	if (G_val <0) _valid=FALSE;
	else
	{
	  tmp_560_val = sqrt(G_val);
	  if (tmp_560_val*tmp_560_val != G_val) _valid=FALSE;
	}
		G_W_val = tmp_560_val;
	}

	// ******************* New Declaration
	integer X_val;

	if (_valid==TRUE)
	{
	integer tmp_562_val = -(a1_g_val);
	integer tmp_564_val = tmp_562_val*a2_g_val;

	integer tmp_567_val = b1_g_val*b2_g_val;

	integer tmp_568_val = tmp_564_val-tmp_567_val;

	integer tmp_570_val = tmp_568_val+D12_val;

		X_val = tmp_570_val;
	}

	// ******************* New Declaration
	integer I_val;

	if (_valid==TRUE)
	{
	integer tmp_573_val = b1_g_val*cc2_val;

	integer tmp_576_val = b2_g_val*cc1_val;

	integer tmp_577_val = tmp_573_val+tmp_576_val;

		I_val = tmp_577_val;
	}

	// ******************* New Declaration
	integer J_val;

	if (_valid==TRUE)
	{
	integer tmp_580_val = a1_g_val*cc2_val;

	integer tmp_583_val = a2_g_val*cc1_val;

	integer tmp_584_val = tmp_580_val+tmp_583_val;

		J_val = tmp_584_val;
	}

	// ******************* New Declaration
	integer xv_trans_val;

	if (_valid==TRUE)
	{
	integer tmp_588_val = kappa_g_val*sign_s_g_val;

	integer tmp_590_val = tmp_588_val*G_W_val;

	integer tmp_591_val = J_val+tmp_590_val;

		xv_trans_val = tmp_591_val;
	}

	// ******************* New Declaration
	integer yv_trans_val;

	if (_valid==TRUE)
	{
	integer tmp_595_val = kappa_g_val*sign_r_g_val;

	integer tmp_597_val = tmp_595_val*F_W_val;

	integer tmp_598_val = I_val-tmp_597_val;

		yv_trans_val = tmp_598_val;
	}

	// ******************* New Declaration
	integer zv_trans_val;

	if (_valid==TRUE)
	{
	integer tmp_601_val = zp_val*X_val;

		zv_trans_val = tmp_601_val;
	}

	// ********************* New Assignment
	if (_valid==TRUE)
	{
	integer tmp_604_val = xv_trans_val*zp_val;

	integer tmp_607_val = xp_val*zv_trans_val;

	integer tmp_608_val = tmp_604_val+tmp_607_val;

	xCoordI = tmp_608_val;
	}

	// ********************* New Assignment
	if (_valid==TRUE)
	{
	integer tmp_611_val = yv_trans_val*zp_val;

	integer tmp_614_val = yp_val*zv_trans_val;

	integer tmp_615_val = tmp_611_val+tmp_614_val;

	yCoordI = tmp_615_val;
	}

	// ********************* New Assignment
	if (_valid==TRUE)
	{
	integer tmp_618_val = zv_trans_val*zp_val;

	wCoordI = tmp_618_val;
	}
	}


return _valid;
}

int vnode::SSP_notcoll_Double()
// **** Local Variables:
//		D
//		D12
//		D12_2
//		F
//		F_W
//		G
//		G_W
//		I
//		J
//		X
//		cc1
//		cc2
//		xp
//		xv_trans
//		yp
//		yv_trans
//		zp
//		zv_trans
// **** External Variables:
//		P.W()
//		P.X()
//		P.Y()
//		a1
//		a2
//		b1
//		b2
//		c1
//		c2
//		kappa
//		sign_r
//		sign_s
// **** Sign Result Variables:

{


  rat_segment l1=csite(0).rseg();
  rat_segment l2=csite(1).rseg();
  rat_point   P =csite(2).rpnt();

    int l1_p_or = orientation(l1,P);
    int l2_p_or = orientation(l2,P);


    if (l1_p_or == RIGHT)
      invert_seg(l1);
    if (l2_p_or == RIGHT)
      invert_seg(l2);

    integer dx1 = l1.dx();
    integer dy1 = l1.dy();
    integer dx2 = l2.dx();
    integer dy2 = l2.dy();
    
    if (l1_p_or == ON)
    {
      if (dx1*dy2 == dx2*dy1 && 
          sign(dx1) == sign(dx2) && sign (dy1) == sign(dy2) ||
          P == l1.start())
        // l1 and l2 are parallel and equally directed or
        // l1 and l2 are not parallel and the node is on the right
        invert_seg(l1);
    }
    if (l2_p_or == ON)
    {
      if (dx1*dy2 == dx2*dy1 && 
          sign(dx1) == sign(dx2) && sign(dy1) == sign(dy2) ||
          P == l2.end())
        invert_seg(l2);
    }
    integer a1,b1,c1,a2,b2,c2;
  
    seg2line_paras(l1,a1,b1,c1); // initializes the homogenous coords of l1
    seg2line_paras(l2,a2,b2,c2); // initializes the homogenous coords of l2

    int sign_s, sign_r;
    if (a1 == 0 && a2 == 0) 
      sign_s = sign(b1); 
      // the trivial case with x-axis parallel lines
      // note that |sign(b2) != sign(b1)|
    else
      sign_s = sign(b1*abs(a2) - b2*abs(a1));
      // the previous case

     if (b1 == 0 && b2 == 0) 
      sign_r = sign(a1); 
      // the trivial case with y-axis parallel lines
      // note that |sign(a2) != sign(a1)|
    else
      sign_r = sign(a1*abs(b2) - a2*abs(b1));
      // the previous case

    int kappa = -1; // compare Lemma 12


double P_W___g_val = P.WD();
double P_W___g_sup = float_abs(P_W___g_val);
double P_X___g_val = P.XD();
double P_X___g_sup = float_abs(P_X___g_val);
double P_Y___g_val = P.YD();
double P_Y___g_sup = float_abs(P_Y___g_val);
double a1_g_val = a1.to_double();
double a1_g_sup = float_abs(a1_g_val);
double a2_g_val = a2.to_double();
double a2_g_sup = float_abs(a2_g_val);
double b1_g_val = b1.to_double();
double b1_g_sup = float_abs(b1_g_val);
double b2_g_val = b2.to_double();
double b2_g_sup = float_abs(b2_g_val);
double c1_g_val = c1.to_double();
double c1_g_sup = float_abs(c1_g_val);
double c2_g_val = c2.to_double();
double c2_g_sup = float_abs(c2_g_val);
double kappa_g_val = kappa;
double kappa_g_sup = float_abs(kappa_g_val);
double sign_r_g_val = sign_r;
double sign_r_g_sup = float_abs(sign_r_g_val);
double sign_s_g_val = sign_s;
double sign_s_g_sup = float_abs(sign_s_g_val);




	// ******************* New Declaration
	double xp_val;
	double xp_sup;

	xp_val = P_X___g_val;
	xp_sup = P_X___g_sup;

	// ******************* New Declaration
	double yp_val;
	double yp_sup;

	yp_val = P_Y___g_val;
	yp_sup = P_Y___g_sup;

	// ******************* New Declaration
	double zp_val;
	double zp_sup;

	zp_val = P_W___g_val;
	zp_sup = P_W___g_sup;

	// ******************* New Declaration
	double cc1_val;
	double cc1_sup;

	double tmp_497_val = a1_g_val*xp_val;
	double tmp_497_sup = a1_g_sup*xp_sup;

	double tmp_500_val = b1_g_val*yp_val;
	double tmp_500_sup = b1_g_sup*yp_sup;

	double tmp_501_val = tmp_497_val+tmp_500_val;
	double tmp_501_sup = tmp_497_sup+tmp_500_sup;
	{
	 static double _upper=4*eps1;
	 if (tmp_501_sup*_upper*correction<1)
	 {  tmp_501_sup = (tmp_501_val);
	   clear_sign_bit(tmp_501_sup);
	 }
	}

	double tmp_504_val = c1_g_val*zp_val;
	double tmp_504_sup = c1_g_sup*zp_sup;

	double tmp_505_val = tmp_501_val+tmp_504_val;
	double tmp_505_sup = tmp_501_sup+tmp_504_sup;
	{
	 static double _upper=5*eps1;
	 if (tmp_505_sup*_upper*correction<1)
	 {  tmp_505_sup = (tmp_505_val);
	   clear_sign_bit(tmp_505_sup);
	 }
	}

	cc1_val = tmp_505_val;
	cc1_sup = tmp_505_sup;

	// ******************* New Declaration
	double cc2_val;
	double cc2_sup;

	double tmp_508_val = a2_g_val*xp_val;
	double tmp_508_sup = a2_g_sup*xp_sup;

	double tmp_511_val = b2_g_val*yp_val;
	double tmp_511_sup = b2_g_sup*yp_sup;

	double tmp_512_val = tmp_508_val+tmp_511_val;
	double tmp_512_sup = tmp_508_sup+tmp_511_sup;
	{
	 static double _upper=4*eps1;
	 if (tmp_512_sup*_upper*correction<1)
	 {  tmp_512_sup = (tmp_512_val);
	   clear_sign_bit(tmp_512_sup);
	 }
	}

	double tmp_515_val = c2_g_val*zp_val;
	double tmp_515_sup = c2_g_sup*zp_sup;

	double tmp_516_val = tmp_512_val+tmp_515_val;
	double tmp_516_sup = tmp_512_sup+tmp_515_sup;
	{
	 static double _upper=5*eps1;
	 if (tmp_516_sup*_upper*correction<1)
	 {  tmp_516_sup = (tmp_516_val);
	   clear_sign_bit(tmp_516_sup);
	 }
	}

	cc2_val = tmp_516_val;
	cc2_sup = tmp_516_sup;

	// ******************* New Declaration
	double D12_2_val;
	double D12_2_sup;

	double tmp_518_val=a1_g_val*a1_g_val;
	double tmp_518_sup=a1_g_sup*a1_g_sup;

	double tmp_520_val=b1_g_val*b1_g_val;
	double tmp_520_sup=b1_g_sup*b1_g_sup;

	double tmp_521_val = tmp_518_val+tmp_520_val;
	double tmp_521_sup = tmp_518_sup+tmp_520_sup;
	{
	 static double _upper=4*eps1;
	 if (tmp_521_sup*_upper*correction<1)
	 {  tmp_521_sup = (tmp_521_val);
	   clear_sign_bit(tmp_521_sup);
	 }
	}

	double tmp_523_val=a2_g_val*a2_g_val;
	double tmp_523_sup=a2_g_sup*a2_g_sup;

	double tmp_525_val=b2_g_val*b2_g_val;
	double tmp_525_sup=b2_g_sup*b2_g_sup;

	double tmp_526_val = tmp_523_val+tmp_525_val;
	double tmp_526_sup = tmp_523_sup+tmp_525_sup;
	{
	 static double _upper=4*eps1;
	 if (tmp_526_sup*_upper*correction<1)
	 {  tmp_526_sup = (tmp_526_val);
	   clear_sign_bit(tmp_526_sup);
	 }
	}

	double tmp_527_val = tmp_521_val*tmp_526_val;
	double tmp_527_sup = tmp_521_sup*tmp_526_sup;

	D12_2_val = tmp_527_val;
	D12_2_sup = tmp_527_sup;

	// ******************* New Declaration
	double D12_val;
	double D12_sup;

	double tmp_529_val=NaN_double;
	double tmp_529_sup=pInf_double;
	if ( D12_2_sup==0 )
	   tmp_529_val=tmp_529_sup=0;
	else
	if (D12_2_sup*(eps1*9)*correction<1)
	{  tmp_529_val = sqrt(D12_2_val);
	   tmp_529_sup = tmp_529_val;
	}
	else
	{   if (D12_2_val==0)
	    { tmp_529_val=0; 
	      tmp_529_sup=sqrt(D12_2_sup)*sqrtMul;
	    }
	    else
	    {
	    tmp_529_val = sqrt(D12_2_val);
	    tmp_529_sup = (D12_2_sup/D12_2_val)*tmp_529_val;
	    }
	}
	D12_val = tmp_529_val;
	D12_sup = tmp_529_sup;

	// ******************* New Declaration
	double D_val;
	double D_sup;

	double tmp_532_val = 2*cc1_val;
	double tmp_532_sup = 2*cc1_sup;

	double tmp_534_val = tmp_532_val*cc2_val;
	double tmp_534_sup = tmp_532_sup*cc2_sup;

	D_val = tmp_534_val;
	D_sup = tmp_534_sup;

	// ******************* New Declaration
	double F_val;
	double F_sup;

	double tmp_538_val = b1_g_val*b2_g_val;
	double tmp_538_sup = b1_g_sup*b2_g_sup;

	double tmp_541_val = a1_g_val*a2_g_val;
	double tmp_541_sup = a1_g_sup*a2_g_sup;

	double tmp_542_val = tmp_538_val-tmp_541_val;
	double tmp_542_sup = tmp_538_sup+tmp_541_sup;
	{
	 static double _upper=4*eps1;
	 if (tmp_542_sup*_upper*correction<1)
	 {  tmp_542_sup = (tmp_542_val);
	   clear_sign_bit(tmp_542_sup);
	 }
	}

	double tmp_544_val = tmp_542_val+D12_val;
	double tmp_544_sup = tmp_542_sup+D12_sup;
	{
	 static double _upper=10*eps1;
	 if (tmp_544_sup*_upper*correction<1)
	 {  tmp_544_sup = (tmp_544_val);
	   clear_sign_bit(tmp_544_sup);
	 }
	}

	double tmp_545_val = D_val*tmp_544_val;
	double tmp_545_sup = D_sup*tmp_544_sup;

	F_val = tmp_545_val;
	F_sup = tmp_545_sup;

	// ******************* New Declaration
	double G_val;
	double G_sup;

	double tmp_549_val = a1_g_val*a2_g_val;
	double tmp_549_sup = a1_g_sup*a2_g_sup;

	double tmp_552_val = b1_g_val*b2_g_val;
	double tmp_552_sup = b1_g_sup*b2_g_sup;

	double tmp_553_val = tmp_549_val-tmp_552_val;
	double tmp_553_sup = tmp_549_sup+tmp_552_sup;
	{
	 static double _upper=4*eps1;
	 if (tmp_553_sup*_upper*correction<1)
	 {  tmp_553_sup = (tmp_553_val);
	   clear_sign_bit(tmp_553_sup);
	 }
	}

	double tmp_555_val = tmp_553_val+D12_val;
	double tmp_555_sup = tmp_553_sup+D12_sup;
	{
	 static double _upper=10*eps1;
	 if (tmp_555_sup*_upper*correction<1)
	 {  tmp_555_sup = (tmp_555_val);
	   clear_sign_bit(tmp_555_sup);
	 }
	}

	double tmp_556_val = D_val*tmp_555_val;
	double tmp_556_sup = D_sup*tmp_555_sup;

	G_val = tmp_556_val;
	G_sup = tmp_556_sup;

	// ******************* New Declaration
	double F_W_val;
	double F_W_sup;

	double tmp_558_val=NaN_double;
	double tmp_558_sup=pInf_double;
	if (F_val<0) ;
	else
	if ( F_sup==0 )
	   tmp_558_val=tmp_558_sup=0;
	else
	{   if (F_val==0)
	    { tmp_558_val=0; 
	      tmp_558_sup=sqrt(F_sup)*sqrtMul;
	    }
	    else
	    {
	    tmp_558_val = sqrt(F_val);
	    tmp_558_sup = (F_sup/F_val)*tmp_558_val;
	    }
	}
	F_W_val = tmp_558_val;
	F_W_sup = tmp_558_sup;

	// ******************* New Declaration
	double G_W_val;
	double G_W_sup;

	double tmp_560_val=NaN_double;
	double tmp_560_sup=pInf_double;
	if (G_val<0) ;
	else
	if ( G_sup==0 )
	   tmp_560_val=tmp_560_sup=0;
	else
	{   if (G_val==0)
	    { tmp_560_val=0; 
	      tmp_560_sup=sqrt(G_sup)*sqrtMul;
	    }
	    else
	    {
	    tmp_560_val = sqrt(G_val);
	    tmp_560_sup = (G_sup/G_val)*tmp_560_val;
	    }
	}
	G_W_val = tmp_560_val;
	G_W_sup = tmp_560_sup;

	// ******************* New Declaration
	double X_val;
	double X_sup;

	double tmp_562_val = -(a1_g_val);
	double tmp_562_sup = a1_g_sup;
	double tmp_564_val = tmp_562_val*a2_g_val;
	double tmp_564_sup = tmp_562_sup*a2_g_sup;

	double tmp_567_val = b1_g_val*b2_g_val;
	double tmp_567_sup = b1_g_sup*b2_g_sup;

	double tmp_568_val = tmp_564_val-tmp_567_val;
	double tmp_568_sup = tmp_564_sup+tmp_567_sup;
	{
	 static double _upper=4*eps1;
	 if (tmp_568_sup*_upper*correction<1)
	 {  tmp_568_sup = (tmp_568_val);
	   clear_sign_bit(tmp_568_sup);
	 }
	}

	double tmp_570_val = tmp_568_val+D12_val;
	double tmp_570_sup = tmp_568_sup+D12_sup;
	{
	 static double _upper=10*eps1;
	 if (tmp_570_sup*_upper*correction<1)
	 {  tmp_570_sup = (tmp_570_val);
	   clear_sign_bit(tmp_570_sup);
	 }
	}

	X_val = tmp_570_val;
	X_sup = tmp_570_sup;

	// ******************* New Declaration
	double I_val;
	double I_sup;

	double tmp_573_val = b1_g_val*cc2_val;
	double tmp_573_sup = b1_g_sup*cc2_sup;

	double tmp_576_val = b2_g_val*cc1_val;
	double tmp_576_sup = b2_g_sup*cc1_sup;

	double tmp_577_val = tmp_573_val+tmp_576_val;
	double tmp_577_sup = tmp_573_sup+tmp_576_sup;
	{
	 static double _upper=8*eps1;
	 if (tmp_577_sup*_upper*correction<1)
	 {  tmp_577_sup = (tmp_577_val);
	   clear_sign_bit(tmp_577_sup);
	 }
	}

	I_val = tmp_577_val;
	I_sup = tmp_577_sup;

	// ******************* New Declaration
	double J_val;
	double J_sup;

	double tmp_580_val = a1_g_val*cc2_val;
	double tmp_580_sup = a1_g_sup*cc2_sup;

	double tmp_583_val = a2_g_val*cc1_val;
	double tmp_583_sup = a2_g_sup*cc1_sup;

	double tmp_584_val = tmp_580_val+tmp_583_val;
	double tmp_584_sup = tmp_580_sup+tmp_583_sup;
	{
	 static double _upper=8*eps1;
	 if (tmp_584_sup*_upper*correction<1)
	 {  tmp_584_sup = (tmp_584_val);
	   clear_sign_bit(tmp_584_sup);
	 }
	}

	J_val = tmp_584_val;
	J_sup = tmp_584_sup;

	// ******************* New Declaration
	double xv_trans_val;
	double xv_trans_sup;

	double tmp_588_val = kappa_g_val*sign_s_g_val;
	double tmp_588_sup = kappa_g_sup*sign_s_g_sup;

	double tmp_590_val = tmp_588_val*G_W_val;
	double tmp_590_sup = tmp_588_sup*G_W_sup;

	double tmp_591_val = J_val+tmp_590_val;
	double tmp_591_sup = J_sup+tmp_590_sup;
	{
	 static double _upper=28*eps1;
	 if (tmp_591_sup*_upper*correction<1)
	 {  tmp_591_sup = (tmp_591_val);
	   clear_sign_bit(tmp_591_sup);
	 }
	}

	xv_trans_val = tmp_591_val;
	xv_trans_sup = tmp_591_sup;

	// ******************* New Declaration
	double yv_trans_val;
	double yv_trans_sup;

	double tmp_595_val = kappa_g_val*sign_r_g_val;
	double tmp_595_sup = kappa_g_sup*sign_r_g_sup;

	double tmp_597_val = tmp_595_val*F_W_val;
	double tmp_597_sup = tmp_595_sup*F_W_sup;

	double tmp_598_val = I_val-tmp_597_val;
	double tmp_598_sup = I_sup+tmp_597_sup;
	{
	 static double _upper=28*eps1;
	 if (tmp_598_sup*_upper*correction<1)
	 {  tmp_598_sup = (tmp_598_val);
	   clear_sign_bit(tmp_598_sup);
	 }
	}

	yv_trans_val = tmp_598_val;
	yv_trans_sup = tmp_598_sup;

	// ******************* New Declaration
	double zv_trans_val;
	double zv_trans_sup;

	double tmp_601_val = zp_val*X_val;
	double tmp_601_sup = zp_sup*X_sup;

	zv_trans_val = tmp_601_val;
	zv_trans_sup = tmp_601_sup;

	// ********************* New Assignment
	double tmp_604_val = xv_trans_val*zp_val;
	double tmp_604_sup = xv_trans_sup*zp_sup;

	double tmp_607_val = xp_val*zv_trans_val;
	double tmp_607_sup = xp_sup*zv_trans_sup;

	double tmp_608_val = tmp_604_val+tmp_607_val;
	double tmp_608_sup = tmp_604_sup+tmp_607_sup;
	{
	 static double _upper=31*eps1;
	 if (tmp_608_sup*_upper*correction<1)
	 {  tmp_608_sup = (tmp_608_val);
	   clear_sign_bit(tmp_608_sup);
	 }
	}

	xCoordD = tmp_608_val;
	xCoordDS = tmp_608_sup;
/* Index of xCoord is 31 */

	// ********************* New Assignment
	double tmp_611_val = yv_trans_val*zp_val;
	double tmp_611_sup = yv_trans_sup*zp_sup;

	double tmp_614_val = yp_val*zv_trans_val;
	double tmp_614_sup = yp_sup*zv_trans_sup;

	double tmp_615_val = tmp_611_val+tmp_614_val;
	double tmp_615_sup = tmp_611_sup+tmp_614_sup;
	{
	 static double _upper=31*eps1;
	 if (tmp_615_sup*_upper*correction<1)
	 {  tmp_615_sup = (tmp_615_val);
	   clear_sign_bit(tmp_615_sup);
	 }
	}

	yCoordD = tmp_615_val;
	yCoordDS = tmp_615_sup;
/* Index of yCoord is 31 */

	// ********************* New Assignment
	double tmp_618_val = zv_trans_val*zp_val;
	double tmp_618_sup = zv_trans_sup*zp_sup;

	wCoordD = tmp_618_val;
	wCoordDS = tmp_618_sup;
/* Index of wCoord is 14 */


return TRUE;
}





int vnode::SSP_coltouch_Exact()
// **** Local Variables:
//		a3
//		a4
//		b3
//		b4
//		c3
//		c4
//		xp
//		yp
//		zp
// **** External Variables:
//		P.W()
//		P.X()
//		P.Y()
//		a1
//		b1
//		xt
//		yt
//		zt
// **** Sign Result Variables:

{


  rat_segment l1=csite(0).rseg();
  rat_segment l2=csite(1).rseg();
  rat_point    P=csite(2).rpnt();

  integer xv,yv,zv;
  bool p_is_l1_endpnt = (P == l1.start() || P == l1.end());
  bool p_is_l2_endpnt = (P == l2.start() || P == l2.end());
  
    int l1_p_or = orientation(l1,P);
    int l2_p_or = orientation(l2,P);


    if (l1_p_or == RIGHT)
      invert_seg(l1);
    if (l2_p_or == RIGHT)
      invert_seg(l2);

    integer dx1 = l1.dx();
    integer dy1 = l1.dy();
    integer dx2 = l2.dx();
    integer dy2 = l2.dy();
    
    if (l1_p_or == ON)
    {

      if (dx1*dy2 == dx2*dy1 && 
          sign(dx1) == sign(dx2) && sign (dy1) == sign(dy2) ||
          P == l1.start())
        // l1 and l2 are parallel and equally directed or
        // l1 and l2 are not parallel and the node is on the right
        invert_seg(l1);
    }
    if (l2_p_or == ON)
    {

      if (dx1*dy2 == dx2*dy1 && 
          sign(dx1) == sign(dx2) && sign(dy1) == sign(dy2) ||
          P == l2.end())
        invert_seg(l2);
    }
  
    integer a1,b1,c1;
    seg2line_paras(l1,a1,b1,c1); // initializes the homogenous coords of l1
      
    integer xt,yt,zt;
    if (l1.end()==l2.start())
    {
      xt = l1.X2();
      yt = l1.Y2();
      zt = l1.W2(); 
    }
    else if (l1.start()==l2.end())
    {
      xt = l1.X1();
      yt = l1.Y1();
      zt = l1.W1();
    }
    // now T = (xt,yt,zt) is the common endpoint on the line
   


	{
	real xp = P.X();
	real yp = P.Y();
	real zp = P.W();
	real a3 = (((2*zp)*zt)*((xt*zp)-(xp*zt)));
	real b3 = (((2*zp)*zt)*((yt*zp)-(yp*zt)));
	real c3 = (((sq(xp)+sq(yp))*sq(zt))-((sq(xt)+sq(yt))*sq(zp)));
	real a4 = (b1*zt);
	real b4 = (-(a1)*zt);
	real c4 = ((a1*yt)-(b1*xt));
	xCoord = ((b3*c4)-(b4*c3));
	yCoord = ((a4*c3)-(a3*c4));
	wCoord = ((a3*b4)-(a4*b3));
	}


return TRUE;
}

int vnode::SSP_coltouch_Integer()
// **** Local Variables:
//		a3
//		a4
//		b3
//		b4
//		c3
//		c4
//		xp
//		yp
//		zp
// **** External Variables:
//		P.W()
//		P.X()
//		P.Y()
//		a1
//		b1
//		xt
//		yt
//		zt
// **** Sign Result Variables:

{
	int _valid=TRUE;
	 if (!(1))
		_valid=FALSE;



  rat_segment l1=csite(0).rseg();
  rat_segment l2=csite(1).rseg();
  rat_point    P=csite(2).rpnt();

  integer xv,yv,zv;
  bool p_is_l1_endpnt = (P == l1.start() || P == l1.end());
  bool p_is_l2_endpnt = (P == l2.start() || P == l2.end());
  
    int l1_p_or = orientation(l1,P);
    int l2_p_or = orientation(l2,P);


    if (l1_p_or == RIGHT)
      invert_seg(l1);
    if (l2_p_or == RIGHT)
      invert_seg(l2);

    integer dx1 = l1.dx();
    integer dy1 = l1.dy();
    integer dx2 = l2.dx();
    integer dy2 = l2.dy();
    
    if (l1_p_or == ON)
    {

      if (dx1*dy2 == dx2*dy1 && 
          sign(dx1) == sign(dx2) && sign (dy1) == sign(dy2) ||
          P == l1.start())
        // l1 and l2 are parallel and equally directed or
        // l1 and l2 are not parallel and the node is on the right
        invert_seg(l1);
    }
    if (l2_p_or == ON)
    {

      if (dx1*dy2 == dx2*dy1 && 
          sign(dx1) == sign(dx2) && sign(dy1) == sign(dy2) ||
          P == l2.end())
        invert_seg(l2);
    }
  
    integer a1,b1,c1;
    seg2line_paras(l1,a1,b1,c1); // initializes the homogenous coords of l1
      
    integer xt,yt,zt;
    if (l1.end()==l2.start())
    {
      xt = l1.X2();
      yt = l1.Y2();
      zt = l1.W2(); 
    }
    else if (l1.start()==l2.end())
    {
      xt = l1.X1();
      yt = l1.Y1();
      zt = l1.W1();
    }
    // now T = (xt,yt,zt) is the common endpoint on the line
   


	{
integer P_W___g_val = P.W();
integer P_X___g_val = P.X();
integer P_Y___g_val = P.Y();
integer a1_g_val = a1;
integer b1_g_val = b1;
integer xt_g_val = xt;
integer yt_g_val = yt;
integer zt_g_val = zt;




	// ******************* New Declaration
	integer xp_val;

	if (_valid==TRUE)
	{
		xp_val = P_X___g_val;
	}

	// ******************* New Declaration
	integer yp_val;

	if (_valid==TRUE)
	{
		yp_val = P_Y___g_val;
	}

	// ******************* New Declaration
	integer zp_val;

	if (_valid==TRUE)
	{
		zp_val = P_W___g_val;
	}

	// ******************* New Declaration
	integer a3_val;

	if (_valid==TRUE)
	{
	integer tmp_625_val = 2*zp_val;

	integer tmp_627_val = tmp_625_val*zt_g_val;

	integer tmp_630_val = xt_g_val*zp_val;

	integer tmp_633_val = xp_val*zt_g_val;

	integer tmp_634_val = tmp_630_val-tmp_633_val;

	integer tmp_635_val = tmp_627_val*tmp_634_val;

		a3_val = tmp_635_val;
	}

	// ******************* New Declaration
	integer b3_val;

	if (_valid==TRUE)
	{
	integer tmp_638_val = 2*zp_val;

	integer tmp_640_val = tmp_638_val*zt_g_val;

	integer tmp_643_val = yt_g_val*zp_val;

	integer tmp_646_val = yp_val*zt_g_val;

	integer tmp_647_val = tmp_643_val-tmp_646_val;

	integer tmp_648_val = tmp_640_val*tmp_647_val;

		b3_val = tmp_648_val;
	}

	// ******************* New Declaration
	integer c3_val;

	if (_valid==TRUE)
	{
	integer tmp_650_val=xp_val*xp_val;
	integer tmp_652_val=yp_val*yp_val;
	integer tmp_653_val = tmp_650_val+tmp_652_val;

	integer tmp_655_val=zt_g_val*zt_g_val;
	integer tmp_656_val = tmp_653_val*tmp_655_val;

	integer tmp_658_val=xt_g_val*xt_g_val;
	integer tmp_660_val=yt_g_val*yt_g_val;
	integer tmp_661_val = tmp_658_val+tmp_660_val;

	integer tmp_663_val=zp_val*zp_val;
	integer tmp_664_val = tmp_661_val*tmp_663_val;

	integer tmp_665_val = tmp_656_val-tmp_664_val;

		c3_val = tmp_665_val;
	}

	// ******************* New Declaration
	integer a4_val;

	if (_valid==TRUE)
	{
	integer tmp_668_val = b1_g_val*zt_g_val;

		a4_val = tmp_668_val;
	}

	// ******************* New Declaration
	integer b4_val;

	if (_valid==TRUE)
	{
	integer tmp_670_val = -(a1_g_val);
	integer tmp_672_val = tmp_670_val*zt_g_val;

		b4_val = tmp_672_val;
	}

	// ******************* New Declaration
	integer c4_val;

	if (_valid==TRUE)
	{
	integer tmp_675_val = a1_g_val*yt_g_val;

	integer tmp_678_val = b1_g_val*xt_g_val;

	integer tmp_679_val = tmp_675_val-tmp_678_val;

		c4_val = tmp_679_val;
	}

	// ********************* New Assignment
	if (_valid==TRUE)
	{
	integer tmp_682_val = b3_val*c4_val;

	integer tmp_685_val = b4_val*c3_val;

	integer tmp_686_val = tmp_682_val-tmp_685_val;

	xCoordI = tmp_686_val;
	}

	// ********************* New Assignment
	if (_valid==TRUE)
	{
	integer tmp_689_val = a4_val*c3_val;

	integer tmp_692_val = a3_val*c4_val;

	integer tmp_693_val = tmp_689_val-tmp_692_val;

	yCoordI = tmp_693_val;
	}

	// ********************* New Assignment
	if (_valid==TRUE)
	{
	integer tmp_696_val = a3_val*b4_val;

	integer tmp_699_val = a4_val*b3_val;

	integer tmp_700_val = tmp_696_val-tmp_699_val;

	wCoordI = tmp_700_val;
	}
	}


return _valid;
}

int vnode::SSP_coltouch_Double()
// **** Local Variables:
//		a3
//		a4
//		b3
//		b4
//		c3
//		c4
//		xp
//		yp
//		zp
// **** External Variables:
//		P.W()
//		P.X()
//		P.Y()
//		a1
//		b1
//		xt
//		yt
//		zt
// **** Sign Result Variables:

{


  rat_segment l1=csite(0).rseg();
  rat_segment l2=csite(1).rseg();
  rat_point    P=csite(2).rpnt();

  integer xv,yv,zv;
  bool p_is_l1_endpnt = (P == l1.start() || P == l1.end());
  bool p_is_l2_endpnt = (P == l2.start() || P == l2.end());
  
    int l1_p_or = orientation(l1,P);
    int l2_p_or = orientation(l2,P);


    if (l1_p_or == RIGHT)
      invert_seg(l1);
    if (l2_p_or == RIGHT)
      invert_seg(l2);

    integer dx1 = l1.dx();
    integer dy1 = l1.dy();
    integer dx2 = l2.dx();
    integer dy2 = l2.dy();
    
    if (l1_p_or == ON)
    {

      if (dx1*dy2 == dx2*dy1 && 
          sign(dx1) == sign(dx2) && sign (dy1) == sign(dy2) ||
          P == l1.start())
        // l1 and l2 are parallel and equally directed or
        // l1 and l2 are not parallel and the node is on the right
        invert_seg(l1);
    }
    if (l2_p_or == ON)
    {

      if (dx1*dy2 == dx2*dy1 && 
          sign(dx1) == sign(dx2) && sign(dy1) == sign(dy2) ||
          P == l2.end())
        invert_seg(l2);
    }
  
    integer a1,b1,c1;
    seg2line_paras(l1,a1,b1,c1); // initializes the homogenous coords of l1
      
    integer xt,yt,zt;
    if (l1.end()==l2.start())
    {
      xt = l1.X2();
      yt = l1.Y2();
      zt = l1.W2(); 
    }
    else if (l1.start()==l2.end())
    {
      xt = l1.X1();
      yt = l1.Y1();
      zt = l1.W1();
    }
    // now T = (xt,yt,zt) is the common endpoint on the line
   


double P_W___g_val = P.WD();
double P_W___g_sup = float_abs(P_W___g_val);
double P_X___g_val = P.XD();
double P_X___g_sup = float_abs(P_X___g_val);
double P_Y___g_val = P.YD();
double P_Y___g_sup = float_abs(P_Y___g_val);
double a1_g_val = a1.to_double();
double a1_g_sup = float_abs(a1_g_val);
double b1_g_val = b1.to_double();
double b1_g_sup = float_abs(b1_g_val);
double xt_g_val = xt.to_double();
double xt_g_sup = float_abs(xt_g_val);
double yt_g_val = yt.to_double();
double yt_g_sup = float_abs(yt_g_val);
double zt_g_val = zt.to_double();
double zt_g_sup = float_abs(zt_g_val);




	// ******************* New Declaration
	double xp_val;
	double xp_sup;

	xp_val = P_X___g_val;
	xp_sup = P_X___g_sup;

	// ******************* New Declaration
	double yp_val;
	double yp_sup;

	yp_val = P_Y___g_val;
	yp_sup = P_Y___g_sup;

	// ******************* New Declaration
	double zp_val;
	double zp_sup;

	zp_val = P_W___g_val;
	zp_sup = P_W___g_sup;

	// ******************* New Declaration
	double a3_val;
	double a3_sup;

	double tmp_625_val = 2*zp_val;
	double tmp_625_sup = 2*zp_sup;

	double tmp_627_val = tmp_625_val*zt_g_val;
	double tmp_627_sup = tmp_625_sup*zt_g_sup;

	double tmp_630_val = xt_g_val*zp_val;
	double tmp_630_sup = xt_g_sup*zp_sup;

	double tmp_633_val = xp_val*zt_g_val;
	double tmp_633_sup = xp_sup*zt_g_sup;

	double tmp_634_val = tmp_630_val-tmp_633_val;
	double tmp_634_sup = tmp_630_sup+tmp_633_sup;
	{
	 static double _upper=4*eps1;
	 if (tmp_634_sup*_upper*correction<1)
	 {  tmp_634_sup = (tmp_634_val);
	   clear_sign_bit(tmp_634_sup);
	 }
	}

	double tmp_635_val = tmp_627_val*tmp_634_val;
	double tmp_635_sup = tmp_627_sup*tmp_634_sup;

	a3_val = tmp_635_val;
	a3_sup = tmp_635_sup;

	// ******************* New Declaration
	double b3_val;
	double b3_sup;

	double tmp_638_val = 2*zp_val;
	double tmp_638_sup = 2*zp_sup;

	double tmp_640_val = tmp_638_val*zt_g_val;
	double tmp_640_sup = tmp_638_sup*zt_g_sup;

	double tmp_643_val = yt_g_val*zp_val;
	double tmp_643_sup = yt_g_sup*zp_sup;

	double tmp_646_val = yp_val*zt_g_val;
	double tmp_646_sup = yp_sup*zt_g_sup;

	double tmp_647_val = tmp_643_val-tmp_646_val;
	double tmp_647_sup = tmp_643_sup+tmp_646_sup;
	{
	 static double _upper=4*eps1;
	 if (tmp_647_sup*_upper*correction<1)
	 {  tmp_647_sup = (tmp_647_val);
	   clear_sign_bit(tmp_647_sup);
	 }
	}

	double tmp_648_val = tmp_640_val*tmp_647_val;
	double tmp_648_sup = tmp_640_sup*tmp_647_sup;

	b3_val = tmp_648_val;
	b3_sup = tmp_648_sup;

	// ******************* New Declaration
	double c3_val;
	double c3_sup;

	double tmp_650_val=xp_val*xp_val;
	double tmp_650_sup=xp_sup*xp_sup;

	double tmp_652_val=yp_val*yp_val;
	double tmp_652_sup=yp_sup*yp_sup;

	double tmp_653_val = tmp_650_val+tmp_652_val;
	double tmp_653_sup = tmp_650_sup+tmp_652_sup;
	{
	 static double _upper=4*eps1;
	 if (tmp_653_sup*_upper*correction<1)
	 {  tmp_653_sup = (tmp_653_val);
	   clear_sign_bit(tmp_653_sup);
	 }
	}

	double tmp_655_val=zt_g_val*zt_g_val;
	double tmp_655_sup=zt_g_sup*zt_g_sup;

	double tmp_656_val = tmp_653_val*tmp_655_val;
	double tmp_656_sup = tmp_653_sup*tmp_655_sup;

	double tmp_658_val=xt_g_val*xt_g_val;
	double tmp_658_sup=xt_g_sup*xt_g_sup;

	double tmp_660_val=yt_g_val*yt_g_val;
	double tmp_660_sup=yt_g_sup*yt_g_sup;

	double tmp_661_val = tmp_658_val+tmp_660_val;
	double tmp_661_sup = tmp_658_sup+tmp_660_sup;
	{
	 static double _upper=4*eps1;
	 if (tmp_661_sup*_upper*correction<1)
	 {  tmp_661_sup = (tmp_661_val);
	   clear_sign_bit(tmp_661_sup);
	 }
	}

	double tmp_663_val=zp_val*zp_val;
	double tmp_663_sup=zp_sup*zp_sup;

	double tmp_664_val = tmp_661_val*tmp_663_val;
	double tmp_664_sup = tmp_661_sup*tmp_663_sup;

	double tmp_665_val = tmp_656_val-tmp_664_val;
	double tmp_665_sup = tmp_656_sup+tmp_664_sup;
	{
	 static double _upper=9*eps1;
	 if (tmp_665_sup*_upper*correction<1)
	 {  tmp_665_sup = (tmp_665_val);
	   clear_sign_bit(tmp_665_sup);
	 }
	}

	c3_val = tmp_665_val;
	c3_sup = tmp_665_sup;

	// ******************* New Declaration
	double a4_val;
	double a4_sup;

	double tmp_668_val = b1_g_val*zt_g_val;
	double tmp_668_sup = b1_g_sup*zt_g_sup;

	a4_val = tmp_668_val;
	a4_sup = tmp_668_sup;

	// ******************* New Declaration
	double b4_val;
	double b4_sup;

	double tmp_670_val = -(a1_g_val);
	double tmp_670_sup = a1_g_sup;
	double tmp_672_val = tmp_670_val*zt_g_val;
	double tmp_672_sup = tmp_670_sup*zt_g_sup;

	b4_val = tmp_672_val;
	b4_sup = tmp_672_sup;

	// ******************* New Declaration
	double c4_val;
	double c4_sup;

	double tmp_675_val = a1_g_val*yt_g_val;
	double tmp_675_sup = a1_g_sup*yt_g_sup;

	double tmp_678_val = b1_g_val*xt_g_val;
	double tmp_678_sup = b1_g_sup*xt_g_sup;

	double tmp_679_val = tmp_675_val-tmp_678_val;
	double tmp_679_sup = tmp_675_sup+tmp_678_sup;
	{
	 static double _upper=4*eps1;
	 if (tmp_679_sup*_upper*correction<1)
	 {  tmp_679_sup = (tmp_679_val);
	   clear_sign_bit(tmp_679_sup);
	 }
	}

	c4_val = tmp_679_val;
	c4_sup = tmp_679_sup;

	// ********************* New Assignment
	double tmp_682_val = b3_val*c4_val;
	double tmp_682_sup = b3_sup*c4_sup;

	double tmp_685_val = b4_val*c3_val;
	double tmp_685_sup = b4_sup*c3_sup;

	double tmp_686_val = tmp_682_val-tmp_685_val;
	double tmp_686_sup = tmp_682_sup+tmp_685_sup;
	{
	 static double _upper=15*eps1;
	 if (tmp_686_sup*_upper*correction<1)
	 {  tmp_686_sup = (tmp_686_val);
	   clear_sign_bit(tmp_686_sup);
	 }
	}

	xCoordD = tmp_686_val;
	xCoordDS = tmp_686_sup;
/* Index of xCoord is 15 */

	// ********************* New Assignment
	double tmp_689_val = a4_val*c3_val;
	double tmp_689_sup = a4_sup*c3_sup;

	double tmp_692_val = a3_val*c4_val;
	double tmp_692_sup = a3_sup*c4_sup;

	double tmp_693_val = tmp_689_val-tmp_692_val;
	double tmp_693_sup = tmp_689_sup+tmp_692_sup;
	{
	 static double _upper=15*eps1;
	 if (tmp_693_sup*_upper*correction<1)
	 {  tmp_693_sup = (tmp_693_val);
	   clear_sign_bit(tmp_693_sup);
	 }
	}

	yCoordD = tmp_693_val;
	yCoordDS = tmp_693_sup;
/* Index of yCoord is 15 */

	// ********************* New Assignment
	double tmp_696_val = a3_val*b4_val;
	double tmp_696_sup = a3_sup*b4_sup;

	double tmp_699_val = a4_val*b3_val;
	double tmp_699_sup = a4_sup*b3_sup;

	double tmp_700_val = tmp_696_val-tmp_699_val;
	double tmp_700_sup = tmp_696_sup+tmp_699_sup;
	{
	 static double _upper=14*eps1;
	 if (tmp_700_sup*_upper*correction<1)
	 {  tmp_700_sup = (tmp_700_val);
	   clear_sign_bit(tmp_700_sup);
	 }
	}

	wCoordD = tmp_700_val;
	wCoordDS = tmp_700_sup;
/* Index of wCoord is 14 */


return TRUE;
}





int vnode::SSS_coltouch_Exact()
// **** Local Variables:
//		D12
//		D12_2
//		D1_2
//		D2_2
//		a3
//		a4
//		b3
//		b4
//		c3
//		c4
// **** External Variables:
//		P.W()
//		P.X()
//		P.Y()
//		a1
//		a2
//		b1
//		b2
//		c1
//		c2
// **** Sign Result Variables:

{


  rat_segment l1=csite(0).rseg();
  rat_segment l2=csite(1).rseg();
  rat_segment l3=csite(2).rseg();

  rat_point tpnt12, tpnt13, tpnt23;
  bool touch12 = endpnts_touch(l1,l2,tpnt12);
  bool touch13 = endpnts_touch(l1,l3,tpnt13);
  bool touch23 = endpnts_touch(l2,l3,tpnt23);

  int l1_rel_l2, l1_rel_l3, l2_rel_l1, l2_rel_l3, l3_rel_l1, l3_rel_l2;
  orient_segs(l1,l2,l1_rel_l2,l2_rel_l1);
  orient_segs(l1,l3,l1_rel_l3,l3_rel_l1);
  orient_segs(l2,l3,l2_rel_l3,l3_rel_l2);
  // provides information about orientation of supporting lines
    
  rat_segment l_1, l_2;
 
  if (l1_rel_l2 == ON)
  {
    if (l2.start() == tpnt12)
      invert_seg(l2);
    if (orientation(l3,tpnt12) == RIGHT)
      invert_seg(l3);
    l_1=l2; l_2=l3;
  }
  if (l1_rel_l3 == ON)
  {
    if (l1.start() == tpnt13)
      invert_seg(l1);
    if (orientation(l2,tpnt13) == RIGHT)
      invert_seg(l2);
    l_1=l1; l_2=l2;
  }
  if (l2_rel_l3 == ON)
  {
    if (l3.start() == tpnt23)
      invert_seg(l3);
    if (orientation(l1,tpnt23) == RIGHT)
      invert_seg(l1);
    l_1=l3; l_2=l1;
  }


  integer a1,b1,c1,a2,b2,c2;
  seg2line_paras(l_1,a1,b1,c1);
  seg2line_paras(l_2,a2,b2,c2);  

  rat_point P=l_1.end();


	{
	real D1_2 = (sq(a1)+sq(b1));
	real D2_2 = (sq(a2)+sq(b2));
	real D12_2 = (D1_2*D2_2);
	real D12 = sqrt(D12_2);
	real a3 = ((a1*D12)-(a2*D1_2));
	real b3 = ((b1*D12)-(b2*D1_2));
	real c3 = ((c1*D12)-(c2*D1_2));
	real a4 = (b1*P.W());
	real b4 = (-(a1)*P.W());
	real c4 = ((a1*P.Y())-(b1*P.X()));
	xCoord = ((b3*c4)-(b4*c3));
	yCoord = ((a4*c3)-(a3*c4));
	wCoord = ((a3*b4)-(a4*b3));
	}


return TRUE;
}

int vnode::SSS_coltouch_Integer()
// **** Local Variables:
//		D12
//		D12_2
//		D1_2
//		D2_2
//		a3
//		a4
//		b3
//		b4
//		c3
//		c4
// **** External Variables:
//		P.W()
//		P.X()
//		P.Y()
//		a1
//		a2
//		b1
//		b2
//		c1
//		c2
// **** Sign Result Variables:

{
	int _valid=TRUE;
	 if (!(1))
		_valid=FALSE;



  rat_segment l1=csite(0).rseg();
  rat_segment l2=csite(1).rseg();
  rat_segment l3=csite(2).rseg();

  rat_point tpnt12, tpnt13, tpnt23;
  bool touch12 = endpnts_touch(l1,l2,tpnt12);
  bool touch13 = endpnts_touch(l1,l3,tpnt13);
  bool touch23 = endpnts_touch(l2,l3,tpnt23);

  int l1_rel_l2, l1_rel_l3, l2_rel_l1, l2_rel_l3, l3_rel_l1, l3_rel_l2;
  orient_segs(l1,l2,l1_rel_l2,l2_rel_l1);
  orient_segs(l1,l3,l1_rel_l3,l3_rel_l1);
  orient_segs(l2,l3,l2_rel_l3,l3_rel_l2);
  // provides information about orientation of supporting lines
    
  rat_segment l_1, l_2;
 
  if (l1_rel_l2 == ON)
  {
    if (l2.start() == tpnt12)
      invert_seg(l2);
    if (orientation(l3,tpnt12) == RIGHT)
      invert_seg(l3);
    l_1=l2; l_2=l3;
  }
  if (l1_rel_l3 == ON)
  {
    if (l1.start() == tpnt13)
      invert_seg(l1);
    if (orientation(l2,tpnt13) == RIGHT)
      invert_seg(l2);
    l_1=l1; l_2=l2;
  }
  if (l2_rel_l3 == ON)
  {
    if (l3.start() == tpnt23)
      invert_seg(l3);
    if (orientation(l1,tpnt23) == RIGHT)
      invert_seg(l1);
    l_1=l3; l_2=l1;
  }


  integer a1,b1,c1,a2,b2,c2;
  seg2line_paras(l_1,a1,b1,c1);
  seg2line_paras(l_2,a2,b2,c2);  

  rat_point P=l_1.end();


	{
integer P_W___g_val = P.W();
integer P_X___g_val = P.X();
integer P_Y___g_val = P.Y();
integer a1_g_val = a1;
integer a2_g_val = a2;
integer b1_g_val = b1;
integer b2_g_val = b2;
integer c1_g_val = c1;
integer c2_g_val = c2;




	// ******************* New Declaration
	integer D1_2_val;

	if (_valid==TRUE)
	{
	integer tmp_703_val=a1_g_val*a1_g_val;
	integer tmp_705_val=b1_g_val*b1_g_val;
	integer tmp_706_val = tmp_703_val+tmp_705_val;

		D1_2_val = tmp_706_val;
	}

	// ******************* New Declaration
	integer D2_2_val;

	if (_valid==TRUE)
	{
	integer tmp_708_val=a2_g_val*a2_g_val;
	integer tmp_710_val=b2_g_val*b2_g_val;
	integer tmp_711_val = tmp_708_val+tmp_710_val;

		D2_2_val = tmp_711_val;
	}

	// ******************* New Declaration
	integer D12_2_val;

	if (_valid==TRUE)
	{
	integer tmp_714_val = D1_2_val*D2_2_val;

		D12_2_val = tmp_714_val;
	}

	// ******************* New Declaration
	integer D12_val;

	if (_valid==TRUE)
	{
	integer tmp_716_val;
	if (D12_2_val <0) _valid=FALSE;
	else
	{
	  tmp_716_val = sqrt(D12_2_val);
	  if (tmp_716_val*tmp_716_val != D12_2_val) _valid=FALSE;
	}
		D12_val = tmp_716_val;
	}

	// ******************* New Declaration
	integer a3_val;

	if (_valid==TRUE)
	{
	integer tmp_719_val = a1_g_val*D12_val;

	integer tmp_722_val = a2_g_val*D1_2_val;

	integer tmp_723_val = tmp_719_val-tmp_722_val;

		a3_val = tmp_723_val;
	}

	// ******************* New Declaration
	integer b3_val;

	if (_valid==TRUE)
	{
	integer tmp_726_val = b1_g_val*D12_val;

	integer tmp_729_val = b2_g_val*D1_2_val;

	integer tmp_730_val = tmp_726_val-tmp_729_val;

		b3_val = tmp_730_val;
	}

	// ******************* New Declaration
	integer c3_val;

	if (_valid==TRUE)
	{
	integer tmp_733_val = c1_g_val*D12_val;

	integer tmp_736_val = c2_g_val*D1_2_val;

	integer tmp_737_val = tmp_733_val-tmp_736_val;

		c3_val = tmp_737_val;
	}

	// ******************* New Declaration
	integer a4_val;

	if (_valid==TRUE)
	{
	integer tmp_740_val = b1_g_val*P_W___g_val;

		a4_val = tmp_740_val;
	}

	// ******************* New Declaration
	integer b4_val;

	if (_valid==TRUE)
	{
	integer tmp_742_val = -(a1_g_val);
	integer tmp_744_val = tmp_742_val*P_W___g_val;

		b4_val = tmp_744_val;
	}

	// ******************* New Declaration
	integer c4_val;

	if (_valid==TRUE)
	{
	integer tmp_747_val = a1_g_val*P_Y___g_val;

	integer tmp_750_val = b1_g_val*P_X___g_val;

	integer tmp_751_val = tmp_747_val-tmp_750_val;

		c4_val = tmp_751_val;
	}

	// ********************* New Assignment
	if (_valid==TRUE)
	{
	integer tmp_754_val = b3_val*c4_val;

	integer tmp_757_val = b4_val*c3_val;

	integer tmp_758_val = tmp_754_val-tmp_757_val;

	xCoordI = tmp_758_val;
	}

	// ********************* New Assignment
	if (_valid==TRUE)
	{
	integer tmp_761_val = a4_val*c3_val;

	integer tmp_764_val = a3_val*c4_val;

	integer tmp_765_val = tmp_761_val-tmp_764_val;

	yCoordI = tmp_765_val;
	}

	// ********************* New Assignment
	if (_valid==TRUE)
	{
	integer tmp_768_val = a3_val*b4_val;

	integer tmp_771_val = a4_val*b3_val;

	integer tmp_772_val = tmp_768_val-tmp_771_val;

	wCoordI = tmp_772_val;
	}
	}


return _valid;
}

int vnode::SSS_coltouch_Double()
// **** Local Variables:
//		D12
//		D12_2
//		D1_2
//		D2_2
//		a3
//		a4
//		b3
//		b4
//		c3
//		c4
// **** External Variables:
//		P.W()
//		P.X()
//		P.Y()
//		a1
//		a2
//		b1
//		b2
//		c1
//		c2
// **** Sign Result Variables:

{


  rat_segment l1=csite(0).rseg();
  rat_segment l2=csite(1).rseg();
  rat_segment l3=csite(2).rseg();

  rat_point tpnt12, tpnt13, tpnt23;
  bool touch12 = endpnts_touch(l1,l2,tpnt12);
  bool touch13 = endpnts_touch(l1,l3,tpnt13);
  bool touch23 = endpnts_touch(l2,l3,tpnt23);

  int l1_rel_l2, l1_rel_l3, l2_rel_l1, l2_rel_l3, l3_rel_l1, l3_rel_l2;
  orient_segs(l1,l2,l1_rel_l2,l2_rel_l1);
  orient_segs(l1,l3,l1_rel_l3,l3_rel_l1);
  orient_segs(l2,l3,l2_rel_l3,l3_rel_l2);
  // provides information about orientation of supporting lines
    
  rat_segment l_1, l_2;
 
  if (l1_rel_l2 == ON)
  {
    if (l2.start() == tpnt12)
      invert_seg(l2);
    if (orientation(l3,tpnt12) == RIGHT)
      invert_seg(l3);
    l_1=l2; l_2=l3;
  }
  if (l1_rel_l3 == ON)
  {
    if (l1.start() == tpnt13)
      invert_seg(l1);
    if (orientation(l2,tpnt13) == RIGHT)
      invert_seg(l2);
    l_1=l1; l_2=l2;
  }
  if (l2_rel_l3 == ON)
  {
    if (l3.start() == tpnt23)
      invert_seg(l3);
    if (orientation(l1,tpnt23) == RIGHT)
      invert_seg(l1);
    l_1=l3; l_2=l1;
  }


  integer a1,b1,c1,a2,b2,c2;
  seg2line_paras(l_1,a1,b1,c1);
  seg2line_paras(l_2,a2,b2,c2);  

  rat_point P=l_1.end();


double P_W___g_val = P.WD();
double P_W___g_sup = float_abs(P_W___g_val);
double P_X___g_val = P.XD();
double P_X___g_sup = float_abs(P_X___g_val);
double P_Y___g_val = P.YD();
double P_Y___g_sup = float_abs(P_Y___g_val);
double a1_g_val = a1.to_double();
double a1_g_sup = float_abs(a1_g_val);
double a2_g_val = a2.to_double();
double a2_g_sup = float_abs(a2_g_val);
double b1_g_val = b1.to_double();
double b1_g_sup = float_abs(b1_g_val);
double b2_g_val = b2.to_double();
double b2_g_sup = float_abs(b2_g_val);
double c1_g_val = c1.to_double();
double c1_g_sup = float_abs(c1_g_val);
double c2_g_val = c2.to_double();
double c2_g_sup = float_abs(c2_g_val);




	// ******************* New Declaration
	double D1_2_val;
	double D1_2_sup;

	double tmp_703_val=a1_g_val*a1_g_val;
	double tmp_703_sup=a1_g_sup*a1_g_sup;

	double tmp_705_val=b1_g_val*b1_g_val;
	double tmp_705_sup=b1_g_sup*b1_g_sup;

	double tmp_706_val = tmp_703_val+tmp_705_val;
	double tmp_706_sup = tmp_703_sup+tmp_705_sup;
	{
	 static double _upper=4*eps1;
	 if (tmp_706_sup*_upper*correction<1)
	 {  tmp_706_sup = (tmp_706_val);
	   clear_sign_bit(tmp_706_sup);
	 }
	}

	D1_2_val = tmp_706_val;
	D1_2_sup = tmp_706_sup;

	// ******************* New Declaration
	double D2_2_val;
	double D2_2_sup;

	double tmp_708_val=a2_g_val*a2_g_val;
	double tmp_708_sup=a2_g_sup*a2_g_sup;

	double tmp_710_val=b2_g_val*b2_g_val;
	double tmp_710_sup=b2_g_sup*b2_g_sup;

	double tmp_711_val = tmp_708_val+tmp_710_val;
	double tmp_711_sup = tmp_708_sup+tmp_710_sup;
	{
	 static double _upper=4*eps1;
	 if (tmp_711_sup*_upper*correction<1)
	 {  tmp_711_sup = (tmp_711_val);
	   clear_sign_bit(tmp_711_sup);
	 }
	}

	D2_2_val = tmp_711_val;
	D2_2_sup = tmp_711_sup;

	// ******************* New Declaration
	double D12_2_val;
	double D12_2_sup;

	double tmp_714_val = D1_2_val*D2_2_val;
	double tmp_714_sup = D1_2_sup*D2_2_sup;

	D12_2_val = tmp_714_val;
	D12_2_sup = tmp_714_sup;

	// ******************* New Declaration
	double D12_val;
	double D12_sup;

	double tmp_716_val=NaN_double;
	double tmp_716_sup=pInf_double;
	if ( D12_2_sup==0 )
	   tmp_716_val=tmp_716_sup=0;
	else
	if (D12_2_sup*(eps1*9)*correction<1)
	{  tmp_716_val = sqrt(D12_2_val);
	   tmp_716_sup = tmp_716_val;
	}
	else
	{   if (D12_2_val==0)
	    { tmp_716_val=0; 
	      tmp_716_sup=sqrt(D12_2_sup)*sqrtMul;
	    }
	    else
	    {
	    tmp_716_val = sqrt(D12_2_val);
	    tmp_716_sup = (D12_2_sup/D12_2_val)*tmp_716_val;
	    }
	}
	D12_val = tmp_716_val;
	D12_sup = tmp_716_sup;

	// ******************* New Declaration
	double a3_val;
	double a3_sup;

	double tmp_719_val = a1_g_val*D12_val;
	double tmp_719_sup = a1_g_sup*D12_sup;

	double tmp_722_val = a2_g_val*D1_2_val;
	double tmp_722_sup = a2_g_sup*D1_2_sup;

	double tmp_723_val = tmp_719_val-tmp_722_val;
	double tmp_723_sup = tmp_719_sup+tmp_722_sup;
	{
	 static double _upper=12*eps1;
	 if (tmp_723_sup*_upper*correction<1)
	 {  tmp_723_sup = (tmp_723_val);
	   clear_sign_bit(tmp_723_sup);
	 }
	}

	a3_val = tmp_723_val;
	a3_sup = tmp_723_sup;

	// ******************* New Declaration
	double b3_val;
	double b3_sup;

	double tmp_726_val = b1_g_val*D12_val;
	double tmp_726_sup = b1_g_sup*D12_sup;

	double tmp_729_val = b2_g_val*D1_2_val;
	double tmp_729_sup = b2_g_sup*D1_2_sup;

	double tmp_730_val = tmp_726_val-tmp_729_val;
	double tmp_730_sup = tmp_726_sup+tmp_729_sup;
	{
	 static double _upper=12*eps1;
	 if (tmp_730_sup*_upper*correction<1)
	 {  tmp_730_sup = (tmp_730_val);
	   clear_sign_bit(tmp_730_sup);
	 }
	}

	b3_val = tmp_730_val;
	b3_sup = tmp_730_sup;

	// ******************* New Declaration
	double c3_val;
	double c3_sup;

	double tmp_733_val = c1_g_val*D12_val;
	double tmp_733_sup = c1_g_sup*D12_sup;

	double tmp_736_val = c2_g_val*D1_2_val;
	double tmp_736_sup = c2_g_sup*D1_2_sup;

	double tmp_737_val = tmp_733_val-tmp_736_val;
	double tmp_737_sup = tmp_733_sup+tmp_736_sup;
	{
	 static double _upper=12*eps1;
	 if (tmp_737_sup*_upper*correction<1)
	 {  tmp_737_sup = (tmp_737_val);
	   clear_sign_bit(tmp_737_sup);
	 }
	}

	c3_val = tmp_737_val;
	c3_sup = tmp_737_sup;

	// ******************* New Declaration
	double a4_val;
	double a4_sup;

	double tmp_740_val = b1_g_val*P_W___g_val;
	double tmp_740_sup = b1_g_sup*P_W___g_sup;

	a4_val = tmp_740_val;
	a4_sup = tmp_740_sup;

	// ******************* New Declaration
	double b4_val;
	double b4_sup;

	double tmp_742_val = -(a1_g_val);
	double tmp_742_sup = a1_g_sup;
	double tmp_744_val = tmp_742_val*P_W___g_val;
	double tmp_744_sup = tmp_742_sup*P_W___g_sup;

	b4_val = tmp_744_val;
	b4_sup = tmp_744_sup;

	// ******************* New Declaration
	double c4_val;
	double c4_sup;

	double tmp_747_val = a1_g_val*P_Y___g_val;
	double tmp_747_sup = a1_g_sup*P_Y___g_sup;

	double tmp_750_val = b1_g_val*P_X___g_val;
	double tmp_750_sup = b1_g_sup*P_X___g_sup;

	double tmp_751_val = tmp_747_val-tmp_750_val;
	double tmp_751_sup = tmp_747_sup+tmp_750_sup;
	{
	 static double _upper=4*eps1;
	 if (tmp_751_sup*_upper*correction<1)
	 {  tmp_751_sup = (tmp_751_val);
	   clear_sign_bit(tmp_751_sup);
	 }
	}

	c4_val = tmp_751_val;
	c4_sup = tmp_751_sup;

	// ********************* New Assignment
	double tmp_754_val = b3_val*c4_val;
	double tmp_754_sup = b3_sup*c4_sup;

	double tmp_757_val = b4_val*c3_val;
	double tmp_757_sup = b4_sup*c3_sup;

	double tmp_758_val = tmp_754_val-tmp_757_val;
	double tmp_758_sup = tmp_754_sup+tmp_757_sup;
	{
	 static double _upper=18*eps1;
	 if (tmp_758_sup*_upper*correction<1)
	 {  tmp_758_sup = (tmp_758_val);
	   clear_sign_bit(tmp_758_sup);
	 }
	}

	xCoordD = tmp_758_val;
	xCoordDS = tmp_758_sup;
/* Index of xCoord is 18 */

	// ********************* New Assignment
	double tmp_761_val = a4_val*c3_val;
	double tmp_761_sup = a4_sup*c3_sup;

	double tmp_764_val = a3_val*c4_val;
	double tmp_764_sup = a3_sup*c4_sup;

	double tmp_765_val = tmp_761_val-tmp_764_val;
	double tmp_765_sup = tmp_761_sup+tmp_764_sup;
	{
	 static double _upper=18*eps1;
	 if (tmp_765_sup*_upper*correction<1)
	 {  tmp_765_sup = (tmp_765_val);
	   clear_sign_bit(tmp_765_sup);
	 }
	}

	yCoordD = tmp_765_val;
	yCoordDS = tmp_765_sup;
/* Index of yCoord is 18 */

	// ********************* New Assignment
	double tmp_768_val = a3_val*b4_val;
	double tmp_768_sup = a3_sup*b4_sup;

	double tmp_771_val = a4_val*b3_val;
	double tmp_771_sup = a4_sup*b3_sup;

	double tmp_772_val = tmp_768_val-tmp_771_val;
	double tmp_772_sup = tmp_768_sup+tmp_771_sup;
	{
	 static double _upper=17*eps1;
	 if (tmp_772_sup*_upper*correction<1)
	 {  tmp_772_sup = (tmp_772_val);
	   clear_sign_bit(tmp_772_sup);
	 }
	}

	wCoordD = tmp_772_val;
	wCoordDS = tmp_772_sup;
/* Index of wCoord is 17 */


return TRUE;
}






int vnode::SSS_interior_Exact()
// **** Local Variables:
//		D12
//		D13
//		D1_2
//		D2_2
//		D3_2
// **** External Variables:
//		a1
//		a2
//		a3
//		b1
//		b2
//		b3
//		c1
//		c2
//		c3
// **** Sign Result Variables:

{


  rat_segment l1=csite(0).rseg();
  rat_segment l2=csite(1).rseg();
  rat_segment l3=csite(2).rseg();

  int l1_rel_l2, l1_rel_l3, l2_rel_l1, l2_rel_l3, l3_rel_l1, l3_rel_l2;
  orient_segs(l1,l2,l1_rel_l2,l2_rel_l1);
  orient_segs(l1,l3,l1_rel_l3,l3_rel_l1);
  orient_segs(l2,l3,l2_rel_l3,l3_rel_l2);

  bool l1_is_oriented = (l2_rel_l1 == LEFT || l3_rel_l1 == LEFT);
  bool l2_is_oriented = (l1_rel_l2 == LEFT || l3_rel_l2 == LEFT);
  bool l3_is_oriented = (l1_rel_l3 == LEFT || l2_rel_l3 == LEFT);
  //  this states if a segment is already correctly oriented 

  if (!l1_is_oriented && (l2_rel_l1 == RIGHT || l3_rel_l1 == RIGHT))
  {  
    invert_seg(l1);  
    l1_is_oriented = true;  
  }
  if (!l2_is_oriented && (l1_rel_l2 == RIGHT || l3_rel_l2 == RIGHT))
  {  
    invert_seg(l2);  
    l2_is_oriented = true;  
  }
  if (!l3_is_oriented && (l1_rel_l3 == RIGHT || l2_rel_l3 == RIGHT))
  {  
    invert_seg(l3);  
    l3_is_oriented = true;  
  }  
  //  this orients the segments which are not correctly oriented
  //  now only one segment might not be oriented

  if (!l1_is_oriented)
  {
    if (l2_rel_l3 == UNDEC && orientation(l1,l3.start()) != RIGHT ||
       l3_rel_l2 == UNDEC && orientation(l1,l2.start()) != LEFT ||
       l2_rel_l3 != UNDEC && l3_rel_l2 != UNDEC && 
       orientation(l1,l2.start()) != LEFT)
      /* l2 is $s_n$ and l3 is $s_p$ thus the first line refers to case 2, the second 
         refers to case 3 and the last two lines refer to case1 */
      invert_seg(l1);
    l1_is_oriented = true;
  }

  if (!l2_is_oriented)
  {
    if (l3_rel_l1 == UNDEC && orientation(l2,l1.start()) != RIGHT ||
       l1_rel_l3 == UNDEC && orientation(l2,l3.start()) != LEFT ||
       l1_rel_l3 != UNDEC && l3_rel_l1 != UNDEC && 
       orientation(l2,l3.start()) != LEFT)
      /* l3 is $s_n$ and l1 is $s_p$ thus the first line refers to case 2, the second 
         refers to case 3 and the last two lines refer to case1 */
      invert_seg(l2);
    l2_is_oriented = true;
  }

  if (!l3_is_oriented)
  {
    if (l1_rel_l2 == UNDEC && orientation(l3,l2.start()) != RIGHT ||
       l2_rel_l1 == UNDEC && orientation(l3,l1.start()) != LEFT ||
       l1_rel_l2 != UNDEC && l2_rel_l1 != UNDEC && 
       orientation(l3,l1.start()) != LEFT)
      /* l1 is $s_n$ and l2 is $s_p$ thus the first line refers to case 2, the second 
         refers to case 3 and the last two lines refer to case1 */
      invert_seg(l3);
    l3_is_oriented = true;
  }

 
  integer a1,b1,c1,a2,b2,c2,a3,b3,c3;
  seg2line_paras(l1,a1,b1,c1); 
  seg2line_paras(l2,a2,b2,c2); 
  seg2line_paras(l3,a3,b3,c3); 
  // initializes the homogenous coords of |l1,l2,l3|


	{
	real D1_2 = (sq(a1)+sq(b1));
	real D2_2 = (sq(a2)+sq(b2));
	real D3_2 = (sq(a3)+sq(b3));
	real D12 = sqrt((D1_2*D2_2));
	real D13 = sqrt((D1_2*D3_2));
	xCoord = (((((c1*b2)-(c2*b1))*D13)+(((c2*b3)-(c3*b2))*D1_2))+(((c3*b1)-(c1*b3))*D12));
	yCoord = -((((((c1*a2)-(c2*a1))*D13)+(((c2*a3)-(c3*a2))*D1_2))+(((c3*a1)-(c1*a3))*D12)));
	wCoord = -((((((a1*b2)-(a2*b1))*D13)+(((a2*b3)-(a3*b2))*D1_2))+(((a3*b1)-(a1*b3))*D12)));
	}


return TRUE;
}

int vnode::SSS_interior_Integer()
// **** Local Variables:
//		D12
//		D13
//		D1_2
//		D2_2
//		D3_2
// **** External Variables:
//		a1
//		a2
//		a3
//		b1
//		b2
//		b3
//		c1
//		c2
//		c3
// **** Sign Result Variables:

{
	int _valid=TRUE;
	 if (!(1))
		_valid=FALSE;



  rat_segment l1=csite(0).rseg();
  rat_segment l2=csite(1).rseg();
  rat_segment l3=csite(2).rseg();

  int l1_rel_l2, l1_rel_l3, l2_rel_l1, l2_rel_l3, l3_rel_l1, l3_rel_l2;
  orient_segs(l1,l2,l1_rel_l2,l2_rel_l1);
  orient_segs(l1,l3,l1_rel_l3,l3_rel_l1);
  orient_segs(l2,l3,l2_rel_l3,l3_rel_l2);

  bool l1_is_oriented = (l2_rel_l1 == LEFT || l3_rel_l1 == LEFT);
  bool l2_is_oriented = (l1_rel_l2 == LEFT || l3_rel_l2 == LEFT);
  bool l3_is_oriented = (l1_rel_l3 == LEFT || l2_rel_l3 == LEFT);
  //  this states if a segment is already correctly oriented 

  if (!l1_is_oriented && (l2_rel_l1 == RIGHT || l3_rel_l1 == RIGHT))
  {  
    invert_seg(l1);  
    l1_is_oriented = true;  
  }
  if (!l2_is_oriented && (l1_rel_l2 == RIGHT || l3_rel_l2 == RIGHT))
  {  
    invert_seg(l2);  
    l2_is_oriented = true;  
  }
  if (!l3_is_oriented && (l1_rel_l3 == RIGHT || l2_rel_l3 == RIGHT))
  {  
    invert_seg(l3);  
    l3_is_oriented = true;  
  }  
  //  this orients the segments which are not correctly oriented
  //  now only one segment might not be oriented

  if (!l1_is_oriented)
  {
    if (l2_rel_l3 == UNDEC && orientation(l1,l3.start()) != RIGHT ||
       l3_rel_l2 == UNDEC && orientation(l1,l2.start()) != LEFT ||
       l2_rel_l3 != UNDEC && l3_rel_l2 != UNDEC && 
       orientation(l1,l2.start()) != LEFT)
      /* l2 is $s_n$ and l3 is $s_p$ thus the first line refers to case 2, the second 
         refers to case 3 and the last two lines refer to case1 */
      invert_seg(l1);
    l1_is_oriented = true;
  }

  if (!l2_is_oriented)
  {
    if (l3_rel_l1 == UNDEC && orientation(l2,l1.start()) != RIGHT ||
       l1_rel_l3 == UNDEC && orientation(l2,l3.start()) != LEFT ||
       l1_rel_l3 != UNDEC && l3_rel_l1 != UNDEC && 
       orientation(l2,l3.start()) != LEFT)
      /* l3 is $s_n$ and l1 is $s_p$ thus the first line refers to case 2, the second 
         refers to case 3 and the last two lines refer to case1 */
      invert_seg(l2);
    l2_is_oriented = true;
  }

  if (!l3_is_oriented)
  {
    if (l1_rel_l2 == UNDEC && orientation(l3,l2.start()) != RIGHT ||
       l2_rel_l1 == UNDEC && orientation(l3,l1.start()) != LEFT ||
       l1_rel_l2 != UNDEC && l2_rel_l1 != UNDEC && 
       orientation(l3,l1.start()) != LEFT)
      /* l1 is $s_n$ and l2 is $s_p$ thus the first line refers to case 2, the second 
         refers to case 3 and the last two lines refer to case1 */
      invert_seg(l3);
    l3_is_oriented = true;
  }

 
  integer a1,b1,c1,a2,b2,c2,a3,b3,c3;
  seg2line_paras(l1,a1,b1,c1); 
  seg2line_paras(l2,a2,b2,c2); 
  seg2line_paras(l3,a3,b3,c3); 
  // initializes the homogenous coords of |l1,l2,l3|


	{
integer a1_g_val = a1;
integer a2_g_val = a2;
integer a3_g_val = a3;
integer b1_g_val = b1;
integer b2_g_val = b2;
integer b3_g_val = b3;
integer c1_g_val = c1;
integer c2_g_val = c2;
integer c3_g_val = c3;




	// ******************* New Declaration
	integer D1_2_val;

	if (_valid==TRUE)
	{
	integer tmp_775_val=a1_g_val*a1_g_val;
	integer tmp_777_val=b1_g_val*b1_g_val;
	integer tmp_778_val = tmp_775_val+tmp_777_val;

		D1_2_val = tmp_778_val;
	}

	// ******************* New Declaration
	integer D2_2_val;

	if (_valid==TRUE)
	{
	integer tmp_780_val=a2_g_val*a2_g_val;
	integer tmp_782_val=b2_g_val*b2_g_val;
	integer tmp_783_val = tmp_780_val+tmp_782_val;

		D2_2_val = tmp_783_val;
	}

	// ******************* New Declaration
	integer D3_2_val;

	if (_valid==TRUE)
	{
	integer tmp_785_val=a3_g_val*a3_g_val;
	integer tmp_787_val=b3_g_val*b3_g_val;
	integer tmp_788_val = tmp_785_val+tmp_787_val;

		D3_2_val = tmp_788_val;
	}

	// ******************* New Declaration
	integer D12_val;

	if (_valid==TRUE)
	{
	integer tmp_791_val = D1_2_val*D2_2_val;

	integer tmp_792_val;
	if (tmp_791_val <0) _valid=FALSE;
	else
	{
	  tmp_792_val = sqrt(tmp_791_val);
	  if (tmp_792_val*tmp_792_val != tmp_791_val) _valid=FALSE;
	}
		D12_val = tmp_792_val;
	}

	// ******************* New Declaration
	integer D13_val;

	if (_valid==TRUE)
	{
	integer tmp_795_val = D1_2_val*D3_2_val;

	integer tmp_796_val;
	if (tmp_795_val <0) _valid=FALSE;
	else
	{
	  tmp_796_val = sqrt(tmp_795_val);
	  if (tmp_796_val*tmp_796_val != tmp_795_val) _valid=FALSE;
	}
		D13_val = tmp_796_val;
	}

	// ********************* New Assignment
	if (_valid==TRUE)
	{
	integer tmp_799_val = c1_g_val*b2_g_val;

	integer tmp_802_val = c2_g_val*b1_g_val;

	integer tmp_803_val = tmp_799_val-tmp_802_val;

	integer tmp_805_val = tmp_803_val*D13_val;

	integer tmp_808_val = c2_g_val*b3_g_val;

	integer tmp_811_val = c3_g_val*b2_g_val;

	integer tmp_812_val = tmp_808_val-tmp_811_val;

	integer tmp_814_val = tmp_812_val*D1_2_val;

	integer tmp_815_val = tmp_805_val+tmp_814_val;

	integer tmp_818_val = c3_g_val*b1_g_val;

	integer tmp_821_val = c1_g_val*b3_g_val;

	integer tmp_822_val = tmp_818_val-tmp_821_val;

	integer tmp_824_val = tmp_822_val*D12_val;

	integer tmp_825_val = tmp_815_val+tmp_824_val;

	xCoordI = tmp_825_val;
	}

	// ********************* New Assignment
	if (_valid==TRUE)
	{
	integer tmp_828_val = c1_g_val*a2_g_val;

	integer tmp_831_val = c2_g_val*a1_g_val;

	integer tmp_832_val = tmp_828_val-tmp_831_val;

	integer tmp_834_val = tmp_832_val*D13_val;

	integer tmp_837_val = c2_g_val*a3_g_val;

	integer tmp_840_val = c3_g_val*a2_g_val;

	integer tmp_841_val = tmp_837_val-tmp_840_val;

	integer tmp_843_val = tmp_841_val*D1_2_val;

	integer tmp_844_val = tmp_834_val+tmp_843_val;

	integer tmp_847_val = c3_g_val*a1_g_val;

	integer tmp_850_val = c1_g_val*a3_g_val;

	integer tmp_851_val = tmp_847_val-tmp_850_val;

	integer tmp_853_val = tmp_851_val*D12_val;

	integer tmp_854_val = tmp_844_val+tmp_853_val;

	integer tmp_855_val = -(tmp_854_val);
	yCoordI = tmp_855_val;
	}

	// ********************* New Assignment
	if (_valid==TRUE)
	{
	integer tmp_858_val = a1_g_val*b2_g_val;

	integer tmp_861_val = a2_g_val*b1_g_val;

	integer tmp_862_val = tmp_858_val-tmp_861_val;

	integer tmp_864_val = tmp_862_val*D13_val;

	integer tmp_867_val = a2_g_val*b3_g_val;

	integer tmp_870_val = a3_g_val*b2_g_val;

	integer tmp_871_val = tmp_867_val-tmp_870_val;

	integer tmp_873_val = tmp_871_val*D1_2_val;

	integer tmp_874_val = tmp_864_val+tmp_873_val;

	integer tmp_877_val = a3_g_val*b1_g_val;

	integer tmp_880_val = a1_g_val*b3_g_val;

	integer tmp_881_val = tmp_877_val-tmp_880_val;

	integer tmp_883_val = tmp_881_val*D12_val;

	integer tmp_884_val = tmp_874_val+tmp_883_val;

	integer tmp_885_val = -(tmp_884_val);
	wCoordI = tmp_885_val;
	}
	}


return _valid;
}

int vnode::SSS_interior_Double()
// **** Local Variables:
//		D12
//		D13
//		D1_2
//		D2_2
//		D3_2
// **** External Variables:
//		a1
//		a2
//		a3
//		b1
//		b2
//		b3
//		c1
//		c2
//		c3
// **** Sign Result Variables:

{


  rat_segment l1=csite(0).rseg();
  rat_segment l2=csite(1).rseg();
  rat_segment l3=csite(2).rseg();

  int l1_rel_l2, l1_rel_l3, l2_rel_l1, l2_rel_l3, l3_rel_l1, l3_rel_l2;
  orient_segs(l1,l2,l1_rel_l2,l2_rel_l1);
  orient_segs(l1,l3,l1_rel_l3,l3_rel_l1);
  orient_segs(l2,l3,l2_rel_l3,l3_rel_l2);

  bool l1_is_oriented = (l2_rel_l1 == LEFT || l3_rel_l1 == LEFT);
  bool l2_is_oriented = (l1_rel_l2 == LEFT || l3_rel_l2 == LEFT);
  bool l3_is_oriented = (l1_rel_l3 == LEFT || l2_rel_l3 == LEFT);
  //  this states if a segment is already correctly oriented 

  if (!l1_is_oriented && (l2_rel_l1 == RIGHT || l3_rel_l1 == RIGHT))
  {  
    invert_seg(l1);  
    l1_is_oriented = true;  
  }
  if (!l2_is_oriented && (l1_rel_l2 == RIGHT || l3_rel_l2 == RIGHT))
  {  
    invert_seg(l2);  
    l2_is_oriented = true;  
  }
  if (!l3_is_oriented && (l1_rel_l3 == RIGHT || l2_rel_l3 == RIGHT))
  {  
    invert_seg(l3);  
    l3_is_oriented = true;  
  }  
  //  this orients the segments which are not correctly oriented
  //  now only one segment might not be oriented

  if (!l1_is_oriented)
  {
    if (l2_rel_l3 == UNDEC && orientation(l1,l3.start()) != RIGHT ||
       l3_rel_l2 == UNDEC && orientation(l1,l2.start()) != LEFT ||
       l2_rel_l3 != UNDEC && l3_rel_l2 != UNDEC && 
       orientation(l1,l2.start()) != LEFT)
      /* l2 is $s_n$ and l3 is $s_p$ thus the first line refers to case 2, the second 
         refers to case 3 and the last two lines refer to case1 */
      invert_seg(l1);
    l1_is_oriented = true;
  }

  if (!l2_is_oriented)
  {
    if (l3_rel_l1 == UNDEC && orientation(l2,l1.start()) != RIGHT ||
       l1_rel_l3 == UNDEC && orientation(l2,l3.start()) != LEFT ||
       l1_rel_l3 != UNDEC && l3_rel_l1 != UNDEC && 
       orientation(l2,l3.start()) != LEFT)
      /* l3 is $s_n$ and l1 is $s_p$ thus the first line refers to case 2, the second 
         refers to case 3 and the last two lines refer to case1 */
      invert_seg(l2);
    l2_is_oriented = true;
  }

  if (!l3_is_oriented)
  {
    if (l1_rel_l2 == UNDEC && orientation(l3,l2.start()) != RIGHT ||
       l2_rel_l1 == UNDEC && orientation(l3,l1.start()) != LEFT ||
       l1_rel_l2 != UNDEC && l2_rel_l1 != UNDEC && 
       orientation(l3,l1.start()) != LEFT)
      /* l1 is $s_n$ and l2 is $s_p$ thus the first line refers to case 2, the second 
         refers to case 3 and the last two lines refer to case1 */
      invert_seg(l3);
    l3_is_oriented = true;
  }

 
  integer a1,b1,c1,a2,b2,c2,a3,b3,c3;
  seg2line_paras(l1,a1,b1,c1); 
  seg2line_paras(l2,a2,b2,c2); 
  seg2line_paras(l3,a3,b3,c3); 
  // initializes the homogenous coords of |l1,l2,l3|


double a1_g_val = a1.to_double();
double a1_g_sup = float_abs(a1_g_val);
double a2_g_val = a2.to_double();
double a2_g_sup = float_abs(a2_g_val);
double a3_g_val = a3.to_double();
double a3_g_sup = float_abs(a3_g_val);
double b1_g_val = b1.to_double();
double b1_g_sup = float_abs(b1_g_val);
double b2_g_val = b2.to_double();
double b2_g_sup = float_abs(b2_g_val);
double b3_g_val = b3.to_double();
double b3_g_sup = float_abs(b3_g_val);
double c1_g_val = c1.to_double();
double c1_g_sup = float_abs(c1_g_val);
double c2_g_val = c2.to_double();
double c2_g_sup = float_abs(c2_g_val);
double c3_g_val = c3.to_double();
double c3_g_sup = float_abs(c3_g_val);




	// ******************* New Declaration
	double D1_2_val;
	double D1_2_sup;

	double tmp_775_val=a1_g_val*a1_g_val;
	double tmp_775_sup=a1_g_sup*a1_g_sup;

	double tmp_777_val=b1_g_val*b1_g_val;
	double tmp_777_sup=b1_g_sup*b1_g_sup;

	double tmp_778_val = tmp_775_val+tmp_777_val;
	double tmp_778_sup = tmp_775_sup+tmp_777_sup;
	{
	 static double _upper=4*eps1;
	 if (tmp_778_sup*_upper*correction<1)
	 {  tmp_778_sup = (tmp_778_val);
	   clear_sign_bit(tmp_778_sup);
	 }
	}

	D1_2_val = tmp_778_val;
	D1_2_sup = tmp_778_sup;

	// ******************* New Declaration
	double D2_2_val;
	double D2_2_sup;

	double tmp_780_val=a2_g_val*a2_g_val;
	double tmp_780_sup=a2_g_sup*a2_g_sup;

	double tmp_782_val=b2_g_val*b2_g_val;
	double tmp_782_sup=b2_g_sup*b2_g_sup;

	double tmp_783_val = tmp_780_val+tmp_782_val;
	double tmp_783_sup = tmp_780_sup+tmp_782_sup;
	{
	 static double _upper=4*eps1;
	 if (tmp_783_sup*_upper*correction<1)
	 {  tmp_783_sup = (tmp_783_val);
	   clear_sign_bit(tmp_783_sup);
	 }
	}

	D2_2_val = tmp_783_val;
	D2_2_sup = tmp_783_sup;

	// ******************* New Declaration
	double D3_2_val;
	double D3_2_sup;

	double tmp_785_val=a3_g_val*a3_g_val;
	double tmp_785_sup=a3_g_sup*a3_g_sup;

	double tmp_787_val=b3_g_val*b3_g_val;
	double tmp_787_sup=b3_g_sup*b3_g_sup;

	double tmp_788_val = tmp_785_val+tmp_787_val;
	double tmp_788_sup = tmp_785_sup+tmp_787_sup;
	{
	 static double _upper=4*eps1;
	 if (tmp_788_sup*_upper*correction<1)
	 {  tmp_788_sup = (tmp_788_val);
	   clear_sign_bit(tmp_788_sup);
	 }
	}

	D3_2_val = tmp_788_val;
	D3_2_sup = tmp_788_sup;

	// ******************* New Declaration
	double D12_val;
	double D12_sup;

	double tmp_791_val = D1_2_val*D2_2_val;
	double tmp_791_sup = D1_2_sup*D2_2_sup;

	double tmp_792_val=NaN_double;
	double tmp_792_sup=pInf_double;
	if ( tmp_791_sup==0 )
	   tmp_792_val=tmp_792_sup=0;
	else
	if (tmp_791_sup*(eps1*9)*correction<1)
	{  tmp_792_val = sqrt(tmp_791_val);
	   tmp_792_sup = tmp_792_val;
	}
	else
	{   if (tmp_791_val==0)
	    { tmp_792_val=0; 
	      tmp_792_sup=sqrt(tmp_791_sup)*sqrtMul;
	    }
	    else
	    {
	    tmp_792_val = sqrt(tmp_791_val);
	    tmp_792_sup = (tmp_791_sup/tmp_791_val)*tmp_792_val;
	    }
	}
	D12_val = tmp_792_val;
	D12_sup = tmp_792_sup;

	// ******************* New Declaration
	double D13_val;
	double D13_sup;

	double tmp_795_val = D1_2_val*D3_2_val;
	double tmp_795_sup = D1_2_sup*D3_2_sup;

	double tmp_796_val=NaN_double;
	double tmp_796_sup=pInf_double;
	if ( tmp_795_sup==0 )
	   tmp_796_val=tmp_796_sup=0;
	else
	if (tmp_795_sup*(eps1*9)*correction<1)
	{  tmp_796_val = sqrt(tmp_795_val);
	   tmp_796_sup = tmp_796_val;
	}
	else
	{   if (tmp_795_val==0)
	    { tmp_796_val=0; 
	      tmp_796_sup=sqrt(tmp_795_sup)*sqrtMul;
	    }
	    else
	    {
	    tmp_796_val = sqrt(tmp_795_val);
	    tmp_796_sup = (tmp_795_sup/tmp_795_val)*tmp_796_val;
	    }
	}
	D13_val = tmp_796_val;
	D13_sup = tmp_796_sup;

	// ********************* New Assignment
	double tmp_799_val = c1_g_val*b2_g_val;
	double tmp_799_sup = c1_g_sup*b2_g_sup;

	double tmp_802_val = c2_g_val*b1_g_val;
	double tmp_802_sup = c2_g_sup*b1_g_sup;

	double tmp_803_val = tmp_799_val-tmp_802_val;
	double tmp_803_sup = tmp_799_sup+tmp_802_sup;
	{
	 static double _upper=4*eps1;
	 if (tmp_803_sup*_upper*correction<1)
	 {  tmp_803_sup = (tmp_803_val);
	   clear_sign_bit(tmp_803_sup);
	 }
	}

	double tmp_805_val = tmp_803_val*D13_val;
	double tmp_805_sup = tmp_803_sup*D13_sup;

	double tmp_808_val = c2_g_val*b3_g_val;
	double tmp_808_sup = c2_g_sup*b3_g_sup;

	double tmp_811_val = c3_g_val*b2_g_val;
	double tmp_811_sup = c3_g_sup*b2_g_sup;

	double tmp_812_val = tmp_808_val-tmp_811_val;
	double tmp_812_sup = tmp_808_sup+tmp_811_sup;
	{
	 static double _upper=4*eps1;
	 if (tmp_812_sup*_upper*correction<1)
	 {  tmp_812_sup = (tmp_812_val);
	   clear_sign_bit(tmp_812_sup);
	 }
	}

	double tmp_814_val = tmp_812_val*D1_2_val;
	double tmp_814_sup = tmp_812_sup*D1_2_sup;

	double tmp_815_val = tmp_805_val+tmp_814_val;
	double tmp_815_sup = tmp_805_sup+tmp_814_sup;
	{
	 static double _upper=15*eps1;
	 if (tmp_815_sup*_upper*correction<1)
	 {  tmp_815_sup = (tmp_815_val);
	   clear_sign_bit(tmp_815_sup);
	 }
	}

	double tmp_818_val = c3_g_val*b1_g_val;
	double tmp_818_sup = c3_g_sup*b1_g_sup;

	double tmp_821_val = c1_g_val*b3_g_val;
	double tmp_821_sup = c1_g_sup*b3_g_sup;

	double tmp_822_val = tmp_818_val-tmp_821_val;
	double tmp_822_sup = tmp_818_sup+tmp_821_sup;
	{
	 static double _upper=4*eps1;
	 if (tmp_822_sup*_upper*correction<1)
	 {  tmp_822_sup = (tmp_822_val);
	   clear_sign_bit(tmp_822_sup);
	 }
	}

	double tmp_824_val = tmp_822_val*D12_val;
	double tmp_824_sup = tmp_822_sup*D12_sup;

	double tmp_825_val = tmp_815_val+tmp_824_val;
	double tmp_825_sup = tmp_815_sup+tmp_824_sup;
	{
	 static double _upper=16*eps1;
	 if (tmp_825_sup*_upper*correction<1)
	 {  tmp_825_sup = (tmp_825_val);
	   clear_sign_bit(tmp_825_sup);
	 }
	}

	xCoordD = tmp_825_val;
	xCoordDS = tmp_825_sup;
/* Index of xCoord is 16 */

	// ********************* New Assignment
	double tmp_828_val = c1_g_val*a2_g_val;
	double tmp_828_sup = c1_g_sup*a2_g_sup;

	double tmp_831_val = c2_g_val*a1_g_val;
	double tmp_831_sup = c2_g_sup*a1_g_sup;

	double tmp_832_val = tmp_828_val-tmp_831_val;
	double tmp_832_sup = tmp_828_sup+tmp_831_sup;
	{
	 static double _upper=4*eps1;
	 if (tmp_832_sup*_upper*correction<1)
	 {  tmp_832_sup = (tmp_832_val);
	   clear_sign_bit(tmp_832_sup);
	 }
	}

	double tmp_834_val = tmp_832_val*D13_val;
	double tmp_834_sup = tmp_832_sup*D13_sup;

	double tmp_837_val = c2_g_val*a3_g_val;
	double tmp_837_sup = c2_g_sup*a3_g_sup;

	double tmp_840_val = c3_g_val*a2_g_val;
	double tmp_840_sup = c3_g_sup*a2_g_sup;

	double tmp_841_val = tmp_837_val-tmp_840_val;
	double tmp_841_sup = tmp_837_sup+tmp_840_sup;
	{
	 static double _upper=4*eps1;
	 if (tmp_841_sup*_upper*correction<1)
	 {  tmp_841_sup = (tmp_841_val);
	   clear_sign_bit(tmp_841_sup);
	 }
	}

	double tmp_843_val = tmp_841_val*D1_2_val;
	double tmp_843_sup = tmp_841_sup*D1_2_sup;

	double tmp_844_val = tmp_834_val+tmp_843_val;
	double tmp_844_sup = tmp_834_sup+tmp_843_sup;
	{
	 static double _upper=15*eps1;
	 if (tmp_844_sup*_upper*correction<1)
	 {  tmp_844_sup = (tmp_844_val);
	   clear_sign_bit(tmp_844_sup);
	 }
	}

	double tmp_847_val = c3_g_val*a1_g_val;
	double tmp_847_sup = c3_g_sup*a1_g_sup;

	double tmp_850_val = c1_g_val*a3_g_val;
	double tmp_850_sup = c1_g_sup*a3_g_sup;

	double tmp_851_val = tmp_847_val-tmp_850_val;
	double tmp_851_sup = tmp_847_sup+tmp_850_sup;
	{
	 static double _upper=4*eps1;
	 if (tmp_851_sup*_upper*correction<1)
	 {  tmp_851_sup = (tmp_851_val);
	   clear_sign_bit(tmp_851_sup);
	 }
	}

	double tmp_853_val = tmp_851_val*D12_val;
	double tmp_853_sup = tmp_851_sup*D12_sup;

	double tmp_854_val = tmp_844_val+tmp_853_val;
	double tmp_854_sup = tmp_844_sup+tmp_853_sup;
	{
	 static double _upper=16*eps1;
	 if (tmp_854_sup*_upper*correction<1)
	 {  tmp_854_sup = (tmp_854_val);
	   clear_sign_bit(tmp_854_sup);
	 }
	}

	double tmp_855_val = -(tmp_854_val);
	double tmp_855_sup = tmp_854_sup;
	yCoordD = tmp_855_val;
	yCoordDS = tmp_855_sup;
/* Index of yCoord is 16 */

	// ********************* New Assignment
	double tmp_858_val = a1_g_val*b2_g_val;
	double tmp_858_sup = a1_g_sup*b2_g_sup;

	double tmp_861_val = a2_g_val*b1_g_val;
	double tmp_861_sup = a2_g_sup*b1_g_sup;

	double tmp_862_val = tmp_858_val-tmp_861_val;
	double tmp_862_sup = tmp_858_sup+tmp_861_sup;
	{
	 static double _upper=4*eps1;
	 if (tmp_862_sup*_upper*correction<1)
	 {  tmp_862_sup = (tmp_862_val);
	   clear_sign_bit(tmp_862_sup);
	 }
	}

	double tmp_864_val = tmp_862_val*D13_val;
	double tmp_864_sup = tmp_862_sup*D13_sup;

	double tmp_867_val = a2_g_val*b3_g_val;
	double tmp_867_sup = a2_g_sup*b3_g_sup;

	double tmp_870_val = a3_g_val*b2_g_val;
	double tmp_870_sup = a3_g_sup*b2_g_sup;

	double tmp_871_val = tmp_867_val-tmp_870_val;
	double tmp_871_sup = tmp_867_sup+tmp_870_sup;
	{
	 static double _upper=4*eps1;
	 if (tmp_871_sup*_upper*correction<1)
	 {  tmp_871_sup = (tmp_871_val);
	   clear_sign_bit(tmp_871_sup);
	 }
	}

	double tmp_873_val = tmp_871_val*D1_2_val;
	double tmp_873_sup = tmp_871_sup*D1_2_sup;

	double tmp_874_val = tmp_864_val+tmp_873_val;
	double tmp_874_sup = tmp_864_sup+tmp_873_sup;
	{
	 static double _upper=15*eps1;
	 if (tmp_874_sup*_upper*correction<1)
	 {  tmp_874_sup = (tmp_874_val);
	   clear_sign_bit(tmp_874_sup);
	 }
	}

	double tmp_877_val = a3_g_val*b1_g_val;
	double tmp_877_sup = a3_g_sup*b1_g_sup;

	double tmp_880_val = a1_g_val*b3_g_val;
	double tmp_880_sup = a1_g_sup*b3_g_sup;

	double tmp_881_val = tmp_877_val-tmp_880_val;
	double tmp_881_sup = tmp_877_sup+tmp_880_sup;
	{
	 static double _upper=4*eps1;
	 if (tmp_881_sup*_upper*correction<1)
	 {  tmp_881_sup = (tmp_881_val);
	   clear_sign_bit(tmp_881_sup);
	 }
	}

	double tmp_883_val = tmp_881_val*D12_val;
	double tmp_883_sup = tmp_881_sup*D12_sup;

	double tmp_884_val = tmp_874_val+tmp_883_val;
	double tmp_884_sup = tmp_874_sup+tmp_883_sup;
	{
	 static double _upper=16*eps1;
	 if (tmp_884_sup*_upper*correction<1)
	 {  tmp_884_sup = (tmp_884_val);
	   clear_sign_bit(tmp_884_sup);
	 }
	}

	double tmp_885_val = -(tmp_884_val);
	double tmp_885_sup = tmp_884_sup;
	wCoordD = tmp_885_val;
	wCoordDS = tmp_885_sup;
/* Index of wCoord is 16 */


return TRUE;
}





int ES_Voronoi_Diagram::
insert(const rat_point& q)
{
    TRACEN("\n>>----------------------------------<<");
    TRACE("ES.insert of ");TRACEN(q);
   rat_point p(q);
   if (p.W() != 1) {
     p = rat_point(round(p.xcoord()),round(p.ycoord()));
      error_handler(1,"insert: rounding point to grid!");
   }

   if (KnownPoints.lookup(p)==NULL)
   {
        KnownPoints.insert(p, 1);
        return Abstract_Voronoi_Diagram<p_vnode,p_site>::
               insert(p_site(site(p)));
   }
}

int ES_Voronoi_Diagram::
insert(const rat_segment& t)
{
    TRACEN("\n>>----------------------------------<<");
    TRACE("ES.insert of ");
    TRACEN(t);

    rat_segment s(t);
    if (s.is_trivial())
      return insert(s.source());
 
    if (s.W1() != 1 || s.W2() != 1) {
      s = rat_segment(round(s.xcoord1()),round(s.ycoord1()),
                      round(s.xcoord2()),round(s.ycoord2()));
      error_handler(1,"insert: rounding segment to grid!");
    }

    if (KnownPoints.lookup(s.start())==NULL)
    {
      KnownPoints.insert(s.start(), 1);
      p_site epnt1(site(s.start()));

      TRACEN("<<AVD.insert of epnt1");
      if (Abstract_Voronoi_Diagram<p_vnode,p_site>::
          insert(epnt1) == 0)
        return 0;
    }

    if (KnownPoints.lookup(s.end())==NULL)
    {
      KnownPoints.insert(s.end(), 1);
      p_site epnt2(site(s.end()));
      TRACEN("<<AVD.insert of epnt2");
      if (Abstract_Voronoi_Diagram<p_vnode,p_site>::
          insert(epnt2) == 0)
        return 0;
    }

      TRACEN("<<AVD.insert of interior seg");
    return Abstract_Voronoi_Diagram<p_vnode,p_site>::
           insert(p_site(site(s))); 
}


bool ES_Voronoi_Diagram::
insert(const rat_polygon& P)
{
    TRACEN("\n>>----------------------------------<<");
    TRACE("ES.insert of polygon");
    TRACEN(P);

  bool legal = true;
  list<rat_point> LP;
  rat_point p;
  forall (p, P.vertices())
  {
    if (p.W()!=1) {
      p = rat_point(round(p.xcoord()), round(p.ycoord()));
      error_handler(1,"insert: rounding point to grid!");
    }
    LP.append(p);
      
    if (legal) {
      legal = insert(p);
    }
  }

  rat_point p_prev,p_act,p_first;
  bool first = true;

  forall (p, LP) {
    if (legal)
    {
      if (first) {
        p_first = p_act = p;
        first = false;
      }
      else {
        p_prev = p_act;
        p_act  = p;
        legal = Abstract_Voronoi_Diagram<p_vnode,p_site>::insert(
                p_site(site(rat_segment(p_prev,p_act))));
      }
    }
  }

  if (legal)
    legal = Abstract_Voronoi_Diagram<p_vnode,p_site>::
            insert(p_site(site(rat_segment(p_act,p_first))));
  return legal;
}

//--------------------------------------------------------------------------

int ES_Voronoi_Diagram::
animated_insert(const rat_point& p, window& W, int pause)
{
    TRACEN("\n>>----------------------------------<<");
    TRACE("ES.animated_insert of "); TRACEN(p);
    ASSERT(p.W()==1,animated_insert_pnt);

  if (KnownPoints.lookup(p)==NULL) {
    dic_item dit = KnownPoints.insert(p,1);
    int retval = Abstract_Voronoi_Diagram<p_vnode,p_site>::
      animated_insert(p_site(site(p)),W,pause);
    if (retval == 0) 
    // to catch case where illegal point is repeatedly inserted
      KnownPoints.del_item(dit);
    return retval;
  }
  else 
    return 1;
}


int ES_Voronoi_Diagram::
animated_insert(const rat_segment& s, window& W, int pause)
{
    TRACEN("\n>>----------------------------------<<");
    TRACE("ES.animated_insert of "); TRACEN(s);
    ASSERT(s.W1()==1 && s.W2()==1,animated_insert_seg);

  if (s.is_trivial())
    return animated_insert(s.source(),W,pause);
  else {
    if (animated_insert(s.source(),W,pause) == 0)
      return 0;
    if (animated_insert(s.target(),W,pause) == 0)
      return 0;

        TRACEN("<<AVD.insert of interior seg");
    return Abstract_Voronoi_Diagram<p_vnode,p_site>::
      animated_insert(p_site(site(s)),W,pause); 
  }
}


bool ES_Voronoi_Diagram::
animated_insert(const rat_polygon& P, window& W, int pause)
{
    TRACEN("\n>>----------------------------------<<");
    TRACE("ES.animated_insert of polygon"); TRACEN(P);

  rat_point v;
  bool legal = true;
  forall (v, P.vertices())
    if (legal) legal = animated_insert(v,W,pause);

  rat_segment e;
  forall (e, P.edges())
    if (legal) legal = Abstract_Voronoi_Diagram<p_vnode,p_site>::
      animated_insert(p_site(site(e)),W,pause);

  return legal;
}



bool ES_Voronoi_Diagram::
init_is_possible(p_site t1, p_site t2, bool& error)
{
  if(error = illegal_intersection(t1,t2)) 
    return false;
  if ((*t1).is_pnt() && (*t2).is_pnt() && (*t1).rpnt()==(*t2).rpnt())
    return false;
  return true;
}



topology  ES_Voronoi_Diagram::
edge_intersection_topology(p_site p, p_site q, p_site r, p_site s, p_site t, 
                           p_vnode mr, p_vnode ms, bool& error)  
{ 
    TRACE(">>edge_intersection_topology: ");
    TRACE(*p);TRACE(*q);TRACE(*r);TRACE(*s);TRACEN(*t);

  {
    error = (illegal_intersection(p,t) || illegal_intersection(q,t) || 
             illegal_intersection(r,t) || illegal_intersection(s,t));
  }


  if (error)
    return NO_INTERSECTION;

  node_status pqr_status = calculate_node_status(p,q,r,t,mr);
  node_status psq_status = calculate_node_status(q,p,s,t,ms);
  topology result;

    TRACE(" node stati: ");TRACE(pqr_status);TRACEN(psq_status);

  /* in the following case switching the labels determine
     U (unaffected), A (affected), C (clipped) */
  switch(sorted_switch_label_i23(pqr_status,psq_status)){
  case UC: 
    result = TARGET_SEGMENT;
    break;
  case CU: 
    result = SOURCE_SEGMENT;
    break;
  case UA:  
    if (inner_point_on_edge_is_clipped(p,q,r,s,t,mr,ms))
      result = TARGET_SEGMENT;
    else
      result = NO_INTERSECTION;
    break;
  case AU: 
    if (inner_point_on_edge_is_clipped(p,q,r,s,t,mr,ms))
      result = SOURCE_SEGMENT;
    else
      result = NO_INTERSECTION;
    break;
  case CA:  
    if (inner_point_on_edge_remains(p,q,r,s,t,mr,ms))
      result = SOURCE_SEGMENT;
    else
      result = TOTAL;
    break;
  case AC: 
    if (inner_point_on_edge_remains(p,q,r,s,t,mr,ms))
      result = TARGET_SEGMENT;
    else
      result = TOTAL;
    break;
  case UU: 
    if (inner_point_on_edge_is_clipped(p,q,r,s,t,mr,ms))
      result = INTERN;
    else
      result = NO_INTERSECTION;
    break;
  case AA: 
    if (total_cut_when_both_affected(p,q,r,s,t,mr,ms))
      result = TOTAL;
    else
      result = NO_INTERSECTION;
    break;
  case CC: 
    if (inner_point_on_edge_remains(p,q,r,s,t,mr,ms))
      result = TWO_SEGMENTS;
    else
      result = TOTAL;
    break;
  }

    TRACE("return value = ");TRACEN(result);
  return result;
}



bool ES_Voronoi_Diagram::
inner_point_on_edge_is_clipped(p_site p, p_site q, p_site r, p_site s, 
                               p_site t, p_vnode mr, p_vnode ms)
{
    TRACE("  inner_point_on_edge_is_clipped ");  
    TRACE(*p);TRACE(*q);TRACE(*r);TRACE(*s);TRACEN(*t);

  {
    if (p == infinity())
      return (r == s && line_hull_and_order(r,q,t));
    if (q == infinity())
      return (r == s && line_hull_and_order(r,p,t));
  }


  
  /* now all sites are finite */
  
  if ((*t).is_seg())
    return false;    // see Lemma 10

  rat_point P;
  rat_segment sp,sq;
  p_vnode vl,vr;
  rat_point T = (*t).rpnt();
  switch(sorted_switch_label_b2((*p).is_pnt(),(*q).is_pnt())) {
  case tt_label: 
    return false; 
    break;
  case tf_label:
    P = (*p).rpnt(); 
    sq = (*q).rseg(); 
    vl = mr; 
    vr = ms;
    {
      int p_rel_sq = orientation(sq,P);
      if (p_rel_sq == ON)
        return false;
      else // $P \not\in l_q$
        if ((orientation(sq,T) == p_rel_sq) && 
            (cmp_pnt_line_distance(T,P,sq) < 0) && 
            perp_separates(sq,T,vl,vr)) 
          return true;
        else
          return false;
    }


    break;
  case ft_label:
    P = (*q).rpnt(); 
    sq = (*p).rseg(); 
    vl = ms; 
    vr = mr;
    {
      int p_rel_sq = orientation(sq,P);
      if (p_rel_sq == ON)
        return false;
      else // $P \not\in l_q$
        if ((orientation(sq,T) == p_rel_sq) && 
            (cmp_pnt_line_distance(T,P,sq) < 0) && 
            perp_separates(sq,T,vl,vr)) 
          return true;
        else
          return false;
    }


    break;
  case ff_label: 
    sp = (*p).rseg(); 
    sq = (*q).rseg(); 
    {
        LTRACEN("clipped inner point and ss");
      if (collinear(sp,sq))
      {
          LTRACEN("p and q collinear");
        return false;
      }
      else // $l_{sp} \neq l_{sq}$
      {
          LTRACEN("p and q not collinear");

        int m_rel_sp = orientation(sp,*mr);
        int m_rel_sq = orientation(sq,*mr);
        if (m_rel_sp == 0)
          m_rel_sp =  orientation(sp,*ms);
        if (m_rel_sq == 0)
          m_rel_sq =  orientation(sq,*ms);

        /* Lemma 9 demands that $T$ lies on the same side
           of the lines through |p| and |q| as the nodes
           |mr| and |ms|. However we have to cope with the
           fact, that |mr| (or |ms|) might be on both lines.
           In this case we check the corresponding other node
           as not both nodes can be on both lines */
        rat_segment s_close;
        p_vnode vl,vr;
        if (cmp_seg_pnt_distance(sp,sq,T) < 0)
        {
          s_close = sp;
          vl = ms;
          vr = mr;
        }
        else
        {
          s_close = sq;
          vl = mr;
          vr = ms;
        }

        if (orientation(sp,T) == m_rel_sp && 
            orientation(sq,T) == m_rel_sq && 
            perp_separates(s_close,T,vl,vr)) 
          return true;
        else
          return false;
      }
    }


    break;
  }  
}


bool  ES_Voronoi_Diagram::
total_cut_when_both_affected(p_site p, p_site q, p_site r, p_site s, 
                             p_site t, p_vnode mr, p_vnode ms)
{
    TRACE("  total_cut_when_both_affected ");  
    TRACE(*p);TRACE(*q);TRACE(*r);TRACE(*s);TRACEN(*t);

  rat_point P;
  rat_segment sq;
  switch(sorted_switch_label_b2((*p).is_pnt(),(*q).is_pnt())) {
  case tt_label: 
    return false; // |t| as pnt or seg 
    break;
  case tf_label:
    P = (*p).rpnt(); 
    sq = (*q).rseg();
    {
      if (collinear(sq,P)) // |P| is endpoint of |sq|
      {
        if ((*t).is_seg() && collinear((*t).rseg(),P))
          /* $l_t = l_q$ thus  |t| gets |P|'s Voronoi region */
          return true;
        else
          /* |t| seg tangentially touching the clearance circles
             or |t| is pnt (and equal to |P|) */
          return false;
      }
      else // $P \not\in l_{sq}$
      {
        if ((*t).is_pnt() &&
            cmp_pnt_line_distance((*t).rpnt(),P,sq) < 0)
          return true;
        else 
          /* |t| is pnt and further away from $l_q$ than |P| or equal to |P|
             or |t| is seg  tangentially touching the clearance circles */
          return false;      
      }
    }

    break;
  case ft_label:
    P = (*q).rpnt(); 
    sq = (*p).rseg();
    {
      if (collinear(sq,P)) // |P| is endpoint of |sq|
      {
        if ((*t).is_seg() && collinear((*t).rseg(),P))
          /* $l_t = l_q$ thus  |t| gets |P|'s Voronoi region */
          return true;
        else
          /* |t| seg tangentially touching the clearance circles
             or |t| is pnt (and equal to |P|) */
          return false;
      }
      else // $P \not\in l_{sq}$
      {
        if ((*t).is_pnt() &&
            cmp_pnt_line_distance((*t).rpnt(),P,sq) < 0)
          return true;
        else 
          /* |t| is pnt and further away from $l_q$ than |P| or equal to |P|
             or |t| is seg  tangentially touching the clearance circles */
          return false;      
      }
    }

    break;
  case ff_label: 
    {
      if (collinear((*p).rseg(),(*q).rseg()))
        return false;
      else
        return true;
    }


    break;
  }
}



bool  ES_Voronoi_Diagram::
inner_point_on_edge_remains(p_site p, p_site q, p_site r, p_site s, 
                            p_site t, p_vnode mr, p_vnode ms)
{
    TRACE("  inner_point_on_edge_remains ");  
    TRACE(*p);TRACE(*q);TRACE(*r);TRACE(*s);TRACEN(*t);

  {
    if (p == infinity())
      return (r == s && line_hull_and_order(r,t,q));
    if (q == infinity())
      return (r == s && line_hull_and_order(r,t,p));
  }

  
  rat_point P,Q;
  rat_segment sp,sq;
  p_vnode vr,vs;
  switch(sorted_switch_label_b2((*p).is_pnt(),(*q).is_pnt())) {
  case tt_label:
    P = (*p).rpnt(); 
    Q = (*q).rpnt(); 
    vr = mr; 
    vs = ms;
    {
        LTRACEN("remaining inner point and pp");
      if ((*t).is_pnt())
      {
          LTRACEN("t is pnt");
        return false;
      }
      else // |t| is segment
      {
        rat_segment st = (*t).rseg(); 
        if (collinear(st,P) || collinear(st,Q))
        {
            LTRACEN("p or q on l_t");
          return false;
        }

        int pq_rel_lt = cmp_pnt_line_distance(P,Q,st);
        if (pq_rel_lt == 0)
        {
            LTRACEN("p and q have equal distance from l_t");
          return false;
        }

        if (pq_rel_lt > 0) // |Q| closer to $l_{st}$ than |P|
        {
          leda_swap(P,Q);
          leda_swap(vs,vr);
        }

        /* now P is closer to $l_t$ than Q, note that vs or vr could
           be gamma_vnode when the node lies on $\Gamma$. */
        rat_segment tp_perp(perpendicular_base_point(st,P),P);

          LTRACEN("examination results: ");
          LTRACE(P);LTRACE(Q);LTRACEN(tp_perp); 
          if (vr!=gamma_node()) 
          {LTRACE(*vr);LTRACEN(orientation(tp_perp,*vr));}
          if (vs!=gamma_node()) 
          {LTRACE(*vs);LTRACEN(orientation(tp_perp,*vs));}

        if ((vs==gamma_node() || orientation(tp_perp,*vs) == LEFT) && 
            (vr==gamma_node() || orientation(tp_perp,*vr) == RIGHT))
          return true;
        else
          return false;
      }   
    }

    break;
  case tf_label:
    P = (*p).rpnt(); 
    sq = (*q).rseg(); 
    vr = mr; 
    vs = ms;
    {
        LTRACE("remaining inner point and ps");
      if (is_endpnt(P,sq)) { // |P| endpoint of segment |sq| 
          LTRACEN("P endpoint of q");
        if (t->is_seg() && is_endpnt(P,t->rseg()))
          return false;
        else
          return true; 
      }
      /* now |p| is not in $l_q$ */

      if ((*t).is_pnt())  {
          LTRACEN("t is point");
        if (cmp_pnt_line_distance(P,(*t).rpnt(),sq) < 0 &&
            perp_separates(sq,P,vr,vs))
          return true;
        else // |T| closer to |sq| than |P|
          return false;
      }

      /* now |t| is segment  */
      rat_segment st = (*t).rseg();

      // we have to examine if |P| is endpoint of |t| or not 

      int p_rel_t = orientation(st,P);
      if ((p_rel_t != ON) && perp_separates(st,P,vs,vr))
      {
        /* this separation case cannot happen with $P \in l_t$ 
           and both nodes clipped by |t| */
           LTRACEN("P not on l_t and sep argument");
         return true;
      }
     
      rat_segment tp_perp;
      if (p_rel_t == ON) 
      {
          LTRACEN("P on l_t");
        rat_point To = other_end(st,P);
        tp_perp = rat_segment(To.rotate90(P),P);       
        // by this construction the nodes should be left  
      } 
      else 
      { 
          LTRACEN("P not on l_t");
        tp_perp = rat_segment(perpendicular_base_point(st,P),P);
        if (orientation(tp_perp,*vr) == RIGHT)
          invert_seg(tp_perp);          
        if (orientation(tp_perp,*vs) == RIGHT)
          return false;
          // now we can guarantee that the nodes are both left of $l_t$
      }
      if (orientation(sq,*vr) == RIGHT)
        invert_seg(sq);             
        // also the nodes are left of $l_q$ now

      if (perp_separates(sq,P,vr,vs) && 
          less_than_right_angle(sq,tp_perp))
        return true;
      return false;        
    }


    break;
  case ft_label:
    P = (*q).rpnt(); 
    sq = (*p).rseg(); 
    vr = ms; 
    vs = mr; 
    {
        LTRACE("remaining inner point and ps");
      if (is_endpnt(P,sq)) { // |P| endpoint of segment |sq| 
          LTRACEN("P endpoint of q");
        if (t->is_seg() && is_endpnt(P,t->rseg()))
          return false;
        else
          return true; 
      }
      /* now |p| is not in $l_q$ */

      if ((*t).is_pnt())  {
          LTRACEN("t is point");
        if (cmp_pnt_line_distance(P,(*t).rpnt(),sq) < 0 &&
            perp_separates(sq,P,vr,vs))
          return true;
        else // |T| closer to |sq| than |P|
          return false;
      }

      /* now |t| is segment  */
      rat_segment st = (*t).rseg();

      // we have to examine if |P| is endpoint of |t| or not 

      int p_rel_t = orientation(st,P);
      if ((p_rel_t != ON) && perp_separates(st,P,vs,vr))
      {
        /* this separation case cannot happen with $P \in l_t$ 
           and both nodes clipped by |t| */
           LTRACEN("P not on l_t and sep argument");
         return true;
      }
     
      rat_segment tp_perp;
      if (p_rel_t == ON) 
      {
          LTRACEN("P on l_t");
        rat_point To = other_end(st,P);
        tp_perp = rat_segment(To.rotate90(P),P);       
        // by this construction the nodes should be left  
      } 
      else 
      { 
          LTRACEN("P not on l_t");
        tp_perp = rat_segment(perpendicular_base_point(st,P),P);
        if (orientation(tp_perp,*vr) == RIGHT)
          invert_seg(tp_perp);          
        if (orientation(tp_perp,*vs) == RIGHT)
          return false;
          // now we can guarantee that the nodes are both left of $l_t$
      }
      if (orientation(sq,*vr) == RIGHT)
        invert_seg(sq);             
        // also the nodes are left of $l_q$ now

      if (perp_separates(sq,P,vr,vs) && 
          less_than_right_angle(sq,tp_perp))
        return true;
      return false;        
    }


    break;
  case ff_label:
    sp = (*p).rseg(); 
    sq = (*q).rseg();
    {
      if (collinear(sp,sq))
        return true;
      else
        return false;
    }


    break;
  }
}



bool  ES_Voronoi_Diagram::
edge_is_intersected(p_site p, p_site q, p_site r, p_site s, p_site t, 
                    p_vnode mr, p_vnode ms, bool& error)
{
    TRACEN(">>edge_is_intersected: ");
    TRACE(*p);TRACE(*q);TRACE(*r);TRACE(*s);TRACEN(*t);

  {
    error = (illegal_intersection(p,t) || illegal_intersection(q,t) || 
             illegal_intersection(r,t) || illegal_intersection(s,t));
  }



    TRACE(" error status: ");TRACEN(error);

  if (error)
    return false;

  if ((*t).is_seg())
  /* in case that |t| is a segment we have to look first for a
     conflict with one of its endpoints, as we might hit edges
     within the history graph where the endpoints are not yet 
     inserted; if there is none we check with the interior */
  {
      TRACEN(" endpoint check first");
      site epnt1((*t).rseg().start(),false);
      site epnt2((*t).rseg().end(),false);
      if (edge_is_intersected(p,q,r,s,p_site(epnt1),mr,ms,error) || 
          edge_is_intersected(p,q,r,s,p_site(epnt2),mr,ms,error)) {
        /* there can be no error condition here, as endpoints
           are inserted before the interior and the error would
           have stopped the insertion there */
          TRACEN(" endpoint check already shows conflict");
        return true;
      }
  }

  node_status pqr_status = calculate_node_status(p,q,r,t,mr);
  node_status psq_status = calculate_node_status(q,p,s,t,ms);
  bool result;

    TRACE(" node stati: ");TRACE(pqr_status);TRACEN(psq_status);

  /* in the following case switching the labels determine
     U (unaffected), A (affected), C (clipped) */
  switch(sorted_switch_label_i23(pqr_status,psq_status)){
  case UC:
  case CU:
  case AC:
  case CA: 
  case CC: 
    result = true; 
    break;
  case UA: 
  case AU: 
  case UU: 
    result = inner_point_on_edge_is_clipped(p,q,r,s,t,mr,ms);
    break;
  case AA: 
    result = total_cut_when_both_affected(p,q,r,s,t,mr,ms);
    break;
  }  

    TRACE("return value = ");TRACEN(result);
  return result;
}


node_status  ES_Voronoi_Diagram::
calculate_node_status(p_site p, p_site q, p_site r, p_site t, p_vnode mr)
{
  {
    if (p == infinity())
      return infinite_node_status(q,r,t);
    if (q == infinity())
      return infinite_node_status(r,p,t);
    if (r == infinity())
      return infinite_node_status(p,q,t);
  }


  if ((*t).is_pnt())
    {
      int sgn_res = side_of_circle(mr,(*t).rpnt());
      switch (sgn_res) {
        case IN:  return CLIPPED;    break;
        case ON:  return AFFECTED;   break;
        case OUT: return UNAFFECTED; break;
      }
    }


  else
    {
        LTRACE("finite node status with |t| segment ");
        LTRACE(*mr);
        LTRACEN(*t);

      int sign_res;
      integer at,bt,ct;
      seg2line_paras((*t).rseg(),at,bt,ct);

      if ((*mr).nt() > 2) { // nt != SSS_xxx
        rat_point P = mr->csite(2).rpnt();

        CASESTAT(mr,t);

        {
          vnode& vr = *mr;
          // ******** Begin Expression Compiler Output
// **** Local Variables:
//		res
// **** External Variables:
//		P.X()
//		P.Y()
//		at
//		bt
//		ct
//		vr.w()
//		vr.x()
//		vr.y()
// **** Sign Result Variables:
//		sign_res

{
	// ****** Double evaluation
double P_X___g_val = P.XD();
double P_X___g_sup = float_abs(P_X___g_val);
double P_Y___g_val = P.YD();
double P_Y___g_sup = float_abs(P_Y___g_val);
double at_g_val = at.to_double();
double at_g_sup = float_abs(at_g_val);
double bt_g_val = bt.to_double();
double bt_g_sup = float_abs(bt_g_val);
double ct_g_val = ct.to_double();
double ct_g_sup = float_abs(ct_g_val);
double vr_w___g_val = vr.wD();
double vr_w___g_sup = (vr.wDS());
double vr_x___g_val = vr.xD();
double vr_x___g_sup = (vr.xDS());
double vr_y___g_val = vr.yD();
double vr_y___g_sup = (vr.yDS());




	// ******************* New Declaration
	double res_val;
	double res_sup;

	double tmp_889_val = at_g_val*vr_x___g_val;
	double tmp_889_sup = at_g_sup*vr_x___g_sup;

	double tmp_892_val = bt_g_val*vr_y___g_val;
	double tmp_892_sup = bt_g_sup*vr_y___g_sup;

	double tmp_893_val = tmp_889_val+tmp_892_val;
	double tmp_893_sup = tmp_889_sup+tmp_892_sup;

	double tmp_896_val = ct_g_val*vr_w___g_val;
	double tmp_896_sup = ct_g_sup*vr_w___g_sup;

	double tmp_897_val = tmp_893_val+tmp_896_val;
	double tmp_897_sup = tmp_893_sup+tmp_896_sup;

	double tmp_898_val=tmp_897_val*tmp_897_val;
	double tmp_898_sup=tmp_897_sup*tmp_897_sup;

	double tmp_900_val=at_g_val*at_g_val;
	double tmp_900_sup=at_g_sup*at_g_sup;

	double tmp_902_val=bt_g_val*bt_g_val;
	double tmp_902_sup=bt_g_sup*bt_g_sup;

	double tmp_903_val = tmp_900_val+tmp_902_val;
	double tmp_903_sup = tmp_900_sup+tmp_902_sup;

	double tmp_907_val = P_X___g_val*vr_w___g_val;
	double tmp_907_sup = P_X___g_sup*vr_w___g_sup;

	double tmp_908_val = vr_x___g_val-tmp_907_val;
	double tmp_908_sup = vr_x___g_sup+tmp_907_sup;

	double tmp_909_val=tmp_908_val*tmp_908_val;
	double tmp_909_sup=tmp_908_sup*tmp_908_sup;

	double tmp_913_val = P_Y___g_val*vr_w___g_val;
	double tmp_913_sup = P_Y___g_sup*vr_w___g_sup;

	double tmp_914_val = vr_y___g_val-tmp_913_val;
	double tmp_914_sup = vr_y___g_sup+tmp_913_sup;

	double tmp_915_val=tmp_914_val*tmp_914_val;
	double tmp_915_sup=tmp_914_sup*tmp_914_sup;

	double tmp_916_val = tmp_909_val+tmp_915_val;
	double tmp_916_sup = tmp_909_sup+tmp_915_sup;

	double tmp_917_val = tmp_903_val*tmp_916_val;
	double tmp_917_sup = tmp_903_sup*tmp_916_sup;

	double tmp_918_val = tmp_898_val-tmp_917_val;
	double tmp_918_sup = tmp_898_sup+tmp_917_sup;

	res_val = tmp_918_val;
	res_sup = tmp_918_sup;

	// ***************** Sign Statement
	// ******* BitLength of Expression is 0
	// ******* Index of Expression is 98
	{
	  static double _upper=98*eps1;
	  if ( float_abs(res_val) > res_sup*_upper*correction )
		sign_res = float_sign(res_val);
	  else if (res_sup==0)
		sign_res = 0;
	  else
		sign_res = NO_IDEA;
	}
}
if ( ((sign_res==NO_IDEA) || FALSE ) && (vr.IsRat()) ) 
	// ***** Integer evaluation
{
	int _valid=TRUE;
	{
integer P_X___g_val = P.X();
integer P_Y___g_val = P.Y();
integer at_g_val = at;
integer bt_g_val = bt;
integer ct_g_val = ct;
integer vr_w___g_val = vr.wI();
integer vr_x___g_val = vr.xI();
integer vr_y___g_val = vr.yI();




	// ******************* New Declaration
	integer res_val;

	if (_valid==TRUE)
	{
	integer tmp_889_val = at_g_val*vr_x___g_val;

	integer tmp_892_val = bt_g_val*vr_y___g_val;

	integer tmp_893_val = tmp_889_val+tmp_892_val;

	integer tmp_896_val = ct_g_val*vr_w___g_val;

	integer tmp_897_val = tmp_893_val+tmp_896_val;

	integer tmp_898_val=tmp_897_val*tmp_897_val;
	integer tmp_900_val=at_g_val*at_g_val;
	integer tmp_902_val=bt_g_val*bt_g_val;
	integer tmp_903_val = tmp_900_val+tmp_902_val;

	integer tmp_907_val = P_X___g_val*vr_w___g_val;

	integer tmp_908_val = vr_x___g_val-tmp_907_val;

	integer tmp_909_val=tmp_908_val*tmp_908_val;
	integer tmp_913_val = P_Y___g_val*vr_w___g_val;

	integer tmp_914_val = vr_y___g_val-tmp_913_val;

	integer tmp_915_val=tmp_914_val*tmp_914_val;
	integer tmp_916_val = tmp_909_val+tmp_915_val;

	integer tmp_917_val = tmp_903_val*tmp_916_val;

	integer tmp_918_val = tmp_898_val-tmp_917_val;

		res_val = tmp_918_val;
	}

	// ***************** Sign Statement
	if (_valid==TRUE)
		sign_res = sign(res_val);
	else
		sign_res = NO_IDEA;
	}
}
if ((sign_res==NO_IDEA) || FALSE )
	// ***** Exact Evaluation
	{
	real res = (sq((((at*vr.x())+(bt*vr.y()))+(ct*vr.w())))-((sq(at)+sq(bt))*(sq((vr.x()-(P.X()*vr.w())))+sq((vr.y()-(P.Y()*vr.w()))))));
	sign_res = sign(res);
	}
// ******** End Expression Compiler Output

        }

          ZEROSTAT(mr,t,sign_res);
          LTRACE("point compare (l_t-circle-pos) = ");LTRACEN(sign(res));
      }
      else { // we only have segments
        integer a1,b1,c1;
        seg2line_paras((*mr).csite(0).rseg(),a1,b1,c1);

          CASESTAT(mr,t);

        {
          vnode& vr = *mr;
          // ******** Begin Expression Compiler Output
// **** Local Variables:
//		res
// **** External Variables:
//		a1
//		at
//		b1
//		bt
//		c1
//		ct
//		vr.w()
//		vr.x()
//		vr.y()
// **** Sign Result Variables:
//		sign_res

{
	// ****** Double evaluation
double a1_g_val = a1.to_double();
double a1_g_sup = float_abs(a1_g_val);
double at_g_val = at.to_double();
double at_g_sup = float_abs(at_g_val);
double b1_g_val = b1.to_double();
double b1_g_sup = float_abs(b1_g_val);
double bt_g_val = bt.to_double();
double bt_g_sup = float_abs(bt_g_val);
double c1_g_val = c1.to_double();
double c1_g_sup = float_abs(c1_g_val);
double ct_g_val = ct.to_double();
double ct_g_sup = float_abs(ct_g_val);
double vr_w___g_val = vr.wD();
double vr_w___g_sup = (vr.wDS());
double vr_x___g_val = vr.xD();
double vr_x___g_sup = (vr.xDS());
double vr_y___g_val = vr.yD();
double vr_y___g_sup = (vr.yDS());




	// ******************* New Declaration
	double res_val;
	double res_sup;

	double tmp_923_val = at_g_val*vr_x___g_val;
	double tmp_923_sup = at_g_sup*vr_x___g_sup;

	double tmp_926_val = bt_g_val*vr_y___g_val;
	double tmp_926_sup = bt_g_sup*vr_y___g_sup;

	double tmp_927_val = tmp_923_val+tmp_926_val;
	double tmp_927_sup = tmp_923_sup+tmp_926_sup;

	double tmp_930_val = ct_g_val*vr_w___g_val;
	double tmp_930_sup = ct_g_sup*vr_w___g_sup;

	double tmp_931_val = tmp_927_val+tmp_930_val;
	double tmp_931_sup = tmp_927_sup+tmp_930_sup;

	double tmp_932_val=tmp_931_val*tmp_931_val;
	double tmp_932_sup=tmp_931_sup*tmp_931_sup;

	double tmp_934_val=a1_g_val*a1_g_val;
	double tmp_934_sup=a1_g_sup*a1_g_sup;

	double tmp_936_val=b1_g_val*b1_g_val;
	double tmp_936_sup=b1_g_sup*b1_g_sup;

	double tmp_937_val = tmp_934_val+tmp_936_val;
	double tmp_937_sup = tmp_934_sup+tmp_936_sup;

	double tmp_938_val = tmp_932_val*tmp_937_val;
	double tmp_938_sup = tmp_932_sup*tmp_937_sup;

	double tmp_941_val = a1_g_val*vr_x___g_val;
	double tmp_941_sup = a1_g_sup*vr_x___g_sup;

	double tmp_944_val = b1_g_val*vr_y___g_val;
	double tmp_944_sup = b1_g_sup*vr_y___g_sup;

	double tmp_945_val = tmp_941_val+tmp_944_val;
	double tmp_945_sup = tmp_941_sup+tmp_944_sup;

	double tmp_948_val = c1_g_val*vr_w___g_val;
	double tmp_948_sup = c1_g_sup*vr_w___g_sup;

	double tmp_949_val = tmp_945_val+tmp_948_val;
	double tmp_949_sup = tmp_945_sup+tmp_948_sup;

	double tmp_950_val=tmp_949_val*tmp_949_val;
	double tmp_950_sup=tmp_949_sup*tmp_949_sup;

	double tmp_952_val=at_g_val*at_g_val;
	double tmp_952_sup=at_g_sup*at_g_sup;

	double tmp_954_val=bt_g_val*bt_g_val;
	double tmp_954_sup=bt_g_sup*bt_g_sup;

	double tmp_955_val = tmp_952_val+tmp_954_val;
	double tmp_955_sup = tmp_952_sup+tmp_954_sup;

	double tmp_956_val = tmp_950_val*tmp_955_val;
	double tmp_956_sup = tmp_950_sup*tmp_955_sup;

	double tmp_957_val = tmp_938_val-tmp_956_val;
	double tmp_957_sup = tmp_938_sup+tmp_956_sup;

	res_val = tmp_957_val;
	res_sup = tmp_957_sup;

	// ***************** Sign Statement
	// ******* BitLength of Expression is 0
	// ******* Index of Expression is 99
	{
	  static double _upper=99*eps1;
	  if ( float_abs(res_val) > res_sup*_upper*correction )
		sign_res = float_sign(res_val);
	  else if (res_sup==0)
		sign_res = 0;
	  else
		sign_res = NO_IDEA;
	}
}
if ( ((sign_res==NO_IDEA) || FALSE ) && (vr.IsRat()) ) 
	// ***** Integer evaluation
{
	int _valid=TRUE;
	{
integer a1_g_val = a1;
integer at_g_val = at;
integer b1_g_val = b1;
integer bt_g_val = bt;
integer c1_g_val = c1;
integer ct_g_val = ct;
integer vr_w___g_val = vr.wI();
integer vr_x___g_val = vr.xI();
integer vr_y___g_val = vr.yI();




	// ******************* New Declaration
	integer res_val;

	if (_valid==TRUE)
	{
	integer tmp_923_val = at_g_val*vr_x___g_val;

	integer tmp_926_val = bt_g_val*vr_y___g_val;

	integer tmp_927_val = tmp_923_val+tmp_926_val;

	integer tmp_930_val = ct_g_val*vr_w___g_val;

	integer tmp_931_val = tmp_927_val+tmp_930_val;

	integer tmp_932_val=tmp_931_val*tmp_931_val;
	integer tmp_934_val=a1_g_val*a1_g_val;
	integer tmp_936_val=b1_g_val*b1_g_val;
	integer tmp_937_val = tmp_934_val+tmp_936_val;

	integer tmp_938_val = tmp_932_val*tmp_937_val;

	integer tmp_941_val = a1_g_val*vr_x___g_val;

	integer tmp_944_val = b1_g_val*vr_y___g_val;

	integer tmp_945_val = tmp_941_val+tmp_944_val;

	integer tmp_948_val = c1_g_val*vr_w___g_val;

	integer tmp_949_val = tmp_945_val+tmp_948_val;

	integer tmp_950_val=tmp_949_val*tmp_949_val;
	integer tmp_952_val=at_g_val*at_g_val;
	integer tmp_954_val=bt_g_val*bt_g_val;
	integer tmp_955_val = tmp_952_val+tmp_954_val;

	integer tmp_956_val = tmp_950_val*tmp_955_val;

	integer tmp_957_val = tmp_938_val-tmp_956_val;

		res_val = tmp_957_val;
	}

	// ***************** Sign Statement
	if (_valid==TRUE)
		sign_res = sign(res_val);
	else
		sign_res = NO_IDEA;
	}
}
if ((sign_res==NO_IDEA) || FALSE )
	// ***** Exact Evaluation
	{
	real res = ((sq((((at*vr.x())+(bt*vr.y()))+(ct*vr.w())))*(sq(a1)+sq(b1)))-(sq((((a1*vr.x())+(b1*vr.y()))+(c1*vr.w())))*(sq(at)+sq(bt))));
	sign_res = sign(res);
	}
// ******** End Expression Compiler Output

        }

          ZEROSTAT(mr,t,sign_res);
          LTRACE("all seg compare (l_t-circle-pos) = ");LTRACEN(sign(res));
      }
      // now we know if the line supporting |t| intersects our circle
      // accuracy adaptation needed ?

      switch (sign_res) {
        case IN: // the line $l_t$ intersects the circle
          if (side_of_circle(mr,(*t).rseg().start()) < 0 ||
              side_of_circle(mr,(*t).rseg().end()) < 0 ||
              is_in_end_perp_stripe((*t).rseg(),mr))
            return CLIPPED;
          else
            return UNAFFECTED;
          break;
        case ON:  // the line $l_t$ touches the circle
          if (is_in_end_perp_stripe((*t).rseg(),mr))
            return AFFECTED;
          else
            return UNAFFECTED;
          break;
        case OUT: // the line $l_t$ passes the circle 
          return UNAFFECTED;
          break;
      }
    }

  error_handler(1,"calculate_node_status: should not end here");
}


node_status  ES_Voronoi_Diagram::
infinite_node_status(p_site p, p_site q, p_site t)
{
    TRACE("  infinite_node_status ");
    TRACE(*p);TRACE(*q);TRACE(*t);

  node_status result;

  switch(sorted_switch_label_b2((*p).is_pnt(),(*q).is_pnt())) {
  case tt_label: 
      ASSERT(((*p).rpnt()!=(*q).rpnt()),infinite_node_status);

    if ((*t).is_pnt())
    {
      /* the infinity node disappears if
         - |t| is right of $\overline{pq}$
         - |t| is in the interior of $\overline{pq}$ */

      int pqt_or = orientation((*p).rpnt(),(*q).rpnt(),(*t).rpnt());

      if (pqt_or == RIGHT || 
          (pqt_or == ON && 
           collinear_ordered((*p).rpnt(),(*t).rpnt(),(*q).rpnt())))
        result = CLIPPED;
      else
        result = UNAFFECTED;
    }
    else // |(*t).is_seg()|
    {
      /* the infinity node disappears if
         - one of the endpoints is right of $\overline{pq}$
         - one of the endpoints is in the interior of $\overline{pq}$
         - the segment is the interior of $\overline{pq}$ */

      rat_point Ts = (*t).rseg().start();
      rat_point Te = (*t).rseg().end();
      int pqtstart_or = orientation((*p).rpnt(),(*q).rpnt(),Ts);
      int pqtend_or = orientation((*p).rpnt(),(*q).rpnt(),Te);
      if (pqtstart_or == RIGHT || pqtend_or == RIGHT || 
          (pqtstart_or == ON && collinear_ordered((*p).rpnt(),Ts,(*q).rpnt())) || 
          (pqtend_or == ON && collinear_ordered((*p).rpnt(),Te,(*q).rpnt())) || 
          (is_endpnt((*p).rpnt(),(*t).rseg()) && 
           is_endpnt((*q).rpnt(),(*t).rseg())))
        result = CLIPPED;
      else
        result = UNAFFECTED;
    }
    break;

  case tf_label: 
      ASSERT((is_endpnt((*p).rpnt(),(*q).rseg())),infinite_node_status);
    if ((*t).is_pnt())
    {
      rat_point P = (*p).rpnt();
      rat_point Q = other_end((*q).rseg(),P);
      if (right_turn(P,Q,(*t).rpnt()))
        result = CLIPPED;
      else
        result = UNAFFECTED;
    }
    else // |(*t).is_seg()|
    {
      rat_point P = (*p).rpnt();
      rat_point Q = other_end((*q).rseg(),P);
      rat_point Ts = (*t).rseg().start();
      rat_point Te = (*t).rseg().end();
      int pqtstart_or = orientation(P,Q,Ts);
      int pqtend_or = orientation(P,Q,Te);
      if (pqtstart_or == RIGHT || pqtend_or == RIGHT || 
          (pqtstart_or == ON && pqtend_or == ON && 
           is_endpnt(P,(*t).rseg())))
        result = CLIPPED;
      else
        result = UNAFFECTED;       
    }
    break;

  case ft_label: 
      ASSERT((is_endpnt((*q).rpnt(),(*p).rseg())),infinite_node_status);
    if ((*t).is_pnt())
    {
      rat_point Q = (*q).rpnt();
      rat_point P = other_end((*p).rseg(),Q);
      if (right_turn(P,Q,(*t).rpnt()))
        result = CLIPPED;
      else
        result = UNAFFECTED;
    }
    else // |(*t).is_seg()|
    {
      rat_point Q = (*q).rpnt();
      rat_point P = other_end((*p).rseg(),Q);
      rat_point Ts = (*t).rseg().start();
      rat_point Te = (*t).rseg().end();
      int pqtstart_or = orientation(P,Q,Ts);
      int pqtend_or = orientation(P,Q,Te);
      if (pqtstart_or == RIGHT || pqtend_or == RIGHT || 
          (pqtstart_or == ON && pqtend_or == ON && 
           is_endpnt(Q,(*t).rseg())))
        result = CLIPPED;
      else
        result = UNAFFECTED;       
    }
    break;

  case ff_label: 
      ASSERT((collinear((*p).rseg(),(*q).rseg()) && 
              (is_endpnt((*p).rseg().start(),(*q).rseg()) || 
               is_endpnt((*p).rseg().end(),(*q).rseg()))), 
             infinite_node_status);

    if ((*t).is_pnt())
    {
      rat_point P = (*p).rseg().start();
      rat_point Q = other_end((*q).rseg(),P);
      if (right_turn(P,Q,(*t).rpnt()))
        result = CLIPPED;
      else
        result = UNAFFECTED;
    }
    else // |(*t).is_seg()|
    {
      rat_point P = (*p).rseg().start();
      rat_point Q = other_end((*q).rseg(),P);
      rat_point Ts = (*t).rseg().start();
      rat_point Te = (*t).rseg().end();
      int pqtstart_or = orientation(P,Q,Ts);
      int pqtend_or = orientation(P,Q,Te);
      if (pqtstart_or == RIGHT || pqtend_or == RIGHT)
        result = CLIPPED;
      else
        result = UNAFFECTED;       
    }
    break;
  }  

    TRACEN(result);
  return result;
}


int ES_Voronoi_Diagram::
side_of_circle(p_vnode vn, const rat_point& T)
{
    LTRACE("side_of_circle ");
    LTRACE(*vn);
    LTRACEN(T);

  int sign_res = NO_IDEA;
  vnode& v = *vn;
  node_type nt=v.nt();

  if (nt==PPP) {
    if (T==(v.csite(2).rpnt())) sign_res=0;
    if (T==(v.csite(1).rpnt())) sign_res=0;
    if (T==(v.csite(0).rpnt())) sign_res=0;

  }
  if (nt==SPP_distdiff || nt==SPP_disteq) {
    if (T==(v.csite(2).rpnt())) sign_res=0;
    if (T==(v.csite(1).rpnt())) sign_res=0;
  }
  if (nt==SSP_alltouch || nt==SSP_notcoll || nt==SSP_coltouch) {
    if (T==(v.csite(2).rpnt())) sign_res=0;
  }

  if (sign_res!=NO_IDEA) {
    LTRACE("Jump out ");LTRACEN(v.nt());
    return sign_res;
  } else {
    LTRACE("No jump: ");LTRACE((T==(v.csite(2).rpnt())));LTRACEN(v.nt());
  }

  if (v.nt() > 2) { // != SSS_xxx
    rat_point P=v.csite(2).rpnt();
      CASESTAT(vn,t);
    {
    // ******** Begin Expression Compiler Output
// **** Local Variables:
//		res
// **** External Variables:
//		P.X()
//		P.Y()
//		T.X()
//		T.Y()
//		v.w()
//		v.x()
//		v.y()
// **** Sign Result Variables:
//		sign_res

{
	// ****** Double evaluation
double P_X___g_val = P.XD();
double P_X___g_sup = float_abs(P_X___g_val);
double P_Y___g_val = P.YD();
double P_Y___g_sup = float_abs(P_Y___g_val);
double T_X___g_val = T.XD();
double T_X___g_sup = float_abs(T_X___g_val);
double T_Y___g_val = T.YD();
double T_Y___g_sup = float_abs(T_Y___g_val);
double v_w___g_val = v.wD();
double v_w___g_sup = (v.wDS());
double v_x___g_val = v.xD();
double v_x___g_sup = (v.xDS());
double v_y___g_val = v.yD();
double v_y___g_sup = (v.yDS());




	// ******************* New Declaration
	double res_val;
	double res_sup;

	// ********************* New Assignment
	double tmp_962_val=T_X___g_val*T_X___g_val;
	double tmp_962_sup=T_X___g_sup*T_X___g_sup;

	double tmp_964_val=T_Y___g_val*T_Y___g_val;
	double tmp_964_sup=T_Y___g_sup*T_Y___g_sup;

	double tmp_965_val = tmp_962_val+tmp_964_val;
	double tmp_965_sup = tmp_962_sup+tmp_964_sup;

	double tmp_967_val=P_X___g_val*P_X___g_val;
	double tmp_967_sup=P_X___g_sup*P_X___g_sup;

	double tmp_968_val = tmp_965_val-tmp_967_val;
	double tmp_968_sup = tmp_965_sup+tmp_967_sup;

	double tmp_970_val=P_Y___g_val*P_Y___g_val;
	double tmp_970_sup=P_Y___g_sup*P_Y___g_sup;

	double tmp_971_val = tmp_968_val-tmp_970_val;
	double tmp_971_sup = tmp_968_sup+tmp_970_sup;

	double tmp_972_val = v_w___g_val*tmp_971_val;
	double tmp_972_sup = v_w___g_sup*tmp_971_sup;

	double tmp_977_val = P_X___g_val-T_X___g_val;
	double tmp_977_sup = P_X___g_sup+T_X___g_sup;

	double tmp_978_val = v_x___g_val*tmp_977_val;
	double tmp_978_sup = v_x___g_sup*tmp_977_sup;

	double tmp_982_val = P_Y___g_val-T_Y___g_val;
	double tmp_982_sup = P_Y___g_sup+T_Y___g_sup;

	double tmp_983_val = v_y___g_val*tmp_982_val;
	double tmp_983_sup = v_y___g_sup*tmp_982_sup;

	double tmp_984_val = tmp_978_val+tmp_983_val;
	double tmp_984_sup = tmp_978_sup+tmp_983_sup;

	double tmp_985_val = 2*tmp_984_val;
	double tmp_985_sup = 2*tmp_984_sup;

	double tmp_986_val = tmp_972_val+tmp_985_val;
	double tmp_986_sup = tmp_972_sup+tmp_985_sup;

	res_val = tmp_986_val;
	res_sup = tmp_986_sup;

	// ***************** Sign Statement
	// ******* BitLength of Expression is 0
	// ******* Index of Expression is 50
	{
	  static double _upper=50*eps1;
	  if ( float_abs(res_val) > res_sup*_upper*correction )
		sign_res = float_sign(res_val);
	  else if (res_sup==0)
		sign_res = 0;
	  else
		sign_res = NO_IDEA;
	}
}
if ( ((sign_res==NO_IDEA) || FALSE ) && (v.IsRat()) ) 
	// ***** Integer evaluation
{
	int _valid=TRUE;
	{
integer P_X___g_val = P.X();
integer P_Y___g_val = P.Y();
integer T_X___g_val = T.X();
integer T_Y___g_val = T.Y();
integer v_w___g_val = v.wI();
integer v_x___g_val = v.xI();
integer v_y___g_val = v.yI();




	// ******************* New Declaration
	integer res_val;

	// ********************* New Assignment
	if (_valid==TRUE)
	{
	integer tmp_962_val=T_X___g_val*T_X___g_val;
	integer tmp_964_val=T_Y___g_val*T_Y___g_val;
	integer tmp_965_val = tmp_962_val+tmp_964_val;

	integer tmp_967_val=P_X___g_val*P_X___g_val;
	integer tmp_968_val = tmp_965_val-tmp_967_val;

	integer tmp_970_val=P_Y___g_val*P_Y___g_val;
	integer tmp_971_val = tmp_968_val-tmp_970_val;

	integer tmp_972_val = v_w___g_val*tmp_971_val;

	integer tmp_977_val = P_X___g_val-T_X___g_val;

	integer tmp_978_val = v_x___g_val*tmp_977_val;

	integer tmp_982_val = P_Y___g_val-T_Y___g_val;

	integer tmp_983_val = v_y___g_val*tmp_982_val;

	integer tmp_984_val = tmp_978_val+tmp_983_val;

	integer tmp_985_val = 2*tmp_984_val;

	integer tmp_986_val = tmp_972_val+tmp_985_val;

	res_val = tmp_986_val;
	}

	// ***************** Sign Statement
	if (_valid==TRUE)
		sign_res = sign(res_val);
	else
		sign_res = NO_IDEA;
	}
}
if ((sign_res==NO_IDEA) || FALSE )
	// ***** Exact Evaluation
	{
	real res;
	res = ((v.w()*(((sq(T.X())+sq(T.Y()))-sq(P.X()))-sq(P.Y())))+(2*((v.x()*(P.X()-T.X()))+(v.y()*(P.Y()-T.Y())))));
	sign_res = sign(res);
	}
// ******** End Expression Compiler Output

    }
      ZEROSTAT(vn,t,sign_res);
  } 
  else { // SSS comparison follows (we have no point on the circle)
    integer a1,b1,c1;
    seg2line_paras(v.csite(0).rseg(),a1,b1,c1);
      CASESTAT(vn,t);
    {
    // ******** Begin Expression Compiler Output
// **** Local Variables:
//		res
// **** External Variables:
//		T.X()
//		T.Y()
//		a1
//		b1
//		c1
//		v.w()
//		v.x()
//		v.y()
// **** Sign Result Variables:
//		sign_res

{
	// ****** Double evaluation
double T_X___g_val = T.XD();
double T_X___g_sup = float_abs(T_X___g_val);
double T_Y___g_val = T.YD();
double T_Y___g_sup = float_abs(T_Y___g_val);
double a1_g_val = a1.to_double();
double a1_g_sup = float_abs(a1_g_val);
double b1_g_val = b1.to_double();
double b1_g_sup = float_abs(b1_g_val);
double c1_g_val = c1.to_double();
double c1_g_sup = float_abs(c1_g_val);
double v_w___g_val = v.wD();
double v_w___g_sup = (v.wDS());
double v_x___g_val = v.xD();
double v_x___g_sup = (v.xDS());
double v_y___g_val = v.yD();
double v_y___g_sup = (v.yDS());




	// ******************* New Declaration
	double res_val;
	double res_sup;

	double tmp_990_val=a1_g_val*a1_g_val;
	double tmp_990_sup=a1_g_sup*a1_g_sup;

	double tmp_992_val=b1_g_val*b1_g_val;
	double tmp_992_sup=b1_g_sup*b1_g_sup;

	double tmp_993_val = tmp_990_val+tmp_992_val;
	double tmp_993_sup = tmp_990_sup+tmp_992_sup;

	double tmp_997_val = T_X___g_val*v_w___g_val;
	double tmp_997_sup = T_X___g_sup*v_w___g_sup;

	double tmp_998_val = v_x___g_val-tmp_997_val;
	double tmp_998_sup = v_x___g_sup+tmp_997_sup;

	double tmp_999_val=tmp_998_val*tmp_998_val;
	double tmp_999_sup=tmp_998_sup*tmp_998_sup;

	double tmp_1003_val = T_Y___g_val*v_w___g_val;
	double tmp_1003_sup = T_Y___g_sup*v_w___g_sup;

	double tmp_1004_val = v_y___g_val-tmp_1003_val;
	double tmp_1004_sup = v_y___g_sup+tmp_1003_sup;

	double tmp_1005_val=tmp_1004_val*tmp_1004_val;
	double tmp_1005_sup=tmp_1004_sup*tmp_1004_sup;

	double tmp_1006_val = tmp_999_val+tmp_1005_val;
	double tmp_1006_sup = tmp_999_sup+tmp_1005_sup;

	double tmp_1007_val = tmp_993_val*tmp_1006_val;
	double tmp_1007_sup = tmp_993_sup*tmp_1006_sup;

	double tmp_1010_val = a1_g_val*v_x___g_val;
	double tmp_1010_sup = a1_g_sup*v_x___g_sup;

	double tmp_1013_val = b1_g_val*v_y___g_val;
	double tmp_1013_sup = b1_g_sup*v_y___g_sup;

	double tmp_1014_val = tmp_1010_val+tmp_1013_val;
	double tmp_1014_sup = tmp_1010_sup+tmp_1013_sup;

	double tmp_1017_val = c1_g_val*v_w___g_val;
	double tmp_1017_sup = c1_g_sup*v_w___g_sup;

	double tmp_1018_val = tmp_1014_val+tmp_1017_val;
	double tmp_1018_sup = tmp_1014_sup+tmp_1017_sup;

	double tmp_1019_val=tmp_1018_val*tmp_1018_val;
	double tmp_1019_sup=tmp_1018_sup*tmp_1018_sup;

	double tmp_1020_val = tmp_1007_val-tmp_1019_val;
	double tmp_1020_sup = tmp_1007_sup+tmp_1019_sup;

	res_val = tmp_1020_val;
	res_sup = tmp_1020_sup;

	// ***************** Sign Statement
	// ******* BitLength of Expression is 0
	// ******* Index of Expression is 50
	{
	  static double _upper=50*eps1;
	  if ( float_abs(res_val) > res_sup*_upper*correction )
		sign_res = float_sign(res_val);
	  else if (res_sup==0)
		sign_res = 0;
	  else
		sign_res = NO_IDEA;
	}
}
if ( ((sign_res==NO_IDEA) || FALSE ) && (v.IsRat()) ) 
	// ***** Integer evaluation
{
	int _valid=TRUE;
	{
integer T_X___g_val = T.X();
integer T_Y___g_val = T.Y();
integer a1_g_val = a1;
integer b1_g_val = b1;
integer c1_g_val = c1;
integer v_w___g_val = v.wI();
integer v_x___g_val = v.xI();
integer v_y___g_val = v.yI();




	// ******************* New Declaration
	integer res_val;

	if (_valid==TRUE)
	{
	integer tmp_990_val=a1_g_val*a1_g_val;
	integer tmp_992_val=b1_g_val*b1_g_val;
	integer tmp_993_val = tmp_990_val+tmp_992_val;

	integer tmp_997_val = T_X___g_val*v_w___g_val;

	integer tmp_998_val = v_x___g_val-tmp_997_val;

	integer tmp_999_val=tmp_998_val*tmp_998_val;
	integer tmp_1003_val = T_Y___g_val*v_w___g_val;

	integer tmp_1004_val = v_y___g_val-tmp_1003_val;

	integer tmp_1005_val=tmp_1004_val*tmp_1004_val;
	integer tmp_1006_val = tmp_999_val+tmp_1005_val;

	integer tmp_1007_val = tmp_993_val*tmp_1006_val;

	integer tmp_1010_val = a1_g_val*v_x___g_val;

	integer tmp_1013_val = b1_g_val*v_y___g_val;

	integer tmp_1014_val = tmp_1010_val+tmp_1013_val;

	integer tmp_1017_val = c1_g_val*v_w___g_val;

	integer tmp_1018_val = tmp_1014_val+tmp_1017_val;

	integer tmp_1019_val=tmp_1018_val*tmp_1018_val;
	integer tmp_1020_val = tmp_1007_val-tmp_1019_val;

		res_val = tmp_1020_val;
	}

	// ***************** Sign Statement
	if (_valid==TRUE)
		sign_res = sign(res_val);
	else
		sign_res = NO_IDEA;
	}
}
if ((sign_res==NO_IDEA) || FALSE )
	// ***** Exact Evaluation
	{
	real res = (((sq(a1)+sq(b1))*(sq((v.x()-(T.X()*v.w())))+sq((v.y()-(T.Y()*v.w())))))-sq((((a1*v.x())+(b1*v.y()))+(c1*v.w()))));
	sign_res = sign(res);
	}
// ******** End Expression Compiler Output

    }
      ZEROSTAT(vn,t,sign_res);
  }
  return sign_res;
}




bool ES_Voronoi_Diagram::
is_in_end_perp_stripe(const rat_segment& s, p_vnode vn)
{
    ASSERT((s.W1()==1),is_in_end_perp_stripe);
    ASSERT((s.W2()==1),is_in_end_perp_stripe);
    LTRACEN("is_in_end_perp_stripe: ");

  vnode& v = *vn;
  integer a,b,c;
  seg2line_paras(s,a,b,c);

  int sgn_s1, sgn_s2;

  rat_point P=s.start();
  rat_point Q=s.end();

  // ******** Begin Expression Compiler Output
// **** Local Variables:
//		s1
// **** External Variables:
//		P.X()
//		P.Y()
//		a
//		b
//		c
//		v.w()
//		v.x()
//		v.y()
// **** Sign Result Variables:
//		sgn_s1

{
	// ****** Double evaluation
double P_X___g_val = P.XD();
double P_X___g_sup = float_abs(P_X___g_val);
double P_Y___g_val = P.YD();
double P_Y___g_sup = float_abs(P_Y___g_val);
double a_g_val = a.to_double();
double a_g_sup = float_abs(a_g_val);
double b_g_val = b.to_double();
double b_g_sup = float_abs(b_g_val);
double c_g_val = c.to_double();
double c_g_sup = float_abs(c_g_val);
double v_w___g_val = v.wD();
double v_w___g_sup = (v.wDS());
double v_x___g_val = v.xD();
double v_x___g_sup = (v.xDS());
double v_y___g_val = v.yD();
double v_y___g_sup = (v.yDS());




	// ******************* New Declaration
	double s1_val;
	double s1_sup;

	double tmp_1025_val = b_g_val*v_x___g_val;
	double tmp_1025_sup = b_g_sup*v_x___g_sup;

	double tmp_1028_val = a_g_val*v_y___g_val;
	double tmp_1028_sup = a_g_sup*v_y___g_sup;

	double tmp_1029_val = tmp_1025_val-tmp_1028_val;
	double tmp_1029_sup = tmp_1025_sup+tmp_1028_sup;

	double tmp_1032_val = a_g_val*P_Y___g_val;
	double tmp_1032_sup = a_g_sup*P_Y___g_sup;

	double tmp_1035_val = b_g_val*P_X___g_val;
	double tmp_1035_sup = b_g_sup*P_X___g_sup;

	double tmp_1036_val = tmp_1032_val-tmp_1035_val;
	double tmp_1036_sup = tmp_1032_sup+tmp_1035_sup;

	double tmp_1038_val = tmp_1036_val*v_w___g_val;
	double tmp_1038_sup = tmp_1036_sup*v_w___g_sup;

	double tmp_1039_val = tmp_1029_val+tmp_1038_val;
	double tmp_1039_sup = tmp_1029_sup+tmp_1038_sup;

	s1_val = tmp_1039_val;
	s1_sup = tmp_1039_sup;

	// ***************** Sign Statement
	// ******* BitLength of Expression is 0
	// ******* Index of Expression is 48
	{
	  static double _upper=48*eps1;
	  if ( float_abs(s1_val) > s1_sup*_upper*correction )
		sgn_s1 = float_sign(s1_val);
	  else if (s1_sup==0)
		sgn_s1 = 0;
	  else
		sgn_s1 = NO_IDEA;
	}
}
if ( ((sgn_s1==NO_IDEA) || FALSE ) && (v.IsRat()) ) 
	// ***** Integer evaluation
{
	int _valid=TRUE;
	{
integer P_X___g_val = P.X();
integer P_Y___g_val = P.Y();
integer a_g_val = a;
integer b_g_val = b;
integer c_g_val = c;
integer v_w___g_val = v.wI();
integer v_x___g_val = v.xI();
integer v_y___g_val = v.yI();




	// ******************* New Declaration
	integer s1_val;

	if (_valid==TRUE)
	{
	integer tmp_1025_val = b_g_val*v_x___g_val;

	integer tmp_1028_val = a_g_val*v_y___g_val;

	integer tmp_1029_val = tmp_1025_val-tmp_1028_val;

	integer tmp_1032_val = a_g_val*P_Y___g_val;

	integer tmp_1035_val = b_g_val*P_X___g_val;

	integer tmp_1036_val = tmp_1032_val-tmp_1035_val;

	integer tmp_1038_val = tmp_1036_val*v_w___g_val;

	integer tmp_1039_val = tmp_1029_val+tmp_1038_val;

		s1_val = tmp_1039_val;
	}

	// ***************** Sign Statement
	if (_valid==TRUE)
		sgn_s1 = sign(s1_val);
	else
		sgn_s1 = NO_IDEA;
	}
}
if ((sgn_s1==NO_IDEA) || FALSE )
	// ***** Exact Evaluation
	{
	real s1 = (((b*v.x())-(a*v.y()))+(((a*P.Y())-(b*P.X()))*v.w()));
	sgn_s1 = sign(s1);
	}
// ******** End Expression Compiler Output

    LTRACE("first sign: ");LTRACEN(sgn_s1);

  // ******** Begin Expression Compiler Output
// **** Local Variables:
//		s2
// **** External Variables:
//		Q.X()
//		Q.Y()
//		a
//		b
//		c
//		v.w()
//		v.x()
//		v.y()
// **** Sign Result Variables:
//		sgn_s2

{
	// ****** Double evaluation
double Q_X___g_val = Q.XD();
double Q_X___g_sup = float_abs(Q_X___g_val);
double Q_Y___g_val = Q.YD();
double Q_Y___g_sup = float_abs(Q_Y___g_val);
double a_g_val = a.to_double();
double a_g_sup = float_abs(a_g_val);
double b_g_val = b.to_double();
double b_g_sup = float_abs(b_g_val);
double c_g_val = c.to_double();
double c_g_sup = float_abs(c_g_val);
double v_w___g_val = v.wD();
double v_w___g_sup = (v.wDS());
double v_x___g_val = v.xD();
double v_x___g_sup = (v.xDS());
double v_y___g_val = v.yD();
double v_y___g_sup = (v.yDS());




	// ******************* New Declaration
	double s2_val;
	double s2_sup;

	double tmp_1044_val = b_g_val*v_x___g_val;
	double tmp_1044_sup = b_g_sup*v_x___g_sup;

	double tmp_1047_val = a_g_val*v_y___g_val;
	double tmp_1047_sup = a_g_sup*v_y___g_sup;

	double tmp_1048_val = tmp_1044_val-tmp_1047_val;
	double tmp_1048_sup = tmp_1044_sup+tmp_1047_sup;

	double tmp_1051_val = a_g_val*Q_Y___g_val;
	double tmp_1051_sup = a_g_sup*Q_Y___g_sup;

	double tmp_1054_val = b_g_val*Q_X___g_val;
	double tmp_1054_sup = b_g_sup*Q_X___g_sup;

	double tmp_1055_val = tmp_1051_val-tmp_1054_val;
	double tmp_1055_sup = tmp_1051_sup+tmp_1054_sup;

	double tmp_1057_val = tmp_1055_val*v_w___g_val;
	double tmp_1057_sup = tmp_1055_sup*v_w___g_sup;

	double tmp_1058_val = tmp_1048_val+tmp_1057_val;
	double tmp_1058_sup = tmp_1048_sup+tmp_1057_sup;

	s2_val = tmp_1058_val;
	s2_sup = tmp_1058_sup;

	// ***************** Sign Statement
	// ******* BitLength of Expression is 0
	// ******* Index of Expression is 48
	{
	  static double _upper=48*eps1;
	  if ( float_abs(s2_val) > s2_sup*_upper*correction )
		sgn_s2 = float_sign(s2_val);
	  else if (s2_sup==0)
		sgn_s2 = 0;
	  else
		sgn_s2 = NO_IDEA;
	}
}
if ( ((sgn_s2==NO_IDEA) || FALSE ) && (v.IsRat()) ) 
	// ***** Integer evaluation
{
	int _valid=TRUE;
	{
integer Q_X___g_val = Q.X();
integer Q_Y___g_val = Q.Y();
integer a_g_val = a;
integer b_g_val = b;
integer c_g_val = c;
integer v_w___g_val = v.wI();
integer v_x___g_val = v.xI();
integer v_y___g_val = v.yI();




	// ******************* New Declaration
	integer s2_val;

	if (_valid==TRUE)
	{
	integer tmp_1044_val = b_g_val*v_x___g_val;

	integer tmp_1047_val = a_g_val*v_y___g_val;

	integer tmp_1048_val = tmp_1044_val-tmp_1047_val;

	integer tmp_1051_val = a_g_val*Q_Y___g_val;

	integer tmp_1054_val = b_g_val*Q_X___g_val;

	integer tmp_1055_val = tmp_1051_val-tmp_1054_val;

	integer tmp_1057_val = tmp_1055_val*v_w___g_val;

	integer tmp_1058_val = tmp_1048_val+tmp_1057_val;

		s2_val = tmp_1058_val;
	}

	// ***************** Sign Statement
	if (_valid==TRUE)
		sgn_s2 = sign(s2_val);
	else
		sgn_s2 = NO_IDEA;
	}
}
if ((sgn_s2==NO_IDEA) || FALSE )
	// ***** Exact Evaluation
	{
	real s2 = (((b*v.x())-(a*v.y()))+(((a*Q.Y())-(b*Q.X()))*v.w()));
	sgn_s2 = sign(s2);
	}
// ******** End Expression Compiler Output

    LTRACE("second sign: ");LTRACEN(sgn_s2);

  return (sgn_s1 != sgn_s2);
  /* if |(sgn_s1 == sgn_s2)| the perpendicular through |vn|
     intersects $l_s$ outside of |s| */
}


bool  ES_Voronoi_Diagram::
line_hull_and_order(p_site pp1, p_site pp2, p_site pp3)
{
    TRACE("  line_hull_and_order");TRACE(*pp1);TRACE(*pp2);TRACE(*pp3);

  rat_segment p12dir,s1,s2;
  const site& p1 = *pp1;
  const site& p2 = *pp2;
  const site& p3 = *pp3;
  rat_point P1,P2,P3;
  bool result;

    switch(sorted_switch_label_b2(p1.is_pnt(),p2.is_pnt())) {
    case tt_label: 
      P1 = p1.rpnt();
      P2 = p2.rpnt();
      p12dir = rat_segment(P1,P2);
      /* now |P1| and |P2| span the hull */

      if (p3.is_pnt()) 
      {
        result = (collinear(p12dir,p3.rpnt()) && 
                  collinear_ordered(P1,P2,p3.rpnt()));
      }
      else // |p3.is_seg()|
        result = (collinear(p12dir,p3.rseg()) && 
                  collinear_ordered(P1,P2,other_end(p3.rseg(),P2)));
      break;
    case tf_label: 
      P1 = p1.rpnt();
      s2 = p2.rseg();
      if (!collinear(s2,P1))
        result = false;
      else /* now |P1| is on $l_{s2}$ */
      {
        if (collinear_ordered(P1,s2.end(),s2.start()) || P1 == s2.end())
          invert_seg(s2);
        P2 = s2.end();
        p12dir = rat_segment(P1,P2);
        /* now |P1| and |P2| span the hull */

        if (p3.is_pnt()) 
          result = (collinear(p12dir,p3.rpnt()) && 
                    (collinear_ordered(P1,P2,p3.rpnt()) || 
                     P2 == p3.rpnt()));
        else // |p3.is_seg()|
          result = (collinear(p12dir,p3.rseg()) && 
                    collinear_ordered(P1,P2,other_end(p3.rseg(),P2)));
      }
      break;
    case ft_label: 
      s1 = p1.rseg();
      P2 = p2.rpnt();
      if (!collinear(s1,P2))
        result =  false;
      else /* now |P2| is on $l_{s1}$ */
      {
        if (collinear_ordered(s1.end(),s1.start(),P2) || s1.start() == P2)
          invert_seg(s1);
        P1 = s1.start();
        p12dir = rat_segment(P1,P2);
        /* now |P1| and |P2| span the hull */

        if (p3.is_pnt()) 
          result = (collinear(p12dir,p3.rpnt()) && 
                    collinear_ordered(P1,P2,p3.rpnt()));
        else // |p3.is_seg()|
          result = (collinear(p12dir,p3.rseg()) && 
                    collinear_ordered(P1,P2,other_end(p3.rseg(),P2)));
      }
      break;
    case ff_label: 
      s1 = p1.rseg();
      s2 = p2.rseg();
      if (!collinear(s1,s2))
        result = false;
      else  /* now $l_{s1} = l_{s2}$ */
      {
        if (collinear_ordered(s1.end(),s1.start(),other_end(s2,s1.start())))
          invert_seg(s1);
        if (collinear_ordered(other_end(s1,s2.end()),s2.end(),s2.start()))
          invert_seg(s2);
        P1 = s1.start();
        P2 = s2.end();
        p12dir = rat_segment(P1,P2);
        /* now |P1| and |P2| span the hull */

        if (p3.is_pnt()) 
          result = (collinear(p12dir,p3.rpnt()) && 
                    (collinear_ordered(P1,P2,p3.rpnt()) || 
                     P2 == p3.rpnt()));
        else // |p3.is_seg()|
          result = (collinear(p12dir,p3.rseg()) && 
                    collinear_ordered(P1,P2,other_end(p3.rseg(),P2)));
      }
      break;
    }  

      TRACEN(result);
    return result;
}



bool ES_Voronoi_Diagram::
illegal_intersection(p_site pp1, p_site pp2)
{
  if (pp1 == infinity()) return false;
  if (pp2 == infinity()) return false;

  const site& p1 = *pp1;
  const site& p2 = *pp2;
  rat_point P1,P2,P3,P4;

  if (p1.type() == p2.type())
  {
    if (p1.is_pnt())
      return false;  // two points can't have illegal position
    else
      if (segments_intersect_internally(p1.rseg(),p2.rseg()))
      {
          TRACEN("illegal_intersection: segments intersect internally!");
          return true;
      }
  }

  // now the mixed cases:
  if (p1.is_seg()) // and |p2.is_pnt()|
  {
    P1 = p1.rseg().start();
    P2 = p1.rseg().end();
    P3 = p2.rpnt();
  }
  if (p2.is_seg()) // and |p1.is_pnt()|
  {
    P1 = p2.rseg().start();
    P2 = p2.rseg().end();
    P3 = p1.rpnt();
  }

  int p3_rel_p12 = orientation(P1,P2,P3);
  if ((p3_rel_p12 == ON) && collinear_ordered(P1,P3,P2))
  {
    // |P3| on the segment between |P1| and |P2| is illegal
      TRACEN("illegal_intersection: point in interior of segment!"); 
    return true;
  }
  return false;
 
}



int  ES_Voronoi_Diagram::
orientation(const rat_segment& s, vnode& vn)
{
  rat_point P=s.start();
  rat_point Q=s.end();

  int sign_res;

  // ******** Begin Expression Compiler Output
// **** Local Variables:
//		res
// **** External Variables:
//		P.W()
//		P.X()
//		P.Y()
//		Q.W()
//		Q.X()
//		Q.Y()
//		vn.w()
//		vn.x()
//		vn.y()
// **** Sign Result Variables:
//		sign_res

{
	// ****** Double evaluation
double P_W___g_val = P.WD();
double P_W___g_sup = float_abs(P_W___g_val);
double P_X___g_val = P.XD();
double P_X___g_sup = float_abs(P_X___g_val);
double P_Y___g_val = P.YD();
double P_Y___g_sup = float_abs(P_Y___g_val);
double Q_W___g_val = Q.WD();
double Q_W___g_sup = float_abs(Q_W___g_val);
double Q_X___g_val = Q.XD();
double Q_X___g_sup = float_abs(Q_X___g_val);
double Q_Y___g_val = Q.YD();
double Q_Y___g_sup = float_abs(Q_Y___g_val);
double vn_w___g_val = vn.wD();
double vn_w___g_sup = (vn.wDS());
double vn_x___g_val = vn.xD();
double vn_x___g_sup = (vn.xDS());
double vn_y___g_val = vn.yD();
double vn_y___g_sup = (vn.yDS());




	// ******************* New Declaration
	double res_val;
	double res_sup;

	double tmp_1063_val = P_X___g_val*Q_W___g_val;
	double tmp_1063_sup = P_X___g_sup*Q_W___g_sup;

	double tmp_1066_val = Q_X___g_val*P_W___g_val;
	double tmp_1066_sup = Q_X___g_sup*P_W___g_sup;

	double tmp_1067_val = tmp_1063_val-tmp_1066_val;
	double tmp_1067_sup = tmp_1063_sup+tmp_1066_sup;

	double tmp_1070_val = P_Y___g_val*vn_w___g_val;
	double tmp_1070_sup = P_Y___g_sup*vn_w___g_sup;

	double tmp_1073_val = vn_y___g_val*P_W___g_val;
	double tmp_1073_sup = vn_y___g_sup*P_W___g_sup;

	double tmp_1074_val = tmp_1070_val-tmp_1073_val;
	double tmp_1074_sup = tmp_1070_sup+tmp_1073_sup;

	double tmp_1075_val = tmp_1067_val*tmp_1074_val;
	double tmp_1075_sup = tmp_1067_sup*tmp_1074_sup;

	double tmp_1078_val = P_Y___g_val*Q_W___g_val;
	double tmp_1078_sup = P_Y___g_sup*Q_W___g_sup;

	double tmp_1081_val = Q_Y___g_val*P_W___g_val;
	double tmp_1081_sup = Q_Y___g_sup*P_W___g_sup;

	double tmp_1082_val = tmp_1078_val-tmp_1081_val;
	double tmp_1082_sup = tmp_1078_sup+tmp_1081_sup;

	double tmp_1085_val = P_X___g_val*vn_w___g_val;
	double tmp_1085_sup = P_X___g_sup*vn_w___g_sup;

	double tmp_1088_val = vn_x___g_val*P_W___g_val;
	double tmp_1088_sup = vn_x___g_sup*P_W___g_sup;

	double tmp_1089_val = tmp_1085_val-tmp_1088_val;
	double tmp_1089_sup = tmp_1085_sup+tmp_1088_sup;

	double tmp_1090_val = tmp_1082_val*tmp_1089_val;
	double tmp_1090_sup = tmp_1082_sup*tmp_1089_sup;

	double tmp_1091_val = tmp_1075_val-tmp_1090_val;
	double tmp_1091_sup = tmp_1075_sup+tmp_1090_sup;

	res_val = tmp_1091_val;
	res_sup = tmp_1091_sup;

	// ***************** Sign Statement
	// ******* BitLength of Expression is 0
	// ******* Index of Expression is 51
	{
	  static double _upper=51*eps1;
	  if ( float_abs(res_val) > res_sup*_upper*correction )
		sign_res = float_sign(res_val);
	  else if (res_sup==0)
		sign_res = 0;
	  else
		sign_res = NO_IDEA;
	}
}
if ( ((sign_res==NO_IDEA) || FALSE ) && (vn.IsRat()) ) 
	// ***** Integer evaluation
{
	int _valid=TRUE;
	{
integer P_W___g_val = P.W();
integer P_X___g_val = P.X();
integer P_Y___g_val = P.Y();
integer Q_W___g_val = Q.W();
integer Q_X___g_val = Q.X();
integer Q_Y___g_val = Q.Y();
integer vn_w___g_val = vn.wI();
integer vn_x___g_val = vn.xI();
integer vn_y___g_val = vn.yI();




	// ******************* New Declaration
	integer res_val;

	if (_valid==TRUE)
	{
	integer tmp_1063_val = P_X___g_val*Q_W___g_val;

	integer tmp_1066_val = Q_X___g_val*P_W___g_val;

	integer tmp_1067_val = tmp_1063_val-tmp_1066_val;

	integer tmp_1070_val = P_Y___g_val*vn_w___g_val;

	integer tmp_1073_val = vn_y___g_val*P_W___g_val;

	integer tmp_1074_val = tmp_1070_val-tmp_1073_val;

	integer tmp_1075_val = tmp_1067_val*tmp_1074_val;

	integer tmp_1078_val = P_Y___g_val*Q_W___g_val;

	integer tmp_1081_val = Q_Y___g_val*P_W___g_val;

	integer tmp_1082_val = tmp_1078_val-tmp_1081_val;

	integer tmp_1085_val = P_X___g_val*vn_w___g_val;

	integer tmp_1088_val = vn_x___g_val*P_W___g_val;

	integer tmp_1089_val = tmp_1085_val-tmp_1088_val;

	integer tmp_1090_val = tmp_1082_val*tmp_1089_val;

	integer tmp_1091_val = tmp_1075_val-tmp_1090_val;

		res_val = tmp_1091_val;
	}

	// ***************** Sign Statement
	if (_valid==TRUE)
		sign_res = sign(res_val);
	else
		sign_res = NO_IDEA;
	}
}
if ((sign_res==NO_IDEA) || FALSE )
	// ***** Exact Evaluation
	{
	real res = ((((P.X()*Q.W())-(Q.X()*P.W()))*((P.Y()*vn.w())-(vn.y()*P.W())))-(((P.Y()*Q.W())-(Q.Y()*P.W()))*((P.X()*vn.w())-(vn.x()*P.W()))));
	sign_res = sign(res);
	}
// ******** End Expression Compiler Output


  return (sign_res);
}



bool  ES_Voronoi_Diagram::
less_than_right_angle(const rat_segment& s1, const rat_segment& s2)
{
  integer dx1 = s1.X2()*s1.W1() - s1.X1()*s1.W2();
  integer dy1 = s1.Y2()*s1.W1() - s1.Y1()*s1.W2();
  integer dx2 = s2.X2()*s2.W1() - s2.X1()*s2.W2();
  integer dy2 = s2.Y2()*s2.W1() - s2.Y1()*s2.W2();
  return ((dx1*dx2 + dy1*dy2) > 0);
}



bool  ES_Voronoi_Diagram::
perp_separates(const rat_segment& l, const rat_point& P, 
               p_vnode ml, p_vnode mr)
{
  rat_point B_l = perpendicular_base_point(l,P);
  rat_segment perp(B_l,P);
  return (orientation(perp,*ml) == LEFT && 
          orientation(perp,*mr) == RIGHT);
}



void ES_Voronoi_Diagram::
adapt_seg(segment& s, bisec_type& t, p_vnode si, p_vnode ei)
{
    TRACE("    adapt_seg: ");TRACEN(s);
    
  switch(sorted_switch_label_b2((si != gamma_node()),(ei != gamma_node()))) {
  case tt_label: // both not on gamma
    s = segment((*si).pnt(),(*ei).pnt());
    t = SEGM;    
    break;
  case tf_label: // only ei on gamma
    move_seg(s,(*si).pnt());
    t = RAY;
    break;
  case ft_label: // only si on gamma
    invert_seg(s);
    move_seg(s,(*ei).pnt());
    t = RAY;
    break;
  case ff_label: // both on gamma
    t = LIN;
    break;  
  }
    TRACE("    adapted: ");TRACEN(s);
}




vnode ES_Voronoi_Diagram::
other_end(p_site p, vnode& v)
{
  if ((*p).is_pnt())
    return v;
  else { // |(*p).is_seg()|
    rat_point PS((*p).rseg().start());
    rat_point PE((*p).rseg().end());
    vnode ps(PS.X(),PS.Y(),PS.W());
    vnode pe(PE.X(),PE.Y(),PE.W());
    if (ps == v)
      return pe;
    else
      return ps;
  }
}




inline bool in_window(window& W, point p)
{
  return (p.xcoord() >= W.xmin() && p.xcoord() <= W.xmax() &&
          p.ycoord() >= W.ymin() && p.ycoord() <= W.ymax());
}

inline bool crossing_window_border(window& W, segment s)
{
  if (in_window(W,s.source()) && !in_window(W,s.target()) ||
      !in_window(W,s.source()) && in_window(W,s.target()))
    return true;
}

void  ES_Voronoi_Diagram::
draw_bisector(p_site pp, p_site pq, p_vnode si, p_vnode ei, window& W, 
              color c)
{
    TRACEN("draw_bisector:");

  bisec_type t;    // the type of the bisector piece;
  segment s;       // start and end point on the bisector
  point   Fo;      // the focus if PARA
  segment ba;      // the baseline if PARA 
  
  // first we analyze the type and store it in t

  if (pp == infinity() || pq == infinity()) {
    t = GAMMA;
    return;
  }

  const site& p = *pp;
  const site& q = *pq;
  // and now the finite cases:
  switch(sorted_switch_label_b2(p.is_pnt(),q.is_pnt())) {
  case tt_label: // both are pnts
    s = mid_perp_seg(p.pnt(),q.pnt());
    adapt_seg(s,t,si,ei);
    break;

  case tf_label: 
    // we know that if (point) p lies on lq then p must be an
    // endpoint of (segment) q as endpoints are inserted before
    // their segment interior
    if (p.rpnt() == q.rseg().start())
    {
      s = end_perp_seg(q.seg().start(),q.seg().end());
      adapt_seg(s,t,si,ei);
    }
    else if (p.rpnt() == q.rseg().end())
    {
      s = end_perp_seg(q.seg().end(),q.seg().start());
      adapt_seg(s,t,si,ei);
    }
    else 
    {
      // we know that in this case si and ei must have finite coordinates
      // and limit a parabola piece
      s = segment((*si).pnt(),(*ei).pnt());
      Fo = p.pnt();
      ba = q.seg();
      t = PARA;
    }
    break;

  case ft_label: 
    // we know that if q lies on lp then q must be an
    // endpoint of p as endpoints are inserted before
    // their segment interior
    if (q.rpnt() == p.rseg().start())
    {
      s = end_perp_seg(p.seg().start(),p.seg().end());
      invert_seg(s);
      adapt_seg(s,t,si,ei);
    }
    else if (q.rpnt() == p.rseg().end())
    {
      s = end_perp_seg(p.seg().end(),p.seg().start());
      invert_seg(s);
      adapt_seg(s,t,si,ei);
    }
    else 
    {
      // we know in this case that si and ei must have finite coordinates
      // and limit a parabola piece 
      s = segment((*ei).pnt(),(*si).pnt());
      Fo = q.pnt();
      ba = p.seg();
      t = PARA;
    }
    break;

  case ff_label: 
    // it might happen that the segments |p| and |q| are collinear
    // and touch in an endpoint, if this is not the case then
    // we know that si and ei must have finite coordinates
    // and limit a line segment
    if (collinear(p.rseg(),q.rseg()))
    {
        ASSERT(is_endpnt(p.rseg().start(),q.rseg())||
               is_endpnt(p.rseg().end(),q.rseg()),
               bisec_elem_collinear_segments);

      if (is_endpnt(p.rseg().start(),q.rseg()))
        s = end_perp_seg(p.seg().start(),p.seg().end());
      else // |is_endpnt(p.rseg().end(),q.rseg())|
        s = end_perp_seg(p.seg().end(),p.seg().start());
      invert_seg(s);
      adapt_seg(s,t,si,ei);
    }
    else
    {      
      s = segment((*si).pnt(),(*ei).pnt());
      t = SEGM;
    }
    break;
  }  

  // then we draw it:
  switch (t) {
  case GAMMA: TRACEN("   GAMMA");
    break;
  case PARA:  TRACE("   PARA ");TRACE(s);TRACE(Fo);TRACEN(ba);
    draw_parabola(Fo,ba,s,W,c);
    break;
  case SEGM:  TRACE("   SEGMENT ");TRACEN(s);
    //if (crossing_window_border(W,s)) {
    //  cerr << "SEGMENT: " << s << endl;
    //  W.draw_segment(s,red);
    //} else
    W.draw_segment(s,c);
    break;
  case RAY:   TRACE("   RAY ");TRACEN(s);
    W.draw_ray(s,c);
    break;
  case LIN:   TRACE("   LINE ");TRACEN(s);
    W.draw_line(s,c);
    break;
  }
}




void  ES_Voronoi_Diagram::
draw_site(p_site p, window& W, color c)
{ (*p).draw(W,c); }




bool ES_Voronoi_Diagram::
right_turn(vnode& p1, vnode& p2, vnode& p3)
{
  int sign_D;

  // ******** Begin Expression Compiler Output
// **** Local Variables:
//		D
// **** External Variables:
//		p1.w()
//		p1.x()
//		p1.y()
//		p2.w()
//		p2.x()
//		p2.y()
//		p3.w()
//		p3.x()
//		p3.y()
// **** Sign Result Variables:
//		sign_D

{
	// ****** Double evaluation
double p1_w___g_val = p1.wD();
double p1_w___g_sup = (p1.wDS());
double p1_x___g_val = p1.xD();
double p1_x___g_sup = (p1.xDS());
double p1_y___g_val = p1.yD();
double p1_y___g_sup = (p1.yDS());
double p2_w___g_val = p2.wD();
double p2_w___g_sup = (p2.wDS());
double p2_x___g_val = p2.xD();
double p2_x___g_sup = (p2.xDS());
double p2_y___g_val = p2.yD();
double p2_y___g_sup = (p2.yDS());
double p3_w___g_val = p3.wD();
double p3_w___g_sup = (p3.wDS());
double p3_x___g_val = p3.xD();
double p3_x___g_sup = (p3.xDS());
double p3_y___g_val = p3.yD();
double p3_y___g_sup = (p3.yDS());




	// ******************* New Declaration
	double D_val;
	double D_sup;

	double tmp_1095_val = p1_x___g_val*p2_w___g_val;
	double tmp_1095_sup = p1_x___g_sup*p2_w___g_sup;

	double tmp_1098_val = p2_x___g_val*p1_w___g_val;
	double tmp_1098_sup = p2_x___g_sup*p1_w___g_sup;

	double tmp_1099_val = tmp_1095_val-tmp_1098_val;
	double tmp_1099_sup = tmp_1095_sup+tmp_1098_sup;

	double tmp_1102_val = p1_y___g_val*p3_w___g_val;
	double tmp_1102_sup = p1_y___g_sup*p3_w___g_sup;

	double tmp_1105_val = p3_y___g_val*p1_w___g_val;
	double tmp_1105_sup = p3_y___g_sup*p1_w___g_sup;

	double tmp_1106_val = tmp_1102_val-tmp_1105_val;
	double tmp_1106_sup = tmp_1102_sup+tmp_1105_sup;

	double tmp_1107_val = tmp_1099_val*tmp_1106_val;
	double tmp_1107_sup = tmp_1099_sup*tmp_1106_sup;

	double tmp_1110_val = p1_y___g_val*p2_w___g_val;
	double tmp_1110_sup = p1_y___g_sup*p2_w___g_sup;

	double tmp_1113_val = p2_y___g_val*p1_w___g_val;
	double tmp_1113_sup = p2_y___g_sup*p1_w___g_sup;

	double tmp_1114_val = tmp_1110_val-tmp_1113_val;
	double tmp_1114_sup = tmp_1110_sup+tmp_1113_sup;

	double tmp_1117_val = p1_x___g_val*p3_w___g_val;
	double tmp_1117_sup = p1_x___g_sup*p3_w___g_sup;

	double tmp_1120_val = p3_x___g_val*p1_w___g_val;
	double tmp_1120_sup = p3_x___g_sup*p1_w___g_sup;

	double tmp_1121_val = tmp_1117_val-tmp_1120_val;
	double tmp_1121_sup = tmp_1117_sup+tmp_1120_sup;

	double tmp_1122_val = tmp_1114_val*tmp_1121_val;
	double tmp_1122_sup = tmp_1114_sup*tmp_1121_sup;

	double tmp_1123_val = tmp_1107_val-tmp_1122_val;
	double tmp_1123_sup = tmp_1107_sup+tmp_1122_sup;

	D_val = tmp_1123_val;
	D_sup = tmp_1123_sup;

	// ***************** Sign Statement
	// ******* BitLength of Expression is 0
	// ******* Index of Expression is 174
	{
	  static double _upper=174*eps1;
	  if ( float_abs(D_val) > D_sup*_upper*correction )
		sign_D = float_sign(D_val);
	  else if (D_sup==0)
		sign_D = 0;
	  else
		sign_D = NO_IDEA;
	}
}
if ((sign_D==NO_IDEA) || FALSE )
	// ***** Exact Evaluation
	{
	real D = ((((p1.x()*p2.w())-(p2.x()*p1.w()))*((p1.y()*p3.w())-(p3.y()*p1.w())))-(((p1.y()*p2.w())-(p2.y()*p1.w()))*((p1.x()*p3.w())-(p3.x()*p1.w()))));
	sign_D = sign(D);
	}
// ******** End Expression Compiler Output

  //if (sign_D==0) cout<<"RightTurn "<<endl;
  return (sign_D < 0);
}


vnode ES_Voronoi_Diagram::
foot_of_perpendicular(vnode& v, const rat_segment& l)
{
    TRACEN("foot_of_perpendicular: ");
  real a,b,c;
  seg2line_paras(l,a,b,c);
  real vx = v.x();
  real vy = v.y();
  real vz = v.w();

  real x = - vy*a*b + vx*b*b - a*c*vz;
  real y = - vx*a*b + vy*a*a - b*c*vz;
  real z = vz*(sq(a)+sq(b));
  // according to C.Burnikel
  vnode vfp(x,y,z);
    TRACEN(vfp);

  return vfp;
}


#undef site
#undef vnode
#undef p_site
#undef p_vnode


/* --------------------------------
          end of file
   -------------------------------- */


