
#include <LEP/avd/es_adaptation.h>
#include <LEP/avd/param_handler.h>

static rat_point rpnt(point p)
{ return rat_point(integer(p.xcoord()),integer(p.ycoord())); }

main(int argc, char* argv[])
{
  int count = 0;
  param_handler params(argc, argv, "input_file [scale_factor]",1,2);

  ES_Voronoi_Diagram AVD;

  p_site t;
  int scale=1;
  string ifile;
  params.set(ifile,1);
  params.set(scale,2);

  file_istream from(ifile);
  if(!from)
    error_handler(1,"cannot open input file!");

  point p,q;
  while ((from >> p) && (from >> q)) {
    // we assume that the input is on the integer grid

    AVD.insert(rat_segment(rpnt(p),rpnt(q)));
  }
  if (!from.eof())
    error_handler(1,"your input file is corrupted!");
  print_time();

  double x0=0,y0=0;
  window W;

  W.init(x0-scale*50,x0+scale*50,y0-scale*50,scale);
  W.set_show_coordinates(true);
  W.set_node_width(4);
  W.display();
  W.clear();
  AVD.draw_diagram(W);
  W.read_mouse();
  W.clear();
  AVD.clear();
}


