
#include <LEP/avd/es_plane_ext.h>
#include <LEP/avd/expcomp.h>

#define _DEBUG_PLANEx

#ifdef _DEBUG_PLANE
#define TRACE(t)    cerr << " " << t  
#else
#define TRACE(t)
#endif

#ifdef _DEBUG_PLANE
#define TRACEN(t)    cerr << " " << t << "\n"
#else
#define TRACEN(t)
#endif

int _STEPNR = 100;




void min_max(rational& q1, rational& q2)
{
  if (q1 > q2)
  {
    rational aux = q1;
    q1 = q2;
    q2 = aux;
  }
}

segment  mid_perp_seg(const point& P1, const point& P2)
{
    TRACE("mid_perp_seg: ");
  double   x1 = P1.xcoord(),
           y1 = P1.ycoord(),
           x2 = P2.xcoord(),
           y2 = P2.ycoord();
  point Mp((x1+x2)/2,(y1+y2)/2);
  segment erg = segment(Mp,P2.rotate90(Mp));
    TRACEN(erg);
  return erg;
}

segment  end_perp_seg(const point& P1, const point& P2)
{
    TRACE("end_perp_seg: ");
  segment erg(P1,P2.rotate90(P1));
    TRACEN(erg);
  return erg;
}

void  move_seg(segment& s, const point& P)
{
  point Po(P.xcoord()+s.dx(), P.ycoord()+s.dy());
  s = segment(P,Po);
}

point  perpendicular_base_point(const segment& l, const point& P)
{
  double fx,fy,px,py,x1,y1,x2,y2,m;
  point P1 = l.start();
  point P2 = l.end();
  x1 = P1.xcoord();
  y1 = P1.ycoord();
  x2 = P2.xcoord();
  y2 = P2.ycoord();
  px = P.xcoord();
  py = P.ycoord();

  if (x1 == x2) // line vertical
    return point(x1,py);
  if (y1 == y2) // line horizontal
    return point(px,y1);

  // now line neither vertical nor horizontal
  m = (y2-y1)/(x2-x1);
  fx =  (py - y1 + px/m + m*x1) / (m + 1.0/m);
  fy =  m*(fx - x1) + y1;
  return point(fx,fy);
}

rat_point  perpendicular_base_point(const rat_segment& l, 
           const rat_point& P)
{
  integer a,b,c;
  a = l.Y1()*l.W2() - l.Y2()*l.W1();
  b = - l.X1()*l.W2() + l.X2()*l.W1();
  c = l.X1()*l.Y2() - l.X2()*l.Y1();
  // these are the params of the supporting line of l
  integer ap,bp,cp;
  ap = b * P.W();
  bp = -a * P.W();
  cp = a*P.Y() - b*P.X();
  // these are the params of the perpendicular through p
  return rat_point(b*cp-bp*c, ap*c-a*cp, a*bp-ap*b);
  // this is the intersection of the perpendicular and l
}


int cmp_pnt_line_distance(const rat_point& P1, const rat_point& P2, 
    const rat_segment& l)
{
  rat_point PB1 = perpendicular_base_point(l,P1);
  rat_point PB2 = perpendicular_base_point(l,P2);
  int sign_res;

  BEGIN_PREDICATE
    {
      DECLARE_ATTRIBUTES poly_id_type FOR P1.X() P1.Y() P1.W() P2.X() P2.Y() P2.W() PB1.X() PB1.Y() PB1.W() PB2.X() PB2.Y() PB2.W();
      EXACTNESS_TEST;
      integer dis1 = sq(P1.X()*PB1.W() - P1.W()*PB1.X()) +
                     sq(P1.Y()*PB1.W() - P1.W()*PB1.Y());
      integer dis2 = sq(P2.X()*PB2.W() - P2.W()*PB2.X()) +
                     sq(P2.Y()*PB2.W() - P2.W()*PB2.Y());

      integer res = sq(P2.W()*PB2.W()) * dis1 - sq(P1.W()*PB1.W()) * dis2;
      sign_res=sign(res);
    }
  END_PREDICATE
  return (sign_res);
}


int cmp_seg_pnt_distance(const rat_segment& s1, const rat_segment& s2, 
    const rat_point& P)
{
  rat_point PB1 = perpendicular_base_point(s1,P);
  rat_point PB2 = perpendicular_base_point(s2,P);
  int sign_res;

  BEGIN_PREDICATE
    {
      DECLARE_ATTRIBUTES poly_id_type FOR P.X() P.Y() P.W() PB1.X() PB1.Y() PB1.W() PB2.X() PB2.Y() PB2.W();
      EXACTNESS_TEST;
      integer dis1 = sq(P.X()*PB1.W() - P.W()*PB1.X()) +
                     sq(P.Y()*PB1.W() - P.W()*PB1.Y());
      integer dis2 = sq(P.X()*PB2.W() - P.W()*PB2.X()) +
                     sq(P.Y()*PB2.W() - P.W()*PB2.Y());

      integer res = sq(P.W()*PB2.W()) * dis1 - sq(P.W()*PB1.W()) * dis2;
      sign_res=sign(res);
    }
  END_PREDICATE 
  return (sign_res);
}



point  rotate(const point& P, double sin_fi, double cos_fi)
{
  return point(P.xcoord()*cos_fi - P.ycoord()*sin_fi,
               P.xcoord()*sin_fi + P.ycoord()*cos_fi);
}

void  invert_seg(segment& s)
{
    TRACE("invert_seg: "); TRACEN(s);
  s = segment(s.end(),s.start());
}

void  invert_seg(rat_segment& s)
{
    TRACE("invert_seg: "); TRACEN(s);
  s = rat_segment(s.end(),s.start());
}

rat_point other_end(const rat_segment& s, const rat_point& P)
{
  if (P == s.start())
    return s.end();
  else
    return s.start();
}

bool is_endpnt(const rat_point& P, const rat_segment& s)
{
  return (P == s.start() || P == s.end());
}

bool    collinear_ordered(rat_point P1, rat_point P2, rat_point P3)
{
  if (compare(P1,P3)>0)
    leda_swap(P1,P3);
  return (compare(P1,P2)<0 && compare(P2,P3)<0);
}

bool collinear(const rat_segment& s, const rat_point& P)
{
  return (orientation(s,P) == 0);
}

bool collinear(const rat_segment& s1, const rat_segment& s2)
{
  return (orientation(s1,s2.start()) == 0 && 
          orientation(s1,s2.end()) == 0);
}

bool    segments_intersect_internally(const rat_segment& s1, 
        const rat_segment& s2)
{
  rat_point P1 = s1.start(),
            P2 = s1.end(),
            P3 = s2.start(),
            P4 = s2.end();

  rational x1(P1.X(),P1.W()),
           y1(P1.Y(),P1.W()),
           x2(P2.X(),P2.W()),
           y2(P2.Y(),P2.W()),
           x3(P3.X(),P3.W()),
           y3(P3.Y(),P3.W()),
           x4(P4.X(),P4.W()),
           y4(P4.Y(),P4.W());

  min_max(x1,x2);
  min_max(y1,y2);
  min_max(x3,x4);
  min_max(y3,y4);
  // now (x1,y1) is the lower left (ll) of the bounding box of 
  // segment s1, and (x2,y2) is the upper right (ur) of this 
  // box; the same holds for s2 with (x3,y3) ll and (x4,y4) ur

  if ((x2>=x3) && (x4>=x1) && (y2>=y3) && (y4>=y1))
  // the segment only have a chance to intersect, if their bounding
  // boxes do intersect
  {
      TRACEN("bouding boxes do intersect.");
    
    int p3_rel_p12 = orientation(P1,P2,P3);
    int p4_rel_p12 = orientation(P1,P2,P4);
    if (p3_rel_p12 == p4_rel_p12)
    {
      if (p3_rel_p12 == ON) // both on line P1P2
      {
        if ((P1 == P3) && collinear_ordered(P2,P1,P4) || 
            (P1 == P4) && collinear_ordered(P2,P1,P3) || 
            (P2 == P3) && collinear_ordered(P1,P2,P4) || 
            (P2 == P4) && collinear_ordered(P1,P2,P3)) 
          return false; // touching in the end, no overlapping
        return true; // overlapping
      }
      // P3, P4 on one side of line P1P2
      return false;
    }
    if (p3_rel_p12 == ON) // P3 on P1P2 and P4 left or right
    {
      if (collinear_ordered(P1,P3,P2)) 
      // s2 touches s1 in interior
        return true;
      return false;
    }
    if (p4_rel_p12 == ON) // P4 on P1P2 and P3 left or right
    {
      if (collinear_ordered(P1,P4,P2)) 
      // s2 touches s1 in interior
        return true;
      return false;
    }
    // now P4 and P3 are not on line P1P2 but on different sides
    int p1_rel_p34 = orientation(P3,P4,P1);
    int p2_rel_p34 = orientation(P3,P4,P2);
    if (p1_rel_p34 == p2_rel_p34)
      return false; // P1 and P2 are on one side => no intersection
    return true;
  }
  // the bounding boxes don't intersect
  return false;
}


bool endpnts_touch(const rat_segment& s1, const rat_segment& s2, 
                   rat_point& tpnt)
{
  if (s1.start()==s2.start()) {  tpnt=s1.start();  return true; }
  if (s1.start()==s2.end())   {  tpnt=s1.start();  return true; }
  if (s1.end()==s2.start())   {  tpnt=s1.end();  return true; }
  if (s1.end()==s2.end())     {  tpnt=s1.end();  return true; }
  return false;
}


void orient_segs(const rat_segment& s1, const rat_segment& s2,
                 int& s1_rel_s2, int& s2_rel_s1)
{
  int st2_rel_s1 = orientation(s1,s2.start());
  int en2_rel_s1 = orientation(s1,s2.end());  
  int st1_rel_s2, en1_rel_s2;

  switch (st2_rel_s1) {
  case ON:
    switch (en2_rel_s1) {
    case ON:
      s1_rel_s2 = ON; 
      s2_rel_s1 = ON; 
      break;
    case LEFT:
      s2_rel_s1 = LEFT;
      if (orientation(s2,s1.start()) == LEFT) 
        s1_rel_s2 = LEFT;
      else 
        s1_rel_s2 = RIGHT; 
      break;
    case RIGHT:
      s2_rel_s1 = RIGHT;
      if (orientation(s2,s1.start()) == RIGHT) 
        s1_rel_s2 = RIGHT; 
      else 
        s1_rel_s2 = LEFT; 
      break;
    }  
    break;

  case LEFT:
    switch (en2_rel_s1) {
    case ON:
      s2_rel_s1 = LEFT;
      if (orientation(s2,s1.start()) == RIGHT) 
        s1_rel_s2 = RIGHT;
      else 
        s1_rel_s2 = LEFT;       
      break;
    case LEFT:
      s2_rel_s1 = LEFT;
      st1_rel_s2 = orientation(s2,s1.start());
      en1_rel_s2 = orientation(s2,s1.end());
      if (st1_rel_s2 == -en1_rel_s2) 
        s1_rel_s2 = UNDEC;
      else if (st1_rel_s2 == LEFT || en1_rel_s2 == LEFT)
        s1_rel_s2 = LEFT;
      else if (st1_rel_s2 == RIGHT || en1_rel_s2 == RIGHT)
        s1_rel_s2 = RIGHT;
      else
        error_handler(1,"orient_segs: illegal");
      break;
    case RIGHT:
      s2_rel_s1 = UNDEC;
      if (orientation(s2,s1.start()) == RIGHT) 
        s1_rel_s2 = RIGHT;
      else 
        s1_rel_s2 = LEFT; 
      break;
    }       
    break;

  case RIGHT:
    switch (en2_rel_s1) {
    case ON:
      s2_rel_s1 = RIGHT;
      if (orientation(s2,s1.end()) == RIGHT) 
        s1_rel_s2 = RIGHT;
      else 
        s1_rel_s2 = LEFT;       
      break;
    case LEFT:
      s2_rel_s1 = UNDEC;
      if (orientation(s2,s1.end()) == RIGHT) 
        s1_rel_s2 = RIGHT;
      else 
        s1_rel_s2 = LEFT;       
      break;
    case RIGHT:
      s2_rel_s1 = RIGHT;
      st1_rel_s2 = orientation(s2,s1.start());
      en1_rel_s2 = orientation(s2,s1.end());
      if (st1_rel_s2 == -en1_rel_s2) 
        s1_rel_s2 = UNDEC;
      else if (st1_rel_s2 == LEFT || en1_rel_s2 == LEFT)
        s1_rel_s2 = LEFT;
      else if (st1_rel_s2 == RIGHT || en1_rel_s2 == RIGHT)
        s1_rel_s2 = RIGHT;
      else
        error_handler(1,"orient_segs: illegal");
      break;
    }       
    break;   
  }
}

double  pfunc(double hp, double x) 
/* calculates the function of a parabola symmetric to the y-axis with
base line in the x-axis and focus on the positive y-axis.
|hp| is the intersection point of the parabola with the y-axis */
{
  return 1/(2 * hp ) * (x*x) + 0.5 * hp;
}

 

void  draw_parabola(const point& F, const segment& base, const segment& l,
      window& W, color c)
{
    TRACE("draw_para (F,base) "); TRACE(F); TRACE(base); 
    TRACE(" in intervall ");TRACEN(l); 

  point P,
        S = l.start(),
        E = l.end(),
        Fo = F,
        Foc_proj = perpendicular_base_point(base,Fo), 
        S_proj   = perpendicular_base_point(base,S),
        E_proj   = perpendicular_base_point(base,E);

  double denom,sin_fi,cos_fi,sin_m_fi,cos_m_fi,x,y,xf,yf,xl;

  x = Foc_proj.xcoord();
  y = Foc_proj.ycoord();

  // translation thus that |foc_proj| lies in the origin:
  Fo = point(Fo.xcoord()-x,Fo.ycoord()-y);
  S_proj = point(S_proj.xcoord()-x,S_proj.ycoord()-y);
  E_proj = point(E_proj.xcoord()-x,E_proj.ycoord()-y); 

  xf = Fo.xcoord();
  yf = Fo.ycoord();
  denom    = sqrt(xf*xf + yf*yf);
  sin_fi   = xf/denom;
  cos_fi   = yf/denom; 
  sin_m_fi = - sin_fi;  // symmetry to origin
  cos_m_fi = yf/denom;  // symmetry to y-axis

  // rotations thus that the base line is identical to the x-axis
  Fo = rotate(Fo,sin_fi,cos_fi);
  S_proj = rotate(S_proj,sin_fi,cos_fi);
  E_proj = rotate(E_proj,sin_fi,cos_fi);

  double hparam = Fo.ycoord();
  if ( S_proj.xcoord() > E_proj.xcoord() ) leda_swap(S_proj,E_proj);

  xl = S_proj.xcoord();
  point Pd,Prevd,Prev;
  P = point(xl,pfunc(hparam,xl));

  double step = (W.xmax()-W.xmin())/_STEPNR;
  do
  {
    Prev = P;
    P = point(xl,pfunc(hparam,xl));          // calculate point
    Pd = rotate(P,sin_m_fi,cos_m_fi);        // inverse rotation
    Pd = point(Pd.xcoord()+x,Pd.ycoord()+y); // inverse translation
    Prevd = rotate(Prev,sin_m_fi,cos_m_fi);
    Prevd = point(Prevd.xcoord()+x,Prevd.ycoord()+y); 
    W.draw_segment(Prevd,Pd,c);              // draw it !!
  }
  while ((xl+=step) <= E_proj.xcoord());
  xl = E_proj.xcoord();
  Prev = P;
  P = point(xl,pfunc(hparam,xl));          // calculate point
  Pd = rotate(P,sin_m_fi,cos_m_fi);        // inverse rotation
  Pd = point(Pd.xcoord()+x,Pd.ycoord()+y); // inverse translation
  Prevd = rotate(Prev,sin_m_fi,cos_m_fi);
  Prevd = point(Prevd.xcoord()+x,Prevd.ycoord()+y); 
  W.draw_segment(Prevd,Pd,c);              // draw the last !!
}


