
#include <LEDA/plane.h>
#include <LEDA/stream.h>
#include <LEDA/window.h>
#include <LEP/avd/param_handler.h>
#include <LEP/avd/es_adaptation.h>

inline void 
create_bounding_box(point& pmin, point& pmax, const point& test)
{
  pmin = point(leda_min(pmin.xcoord(), test.xcoord()),
               leda_min(pmin.ycoord(), test.ycoord()));
  pmax = point(leda_max(pmax.xcoord(), test.xcoord()),
               leda_max(pmax.ycoord(), test.ycoord()));
}

static rat_point rpnt(point p)
{ return rat_point(integer(p.xcoord()),integer(p.ycoord())); }

static rat_segment rseg(segment p)
{ return rat_segment(rpnt(p.source()),rpnt(p.target())); }


main(int argc, char* argv[])
{
  int count = 0;
  param_handler params(argc, argv, "input_file",1,2);
  ES_Voronoi_Diagram V;

  string ifile;
  params.set(ifile,1);
  list<segment> SiteList;

  file_istream from(ifile);
  if (!from)
    error_handler(1,"there is no input file "+ifile+"!");
  
  point p,q,pmin,pmax;
  string istr1,istr2;
  bool first = true;
  while ((from >> istr1) && (from >> istr2)) {
      /* this loop reads the lines with label istr1 and
         pointstring istr2 */

   string_istream is(istr2);
   if (istr1 == "site") {
     /* this handles site input lines where two consecutive
        points define a site -- two equal points a point site
        and two different points a segment site */
      while ((is >> p) && (is >> q)) {
        // we assume that the input is on the integer grid
        create_bounding_box(pmin,pmax,p);
        create_bounding_box(pmin,pmax,q);
        SiteList.append(segment(p,q));
      }
    }
    else if (istr1 == "poly")
    {
      /* this handles polygon input lines where all points
         define the vertices of a closed polygon */

      polygon P;
      is >> P;

      forall_vertices(p,P) {
        SiteList.append(segment(p,q));
        create_bounding_box(pmin,pmax,p);
      }
      segment s;
      forall_segments(s,P) 
        SiteList.append(s);
    }
    else
      error_handler(1,"wrong label - your input file is corrupted!");
    if (!is.eof())
      error_handler(1,"point list - your input file is corrupted!");
  }
  if (!from.eof())
    error_handler(1,"line structure - your input file is corrupted!");

  double dx = pmax.xcoord()-pmin.xcoord();
  double dy = pmax.ycoord()-pmin.ycoord();
  int x0 = int(pmin.xcoord()+dx/2), y0 = int(pmin.ycoord()+dy/2);
  int dmax = int(leda_max(dx,dy))/2;
  int scale = dmax/10+2;
  int xmin = x0-scale*10;
  int xmax = x0+scale*10;
  int ymin = y0-scale*10;
  int grid = leda_max(1,(xmax-xmin)/100);

  window W(800,800);
  W.init(xmin,xmax,ymin,grid);
  W.set_show_coordinates(true);
  W.set_node_width(4);
  W.set_line_width(2);
  W.display();
  segment s;
  forall(s,SiteList) {
    V.insert(rseg(s));
    //W.draw_segment(s);
    //W.draw_filled_node(s.start());
    //W.draw_filled_node(s.end());
  }
  V.draw_diagram(W);

  point pdel;
  int l=1;
  while (W.read_mouse(pdel) != MOUSE_BUTTON(3)) {
    list_item it;
    forall_items(it,SiteList) {
      if (SiteList[it].start()==pdel ||
          SiteList[it].end()==pdel)
        SiteList.del(it);
    }
    V.clear();
    W.clear();
    file_ostream to(ifile+"."+string("%d",l));
    forall(s,SiteList) {
      V.insert(rseg(s));
      to << "site " << s.start() << s.end() << endl;
    }
    to.close();
    ++l;
    V.draw_diagram(W);
  }
  forall(s,SiteList) {
    cout << "site " << s.start() << s.end() << endl;
  }

}

