
#include <LEP/avd/es_adaptation.h>
#include <LEP/avd/param_handler.h>

static window* p_W;
static ES_Voronoi_Diagram* p_AVD;

static rat_point rpnt(point p)
{ return rat_point(integer(p.xcoord()),integer(p.ycoord())); }

static void redraw_diagram()
{ p_AVD->draw_diagram(*p_W); }

main(int argc, char* argv[])
{
  int count = 0;
  param_handler params(argc,argv,"[filename]",0,1);
  string ifile;
  params.set(ifile,1);

  file_ostream to("log");
  if(!to)
    error_handler(1,"cannot open logfile!");

  window W;
  panel  P;
  ES_Voronoi_Diagram AVD;
  p_W = &W;
  p_AVD = &AVD;

  int bas_scale = 1;
  int scale= bas_scale;
  double x0=0 ,y0=0 ,x1,y1;
  W.init(x0-scale*50,x0+scale*50,y0-scale*50,scale);
  W.set_show_coordinates(true);
  W.display();
  W.clear();
  P.text_item("Viewer centered around the mouse click!");
  P.int_item("Basic Scale",bas_scale);
  int const scale_1_button = P.button("Scale 1");
  int const scale_2_button = P.button("Scale 2");
  int const scale_3_button = P.button("Scale 3");
  int const scale_4_button = P.button("Scale 4");
  int const recenter_button = P.button("Recenter");
  int const cancel_button = P.button("Cancel");

  // for the setting of the window redrawing function there's redraw\_diagram
  // calling the redraw function AV.draw\_diagram 

  point p,q;
  W.set_redraw(redraw_diagram);

  if (params.num() == 1)
  { 
    file_istream from(ifile);
    if(!from);
      error_handler(1,"cannot open input file!");
  
    while ((from >> p) && (from >> q))
    {
      // we assume that the input is on the integer grid
      to << p;
      to << q;
      to.flush();
      if (!AVD.insert(rat_segment(rpnt(p),rpnt(q)))) 
        cout << "illegal object: " << p << q << "\n";
    }
    if (!from.eof())
      error_handler(1,"your input file is corrupted!");
  }
  AVD.draw_diagram(W);


  int rally = W.read_mouse(p);
  while (rally != -3) 
  {

    if (rally == -1)
    {
      // mouse click on 1
      W.read_mouse_seg(p,q);

      to << p << q;
      to.flush();
      if (!AVD.insert(rat_segment(rpnt(p),rpnt(q)))) 
      {
        W.acknowledge("Object is illegal!\n");
        cout << "illegal object: " << p << q << "\n";
      }
      AVD.draw_diagram(W);
    }
    else // mouse click on 2
    {
      int result = P.open();
      if (result == scale_1_button)        
        scale = 1 * bas_scale;
      if (result == scale_2_button)        
        scale = 2 * bas_scale;
      if (result == scale_3_button)        
        scale = 3 * bas_scale;
      if (result == scale_4_button)        
        scale = 4 * bas_scale;
      if (result != cancel_button)
        W.init(p.xcoord()-scale*50,p.xcoord()+scale*50,
               p.ycoord()-scale*50,scale);
      AVD.draw_diagram(W);                
    }
    rally=W.read_mouse(p);
  }

  W.clear();
  AVD.clear();
}

