
#include <LEP/avd/ep_adaptation.h>
#include <LEP/avd/param_handler.h>

//------------------------------------------------------------------------------
// M       M      A      I  NN    N
// MM     MM     A A     I  N N   N
// M M   M M    A   A    I  N  N  N
// M  M M  M   AAAAAAA   I  N   N N
// M   M   M  A       A  I  N    NN
//------------------------------------------------------------------------------

window* pW;
EP_Voronoi_Diagram* pEVD;
file_ostream* pFO;

static void redraw_diagram()
{ pEVD->draw_diagram(*pW); }

static rat_point rpnt(point p)
{ return rat_point(int(p.xcoord()), int(p.ycoord())); }

void random_points(int n)
{ 
  int dx = int(1+(pW->xmax() - pW->xmin())/10);
  int dy = int(1+(pW->ymax() - pW->ymin())/10);

  int xmin = int(pW->xmin()+dx);
  int xmax = int(pW->xmax()-dx);
  int ymin = int(pW->ymin()+dy);
  int ymax = int(pW->ymax()-dy);
  while (n--) {
    pW->del_messages();
    pW->message(string(" %3d",n));
    double x = rand_int(xmin,xmax);
    double y = rand_int(ymin,ymax);
    point p(x,y);
    (*pFO) << p;

    //pW->draw_filled_node(p,blue2);
    pEVD->insert(rpnt(p));
  }
  print_time();
  pEVD->draw_diagram((*pW));
  pW->set_mode(src_mode);
  pW->del_messages();
}
   
main(int argc, char* argv[])
{
  param_handler params(argc,argv,"-f[input file] -p[pause] -h",0,2);
  string ifile;
  int pause = -2;
  params.set(ifile,1);
  params.set(pause,2);

  file_ostream to("log");
  if(!to) error_handler(1,"cannot open logfile!");
  pFO = &to;

  window W("Euclidean Voronoi Diagrams of Points (AVD Adaptation)");

  EP_Voronoi_Diagram EVD;
  pW = &W;
  pEVD = &EVD;
  int scale=1;
  W.set_show_coordinates(true);
  W.set_redraw(redraw_diagram);
  W.set_node_width(2);
  enum { RAND_BUTTON, ZOOM_BUTTON, END_BUTTON, HELP_BUTTON};
  menu rand_menu;
  rand_menu.button(" 125", 125,random_points);  
  rand_menu.button(" 250", 250,random_points);
  rand_menu.button(" 500", 500,random_points);
  rand_menu.button("1000",1000,random_points);
  rand_menu.button("2000",2000,random_points);
  rand_menu.button("4000",4000,random_points);
  rand_menu.button("8000",8000,random_points);
  W.button("Random Points", RAND_BUTTON , rand_menu);
  W.button("Zoom",ZOOM_BUTTON);
  W.button("End",END_BUTTON);
  W.button("Help",HELP_BUTTON);
  W.init(-50,50,-50,1);
  W.display();
  panel  P("Zoom it"), H("Help yourself");
  P.int_item("Scale factor:",scale,1,10);
  P.text_item("Viewer centered around the mouse click!");
  H.text_item("You can input points via the left mouse button,");
  H.text_item("by the [Random Points] menu, or by a command line call");
  H.text_item("of this program >> epvd [input file] [pause];");
  H.text_item("pause >= 0 animates the input with pause seconds pause, ");
  H.text_item("pause = -1 pauses after each increment, ");
  H.text_item("pause < -1 increments without break and animation (default).");
 
  // for the setting of the window redrawing function there's redraw_diagram
  // calling the redraw function EVD.draw_diagram

  point p;

  if (params.num() >= 1)
  { 
    file_istream from(ifile);
    if(!from) error_handler(1,"cannot open input file!");

    while (from >> p)
    {
      to << p;
      to.flush();
      if (pause == -2)
        EVD.insert(rpnt(p));
      else
        EVD.animated_insert(rpnt(p),W,pause);
    }
    if (!from.eof())
      error_handler(1,"your input file is corrupted!");
    EVD.draw_diagram(W);
  }
  print_time();
  W.message("You can enter points by the left mouse button!");
  int rally=W.read_mouse(p);
  bool loop = true;
  int x,y;
  while (loop) { // rally != MOUSE_BUTTON(3)) {
    switch (rally) {
    case MOUSE_BUTTON(1):
      to << p; to.flush();
      if (pause == -2) {
        EVD.insert(rpnt(p));
        EVD.draw_diagram(W);
      }
      else
        EVD.animated_insert(rpnt(p),W,pause);
      break;
    case MOUSE_BUTTON(2):
    case ZOOM_BUTTON:
      P.open();
      x = (int)p.xcoord();
      y = (int)p.ycoord();
      W.init(x-scale*50,x+scale*50,y-scale*50,scale);
      EVD.draw_diagram(W);
      break;
    case HELP_BUTTON:
      H.open();
      break;
    case MOUSE_BUTTON(3):
    case END_BUTTON:
      loop = false;
      continue;
      break;
    }
    rally=W.read_mouse(p);
  }
  W.clear();
  EVD.clear();
}


//----------------------------------- EOF --------------------------------------


