/****************************************************************************/
/* FILE NAME: LEADSHOW.C SOFTWARE DECOMPRESS FILE TO SCREEN                 */
/* PROGRAMER: MOHAMMAD DAHER                                                */
/* DATE:      03/12/1992                                                    */
/*                                                                          */
/*     COPYRIGHT (c) LEAD Technologies Inc. ALL RIGHTS RESEVED              */
/****************************************************************************/


#include <stdio.h>
#include <dos.h>
#include"v:\leadview\toolkit\L_Bitmap.h"
#include"v:\leadview\toolkit\L_error.h"
#include"v:\leadview\toolkit\toolapp.h"  


#define OK 1
#define BAD_COMMAND -2
#define TARGAOLD 1
#define VGA   2



int Width=0,Hight=0,Xorigin=0,Yorigin=0;
int time=99;
int video=VGA;



main(int argc, char *argv[])
{
  FILEINFO FileInformation;
  struct find_t file;
  int result;
  int i;
  char string[256], infile[128], pathname[128];
  int lines=0;
  int mode,page;
  int error;

  L_GetVideoMode(&mode,&page);

  if(argc<=1)
  {
     printf("COPYRIGHT (C) LEAD Technologies, Inc. 1991,1992 ALL RIGHTS RESERVED.\n");
     printf("              8701 Mallard Creek Rd.\n");
     printf("              Charlotte NC 28262      Tel# (704)549-5532\n\n");
     printf("LEADTOOLS DEMO is for Evaluation purposes only. Your license to use this\n");
     printf("software will expire after 3 weeks from the date you receive it.\n");
     printf("You are free to distribute this demo copy of LEADTOOLS as long as all files\n");
     printf("listed (DEMO.C DEMO36.EXE LEADSHOW.C LEADSHOW.EXE LEADCOMP.C\n");
     printf("LEADCOMP.EXE LEADECOM.C LEADECOM.EXE) are all included. You may not distribute\n");
     printf("any of the files separately.\n");
     printf("If you do not have the above list of files please contact LEAD Technologies Inc.\n");
     printf("for the complete list.\n");
     printf("All .EXE programs are not designed as end user products.  They all are a quick\n");
     printf("collection of calls to LEADTOOLS functions.  Menus were not included to avoid\n");
     printf("confusion when evaluating the code as to the processing calls verses the\n");
     printf("menuing code..........................PRESS ANY KEY TO CONTINUE.\n");
     L_SleepKey(20);
     printf("\nDOS - File to screen software deompression utility Version 3.6\n");
     printf("USEAGE: LEADSHOW <source file> [/option1] [/option2] [/option3] [/option4]\n\n");
     printf("<source file> is any LEAD, JFIF, or JTIF compressed file formats\n");
     printf("              or TGA, TIFF, PCX, GIF, BMP image file formats\n");
     printf("[option1] /TA for TARGA16, TARGA24, or TARGA32\n");
     printf(" or       /V320  display to FAST SUPER VGA 320X200\n");
     printf("          /V640  display to FAST SUPER VGA 640X480\n");
     printf("          /V800  display to FAST SUPER VGA 800X600\n");
     printf("          /V1024 display to FAST SUPER VGA 1024X768\n");
     printf("[option2] /T# number of seconds to keep image displayed on the screen\n");
     printf("[option3] /X# the X (horizontal) position of the image displayed on the screen\n");
     printf("[option4] /Y# the Y (vertical) position of the image displayed on the screen\n\n");
     printf("EXAMPLE LEADSHOW *.* /T4 /X20 /Y20\n");
     printf("Will display all image files to the VGA/SuperVGA screen at the best resolution\nfor the selected image file\n");
     exit(0);
  }


  for (i = 2; i<=argc; i++)
   {
      strupr(argv[i]);
      if(argv[i][0]=='/')
         if(get_value(&argv[i][1])==BAD_COMMAND)
           {
             printf("COPYRIGHT (C) LEAD Technologies, Inc. 1991,1992 ALL RIGHTS RESERVED.\n");
             printf("              8701 Mallard Creek Rd.\n");
             printf("              Charlotte NC 28262\n");
             printf("              tel# (704)549-5532\n");
             L_SleepKey(1);
             printf("\nDOS - File to screen software deompression utility Version 3.6\n");
             printf("USEAGE: LEADSHOW <source file> [/option1] [/option2] [/option3] [/option4]\n\n");
             printf("<source file> is any LEAD, JFIF, or JTIF compressed file formats\n");
             printf("              or TGA, TIFF, PCX, GIF, BMP image file formats\n");
             printf("[option1] /TA for TARGA16, TARGA24, or TARGA32\n");
             printf(" or       /V320  display to FAST SUPER VGA 320X200\n");
             printf("          /V640  display to FAST SUPER VGA 640X480\n");
             printf("          /V800  display to FAST SUPER VGA 800X600\n");
             printf("          /V1024 display to FAST SUPER VGA 1024X768\n");
             printf("[option2] /T# number of seconds to keep image displayed on the screen\n");
             printf("[option3] /X# the X (horizontal) position of the image displayed on the screen\n");
             printf("[option4] /Y# the Y (vertical) position of the image displayed on the screen\n\n");
             printf("EXAMPLE LEADSHOW *.* /T4 /X20 /Y20\n");
             printf("Will display all image files to the VGA/SuperVGA screen at the best resolution\nfor the selected image file\n\n\n");
             printf("BAD COMMAND %s\n",argv[i-1]);
              exit(0);
           }
   }
   get_pathname(argv[1], pathname);
   result = _dos_findfirst(argv[1], 0 , &file);
   if (result)   /* if result has any value rather that 0 then  */
      printf("LEADSHOW: no such file %s\n",argv[1]);
   else
      while(!result)  /* Stop when _dos_findnext returns */
       {
          strcpy(infile, pathname);
          strcat(infile, file.name);
          if (L_FileInfo(infile, &FileInformation)==SUCCESS)
           {
              if(video==VGA)
               {
                  L_SetVideoMode(mode,page);
                  printf("COPYRIGHT (C) LEAD Technologies, Inc. 1991,1992 ALL RIGHTS RESERVED.\n");
                  printf("              8701 Mallard Creek Rd.\n");
                  printf("              Charlotte NC 28262\n");
                  printf("              tel# (704)549-5532\n");
                  printf("\nDOS - File to screen software deompression utility Version 3.6\n");
                  printf("Viewing image file %s to VGA screen", infile);
                  if( FileInformation.Format == FILE_TGA)
                   {
                      error=L_ShowTGAScreen(infile,Width,Hight,Xorigin,Yorigin);
                   }
                  else if( FileInformation.Format == FILE_TIF)
                   {
                      error=L_ShowTIFScreen(infile,Width,Hight,Xorigin,Yorigin);
                   }
                  else if( FileInformation.Format == FILE_BMP)
                   {
                      error=L_ShowBMPScreen(infile,Width,Hight,Xorigin,Yorigin);
                   }
                  else if( FileInformation.Format == FILE_OS2)
                   {
                      error=L_ShowBMPScreen(infile,Width,Hight,Xorigin,Yorigin);
                   }
                  else if( FileInformation.Format == FILE_PCX)
                   {
                      error=L_ShowPCXScreen(infile,Width,Hight,Xorigin,Yorigin);
                   }
                  else if( FileInformation.Format == FILE_GIF)
                   {
                      error=L_ShowGIFScreen(infile,Width,Hight,Xorigin,Yorigin);
                   }
                  else if( FileInformation.Format == FILE_CMP)
                   {
                      error=L_DecompressVGAScreen(infile,Xorigin,Yorigin);
                   }
                  else if( FileInformation.Format == FILE_JFIF)
                   {
                      error=L_DecompressVGAScreen(infile,Xorigin,Yorigin);
                   }
                  else if( FileInformation.Format == FILE_JTIF)
                   {
                      error=L_DecompressVGAScreen(infile,Xorigin,Yorigin);
                   }
            
                 if(error==SUCCESS)
                  {
                     L_SleepKey(time);
                  }
                 else
                   {
                      printf("COPYRIGHT (C) LEAD Technologies, Inc. 1991,1992 ALL RIGHTS RESERVED.\n");
                      printf("              8701 Mallard Creek Rd.\n");
                      printf("              Charlotte NC 28262\n");
                      printf("              tel# (704)549-5532\n");
                      printf("\nDOS - File to screen software deompression utility Version 3.6\n");
                      printf("ERROR %d VIEWING IMAGE FILE %s\n",error,file.name);
                      l_SleepKey(2);
                   }
              }
              else if(video==TARGAOLD)
               {
                 printf("COPYRIGHT (C) LEAD Technologies, Inc. 1991,1992 ALL RIGHTS RESERVED.\n");
                 printf("              8701 Mallard Creek Rd.\n");
                 printf("              Charlotte NC 28262\n");
                 printf("              tel# (704)549-5532\n");
                 printf("\nDOS - File to screen software deompression utility Version 3.6\n");
                 printf("Viewing image file %s to TARGA screen",file.name);
                 if( FileInformation.Format == FILE_TGA)
                  {
                     error=L_ShowTGATarga(infile,Width,Hight,Xorigin,Yorigin);
                  }
                 else if( FileInformation.Format == FILE_TIF)
                  {
                     error=L_ShowTIFTarga(infile,Width,Hight,Xorigin,Yorigin);
                  }
                 else if( FileInformation.Format == FILE_BMP)
                  {
                     error=L_ShowBMPTarga(infile,Width,Hight,Xorigin,Yorigin);
                  }
                 else if( FileInformation.Format == FILE_OS2)
                  {
                     error=L_ShowBMPTarga(infile,Width,Hight,Xorigin,Yorigin);
                  }
                 else if( FileInformation.Format == FILE_PCX)
                  {
                     error=L_ShowPCXTarga(infile,Width,Hight,Xorigin,Yorigin);
                  }
                 else if( FileInformation.Format == FILE_GIF)
                  {
                     error=L_ShowGIFTarga(infile,Width,Hight,Xorigin,Yorigin);
                  }
                 else if( FileInformation.Format == FILE_CMP)
                  {
                     error=L_DecompressTARGAScreen(infile,Xorigin,Yorigin);
                  }
                 else if( FileInformation.Format == FILE_JFIF)
                  {
                     error=L_DecompressTARGAScreen(infile,Xorigin,Yorigin);
                  }
                 else if( FileInformation.Format == FILE_JTIF)
                  {
                     error=L_DecompressTARGAScreen(infile,Xorigin,Yorigin);
                  }
            
                if(error==SUCCESS)
                  L_SleepKey(time);
                else
                  {
                     printf("COPYRIGHT (C) LEAD Technologies, Inc. 1991,1992 ALL RIGHTS RESERVED.\n");
                     printf("              8701 Mallard Creek Rd.\n");
                     printf("              Charlotte NC 28262\n");
                     printf("              tel# (704)549-5532\n");
                     printf("\nDOS - File to screen software deompression utility Version 3.6\n");
                     printf("ERROR %d VIEWING IMAGE FILE %s\n",error,file.name);
                     l_SleepKey(2);
                  }
               }
              L_SetVideoMode(mode,page);
           }
          else
           {
              L_SetVideoMode(mode,page);
              printf("COPYRIGHT (C) LEAD Technologies, Inc. 1991,1992 ALL RIGHTS RESERVED.\n");
              printf("              8701 Mallard Creek Rd.\n");
              printf("              Charlotte NC 28262\n");
              printf("              tel# (704)549-5532\n");
              printf("\nDOS - File to screen software deompression utility Version 3.6\n");
              printf("ERROR %d VIEWING IMAGE FILE %s\n",error,file.name);
              printf("LEADSHOW: error opening file %s\n",file.name);
              putch(7);
           }
         result = _dos_findnext(&file);
       }
}







get_value(char *string)
{
 int ret=OK;

 if (string[0] == 'X')
  {
     Xorigin = atoi(string+1);
     if (Xorigin <= 0 || Xorigin > 1024)
        return(BAD_COMMAND);
     else
        return(ret);
  }

 if (string[0] == 'Y')
  {
     Yorigin = atoi(string+1);
     if (Yorigin <= 0 || Yorigin > 1024)
        return(BAD_COMMAND);
     else
        return(ret);
  }

 if (string[0] == 'T' && string[1] != 'A')
  {
     time = atoi(string+1);
     if (time < 0)
        return(BAD_COMMAND);
     else
        return(ret);
  }
 
 if (string[0] == 'T' && string[1] == 'A')
  {
     video=TARGAOLD;
     if(L_TARGAInit()==0)
      {
         printf("TARGA Initialization error\n\n");
         exit(0);
      }
  }


 if(string[0] == 'V')
  {
     video=VGA;
     if(strstr(string,"V320"))
        L_SetVGASize(SIZE_320x200);
     else if(strstr(string,"V640"))
        L_SetVGASize(SIZE_640x480);
     else if(strstr(string,"V800"))
        L_SetVGASize(SIZE_800x600);
     else if(strstr(string,"V1024"))
        L_SetVGASize(SIZE_1024x768);
  }
 return(ret);
}










get_pathname(char in[], char pathname[])
{
 int i;
 
 strcpy(pathname, in);
 for (i = strlen(in)-1; i >= 0; i--)
  {
    if( (in[i] == '\\') || (in[i] == ':') )
      break;
  }

 if (i == 0)
    pathname[0] = 0;
 else
    pathname[i+1] = 0;
}
