/****************************************************************************/
/* FILE NAME: LEADECOM.C SOFTWARE DECOMPRESS FILE TO FILE                   */
/* PROGRAMER: MOHAMMAD DAHER                                                */
/* DATE:      03/12/1992                                                    */
/*                                                                          */
/*     COPYRIGHT (c) LEAD Technologies Inc. ALL RIGHTS RESEVED              */
/****************************************************************************/

#include <stdio.h>
#include <dos.h>
#include"v:\leadview\toolkit\L_Bitmap.h"
#include"v:\leadview\toolkit\L_error.h"
#include"v:\leadview\toolkit\toolapp.h"  

#define OK 1
#define BAD_COMMAND -2
#define TARGAOLD 1
#define VGA   2

#if __BORLANDC__
    extern unsigned _stklen = 13000U;
#endif

int format = TGA24;

main(int argc, char *argv[])
{
  FILEINFO FileInformation;
  struct find_t file;
  int result;
  int i;
  char string[256];
  int mode,page;
  int error;
  char outfile[128], infile[128], pathname[128];
  int wild_flag = 0;

  if(argc<=2)
  {
     printf("COPYRIGHT (C) LEAD Technologies, Inc. 1991,1992 ALL RIGHTS RESERVED.\n");
     printf("              8701 Mallard Creek Rd.\n");
     printf("              Charlotte NC 28262      Tel# (704)549-5532\n\n");
printf("LEADTOOLS DEMO is for Evaluation purposes only. Your license to use this\n");
     printf("software will expire after 3 weeks from the date you receive it.\n");
     printf("You are free to distribute this demo copy of LEADTOOLS as long as all files\n");
     printf("listed (DEMO.C DEMO36.EXE LEADSHOW.C LEADSHOW.EXE LEADCOMP.C\n");
     printf("LEADCOMP.EXE LEADECOM.C LEADECOM.EXE) are all included. You may not distribute\n");
     printf("any of the files separately.\n");
     printf("If you do not have the above list of files please contact LEAD Technologies Inc.\n");
     printf("for the complete list.\n");
     printf("All .EXE programs are not designed as end user products.  They all are a quick\n");
     printf("collection of calls to LEADTOOLS functions.  Menus were not included to avoid\n");
     printf("confusion when evaluating the code as to the processing calls verses the\n");
     printf("menuing code..........................PRESS ANY KEY TO CONTINUE.\n");
      L_SleepKey(20);
      printf("\nDOS - File to file software decompresion utility Version 3.6\n");
      printf("USEAGE: LEADECOM <source file> <target file> [/option1]\n");
      printf("<source file> is any LEAD, JFIF, or JTIF compressed file formats\n");
      printf("<target file> is any DOS file name\n");
      printf("[option1] /TGA8 decompress to 8bits color mapped TGA image file format\n");
      printf("          /TGA16 decompress to 16bits TGA image file format\n");
      printf("          default /TGA24 decompress to 24bits TGA image file format\n");
      printf("          /TGA32 decompress to 32bits TGA image file format\n");
      printf("          /TIF24 decompress to 24bits TIF image file format\n");
      printf("          /TIF8 decompress to 8bits color mapped TIF image file format\n");
      printf("          /BMP24 decompress to 24bits Windows BMP image file format\n");
      printf("          /BMP8 decompress to 8bits color mapped Windows BMP image file format\n");
      printf("          /PM24 decompress to 24bits OS/2 BMP image file format\n");
      printf("          /PM8 decompress to 8bits color mapped OS/2 BMP image file format\n");
      printf("          /PCX decompress to 8bits color mapped PCX image file format\n");
      printf("          /GIF decompress to 8bits color mapped GIF image file format\n");
      printf("DOS wildcards are also supported for <source file> and <target file>\n");
      printf("EXAMPLE LEADECOM *.cmp *.TGA /TGA24\n");
      printf("  will decompress all cmp files to 24bits TGA files.\n");
      if(argc==1)
         printf("ERROR NO <source file> and <target file> specified");
      else
         printf("ERROR NO <target file> specified");
      exit(0);
  }
 else
    if(argv[1][0]=='/')
     {
        printf("Error Bad source file %s",argv[1]);
        exit(0);
     }
    else if(argv[2][0]=='/')
     {
        printf("Error Bad source file %s",argv[1]);
        exit(0);
     }
  
  
  strupr(argv[1]);
  strupr(argv[2]);
  
  if ( find_wildletter(argv[1]) == 1)
     {
       if (find_wildletter(argv[2]) == 1)
          wild_flag = 1;
     }
  
  for (i = 3; i<=argc; i++)
    {
       strupr(argv[i]);
       if(argv[i][0]=='/')
          if(get_value(argv[i]+1)==BAD_COMMAND)
           {
             printf("\nCOPYRIGHT (C) LEAD Technologies, Inc. 1991,1992 ALL RIGHTS RESERVED.\n");
             printf("              8701 Mallard Creek Rd.\n");
             printf("              Charlotte NC 28262      Tel# (704)549-5532\n");
             L_SleepKey(1);
             printf("\nDOS - File to file software decompresion utility Version 3.6\n");
             printf("USEAGE: LEADECOM <source file> <target file> [/option1]\n");
             printf("<source file> is any LEAD, JFIF, or JTIF compressed file formats\n");
             printf("<target file> is any DOS file name\n");
             printf("[option1] /TGA8 decompress to 8bits color mapped TGA image file format\n");
             printf("          /TGA16 decompress to 16bits TGA image file format\n");
             printf("          default /TGA24 decompress to 24bits TGA image file format\n");
             printf("          /TGA32 decompress to 32bits TGA image file format\n");
             printf("          /TIF24 decompress to 24bits TIF image file format\n");
             printf("          /TIF8 decompress to 8bits color mapped TIF image file format\n");
             printf("          /BMP24 decompress to 24bits Windows BMP image file format\n");
             printf("          /BMP8 decompress to 8bits color mapped Windows BMP image file format\n");
             printf("          /PM24 decompress to 24bits OS/2 BMP image file format\n");
             printf("          /PM8 decompress to 8bits color mapped OS/2 BMP image file format\n");
             printf("          /PCX decompress to 8bits color mapped PCX image file format\n");
             printf("          /GIF decompress to 8bits color mapped GIF image file format\n");
             printf("DOS wildcards are also supported for <source file> and <target file>\n");
             printf("EXAMPLE LEADECOM *.cmp *.TGA /TGA24\n");
             printf("  will decompress all cmp files to 24bits TGA files.\n");
             if(argc==1)
                printf("ERROR NO <source file> and <target file> specified");
             else
                printf("ERROR NO <target file> specified");
  
             printf("\nInvalid option %s",argv[i]);
             exit(0);
           }
    }
    
    
    get_pathname(argv[1], pathname);
    result = _dos_findfirst(argv[1], 0 , &file);
              /* _dosfindfirst will return a 0 if succesfull */
              /*   and any other value if not       */
  
    if (result)   /* if result has any value rather that 0 then  */
                  /* False = 0    True= any other value */
                  /* and when the function is succesful it return a 0 */
        printf("leadcomp: no such file %s\n",argv[1]);
    else
       while(!result)  /* Stop when _dos_findnext returns */
                       /*   a value other than a 0        */
                       /* becuse False =0 and when the
                       /* function is succesful it returns a 0) */
       {
        strcpy(infile, pathname);
        strcat(infile, file.name);
        if (L_FileInfo(infile,&FileInformation)==SUCCESS)
           {
               if (wild_flag == 1)
                  get_outfilename(file.name, argv[2], outfile);
  
               else
                  strcpy(outfile, argv[2]);
              printf("\nCOPYRIGHT (C) LEAD Technologies, Inc. 1991,1992 ALL RIGHTS RESERVED.\n");
              printf("              8701 Mallard Creek Rd.\n");
              printf("              Charlotte NC 28262      Tel# (704)549-5532\n");
              printf("\nDOS - File to file software decompresion utility Version 3.6\n");
              printf("\nDecompressing image file %s to %s", infile, outfile);
              if( (FileInformation.Format == FILE_CMP) ||
                ( FileInformation.Format == FILE_JFIF) ||
                ( FileInformation.Format == FILE_JTIF) )
                {
                   if((format==TGA8) || (format==TGA16) || (format==TGA24) ||
                      (format==TGA32) )
                        error=L_DecompressTGA(infile,outfile,format);
                   else if( (format==TIF8) || (format==TIF24) )
                        error=L_DecompressTIF(infile,outfile,format);
                   else if( (format==BMP8) || (format==BMP24) || (format==PM8) ||
                         (format==PM24) )
                        error=L_DecompressBMP(infile,outfile,format);
                   else if( (format==PCX8))
                        error=L_DecompressPCX(infile,outfile,format);
                   else if( (format==GIF8))
                         error=L_DecompressGIF(infile,outfile,format);
  
                }

               if(error!=SUCCESS)
                {
                   printf("\nCOPYRIGHT (C) LEAD Technologies, Inc. 1991,1992 ALL RIGHTS RESERVED.\n");
                   printf("              8701 Mallard Creek Rd.\n");
                   printf("              Charlotte NC 28262      Tel# (704)549-5532\n");
                   printf("\nDOS - File to file software decompresion utility Version 3.6\n");
                   printf("\nERROR %d DECOMPRESSING IMAGE FILE %s\n",error,file.name);
                }
           }
          else
           {
              printf("\nleadcomp: error opening file %s\n",file.name);
              putch(7);
           }
        result = _dos_findnext(&file);
       }
}
  
  
  
  
get_value(string)
char *string;
{
  int ret=OK;
  if     ( string[0] == 'T' && string[1] == 'G' && string[2] == 'A'
        && string[3] == '8' )
      {
         format=TGA8;
      }
  else if (   string[0] == 'T' && string[1] == 'G' && string[2] == 'A'
            && string[3] == '1' && string[4] == '6')
   {
      format=TGA16;
   }
  else if (   string[0] == 'T' && string[1] == 'G' && string[2] == 'A'
           && string[3] == '2' && string[4] == '4')
   {
      format=TGA24;
   }
  else if (   string[0] == 'T' && string[1] == 'G' && string[2] == 'A'
           && string[3] == '3' && string[4] == '2')
   {
      format=TGA32;
   }
  else if (   string[0] == 'T' && string[1] == 'I' && string[2] == 'F'
           && string[3] == '8')
   {
      format=TIF8;
   }
  else if (   string[0] == 'T' && string[1] == 'I' && string[2] == 'F'
           && string[3] == '2' && string[4] == '4')
   {
      format=TIF24;
   }
  else if (   string[0] == 'B' && string[1] == 'M' && string[2] == 'P'
           && string[3] == '8')
   {
      format=BMP8;
   }
  else if (   string[0] == 'B' && string[1] == 'B' && string[2] == 'P'
           && string[3] == '2' && string[4] == '4')
   {
      format=BMP24;
   }
  else if (   string[0] == 'P' && string[1] == 'M'
           && string[3] == '8' )
   {
      format=PM8;
   }
  else if (   string[0] == 'P' && string[1] == 'M' 
           && string[3] == '2' && string[4] == '4')
   {
      format=PM24;
   }
  else if (   string[0] == 'P' && string[1] == 'C' && string[2] == 'X')
   {
      format=PCX8;
   }
  else if (   string[0] == 'G' && string[1] == 'I' && string[2] == 'F' )
   {
      format=GIF8;
   }
  else
      return(ret);

return(ret);
}



get_outfilename(from_file, as_file, to_file)
char from_file[], as_file[], to_file[];
{
  char ext1[20], name1[128], ext2[20], name2[128];
  int i, q, j, ext1_flag = 0, ext2_flag = 0;
  int x, x1;
  
  ext1[0] = 0, ext2[0] = 0, name1[0] = 0, name2[0] = 0;
  for (i = strlen(from_file)-1; i >= 0; i--)
    if (from_file[i] == '.' && from_file[i+1] != '.' && from_file[i-1] != '.')
     {
         ext1_flag = 1;
         break;
      }
  
  strcpy(name1, from_file);
  name1[i] = 0;
  if (ext1_flag == 1)
    strcpy(ext1, from_file+i+1);
  for (i = strlen(as_file)-1; i >= 0; i--)
    if (as_file[i] == '.' && as_file[i+1] != '.' && as_file[i-1] != '.')
     {
        ext2_flag = 1;
        break;
     }
  
  strcpy(name2, as_file);
  name2[i] = 0;
  if (ext2_flag == 1)
     strcpy(ext2, as_file+i+1);
  
  for (i = 0, q = 0; i < strlen(name2); i++)
      {
       if (name2[i] == '*')
           {
           to_file[i] = 0;
           strcat(to_file+i, name1);
           i = i + strlen(name1+q);
           goto exit0;
           }
       if (name2[i] == '?')
          {
          to_file[i] = name1[i];
          q++;
          } 
       else
          to_file[i] = name2[i];
      }
  
   to_file[i] = 0;
   exit0:
  
   to_file[i] = '.';
   i++;
   for (j = 0, q = 0; j < strlen(ext2); i++, j++)
    {
       if (ext2[j] == '*')
        {
           to_file[i] = 0;
           strcat(to_file, ext1+q);
           return(0);
        }
       if (name2[i] == '?')
          {
          to_file[i] = ext1[j];
          q++;
          } 
       else
          to_file[i] = ext2[j];
    }
    to_file[i] = 0;
    if(to_file[i-1] == '.')
       to_file[i-1] = 0;
  
  return(0);
}
  

find_wildletter(string)
char string[];
{
int i;

for (i = 0; i < strlen(string); i++)
    if (string[i] == '*')
       return(1);

return(0);
}

get_pathname(in, pathname)
char in[], pathname[];
{
int i;

strcpy(pathname, in);

for (i = strlen(in)-1; i >= 0; i--)
    {
    if (in[i] == '\\' || in[i] == ':')
       break;
    }

if (i == 0)
   pathname[0] = 0;
else
   pathname[i+1] = 0;
}



