#include <stdio.h>
#include <dos.h>
#include"v:\leadview\toolkit\L_Bitmap.h"
#include"v:\leadview\toolkit\L_error.h"
#include"v:\leadview\toolkit\toolapp.h"  

#define OK 1
#define BAD_COMMAND -2
#define TARGAOLD 1
#define VGA   2

#if __BORLANDC__
    extern unsigned _stklen = 13000U;
#endif

int format = LEAD, qqfactor = PQ1, palette = NoVGAPalette;

main(int argc, char *argv[])
{
  FILEINFO FileInformation;
  struct find_t file;
  int result;
  int i;
  char string[256];
  int mode,page;
  int error;
  char outfile[128], infile[128], pathname[128];
  int wild_flag = 0;

 L_SetCheckStatus(NO_CHECK);
 if(argc<=2)
  {
     printf("COPYRIGHT (C) LEAD Technologies, Inc. 1991,1992 ALL RIGHTS RESERVED.\n");
     printf("              8701 Mallard Creek Rd.\n");
     printf("              Charlotte NC 28262      Tel# (704)549-5532\n\n");
     printf("LEADTOOLS DEMO is for Evaluation purposes only. Your license to use this\n");
     printf("software will expire after 3 weeks from the date you receive it.\n");
     printf("You are free to distribute this demo copy of LEADTOOLS as long as all files\n");
     printf("listed (DEMO.C DEMO36.EXE LEADSHOW.C LEADSHOW.EXE LEADCOMP.C\n");
     printf("LEADCOMP.EXE LEADECOM.C LEADECOM.EXE) are all included. You may not distribute\n");
     printf("any of the files separately.\n");
     printf("If you do not have the above list of files please contact LEAD Technologies Inc.\n");
     printf("for the complete list.\n");
     printf("All .EXE programs are not designed as end user products.  They all are a quick\n");
     printf("collection of calls to LEADTOOLS functions.  Menus were not included to avoid\n");
     printf("confusion when evaluating the code as to the processing calls verses the\n");
     printf("menuing code..........................PRESS ANY KEY TO CONTINUE.\n");
     L_SleepKey(20);
     printf("\nDOS - File to file software compression utility Version 3.6\n");
     printf("USEAGE: LEADCOMP <source file> <target file> [/option1] [/option2] \n");
     printf("<source file> is any TARGA, GIF, PCX, 8 or 24 bits TIF, 8 or 24 bits BMP\n");
     printf("<target file> is any DOS file name\n");
     printf("[option1] /LP (LEAD compression with VGA palette.)\n");
     printf("          /L default (LEAD compression without the VGA palette.)\n");
     printf("          /L2JFIF (LEAD JFIF LEAD JPEG Interchange File Format 4:2:2)\n");
     printf("          /L1JFIF (LEAD JFIF LEAD JPEG Interchange File Format 4:1:1)\n");
     printf("          /JFIF (JFIF JPEG Interchange File Format)\n");
     printf("          /L2JTIF (LEAD JTIF JPEG TIF 4:2:2)\n");
     printf("          /L1JTIF (LEAD JTIF JPEG TIF 4:1:1)\n");
     printf("          /JTIF (JTIF JPEG TIF)\n");
     printf("[option2] /# any number from 2 to 255\n");
     printf("          or the following options for LEAD compression only\n");
     printf("          /PQ1  default LEAD Perfect Quality compression option1\n");
     printf("          /PQ2  default LEAD Perfect Quality compression option2\n");
     printf("          /QFS LEAD Quality by far more important than Size\n");
     printf("          /QMS LEAD Quality more important than Size\n");
     printf("          /QS  LEAD Quality and Size are equally Important\n");
     printf("          /SQS LEAD Size more important than Quality sharp\n");
     printf("          /SQT LEAD Size more important than Quality less Tiling\n");
     printf("          /MCQ LEAD Maximum Compression, keep Quality as good as possible\n");
     printf("EXAMPLE   LEADCOMP *.TGA *.cmp /LP /PQ2   will compress all TGA files to LEAD\n");
     printf("with palette at LEAD Perfect Quality compression option2.\n");
     if(argc==1)
        printf("ERROR NO <source file> and <target file> specified");
     else
        printf("ERROR NO <target file> specified");
     exit(0);
  }
 else
    if(argv[1][0]=='/')
     {
        printf("Error Bad source file %s",argv[1]);
        exit(0);
     }
    else if(argv[2][0]=='/')
     {
        printf("Error Bad source file %s",argv[1]);
        exit(0);
     }


 strupr(argv[1]);
 strupr(argv[2]);
    
 if ( find_wildletter(argv[1]) == 1)
  {
     if (find_wildletter(argv[2]) == 1)
        wild_flag = 1;
  }
 for (i = 3; i<=argc; i++)
   {
      strupr(argv[i]);
      if(argv[i][0]=='/')
      if(get_value(argv[i]+1)==BAD_COMMAND)
         {
            printf("\nCOPYRIGHT (C) LEAD Technologies, Inc. 1991,1992 ALL RIGHTS RESERVED.\n");
            printf("              8701 Mallard Creek Rd.\n");
            printf("              Charlotte NC 28262      Tel# (704)549-5532\n\n");
            L_SleepKey(1);
            printf("\nDOS - File to file software compression utility Version 3.6\n");
            printf("USEAGE: LEADCOMP <source file> <target file> [/option1] [/option2] \n");
            printf("<source file> is any TARGA, GIF, PCX, 8 or 24 bits TIF, 8 or 24 bits BMP\n");
            printf("<target file> is any DOS file name\n");
            printf("[option1] /LP (LEAD compression with VGA palette.)\n");
            printf("          /L default (LEAD compression without the VGA palette.)\n");
            printf("          /L2JFIF (LEAD JFIF LEAD JPEG Interchange File Format 4:2:2)\n");
            printf("          /L1JFIF (LEAD JFIF LEAD JPEG Interchange File Format 4:1:1)\n");
            printf("          /JFIF (JFIF JPEG Interchange File Format)\n");
            printf("          /L1JTIF (LEAD JTIF JPEG TIF 4:2:2)\n");
            printf("          /L2JTIF (LEAD JTIF JPEG TIF 4:1:1)\n");
            printf("          /JTIF (JTIF JPEG TIF)\n");
            printf("[option2] /# any number from 2 to 255\n");
            printf("          or the following options for LEAD compression only\n");
            printf("          /PQ1  default LEAD Perfect Quality compression option1\n");
            printf("          /PQ2  default LEAD Perfect Quality compression option2\n");
            printf("          /QFS LEAD Quality by far more important than Size\n");
            printf("          /QMS LEAD Quality more important than Size\n");
            printf("          /QS  LEAD Quality and Size are equally Important\n");
            printf("          /SQS LEAD Size more important than Quality sharp\n");
            printf("          /SQT LEAD Size more important than Quality less Tiling\n");
            printf("          /MCQ LEAD Maximum Compression, keep Quality as good as possible\n");
            printf("          /MC  LEAD Maximum Compression\n");
            printf("EXAMPLE   LEADCOMP *.TGA *.cmp /LP /PQ2    will compress all TGA files to LEAD\n");
            printf("with palette at LEAD Perfect Quality compression option2.\n");
            printf("\nInvalid option %s",argv[i]);
            exit(0);
         }
   }
   get_pathname(argv[1], pathname);
   result = _dos_findfirst(argv[1], 0 , &file);
   if (result) 
       printf("LEADCOMP: no such file %s\n",argv[1]);
   else
       while(!result)  /* Stop when _dos_findnext returns */
         {
            strcpy(infile, pathname);
            strcat(infile, file.name);
            if ( (L_FileInfo(infile,&FileInformation)==SUCCESS) && (FileInformation.BitsPerPixel >=8) )
               {
                 if (wild_flag == 1)
                    get_outfilename(file.name, argv[2], outfile);
                 else
                    strcpy(outfile, argv[2]);
                 printf("\nCOPYRIGHT (C) LEAD Technologies, Inc. 1991,1992 ALL RIGHTS RESERVED.\n");
                 printf("              8701 Mallard Creek Rd.\n");
                 printf("              Charlotte NC 28262      Tel# (704)549-5532\n\n");
                 printf("\nDOS - File to file software compression utility Version 3.6\n");
                 printf("\nCompressing image file %s to %s", infile, outfile);
                 if( FileInformation.Format == FILE_TGA)
                  {
                      error=L_CompressTGA(infile,outfile,format,qqfactor,palette);
                  }
                 else if( FileInformation.Format == FILE_TIF)
                  {
                     error=L_CompressTIF(infile,outfile,format,qqfactor,palette);
                  }
                 else if( FileInformation.Format == FILE_BMP)
                  {
                     error=L_CompressBMP(infile,outfile,format,qqfactor,palette);
                  }
                 else if( FileInformation.Format == FILE_OS2)
                  {
                     error=L_CompressBMP(infile,outfile,format,qqfactor,palette);
                  }
                 else if( FileInformation.Format == FILE_PCX)
                  {
                     error=L_CompressPCX(infile,outfile,format,qqfactor,palette);
                  }
                 else if( FileInformation.Format == FILE_GIF)
                  {
                     error=L_CompressGIF(infile,outfile,format,qqfactor,palette);
                  }
               
                 if(error!=SUCCESS)
                  {
                      printf("\nCOPYRIGHT (C) LEAD Technologies, Inc. 1991,1992 ALL RIGHTS RESERVED.\n");
                      printf("              8701 Mallard Creek Rd.\n");
                      printf("              Charlotte NC 28262      Tel# (704)549-5532\n\n");
                      printf("\nDOS - File to file software compression utility Version 3.6\n");
                      printf("\nERROR %d COMPRESSING IMAGE FILE %s\n",error,file.name);
                  }
               }
              else
               {
                  printf("\nLEADCOMP: error opening file %s\n",file.name);
                  putch(7);
               }
            result = _dos_findnext(&file);
         }

}




get_value(string)
char *string;
{
  char *exttab[20], *extptr1;
  int pathlen1, ret = OK, source;
 
  exttab[0] = "LP";
  exttab[1] = "L";
  exttab[2] = "L2JFIF";
  exttab[3] = "L1JFIF";
  exttab[4] = "JFIF";
  exttab[5] = "L2JTIF";
  exttab[6] = "L1JTIF";
  exttab[7] = "JTIF";
  exttab[8] = "PQ1";
  exttab[9] = "PQ2";
  exttab[10] = "QFS";
  exttab[11] = "QMS";
  exttab[12] = "QS";
  exttab[13] = "SQS";
  exttab[14] = "SQT";
  exttab[15] = "MCQ";
  exttab[16] = "MC";
  exttab[17] = "SAVE";
  exttab[18] = "NOSAVE";
  
  extptr1 = string;
  
  for (source = 0; source < 19; ++source)
   {
      if (!strcmp(extptr1, exttab[source]))
         break;
   }
  
   if (source >= 19)
     {
       qqfactor = atoi(string);
       if (qqfactor <= 0 || qqfactor > 255)
          return(BAD_COMMAND);
       return(OK);
     }
  
    switch (source)
      {
         case  0:
               format = LEAD;
               palette = SaveVGAPalette;
               break;
  
         case  1:
               format = LEAD;
               palette = NoVGAPalette;
               break;
  
         case  2:
               format = LEAD2JFIF;
               qqfactor = 5;
               break;
  
         case  3:
               format = LEAD1JFIF;
               qqfactor = 5;
               break;

         case  4:
               format = JFIF;
               qqfactor = 5;
               break;

         case  5:
               format = LEAD2JTIF;
               qqfactor = 5;
               break;
  
         case  6:
               format = LEAD1JTIF;
               qqfactor = 5;
               break;

         case  7:
               format = JTIF;
               qqfactor = 5;
               break;

         case  8:
               qqfactor = PQ1;
               break;
  
         case  9:
               qqfactor = PQ2;
               break;
  
         case  10:
               qqfactor = QFS;
               break;
  
         case  11:
               qqfactor = QMS;
               break;
  
         case  12:
               qqfactor = QS;
               break;
  
         case  13:
               qqfactor = SQS;
               break;
  
         case  14:
               qqfactor = SQT;
               break;
  
  
         case  15:
               qqfactor = MCQ;
               break;
  
         case  16:
               qqfactor = MC;
               break;
  
         case  17:
               palette = SaveVGAPalette;
               break;
  
         case  18:
               palette = NoVGAPalette;
               break;
  
  
        default:
               ret = BAD_COMMAND;
               break;
      }
  
  return(ret);
}




get_outfilename(from_file, as_file, to_file)
char from_file[], as_file[], to_file[];
{
  char ext1[120], name1[128], ext2[120], name2[128];
  int i, q, j, ext1_flag = 0, ext2_flag = 0;
  int x, x1;
  
  ext1[0] = 0, ext2[0] = 0, name1[0] = 0, name2[0] = 0;
  for (i = strlen(from_file)-1; i >= 0; i--)
    if (from_file[i] == '.' && from_file[i+1] != '.' && from_file[i-1] != '.')
     {
         ext1_flag = 1;
         break;
      }
  
  strcpy(name1, from_file);
  name1[i] = 0;
  if (ext1_flag == 1)
    strcpy(ext1, from_file+i+1);
  for (i = strlen(as_file)-1; i >= 0; i--)
    if (as_file[i] == '.' && as_file[i+1] != '.' && as_file[i-1] != '.')
     {
        ext2_flag = 1;
        break;
     }
  
  strcpy(name2, as_file);
  name2[i] = 0;
  if (ext2_flag == 1)
     strcpy(ext2, as_file+i+1);
  
  for (i = 0, q = 0; i < strlen(name2); i++)
      {
       if (name2[i] == '*')
           {
           to_file[i] = 0;
           strcat(to_file+i, name1);
           i = i + strlen(name1+q);
           goto exit0;
           }
       if (name2[i] == '?')
          {
          to_file[i] = name1[i];
          q++;
          } 
       else
          to_file[i] = name2[i];
      }
  
   to_file[i] = 0;
   exit0:
  
   to_file[i] = '.';
   i++;
   for (j = 0, q = 0; j < strlen(ext2); i++, j++)
    {
       if (ext2[j] == '*')
        {
           to_file[i] = 0;
           strcat(to_file, ext1+q);
           return(0);
        }
       if (name2[i] == '?')
          {
          to_file[i] = ext1[j];
          q++;
          } 
       else
          to_file[i] = ext2[j];
    }
    to_file[i] = 0;
    if(to_file[i-1] == '.')
       to_file[i-1] = 0;
  
  return(0);
}
  


  
find_wildletter(string)
char string[];
{
  int i;
  
  for (i = 0; i < strlen(string); i++)
   if (string[i] == '*')
         return(1);
  
  return(0);
}


get_pathname(in, pathname)
char in[], pathname[];
{
  int i;

  strcpy(pathname, in);
  for (i = strlen(in)-1; i >= 0; i--)
    {
       if (in[i] == '\\' || in[i] == ':')
          break;
    }

  if (i == 0)
     pathname[0] = 0;
  else
     pathname[i+1] = 0;
}



