/*****************************************************************************
 *  Last Modified:  3/26/92                                                   *
 *  Filenanme   : DEMO.C                                                     *
 *                 This is an example program that demonstrates use          *
 *                 of the most commonly called LEADTOOLS functions.          *
 *                 This  will be a guideline for developers to call          *
 *                 and use LEADTOOLS compression/decompression,              *
 *                 viewing, conversion, and all the BitMap load, flip,       *
 *                 reverse functions for both TARGA and VGA/SuperVGA         *
 *                 graphics card.                                            *
 *                                                                           *
 *                 This example uses both TARGA and VGA display in the same  *
 *                 program. If your application uses only the TARGA display  *
 *                 then do not use the L_Load???Screen() functions (where    *
 *                 ??? is the file format). Also, if you are writing only    *
 *                 for VGA display, then do not use the L_Load???Targa()     *
 *                 functions. If both are used, then the EXE file will be    *
 *                 larger than necessary since these routine are not         *
 *                 applicable to the hardware.                               *
 *                                                                           *
 ****************************************************************************/

/********* INCLUDES  *********/
#include  "V:\LEADVIEW\TOOLKIT\toolapp.h"  /* Application tools for the toolkit */
#include  "V:\LEADVIEW\TOOLKIT\l_error.h"  /* Error return codes                */
#include  "V:\LEADVIEW\TOOLKIT\l_bitmap.h" /* Bitmap file information           */
#include  <ctype.h>                /* Standard C header files           */
#include  <conio.h>
#include  <stdio.h>
#include  <stdlib.h>
#include  <string.h>

#if __BORLANDC__
    extern unsigned _stklen = 13000U;
#endif

/* A define used in get_qfactor for transforming the characters typed for
LEAD's Compression formats enhanced options to their equivalent
integer defines. */

#define NUMEXTENSIONS 9


/*********************** Global Variables ***********************/
char screen_buffer[4000]; /* Holds the TEXT in a text mode screen */

char screen_clear[4000];  /* Holds the a blank text screen        */
char clear_line[160];     /* Holds the a blank line buffer        */
int mode, page;                    /* Holds the current video text mode and
                                      page */
int curcolumn, currow;             /* Current cursor column and row        */


/********************** Decalare Functions ********************/
int get_qfactor(char *string);     /* Convert the characters typed for the
                                      ImageQfactor to the equivalent integer
                                      defines. */
void printscreen(void);            /* Prints the user input screen         */
void getint(int *);                /* Gets an integer from the keyboard    */
void getstring(char *answer);      /* Gets a string from the keyboard      */
void ClearTheScreen(void);         /* Blanks the screen                    */
void RestoreInputScreen(void);     /* Restores the main menu               */
   


/****************************************************************************
 *                                main()                                    *
 ****************************************************************************/
void main()
{
  int TARGA_FLAG;       /* Flag used to verify if a TARGA board is present */
  int function_type;    /* Switch to determine which function to call      */
  int ret;              /* Function return values                          */
  int videotype;        /* To determine the VGA/SuperVGA graphics card type */
  int width;            /* Image width       */
  int height;           /* Image height      */
  int BitsPerPixel;     /* As it says        */
  int alloc_bitmap = 0; /* Flag to determine if there is a BitMap allocated
                           in memory                                       */

  int compress_format; /* Compression method to be used, either
                          LEAD, JFIF, or JTIF */
  int qfactor;         /* To determine the degree of compression for
                          CMP, JFIF and JTIF */

  int new_width,       /* For resizing an image */
      new_height; 
  int xpos, ypos;      /* For viewing image at different locations on
                          the screen */
  int save_palette;    /* Flag for saving the VGA palette in a compressed
                          file or not */
  int output_format;   /* For saving an image into the desired file format */
  int video_size;      /* Select a video mode */
  int video_memory;    /* Amount of video memory in KBytes
                          available in the VGA/SuperVGA card */
  int input_format;    /* For selecting the input file format in the
                          file to file conversion process */

  char input_filename[160], /* Strings for input and output DOS file names */
       output_filename[160];

  char compress_qfactor[100]; /* String for entering compression Q factor */
  
  BITMAPHANDLE Bitmap;    /* The main BITMAPHANLE used in the program */
  BITMAPHANDLE NewBitmap; /* A BitMap handle used for the resizing,
                             optimizing, and viewing functions */

  FILEINFO     FileInfo;  /* Structure that L_FileInfo will fill to return
                             important information about an image file */

  int format; /* used for BMP windows or PM */

  /* Initialize the TARGA graphics environment. This function must be called
     before any other function to communicate with the TARGA. */
  if (L_TARGAInit() <= 0)
      {
       printf("TARGA board initialization error or TARGA not present!\n");
       printf("Do not atempt to use any of the TARGA functions!\n\n");
       printf("Press any key to continue.\n" );
       putch(7);
       getch();
       TARGA_FLAG=0;
      }
      else
        TARGA_FLAG=1;

 /* Set current video display mode and page. The purpose of this function is
    to allow the developer to run his program in any of the text modes and
    pages.  Call the L_GetVideoMode function before loading a graphical
    image which requires the graphics adapter to chage from text mode to
    graphic mode. Then load the image. When finished, use this function
    to chage back to the same text mode and reference page as before
    calling the L_GetVideoMode.                                   */
    L_SetVideoMode(3, 0);

    printscreen(); /* Prints out the main menu on the screen      */

    for(;;)       /* Loops until user enters 100 to exit program */
        {
         RestoreInputScreen();      /* Restore the input screen and
                                       set the cursor position to 0,24 */

         getint(&function_type);    /* Get user input                  */

         switch (function_type)     /* Main switch on user's input     */
         {
          case 1:/* Case load TGA file to a BitMap           */
                 /* If a BitMap exists we need to free it    */
                   if (alloc_bitmap == 1)
                   {
                    L_FreeBitmap( &Bitmap );
                    alloc_bitmap = 0;
                   }
                   printf("Input file name: ");
                   getstring(input_filename);
                   /* Load the TGA filename directly into the BitMap handle.*/
                   if ( (ret=L_LoadTGATarga( input_filename,
                                             &Bitmap,OUTPUT_BITMAP,
                                             TYPE_NOCONV, 0, 0 )) == SUCCESS )
                   { /* It alocated a BitMap sucessfully */
                     alloc_bitmap = 1;
                     printf("%s loaded to the BitMap. Press any key to continue.",input_filename);
                   }
                   else 
                   { /* An error occured while loading the TGA file */
                     printf("Error: %d loading TGA to BitMap. Press any key to continue.", ret);
                     putch(7);
                   }
          break;

          case 2:/* Case save a BitMap to TGA file */
                 /* Make sure BitMap is being used and filled with image data */
                 if (alloc_bitmap == 1)
                  {
                    printf("Output file name: ");
                    getstring(output_filename);
                    printf("BitsPerPixel (8, 16, 24 or 32): ");
                    getint(&BitsPerPixel);
                    /* Save the image Data in BitMap to a TGA file */
                    if ( (ret=L_SaveTGABitmap( output_filename,
                                               &Bitmap,BitsPerPixel )) == SUCCESS )
                     {
                      printf("%s saved OK.  Press any key to continue.",output_filename);
                     }
                     else
                     { /* Error saving the TGA BitMap to the file */
                      printf("Error: %d saving BitMap to TGA. Press any key to continue.", ret);
                      putch(7);
                     }
                  }
                  else
                   { /* Trying to save an empty BitMap */
                     printf("Error: No image in the BitMap allocated. Press any key to continue.");
                     putch(7);
                    }
          break;

          case 3:/* Case load a PCX file to the BitMap */
                 /* Make sure BitMap used and is filled with image */
                 if (alloc_bitmap == 1)
                  {
                   L_FreeBitmap( &Bitmap );
                   alloc_bitmap = 0;
                  }
                  printf("Input file name: ");
                  getstring(input_filename);
                  /* Load the PCX filename directly into the BitMap handle.*/
                  if ( (ret=L_LoadPCXScreen( input_filename,
                                             &Bitmap, OUTPUT_BITMAP,
                                             TYPE_NOCONV, 0, 0 )) == SUCCESS )
                   {/* If the PCX file was successfuly loaded to the BitMap */
                     alloc_bitmap = 1;
                     printf("%s loaded to BitMap. Press any key to continue.",input_filename);
                   }
                  else
                   {
                    printf("Error: %d loading PCX to BitMap. Press any key to continue.", ret);
                    putch(7);
                   }
          break;

          case 4:/* Case save a BitMap to a PCX file */
                 /* Make sure BitMap is already being used and is filled with image data */
                 if (alloc_bitmap == 1)
                  {
                   printf("Output file name: ");
                   getstring(output_filename);
                   printf("BitsPerPixel (1, 4, or 8): ");
                   getint(&BitsPerPixel);
                   /* Save the image Data in BitMap to a PCX file*/
                   if ( (ret=L_SavePCXBitmap( output_filename,&Bitmap,
                                              BitsPerPixel )) == SUCCESS )
                    {
                      printf("%s saved OK.  Press any key to continue.",output_filename);
                    }
                   else
                    {
                     printf("Error: %d saving BitMap to PCX. Press any key to continue.", ret);
                     putch(7);
                   }
                  }
                 else
                  {  /* Trying to save an empty BitMap */
                   printf("Error: No image in the BitMap allocated. Press any key to continue.");
                   putch(7);
                  }
          break;

          case 5:/* Case Load GIF to BitMap */
                 /* If a BitMap is already being used we need to free it */
                 if (alloc_bitmap == 1)
                  {
                   L_FreeBitmap( &Bitmap );
                   alloc_bitmap = 0;
                  }
                  printf("Input file name: ");
                  getstring(input_filename);
                  /* Load a GIF file to a BitMap */
                  if ( (ret=L_LoadGIFScreen( input_filename,
                                             &Bitmap, OUTPUT_BITMAP,
                                             TYPE_NOCONV, 0, 0 )) == SUCCESS )
                   {
                    alloc_bitmap = 1;
                    printf("%s loaded to BitMap. Press any key to continue.",input_filename);
                   }
                  else
                   {
                    printf("Error: %d loading GIF to the BitMap. Press any key to continue.", ret);
                    putch(7);
                   }
          break;

          case 6:/* Case save a BitMap as GIF file */
                 /* Make sure BitMap is already being used and filled with image data */
                 if (alloc_bitmap == 1)
                  {
                   printf("Output file name: ");
                   getstring(output_filename);
                   /* Saving the BitMap to a GIF file */
                   if ( (ret=L_SaveGIFBitmap( output_filename,
                                             &Bitmap, 8 )) == SUCCESS )
                    {
                     printf("%s saved OK.  Press any key to continue.",output_filename);
                    }
                   else
                    {
                     printf("Error: %d saving the BitMap to GIF. Press any key to continue.", ret);
                     putch(7);
                    }
                  }
                 else
                  {
                   printf("Error: No image in the BitMap allocated. Press any key to continue.");
                   putch(7);
                  }
          break;

          case 7:/* Case Load a TIF file to a BitMap */
                 /* If a BitMap is already being used free it */
                 if (alloc_bitmap == 1)
                  {
                   L_FreeBitmap( &Bitmap );
                   alloc_bitmap = 0;
                  }
                  printf("Input file name: ");
                  getstring(input_filename);
                  /* Load the TIF file to a BitMap */
                 if ( (ret=L_LoadTIFScreen( input_filename, &Bitmap,
                                            OUTPUT_BITMAP, TYPE_NOCONV, 0, 0 )) == SUCCESS )
                  {
                   alloc_bitmap = 1;
                   printf("%s loaded to BitMap. Press any key to continue.",input_filename);
                  }
                 else
                  {
                   printf("Error: %d loading TIF to the BitMap. Press any key to continue.", ret);
                   putch(7);
                  }
          break;

          case 8:/* Case save a BitMap to a TIF file */
                 /* Make sure BitMap is already being used and is filled with image data */
                 if (alloc_bitmap == 1)
                  {
                   printf("Output file name: ");
                   getstring(output_filename);
                   printf("BitsPerPixel (1, 8, or 24): ");
                   getint(&BitsPerPixel);
                   /* Save the BitMap to a TIF file */
                   if ( (ret=L_SaveTIFBitmap( output_filename, &Bitmap,
                                              BitsPerPixel )) == SUCCESS )
                    {
                     printf("%s saved OK.  Press any key to continue.",output_filename);
                    }
                   else
                    {
                     printf("Error: %d saving the BitMap to TIF. Press any key to continue.", ret);
                     putch(7);
                    }
                  }
                 else
                  {
                   printf("Error: No image in the BitMap allocated. Press any key to continue.");
                   putch(7);
                  }
          break;

          case 9:/* Case Load a BMP file to a BitMap */
                 /* If a BitMap is already being used free it */
                 if (alloc_bitmap == 1)
                  {
                   L_FreeBitmap( &Bitmap );
                   alloc_bitmap = 0;
                  }
                 printf("Input file name: ");
                 getstring(input_filename);
                 /* Load a BMP file to the BitMap */
                 if ( (ret=L_LoadBMPScreen( input_filename, &Bitmap,
                                            OUTPUT_BITMAP, TYPE_NOCONV, 0, 0 )) == SUCCESS )
                  {
                   alloc_bitmap = 1;
                   printf("%s loaded to BitMap. Press any key to continue.",input_filename);
                  }
                 else
                 {
                  printf("Error: %d loading BMP to the BitMap. Press any key to continue.", ret);
                  putch(7);
                 }
          break;

          case 10:/* Case save a BitMap to a BMP file */
                  /* Make sure BitMap is already being used and is filled with image data */
                  if (alloc_bitmap == 1)
                   {
                    printf("Output file name: ");
                    getstring(output_filename);
                    printf("BitsPerPixel (4, 8, or 24): ");
                    getint(&BitsPerPixel);
                    printf("type 0 for (WINDOWS BMP), or 1 for (PM BMP): ");
                    getint(&format);
                    if(format==0)
                       format=TYPE_WIN;
                    else if(format==1)
                        format=TYPE_OS2;
                     else
                        {
                         printf("%d not a valid option",format);
                         getch();
                         break;
                        }
                    /* Save the BitMap to a BMP file */
                    if ( (ret=L_SaveBMPBitmap( output_filename,&Bitmap,
                                             BitsPerPixel, format )) == SUCCESS )
                     {
                      printf("%s saved OK.  Press any key to continue.",output_filename);
                     }
                    else
                     {
                      printf("Error: %d saving the BitMap to BMP. Press any key to continue.", ret);
                      putch(7);
                     }
                   }
                  else
                   {
                    printf("Error: No image in the BitMap allocated. Press any key to continue.");
                    putch(7);
                   }
          break;

          case 11:/* Decompress a compressed file to a BitMap*/
                  /* If a BitMap is already being used free it */
                  if (alloc_bitmap == 1)
                   {
                    L_FreeBitmap( &Bitmap );
                    alloc_bitmap = 0;
                   }
                  printf("Input file name: ");
                  getstring(input_filename);
                  /* Decompress a LEAD, JTIF, or JFIF compressed file format
                     directly to a BitMap*/
                 L_InitBitmap( &Bitmap, 0, 0, 0);
                 if ( (ret=L_DecompressBitmap ( input_filename,
                                                &Bitmap, BIT24 )) == SUCCESS )
                  {
                   alloc_bitmap = 1;
                   printf("Image decompressed to a BitMap. Press any key to continue.");
                  }
                 else
                  {
                   printf("Error: %d Decompressing to the BitMap. Press any key to continue.", ret);
                   putch(7);
                  }
          break;
          
          case 12:/* Case compress a BitMap to a compressed format */
                  /* Make sure BitMap is already being used and is filled with image data */
                  if (alloc_bitmap == 1)
                   {
                    printf("Output file name: ");
                    getstring(output_filename);
                    printf("Compress format 0 - LEAD, 1 - JFIF, 2 - JTIF, 3 - LEAD1JFIF, 4 - LEAD1JTIF,\n");
                    printf("5 - LEAD2JFIF, 6 - LEAD2JTF: ");
                    getint(&compress_format);
                    printf("Qfactor 1 to 255 or LEAD defined PQ1, PQ2, QFS, QMS, QS, SQS, SQT, MCQ, MC ");
                    getstring(compress_qfactor);
                    strupr(compress_qfactor);
                    /* Check for a correct Qfactor entered */
                    if ( (qfactor = get_qfactor(compress_qfactor)) == ERROR_QFACTOR)
                     {
                      printf("Bad qfactor. Press any key to continue.");
                      putch(7);
                      break;
                     }
                    /* If the user selected the LEAD compressed file format
                       then ask to see if he/she would also like to save the
                       VGA palette */
                    if (compress_format != 0)
                        save_palette = 0;
                    else
                     {
                      printf("Save VGA palette? 0 - No, 1 - YES: ");
                      getint(&save_palette);
                      while( (save_palette != 0) && (save_palette != 1) )
                       {
                        printf("Save VGA palette? 0 - No, 1 - YES: ");
                        getint(&save_palette);
                       }
                     }
                    /* Compress the BitMap to a compressed file */
                    if ( (ret = L_CompressBitmap ( &Bitmap,
                                                output_filename, compress_format,
                                                qfactor, save_palette )) == SUCCESS )
                     {
                      printf("BitMap compressed. Press any key to continue.");
                     }
                    else
                     {
                      printf("Error: %d compressing the BitMap. Press any key to continue.", ret);
                      putch(7);
                     }
                   }
                  else
                   {
                    printf("Error: No image in the BitMap allocated. Press any key to continue.");
                    putch(7);
                   }
          break;

          case 13: /* Case Flip a BitMap */
                   /* Flip vertical      */
                   /* Make sure BitMap is already being used and is filled with image data */
                   if ( alloc_bitmap == 0 )
                    {
                     printf("Error: No storage has been allocated for a BitMap. Press any key to continue.");
                     putch(7);
                     break;
                    }
                    /* Flip an image in the BitMap (top to bottom) */
                    if ( (ret = L_FlipBitmap( &Bitmap )) == SUCCESS)
                     {
                      printf("Image fliped. Press any key to continue.");
                     }
                    else
                     {
                      printf("Error: %d could not flip image. Press any key to continue.", ret);
                      putch(7);
                     }
          break;

          case 14: /* Case reverse an image in a BitMap */
                   /* Flip horizontal                   */
                   /* Make sure BitMap is already being used and is filled with image data */
                   if ( alloc_bitmap == 0 )
                    {
                     printf("Error: No image in the BitMap allocated. Press any key to continue.");
                     putch(7);
                     break;
                    }
                    /* Reverse an image in a BitMap (left to right) */
                    if ( (ret = L_ReverseBitmap( &Bitmap )) == SUCCESS)
                     {
                      printf("Image reversed. Press any key to continue.");
                     }
                    else
                     {
                      printf("Error: %d Reversing the image. Press any key to continue.", ret);
                      putch(7);
                     }
          break;

         case 15: /* Case resize the image in the BitMap */
                  /* Make sure BitMap is already being used and is filled with image data */
                  if ( alloc_bitmap == 0 )
                   {
                    printf("Error: No image in the BitMap allocated. Press any key to continue.");
                    putch(7);
                    break;
                   }
                   printf("New BitMap width: ");
                   getint(&new_width);
                   printf("New BitMap height: ");
                   getint(&new_height);
                  /* Will alocate room and initialize a new Bitmap while keeping
                     the original BitMap. Then the original BitMap location is released. */
                  /* Initialize fields in a BitMap handle.                       */
                     L_InitBitmap( &NewBitmap, new_width, new_height,
                                   Bitmap.BitsPerPixel ) ;
          
                  /* Allocate storage to hold an image in a BitMap handle.       */
                  if ( (ret = L_AllocateBitmap( &NewBitmap,
                                             TYPE_NOCONV   )) == SUCCESS )
                   {
                   /* Resizes image currently in BitMap handle, to the output BitMap
                      handle. Since the new BitMap structure contains the new width
                      and height just call L_ResizeBitmap()                      */
                    if ( (ret = L_ResizeBitmap( &Bitmap, &NewBitmap ))
                                                                  == SUCCESS )
                     {
                      L_FreeBitmap( &Bitmap );    /* Free the old BitMap */
                      L_CopyBitmapHandle( &Bitmap, &NewBitmap ); /* Copy the old BitMap handle
                                                                    to the new one */
                      printf("BitMap resized in NewBitMap.");
                     }
                    else
                     {
                      printf("Error: %d Resizing the BitMap. Press any key to continue.", ret);
                      putch(7);
                     }
                   }
                  else
                   {
                    printf("Error: %d Alloctating a new bitmap for resizing. Press any key to continue.", ret);
                    putch(7);
                  }
         break;

        case 16: /* Rotate an image in a bitmap */
                 if ( alloc_bitmap == 0 )
                  {
                   printf("Error: No image in the BitMap allocated. Press any key to continue.");
                   putch(7);
                   break;
                  }
                 printf("Rotate by (degrees):");
                 getint( &xpos ) ;
                 printf("Resize? (0=No, 1=Yes):");
                 getint( &output_format ) ;
                 L_RotateBitmap( &Bitmap, xpos, output_format ) ;
                 printf("Bitmap Rotated! Press any key to continue.\n");
        break;

         case 17: /* Case optimize an image for 256 colors */
                  /* Make sure BitMap is already being used and is filled with image data */
                  if ( alloc_bitmap == 0 )
                   {
                    printf("Error: No image in the BitMap allocated. Press any key to continue.");
                    putch(7);
                    break;
                   }
                   /* Make sure that the image needs to be optimized
                      to 256 colors */
                   if (Bitmap.BitsPerPixel >= 16)
                    {
                    /* Selecting the best 256 colors to represent the image.
                       This function will allocate and put the 256 color image
                       in NewBitmap */
                     if ( (ret = L_OptimizeBitmap ( &Bitmap, &NewBitmap, NO_DITHERING, 256 )) == SUCCESS)
                      {
                       /* Free the storage for the old BitMap */
                       L_FreeBitmap( &Bitmap );    
                       /* Copy the old BitMap handle to the new one */
                       L_CopyBitmapHandle( &Bitmap, &NewBitmap );
                       printf("Bitmap optimized.  Press any key to continue.");
                      }
                     else
                      {
                       printf("Error: %d Optimizing the BitMap.  Press any key to continue.", ret);
                       putch(7);
                      }
                    }
                   else
                    { /* You cannot optimize 4 or 8 bits/pixel image */
                     printf("Cannot optimize a %d bits/pixel BitMap. Press any key to continue.",Bitmap.BitsPerPixel);
                     putch(7);
                    }
         break;


         case 18: /* Case clear a BitMap */
                  /* Make sure BitMap is already being used and is filled with image data */
                  if ( alloc_bitmap == 0 )
                   {
                    printf("Error: No image in BitMap allocated. Press any key to continue.");
                    putch(7);
                    break;
                   }
                   /* Clear the BitMap and fill it with zeros */
                   if ( (ret = L_ClearBitmap( &Bitmap )) == SUCCESS )
                    {
                     printf("BitMap cleared and filled with zeros OK. Press any key to continue.");
                    }
                   else
                    {
                     printf("Error: %d Clearing the BitMap. Press any key to continue.", ret);
                     putch(7);
                    }
         break;

         case 19: /* Case change BitMap bosition */
                  /* Make sure BitMap is already being used and is filled with image data */
                  if ( alloc_bitmap == 0 )
                   {
                    printf("Error: No image in BitMap allocated. Press any key to continue.");
                    putch(7);
                    break;
                   }
                   printf("New BitMap X position: ");
                   getint(&xpos);
                   printf("New BitMap Y position: ");
                   getint(&ypos);
                   /* Set new X, Y positions in a BitMap handle.
                      The X and Y positions will be used as the starting
                      offset when displaying this BitMap */
                   L_SetBitmapPos( &Bitmap, xpos, ypos);
                   printf("Set BitMap position OK.  Press any key to continue.");
         break;

         case 20: /* Case view BitMap to TARGA */
                  /* Is a TARGA installed OK? */
                 if (TARGA_FLAG)
                  {
                   /* Make sure BitMap is already being used and is filled with image data */
                   if ( alloc_bitmap == 0 )
                    {
                     printf("Error: No image in the BitMap allocated. Press any key to continue.");
                     putch(7);
                     break;
                    }
                    /* View the BitMap to the TARGA graphics adapter */
                    if ( (ret = L_ViewBitmapTarga( &Bitmap, 0, 0 )) == SUCCESS )
                     {
                      printf("BitMap viewed to TARGA successfully.  Press any key to continue.");
                     }
                    else
                     {
                      printf("Error: %d viewing to the TARGA screen.  Press any key to continue.", ret);
                      putch(7);
                     }
                  }
                 else
                  {
                   printf("Error: TARGA board initialization.  Press any key to continue.");
                   putch(7);
                  }
         break;

         case 21: /* Case view a BitMap on the VGA/SuperVGA screen */
                  /* Make sure BitMap is already being used and is filled with image data */
                  if ( alloc_bitmap == 0 )
                   {
                    printf("Error: No image in the BitMap allocated. Press any key to continue.");
                    putch(7);
                    break;
                   }
                   /* Make sure that the image has no more than 256 colors */
                     printf("New viewing screen width 0 for no resize: ");
                     getint(&new_width);
                     printf("New viewing screen height 0 for no resize: ");
                     getint(&new_height);
                     /* View the BitMap with the new width and height.
                        This will display the image with the new width and height
                        but will not change the original BitMap's width and height */
                    if( L_ViewBitmapScreen(&Bitmap,new_width,new_height) == ERROR_NOT_256_COLOR )
                       {
                       ClearTheScreen();
                       printf("This is a %d bit/pixel image containing more that 256 colors.\n", Bitmap.BitsPerPixel);
                       printf("A VGA/SuperVGA card can only handle up to 256 colors.\n");
                       printf("To be able to view the image you must first optimize the BitMap.\n");
                       printf("This will find the best 256 colors to represent this image.\n\n");                   
                       printf("\nPress any key to continue.");
                       putch(7);
                       }
         break;

         case 22: /* Case view TGA file to TARGA screen */
                  /* Is a TARGA installed OK? */
                  if (TARGA_FLAG)
                   {
                    printf("Input file name: ");
                    getstring(input_filename);
                    printf("Starting X display position, or 0 for normal position: ");
                    getint(&xpos);
                    printf("Starting Y display position, or 0 for normal position: ");
                    getint(&ypos);
                    printf("Display width, or 0 for current Width in the file: ");
                    getint(&width);
                    printf("Display height, or 0 for current Height in the file: ");
                    getint(&height);
                    if ( (ret = L_ShowTGATarga(input_filename,width,height,xpos, ypos)) ==SUCCESS)
                     {
                      printf("%s successfully loaded to TARGA. Press any key to continue.",input_filename);
                     }  
                    else
                     {
                      printf("Error: %d Viewing to the TARGA. Press any key to continue.", ret);
                      putch(7);
                     }
                  }
                 else
                  {
                   printf("Error: TARGA board initialization.  Press any key to continue.");
                   putch(7);
                  }
         break;

         case 23: /* Case view TGA file to VGA screen */
                  printf("Input file name: ");
                  getstring(input_filename);
                  /* See if the file is a valid format and fill the FileInfo structure */
                  if (L_FileInfo(input_filename, &FileInfo) == SUCCESS)
                   {
                    if (FileInfo.Format == FILE_TGA)
                     {
                        {
                         printf("Starting X display position, or 0 for normal position: ");
                         getint(&xpos);
                         printf("Starting Y display position, or 0 for normal position: ");
                         getint(&ypos);
                         printf("Display width, or 0 for current Width in the file: ");
                         getint(&width);
                         printf("Display height, or 0 for current Height in the file: ");
                         getint(&height);
                         if ( (ret = L_ShowTGAScreen(input_filename,width,height,
                                                               xpos, ypos)) == SUCCESS)
                          {
                            /* Displayed to VGA OK */
                            ;
                          }
                         else
                          {
                          if( ret == ERROR_NOT_256_COLOR )
                             {/* If the TGA file a 16, 24, or 32 bits/pixel file
                                 we have to load into a BitMap then optimize the BitMap and
                                 then view the BitMap */
                              ClearTheScreen();
                              printf("\n%s is a %d bit/pixel image containing more that 256 colors.\n", input_filename,FileInfo.BitsPerPixel);
                              printf("A VGA/SuperVGA card can only handle up to 256 colors.\n");
                              printf("To be able to view this file you must load the file to \n");
                              printf("the BitMap. Then run optimize the BitMap.\n");
                              printf("This will find the best 256 colors to represent the image.");
                              printf("Afterwards, you can view the BitMap to the screen.\n\n");
                              printf("Press any key to continue.");
                              putch(7);
                             }
                          else
                             {
                             printf("Error: %d viewing VGA. Press any key to continue.", ret);
                             putch(7);
                             }
                          }
                        }
                     }  
                    else
                     {
                      printf("Error: %s invalid TGA file format. Press any key to continue.", input_filename);
                      putch(7);
                     }
                   }
                  else
                   {
                      printf("Error: %s not a supported file format. Press any key to continue.", input_filename);
                      putch(7);
                   }
         break;

         case 24: /* Case view PCX file to TARGA */
                  /* Is a TARGA installed OK */
                  if (TARGA_FLAG)
                   {
                    printf("Input file name: ");
                    getstring(input_filename);
                    printf("Starting X display position, or 0 for normal position: ");
                    getint(&xpos);
                    printf("Starting Y display position, or 0 for normal position: ");
                    getint(&ypos);
                    printf("Display width, or 0 for current Width in the file: ");
                    getint(&width);
                    printf("Display height, or 0 for current Height in the file: ");
                    getint(&height);
                    if ( (ret = L_ShowPCXTarga(input_filename,width,
                                                      height,xpos, ypos)) ==SUCCESS)
                     {
                      printf("%s successfully loaded to TARGA. Press any key to continue.",input_filename);
                     }
                    else
                     {
                      printf("Error: %d viewing to the TARGA. Press any key to continue.", ret);
                      putch(7);
                     }
                  }
                 else
                  {
                   printf("Error: TARGA board initialization.  Press any key to continue.");
                   putch(7);
                  }
         break;

         case 25: /* Case view PCX file to VGA */
                  printf("Input file name: ");
                  getstring(input_filename);
                  printf("Starting X display position, or 0 for normal position: ");
                  getint(&xpos);
                  printf("Starting Y display position, or 0 for normal position: ");
                  getint(&ypos);
                  printf("Display width, or 0 for current Width in the file: ");
                  getint(&width);
                  printf("Display height, or 0 for current Height in the file: ");
                  getint(&height);
                  if ( (ret = L_ShowPCXScreen(input_filename,width,height,
                                                            xpos, ypos)) ==SUCCESS)
                   {
                    /* displayed to VGA OK */
                    ;
                   }
                  else
                   {
                    printf("Error: %d viewing to VGA. Press any key to continue.", ret);
                    putch(7);
                   }
         break;

         case 26: /* Case view GIF file to TARGA */
                  /* Is a TARGA installed OK */
                  if (TARGA_FLAG)
                   {
                    printf("Input file name: ");
                    getstring(input_filename);
                    printf("Starting X display position, or 0 for normal position: ");
                    getint(&xpos);
                    printf("Starting Y display position, or 0 for normal position: ");
                    getint(&ypos);
                    printf("Display width, or 0 for current Width in the file: ");
                    getint(&width);
                    printf("Display height, or 0 for current Height in the file: ");
                    getint(&height);
                    if ( (ret = L_ShowGIFTarga(input_filename,width,height,
                                                            xpos, ypos)) ==SUCCESS)
                     {
                      printf("%s successfully loaded to TARGA. Press any key to continue.",input_filename);
                     }
                    else
                     {
                      printf("Error: %d viewing to TARGA. Press any key to continue.", ret);
                      putch(7);
                     }
                   }
                  else
                   {
                    printf("Error: TARGA board initialization.  Press any key to continue.");
                    putch(7);
                   }
         break;

        case 27: /* Case view GIF to VGA */
                 printf("Input file name: ");
                 getstring(input_filename);
                 printf("Starting X display position, or 0 for normal position: ");
                 getint(&xpos);
                 printf("Starting Y display position, or 0 for normal position: ");
                 getint(&ypos);
                 printf("Display width, or 0 for current Width in the file: ");
                 getint(&width);
                 printf("Display height, or 0 for current Height in the file: ");
                 getint(&height);
                 if ( (ret = L_ShowGIFScreen(input_filename,width,height,
                                                         xpos, ypos)) ==SUCCESS)
                  {
                   /* displayed to VGA OK */
                   ;
                  }
                 else
                  {
                   printf("Error: %d viewing VGA. Press any key to continue.", ret);
                   putch(7);
                  }
        break;

        case 28: /* Case view TIF to TARGA */
                  /* Is a TARGA installed OK */
                  if (TARGA_FLAG)
                   {
                    printf("Input file name: ");
                    getstring(input_filename);
                    printf("Starting X display position, or 0 for normal position: ");
                    getint(&xpos);
                    printf("Starting Y display position, or 0 for normal position: ");
                    getint(&ypos);
                    printf("Display width, or 0 for current Width in the file: ");
                    getint(&width);
                    printf("Display height, or 0 for current Height in the file: ");
                    getint(&height);
                    if ( (ret = L_ShowTIFTarga(input_filename,width,height,
                                                            xpos, ypos)) ==SUCCESS)
                     {
                      printf("%s successfully loaded to TARGA. Press any key to continue.",input_filename);
                     }
                    else
                     {
                      printf("Error: %d viewing to the TARGA. Press any key to continue.", ret);
                      putch(7);
                     }
                   }
                  else
                   {
                    printf("Error: TARGA board initialization.  Press any key to continue.");
                    putch(7);
                   }
        break;

        case 29: /* Case view TIF to VGA */
                 printf("Input file name: ");
                 getstring(input_filename);
                 /* See if the file is a valid format and fill the FileInfo structure */
                  if (L_FileInfo(input_filename, &FileInfo) == SUCCESS)
                   {
                    if (FileInfo.Format == FILE_TIF)
                     {
                        {
                         printf("Starting X display position, or 0 for normal position: ");
                         getint(&xpos);
                         printf("Starting Y display position, or 0 for normal position: ");
                         getint(&ypos);
                         printf("Display width, or 0 for current Width in the file: ");
                         getint(&width);
                         printf("Display height, or 0 for current Height in the file: ");
                         getint(&height);
                         if ( (ret = L_ShowTIFScreen(input_filename,width,height,
                                                               xpos, ypos)) ==SUCCESS)
                          {
                            /* Displayed to VGA OK */
                            ;
                          }
                         else
                          {
                          if( ret == ERROR_NOT_256_COLOR )
                             {/* If the TGA file a 16, 24, or 32 bits/pixel file
                                 we have to load into a BitMap then optimize the BitMap and
                                 then view the BitMap */
                              ClearTheScreen();
                              printf("\n%s is a %d bit/pixel image containing more that 256 colors.\n", input_filename,FileInfo.BitsPerPixel);
                              printf("A VGA/SuperVGA card can only handle up to 256 colors.\n");
                              printf("To be able to view this file you must load the file to \n");
                              printf("the BitMap. Then run optimize the BitMap.\n");
                              printf("This will find the best 256 colors to represent the image.");
                              printf("Afterwards, you can view the BitMap to the screen.\n\n");
                              printf("Press any key to continue.");
                              putch(7);
                             }
                          else
                             {
                             printf("Error: %d viewing VGA. Press any key to continue.", ret);
                             putch(7);
                             }
                          }
                        }
                     }  
                    else
                     {
                      printf("Error: %s Invalid TIF file format. Press any key to continue.",input_filename);
                      putch(7);
                     }
                   }
                  else
                   {
                      printf("Error: %s not a supported file format. Press any key to continue.", input_filename);
                     putch(7);
                   }
        break;

        case 30: /* Case view BMP to TARGA */
                  /* Is a TARGA installed OK */
                  if (TARGA_FLAG)
                   {
                    printf("Input file name: ");
                    getstring(input_filename);
                    printf("Starting X display position, or 0 for normal position: ");
                    getint(&xpos);
                    printf("Starting Y display position, or 0 for normal position: ");
                    getint(&ypos);
                    printf("Display width, or 0 for current Width in the file: ");
                    getint(&width);
                    printf("Display height, or 0 for current Heigth in the file: ");
                    getint(&height);
                    if ( (ret = L_ShowBMPTarga(input_filename,width,height,
                                                            xpos, ypos)) ==SUCCESS)
                     {
                      printf("%s successfully loaded to TARGA. Press any key to continue.",input_filename);
                     }
                    else
                     {
                      printf("Error: %d viewing to the TARGA. Press any key to continue.", ret);
                      putch(7);
                     }
                   }
                  else
                   {
                    printf("Error: TARGA board initialization. Press any key to continue.");
                    putch(7);
                   }
        break;

        case 31: /* Case view BMP to VGA */
                 printf("Input file name: ");
                 getstring(input_filename);
                 /* See if the file is a valid format and fill the FileInfo structure */
                  if (L_FileInfo(input_filename, &FileInfo) == SUCCESS)
                   {
                    if (FileInfo.Format == FILE_BMP)
                     {
                        {
                         printf("Starting X display position, or 0 for normal position: ");
                         getint(&xpos);
                         printf("Starting Y display position, or 0 for normal position: ");
                         getint(&ypos);
                         printf("Display width, or 0 for current Width in the file: ");
                         getint(&width);
                         printf("Display height, or 0 for current Height in the file: ");
                         getint(&height);
                         if ( (ret = L_ShowBMPScreen(input_filename,width,height,
                                                               xpos, ypos)) ==SUCCESS)
                          {
                            /* Displayed to VGA OK */
                            ;
                          }
                         else
                          {
                          if( ret == ERROR_NOT_256_COLOR )
                             {/* If the TGA file a 16, 24, or 32 bits/pixel file
                                 we have to load into a BitMap then optimize the BitMap and
                                 then view the BitMap */
                              ClearTheScreen();
                              printf("\n%s is a %d bit/pixel image containing more that 256 colors.\n", input_filename,FileInfo.BitsPerPixel);
                              printf("A VGA/SuperVGA card can only handle up to 256 colors.\n");
                              printf("To be able to view this file you must load the file to \n");
                              printf("the BitMap. Then run optimize the BitMap.\n");
                              printf("This will find the best 256 colors to represent the image.");
                              printf("Afterwards, you can view the BitMap to the screen.\n\n");
                              printf("Press any key to continue.");
                              putch(7);
                             }
                          else
                             {
                             printf("Error: %d viewing VGA. Press any key to continue.", ret);
                             putch(7);
                             }
                          }
                        }
                     }  
                    else
                     {
                      printf("Error: %s invalid BMP file format. Press any key to continue.", input_filename);
                      putch(7);
                     }
                   }
                  else
                   {
                      printf("Error: %s Not a supported file format. Press any key to continue.", input_filename);
                      putch(7);
                   }
        break;

        case 32: /* Case decompress or display a compressed file to TARGA screen */
                 /* Is a TARGA installed OK */
                 if (TARGA_FLAG)
                  {
                   printf("Input file name: ");
                   getstring(input_filename);
                   printf("Starting X display position, or 0 for normal position: ");
                   getint(&xpos);
                   printf("Starting Y display position, or 0 for normal position: ");
                   getint(&ypos);
                   if ( (ret = L_DecompressTARGAScreen(input_filename,
                                                            xpos, ypos)) == SUCCESS)
                    {
                     printf("Decompress %s to TARGA screen. Press any key to continue.",input_filename );
                    }
                   else
                    {
                     printf("Error: %d Decompressing to TARGA. Press any key to continue.", ret);
                     putch(7);
                    }
                  }
                else
                 {
                  printf("Error: Cannot initialize TARGA board.  Press any key to continue.");
                  putch(7);
                 }
        break;

        case 33: /* Decompress a compressed file to the VGA screen */
                 printf("Input file name: ");
                 getstring(input_filename);
                 printf("Starting X display position, or 0 for normal position: ");
                 getint(&xpos);
                 printf("Starting Y display position, or 0 for normal position: ");                 getint(&ypos);
                if ( (ret = L_DecompressVGAScreen(input_filename, xpos, ypos)) == SUCCESS)
                 {
                  /* Decompression to VGA was OK */
                  ;
                 }
                else
                 {
                  printf("Error: %d Decompressing to VGA. Press any key to continue.", ret);
                  putch(7);
                 }
        break;

        case 34: /* Case compress TGA file */
                 printf("Input file name: ");
                 getstring(input_filename);
                 printf("Output file name: ");
                 getstring(output_filename);
                 printf("Compress format 0 - LEAD, 1 - JFIF, 2 - JTIF, 3 - LEAD1JFIF, 4 - LEAD1JTIF,\n");
                 printf("5 - LEAD2JFIF, 6 - LEAD2JTF: ");
                 getint(&compress_format);
                 printf("Qfactor 1 to 255 or LEAD defined PQ1, PQ2, QFS, QMS, QS, SQS, SQT, MCQ, MC ");
                 getstring(compress_qfactor);
                 if (compress_format != 0)
                  save_palette = 0;
                 else
                  {
                   printf("Save VGA palette? 0 - No, 1 - YES: ");
                   getint(&save_palette);
                   while( (save_palette != 0) && (save_palette != 1) )
                    {
                     printf("Save VGA palette? 0 - No, 1 - YES: ");
                     getint(&save_palette);
                    }
                  }
                strupr(compress_qfactor);
                if ( (qfactor = get_qfactor(compress_qfactor)) == ERROR_QFACTOR)
                 {
                  printf("Error: Bad qfactor. Press any key to continue.");
                  putch(7);
                  break;
                 }
                if ( (ret = L_CompressTGA(input_filename, output_filename, compress_format,
                                        qfactor, save_palette)) == SUCCESS)
                 {
                  printf("File: %s compressed to %s. Press any key to continue.",input_filename,output_filename);
                 }
                else
                 {
                  printf("Error: %d compressing %s. Press any key to continue.", ret,input_filename);
                  putch(7);
                 }
        break;

        case 35: /* Case decompress to TGA file */
                 printf("Input file name: ");
                 getstring(input_filename);
                 printf("Output file name: ");
                 getstring(output_filename);
                 printf("Output format 0 - TGA8, 1 - TGA16, 2 - TGA24, 3 - TGA32: ");
                 getint(&output_format);
                 if ( (ret = L_DecompressTGA(input_filename, output_filename, output_format))
                                           == SUCCESS)
                  {
                   printf("File: %s Decompressed to %s (TGA). Press any key to continue. ",input_filename,output_filename);
                  }
                 else
                  {
                   printf("Error: %d Decompressing to TGA. Press any key to continue. ", ret);
                   putch(7);
                  }
        break;

        case 36: /* Case compress PCX file */
                 printf("Input file name: ");
                 getstring(input_filename);
                 printf("Output file name: ");
                 getstring(output_filename);
                 printf("Compress format 0 - LEAD, 1 - JFIF, 2 - JTIF, 3 - LEAD1JFIF, 4 - LEAD1JTIF,\n");
                 printf("5 - LEAD2JFIF, 6 - LEAD2JTF: ");
                 getint(&compress_format);
                 printf("Qfactor 1 to 255 or LEAD defined PQ1, PQ2, QFS, QMS, QS, SQS, SQT, MCQ, MC ");
                 getstring(compress_qfactor);
                 if (compress_format != 0)
                  save_palette = 0;
                 else
                  {
                   printf("Save VGA palette? 0 - No, 1 - YES: ");
                   getint(&save_palette);
                   while( (save_palette != 0) && (save_palette != 1) )
                    {
                     printf("Save VGA palette? 0 - No, 1 - YES: ");
                     getint(&save_palette);
                    }
                  }
                 strupr(compress_qfactor);
                 if ( (qfactor = get_qfactor(compress_qfactor)) == ERROR_QFACTOR)
                  {
                   printf("Error: Bad qfactor.");
                   break;
                  }
                 if ( (ret = L_CompressPCX(input_filename, output_filename, compress_format,
                                         qfactor, save_palette)) == SUCCESS)
                  {
                   printf("File: %s compressed to %s. Press any key to continue.",input_filename,output_filename);
                  }
                 else
                  {
                   printf("Error: %d compressing %s. Press any key to continue.", ret,input_filename);
                   putch(7);
                  }
        break;
   
        case 37: /* Case decompress to PCX file*/
                 printf("Input file name: ");
                 getstring(input_filename);
                 printf("Output file name: ");
                 getstring(output_filename);
                 if ( (ret = L_DecompressPCX(input_filename, output_filename, PCX8))
                      == SUCCESS)
                  {
                   printf("%s Decompressed to %s (PCX). Press any key to continue. ",input_filename,output_filename);
                  }
                 else
                  {
                   printf("Error: %d Decompressing to PCX. Press any key to continue. ", ret);
                   putch(7);
                  }
        break;

        case 38: /* Case compress GIF file */
                 printf("Input file name: ");
                 getstring(input_filename);
                 printf("Output file name: ");
                 getstring(output_filename);
                 printf("Compress format 0 - LEAD, 1 - JFIF, 2 - JTIF, 3 - LEAD1JFIF, 4 - LEAD1JTIF,\n");
                 printf("5 - LEAD2JFIF, 6 - LEAD2JTF: ");
                 getint(&compress_format);
                 printf("Qfactor 1 to 255 or LEAD defined PQ1, PQ2, QFS, QMS, QS, SQS, SQT, MCQ, MC ");
                 getstring(compress_qfactor);
                 if (compress_format != 0)
                   save_palette = 0;
                 else
                  {
                   printf("Save VGA palette? 0 - No, 1 - YES: ");
                   getint(&save_palette);
                   while( (save_palette != 0) && (save_palette != 1) )
                    {
                     printf("Save VGA palette? 0 - No, 1 - YES: ");
                     getint(&save_palette);
                    }
                  }
                 strupr(compress_qfactor);
                 if ( (qfactor = get_qfactor(compress_qfactor)) == ERROR_QFACTOR)
                  {
                   printf("Error: Bad qfactor. Press any key to continue.");
                   putch(7);
                   break;
                  }
                 if ( (ret = L_CompressGIF(input_filename, output_filename, compress_format,
                                         qfactor, save_palette)) == SUCCESS)
                  {
                   printf("File: %s compressed to %s. Press any key to continue.",input_filename,output_filename);
                  }
                 else
                  {
                   printf("Error: %d compressing %s. Press any key to continue.", ret,input_filename);
                   putch(7);
                  }
        break;
       
        case 39: /* Case decompress to GIF file */
                 printf("Input file name: ");
                 getstring(input_filename);
                 printf("Output file name: ");
                 getstring(output_filename);
                 if ( (ret = L_DecompressGIF(input_filename, output_filename, GIF8))
                            == SUCCESS)
                  {
                   printf("File: %s decompressed to %s (GIF). Press any key to continue. ",input_filename,output_filename);
                  }
                 else
                  {
                   printf("Error: %d Decompressing to GIF. Press any key to continue. ", ret);
                   putch(7);
                  }
        break;

        case 40: /* Case compress TIF file */
                 printf("Input file name: ");
                 getstring(input_filename);
                 printf("Output file name: ");
                 getstring(output_filename);
                 printf("Compress format 0 - LEAD, 1 - JFIF, 2 - JTIF, 3 - LEAD1JFIF, 4 - LEAD1JTIF,\n");
                 printf("5 - LEAD2JFIF, 6 - LEAD2JTF: ");
                 getint(&compress_format);
                 printf("Qfactor 1 to 255 or LEAD defined PQ1, PQ2, QFS, QMS, QS, SQS, SQT, MCQ, MC ");
                 getstring(compress_qfactor);
                 if (compress_format != 0)
                   save_palette = 0;
                 else
                  {
                   printf("Save VGA palette? 0 - No, 1 - YES: ");
                   getint(&save_palette);
                   while( (save_palette != 0) && (save_palette != 1) )
                    {
                     printf("Save VGA palette? 0 - No, 1 - YES: ");
                     getint(&save_palette);
                    }
                  }
                 strupr(compress_qfactor);
                 if ( (qfactor = get_qfactor(compress_qfactor)) == ERROR_QFACTOR)
                  {
                   printf("Error: Bad qfactor. Press any key to continue.");
                   break;
                  }
                 if ( (ret = L_CompressTIF(input_filename, output_filename, compress_format,
                                         qfactor, save_palette)) == SUCCESS)
                  {
                   printf("File %s compressed to %s. Press any key to continue.",input_filename,output_filename);
                  }
                 else
                  {
                   printf("Error: %d compressing %s. Press any key to continue.", ret,input_filename);
                   putch(7);
                  }
        break;

        case 41: /* Case decompress to a TIF file */
                 printf("Input file name: ");
                 getstring(input_filename);
                 printf("Output file name: ");
                 getstring(output_filename);
                 printf("Output format 7 - TIF8, 8 - TIF24: ");
                 getint(&output_format);
                 if ( (ret = L_DecompressTIF(input_filename, output_filename, output_format))
                            == SUCCESS)
                  {
                   printf("File: %s Decompressed to %s (TIF). Press any key to continue. ",input_filename,output_filename);
                  }
                 else
                  {
                   printf("Error: %d Decompressiing to TIF. Press any key to continue. ", ret);
                   putch(7);
                  }
        break;

        case 42: /* Case compress a BMP file */
                 printf("Input file name: ");
                 getstring(input_filename);
                 printf("Output file name: ");
                 getstring(output_filename);
                 printf("Compress format 0 - LEAD, 1 - JFIF, 2 - JTIF, 3 - LEAD1JFIF, 4 - LEAD1JTIF,\n");
                 printf("5 - LEAD2JFIF, 6 - LEAD2JTF: ");
                 getint(&compress_format);
                 printf("Qfactor 1 to 255 or LEAD defined PQ1, PQ2, QFS, QMS, QS, SQS, SQT, MCQ, MC ");
                 getstring(compress_qfactor);
                 if (compress_format != 0)
                   save_palette = 0;
                 else
                  {
                   printf("Save VGA palette? 0 - No, 1 - YES: ");
                   getint(&save_palette);
                   while( (save_palette != 0) && (save_palette != 1) )
                    {
                     printf("Save VGA palette? te? 0 - No, 1 - YES: ");
                     getint(&save_palette);
                    }
                  }
                 strupr(compress_qfactor);
                 if ( (qfactor = get_qfactor(compress_qfactor)) == ERROR_QFACTOR)
                  {
                   printf("Error: Bad qfactor. Press any key to continue.");
                   break;
                  }
                 if ( (ret = L_CompressBMP(input_filename, output_filename, compress_format,
                                         qfactor, save_palette)) == SUCCESS)
                  {
                   printf("File: %s compressed to %s. Press any key to continue.",input_filename,output_filename);
                  }
                 else
                  {
                   printf("Error: %d compressing %s. Press any key to continue.", ret,input_filename);
                   putch(7);
                  }
        break;

        case 43: /* Case decompress to BMP file */
                 printf("Input file name: ");
                 getstring(input_filename);
                 printf("Output file name: ");
                 getstring(output_filename);
                 printf("Output format 1 -BMP4, 2 -BMP8, 3 -BMP24, 4 -PM4, 5 -PM8, 6 -PM24: ");
                 getint(&output_format);
                 if(output_format==1)
                    output_format=BMP4;
                 else if(output_format==2)
                    output_format=BMP8;
                 else if(output_format==3)
                    output_format=BMP24;
                 else if(output_format==4)
                    output_format=PM4;
                 else if(output_format==5)
                    output_format=BMP8;
                 else if(output_format==6)
                    output_format=BMP24;
                 else
                   {
                      printf("%d not a valid option",output_format);
                      getch();
                      break;
                   }


                 if ( (ret = L_DecompressBMP(input_filename, output_filename, output_format))
                           == SUCCESS)
                  {
                   printf("File: %s decompressed to %s (BMP). Press any key to continue. ",input_filename,output_filename);
                  }
                 else
                  {
                   printf("Error: %d Decompressing to BMP. Press any key to continue. ", ret);
                   putch(7);
                  }
        break;

        case 44: /* Case compress TARGA screen */
                 /* Is a TARGA installed OK */
                 if (TARGA_FLAG)
                  {
                   printf("Output file name: ");
                   getstring(output_filename);
                   printf("Compress format 0 - LEAD, 1 - JFIF, 2 - JTIF, 3 - LEAD1JFIF, 4 - LEAD1JTIF,\n");
                   printf("5 - LEAD2JFIF, 6 - LEAD2JTF: ");
                   getint(&compress_format);
                   printf("Qfactor 1 to 255 or LEAD defined PQ1, PQ2, QFS, QMS, QS, SQS, SQT, MCQ, MC ");
                   getstring(compress_qfactor);
                   strupr(compress_qfactor);
                   if ( (qfactor = get_qfactor(compress_qfactor)) == ERROR_QFACTOR)
                    {
                     printf("Error: Bad qfactor. Press any key to continue.");
                     putch(7);
                     break;
                    }
                   if ( (ret = L_CompressTarga(output_filename, compress_format,
                                               qfactor )) == SUCCESS )
                    {
                     printf("File: %s TARGA screen compressed. Press any key to continue.",output_filename);
                    }
                   else
                    {
                     printf("Error: %d TARGA screen compression.", ret);
                     putch(7);
                    }
                  }
                 else
                  {
                   printf("Error: Cannot initialize TARGA board.  Press any key to continue.");
                   putch(7);
                  }
        break;

        case 45: /* Gase get file info */
                 printf("Input file name: ");
                 getstring(input_filename);
                 if (L_FileInfo(input_filename, &FileInfo) != SUCCESS)
                  {
                   printf("Error: %s Unrecognized file format.  Press any key to continue.",input_filename);
                   putch(7);
                   break;
                  }
                  ClearTheScreen();
                  if (FileInfo.Format == FILE_PCX)
                   {
                    printf("File: %s is a PCX file format\n",input_filename);
                    printf("Width      = %d\n",FileInfo.Width);
                    printf("Height     = %d\n",FileInfo.Height);
                    printf("Bits/Pixel = %d\n",FileInfo.BitsPerPixel);
                   }
                  else
                    if (FileInfo.Format == FILE_GIF)
                  {    
                    printf("File: %s is a GIF file format\n",input_filename);
                    printf("Width      = %d\n",FileInfo.Width);
                    printf("Height     = %d\n",FileInfo.Height);
                    printf("Bits/Pixel = %d\n",FileInfo.BitsPerPixel);

                  }
                 else
                  if (FileInfo.Format == FILE_TIF)
                  {
                    printf("File: %s is a TIF file format\n",input_filename);
                    printf("Width      = %d\n",FileInfo.Width);
                    printf("Height     = %d\n",FileInfo.Height);
                    printf("Bits/Pixel = %d\n",FileInfo.BitsPerPixel);

                  }
                 else
                  if (FileInfo.Format == FILE_TGA)
                   {
                    printf("File: %s is a TGA file format\n",input_filename);
                    printf("Width      = %d\n",FileInfo.Width);
                    printf("Height     = %d\n",FileInfo.Height);
                    printf("Bits/Pixel = %d\n",FileInfo.BitsPerPixel);
                   }
                  else
                   if (FileInfo.Format == FILE_CMP)
                  {
                    printf("File: %s is a LEAD compressed file format\n",input_filename);
                    printf("Width      = %d\n",FileInfo.Width);
                    printf("Height     = %d\n",FileInfo.Height);
                    printf("Bits/Pixel = %d\n",FileInfo.BitsPerPixel);
                   }
                  else
                   if (FileInfo.Format == FILE_BMP)
                  {
                    printf("File: %s is a Windows BMP file format\n",input_filename);
                    printf("Width      = %d\n",FileInfo.Width);
                    printf("Height     = %d\n",FileInfo.Height);
                    printf("Bits/Pixel = %d\n",FileInfo.BitsPerPixel);
                  }
                  else
                   if (FileInfo.Format == FILE_OS2)
                  {
                    printf("File: %s is an OS2 BMP file format\n",input_filename);
                    printf("Width      = %d\n",FileInfo.Width);
                    printf("Height     = %d\n",FileInfo.Height);
                    printf("Bits/Pixel = %d\n",FileInfo.BitsPerPixel);
                  }

                 else
                  if (FileInfo.Format == FILE_JFIF)
                  {
                    printf("File: %s is a JPEG File Interchange Format (JFIF)\n",input_filename);
                    printf("Width      = %d\n",FileInfo.Width);
                    printf("Height     = %d\n",FileInfo.Height);
                    printf("Bits/Pixel = %d\n",FileInfo.BitsPerPixel);
                  }
                 else
                  if (FileInfo.Format == FILE_JTIF)
                   {
                    printf("File: %s is a JPEG TIF file format (JTIF)\n",input_filename);
                    printf("Width      = %d\n",FileInfo.Width);
                    printf("Height     = %d\n",FileInfo.Height);
                    printf("Bits/Pixel = %d\n",FileInfo.BitsPerPixel);
                   }
                 printf("\n\nPress any key to continue.");
        break;

        case 46: /* Case convert a file */
                 printf("Input file name: ");
                 getstring(input_filename);
                 if (L_FileInfo(input_filename, &FileInfo) != SUCCESS)  
                  {
                   printf("Error: %s Unknown file format.  Press any key to continue.",input_filename);
                   putch(7);
                   break;
                  }
                 input_format = FileInfo.Format;
                 printf("Output file name: ");
                 getstring(output_filename);
                 printf("Output file format 1 -PCX, 2 -GIF, 3 -TIF, 4 -TGA, 6 -Windows BMP, 14 -OS2 BMP : ");
                 getint(&output_format);
                 if ( (output_format != FILE_PCX) && (output_format != FILE_GIF)
                     && (output_format != FILE_TIF) && (output_format != FILE_TGA)
                     && (output_format != FILE_BMP)
                     && (output_format != FILE_OS2) )
                  {
                   printf("Error: Unknown file format. Press any key to continue.");
                   putch(7);
                   break;
                  }
                 printf("New width or 0 for same as original: ");
                 getint(&new_width);
                 printf("New height or 0 for same as original: ");
                 getint(&new_height);
                 printf("BitsPerPixel: ");
                 getint(&BitsPerPixel);
                 if (output_format == FILE_PCX)
                  {
                   if ( (BitsPerPixel != 1) && (BitsPerPixel != 4) && (BitsPerPixel != 8) )
                    {
                     printf("Error: PCX can only be 1, 4, or 8-Bits/pixel. Press any key to continue.");
                     putch(7);
                     break;
                    }
                  }
                 else
                  if (output_format == FILE_GIF)
                   {
                    if ( (BitsPerPixel != 8) )
                     {
                      printf("Error: GIF can only be 8-Bits/pixel. Press any key to continue.");
                      putch(7);
                      break;
                     }
                   }
                  else
                   if (output_format == FILE_TIF)
                    {
                     if ( (BitsPerPixel != 1) && (BitsPerPixel != 8)
                         && (BitsPerPixel != 24) )
                      {
                       printf("Error: TIF can only be 1, 8, or 24-Bits/pixel. Press any key to continue.");
                       putch(7);
                       break;
                      }
                    }
                   else
                    if (output_format == FILE_TGA)
                     {
                      if ( (BitsPerPixel != 8) && (BitsPerPixel != 16)
                          && (BitsPerPixel != 24) && (BitsPerPixel != 32) )
                       {
                        printf("Error: TGA can only be 8, 16, 24, or 32-Bits/pixel. Press any key to continue.");
                        putch(7);
                        break;
                       }
                     }
                    else
                     if (output_format == FILE_BMP || output_format == FILE_OS2)
                       {
                       if ( (BitsPerPixel != 4) && (BitsPerPixel != 8)
                           && (BitsPerPixel != 24) )
                        {
                         printf("Error: BMP can only be 4, 8, or 24 Bits/pixel. Press any key to continue.");
                         putch(7);
                         break;
                        }
                      }
                 if ( (ret=L_FileConvert( input_filename,input_format,
                                       output_filename, output_format, new_width,
                                       new_height, BitsPerPixel )) == SUCCESS)
                  {
                   printf("File: %s converted to %s successfully.", input_filename, output_filename);
                  }
                 else
                  {
                   printf("Error: %d File convert. Press any key to continue.", ret);
                   putch(7);
                  }
        break;

        case 47: /* Case get video information */
                 ClearTheScreen();
                 L_GetVideoInfo(&videotype, &width, &height);
                 if (videotype == VIDEO_EGA)
                   printf("\n\nVIDEO TYPE =  EGA\nWidth = %d, Height = %d",width, height);
                 else
                 if (videotype == VIDEO_VGA)
                   printf("\n\nVIDEO TYPE = Standared VGA with 256K of memory\nWidth = %d, Height = %d",width, height);
                 else
                  if (videotype == VIDEO_SVGA)
                   printf("\n\nVIDEO TYPE =  SuperVGA with 512K or more memory\nWidth = %d, Height = %d",width, height);
                 printf("\n\nPress any key to continue.");
        break;

        case 48: /* Case set video resolution */
        #ifdef TARGA   /* If TARGA 16,24,32 is used not a TARGA+.
                          The TARGA+ can be chages to multiple resolutions
                          I cant not chage the old TARGA 16,24,32 only TARGA+*/
                 printf("MAX VGA resolution 0-320x200, 1-640x350, 2-640x480, 3-800x600, 4-1024x768. ");
                 getint(&video_size);
                /* Checks for legal VGA/SuperVGA resolution */
                 if ( (video_size != SIZE_320x200) && (video_size != SIZE_640x350)
                      && (video_size != SIZE_640x480) && (video_size != SIZE_800x600)
                      && (video_size != SIZE_1024x768) )
                  {
                   printf("Error: Unknown VGA resolution %d. Press any key to continue.",video_size);
                   putch(7);
                   break;
                  }
                 L_SetVGASize(video_size) ;
                 printf("VGA size set OK!  Press any key to continue.");
        #else    /** If TARGA+ is used NOT a TARGA 16, 24, 32**/
                 printf(" 0 - Set VGA resolution. 1 - Set TARGA+ resolution.");
                 getint(&input_format);
                 if (input_format == 0)
                    {
                    printf("MAX VGA resolution 0-320x200, 1-640x350, 2-640x480, 3-800x600, 4-1024x768: ");
                    getint(&video_size);
                    /* Checks for legal VGA/SuperVGA resolution */
                    if ( (video_size != SIZE_320x200) && (video_size != SIZE_640x350)
                       && (video_size != SIZE_640x480) && (video_size != SIZE_800x600)
                       && (video_size != SIZE_1024x768) )
                       {
                       printf("Error: Unknown VGA resolution %d. Press any key to continue.",video_size);
                       putch(7);
                       break;
                       }
                    L_SetVGASize(video_size) ;        /* Set new VGA resolution */
                    printf("VGA size set OK!  Press any key to continue.");
                    }
                 else if(input_format == 1)
                    {
                    ClearTheScreen();

                    printf("  0 - Interlaced 512x400x16.\n");        /* TARGA+ modes available */
                    printf("  1 - Noninterlaced 512x400x16.\n");
                    printf("  2 - Interlaced 512x400x32.\n");
                    printf("  3 - Noninterlaced 512x400x32.\n");
                    printf("  4 - Interlaced 512x486x16.\n");
                    printf("  5 - Noninterlaced 512x486x16.\n");
                    printf("  6 - Interlaced 512x486x32.\n");
                    printf("  7 - Noninterlaced 512x486x32.\n");
                    printf("  8 - Interlaced 640x480x16.\n");
                    printf("  9 - Noninterlaced 640x480x16.\n");
                    printf(" 10 - SquareInterlaced 640x486x16.\n");
                    printf(" 11 - SquareNoninterlaced 640x486x16.\n");
                    printf(" 12 - Interlaced 720x486x16.\n");
                    printf(" 13 - Noninterlaced 720x486x16.\n");
                    printf(" 14 - Interlaced 756x486x16.\n");
                    printf(" 15 - Noninterlaced 756x486x16.\n");
                    printf(" 16 - Interlaced 800x600x16.\n");
                    printf(" 17 - Interlaced 1024x768x16.\n");

                    L_SetCursor(1, 24);
                    printf("Set Targa+ Mode To: ");
                    getint(&videotype);
                    L_SetTARGAMode(videotype) ;            /* Set new TARGA+ mode */
                    printf("Targa+ mode set!  Press any key to continue.\n");
                    }
                 else
                    {
                    printf("Error: %d Unknown command number!");
                    putch(7);
                    }
        #endif
        break;

        case 49: /* Case set VGA memory */
                 printf("VGA memory in Kbytes: ");
                 getint(&video_memory);
                if (video_memory < 256)
                 {
                  printf("Error: %d Unknown VGA memory size", video_memory);
                  break;
                 }
                L_SetVideoMemory(video_memory) ;       /* Set new video memory */
                printf("VGA memory set! Press any key to continue.\n");
        break;

       case 50: /* Case change brightness */
                printf("Increase/Decrease Intensity by: ");
                getint( &ret );
                L_ChangeBitmapIntensity(&Bitmap, ret) ;    /* Set new intensity */
                printf("Change Intensity Successful!");
        break;

        case 51: /* Case capture VGA */
                if (alloc_bitmap == 1)       /* Free BitMap information as before */
                   {
                    L_FreeBitmap( &Bitmap );
                    alloc_bitmap = 0;
                   }
                /* The input file name can be any file format as long as it matches the */
                /* function call below. For this program capturing the VGA screen       */
                /* requires that the user enter a PCX file. It then loads the file to   */
                /* a bitmap handle. Then it will save the bitmap using L_GetScreeBitMap.*/
                /* When it is finished, it will release the bitmap.                     */
                printf("Input PCX file name: ");
                getstring(input_filename);
                printf("Starting X display position, or 0 for normal position: ");
                getint(&xpos);
                printf("Starting Y display position, or 0 for normal position: ");
                getint(&ypos);
                printf("Display width, or 0 for current Width in the file: ");
                getint(&width);
                printf("Display height, or 0 for current Height in the file: ");
                getint(&height);
                                 /* Puts it on the VGA screen and Bitmap handle */
                if ( (ret = L_LoadPCXScreen(input_filename, &Bitmap, OUTPUT_BITMAP,
                                                             TYPE_CONV, 0, 0 )) == SUCCESS)
                 {
                  if ((ret=L_ViewBitmapScreen(&Bitmap, 0, 0)) == SUCCESS)
                   {
                    if ((ret = L_GetScreenBitmap(&NewBitmap, 0, 0, 0, 0)) == SUCCESS )
                     {
                       if ((ret = L_SavePCXBitmap("screen.pcx", &NewBitmap, 8)) == SUCCESS)
                        {
                         /* Copy to screen sucessfull and is saved as screen.pcx in */
                         /* current directory at 8 bit/pixel.                       */ 
                        }
                      L_FreeBitmap(&NewBitmap); /* Release impage from the copy Bit map */
                      alloc_bitmap = 1;         /* Release image from the bitmap */
                     }
                   }
                 }
        break;
 

        case 99: /* inter use */
             L_SetVideoSource(VideoInputRGB);
             L_SetTARGALiveMode();
             L_SleepKey(99);
             L_GrabTARGA();
             break;

        case 100: /* Case exit the program */
                  if (alloc_bitmap == 1)  /* Release BitMap information before quit */
                   {
                    L_FreeBitmap(&Bitmap);
                    alloc_bitmap = 0;
                   }
                  L_TARGAEnd();
		            printf("\nEXIT DEMO\n\n\n");
                  printf("       COPYRIGHT (c) 1991 LEAD Technologies Inc. ALL RIGHTS RESERVED.\n");
                  printf("                           8701 Mallard Creek Rd.\n");
                  printf("                           Charlotte NC 28262\n");
                  printf("                           Tel # 704-549-5532\n");
                  printf("LEADTOOLS DEMO is for Evaluation purposes only. Your license to use this\n");
                  printf("software will expire after 3 weeks from the date you receive it.\n");
                  printf("You are free to distribute this demo copy of LEADTOOLS as long as all files\n");
                  printf("listed (DEMO.C DEMO36.EXE LEADSHOW.C LEADSHOW.EXE LEADCOMP.C\n");
                  printf("LEADCOMP.EXE LEADECOM.C LEADECOM.EXE) are all included. You may not distribute\n");
                  printf("any of the files separately.\n");
                  printf("If you do not have the above list of files please contact LEAD Technologies Inc.\n");
                  printf("for the complete list.\n");
                  printf("All .EXE programs are not designed as end user products.  They all are a quick\n");
                  printf("collection of calls to LEADTOOLS functions.  Menus were not included to avoid\n");
                  printf("confusion when evaluating the code as to the processing calls verses the\n");
                  printf("menuing code.\n");
                  exit(0);

        default:   /* Anything else is a wrong selection */
               printf("Wrong selection!  Press any key to continue.");
               putch(7);
               break;
       }             /* End BIG switch */

 L_SleepKey(99);    /* Waits 99 seconds or until key is pressed */

}                   /* BIG for loop  */

}                    /* end main(); */
/****************************END OF MAIN()***************************/


/*********** Function to get the qfactor **********/
/* Also it checks for a valid qfactor entered by the user */
int get_qfactor(char *string)   /* String to hold the Qfactor */
{
  char *exttab[NUMEXTENSIONS], *extptr1;
  int qfactor, source;

  /* The following is a reference table to find out which compression       */
  /* method the user wants to compress the file with.                       */
    exttab[0] = "PQ1";    /* Perfect quality compression                    */
    exttab[1] = "PQ2";    /* Perfect quality compression                    */
    exttab[2] = "QFS";   /* Quality by far more important than size         */
    exttab[3] = "QMS";   /* Quality more important than size                */
    exttab[4] = "QS";    /* Quality and size equally important              */
    exttab[5] = "SQS";   /* Size more important than quality - SHARP        */
    exttab[6] = "SQT";   /* Size more important than quality -  LESS TILING */
    exttab[7] = "MCQ";   /* Give maximum compression - HIGHT QUALITY        */
    exttab[8] = "MC";    /* Give maximum compression                        */

extptr1 = string;

for (source = 0; source < NUMEXTENSIONS; ++source)
     {if (!strcmp(extptr1, exttab[source]))
       break;
      }
/* Checks for bad qfactor */
if (source >= NUMEXTENSIONS)
   {
   qfactor = atoi(string);
   if (qfactor <= 0 || qfactor > 255)
      return(ERROR_QFACTOR);
   else
      return (qfactor);
   }
/* Else the extension is a predefined qfactor shown in the table above */
else
   {
   if (source == 0)         /* See the table above for types of compression */
      return(QFACTOR_PQ1);
   if (source == 1)
      return(QFACTOR_PQ2);
   if (source == 2)
      return(QFACTOR_QFS);
   if (source == 3)
      return(QFACTOR_QMS);
   if (source == 4)
      return(QFACTOR_QS);
   if (source == 5)
      return(QFACTOR_SQS);
   if (source == 6)
      return(QFACTOR_SQT);
   if (source == 7)
      return(QFACTOR_MCQ);
   if (source == 8)
      return(QFACTOR_MC);
   }
return(SUCCESS);
}

/********* Prints out the Main Menu *********/
void printscreen(void)
{
  int i;  /* For the loop to fill the BLANK screen and a */
          /* BLANK line storage array */

/* Fill the storage space into a BLANK screen with 0's */
  for(i=0; i<4000; i=i+2)  /* The background color */
     screen_clear[i]=0;
  for(i=1; i<4000; i=i+2)  /* The foreground color */
     screen_clear[i]=7;

  for(i=0; i<160; i=i+2)   /* Fill the storage space into a BLANK line */
     clear_line[i]=0;
  for(i=1; i<160; i=i+2)   /* The foreground color */
     clear_line[i]=15;

 /* Prints out the Main Menu */ 
   printf(" 1- Load TGA file to BitMap.             2- Save BitMap as TGA file.\n");
   printf(" 3- Load PCX file to BitMap.             4- Save BitMap as PCX file.\n");
   printf(" 5- Load GIF file to BitMap.             6- Save BitMap as GIF file.\n");
   printf(" 7- Load TIF file to BitMap.             8- Save BitMap as TIF file.\n");
   printf(" 9- Load BMP file to BitMap.            10- Save BitMap as BMP file.\n");
   printf("11- Load LEAD/JFIF/JTIF file to BitMap. 12- Save BitMap as LEAD/JFIF/JTIF file.\n");
   printf("13- Flip BitMap.      14- Reverse BitMap.  15- Resize BitMap.  16 Rotate Bitmap\n");
   printf("17- Optimize BitMap.  18- Clear BitMap.    19- Change BitMap position.\n");
   printf("20- View BitMap on TARGA.               21- View BitMap on VGA.\n");
   printf("22- View TGA file on TARGA.             23- View TGA file on VGA.\n");
   printf("24- View PCX file on TARGA.             25- View PCX file on VGA.\n");
   printf("26- View GIF file on TARGA.             27- View GIF file on VGA.\n");
   printf("28- View TIF file on TARGA.             29- View TIF file on VGA.\n");
   printf("30- View BMP file on TARGA.             31- View BMP file on VGA.\n");
   printf("32- View LEAD/JFIF/JTIF file on TARGA.  33- View LEAD/JFIF/JTIF file on VGA.\n");
   printf("34- Compress TGA file.                  35- Decompress to TGA file.\n");
   printf("36- Compress PCX file.                  37- Decompress to PCX file.\n");
   printf("38- Compress GIF file.                  39- Decompress to GIF file.\n");
   printf("40- Compress TIF file.                  41- Decompress to TIF file.\n");
   printf("42- Compress BMP file.                  43- Decompress to BMP file.\n");
   printf("44- Compress TARGA screen.              45- Get information on a file.\n");
   printf("46- Convert a file.                     47- Get VGA/SuperVGA information.\n");
#ifdef TARGA
   printf("48- Set VGA/SuperVGA Resolution.        49- Set VGA/SuperVGA memory size.\n");
#else                                            
   printf("48- Set VGA or TARGA+ Resolution.       49- Set VGA/SuperVGA memory size.\n");
#endif
   printf("50- Change BitMap brightness.           51- Capture VGA to BitMap.\n");

   /* Clear the input line and chage the text attribute for that line */
   L_RestoreWindow (0, 24, 79, 24, clear_line, 79, 24);
   putch('\r');
   printf("Enter your selection, or 100 to exit: ");
   
   L_GetVideoMode(&mode, &page);   /* Save the current video TEXT screen
                                      and page mode */

   /* Save the curent input screen screen to be able to restore when needed
      it is faster to restore the input screen using L_RestoreWindow()
      than calling printscreen() since L_RestoreWindow() function writes
      directly to video memory */ 
   L_SaveWindow (0, 0, 79, 24, screen_buffer, &curcolumn, &currow);
}

/**************** Restore the Main Menu and Input Screen ***************/
/* Also sets the cursor position to 0,24                               */
void RestoreInputScreen()
{
 int newmode,newpage;            /* New text mode and video page */

 L_GetVideoMode(&newmode, &newpage);    
 if ( (newmode != mode) || (newpage != page) )
    L_SetVideoMode(mode, page);            /* Set new video mode */
 L_RestoreWindow (0, 0, 79, 24, screen_buffer, 37, 24);
 L_SetCursor(39, 24);                      /* Sets the cursor    */
}

/************* Get integer value from the keyboard *************/
void getint(int *answer)         
{
   int ch, i=0;
   char string[7];

   string[0]='\0';
   while(i < 5)
   {
    ch = getch();  /* Character type in is stored in ch */
    if ( (ch == EOF) || (ch == '\r') || (ch == '\n') )
      {
       break;
      }
    /* Makes sure ch is a printable charcter */
    /* Also checks to see if ch is a Backspace key */
    if ( (ch != 0x08) && (ch > 32 ) )
      {
       putch(ch);
       string[i]=(char)ch;
       i++;
      }
    else
       if (ch == 0x08)
         {
         if (i > 0)
            {
             /* If ch is a Backspace then clear the curent character
                on the screen */
             i--;
             putch(ch);
             putch(' ');
             putch(ch);
            }
         }
   }
   string[i]='\0';
   *answer=atoi(string);
   putch('\r');     /* Clears the Line */
   L_RestoreWindow (0, 24, 79, 24, clear_line, 79, 24);
   putch('\r');
}

/************** Get a string from the keyboard ****************/
void getstring(char *answer)
{
   int ch, i=0;          /* Counters */
   char string[128];     /* Charcter buffer */

   while(i < 128)
   {
    ch = getch();          /* Gets a character and stores it in ch */
    if ( (ch == EOF) || (ch == '\r') || (ch == '\n') )
     {
      break;
     }
    /* Make sure the key pressed is a printable character and
       not a Backspace */
    if ( (ch != 0x08) && (ch > 32 ) )
     {
      putch(ch);
      string[i]=(char)ch;
      i++;
     }
    else
       if (ch == 0x08)
        {
         if (i > 0)
           {
            /* If ch is a Backspace then clear the curent character
               on the screen */
            i--;
            putch(ch);
            putch(' ');
            putch(ch);
           }
        }
   }
   string[i] = '\0';
   strcpy(answer,string);
   putch('\r');      /* Clear the line */
   L_RestoreWindow (0, 24, 79, 24, clear_line, 79, 24);
   putch('\r');
}


/************* BLANK the screen ************/
void ClearTheScreen(void)
{
 int newmode,newpage;              

 L_GetVideoMode(&newmode, &newpage);
 if ( (newmode != mode) || (newpage != page) )
   L_SetVideoMode(mode, page);
 L_RestoreWindow (0, 0, 79, 24, screen_clear, 79, 24);
 L_SetCursor(0, 0);
}
