@ECHO OFF
REM ============================================================================
REM 
REM LARC-S "LARC Examples"
REM LARC-D "Full System Build Archive Batch File"
REM LARC-V "100"
REM
REM Revision history:
REM kbg 05/14/94 100 - Created.
REM
REM Some general notes about this file follows.
REM
REM This batch file is executed whenever a full system release build is
REM performed.  The batch file is responsible for creating a complete archive
REM of everything that was used to build the release.
REM
REM
REM This batch file is started by LARC and LARC passes the following parameters:
REM 
REM     %1 = Argument 1 contains the 8 character release identifier that you
REM	     entered when you started building the release.
REM
REM     %2 = Argument 2 contains the release build type that you selected:
REM
REM		"*" = full system build requested.
REM		"T" = test build requested.
REM		"1" thru "5" = individual test build requested.
REM
REM     %3 = Argument 3 contains the two character hard drive name (i.e., "C:").
REM
REM     %4 = Argument 4 contains source file directory name (i.e., "C:\LARCEMP").
REM
REM     %5 = Argument 5 contains the constant "FULL-RELEASE".
REM
REM     %6 = Argument 6 contains current system date formatted as mm-dd-yy.
REM
REM     %7 = Argument 7 contains current system time formatted as hh:mm:ss.
REM
REM     %8 = Argument 8 contains the three character source library number.
REM	     This number can be used to archive the LARC control files
REM	     (MODCTL.nnn, RELCTL.nnn, REVCTL.nnn) that belong with the
REM	     library being archived.  However, if you use many libraries to
REM	     build you release, then it is suggested that you archive all of
REM	     LARC control files.
REM
REM     %9 = Argument 9 contains the same release identifier that is passed in
REM	     argument 1, but this one has certain characters (such as "V",
REM	     and "." removed.  This argument provides the release identifier in
REM 	     a format that can be used to create file names.
REM
REM LARC allows you complete freedom over how your product is archived.  Since
REM LARC executes this standard DOS command batch file, you can use any
REM combination of system commands to archive the release.
REM
REM Normally, ECHO OFF is set to keep things like REM lines from being
REM scrolled up the screen.  Then ECHO commands are used to display progress
REM messages.  
REM
REM ============================================================================




REM ============================================================================
REM Display some initial information on the screen.
REM ============================================================================
ECHO.
ECHO Full System Archive of build %1.
ECHO.
ECHO Delete all files from the temporary work directory C:\LARC3\TEMP...




REM ============================================================================
REM Use Ken's File Deletion utility with the "/N" option to delete any existing
REM files with being prompted before the delete.  Notice that this entire
REM process will use the C:\LARC3\TEMP directory.  You can use any directory
REM name.  However, if you were to archive directly to an off-line media, such
REM as tape, then you might need to replace this delete command with appropriate
REM tape formatting or initialization commands.
REM ============================================================================
KDEL/N C:\LARC3\TEMP\*.*




REM ============================================================================
REM Now a file will be created and printed that describes the contents of the
REM archive set.  This file should be stored with the archive set to help you
REM identify the contents at a future date.
REM ============================================================================
ECHO.
ECHO Creating READ.ME file containing notes of the archive files...

ECHO.									> C:\LARC3\TEMP\READ.ME
ECHO 		Archive Diskettes for LARC Hello %1			>> C:\LARC3\TEMP\READ.ME
ECHO 		Created %6 at %7 					>> C:\LARC3\TEMP\READ.ME
ECHO.									>> C:\LARC3\TEMP\READ.ME
ECHO 		This archive contains:					>> C:\LARC3\TEMP\READ.ME
ECHO.									>> C:\LARC3\TEMP\READ.ME
ECHO 			READ.ME		This file			>> C:\LARC3\TEMP\READ.ME
ECHO 			FILES.LST	List of source files		>> C:\LARC3\TEMP\READ.ME
ECHO 			SOURCES.ZIP	Source files			>> C:\LARC3\TEMP\READ.ME
ECHO 			RELEASE.ZIP	Release directory files		>> C:\LARC3\TEMP\READ.ME
ECHO 			LARC.ZIP	Full LARC system files		>> C:\LARC3\TEMP\READ.ME
ECHO.									>> C:\LARC3\TEMP\READ.ME

PRINT C:\LARC3\TEMP\READ.ME




REM ============================================================================
REM Create a ZIP file containing all of the source files.
REM ============================================================================
ECHO.
ECHO Zip the LARC sources...
PKZIP C:\LARC3\TEMP\SOURCES.ZIP C:\LARCSRC\EXAMPLES\*.*




REM ============================================================================
REM Copy the LARC control files for your library into the temporary
REM directory as a safeguard.  This will get the control files stored
REM it the exact state as when the archive was created.
REM ============================================================================
ECHO.
ECHO Copy the LARC control files...
COPY C:\LARC3\*.%8 C:\LARC3\TEMP\*.* >NUL




REM ============================================================================
REM Create an "on-site" backup that contains a copy of just the source files.
REM This on-site backup can be used to gain quick access to this library's files
REM should that ever be necessary.  We use Ken's File Copy utility to copy the
REM files from the temporary directory to diskette A:.  You would, of course,
REM replace this command with the commands necessary to copy the files to your
REM backup media.
REM ============================================================================
ECHO.
ECHO Start copying the zipped source files to the archive diskettes
ECHO in drive A:.  Make sure that each diskette is labeled:
ECHO.
ECHO 		LARC Hello Example
ECHO 		On-site Source Diskettes for Release %1
ECHO 		Created %6
ECHO 		Diskette 1 of n
ECHO.
KCOPY C:\LARC3\TEMP\*.* A:




REM ============================================================================
REM Now that the on-site backup has been made, we are going to add some
REM additional things to the temporary directory.  We already have the source
REM files, so we will add the release and LARC system directory.
REM
REM If you create separate configurations of LARC, it is recommended that you
REM make sure you archive the specific configuration directory.  While all of
REM the LARC configuration files are important, backing up the system activity
REM log file (SYSLOG.LRC) will ensure that you have a snapshot of all LARC
REM activity through the release creation stage.
REM ============================================================================
ECHO.
ECHO Zip the release directory...
PKZIP C:\LARC3\TEMP\RELEASE.ZIP C:\LARCSRC\EXMPREL\*.*

ECHO.
ECHO Zip the release directory...
PKZIP C:\LARC3\TEMP\LARC.ZIP C:\LARC3\*.*




REM ============================================================================
REM You can use the LDIR utility program to generate a file containing a
REM description of all of the source files that you are archiving.
REM ============================================================================
ECHO.
ECHO Creating the library listing file FILES.LST...
LDIR/C C:\LARC3\LARC.CFG %8 C:\LARC3\TEMP\FILES.LST



REM ============================================================================
REM Create an "off-site" archive.  This archive media should contain EVERYTHING
REM used to create your product.  While this example does not demonstrate
REM backing up development tools, you should consider doing so for legacy system
REM support issues.  Of course, you will need to ensure that the license
REM agreements for each individual development tool permits such backups.
REM
REM We also highly recommend that you make arrangements for the off-site
REM archive to be vaulted in a fire-safe location, preferable at a location
REM away from you main business location.
REM
REM As with the on-site backup, we are using Ken's File Copy utility to copy the
REM files from the temporary directory to diskette A:.  You would, of course,
REM replace this command with the commands necessary to copy the files to your
REM backup media.
REM ============================================================================
ECHO.
ECHO Start copying the zipped files to the archive diskettes in
ECHO drive A:.  Make sure that each diskette is labeled:
ECHO.
ECHO 		LARC Hello Example
ECHO 		Archive Diskettes for Release %1
ECHO 		Created %6
ECHO 		Diskette 1 of n
ECHO.

KCOPY C:\LARC3\TEMP\*.* A:




REM ============================================================================
REM Remove the last diskette an make sure that all diskettes have been
REM properly labeled.
REM ============================================================================
ECHO.
ECHO Remove the last diskette from drive A: and make sure that
ECHO each diskette is properly labelled and write protected!




REM ============================================================================
REM Finally, we delete the files from the temporary directory.  This step
REM may be unnecessary if you archive directly to your archive media.
REM ============================================================================
KDEL/N C:\LARC3\TEMP\*.*
