/*
 * @(#)src/contract/jvm/sov/jvmmi.h, core, xs131, 20020822 1.4.2.2
 * ===========================================================================
 * Licensed Materials - Property of IBM
 *
 * IBM Java(tm)2 SDK, Standard Edition, v 1.3.1
 * (C) Copyright IBM Corp. 1998, 2001. All Rights Reserved
 * US Government Users Restricted Rights - Use, duplication or disclosure
 * restricted by GSA ADP Schedule Contract with IBM Corp.
 * ===========================================================================
 */

/*
 *
 * ===========================================================================
 *
 *
 *
 * ===========================================================================
 * Change activity:
 *
 * Reason  Date   Origin  Description
 * ------  ----   ------  ----------------------------------------------------
 * 028883  250401 hdmsa   Creation
 * 033898  050701 hdrjm   Tidy up - add module information
 * 034149  180701 hdseb   Definition of JVMMI_callback structure for use in
 *                        monitor and object enumeration routines
 * 034693  070801 hdbdp   Definition of JVMMI_callback incorrect
 *
 * ===========================================================================
 * Module Information:
 *
 * DESCRIPTION: Contains definitions/declarations related to JVMMI. This
 * header is likely to be published if the Monitoring Interface is made public.
 * Additional non-public JVMMI elements are defined in ci_jvmmi.h.
 * ===========================================================================
 */

#include <jni.h>

#define JVMMI_VERSION_1         ((jint)0x00010011)


/****************************************************************************/
/* Event types which may be monitored                                       */
/****************************************************************************/

#define JVMMI_EVENT_COUNT             5  /* Number of events defined */

#define JVMMI_EVENT_THREAD_START      0
#define JVMMI_EVENT_THREAD_STOP       1
#define JVMMI_EVENT_CLASS_LOAD        2
#define JVMMI_EVENT_CLASS_UNLOAD      3
#define JVMMI_EVENT_HEAP_DUMP         4


/****************************************************************************/
/* "Items" which may be enumerated over                                     */
/* Any changes here need to be reflected in jvmmi_enumerateDefinitions      */
/****************************************************************************/

#define JVMMI_LIST_COUNT              5           /* Number of lists defined */

#define JVMMI_LIST_DEFINITIONS        0x10000000  /* what can be enumerated */
#define JVMMI_LIST_EVENT              0x10000001  /* what events can be monitored */
#define JVMMI_LIST_COMPONENT          0x10000002  /* components, eg st, gc... */
#define JVMMI_LIST_MONITOR            0x10000003  /* monitors */
#define JVMMI_LIST_OBJECT             0x10000004  /* All objects in heap */


/****************************************************************************/
/* Return codes                                                             */
/****************************************************************************/

#define JVMMI_OK     JNI_OK
#define JVMMI_ERR    JNI_ERR
#define JVMMI_OTHER  999


/****************************************************************************/
/* JVMMI_Event                                                              */
/****************************************************************************/

typedef struct JVMMI_Event{

/****************************************************************************/
/* NOTE: Any change to this structure may need reflecting in the            */
/* jvmmi_enumerateEvents function.                                          */
/****************************************************************************/

    int type;                 /* The type of the event */
    JNIEnv *envID;            /* Env where event occured */
    union{                    /* The valid element of the union is dictated by type */
      struct{
          void *id;           /* Unique ID of monitor */
          int tid;            /* Thread id */
          int flat_inflated;  /* 0 = flat, 1 = inflated */
      } monitor_info;
      struct{
          void *id;           /* Unique ID of object */
          int size;           /* Size of object */
          char *classname;    /* Name of class this is instance of */
      } object_info;
      struct{
          void *id;           /* Unique ID of thread */
      } thread_info;
      struct{
          char *name;         /* Class name */
          char *source;       /* Source file name */
          int interfaces;     /* Number of interfaces */
          int methods;        /* Number of methods */
          int fields;         /* Number of fields */
      } class_info;
      struct{
          int type;           /* Type of object which can be enumerated */
      } enumeration_info;
      struct{
          char name[3];       /* Name of component */
          void *interface;    /* Pointer to components interface */
      } component_info;
      struct{
          int type;           /* Type of event */
          char *detail_name;  /* Name of element in detail union */
          char *elements;     /* List of elements in detail */
          char *description;  /* V brief description of event */
      } event_info;
    } detail;
} JVMMI_Event;


/****************************************************************************/
/* JVMMI_Interface                                                          */
/****************************************************************************/

typedef struct JVMMI_Interface{
    /* Enable a callback to "func" on event type "eventId" */
    int (JNICALL *EnableEvent)(JNIEnv *env,
                               void (JNICALL *func)(JNIEnv *env, JVMMI_Event *evt, void *userData, int tid),
                               void *userData,
                               int eventId);
    /* Disable previously enabled callback to "func" on event type "eventId" */
    int (JNICALL *DisableEvent)(JNIEnv *env,
                               void (JNICALL *func)(JNIEnv *env, JVMMI_Event *evt, void *userData, int tid),
                               void *userData,
                               int eventId);
    /* Request a callback to "func" for each item of type "itemType", up to a maximum of "limit" items */
    int (JNICALL *EnumerateOver)(JNIEnv *env,
                               int itemType,
                               int limit,
                               void (JNICALL *func)(JNIEnv *env, JVMMI_Event *evt, void *userData, int tid),
                               void *userData);
} JVMMI_Interface;


/****************************************************************************/
/* JVMMI_callbackDetail                                                     */
/****************************************************************************/

typedef struct JVMMI_callbackDetail{
    void (JNICALL *func)(JNIEnv *env, JVMMI_Event *evt, void *userData, int tid);
    void *userData;
    char enabledEvents[JVMMI_EVENT_COUNT];
    struct JVMMI_callbackDetail *next;
} JVMMI_callbackDetail;



/****************************************************************************/
/* JVMMI_callback                                                           */
/****************************************************************************/

typedef struct JVMMI_callback {                                             /*ibm@34149 starts*/
    void *userdata;
    JNIEnv *env;
    int limit;
    int objcount;
    void (JNICALL *func)(JNIEnv *env, JVMMI_Event *evt, void *userData, int tid);
} JVMMI_callback;                                                            /*ibm@34149 ends ibm@34693*/


/****************************************************************************/
/* Function declarations                                                    */
/****************************************************************************/

JVMMI_Interface * jvmmi_GetInterface_1(JavaVM *vm);

