(*****************************************************************
** PURPOSE: Writes one or more files to the standard output.
**          Similar to the UNIX command 'cat'
*)
program cat(output);
var
   i : integer;

   procedure ShowSyntax;
   begin
      writeln('cat: Writes one or more files to the standard output');
      writeln('Syntax: cat files ...');
      halt
   end;

   procedure write_file(name : string);
   var
      f : text;
      c : char;
   begin
      assign(f, name);
      reset(f);
      while not eof(f) do
          begin
              read(f, c);
              write(c)
          end;
      close(f)
   end;

begin
   if paramcount = 0 then
      ShowSyntax;
   for i := 1 to paramcount do
      write_file(paramstr(i))
end.
