//-----------------------------------------------------------------------------
// Freeware.  This file may be used freely to promote the ioctl90 mixer API.
//-----------------------------------------------------------------------------

#include <stdio.h>
#include <string.h>     // memcpy

#include <os2.h>

#include "data.h"
#include "util.h"

                /*                                      ----------------------------- HexDump -
** Display data buffer (debug support)
** 16 bytes per line with ascii on right
** Output lines will look like the following
** *  OFFSET   +0       +4         +8       +C                          ";
** " 00000000  00000000 00000000 - 00000000 00000000  *................*";
*/
void HexDump (char *pszComment, BYTE *pbBuf, unsigned uBufSize)
{
   char AsciiData[17];
   unsigned I, J;
   BYTE bTemp;
   BYTE *pbTmp;

   if ( pszComment && *pszComment )
   {
      printf ("* %s\n*\n", pszComment);
   }

   AsciiData[16] = '\0';

   if ((pbBuf == NULL) ||
      (uBufSize <= 0))
      {
      return;
      }
   printf (
   "* OFFSET   +0       +4         +8       +C                          \n");

   for (I = 0; I < uBufSize; I=I+16)
   {
      if (I % 0x10 == 0)
      {
         printf (" %08X  ", I); // Offset
      }

      for (J = 0; J < 16; J++)
      {
         if ((I+J) < uBufSize)
         {
            pbTmp = pbBuf + I + J;
            bTemp = *pbTmp;
            printf ("%02X", bTemp);
            if (bTemp < ' ')
               AsciiData[J] = '.';
            else
               AsciiData[J] = bTemp;
         }
         else
         {
            printf ("  ");  // Blanks in hex area
            AsciiData[J] = ' ';
         }

         if ((J == 3) || (J == 11))
            printf (" ");
         else if (J == 7)
            printf (" - ");
      } /* for */
      printf ("  *%s*\n", AsciiData);
   } /* for */
}
