//-----------------------------------------------------------------------------
// Freeware.  This file may be used freely to promote the ioctl90 mixer API.
//
//-----------------------------------------------------------------------------
// File: ioctl90.c                                      Date Created: 03/11/99
// Description: Exercise IOCTL 90 mixer API             Last Update : 11/16/99
//-----------------------------------------------------------------------------
//
// MODIFICATION HISTORY
// 03-Sep-1998  Joe Nord   Create
//-----------------------------------------------------------------------------

#include <stdlib.h>
#include <stdio.h>
#include <signal.h>
#include <memory.h>
#include <string.h>
#include <ctype.h>
#include <io.h>

#define INCL_DOSDEVICES      // DosDevIOCtl 
#define INCL_DOSFILEMGR      // DosDevIOCtl 
#define INCL_DOSSEMAPHORES   // Semaphore values
#define INCL_DOSDATETIME     // Timer support
#define INCL_DOSERRORS       // DOS error values
#include <os2.h>

#include "data.h"
#include "parse.h"
#include "help.h"
#include "ioctl90.h"           
#include "mixerapi.h"
#include "commands.h"
#include "callback.h"



// Control break signal handler
#pragma off (unreferenced)
void SIGINT_Handler(int a)
{
   fprintf (stderr, "* Ctrl-Break *\n");
   mixerapiDeInit ();
   exit (99); // Normal exit code for SIGINT
}
#pragma on (unreferenced)


int main (int argc, char *argv[])
{
   ULONG ulRC;

   setbuf (stdout, NULL);
   setbuf (stderr, NULL);

   if (signal(SIGINT, SIGINT_Handler) == SIG_ERR)
   {
      fprintf (stderr, "\nCtrl-Break handler install failed\n");
      return (1);
   }

   ParseCommandLine (argc, argv); // Sets global variables to reflect options

   if (Options.Help)
   {
      Help (Options.ExtendedHelp);
   }
   else
   {
      ulRC = mixerapiInit (callbackMain);
      if (ulRC == 0)
      {
         CommandsMain ();
         mixerapiDeInit ();
      }
   }

   return (0);
}
