//-----------------------------------------------------------------------------
// Freeware.  This file may be used freely to promote the ioctl90 mixer API.
//-----------------------------------------------------------------------------
// asciinum.c
//
// Convert ASCII strings into numbers
//
// Modification history:
// 09/25/95 - Joe Nord - Create
//-----------------------------------------------------------------------------

#include <stdio.h>
#include <string.h>                     // memchr

#include <os2.h>                        // typedefs

#include "data.h"
#include "asciinum.h"


// This function converts an ascii string representing a
// number of the given base to an unsigned long integer.
// String token must be only digits of the indicated base and
// must be terminated by space character or nul.
//
// The parameter 'srcP' is a pointer to the ascii string.
// The function returns the converted value in the parameter 'numP'.
//
// RETURNS
//    0 - Successful conversion
//   -1 - String does not represent a number
//
static char Digits[] = {"0123456789ABCDEF"};

int AsciiToUlong (char *srcP, ULONG *numP, USHORT usBase)
{
   ULONG x;
   char *chrP;

   *numP = 0;
   if (usBase > 16)
      return (-1);

   // skip leading spaces
   while (*srcP != '\0' && *srcP <= ' ')
      srcP++;

   if ( *srcP == '\0')          // Passed empty string?
      return (-1);

   // skip leading zeros
   while (*srcP == '0')
      srcP++;

   // accumulate digits - return error if unexpected character encountered
   x = 0;
   while (*srcP > ' ')
      {
      if ((chrP = (char *)memchr(Digits, *srcP, usBase)) == NULL)
         return (-1);
      x = (x * usBase) + (chrP - Digits);
      srcP++;
      }
   *numP = x;

   // return successful
   return (0);
}


int AsciiToUshort (char *srcP, USHORT *numP, USHORT usBase)
{
   ULONG x;
   int   iRC;

   iRC = AsciiToUlong (srcP, &x, usBase);
   if ( iRC == 0 )
   {
      if ( x & 0xFFFF0000 )
         iRC = 1; // Fail for numbers too big
      else
         *numP = x;
   }

   return (iRC);
}
