/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1992 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 source code is provided to you solely for       */
/*    the purpose of assisting you in your development of OS/2 device        */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Developer Connection Device Driver       */
/*    Source Kit for OS/2. This Copyright statement may not be removed.      */
/*                                                                           */
/*****************************************************************************/
/**************************************************************************
 *
 * SOURCE FILE NAME = VTDATA.C
 *
 * DESCRIPTIVE NAME = Virtual Touch Device Driver Private Data Definitions.
 *
 *
 * VERSION = V2.0
 *
 * DATE        09/20/91
 *
 * DESCRIPTION
 *             This module contains the VTD's private data.
 *
 * FUNCTIONS
 *
 * ENTRY POINTS:
 *
 * DEPENDENCIES:
 *
 * NOTES
 *
 *
 * STRUCTURES
 *
 * EXTERNAL REFERENCES
 *
 * EXTERNAL FUNCTIONS
 *
*/

#include "vtdef.h"
#include <propname.h>

/*
** Global Data
*/

#pragma  BEGIN_GLOBAL_DATA
PSZ Copyright =
{
    "IBM Touch Device Virtual Device Driver "
    "Version "VTD_VERSION" "
    "(C) Copyright IBM Corporation 1991. All Rights Reserved."
} ;

PSZ pszExclusiveTouch = PROP_NAME_EXCLUSIVE_TOUCH;

#ifdef   VTDEBUG
PSZ AssertMsg =
{
    "\nVTouch Assertion: File %s at line %d.\n\n\a"
} ;
#endif
#pragma  END_GLOBAL_DATA

/*
** Instance Data
*/

#pragma  BEGIN_INSTANCE_DATA
QEVENT   atevBuffer[QEVENTBUFFSIZE];    /*                              */
PQEVENT  pEventHead = & atevBuffer[0];  /*                              */
PQEVENT  pEventTail = & atevBuffer[0];  /*                              */
HHOOK    hhookSendEventHook;            /*                              */
HHOOK    hhookUserSubReturnHook;        /*                              */
HHOOK    hhookJmpTableHook;             /*                              */
ULONG    ulSG = 0;                      /* screen group for this VDM    */
ULONG    ulSstate = 0;                  /* Fgnd/Bkgnd state             */
BOOL     fTouchEnabled = FALSE;         /* reset done                   */
BOOL     fEventsPending = FALSE;        /* TRUE if event queue has data */
BOOL     fSubActive = FALSE;            /* sendevent user-sub active    */
BOOL     fTaskActive = FALSE;           /* 122614 - sendevent is active */
#pragma  END_INSTANCE_DATA

/*
** Swappable Instance Data
*/

#pragma  BEGIN_SWAP_INSTANCE
PERVDMDATA VDMData;
#pragma  END_SWAP_INSTANCE

/*
** Swappable Global Data
*/

#pragma  BEGIN_SWAP_DATA
FPFNPDD  fpfnPTDRequestProc;
HIRQ     hirq;
TOUDEVICESTATE touDeviceState =
{
    sizeof(TOUDEVICESTATE), 0
} ;

ULONG    ulExclusiveSG = 0;
VPVOID   vpBP74;                        /* breakpoint address for int 74 ARPL */
VPVOID   vpBP7f;                        /* breakpoint address for int 7f ARPL */
SZ szVMBoot =
{
    '#', VDMP_ORD_VMBOOT+'0', 0
} ;

PFNVTDOSREQ apfnDosReq[] =
{
    vtDosSetFocus,
    vtDosPostTouch,
} ;

PFNVTVDDREQ apfnVddReq[] =
{
    vtVddSetFocus,
    vtVddPostTouch,
} ;

PERVDMDATA VDMDataDefaults =
{
    { DEFAULT_EMUL_TYPE,
      DEFAULT_EMUL_BEEP,
      DEFAULT_EMUL_MICKEYS,
    },                                  /* flEmulState;                 */
    DEFAULT_EMUL_ONOFF,                 /* fEmulationOn;                */
    DEFAULT_BLOCKMASK,                  /* flBlockMask;                 */
    DEFAULT_CALLMASK,                   /* flCallMask;                  */
    NULL,                               /* fpfnUserSub;                 */
    { 0 },                              /* UserSubStack;                */
    DEFAULT_FILTER_TYPE,                /* ulFilterType;                */
    DEFAULT_FILTER_FREQ,                /* ulFilterFreq;                */
    DEFAULT_REPORT_RATE,                /* ulReportRate;                */
    DEFAULT_ORIGIN_TOPLEFT,             /* fOriginTopLeft;              */
    DEFAULT_TRACK_VIDEOMODE,            /* fTrackVideoMode;             */
    { DEFAULT_COORD_XMIN,
      DEFAULT_COORD_XMAX,
      DEFAULT_COORD_YMIN,
      DEFAULT_COORD_YMAX,
      DEFAULT_COORD_ZMIN,
      DEFAULT_COORD_ZMAX,
      DEFAULT_COORD_XHYSTERESIS,
      DEFAULT_COORD_YHYSTERESIS,
    },                                  /* coData;                      */
    { DEFAULT_THRESHOLD_ONSCREEN,
      DEFAULT_THRESHOLD_HYSTERESIS,
      DEFAULT_THRESHOLD_PUSH,
    },                                  /* thData;                      */
    { DEFAULT_SELECTION_METHOD,
      DEFAULT_SELECTION_FLAG,
      DEFAULT_SELECTION_TOLERANCE,
      DEFAULT_SELECTION_COUNT,
      DEFAULT_SELECTION_COUNT,
      DEFAULT_SELECTION_LIMIT,
      DEFAULT_SELECTION_METHOD,
      DEFAULT_SELECTION_TOLERANCE,
      DEFAULT_SELECTION_COUNT,
      DEFAULT_SELECTION_LIMIT,
      0,
      0,
      0,
    },                                  /* smData;                      */
    { DEFAULT_CLICK_ONOFF,
      DEFAULT_CLICK_TIMEOUT,
      DEFAULT_CLICK_XLOCKAREA,
      DEFAULT_CLICK_YLOCKAREA,
    },                                  /* clData;                      */
    { 0 },                              /* xyzCurrent;                  */
    { 0 },                              /* xyzLastLiftOff;              */
    { 0 },                              /* xyzLastTouchDown;            */
    { 0 },                              /* xyzLastSelectOn;             */
    { 0 },                              /* xyzLastSelectOff;            */
    { 0 },                              /* xyzStablePoint;              */
    { 0 },                              /* xyzSingleTouch;              */
} ;
#pragma  END_SWAP_DATA
