/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1992 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 source code is provided to you solely for       */
/*    the purpose of assisting you in your development of OS/2 device        */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Developer Connection Device Driver       */
/*    Source Kit for OS/2. This Copyright statement may not be removed.      */
/*                                                                           */
/*****************************************************************************/

/**************************************************************************
 *
 * SOURCE FILE NAME = VMSECRET.C
 *
 * DESCRIPTIVE NAME = Virtual Mouse Device Driver Microsoft secret interfaces
 *
 *
 * VERSION = V2.0
 *
 * DATE      92/02/28
 *
 * DESCRIPTION This module contains the Microsoft secret interfaces.
 *
 *
 * FUNCTIONS
 *
 *   VMInt33SecretMessage()     Int 33h Get Secret Message   (function 'm')
 *   VMInt33SecretStructure()   Int 33h Get Secret Structure (function 'M')
 *
 *
 * ENTRY POINTS:
 *
 * DEPENDENCIES:
 *
 * NOTES
 *
 *
 * STRUCTURES
 *
 * EXTERNAL REFERENCES
 *
 * EXTERNAL FUNCTIONS
 *
*/
#include "vmdp.h"
#include "vmint33.h"
#ifdef VDDSTRICT
MODNAME = __FILE__;
#endif

#pragma BEGIN_SWAP_CODE

/****************************************************************************
 *
 * FUNCTION NAME  : VMInt33SecretMessage
 *
 * DESCRIPTION    :  Int 33h Get Secret Message (function 'm')
 *
 *      INPUT    :
 *          pcrf -> VDM register frame
 *
 *      OUTPUT   :
 *          EMULATED
 *              TRUE
 *          NOT EMULATED
 *              FALSE (pass control to next VDD and/or ROM)
 *
 *      CONTEXT
 *          VDM Task-time
 *
 *      PSEUDOCODE
 *          return Microsoft secret message.
 *
 ****************************************************************************/

BOOL HOOKENTRY VMInt33SecretMessage(register PCRF pcrf)
{
  ES(pcrf) = SEGMENTOF16(VDMBase.rb_avpIVT[INT_MOUSE]);
  DI(pcrf) = SECRET_MESSAGE1OFFSET;
  return TRUE;
}       /* VMInt33SecretMessage */

/****************************************************************************
 *
 * FUNCTION NAME  : VMInt33SecretStructure
 *
 * DESCRIPTION    :  Int 33h Get Secret Structure (function 'M')
 *
 *      INPUT    :
 *          pcrf -> VDM register frame
 *
 *      OUTPUT   :
 *          EMULATED
 *              TRUE
 *          NOT EMULATED
 *              FALSE (pass control to next VDD and/or ROM)
 *
 *      CONTEXT
 *          VDM Task-time
 *
 *      PSEUDOCODE
 *          return Microsoft secret structure.
 *
 ****************************************************************************/

BOOL HOOKENTRY VMInt33SecretStructure(register PCRF pcrf)
{
  ES(pcrf) = SEGMENTOF16(VDMBase.rb_avpIVT[INT_MOUSE]);
  DI(pcrf) = SECRET_STRUCTOFSET;
  return TRUE;
}       /* VMInt33Secretstructure */

#pragma END_SWAP_CODE
