/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1992 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 source code is provided to you solely for       */
/*    the purpose of assisting you in your development of OS/2 device        */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Developer Connection Device Driver       */
/*    Source Kit for OS/2. This Copyright statement may not be removed.      */
/*                                                                           */
/*****************************************************************************/

/**************************************************************************
 *
 * SOURCE FILE NAME = VMIO.C
 *
 * DESCRIPTIVE NAME = Virtual Mouse Device Driver (VMSE) 
 *
 *
 * VERSION   V2.0
 *
 * DATE      02/28/92
 *
 * DESCRIPTION This module contains all the VMSE's I/O port handlers.
 *             
 *
 * FUNCTIONS  vmReadPort  Byte input handler for serial port 
 *            vmWritePort Byte output handler for serial port
 *
 * ENTRY POINTS: 
 *
 * DEPENDENCIES:  
 *
 * NOTES
 *
 *
 * STRUCTURES
 *
 * EXTERNAL REFERENCES
 *
 * EXTERNAL FUNCTIONS
 *
*/#include "vmdp.h"

#ifdef   VDDSTRICT
MODNAME = __FILE__;
#endif

/*
**    External References
*/

/*
** Global Data
*/

/*
** Instance Data
*/

#pragma  BEGIN_SWAP_CODE

 /****************************************************************************
 *
 * FUNCTION NAME  : vmReadPort 
 *
 * DESCRIPTION    : Byte input handler for serial port 
 *
 *                  See 8086 Emulation for complete semantics.
 *                 
 *                  This registered subroutine is called whenever byte input
 *                  is performed on the serial port that the physical mouse
 *                  is attached to.
 *
 * INPUT          :
 *                   ulPort   - port address
 *                   pcrf     - pointer to client register frame
 *
 * OUTPUT         :
 *                      returns data read
 *
 * CONTEXT        :
 *                   VDM Task-time
 *
 ***************************************************************************/

BYTE HOOKENTRY vmReadPort(ULONG ulPort,PCRF pcrf)
{
  return 0xff;
} 

 /***************************************************************************
 *
 * FUNCTION NAME  : vmWritePort 
 *
 * DESCRIPTION    : Byte output handler for serial port 
 *
 *                 Byte output handler for the serial port.
 *                
 *                 See 8086 Emulation for complete semantics.
 *                
 *                 This registered subroutine is called whenever byte output
 *                 is performed on the serial port that the physical mouse is
 *                 attached to.
 *
 * INPUT          :
 *                    ulPort   - port address
 *                    pcrf     - pointer to client register frame
 *                    bOutData - output data
 *                  
 * OUTPUT         :
 *                    None
 *
 * CONTEXT        :
 *                  VDM Task-time
 *
 ****************************************************************************/

VOID HOOKENTRY vmWritePort(BYTE bOutData,ULONG ulPort,PCRF pcrf)
{
} 

#pragma  END_SWAP_CODE
