/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1992 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 source code is provided to you solely for       */
/*    the purpose of assisting you in your development of OS/2 device        */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Developer Connection Device Driver       */
/*    Source Kit for OS/2. This Copyright statement may not be removed.      */
/*                                                                           */
/*****************************************************************************/

/**************************************************************************
 *
 * SOURCE FILE NAME = VMINIT.C
 *
 * DESCRIPTIVE NAME = Virtual Mouse Device Driver Initialization
 *
 *
 * VERSION     V2.0
 *
 * DATE        01/10/92
 *
 * DESCRIPTION This module contains the VMD's initialization code.
 *
 *
 * FUNCTIONS   VDDInit()          VMD initialization
 *
 * ENTRY POINTS:
 *
 * DEPENDENCIES:
 *
 * NOTES
 *
 *
 * STRUCTURES
 *
 * EXTERNAL REFERENCES
 *
 * EXTERNAL FUNCTIONS
 *
*/#include "vmdp.h"

#ifdef   VDDSTRICT
MODNAME = __FILE__;
#endif

/*
**    External References
*/

extern FPFNPDD fpfnPMRequestProc;
extern MHARDWARE mhwInstalled;
extern HIRQ hirq;

#pragma  BEGIN_SWAP_DATA
extern PSZ pszPropMouseCapture;
#pragma  END_SWAP_DATA


#pragma  BEGIN_INIT_CODE
 /**************************************************************************
 *
 * FUNCTION NAME  : VDDInit()
 *
 * DESCRIPTION    : VMD initialization
 *
 *  This routine is defined as the device driver entry point, and
 *  is called during system initialization (also known as VDD-init time).
 *
 *  INPUT         : NONE.
 *
 *  OUTPUT        :
 *                  SUCCESS
 *                      TRUE
 *                  FAILURE
 *                      FALSE (ie, hardware missing)
 *  USES          :
 *                  32-bit small-model PASCAL calling/register conventions
 *
 *  CONTEXT       :
 *                  System initialization (specifically, VDD-init time)
 *
 *  PSEUDO-CODE   :                                 REFERENCES
 *      verify existence of physical hardware
 *
 ****************************************************************************/

BOOL EXPENTRY VDDInit(PSZ psz)
{
  BOOL fSuccess = FALSE;

    /*
    ** Verify PMD is loaded
    */

  fpfnPMRequestProc = VDHOpenPDD(PMD_NAME, VMEventProc);

    /*
    ** If the hardware is available
    */

  if (fpfnPMRequestProc)
  {

       /*
       ** Query the hardware type
       */

    AssertRC((*fpfnPMRequestProc)(PMDCMD_QUERYTYPE,
                                  NULL,
                                  F16PFROMP (&mhwInstalled)));

       /*
       ** If the PDD has found a pointing device
       */

    if (mhwInstalled.mhw_uType)
    {

          /*
          ** Claim the IRQ that the PMD says is the real IRQ
          */

      hirq = VDHOpenVIRQ(mhwInstalled.mhw_irq,
                         VPIC_NOEOIHOOK,
                         VPIC_NOIRETHOOK,
                         VPIC_NOIRETHOOK_TIMEOUT,
                         VPIC_SHARE_IRQ);

          /*
          ** Assuming the IRQ is available, we will install
          */

      if (hirq)
      {
        /*
        ** WARNING - Some clones do not initialize with our IRQ
        ** unmasked so force the correct IRQ to be unmasked.
        */

        VDHPutSysValue( VDHGSV_PICMASK,
                        (VDHQuerySysValue((HVDM)0,
                        VDHGSV_PICMASK)&~(1 << mhwInstalled.mhw_irq) ) );
        fSuccess = TRUE;

              /*
              ** Install user event hooks
              */

        VDHInstallUserHook(VDM_CREATE, VMCreate);
        VDHInstallUserHook(VDM_TERMINATE, VMTerminate);
        VDHInstallUserHook(VDM_FOREGROUND, VMSetFgnd);
        VDHInstallUserHook(VDM_BACKGROUND, VMSetBgnd);

              /*
              ** Allow Video VDD and shield to communicate with us
              */

        VDHRegisterVDD(VMD_NAME, VMSysReqProc, VMDeviceReqProc);
        if (!VDHRegisterProperty(
                   pszPropMouseCapture,       /* property name               */
                   NULL,                      /* no help file                */
                   0,                         /* no help id                  */
                   VDMP_BOOL,                 /* type                        */
                   VDMP_ORD_OTHER,            /* no ordinal                  */
                   0,                         /* modifiable after creation   */
                   (VOID *)FALSE,             /* default                     */
                   NULL,                      /* validation info             */
                   VMMouseCapture)            /* function                    */
           )
          fSuccess = FALSE;
      }
    }
    if (!fSuccess)
      AssertRC((*fpfnPMRequestProc)(PMDCMD_DEREGISTER, NULL, NULL));
  }
  return  fSuccess;
}                                      /* VDDInit                            */
#pragma  END_INIT_CODE
