;***    Virtual Mouse Private Definitions
;
;
;       IBM/Microsoft Confidential
;
;       Copyright (c) IBM Corporation 1987, 1989
;       Copyright (c) Microsoft Corporation 1987, 1989
;
;       All Rights Reserved
;
;       DESCRIPTION
;       VMD private constants, types, and function prototypes
;
;       MODIFICATION HISTORY
;       01/30/89    JTP     Created.
;       07/19/90    J-TS00  Japanese version created.   (T.Sobue)
;       01/16/91    J-TS01  Imprement int 15H function
;                           to support 'ICHITARO'       (T.Sobue)
;

PROPERTIES      EQU 1           ;include properties support

        include mvdm.inc
include vddseg.inc
        include vmd.inc
        include vmdpmd.inc

MOUSE_VERSION   EQU     00625h  ;version 6.25
MOUSE_INSTALLED         EQU     -1      ;returned state of INT33_RESET and
                                ;INT33_SOFTWARERESET
MOUSE_INSTALLED_J       EQU     3   ;returned state (J-DOS)           ;@IBM J-TS00

MAX_MEVBUFFS    EQU     16      ;maximum number of buffered mouse events
MAX_BUTTONS     EQU     3       ;maximum buttons supported

BUTTON_LEFT     EQU     0       ;index of butinfo array
BUTTON_RIGHT    EQU     1
BUTTON_CENTER   EQU     2

PTR_HIDDEN      EQU     -1       ;ordinals for fPtrHidden
PTR_VISIBLE     EQU     0

SUB_NONE        EQU     -1       ;ordinals for iSubActive
SUB_NORMAL      EQU     0
SUB_ALT1        EQU     1
SUB_ALT2        EQU     2
SUB_ALT3        EQU     3
MAX_USERSUBS    EQU     4       ;maximum user subroutines supported

DEF_XHOT        EQU     0       ;default hot-spot positions
DEF_YHOT        EQU     0

MAX_EVENTYIELD  EQU     10      ;# events to process before yielding

EVEN_XMASK      EQU     0fffffffeh ;mask to truncate x into even value
                                   ;for 320200h video mode

MAX_SCALERANGE  EQU     21      ;maximum number of entries in scale table
SENS_SCALAR     EQU     65536   ;precision scale factor used in scale table

MAX_INTLEVEL    EQU     2       ;max. interrupt nesting allowed
BLOCKED_NONE    EQU     0       ;sendevent is not blocked
BLOCKED_SUBACTIVE       EQU     1       ;sendevent is blocked by an active sub.
BLOCKED_MAXINTLEVEL     EQU     2       ;sendevent is blocked by exceeding max.
                                        ;interrupt nesting levels

                                        ;DOS BIOS mode value      ;@IBM J-TS00
                                        ;for vmQueryDosMode()     ;@IBM J-TS00
BIOS_PS2        EQU     0       ;U.S. mode                        ;@IBM J-TS00
BIOS_PS55       EQU     1       ;Japan mode                       ;@IBM J-TS00

;***    Session states
;
;   These indicate the state of a VDM session as dictated by foreground
;   and background notifications.
;

SESSION_FGND    EQU     001h    ;session is foregrounded
SESSION_WINDOW  EQU     002h    ;session is a windowed VDM
SESSION_EXCMOUSE        EQU     004h    ;session set for exclusive mouse
SESSION_READY   EQU     008h    ;session is ready to accept events



;***    Private types
;
;   These state-types refer to sets of ordinal values representing
;   various states.
;
;   butinfo contains button information, and subinfo contains user-subroutine
;   information.
;

DefType PFNINT33,dd
DefType PFNSYSRQ,dd

DefType STATE,BOOL                      ;for misc. state values   (state)
DefType SSTATE,BOOL                     ;for session-state values (sstate, ss)

DefStruc ,mevbuff_s                     ;mouse event buffer
    MINFO   mevb_mi            ;mouse event info.
    USHORT  mevb_fsKeyShift    ;keyboard shift states
EndStruc MEVBUFF

DefType PMEVBUFF,dd

DefStruc ,butinfo_s                     ;butinfo
    ULONG bi_nPresses          ;button information
    ULONG bi_xLastPress
    ULONG bi_yLastPress
    ULONG bi_nReleases
    ULONG bi_xLastRelease
    ULONG bi_yLastRelease
EndStruc BUTINFO

DefStruc ,subinfo_s                     ;subinfo
    VPVOID si_vpCall           ;user-subroutine information
    ULONG  si_flCallMask
EndStruc SUBINFO

DefStruc ,int15info_s                   ;int 15h subinfo          ;@IBM J-TS01
    VPVOID vpCall              ;user-subroutine address           ;@IBM J-TS01
    ULONG  flEnable            ;mouse enable/disable flag         ;@IBM J-TS01
    ULONG  ulSampleRate        ;sampling rate                     ;@IBM J-TS01
    ULONG  ulScaling           ;scaling factor                    ;@IBM J-TS01
    ULONG  ulResolution        ;resolution                        ;@IBM J-TS01
    ULONG  ulPackageSize       ;data package size                 ;@IBM J-TS01
    _SHORT  sRemainX            ;x remain delta                   ;@IBM J-TS01
    _SHORT  sRemainY            ;y remain delta                   ;@IBM J-TS01
EndStruc INT15INFO                                                ;@IBM J-TS01

DefStruc ,vvinfo_s                      ;vvinfo
    VMREG vvi_vmreg            ;video services for a given VVD
    PVOID vvi_pvvinfoNext
EndStruc VVINFO

DefType PVVINFO,dd




DefStruc ,mousestates_s

;***    Int 33h state information
;
;

BOOL    fInOffRegion           ;TRUE if cursor is in conditional off region
BOOL    fOffEnable             ;TRUE if conditional off is enabled
BOOL    fPtrHidden             ;normally -1 (PTR_HIDDEN)
BOOL    JDosGraphicsMode       ;TRUE if screen mode is graphics   ;@IBM J-TS00
                                ;in @IBM J-DOS.                   ;@IBM J-TS00

ULONG   xCur                   ;current horz/vert positions
ULONG   yCur                   ;x must be doubled if 320-wide mode (fShiftX)

BUTINFO butinfo,,MAX_BUTTONS   ;button info for left/right/center buttons

LONG    xMin                   ;current horz/vert minimums/maximums
LONG    xMax                   ;for the "screen-motion" rectangle
LONG    yMin
LONG    yMax

LONG    xMinOff                ;current horz/vert minimums/maximums
LONG    xMaxOff                ;for the "conditional-off" rectangle
LONG    yMinOff
LONG    yMaxOff

LONG    nxMics                 ;# since last query (INT33_GETMOTIONCOUNTS)
LONG    nyMics                 ;can be negative numbers

ULONG   nxMicsPer8Pix          ;DEF_XMICKEYS (set by INT33_SETMICKEYRATIO)
ULONG   nyMicsPer8Pix          ;DEF_YMICKEYS
ULONG   ulThreshold            ;current double-speed threshold

ULONG   scaleXMics             ;DEF_XMICSSCALE (set by INT33_SETSENSITIVITY)
ULONG   scaleYMics             ;DEF_YMICSSCALE
ULONG   scaleThreshold         ;DEF_THRESHOLDSCALE

SUBINFO subinfo,,MAX_USERSUBS  ;user-defined subroutine info

BOOL    fLPenEmulate           ;TRUE if light-pen emulation active (default)

BOOL    fHWPtr                 ;TRUE if "hardware" pointer enabled

ULONG   ulTextANDMask          ;also called the "screen" mask
ULONG   ulTextXORMask          ;also called the "cursor/pointer" mask

ULONG   xHot                   ;hot-spot coordinates for app's pointer
ULONG   yHot                   ;storage for app's screen and pointer masks

ULONG   ulVideoPage            ;video page number to use
ULONG   ulPtrColor             ;pointer color                     ;@IBM J-TS00
INT15INFO int15info            ;int 15H interface information     ;@IBM J-TS01
ULONG   ulLanguage             ;language number (set by INT33_SETLANGUAGE)

USHORT  ausGraphMasks,,2*MAX_PTRHEIGHT


EndStruc MOUSESTATES


DefStruc ,vdmdata_s                     ;beginning of PERVDMDATA structure

;***    Per-VDM data
;
;   sstate indicates the VDM "session state" (SESSION_NONE, SESSION_FGND,
;   or SESSION_BGND).  It is NONE only up until the first SetFgnd/SetBgnd call.
;

ULONG   ulSG                   ;screen group # for this VDM
SSTATE  sstate                 ;session state (NONE, FGND, BGND)

ULONG   iSubActive             ;index of active user-subroutine
ULONG   flEventMask            ;event mask for user subroutine call

VMSSIZE vmss                   ;current display mode data
BOOL    fShiftX                ;TRUE if x-coordinates must be doubled
BOOL    fScrInit               ;set TRUE once screen has been initialized
                                ;at that time, we also perform a soft reset

ULONG   flBlocked              ;blocked flag of sendevent
ULONG   nIntLevel              ;number of nesting interrupts

ULONG   flButtons              ;button state (see BUTBITs)

ULONG   BIOSMode               ;BIOS mode PS/2 or PS/55           ;@IBM J-TS00

MOUSESTATES mstates            ;mouse state information

EndStruc PERVDMDATA                   ;end of PERVDMDATA structure

DefType PVDMDATA,dd


DefData IMPORT,INSTANCE,C
PERVDMDATA VMData
VDMData catstr VMData
EndData




;*** Private function prototypes
;

;vminit.c

EXPENTRY VDDInit                <PSZ>


;vmuser.c

EXPENTRY VMCreate               <HVDM>
EXPENTRY VMSetFgnd              <HVDM>
EXPENTRY VMSetBgnd              <HVDM>
ifdef PROPERTIES
EXPENTRY VMMouseCapture         <ULONG, HVDM, ULONG, PSZ>
EXPENTRY VMGrabAccess           <HVDM, BOOL>
endif


;vmint15.c                                                        ;@IBM J-TS01
                                                                  ;@IBM J-TS01
HOOKENTRY VMInt15Hook           <PCRF>                            ;@IBM J-TS01
HOOKENTRY VMInt15SubIntHook             <PCRF>                    ;@IBM J-TS01
HOOKENTRY VMInt15SubReturnHook          <PVOID, PCRF>             ;@IBM J-TS01


;vmhook.c

HOOKENTRY VMInt33Hook           <PCRF>
HOOKENTRY VMUserSubIntHook              <PCRF>
HOOKENTRY VMUserSubReturnHook           <PVOID, PCRF>


;vmreset.c

PRIVENTRY vmInt33Reset          <PCRF>
PRIVENTRY vmInt33SoftwareReset          <PCRF>
PRIVENTRY vmHardReset           <VOID>
PRIVENTRY vmSoftReset           <HVDM>


;vmptr.c

PRIVENTRY vmInt33ShowPointer            <PCRF>
PRIVENTRY vmShowPointer         <HVDM>
PRIVENTRY vmInt33HidePointer            <PCRF>
PRIVENTRY vmHidePointer         <HVDM>
PRIVENTRY vmInt33DefineGraphPointer             <PCRF>
PRIVENTRY vmInt33DefineTextPointer              <PCRF>
PRIVENTRY vmDefineTextPointer           <HVDM>
PRIVENTRY vmInt33DefineVarPointer               <PCRF>
PRIVENTRY vmInt33SetCRTPage             <PCRF>
PRIVENTRY vmSetCRTPage          <HVDM, ULONG>
PRIVENTRY vmInt33QueryCRTPage           <PCRF>
PRIVENTRY vmResetMasks          <HVDM, BOOL>
PRIVENTRY vmUpdateGraphMasks            <HVDM, PUSHORT>
PRIVENTRY vmInt33SetPtrColor            <PCRF>                    ;@IBM J-TS00
PRIVENTRY vmSetPtrColor         <HVDM, ULONG>                     ;@IBM J-TS00


;vmpos.c

PRIVENTRY vmInt33QueryStatus            <PCRF>
PRIVENTRY vmInt33SetPosition            <PCRF>
PRIVENTRY vmBoundedX            <HVDM, LONG>
PRIVENTRY vmBoundedY            <HVDM, LONG>
PRIVENTRY vmSetPosition         <HVDM, ULONG, ULONG, BOOL>
PRIVENTRY vmCheckOffRegion              <HVDM>
PRIVENTRY vmInt33GetPressInfo           <PCRF>
PRIVENTRY vmInt33GetReleaseInfo         <PCRF>
PRIVENTRY vmInt33GetMotionCounts                <PCRF>


;vmbound.c

PRIVENTRY vmInt33SetHorizontal          <PCRF>
PRIVENTRY vmInt33SetVertical            <PCRF>
PRIVENTRY vmInt33SetConditional         <PCRF>


;vmrate.c

PRIVENTRY vmInt33SetMickeyRatio         <PCRF>
PRIVENTRY vmSetScaleFactor              <ULONG, ULONG>
PRIVENTRY vmInt33SetThreshold           <PCRF>
PRIVENTRY vmSetThreshold                <ULONG>
PRIVENTRY vmScaleSensitivity            <ULONG, ULONG>
PRIVENTRY vmInt33SetSensitivity         <PCRF>
PRIVENTRY vmInt33QuerySensitivity               <PCRF>
PRIVENTRY vmInt33SetInterruptRate               <PCRF>


;vmlpen.c

PRIVENTRY vmInt33EnableLightPen         <PCRF>
PRIVENTRY vmInt33DisableLightPen                <PCRF>
PRIVENTRY vmSetLightPen         <HVDM, BOOL>
EXPENTRY VMQueryStatus          <HVDM, PVMSTAT>


;vmstate.c

PRIVENTRY vmInt33QueryStateSize         <PCRF>
PRIVENTRY vmInt33SaveState              <PCRF>
PRIVENTRY vmInt33RestoreState           <PCRF>
PRIVENTRY vmInt33DisableDriver          <PCRF>
PRIVENTRY vmInt33EnableDriver           <PCRF>


;vmmisc.c

PRIVENTRY vmInt33SetLanguage            <PCRF>
PRIVENTRY vmInt33QueryLanguage          <PCRF>
PRIVENTRY vmInt33QueryMouseVersion              <PCRF>
PRIVENTRY vmInt33NotSupported           <PCRF>                    ;@IBM J-TS00
PRIVENTRY vmQueryDosMode                <VOID>                    ;@IBM J-TS00


;vmevent.c

PRIVENTRY vmInt33SetUserSub             <PCRF>
PRIVENTRY vmInt33SwapUserSub            <PCRF>
PRIVENTRY vmFindAltUserSub              <HVDM, ULONG>
PRIVENTRY vmInt33SetAltUserSub          <PCRF>
PRIVENTRY vmInt33QueryAltUserSub                <PCRF>
VDDENTRY VMEventProc            <ULONG, F16PVOID, F16PVOID>
PRIVENTRY vmMickeysToPixels             <PMINFO>
PRIVENTRY vmAddEvent            <HVDM, PMINFO, ULONG, BOOL>
PRIVENTRY vmCoalesceEvent               <HVDM, PMINFO>
HOOKENTRY vmSendEvent           <PHVDM, PCRF>
PRIVENTRY vmClearEvent          <HVDM>
PRIVENTRY vmPeekEvent           <HVDM, PMEVBUFF>
PRIVENTRY vmRemoveEvent         <HVDM, PMEVBUFF>
PRIVENTRY vmNeedEvent           <HVDM, ULONG, ULONG, PULONG>
PRIVENTRY vmEvent2CallMask              <ULONG, ULONG, ULONG>
PRIVENTRY vmProcessEvent                <HVDM, PMEVBUFF, ULONG>


;vmdevrq.c

EXPENTRY VMDeviceReqProc                <HVDM, ULONG, PVOID, PVOID>
PRIVENTRY vmRegisterVVD         <HVDM, PVMREG, PVMFUNC>
PRIVENTRY vmSetScreenSize               <HVDM, PVMSSIZE>


;vmsysrq.c

EXPENTRY VMSysReqProc           <SGID, ULONG, ULONG, PVOID, ULONG, PVOID>
PRIVENTRY vmSysSetAccess                <HVDM, BOOL, PVOID, ULONG, PVOID>
PRIVENTRY vmSysSetFocus         <HVDM, BOOL, PULONG, ULONG, PULONG>
PRIVENTRY vmSysPostMouse                <HVDM, ULONG, PVOID, ULONG, PVOID>


;vmint33.asm


PRIVENTRY vmInt33Router         <VOID>
PRIVENTRY vmInt33RouterEntry            <VOID>
PRIVENTRY vmInt33RouterBasicEntry               <USHORT, USHORT, USHORT, USHORT>
PRIVENTRY vmInt33RouterEnd              <VOID>

;*** Component specific macros
;



;*** Random macro support
;
;    If VDDSTRICT is defined, the Assert macros generate appropriate code.
;
;    If VDDSTRICT is not defined, the Assert macros are NO-OPs (with the
;    exception of AssertRC, in which case the function is still called, but
;    the return code is not checked).
;
;    If VDDDEBUG is defined, debug printfs (PRINTDEBUGs) are generated, and
;    failed assertions (assuming VDDSTRICT is defined) break at the assertion
;    rather than in the kernel's "panic" service.  VDDDEBUG requires the
;    kernel debugger, in other words.
;
;    If VDDDEBUG is not defined, debug printfs (PRINTDEBUGs) are NOT
;    generated, and failed assertions (assuming VDDSTRICT is defined) simply
;    panics.
;

ifdef VDDSTRICT


else


endif


;*** Random debugging support
;

ifdef VDDDEBUG


endif
