/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1992 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 source code is provided to you solely for       */
/*    the purpose of assisting you in your development of OS/2 device        */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Developer Connection Device Driver       */
/*    Source Kit for OS/2. This Copyright statement may not be removed.      */
/*                                                                           */
/*****************************************************************************/

/**************************************************************************
 *
 * SOURCE FILE NAME = VMDP.H
 *
 * DESCRIPTIVE NAME = VMD private constants, types, and function prototypes
 *
 *
 * VERSION =   V2.0
 *
 * DATE        02/28/92
 *
 * DESCRIPTION VMD private constants, types, and function prototypes
 *
 *
 * FUNCTIONS   NONE
 *
 * ENTRY POINTS:  NONE
 *
 * DEPENDENCIES:  NONE
 *
 * NOTES          NONE
 *
 *
 * STRUCTURES     NONE
 *
 * EXTERNAL REFERENCES  NONE
 *
 * EXTERNAL FUNCTIONS   NONE
 *
*/
#define  PROPERTIES                   /* include properties support          */
#include <mvdm.h>
#include <vpmxport.h>                 

/*
** masm-begin
*/

/* include vddseg.inc */

/*
** masm-end
*/

#include <vmd.h>
#include <vmdpmd.h>
#define  MOUSE_VERSION 0x0900         /* version 9.00                        */
#define  MOUSE_INSTALLED -1           /* returned state of INT33_RESET and   */
                                      /* INT33_SOFTWARERESET                 */
#define  MOUSE_INSTALLED_J  3         /* returned state (J-DOS)              */

//#define  MAX_MEVBUFFS  16             /* maximum no. of buffered mouse events*/
//175800
#define  MAX_MEVBUFFS  24              /* 175800 maximum no. of buffered mouse events*/
#define  MAX_BUTTONS   3              /* maximum buttons supported           */
#define  MAX_BUTTON_STATE_CHANGES 5   /* 175800                              */
#define  BUTTON_LEFT   0              /* index of butinfo array              */
#define  BUTTON_RIGHT  1
#define  BUTTON_CENTER 2

#define  PTR_HIDDEN    -1             /* ordinals for fPtrHidden             */
#define  PTR_VISIBLE   0

#define  SUB_NONE      -1             /* ordinals for iSubActive             */
#define  SUB_NORMAL    0
#define  SUB_ALT1      1
#define  SUB_ALT2      2
#define  SUB_ALT3      3
#define  MAX_USERSUBS  4              /* maximum user subroutines supported  */
#define  SUB_INT15     15

#define  DEF_XHOT      0              /* default hot-spot positions          */
#define  DEF_YHOT      0

#define  MAX_EVENTYIELD 10            /* # events to process before yielding */

#define  EVEN_XMASK    0xfffffffe     /* mask to truncate x into even value  */
                                      /* for 320x200 video mode              */
#define  MAX_SCALERANGE 21     /* maximum number of entries in scale table   */

#define  SENS_SCALAR   65536   /* precision scale factor used in scale table */
#define  CALLMASK_VPMHANDLER 0x80000000 /* protected mode handl              */

                                      /* DOS BIOS mode value                 */
                                      /* for vmQueryDosMode()                */
#define BIOS_PS2        0             /* U.S. mode                           */
#define BIOS_PS55       1             /* Japan mode                          */

/*
** LK+ Session states - fsstate
**
**  These indicate the state of a VDM session as dictated by foreground
**  and background notifications.
*/

#define  SESSION_FGND  0x01           /* session is foregrounded             */
#define  SESSION_WINDOW 0x02          /* session is a windowed VDM           */
#define  SESSION_EXCMOUSE 0x04        /* session set for exclusive mouse     */
#define  SESSION_READY 0x08           /* session is ready to accept events   */
#define  SESSION_SEAMLESS 0x10        /* session is running seamless windows */

/*
 More Background states         175800
*/

#define  BKG_FROM_BKG       0x1    /* 175800 processing events as if we're in bkgnd*/
#define  BKG_CRF_REGS_SET   0x2    /* 175800 CRF registers are set, int is sent    */
/*
** end
*/

/*
** LT+ Private types
**
**  These state-types refer to sets of ordinal values representing
**  various states.
**
**  butinfo contains button information, and subinfo contains user-subroutine
**  information.
*/

typedef(PASCAL *PFNINT33)(PCRF);
typedef(PASCAL *PFNSYSRQ)(HVDM,ULONG,PVOID,ULONG,PVOID);

typedef(PRIVENTRY *PFNINT33PROCS)(PCRF);

typedef BOOL STATE;                   /* for misc. state values (state)      */
typedef struct mevbuff_s
{                                     /* mouse event buffer                  */
  MINFO mevb_mi;                      /* mouse event info.                   */
  USHORT mevb_fsKeyShift;             /* keyboard shift states               */
} MEVBUFF;

typedef MEVBUFF *PMEVBUFF;
typedef PMEVBUFF *PPMEVBUFF;

typedef struct butinfo_s
{                                     /* butinfo                             */
  ULONG bi_nPresses;                  /* button information                  */
  ULONG bi_xLastPress;
  ULONG bi_yLastPress;
  ULONG bi_nReleases;
  ULONG bi_xLastRelease;
  ULONG bi_yLastRelease;
} BUTINFO;

typedef struct subinfo_s
{                                     /* subinfo                             */
  FPFN si_SubAddr;                    /* user-subroutine information         */
  ULONG si_flCallMask;
} SUBINFO;

typedef struct vvinfo_s
{                                     /* vvinfo                              */
  VMREG vvi_vmreg;                    /* video services for a given VVD      */
  struct vvinfo_s *vvi_pvvinfoNext;
} VVINFO;

typedef VVINFO *PVVINFO;

typedef struct int15info_s
{                                     /* int15info                           */
  FPFN ii_SubAddr;                    /* user-subroutine callout address     */
  BYTE ii_fstatus;                    /* status flags byte                   */
  BYTE ii_srate;                      /* reports per second (100 default)    */
  BYTE ii_res;                        /* counts per millimeter (4 default)   */
} INT15INFO;

typedef struct perappdata_s
{
  FPFN    pad_fpfnOriginalVPMIRQ;     /* Original int handler for mouse IRQ  */
  SUBINFO pad_subinfo[MAX_USERSUBS];  /* SUBINFO structure for this app      */
  ULONG   pad_ulsubactive;            /* iSubActive for this app             */
  PDHD    pad_pdhdData;               
  struct  perappdata_s *pad_pappdataPrev;
} PERAPPDATA;

typedef PERAPPDATA *PAPPDATA;

/*
** end
*/

typedef struct mousestates_s
{

  /*
  ** LT+ Int 33h state information
  */


  BOOL fInOffRegion;           /* TRUE if cursor is in conditional off region*/
  BOOL fOffEnable;             /* TRUE if conditional off is enabled         */
  BOOL fPtrHidden;             /* normally -1 (PTR_HIDDEN)                   */
  BOOL JDosGraphicsMode;       /* TRUE if screen mode is graphics            */
                               

  ULONG xCur;                  /* current horz/vert positions                */
  ULONG yCur;                  /* x must be doubled if 320-wide mode(fShiftX)*/

  BUTINFO butinfo[MAX_BUTTONS];/* button info for left/right/center buttons  */

  LONG xMin;                   /* current horz/vert minimums/maximums        */
  LONG xMax;                   /* for the "screen-motion" rectangle          */
  LONG yMin;
  LONG yMax;

  LONG xMinOff;                /* current horz/vert minimums/maximums        */
  LONG xMaxOff;                /* for the "conditional-off" rectangle        */
  LONG yMinOff;
  LONG yMaxOff;

  LONG nxMics;                 /* # since last query (INT33_GETMOTIONCOUNTS) */
  LONG nyMics;                 /* can be negative numbers                    */

  ULONG nxMicsPer8Pix;         /* DEF_XMICKEYS (set by INT33_SETMICKEYRATIO) */
  ULONG nyMicsPer8Pix;         /* DEF_YMICKEYS                               */
  ULONG ulThreshold;           /* current double-speed threshold             */

  ULONG scaleXMics;            /* DEF_XMICSSCALE(set by INT33_SETSENSITIVITY)*/
  ULONG scaleYMics;            /* DEF_YMICSSCALE                             */
  ULONG scaleThreshold;        /* DEF_THRESHOLDSCALE                         */

  SUBINFO subinfo[MAX_USERSUBS];/* user-defined subroutine info              */

  INT15INFO int15info;         /* Int 15h (Pointing Device BIOS) info        */

  BOOL fLPenEmulate;           /* TRUE if light-pen emulation active(default)*/

  BOOL fHWPtr;                 /* TRUE if "hardware" pointer enabled         */

  ULONG ulTextANDMask;         /* also called the "screen" mask              */
  ULONG ulTextXORMask;         /* also called the "cursor/ptr" mask          */

  ULONG xHot;                  /* hot-spot coordinates for app's ptr         */
  ULONG yHot;                  /* storage for app's screen and pointer masks */

  ULONG ulVideoPage;           /* video page number to use                   */
  ULONG ulPtrColor;            /* pointer color                              */
  ULONG ulLanguage;            /* language number (set by INT33_SETLANGUAGE) */

  USHORT ausGraphMasks[2*MAX_PTRHEIGHT];

/*
** end
*/

} MOUSESTATES;

typedef struct vdmdata_s
{                               /* beginning of PERVDMDATA structure         */
  /*
  ** LT+ Per-VDM data
  */

  ULONG ulSG;                   /* screen group # for this VDM               */

  ULONG flEventMask;            /* event mask for user subroutine call       */

  VMSSIZE vmss;                 /* current display mode data                 */

  BOOL fShiftX;                 /* TRUE if x-coordinates must be doubled     */
  BOOL fScrInit;                /* set TRUE once screen has been initialized */
                                /* at that time, we also perform a soft reset*/
  BOOL fPassAbs;                /* set TRUE if user sub asked to be told     */
                                /* if point is absolute or relative          */
  BOOL fAbsPt;                  /* the last point processed was absolute     */

  ULONG BIOSMode;               /* BIOS mode PS/2 or PS/55                   */

  ULONG flButtons;              /* button state (see BUTBITs)                */
  ULONG ulcVPMapps;             /* number of DPMI client's in this VDM       */
  FPFN  fpfnVPMBP;              /* VPM breakpoint for mouse IRQ              */
  PAPPDATA    pappdata;         /* pointer to VPM app specific data          */
  MOUSESTATES mstates;          /* mouse state information                   */
                 /* additions by 175800 */
  ULONG  OldButtonState;        /* Old mouse button state                    */
  USHORT ButtonEvSinceBkg;      /* Button events since coming from bkgnd     */
  ULONG  flBkgButtonState;       /* Background Button State                   */

} PERVDMDATA;
                                /* end of PERVDMDATA structure               */
typedef PERVDMDATA *PVDMDATA;

/*
** end
*/


   /*
   ** masm-begin
   **
   ** DefData IMPORT,INSTANCE,C
   ** PERVDMDATA VMData
   ** VDMData catstr VMData
   ** EndData
   **
   ** masm-end
   */

/*
** c-begin
*/

#pragma BEGIN_INSTANCE_DATA
extern  PERVDMDATA VMData;
#define VDMData VMData
#pragma END_INSTANCE_DATA

/*
** c-end
*/

/*
** Private function prototypes
*/

/*
** vminit.c
*/

BOOL EXPENTRY VDDInit(PSZ);

/*
** vmuser.c
*/

BOOL EXPENTRY VMCreate(HVDM);
BOOL EXPENTRY VMTerminate(HVDM hvdm);
VOID EXPENTRY VMSetFgnd(HVDM);
VOID EXPENTRY VMSetBgnd(HVDM);
ULONG EXPENTRY VMMouseCapture(ULONG,HVDM,ULONG,PSZ);
VOID EXPENTRY VMGrabAccess(HVDM,BOOL);

/*
** vmhook.c
*/

BOOL HOOKENTRY VMInt33Hook(PCRF);
BOOL HOOKENTRY VMUserSubIntHook(PCRF);
BOOL HOOKENTRY VMUserSubVPMIntHook(PVOID,PCRF);
VOID HOOKENTRY VMUserSubReturnHook(PVOID,PCRF);

/*
** vmreset.c
*/

BOOL PRIVENTRY vmInt33Reset(PCRF);
BOOL PRIVENTRY vmInt33SoftwareReset(PCRF);
VOID PRIVENTRY vmHardReset(VOID);
VOID PRIVENTRY vmSoftReset(HVDM);

/*
** vmptr.c
*/

BOOL PRIVENTRY vmInt33ShowPointer(PCRF);
VOID PRIVENTRY vmShowPointer(HVDM);
BOOL PRIVENTRY vmInt33HidePointer(PCRF);
VOID PRIVENTRY vmHidePointer(HVDM);

BOOL PRIVENTRY vmInt33DefineGraphPointer(PCRF);
BOOL PRIVENTRY vmInt33DefineTextPointer(PCRF);
VOID PRIVENTRY vmDefineTextPointer(HVDM);
BOOL PRIVENTRY vmInt33DefineVarPointer(PCRF);

BOOL PRIVENTRY vmInt33SetCRTPage(PCRF);
VOID PRIVENTRY vmSetCRTPage(HVDM,ULONG);
BOOL PRIVENTRY vmInt33QueryCRTPage(PCRF);
VOID PRIVENTRY vmResetMasks(HVDM,BOOL);
VOID PRIVENTRY vmUpdateGraphMasks(HVDM,PUSHORT);
BOOL PRIVENTRY vmInt33SetPtrColor(PCRF);                            
VOID PRIVENTRY vmSetPtrColor(HVDM, ULONG);                          

/*
** vmpos.c
*/

BOOL PRIVENTRY vmInt33QueryStatus(PCRF);
BOOL PRIVENTRY vmInt33SetPosition(PCRF);
ULONG PRIVENTRY vmBoundedX(HVDM,LONG);
ULONG PRIVENTRY vmBoundedY(HVDM,LONG);

VOID PRIVENTRY vmSetPosition(HVDM,ULONG,ULONG,BOOL);
BOOL PRIVENTRY vmCheckOffRegion(HVDM);
BOOL PRIVENTRY vmInt33GetPressInfo(PCRF);
BOOL PRIVENTRY vmInt33GetReleaseInfo(PCRF);
BOOL PRIVENTRY vmInt33GetMotionCounts(PCRF);

/*
** vmbound.c
*/

BOOL PRIVENTRY vmInt33SetHorizontal(PCRF);
BOOL PRIVENTRY vmInt33SetVertical(PCRF);
BOOL PRIVENTRY vmInt33SetConditional(PCRF);

/*
** vmrate.c
*/

BOOL PRIVENTRY vmInt33SetMickeyRatio(PCRF);
VOID PRIVENTRY vmSetScaleFactor(ULONG,ULONG);
BOOL PRIVENTRY vmInt33SetThreshold(PCRF);
VOID PRIVENTRY vmSetThreshold(ULONG);

ULONG PRIVENTRY vmScaleSensitivity(ULONG,ULONG);
BOOL PRIVENTRY vmInt33SetSensitivity(PCRF);
BOOL PRIVENTRY vmInt33QuerySensitivity(PCRF);
BOOL PRIVENTRY vmInt33SetInterruptRate(PCRF);

/*
** vmlpen.c
*/

BOOL PRIVENTRY vmInt33EnableLightPen(PCRF);
BOOL PRIVENTRY vmInt33DisableLightPen(PCRF);
VOID PRIVENTRY vmSetLightPen(HVDM,BOOL);
BOOL EXPENTRY VMQueryStatus(HVDM,PVMSTAT);

/*
** vmstate.c
*/

BOOL PRIVENTRY vmInt33QueryStateSize(PCRF);
BOOL PRIVENTRY vmInt33SaveState(PCRF);
BOOL PRIVENTRY vmInt33RestoreState(PCRF);
BOOL PRIVENTRY vmInt33DisableDriver(PCRF);
BOOL PRIVENTRY vmInt33EnableDriver(PCRF);

/*
** vmmisc.c
*/

BOOL PRIVENTRY vmInt33SetLanguage(PCRF);
BOOL PRIVENTRY vmInt33QueryLanguage(PCRF);
BOOL PRIVENTRY vmInt33QueryMouseVersion(PCRF);
BOOL PRIVENTRY vmInt33GetGeneralInfo(register PCRF pcrf);
BOOL PRIVENTRY vmInt33GetMaxVirtual(register PCRF pcrf);
BOOL PRIVENTRY vmInt33GetMaskMickey(register PCRF pcrf);
BOOL PRIVENTRY vmInt33GetHotSpot(register PCRF pcrf);
BOOL PRIVENTRY vmInt33HdwReset(register PCRF pcrf);
BOOL PRIVENTRY vmInt33GetMinMax(register PCRF pcrf);
BOOL PRIVENTRY vmInt33GetAdvanced(register PCRF pcrf);
BOOL PRIVENTRY vmInt33GetSwitches(register PCRF pcrf);
BOOL PRIVENTRY vmInt33NotSupported(PCRF);                           
BOOL PRIVENTRY vmQueryDosMode(VOID);                                

/*
** vmevent. c
*/

BOOL PRIVENTRY vmInt33SetUserSub(PCRF);
BOOL PRIVENTRY vmInt33SwapUserSub(PCRF);
LONG PRIVENTRY vmFindAltUserSub(HVDM,ULONG);
BOOL PRIVENTRY vmInt33SetAltUserSub(PCRF);

BOOL PRIVENTRY vmInt33QueryAltUserSub(PCRF);
VOID VDDENTRY VMEventProc(ULONG,F16PVOID,F16PVOID);
VOID PRIVENTRY vmMickeysToPixels(PMINFO);
VOID PRIVENTRY vmAddEvent(HVDM,PMINFO,ULONG,BOOL);

VOID HOOKENTRY vmSendEvent(PHVDM,PCRF);
VOID PRIVENTRY vmClearEvent(HVDM);
BOOL PRIVENTRY vmPeekEvent(HVDM,PMEVBUFF);
BOOL PRIVENTRY vmRemoveEvent(HVDM,PMEVBUFF);

ULONG PRIVENTRY vmNeedEvent(HVDM,ULONG,ULONG,PULONG);
ULONG PRIVENTRY vmEvent2CallMask(ULONG,ULONG,ULONG);
VOID PRIVENTRY vmProcessEvent(HVDM,PMEVBUFF,ULONG);

/*
** vmdevrq. c
*/

BOOL EXPENTRY VMDeviceReqProc(HVDM,ULONG,PVOID,PVOID);
BOOL PRIVENTRY vmRegisterVVD(HVDM,PVMREG,PVMFUNC);
BOOL PRIVENTRY vmSetScreenSize(HVDM,PVMSSIZE);
BOOL PRIVENTRY vmPMDNotification(HVDM);                 /* PenPM EMI change  */

BOOL PRIVENTRY vmSeamlessNotification(HVDM,PBOOL);
BOOL PRIVENTRY vmProtInt33Entry(HVDM hvdm,PCRF pcrf);
BOOL PRIVENTRY vmDPMITask(HVDM hvdm,BOOL fStart);

/*
** vmsysrq. c
*/

LONG EXPENTRY VMSysReqProc(SGID,ULONG,ULONG,PVOID,ULONG,PVOID);
LONG PRIVENTRY vmSysSetAccess(HVDM,BOOL,PVOID,ULONG,PVOID);
LONG PRIVENTRY vmSysSetFocus(HVDM,BOOL,PULONG,ULONG,PULONG);
LONG PRIVENTRY vmSysPostMouse(HVDM,ULONG,PVOID,ULONG,PVOID);

/*
** vmint15. c
*/

BOOL HOOKENTRY vmInt15Hook(PCRF);
BOOL PRIVENTRY vmInt15EnableDisable(PCRF);
BOOL PRIVENTRY vmInt15Reset(PCRF);
BOOL PRIVENTRY vmInt15SetSampleRate(PCRF);

BOOL PRIVENTRY vmInt15SetResolution(PCRF);
BOOL PRIVENTRY vmInt15ReadDeviceType(PCRF);
BOOL PRIVENTRY vmInt15Init(PCRF);
BOOL PRIVENTRY vmInt15ExtCommand(PCRF);

BOOL PRIVENTRY vmInt15FarCallInit(PCRF);

/*
** vmio.c
*/

BYTE HOOKENTRY vmReadPort(ULONG,PCRF);
VOID HOOKENTRY vmWritePort(BYTE,ULONG,PCRF);

/*
** vmsecret.c
*/

BOOL HOOKENTRY VMInt33SecretMessage(PCRF);
BOOL HOOKENTRY VMInt33SecretStructure(PCRF);

/*
** vmint33. asm
** c-begin
**
** #define ROUTER_SIZE       ((PBYTE)vmInt33RouterEnd-(PBYTE)vmInt33Router)
** #define ROUTER_ENTRYOFFSET((PBYTE)vmInt33RouterEntry-(PBYTE)vmInt33Router)
**
**  c-end
**
** VOID    PRIVENTRY vmInt33Router(VOID);
** VOID    PRIVENTRY vmInt33RouterEntry(VOID);
** VOID    PRIVENTRY vmInt33RouterBasicEntry(USHORT, USHORT, USHORT, USHORT);
** VOID    PRIVENTRY vmInt33RouterEnd(VOID);
*/

/*
** Component specific macros
*/

/*
** c-begin
*/

#define  NEXTPTR(p,pb,pe) (((p)+1==(pe))?(pb):((p)+1))
#define  MBUFFHEAD        ((PMEVBUFF)&amevBuffer[0])
#define  MBUFFTAIL        ((PMEVBUFF)&amevBuffer[MAX_MEVBUFFS])
#define  VDMMBUFFHEAD(h)  (pVDM((h), PMEVBUFF, &amevBuffer[0]))
#define  VDMMBUFFTAIL(h)  (pVDM((h), PMEVBUFF, &amevBuffer[MAX_MEVBUFFS]))

/*
** c-end
*/

/*
** Random macro support
**
**   If VDDSTRICT is defined, the Assert macros generate appropriate code.
**
**   If VDDSTRICT is not defined, the Assert macros are NO-OPs (with the
**   exception of AssertRC, in which case the function is still called, but
**   the return code is not checked).
**
**   If VDDDEBUG is defined, debug printfs (PRINTDEBUGs) are generated, and
**   failed assertions (assuming VDDSTRICT is defined) break at the assertion
**   rather than in the kernel's "panic" service.  VDDDEBUG requires the
**   kernel debugger, in other words.
**
**   If VDDDEBUG is not defined, debug printfs (PRINTDEBUGs) are NOT
**   generated, and failed assertions (assuming VDDSTRICT is defined) simply
**   panics.
*/

#ifdef   VDDSTRICT

/*
** c-begin
*/

extern CHAR szAssertMsg[];
#define  MODNAME static CHAR szFile[]

#ifdef VDDDEBUG

 #define Assert(t) {                                              \
                     if (!(t)) {                                  \
                       PRINTDEBUG(szAssertMsg, szFile, __LINE__); \
                       INT3();                                    \
                     }                                            \
                   }
 #else
 #define Assert(t) {                                         \
                     if (!(t)) {                             \
                       PANIC(szAssertMsg, szFile, __LINE__); \
                     }                                       \
                   }

#endif
 #define  AssertTRUE(t) Assert(t)
 #define  AssertFALSE(t) Assert(!(t))
 #define  AssertZERO(t) Assert(!(t))
 #define  AssertNONZERO(t)Assert(t)
 #define  AssertRC(t)   Assert(t)  /* verify function return code good       */

/*
** c-end
*/

#else

 /*
 ** c-begin
 */

 #define  Assert(t)
 #define  AssertTRUE(t)
 #define  AssertFALSE(t)
 #define  AssertZERO(t)
 #define  AssertNONZERO(t)
 #define  AssertRC(t)   (t)        /* perform function, but don't verify     */


 /*
 ** c-end
 */

#endif

/*
** Random debugging support
*/

#ifdef   VDDDEBUG


 /*
 ** c-begin
 */

 extern CHAR szModule[];
 extern CHAR *apszPageStates[];
 #undef   PRINTDEBUG
 #define  PRINTDEBUG    printf(szModule); printf


 /*
 ** c-end
 */
#endif

