/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT (C) Microsoft Corporation, 1989                                 */
/* COPYRIGHT    Copyright (C) 1992 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 source code is provided to you solely for       */
/*    the purpose of assisting you in your development of OS/2 device        */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Developer Connection Device Driver       */
/*    Source Kit for OS/2. This Copyright statement may not be removed.      */
/*                                                                           */
/*****************************************************************************/
/*static char *SCCSID = "@(#)vlptout.c  6.2 91/03/25";*/
#pragma linesize(132)
#pragma pagesize(60)
#pragma title("VLPTOUT.C")
/****************************************************************************/
/*                                                                          */
/*                                                                          */
/*                                                                          */
/****************************************************************************/
/************************** START OF SPECIFICATIONS ***************************/
/*                                                                            */
/*   SOURCE FILE NAME:  VLPTOUT.C                                             */
/*                                                                            */
/*   DESCRIPTIVE NAME:  Process VDM parallel printer port Output              */
/*                                                                            */
/*   FUNCTION: These routines process all OUT instructions                    */
/*             to parallel printer ports.                                     */
/*                                                                            */
/*   NOTES:                                                                   */
/*      DEPENDENCIES: Spooler is running                                      */
/*      RESTRICTIONS: None                                                    */
/*                                                                            */
/*   ENTRY POINTS:                                                            */
/*             VLPT1DaOut - LPT1 Data port OUT instruction handler            */
/*             VLPT2DaOut - LPT2 Data port OUT instruction handler            */
/*             VLPT3DaOut - LPT3 Data port OUT instruction handler            */
/*             VLPT1StOut - LPT1 Status port OUT instruction handler          */
/*             VLPT2StOut - LPT1 Status port OUT instruction handler          */
/*             VLPT3StOut - LPT1 Status port OUT instruction handler          */
/*             VLPT1CoOut - LPT1 Control port OUT instruction handler         */
/*             VLPT2CoOut - LPT2 Control port OUT instruction handler         */
/*             VLPT3CoOut - LPT3 Control port OUT instruction handler         */
/*             VLPTResOut - LPT Reserve port OUT instruction handler          */
/*                                                                            */
/*   EXTERNAL REFERENCES:                                                     */
/*             None                                                           */
/*   HISTORY: 51595 09-23-92 S. Barnes  Enable IRQ7 simulation                */
/*                                                                            */
/**************************** END OF SPECIFICATIONS ***************************/

#include <mvdm.h>                       /* VDH services, etc.        */
#include "vlptp.h"                      /* VLPT data defines         */
#include "vlptdata.h"                   /* VLPT external data        */

#pragma BEGIN_SWAP_CODE

/********************** START OF SPECIFICATIONS ***********************/
/*                                                                    */
/* SUBROUTINE NAME:  VLPT1DaOut                                       */
/*                                                                    */
/* DESCRIPTIVE NAME:  LPT1 Data Port OUT Instruction Handler          */
/*                                                                    */
/* FUNCTION:  The function of this routine is to service the VDM      */
/*            OUT instruction for LPT1 if the OUT to the data port    */
/*            is the first occurrence of I/O. If it is not the        */
/*            first occurrence then the hook for this port will       */
/*            have been disabled. This routine requests I/O direct    */
/*            mode and if successful does the OUT instruction.        */
/*                                                                    */
/* NOTES:  VLPT1DaOut currently handles byte instructions only.       */
/*                                                                    */
/* CONTEXT: VDM task time                                             */
/*                                                                    */
/* ENTRY POINT:  VLPT1DaOut                                           */
/*    LINKAGE:  CALL NEAR 32                                          */
/*                                                                    */
/* INPUT:  (PARAMETERS)  (passed on the stack)                        */
/*         chartowrite - data to write                                */
/*         portaddr    - port address                                 */
/*         pcrf        - client register frame pointer                */
/*                                                                    */
/* EXIT-NORMAL:  NONE                                                 */
/*                                                                    */
/* EXIT-ERROR:  NONE                                                  */
/*                                                                    */
/* EFFECTS:  NONE                                                     */
/*                                                                    */
/* INTERNAL REFERENCES:  doOpenDirect                                 */
/*                                                                    */
/* EXTERNAL REFERENCES:  NONE                                         */
/*                                                                    */
/************************ END OF SPECIFICATIONS ***********************/
VOID HOOKENTRY VLPT1DaOut(chartowrite, portaddr, pcrf)
BYTE chartowrite;
ULONG portaddr;
PCRF pcrf;
{

#ifdef DEBUG
   vdhInt3();
#endif
    /*---------------------------------------------------------------*/
    /*- Call to set up direct access mode for the port address      -*/
    /*- passed in.                                                  -*/
    /*---------------------------------------------------------------*/
    doOpenDirect(&pvd_area[LPTONE]);

    /*---------------------------------------------------------------*/
    /*- If direct I/O access mode was granted all future I/O to the -*/
    /*- data port will go directly to the port. Now do an OUT to    -*/
    /*- satisfy the application that caused this routine to be      -*/
    /*- executed.                                                   -*/
    /*---------------------------------------------------------------*/
    if (pvd_area[LPTONE].flags & DIRECT_MODE_FLAG) {

        OUTB(portaddr,chartowrite);

    } /* endif */

    return;

}

/********************** START OF SPECIFICATIONS ***********************/
/*                                                                    */
/* SUBROUTINE NAME:  VLPT2DaOut                                       */
/*                                                                    */
/* DESCRIPTIVE NAME:  LPT2 Data Port OUT Instruction Handler          */
/*                                                                    */
/* FUNCTION:  The function of this routine is to service the VDM      */
/*            OUT instruction for LPT2 if the OUT to the data port    */
/*            is the first occurrence of I/O. If it is not the        */
/*            first occurrence then the hook for this port will       */
/*            have been disabled. This routine requests I/O direct    */
/*            mode and if successful does the OUT instruction.        */
/*                                                                    */
/* NOTES:  VLPT2DaOut currently handles byte instructions only.       */
/*                                                                    */
/* CONTEXT: VDM task time                                             */
/*                                                                    */
/* ENTRY POINT:  VLPT2DaOut                                           */
/*    LINKAGE:  CALL NEAR 32                                          */
/*                                                                    */
/* INPUT:  (PARAMETERS)  (passed on the stack)                        */
/*         chartowrite - data to write                                */
/*         portaddr    - port address                                 */
/*         pcrf        - client register frame pointer                */
/*                                                                    */
/* EXIT-NORMAL:  NONE                                                 */
/*                                                                    */
/* EXIT-ERROR:  NONE                                                  */
/*                                                                    */
/* EFFECTS:  NONE                                                     */
/*                                                                    */
/* INTERNAL REFERENCES:  doOpenDirect                                 */
/*                                                                    */
/* EXTERNAL REFERENCES:  NONE                                         */
/*                                                                    */
/************************ END OF SPECIFICATIONS ***********************/
VOID HOOKENTRY VLPT2DaOut(chartowrite, portaddr, pcrf)
BYTE chartowrite;
ULONG portaddr;
PCRF pcrf;
{

#ifdef DEBUG
   vdhInt3();
#endif
    /*---------------------------------------------------------------*/
    /*- Call to set up direct access mode for the port address      -*/
    /*- passed in.                                                  -*/
    /*---------------------------------------------------------------*/
    doOpenDirect(&pvd_area[LPTTWO]);

    /*---------------------------------------------------------------*/
    /*- If direct I/O access mode was granted all future I/O to the -*/
    /*- data port will go directly to the port. Now do an OUT to    -*/
    /*- satisfy the application that caused this routine to be      -*/
    /*- executed.                                                   -*/
    /*---------------------------------------------------------------*/
    if (pvd_area[LPTTWO].flags & DIRECT_MODE_FLAG) {

        OUTB(portaddr,chartowrite);

    } /* endif */

    return;

}

/********************** START OF SPECIFICATIONS ***********************/
/*                                                                    */
/* SUBROUTINE NAME:  VLPT3DaOut                                       */
/*                                                                    */
/* DESCRIPTIVE NAME:  LPT3 Data Port OUT Instruction Handler          */
/*                                                                    */
/* FUNCTION:  The function of this routine is to service the VDM      */
/*            OUT instruction for LPT3 if the OUT to the data port    */
/*            is the first occurrence of I/O. If it is not the        */
/*            first occurrence then the hook for this port will       */
/*            have been disabled. This routine requests I/O direct    */
/*            mode and if successful does the OUT instruction.        */
/*                                                                    */
/* NOTES:  VLPT3DaOut currently handles byte instructions only.       */
/*                                                                    */
/* CONTEXT: VDM task time                                             */
/*                                                                    */
/* ENTRY POINT:  VLPT3DaOut                                           */
/*    LINKAGE:  CALL NEAR 32                                          */
/*                                                                    */
/* INPUT:  (PARAMETERS)  (passed on the stack)                        */
/*         chartowrite - data to write                                */
/*         portaddr    - port address                                 */
/*         pcrf        - client register frame pointer                */
/*                                                                    */
/* EXIT-NORMAL:  NONE                                                 */
/*                                                                    */
/* EXIT-ERROR:  NONE                                                  */
/*                                                                    */
/* EFFECTS:  NONE                                                     */
/*                                                                    */
/* INTERNAL REFERENCES:  doOpenDirect                                 */
/*                                                                    */
/* EXTERNAL REFERENCES:  NONE                                         */
/*                                                                    */
/************************ END OF SPECIFICATIONS ***********************/
VOID HOOKENTRY VLPT3DaOut(chartowrite, portaddr, pcrf)
BYTE chartowrite;
ULONG portaddr;
PCRF pcrf;
{

#ifdef DEBUG
   vdhInt3();
#endif
    /*---------------------------------------------------------------*/
    /*- Call to set up direct access mode for the port address      -*/
    /*- passed in.                                                  -*/
    /*---------------------------------------------------------------*/
    doOpenDirect(&pvd_area[LPTTHREE]);

    /*---------------------------------------------------------------*/
    /*- If direct I/O access mode was granted all future I/O to the -*/
    /*- data port will go directly to the port. Now do an OUT to    -*/
    /*- satisfy the application that caused this routine to be      -*/
    /*- executed.                                                   -*/
    /*---------------------------------------------------------------*/
    if (pvd_area[LPTTHREE].flags & DIRECT_MODE_FLAG) {

        OUTB(portaddr,chartowrite);

    } /* endif */

    return;

}

/********************** START OF SPECIFICATIONS ***********************/
/*                                                                    */
/* SUBROUTINE NAME:  VLPT1StOut                                       */
/*                                                                    */
/* DESCRIPTIVE NAME:  LPT1 Status Port OUT Instruction Handler        */
/*                                                                    */
/* FUNCTION:  The function of this routine is to service the VDM      */
/*            OUT instruction for LPT1 if the OUT to the status port  */
/*            is the first occurrence of I/O. If it is not the        */
/*            first occurrence then the hook for this port will       */
/*            have been disabled. This routine requests I/O direct    */
/*            mode and if successful does the OUT instruction.        */
/*                                                                    */
/* NOTES:  VLPT1StOut currently handles byte instructions only.       */
/*         See vlptp.h for bit-level detail of the status port.       */
/*                                                                    */
/* CONTEXT: VDM task time                                             */
/*                                                                    */
/* ENTRY POINT:  VLPT1StOut                                           */
/*    LINKAGE:  CALL NEAR 32                                          */
/*                                                                    */
/* INPUT:  (PARAMETERS)  (passed on the stack)                        */
/*         chartowrite - data to write                                */
/*         portaddr    - port address                                 */
/*         pcrf        - client register frame pointer                */
/*                                                                    */
/* EXIT-NORMAL:  NONE                                                 */
/*                                                                    */
/* EXIT-ERROR:  NONE                                                  */
/*                                                                    */
/* EFFECTS:  NONE                                                     */
/*                                                                    */
/* INTERNAL REFERENCES:  doOpenDirect                                 */
/*                                                                    */
/* EXTERNAL REFERENCES:  NONE                                         */
/*                                                                    */
/************************ END OF SPECIFICATIONS ***********************/
VOID HOOKENTRY VLPT1StOut(chartowrite, portaddr, pcrf)
BYTE chartowrite;
ULONG portaddr;
PCRF pcrf;
{

#ifdef DEBUG
   vdhInt3();
#endif
    /*---------------------------------------------------------------*/
    /*- Call to set up direct access mode for the port address      -*/
    /*- passed in.                                                  -*/
    /*---------------------------------------------------------------*/
    doOpenDirect(&pvd_area[LPTONE]);

    /*---------------------------------------------------------------*/
    /*- If direct I/O access mode was granted all future I/O to the -*/
    /*- status port will go directly to the port. Now do an OUT to  -*/
    /*- satisfy the application that caused this routine to be      -*/
    /*- executed.                                                   -*/
    /*---------------------------------------------------------------*/
    if (pvd_area[LPTONE].flags & DIRECT_MODE_FLAG) {

        OUTB(portaddr,chartowrite);

    } /* endif */

    return;

}

/********************** START OF SPECIFICATIONS ***********************/
/*                                                                    */
/* SUBROUTINE NAME:  VLPT2StOut                                       */
/*                                                                    */
/* DESCRIPTIVE NAME:  LPT2 Status Port OUT Instruction Handler        */
/*                                                                    */
/* FUNCTION:  The function of this routine is to service the VDM      */
/*            OUT instruction for LPT2 if the OUT to the status port  */
/*            is the first occurrence of I/O. If it is not the        */
/*            first occurrence then the hook for this port will       */
/*            have been disabled. This routine requests I/O direct    */
/*            mode and if successful does the OUT instruction.        */
/*                                                                    */
/* NOTES:  VLPT2StOut currently handles byte instructions only.       */
/*         See vlptp.h for bit-level detail of the status port.       */
/*                                                                    */
/* CONTEXT: VDM task time                                             */
/*                                                                    */
/* ENTRY POINT:  VLPT2StOut                                           */
/*    LINKAGE:  CALL NEAR 32                                          */
/*                                                                    */
/* INPUT:  (PARAMETERS)  (passed on the stack)                        */
/*         chartowrite - data to write                                */
/*         portaddr    - port address                                 */
/*         pcrf        - client register frame pointer                */
/*                                                                    */
/* EXIT-NORMAL:  NONE                                                 */
/*                                                                    */
/* EXIT-ERROR:  NONE                                                  */
/*                                                                    */
/* EFFECTS:  NONE                                                     */
/*                                                                    */
/* INTERNAL REFERENCES:  doOpenDirect                                 */
/*                                                                    */
/* EXTERNAL REFERENCES:  NONE                                         */
/*                                                                    */
/************************ END OF SPECIFICATIONS ***********************/
VOID HOOKENTRY VLPT2StOut(chartowrite, portaddr, pcrf)
BYTE chartowrite;
ULONG portaddr;
PCRF pcrf;
{

#ifdef DEBUG
   vdhInt3();
#endif
    /*---------------------------------------------------------------*/
    /*- Call to set up direct access mode for the port address      -*/
    /*- passed in.                                                  -*/
    /*---------------------------------------------------------------*/
    doOpenDirect(&pvd_area[LPTTWO]);

    /*---------------------------------------------------------------*/
    /*- If direct I/O access mode was granted all future I/O to the -*/
    /*- status port will go directly to the port. Now do an OUT to  -*/
    /*- satisfy the application that caused this routine to be      -*/
    /*- executed.                                                   -*/
    /*---------------------------------------------------------------*/
    if (pvd_area[LPTTWO].flags & DIRECT_MODE_FLAG) {

        OUTB(portaddr,chartowrite);

    } /* endif */

    return;

}

/********************** START OF SPECIFICATIONS ***********************/
/*                                                                    */
/* SUBROUTINE NAME:  VLPT3StOut                                       */
/*                                                                    */
/* DESCRIPTIVE NAME:  LPT3 Status Port OUT Instruction Handler        */
/*                                                                    */
/* FUNCTION:  The function of this routine is to service the VDM      */
/*            OUT instruction for LPT3 if the OUT to the status port  */
/*            is the first occurrence of I/O. If it is not the        */
/*            first occurrence then the hook for this port will       */
/*            have been disabled. This routine requests I/O direct    */
/*            mode and if successful does the OUT instruction.        */
/*                                                                    */
/* NOTES:  VLPT3StOut currently handles byte instructions only.       */
/*         See vlptp.h for bit-level detail of the status port.       */
/*                                                                    */
/* CONTEXT: VDM task time                                             */
/*                                                                    */
/* ENTRY POINT:  VLPT3StOut                                           */
/*    LINKAGE:  CALL NEAR 32                                          */
/*                                                                    */
/* INPUT:  (PARAMETERS)  (passed on the stack)                        */
/*         chartowrite - data to write                                */
/*         portaddr    - port address                                 */
/*         pcrf        - client register frame pointer                */
/*                                                                    */
/* EXIT-NORMAL:  NONE                                                 */
/*                                                                    */
/* EXIT-ERROR:  NONE                                                  */
/*                                                                    */
/* EFFECTS:  NONE                                                     */
/*                                                                    */
/* INTERNAL REFERENCES:  doOpenDirect                                 */
/*                                                                    */
/* EXTERNAL REFERENCES:  NONE                                         */
/*                                                                    */
/************************ END OF SPECIFICATIONS ***********************/
VOID HOOKENTRY VLPT3StOut(chartowrite, portaddr, pcrf)
BYTE chartowrite;
ULONG portaddr;
PCRF pcrf;
{

#ifdef DEBUG
   vdhInt3();
#endif
    /*---------------------------------------------------------------*/
    /*- Call to set up direct access mode for the port address      -*/
    /*- passed in.                                                  -*/
    /*---------------------------------------------------------------*/
    doOpenDirect(&pvd_area[LPTTHREE]);

    /*---------------------------------------------------------------*/
    /*- If direct I/O access mode was granted all future I/O to the -*/
    /*- status port will go directly to the port. Now do an OUT to  -*/
    /*- satisfy the application that caused this routine to be      -*/
    /*- executed.                                                   -*/
    /*---------------------------------------------------------------*/
    if (pvd_area[LPTTHREE].flags & DIRECT_MODE_FLAG) {

        OUTB(portaddr,chartowrite);

    } /* endif */

    return;

}

/********************** START OF SPECIFICATIONS ***********************/
/*                                                                    */
/* SUBROUTINE NAME:  VLPT1CoOut                                       */
/*                                                                    */
/* DESCRIPTIVE NAME:  LPT1 Control Port OUT Instruction Handler       */
/*                                                                    */
/* FUNCTION:  The function of this routine is to service the VDM      */
/*            OUT instructions for LPT1 control port. If this OUT     */
/*            is the first occurrence of I/O then direct I/O access   */
/*            is requested.                                           */
/*                                                                    */
/* NOTES:  VLPT1CoOut currently handles byte instructions only.       */
/*         See vlptp.h for bit-level detail of the control port.      */
/*                                                                    */
/* CONTEXT: VDM task time                                             */
/*                                                                    */
/* ENTRY POINT:  VLPT1CoOut                                           */
/*    LINKAGE:  CALL NEAR 32                                          */
/*                                                                    */
/* INPUT:  (PARAMETERS)  (passed on the stack)                        */
/*         chartowrite - data to write                                */
/*         portaddr    - port address                                 */
/*         pcrf        - client register frame pointer                */
/*                                                                    */
/* EXIT-NORMAL:  NONE                                                 */
/*                                                                    */
/* EXIT-ERROR:  NONE                                                  */
/*                                                                    */
/* EFFECTS:  NONE                                                     */
/*                                                                    */
/* INTERNAL REFERENCES:  doOpenDirect                                 */
/*                                                                    */
/* EXTERNAL REFERENCES:  NONE                                         */
/*                                                                    */
/************************ END OF SPECIFICATIONS ***********************/
VOID HOOKENTRY VLPT1CoOut(chartowrite, portaddr, pcrf)
BYTE chartowrite;
ULONG portaddr;
PCRF pcrf;
{

#ifdef DEBUG
     vdhInt3();
#endif
    /*---------------------------------------------------------------*/
    /*- Call to set up direct access mode for the port address      -*/
    /*- passed in.                                                  -*/
    /*---------------------------------------------------------------*/
    doOpenDirect(&pvd_area[LPTONE]);

    /*---------------------------------------------------------------*/
    /*- If direct I/O access mode was granted do an OUT to the      -*/
    /*- control port to satisfy the application that caused this    -*/
    /*- routine to be executed.                                     -*/
    /*---------------------------------------------------------------*/
    if (pvd_area[LPTONE].flags & DIRECT_MODE_FLAG) {

      OUTB(portaddr,chartowrite);

    } /* endif */

    return;

}

/********************** START OF SPECIFICATIONS ***********************/
/*                                                                    */
/* SUBROUTINE NAME:  VLPT2CoOut                                       */
/*                                                                    */
/* DESCRIPTIVE NAME:  LPT2 Control Port OUT Instruction Handler       */
/*                                                                    */
/* FUNCTION:  The function of this routine is to service the VDM      */
/*            OUT instructions for LPT2 control port. If this OUT     */
/*            is the first occurrence of I/O then direct I/O access   */
/*            is requested.                                           */
/*                                                                    */
/* NOTES:  VLPT2CoOut currently handles byte instructions only.       */
/*         See vlptp.h for bit-level detail of the control port.      */
/*                                                                    */
/* CONTEXT: VDM task time                                             */
/*                                                                    */
/* ENTRY POINT:  VLPT2CoOut                                           */
/*    LINKAGE:  CALL NEAR 32                                          */
/*                                                                    */
/* INPUT:  (PARAMETERS)  (passed on the stack)                        */
/*         chartowrite - data to write                                */
/*         portaddr    - port address                                 */
/*         pcrf        - client register frame pointer                */
/*                                                                    */
/* EXIT-NORMAL:  NONE                                                 */
/*                                                                    */
/* EXIT-ERROR:  NONE                                                  */
/*                                                                    */
/* EFFECTS:  NONE                                                     */
/*                                                                    */
/* INTERNAL REFERENCES:  doOpenDirect                                 */
/*                                                                    */
/* EXTERNAL REFERENCES:  NONE                                         */
/*                                                                    */
/************************ END OF SPECIFICATIONS ***********************/
VOID HOOKENTRY VLPT2CoOut(chartowrite, portaddr, pcrf)
BYTE chartowrite;
ULONG portaddr;
PCRF pcrf;
{

#ifdef DEBUG
     vdhInt3();
#endif
    /*---------------------------------------------------------------*/
    /*- Call to set up direct access mode for the port address      -*/
    /*- passed in.                                                  -*/
    /*---------------------------------------------------------------*/
    doOpenDirect(&pvd_area[LPTTWO]);

    /*---------------------------------------------------------------*/
    /*- If direct I/O access mode was granted do an OUT to the      -*/
    /*- control port to satisfy the application that caused this    -*/
    /*- routine to be executed.                                     -*/
    /*---------------------------------------------------------------*/
    if (pvd_area[LPTTWO].flags & DIRECT_MODE_FLAG) {

      OUTB(portaddr,chartowrite);

    } /* endif */

    return;

}

/********************** START OF SPECIFICATIONS ***********************/
/*                                                                    */
/* SUBROUTINE NAME:  VLPT3CoOut                                       */
/*                                                                    */
/* DESCRIPTIVE NAME:  LPT3 Control Port OUT Instruction Handler       */
/*                                                                    */
/* FUNCTION:  The function of this routine is to service the VDM      */
/*            OUT instructions for LPT3 control port. If this OUT     */
/*            is the first occurrence of I/O then direct I/O access   */
/*            is requested.                                           */
/*                                                                    */
/* NOTES:  VLPT3CoOut currently handles byte instructions only.       */
/*         See vlptp.h for bit-level detail of the control port.      */
/*                                                                    */
/* CONTEXT: VDM task time                                             */
/*                                                                    */
/* ENTRY POINT:  VLPT3CoOut                                           */
/*    LINKAGE:  CALL NEAR 32                                          */
/*                                                                    */
/* INPUT:  (PARAMETERS)  (passed on the stack)                        */
/*         chartowrite - data to write                                */
/*         portaddr    - port address                                 */
/*         pcrf        - client register frame pointer                */
/*                                                                    */
/* EXIT-NORMAL:  NONE                                                 */
/*                                                                    */
/* EXIT-ERROR:  NONE                                                  */
/*                                                                    */
/* EFFECTS:  NONE                                                     */
/*                                                                    */
/* INTERNAL REFERENCES:  doOpenDirect                                 */
/*                                                                    */
/* EXTERNAL REFERENCES:  NONE                                         */
/*                                                                    */
/************************ END OF SPECIFICATIONS ***********************/
VOID HOOKENTRY VLPT3CoOut(chartowrite, portaddr, pcrf)
BYTE chartowrite;
ULONG portaddr;
PCRF pcrf;
{

#ifdef DEBUG
     vdhInt3();
#endif
    /*---------------------------------------------------------------*/
    /*- Call to set up direct access mode for the port address      -*/
    /*- passed in.                                                  -*/
    /*---------------------------------------------------------------*/
    doOpenDirect(&pvd_area[LPTTHREE]);

    /*---------------------------------------------------------------*/
    /*- If direct I/O access mode was granted do an OUT to the      -*/
    /*- control port to satisfy the application that caused this    -*/
    /*- routine to be executed.                                     -*/
    /*---------------------------------------------------------------*/
    if (pvd_area[LPTTHREE].flags & DIRECT_MODE_FLAG) {

      OUTB(portaddr,chartowrite);

    } /* endif */

    return;

}

/********************** START OF SPECIFICATIONS ***********************/
/*                                                                    */
/* SUBROUTINE NAME:  VLPTResOut                                       */
/*                                                                    */
/* DESCRIPTIVE NAME:  LPT Reserve Port OUT Instruction Handler        */
/*                                                                    */
/* FUNCTION:  The function of this routine is to service the VDM      */
/*            OUT instruction for all LPT reserve ports. It           */
/*            simply returns.                                         */
/*                                                                    */
/* NOTES:  VLPTResOut currently handles byte instructions only.       */
/*                                                                    */
/* CONTEXT: VDM task time                                             */
/*                                                                    */
/* ENTRY POINT:  VLPTResOut                                           */
/*    LINKAGE:  CALL NEAR 32                                          */
/*                                                                    */
/* INPUT:  (PARAMETERS)  (passed on the stack)                        */
/*         chartowrite - data to write                                */
/*         portaddr    - port address                                 */
/*         pcrf        - client register frame pointer                */
/*                                                                    */
/* EXIT-NORMAL:  NONE                                                 */
/*                                                                    */
/* EXIT-ERROR:  NONE                                                  */
/*                                                                    */
/* EFFECTS:  NONE                                                     */
/*                                                                    */
/* INTERNAL REFERENCES:  NONE                                         */
/*                                                                    */
/* EXTERNAL REFERENCES:  NONE                                         */
/*                                                                    */
/************************ END OF SPECIFICATIONS ***********************/
VOID HOOKENTRY VLPTResOut(chartowrite, portaddr, pcrf)
BYTE chartowrite;
ULONG portaddr;
PCRF pcrf;
{

#ifdef DEBUG
   vdhInt3();
#endif

    /*---------------------------------------------------------------*/
    /*- OUT instructions to reserve ports are not supported.        -*/
    /*---------------------------------------------------------------*/
    return ;
}

#pragma END_SWAP_CODE
