/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT (C) Microsoft Corporation, 1989                                 */
/* COPYRIGHT    Copyright (C) 1992 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 source code is provided to you solely for       */
/*    the purpose of assisting you in your development of OS/2 device        */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Developer Connection Device Driver       */
/*    Source Kit for OS/2. This Copyright statement may not be removed.      */
/*                                                                           */
/*****************************************************************************/
/*static char *SCCSID = "@(#)vlptdata.h 6.8 92/03/20";*/
#pragma linesize(132)
#pragma pagesize(60)
#pragma title("VLPTDATA.H")
/****************************************************************************/
/*                                                                          */
/*                                                                          */
/*                                                                          */
/****************************************************************************/
/************************** START OF SPECIFICATIONS ***************************/
/*                                                                            */
/*   SOURCE FILE NAME:  VLPTDATA.H                                            */
/*                                                                            */
/*   DESCRIPTIVE NAME:  VLPT external data                                    */
/*                                                                            */
/*   FUNCTION: This routine sets up the externs to match the instance data    */
/*             area and the global data area for VLPT.                        */
/*                                                                            */
/*   NOTES:                                                                   */
/*      DEPENDENCIES: Any data structure changes made to VLPTDATA.C must      */
/*                    also be changed in this file. VLPTDATA.C contains       */
/*                    the data that this file makes into external data.       */
/*      RESTRICTIONS: None                                                    */
/*                                                                            */
/*   ENTRY POINTS:                                                            */
/*             None                                                           */
/*                                                                            */
/*   EXTERNAL REFERENCES:                                                     */
/*             None                                                           */
/*                                                                            */
/**************************** END OF SPECIFICATIONS ***************************/

#pragma BEGIN_SWAP_INSTANCE

extern struct instance_data pvd_area[];    /* per VDM data area            */
extern HVDM this_VDM;                      /*  actual VDM handle           */
extern UINT resp_val;                      /*  response value from popup   */
extern HVDHSEM vlpt_sem_handle;            /*  semaphore handle for delays */
extern PCHAR lptname;                      /* device name prefix           */
extern HHOOK hhookVLPTIRet5;               /* handle for VDHArmReturnHook  */
extern VLPTPDB pdbCurrent;                 /* current PDB,Process Data Blk.*/
extern ULONG nmsLptTimeout;                /* per vdm lpt starting value   */
extern FLAGS VLPTFlags;                    /* VLPT flags (see vlptp.h)     */

#pragma END_SWAP_INSTANCE

#pragma BEGIN_SWAP_DATA

extern ULONG ulbuffersize[];                    /* Size of print data bffr */
extern HVDD hvddvbios;                          /* Addr. of VBIOS entry pt.*/
extern PPOSREGS pvddvbiospos;                   /* Address of POS Regs     */
extern ULONG MachineType;                       /* Machine Type            */
extern FPFNPDD PLPTPDDProc;                     /* addr of PDD entry point */
extern struct port_address vpa_table[];         /* VLPT port address table */
extern struct error_table_record other_table[];  /* OTHER error table      */
extern struct error_table_record direct_table[]; /* DIRECT error table     */
extern struct vlpt_ioh_table_s v_ioh[];          /*   LPT IO handler table */

#pragma END_SWAP_DATA
