/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1992 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 source code is provided to you solely for       */
/*    the purpose of assisting you in your development of OS/2 device        */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Developer Connection Device Driver       */
/*    Source Kit for OS/2. This Copyright statement may not be removed.      */
/*                                                                           */
/*****************************************************************************/
/*static char *SCCSID = "@(#)vkbdxtbl.h    1.00 92/04/30";*/
/***    Virtual Keyboard Device Driver (VKBD)
 *
 *      SCCSID = @(#)vkbdxtbl.h    1.00 92/04/30
 *
 *
 *
 *
 *      VKBD private tables for JDOS and PC-DOS VDM
 *
 *      Include file hierarchy:
 *           includer   : VKBD.C
 *
 *      MODIFICATION HISTORY
 *           4/30/92  Sonny          : first issue
 *          10/22/92  Masanobu Ida   : AH=06H support for DOS BUNSHO III (j-mi1022)
 *          11/19/92  j-@mh01        : J3100 support
 *           2/26/93  j-mi02         : JS05096 - data for INT16H AH=14H, AL=01H
 *           6/02/93  j-ki01         : JS05401 - OHTOU key doesn't work on DOS/BUNSHO
 */

//
//          Xlation Table : from 81h to 8Ah
//
BYTE    ToEpoch[256] =
                { 0x00, 0x3D, 0x24, 0x25, 0x26, 0x27, 0x28, 0x29,
                  0x2A, 0x2B, 0x2C, 0x2D, 0x2E, 0x2F, 0x3E, 0x3C,
                  0x18, 0x19, 0x1A, 0x1B, 0x1C, 0x1D, 0x1E, 0x1F,
                  0x20, 0x21, 0x23, 0x17, 0x3B, 0x41, 0x0C, 0x0D,
                  0x0E, 0x0F, 0x10, 0x11, 0x12, 0x13, 0x14, 0x15,
                  0x16, 0x22, 0x38, 0x30, 0x01, 0x02, 0x03, 0x04,
                  0x05, 0x06, 0x07, 0x08, 0x09, 0x0A, 0x39, 0x64,
                  0x31, 0x34, 0x32, 0x68, 0x69, 0x6A, 0x6B, 0x6C,
                  0x6D, 0x6E, 0x6F, 0x70, 0x71, 0x75, 0x75, 0x5D,
                  0x5E, 0x5F, 0x67, 0x5A, 0x5B, 0x5C, 0x63, 0x57,
                  0x58, 0x59, 0x55, 0x56, 0x00, 0x40, 0x00, 0x72,
                  0x73, 0x00, 0x7E, 0x76, 0x77, 0x78, 0x7F, 0x00,
                  0x00, 0x00, 0x00, 0x79, 0x7A, 0x7B, 0x7D, 0x42,
                  0x43, 0x44, 0x46, 0x51, 0x49, 0x7C, 0x00, 0x00,
                  0x3A, 0x00, 0x00, 0x0B, 0x00, 0x00, 0x48, 0x45,
                  0x00, 0x35, 0x00, 0x33, 0x00, 0x00, 0x00, 0x00,
                  0x80, 0x81, 0x82, 0x83, 0x84, 0x85, 0x86, 0x87,
                  0x88, 0x89, 0x8A, 0x8B, 0x8C, 0x8D, 0x8E, 0x8F,
                  0x90, 0x91, 0x92, 0x93, 0x94, 0x95, 0x96, 0x97,
                  0x98, 0x99, 0x9A, 0x9B, 0x9C, 0x9D, 0x9E, 0x9F,
                  0xA0, 0xA1, 0xA2, 0xA3, 0xA4, 0xA5, 0xA6, 0xA7,
                  0xA8, 0xA9, 0xAA, 0xAB, 0xAC, 0xAD, 0xAE, 0xAF,
                  0xB0, 0xB1, 0xB2, 0xB3, 0xB4, 0xB5, 0xB6, 0xB7,
                  0xB8, 0xB9, 0xBA, 0xBB, 0xBC, 0xBD, 0xBE, 0xBF,
                  0xC0, 0xC1, 0xC2, 0xC3, 0xC4, 0xC5, 0xC6, 0xC7,
                  0xC8, 0xC9, 0xCA, 0xCB, 0xCC, 0xCD, 0xCE, 0xCF,
                  0xD0, 0xD1, 0xD2, 0xD3, 0xD4, 0xD5, 0xD6, 0xD7,
                  0xD8, 0xD9, 0xDA, 0xDB, 0xDC, 0xDD, 0xDE, 0xDF,
                  0xE0, 0xE1, 0xE2, 0xE3, 0xE4, 0xE5, 0xE6, 0xE7,
                  0xE8, 0xE9, 0xEA, 0xEB, 0xEC, 0xED, 0xEE, 0xEF,
                  0xF0, 0xF1, 0xF2, 0xF3, 0xF4, 0xF5, 0xF6, 0xF7,
                  0xF8, 0xF9, 0xFA, 0xFB, 0xFC, 0xFD, 0xFE, 0xFF };

BYTE    ToEpochExt[256] =
                { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                  0x00, 0x00, 0x00, 0x00, 0x60, 0x37, 0x00, 0x00,
                  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                  0x00, 0x00, 0x00, 0x66, 0x00, 0x65, 0x00, 0x74,
                  0x36, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
//j-ki01          0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x47, 0x4C,
                  0x00, 0x00, 0x00, 0x00, 0x00, 0x47, 0x47, 0x4C, //j-ki01
                  0x4E, 0x52, 0x00, 0x4B, 0x00, 0x4D, 0x00, 0x53,
                  0x4A, 0x54, 0x4F, 0x50, 0x00, 0x00, 0x00, 0x00,
                  0x00, 0x00, 0x7E, 0x76, 0x00, 0x78, 0x7F, 0x00,
                  0x00, 0x00, 0x00, 0x79, 0x7A, 0x7B, 0x7D, 0x42,
                  0x00, 0x44, 0x46, 0x51, 0x00, 0x7C, 0x00, 0x00,
                  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x48, 0x00,
                  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                  0x80, 0x81, 0x82, 0x83, 0x84, 0x85, 0x86, 0x87,
                  0x88, 0x89, 0x8A, 0x8B, 0x8C, 0x8D, 0x8E, 0x8F,
                  0x90, 0x91, 0x92, 0x93, 0x94, 0x95, 0x96, 0x97,
                  0x98, 0x99, 0x9A, 0x9B, 0x9C, 0x9D, 0x9E, 0x9F,
                  0xA0, 0xA1, 0xA2, 0xA3, 0xA4, 0xA5, 0xA6, 0xA7,
                  0xA8, 0xA9, 0xAA, 0xAB, 0xAC, 0xAD, 0xAE, 0xAF,
                  0xB0, 0xB1, 0xB2, 0xB3, 0xB4, 0xB5, 0xB6, 0xB7,
                  0xB8, 0xB9, 0xBA, 0xBB, 0xBC, 0xBD, 0xBE, 0xBF,
                  0xC0, 0xC1, 0xC2, 0xC3, 0xC4, 0xC5, 0xC6, 0xC7,
                  0xC8, 0xC9, 0xCA, 0xCB, 0xCC, 0xCD, 0xCE, 0xCF,
                  0xD0, 0xD1, 0xD2, 0xD3, 0xD4, 0xD5, 0xD6, 0xD7,
                  0xD8, 0xD9, 0xDA, 0xDB, 0xDC, 0xDD, 0xDE, 0xDF,
                  0xE0, 0xE1, 0xE2, 0xE3, 0xE4, 0xE5, 0xE6, 0xE7,
                  0xE8, 0xE9, 0xEA, 0xEB, 0xEC, 0xED, 0xEE, 0xEF,
                  0xF0, 0xF1, 0xF2, 0xF3, 0xF4, 0xF5, 0xF6, 0xF7,
                  0xF8, 0xF9, 0xFA, 0xFB, 0xFC, 0xFD, 0xFE, 0xFF };

//
//       8A KeyTypeTable : 0x00 - TypaMatic Key (M,  MBBBBB)
//                         0x01 - MakeBreak Key (MB, M....B)
//                         0x02 - MakeOnly  Key (M,  M.....)
//
//                         Index : 0x00 - 0x7F .PrimaryKey
//                                 0x80 - 0xFF .SecondaryKey
//
BYTE    ScanType[256] =
                { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                  0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00,
                  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                  0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00,
                  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00,
                  0x01, 0x00, 0x01, 0x02, 0x02, 0x02, 0x02, 0x02,
                  0x02, 0x02, 0x02, 0x02, 0x02, 0x01, 0x01, 0x00,
                  0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x02, 0x00,
                  0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x02,
                  0x02, 0x00, 0x02, 0x02, 0x02, 0x02, 0x02, 0x00,
                  0x00, 0x00, 0x00, 0x02, 0x02, 0x02, 0x02, 0x01,
                  0x01, 0x02, 0x02, 0x00, 0x02, 0x02, 0x00, 0x00,
                  0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x01,
                  0x00, 0x02, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00,

                  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                  0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00,
                  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
//ss0020          0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02,
                  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01,
                  0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x02,
                  0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x02,
                  0x00, 0x00, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00,
                  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                  0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00,
                  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,};


//
//          Xlation Table : from 81h to 8Ah
//
BYTE    ToEpoch16[256] =
                { 0x00, 0x3D, 0x24, 0x25, 0x26, 0x27, 0x28, 0x29,
                  0x2A, 0x2B, 0x2C, 0x2D, 0x2E, 0x2F, 0x3E, 0x3C,
                  0x18, 0x19, 0x1A, 0x1B, 0x1C, 0x1D, 0x1E, 0x1F,
                  0x20, 0x21, 0x23, 0x17, 0x3B, 0x41, 0x0C, 0x0D,
                  0x0E, 0x0F, 0x10, 0x11, 0x12, 0x13, 0x14, 0x15,
                  0x16, 0x22, 0x38, 0x30, 0x01, 0x02, 0x03, 0x04,
                  0x05, 0x06, 0x07, 0x08, 0x09, 0x0A, 0x39, 0x64,
                  0x31, 0x34, 0x32, 0x3B, 0x3C, 0x3D, 0x3E, 0x3F,
                  0x40, 0x41, 0x42, 0x43, 0x44, 0x00, 0x75, 0x5D,
                  0x5E, 0x5F, 0x67, 0x5A, 0x5B, 0x5C, 0x63, 0x57,
                  0x58, 0x59, 0x55, 0x56, 0x00, 0x98, 0x00, 0x54,
                  0x55, 0x00, 0x7E, 0x76, 0x99, 0x78, 0x7F, 0x00,
                  0x00, 0x00, 0x00, 0x79, 0x7A, 0x7B, 0x7D, 0x42,
//ss0034          0xFF, 0x44, 0x46, 0x51, 0x49, 0x7C, 0x00, 0x00,
//ss0034          0xFF, 0x00, 0x00, 0x0B, 0x00, 0x00, 0x48, 0x45,
                  0x68, 0x44, 0x46, 0x51, 0x49, 0x7C, 0x00, 0x00,
                  0x70, 0x00, 0x00, 0x0B, 0x00, 0x00, 0x48, 0x45,
                  0x00, 0x35, 0x00, 0x33, 0x00, 0x00, 0x00, 0x00,
//ss0034          0x80, 0x81, 0x82, 0x83, 0x84, 0xFF, 0xFF, 0x87,
//ss0034          0x88, 0x89, 0x8A, 0x8B, 0x8C, 0x8D, 0x8E, 0x8F,
                  0x80, 0x81, 0x82, 0x83, 0x84, 0x54, 0x55, 0x5E,
                  0x5F, 0x68, 0x69, 0x8B, 0x8C, 0x8D, 0x8E, 0x8F,
//ss0034          0x90, 0x91, 0x92, 0x93, 0x94, 0x95, 0x96, 0x97,
//ss0034          0x98, 0x99, 0x9A, 0x9B, 0x9C, 0x9D, 0x9E, 0x9F,
                  0x90, 0x91, 0x92, 0x93, 0x94, 0x95, 0x96, 0xFF,
                  0xFF, 0xFF, 0x9A, 0xFF, 0x9C, 0xFF, 0x9E, 0x9F,

//ss0020          0xA0, 0xA1, 0xA2, 0xA3, 0xA4, 0xA5, 0xA6, 0xA7,
//ss0020          0xA8, 0xA9, 0xAA, 0xAB, 0xAC, 0xAD, 0xAE, 0xFF,
//ss0034          0xA0, 0xA1, 0xA2, 0xA3, 0xA4, 0xA5, 0xA6, 0x35,
                  0xFF, 0xFF, 0xFF, 0xFF, 0xA4, 0xA5, 0xA6, 0x35,
                  0x35, 0x35, 0x35, 0x33, 0x33, 0x33, 0x33, 0xFF,

                  0xFF, 0xFF, 0xFF, 0xB3, 0xB4, 0xB5, 0xB6, 0xFF,
                  0xB8, 0xB9, 0xBA, 0xBB, 0xBC, 0xBD, 0xBE, 0xBF,
                  0xC0, 0xC1, 0xC2, 0xC3, 0xC4, 0xC5, 0xC6, 0xC7,
                  0xC8, 0xC9, 0xCA, 0xCB, 0xCC, 0xCD, 0xCE, 0xCF,
                  0xD0, 0xD1, 0xD2, 0xD3, 0xD4, 0xD5, 0xD6, 0xD7,
                  0xD8, 0xD9, 0xDA, 0xDB, 0xDC, 0xDD, 0xDE, 0xDF,
                  0xE0, 0xE1, 0xE2, 0xE3, 0xE4, 0xE5, 0xE6, 0xE7,
                  0xE8, 0xE9, 0xEA, 0xEB, 0xEC, 0xED, 0xEE, 0xEF,
                  0xF0, 0xF1, 0xF2, 0xF3, 0xFF, 0xF5, 0xF6, 0xF7,
                  0xFF, 0xF9, 0xFA, 0xFF, 0xFC, 0xFD, 0xFE, 0xFF };

BYTE    ToEpochExt16[256] =
//              { 0x00, 0x3D, 0x24, 0x25, 0x26, 0x27, 0x28, 0x29,
//                0x2A, 0x2B, 0x2C, 0x2D, 0x2E, 0x2F, 0x3E, 0x3C,
//                0x18, 0x19, 0x1A, 0x1B, 0x1C, 0x1D, 0x1E, 0x1F,
//                0x20, 0x21, 0x23, 0x17, 0x60, 0x93, 0x0C, 0x0D,
//                0x0E, 0x0F, 0x10, 0x11, 0x12, 0x13, 0x14, 0x15,
//                0x16, 0x22, 0x38, 0x30, 0x01, 0x02, 0x03, 0x04,
//                0x05, 0x06, 0x07, 0x66, 0x09, 0x65, 0x00, 0x74,

                { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                  0x00, 0x00, 0x00, 0x00, 0x60, 0x93, 0x00, 0x00,
                  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                  0x00, 0x00, 0x00, 0x66, 0x00, 0x65, 0x00, 0x74,
                  0x36, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x47, 0x47,
                  0x48, 0x49, 0x00, 0x4B, 0x00, 0x4D, 0x00, 0x4F,
                  0x50, 0x51, 0x52, 0x53, 0x00, 0x00, 0x00, 0x00,
                  0x00, 0x00, 0x7E, 0x76, 0x00, 0x78, 0x7F, 0x00,
                  0x00, 0x00, 0x00, 0x79, 0x7A, 0x7B, 0x7D, 0x42,
                  0x97, 0x44, 0x46, 0xFF, 0x00, 0x7C, 0x00, 0x00,
                  0x97, 0x00, 0x00, 0x73, 0x74, 0x75, 0x76, 0x75,
                  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                  0x80, 0x81, 0x82, 0x83, 0x84, 0x54, 0x55, 0x87,
                  0x88, 0x89, 0x8A, 0x8B, 0x8C, 0x84, 0x8E, 0x8F,
                  0x90, 0x76, 0x92, 0x93, 0x94, 0x95, 0x96, 0x4F,
//ss0034          0x98, 0x99, 0x9A, 0x9C, 0x9C, 0x9D, 0x9E, 0x9F,
//ss0034          0x51, 0xA1, 0xA2, 0xA3, 0xA4, 0xA5, 0xA6, 0xA7,
                  0x49, 0x99, 0x9A, 0x9C, 0x9C, 0x9D, 0x9E, 0x9F,
//ss0035          0x51, 0xA1, 0xA2, 0xA3, 0xA4, 0xA5, 0xA6, 0xA7,
//ss0035          0xA8, 0xA9, 0xAA, 0xAB, 0xAC, 0xAD, 0xAE, 0x93,
                  0x51, 0xA1, 0xA2, 0xA3, 0xA4, 0xA5, 0xA6, 0x92,
                  0x92, 0x85, 0x90, 0x91, 0x91, 0x86, 0x96, 0x93,

//ss0022          0x93, 0xA6, 0xFF, 0xB3, 0xB4, 0xB5, 0xB6, 0x99,
                  0x93, 0xB1, 0xA6, 0xB3, 0xB4, 0xB5, 0xB6, 0x99,

                  0xB8, 0xB9, 0xBA, 0xBB, 0xBC, 0xBD, 0xBE, 0xBF,
                  0xC0, 0xC1, 0xC2, 0xC3, 0xC4, 0xC5, 0xC6, 0xC7,
                  0xC8, 0xC9, 0xCA, 0xCB, 0xCC, 0xCD, 0xCE, 0xCF,
                  0xD0, 0xD1, 0xD2, 0xD3, 0xD4, 0xD5, 0xD6, 0xD7,
                  0xD8, 0xD9, 0xDA, 0xDB, 0xDC, 0xDD, 0xDE, 0xDF,
                  0xE0, 0xE1, 0xE2, 0xE3, 0xE4, 0xE5, 0xE6, 0xE7,
                  0xE8, 0xE9, 0xEA, 0xEB, 0xEC, 0xED, 0xEE, 0xEF,
                  0xF0, 0xF1, 0xF2, 0xF3, 0x9A, 0xF5, 0xF6, 0xF7,
                  0x98, 0xF9, 0xFA, 0x77, 0xFC, 0xFD, 0xFE, 0xFF };

//
//          Xlation Table : from 81h to 01h
//                          (char code to scan code for PC-DOS VDM)
//
BYTE    ToSC01[128] =
                { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                  0x00, 0x02, 0x28, 0x04, 0x05, 0x06, 0x08, 0x28,

#ifdef   J3100                                                       //j-@mh01
                  0x0A, 0x0B, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00,    //j-@mh01
#else                                                                //j-@mh01
                  0x0A, 0x0B, 0x09, 0x0D, 0x33, 0x0C, 0x34, 0x35,
#endif                                                               //j-@mh01

                  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                  0x00, 0x00, 0x27, 0x27, 0x33, 0x0D, 0x34, 0x35,
                  0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

#ifdef   J3100                                                       //j-@mh01
                  0x00, 0x00, 0x00, 0x1A, 0x00, 0x1B, 0x07, 0x0C,    //j-@mh01
#else                                                                //j-@mh01
                  0x00, 0x00, 0x00, 0x1A, 0x2B, 0x1B, 0x07, 0x0C,
#endif                                                               //j-@mh01

                  0x29, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

#ifdef   J3100                                                       //j-@mh01
                  0x00, 0x00, 0x00, 0x1A, 0x00, 0x1B, 0x29, 0x00 };  //j-@mh01
#else                                                                //j-@mh01
                  0x00, 0x00, 0x00, 0x1A, 0x2B, 0x1B, 0x29, 0x00 };
#endif                                                               //j-@mh01


//
//          Key Translation Table      (for INT 16H AH=06H)
//
//          Shift key (08/88)
SHIFTTBL dos_shifttable[] =
        { { 0x31,     0x0040,0x0040,0x0040,0x0040 },    //ALT KEY
          { 0x41,     0x0010,0x0010,0x0010,0x0010 },    //CTRL KEY
          { 0x41+0x80,0x0020,0x0020,0x0020,0x0020 },    //CTRL BREAK
          { 0x38,     0x0004,0x0004,0x0004,0x0004 },    //LEFT SHIFT
          { 0x38+0x80,0x0008,0x0008,0x0008,0x0008 },    //L-SHIFT BREAK
          { 0x39,     0x0001,0x0001,0x0001,0x0001 },    //RIGHT SHIFT
          { 0x39+0x80,0x0002,0x0002,0x0002,0x0002 },    //R-SHIFT BREAK
          { 0x37+0x80,0x0000,0x0000,0x0000,0x0000 },    //ENTER BREAK
          { 0x32+0x80,0x0000,0x0000,0x0000,0x0000 },    //ALPHA BREAK
          { 0x3A+0x80,0x0000,0x0000,0x0000,0x0000 },    //KATA BREAK
          { 0x36+0x80,0x0000,0x0000,0x0000,0x0000 },    //HIRA BREAK
          { 0x32,     0x8300,0x4000,0x4000,0x9000 },    //ALPHA KEY
          { 0x3A,     0x4000,0x4000,0x4000,0xA000 },    //KATAKANA
          { 0x36,     0x8000,0x4000,0x4000,0xB000 },    //HIRAGANA
          { 0x45,     0x8400,0x4000,0x4000,0x8800 },    //HAN/ZEN KEY
          { 0x3F,     0xA004,0xA004,0xA004,0xA004 },    //
          { 0x3F+0x80,0x0000,0x0000,0x0000,0x0000 },    //
          { 0xFF,     0x0000,0x0000,0x0000,0x0000 } };  //end mark

//          Base Alpha Hankaku graphic key (09/89)                              //j-mi1022
XCODETBL2 dos_base_alpha_han =                                                  //j-mi1022
        {   0x00,                                                               //j-mi1022
          { 0x7A, 0x78, 0x63, 0x76, 0x62, 0x6E, 0x6D, 0x2C,                     //j-mi1022
            0x2E, 0x2F, 0xFF, 0x61, 0x73, 0x64, 0x66, 0x67,                     //j-mi1022
            0x68, 0x6A, 0x6B, 0x6C, 0x3B, 0x3A, 0x5D, 0x71,                     //j-mi1022
            0x77, 0x65, 0x72, 0x74, 0x79, 0x75, 0x69, 0x6F,                     //j-mi1022
            0x70, 0x40, 0x5B, 0x31, 0x32, 0x33, 0x34, 0x35,                     //j-mi1022
            0x36, 0x37, 0x38, 0x39, 0x30, 0x2D, 0x5E, 0x5C  },                  //j-mi1022
                                                                                //j-mi1022
          { 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,     //j-mi1022
            0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,     //j-mi1022
            0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,     //j-mi1022
            0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF         } }; //j-mi1022

//          Base Alpha Zenkaku graphic key (0A/8A)                              //j-mi1022
XCODETBL2 dos_base_alpha_zen =                                                  //j-mi1022
        {   0x82,                                                               //j-mi1022
          { 0x9A, 0x98, 0x83, 0x96, 0x82, 0x8E, 0x8D, 0x01,                     //j-mi1022
            0x02, 0x03, 0x04, 0x81, 0x93, 0x84, 0x86, 0x87,                     //j-mi1022
            0x88, 0x8A, 0x8B, 0x8C, 0x05, 0x06, 0x07, 0x91,                     //j-mi1022
            0x97, 0x85, 0x92, 0x94, 0x99, 0x95, 0x89, 0x8F,                     //j-mi1022
            0x90, 0x08, 0x09, 0x50, 0x51, 0x52, 0x53, 0x54,                     //j-mi1022
            0x55, 0x56, 0x57, 0x58, 0x4F, 0x0A, 0x0B, 0x0C  },                  //j-mi1022
                                                                                //j-mi1022
          { 0x8143, 0x8144, 0x815E, 0x815F, 0x8147, 0x8146, 0x816E, 0x8197,     //j-mi1022
            0x816D, 0x817C, 0x814F, 0x818F, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,     //j-mi1022
            0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,     //j-mi1022
            0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF         } }; //j-mi1022

//          Base Hiragana Zenkaku graphic key (0B/8B),(0C/8C)                   //j-mi1022
XCODETBL2 dos_base_hira_zen =                                                   //j-mi1022
        {   0x82,                                                               //j-mi1022
          { 0xC2, 0xB3, 0xBB, 0xD0, 0xB1, 0xDD, 0xE0, 0xCB,                     //j-mi1022
            0xE9, 0xDF, 0xEB, 0xBF, 0xC6, 0xB5, 0xCD, 0xAB,                     //j-mi1022
            0xAD, 0xDC, 0xCC, 0xE8, 0xEA, 0xAF, 0xDE, 0xBD,                     //j-mi1022
            0xC4, 0xA2, 0xB7, 0xA9, 0xF1, 0xC8, 0xC9, 0xE7,                     //j-mi1022
            0xB9, 0x01, 0x02, 0xCA, 0xD3, 0xA0, 0xA4, 0xA6,                     //j-mi1022
            0xA8, 0xE2, 0xE4, 0xE6, 0xED, 0xD9, 0xD6, 0x03  },                  //j-mi1022
                                                                                //j-mi1022
          { 0x814A, 0x814B, 0x815B, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,     //j-mi1022
            0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,     //j-mi1022
            0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,     //j-mi1022
            0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF         } }; //j-mi1022

//          Base Katakana Hankaku graphic key (0D/8D)                           //j-mi1022
XCODETBL2 dos_base_kata_han =                                                   //j-mi1022
        {   0x00,                                                               //j-mi1022
          { 0xC2, 0xBB, 0xBF, 0xCB, 0xBA, 0xD0, 0xD3, 0xC8,                     //j-mi1022
            0xD9, 0xD2, 0xDB, 0xC1, 0xC4, 0xBC, 0xCA, 0xB7,                     //j-mi1022
            0xB8, 0xCF, 0xC9, 0xD8, 0xDA, 0xB9, 0xD1, 0xC0,                     //j-mi1022
            0xC3, 0xB2, 0xBD, 0xB6, 0xDD, 0xC5, 0xC6, 0xD7,                     //j-mi1022
            0xBE, 0xDE, 0xDF, 0xC7, 0xCC, 0xB1, 0xB3, 0xB4,                     //j-mi1022
            0xB5, 0xD4, 0xD5, 0xD6, 0xDC, 0xCE, 0xCD, 0xB0  },                  //j-mi1022
                                                                                //j-mi1022
          { 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,     //j-mi1022
            0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,     //j-mi1022
            0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,     //j-mi1022
            0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF         } }; //j-mi1022

//          Base Katakana Zenkaku graphic key (0E/8E)                           //j-mi1022
XCODETBL2 dos_base_kata_zen =                                                   //j-mi1022
        {   0x83,                                                               //j-mi1022
          { 0x63, 0x54, 0x5C, 0x71, 0x52, 0x7E, 0x82, 0x6C,                     //j-mi1022
            0x8B, 0x81, 0x8D, 0x60, 0x67, 0x56, 0x6E, 0x4C,                     //j-mi1022
            0x4E, 0x7D, 0x6D, 0x8A, 0x8C, 0x50, 0x80, 0x5E,                     //j-mi1022
            0x65, 0x43, 0x58, 0x4A, 0x93, 0x69, 0x6A, 0x89,                     //j-mi1022
            0x5A, 0x01, 0x02, 0x6B, 0x74, 0x41, 0x45, 0x47,                     //j-mi1022
            0x49, 0x84, 0x86, 0x88, 0x8F, 0x7A, 0x77, 0x03  },                  //j-mi1022
                                                                                //j-mi1022
          { 0x814A, 0x814B, 0x815B, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,     //j-mi1022
            0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,     //j-mi1022
            0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,     //j-mi1022
            0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF         } }; //j-mi1022

//          Upper Alpha Hankaku graphic key (0F/8F)                             //j-mi1022
XCODETBL2 dos_upper_alpha_han =                                                 //j-mi1022
        {   0x00,                                                               //j-mi1022
          { 0x5A, 0x58, 0x43, 0x56, 0x42, 0x4E, 0x4D, 0x3C,                     //j-mi1022
            0x3E, 0x3F, 0x5F, 0x41, 0x53, 0x44, 0x46, 0x47,                     //j-mi1022
            0x48, 0x4A, 0x4B, 0x4C, 0x2B, 0x2A, 0x7D, 0x51,                     //j-mi1022
            0x57, 0x45, 0x52, 0x54, 0x59, 0x55, 0x49, 0x4F,                     //j-mi1022
            0x50, 0x60, 0x7B, 0x21, 0x22, 0x23, 0x24, 0x25,                     //j-mi1022
            0x26, 0x27, 0x28, 0x29, 0xFF, 0x3D, 0x7E, 0x7C  },                  //j-mi1022

          { 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,     //j-mi1022
            0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,     //j-mi1022
            0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,     //j-mi1022
            0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF         } }; //j-mi1022

//          Upper Alpha Zenkaku graphic key (10/90)                             //j-mi1022
XCODETBL2 dos_upper_alpha_zen =                                                 //j-mi1022
        {   0x82,                                                               //j-mi1022
          { 0x79, 0x77, 0x62, 0x75, 0x61, 0x6D, 0x6C, 0x01,                     //j-mi1022
            0x02, 0x03, 0x04, 0x60, 0x72, 0x63, 0x65, 0x66,                     //j-mi1022
            0x67, 0x69, 0x6A, 0x6B, 0x05, 0x06, 0x07, 0x70,                     //j-mi1022
            0x76, 0x64, 0x71, 0x73, 0x78, 0x74, 0x68, 0x6E,                     //j-mi1022
            0x6F, 0x08, 0x09, 0x0A, 0x15, 0x0B, 0x0C, 0x0D,                     //j-mi1022
            0x0E, 0x16, 0x0F, 0x10, 0x11, 0x12, 0x13, 0x14  },                  //j-mi1022
                                                                                //j-mi1022
          { 0x8183, 0x8184, 0x8148, 0x8151, 0x817B, 0x8196, 0x8170, 0x814D,     //j-mi1022
            0x816F, 0x8149, 0x8194, 0x8190, 0x8193, 0x8195, 0x8169, 0x816A,     //j-mi1022
            0x8160, 0x8181, 0x8150, 0x8162, 0xFA57, 0xFA56, 0xFFFF, 0xFFFF,     //j-mi1022
            0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF         } }; //j-mi1022

//          Upper Hiragana Zenkaku graphic key (11/91), (12/92)                 //j-mi1022
XCODETBL2 dos_upper_hira_zen =                                                  //j-mi1022
        {   0x82,                                                               //j-mi1022
          { 0xC1, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x01,                     //j-mi1022
            0x02, 0x03, 0x0B, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,                     //j-mi1022
            0xFF, 0xFF, 0xFF, 0xFF, 0x04, 0x05, 0x06, 0xFF,                     //j-mi1022
            0xFF, 0xA1, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,                     //j-mi1022
            0x07, 0x0C, 0x08, 0x0E, 0x0E, 0x9F, 0xA3, 0xA5,                     //j-mi1022
            0xA7, 0xE1, 0xE3, 0xE5, 0xF0, 0x09, 0x0A, 0x0D  },                  //j-mi1022
                                                                                //j-mi1022
          { 0x8141, 0x8142, 0x8145, 0x8178, 0x8396, 0x8176, 0x8177, 0x8175,     //j-mi1022
            0x8192, 0x8158, 0xFA55, 0x8191, 0xFA54, 0x001A, 0xFFFF, 0xFFFF,     //j-mi1022
            0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,     //j-mi1022
            0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF         } }; //j-mi1022

//          Upper Katakana Hankaku graphic key (13/93)                          //j-mi1022
XCODETBL2 dos_upper_kata_han =                                                  //j-mi1022
        {   0x00,                                                               //j-mi1022
          { 0xAF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xA4,                     //j-mi1022
            0xA1, 0xA5, 0x01, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,                     //j-mi1022
            0xFF, 0xFF, 0xFF, 0xFF, 0x01, 0x01, 0xA3, 0xFF,                     //j-mi1022
            0xFF, 0xA8, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,                     //j-mi1022
            0x01, 0x01, 0xA2, 0x01, 0x01, 0xA7, 0xA9, 0xAA,                     //j-mi1022
            0xAB, 0xAC, 0xAD, 0xAE, 0xA6, 0x01, 0x01, 0x01  },                  //j-mi1022
                                                                                //j-mi1022
          { 0x001A, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,     //j-mi1022
            0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,     //j-mi1022
            0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,     //j-mi1022
            0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF         } }; //j-mi1022

//          Upper Katakana Zenkaku graphic key (14/94)                          //j-mi1022
XCODETBL2 dos_upper_kata_zen =                                                  //j-mi1022
        {   0x83,                                                               //j-mi1022
          { 0x62, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x01,                     //j-mi1022
            0x02, 0x03, 0x0A, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,                     //j-mi1022
            0xFF, 0xFF, 0xFF, 0xFF, 0x04, 0x96, 0x05, 0xFF,                     //j-mi1022
            0xFF, 0x42, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,                     //j-mi1022
            0x06, 0x0B, 0x07, 0x0D, 0x0D, 0x40, 0x44, 0x46,                     //j-mi1022
            0x48, 0x83, 0x85, 0x87, 0x92, 0x08, 0x09, 0x0C  },                  //j-mi1022
                                                                                //j-mi1022
          { 0x8141, 0x8142, 0x8145, 0x8178, 0x8176, 0x8177, 0x8175, 0x8192,     //j-mi1022
            0x8158, 0xFA55, 0x8191, 0xFA54, 0x001A, 0xFFFF, 0xFFFF, 0xFFFF,     //j-mi1022
            0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,     //j-mi1022
            0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF         } }; //j-mi1022

//          CTRL graphic key (15/95 - 1A/9A)                                    //j-mi1022
XCODETBL2 dos_ctrl_alpha_han =                                                  //j-mi1022
        {   0x02,                                                               //j-mi1022
          { 0x1A, 0x18, 0x03, 0x16, 0x02, 0x0E, 0x0D, 0xFF,                     //j-mi1022
            0xFF, 0xFF, 0xFF, 0x01, 0x13, 0x04, 0x06, 0x07,                     //j-mi1022
            0x08, 0x0A, 0x0B, 0x0C, 0xFF, 0xFF, 0x1D, 0x11,                     //j-mi1022
            0x17, 0x05, 0x12, 0x14, 0x19, 0x15, 0x09, 0x0F,                     //j-mi1022
            0x10, 0xFF, 0x1B, 0xFF, 0x00, 0xFF, 0xFF, 0xFF,                     //j-mi1022
            0x1E, 0xFF, 0xFF, 0xFF, 0xFF, 0x1F, 0xFF, 0x1C  },                  //j-mi1022
          {                                                                     //j-mi1022
            0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,     //j-mi1022
            0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,     //j-mi1022
            0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,     //j-mi1022
            0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF         } }; //j-mi1022

//          ALT graphic key (1B/9B - 20/A0)                                     //j-mi1022
XCODETBL2 dos_alt_alpha_han =                                                   //j-mi1022
        {   0x01,                                                               //j-mi1022
          { 0x2C, 0x2D, 0x2E, 0x2F, 0x30, 0x31, 0x32, 0x33,                     //j-mi1022
            0x34, 0x35, 0xFF, 0x01, 0x02, 0x20, 0x21, 0x22,                     //j-mi1022
            0x23, 0x24, 0x25, 0x26, 0x27, 0x28, 0x29, 0x03,                     //j-mi1022
            0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0A, 0x0B,                     //j-mi1022
            0x0C, 0x0D, 0x0E, 0x78, 0x79, 0x7A, 0x7B, 0x7C,                     //j-mi1022
            0x7D, 0x7E, 0x7F, 0x80, 0x81, 0x82, 0x83, 0xFF  },                  //j-mi1022
                                                                                //j-mi1022
          { 0x1E00, 0x1F00, 0x1000, 0x1100, 0x1200, 0x1300, 0x1400, 0x1500,     //j-mi1022
            0x1600, 0x1700, 0x1800, 0x1900, 0x1A00, 0x1B00, 0xFFFF, 0xFFFF,     //j-mi1022
            0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,     //j-mi1022
            0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF         } }; //j-mi1022

//          ALT function key (24/A4)
XCODETBL dos_func_alt =
        {   0x01,
          {       0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xDF,
            0xFF, 0xFF, 0xFF, 0x01, 0xA5, 0x02, 0xF3, 0xDF,

            0xDC, 0xFF, 0xD6, 0x94, 0xD0, 0xFF, 0xCA, 0xFF,
            0xC4, 0xC7, 0x51, 0x9C, 0x4F, 0x9D, 0x49, 0xA2,

            0xA3, 0xCD, 0x99, 0x9F, 0xA1, 0xFF, 0xFF, 0xFF,
            0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,

            0xA6, 0xFF, 0xFF, 0x4E, 0x37, 0xA4, 0xFF, 0x4A,
            0x68, 0x69, 0x6A, 0x6B, 0x6C, 0x6D, 0x6E, 0x6F,

            0x70, 0x71, 0x8B, 0x8C, 0xFF, 0xFF, 0xE3, 0xE6,
            0xE9, 0xEC, 0xEF, 0xF2, 0xF5, 0xF8, 0xFB, 0xFE },

          {         0x1C00, 0x0100, 0x0E00, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
            0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
            0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
            0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF } };

//          CTRL function key (23/A3)
XCODETBL dos_func_ctl =
        {   0x01,
          {       0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xDE,
            0xFF, 0xFF, 0xFF, 0x01, 0x94, 0x02, 0x03, 0xFF,

            0xDB, 0xFF, 0xD5, 0x87, 0xCF, 0xFF, 0xC9, 0xFF,
            0xC3, 0xC6, 0x76, 0x73, 0x75, 0x74, 0x84, 0x92,

            0x93, 0xCC, 0x84, 0x75, 0x76, 0xFF, 0xFF, 0xFF,
            0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,

            0x01, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x8E,
            0x5E, 0x5F, 0x60, 0x61, 0x62, 0x63, 0x64, 0x65,

            0x66, 0x67, 0x68, 0x69, 0x72, 0xFF, 0xE2, 0xE5,
            0xE8, 0xEB, 0xEE, 0xF1, 0xF4, 0xF7, 0xFA, 0xFD },

          {         0x000A, 0x001B, 0x007F, 0x1D00, 0xFFFF, 0xFFFF, 0xFFFF,
            0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
            0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
            0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF } };

//          Upper function key (22/A2)
XCODETBL dos_func_up =
        {   0x01,
          {       0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x93,
            0xFF, 0xFF, 0xFF, 0x12, 0x13, 0x14, 0x15, 0xFF,

            0x98, 0xFF, 0xD4, 0x97, 0xCE, 0xFF, 0xC8, 0xFF,
            0x77, 0x9A, 0x50, 0x4B, 0x47, 0x4D, 0x48, 0x52,

            0x53, 0xCB, 0x49, 0x4F, 0x51, 0x01, 0x02, 0x03,
            0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0A, 0x0B,

            0x0C, 0xFF, 0xFF, 0x0D, 0x0E, 0x0F, 0x10, 0x11,
            0x54, 0x55, 0x56, 0x57, 0x58, 0x59, 0x5A, 0x5B,

            0x5C, 0x5D, 0x5E, 0x5F, 0xFF, 0xFF, 0xE1, 0x99,
            0xE7, 0xEA, 0xED, 0xF0, 0xF3, 0xF6, 0xF9, 0xFC },

          {         0x0030, 0x002E, 0x0031, 0x0032, 0x0033, 0x0034, 0x0035,
            0x0036, 0x0037, 0x0038, 0x0039, 0x000D, 0x002B, 0x002A, 0x002F,
            0x002C, 0x002D, 0x000D, 0x0F00, 0x001B, 0x0008, 0xFFFF, 0xFFFF,
            0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF } };

//          Base function key (21/A1)
XCODETBL dos_func_base =
        {   0x01,
          {       0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x93,
            0xFF, 0xFF, 0xFF, 0x12, 0x13, 0x14, 0x15, 0xFF,

            0x98, 0xFF, 0xD4, 0x97, 0xCE, 0xFF, 0xC8, 0xFF,
            0x77, 0x9A, 0x50, 0x4B, 0x47, 0x4D, 0x48, 0x52,

            0x53, 0xCB, 0x49, 0x4F, 0x51, 0x01, 0x02, 0x03,
            0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0A, 0x0B,

            0x0C, 0xFF, 0xFF, 0x0D, 0x0E, 0x0F, 0x10, 0x11,
            0x3B, 0x3C, 0x3D, 0x3E, 0x3F, 0x40, 0x41, 0x42,

            0x43, 0x44, 0x54, 0x55, 0xFF, 0xFF, 0xE1, 0x99,
            0xE7, 0xEA, 0xED, 0xF0, 0xF3, 0xF6, 0xF9, 0xFC },

          {         0x0030, 0x002E, 0x0031, 0x0032, 0x0033, 0x0034, 0x0035,
            0x0036, 0x0037, 0x0038, 0x0039, 0x000D, 0x002B, 0x002A, 0x002F,
            0x002C, 0x002D, 0x000D, 0x0009, 0x001B, 0x0008, 0xFFFF, 0xFFFF,
            0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF } };

//          Special key (25/A5)
SPECIALORG dos_originaltbl =
        {   0L,                             // Header
         {{ 0x31, 0xC000, 0x0000 },         // Alt Key Break
          { 0x32, 0xC040, 0x0000 },         // Alpha Key(Alt)
          { 0x32, 0x4040, 0x0000 },         // Alpha Key
          { 0x36, 0xC040, 0x0000 },         // Roman Key
          { 0x36, 0x0040, 0x0000 },         // Roman Key(Alt)
          { 0x47, 0x0040, 0x0000 },         // Pause Key(Alt)
          { 0x47, 0x0010, 0x0000 },         // Pause Key(Ctl)
          { 0x47, 0x4000, 0x0000 },         // Pause Key
          { 0x34, 0x0000, 0x0000 },         // Space Key
          { 0x35, 0x0000, 0x0000 },         // Conv Key
          { 0x33, 0x0000, 0x0000 },         // NoConv Key
          { 0x55, 0x0000, 0x0000 },         // Alt+TenKey(0)
          { 0x57, 0x0000, 0x0000 },         // Alt+TenKey(1)
          { 0x58, 0x0000, 0x0000 },         // Alt+TenKey(2)
          { 0x59, 0x0000, 0x0000 },         // Alt+TenKey(3)
          { 0x5A, 0x0000, 0x0000 },         // Alt+TenKey(4)
          { 0x5B, 0x0000, 0x0000 },         // Alt+TenKey(5)
          { 0x5C, 0x0000, 0x0000 },         // Alt+TenKey(6)
          { 0x5D, 0x0000, 0x0000 },         // Alt+TenKey(7)
          { 0x5E, 0x0000, 0x0000 },         // Alt+TenKey(8)
          { 0x5F, 0x0000, 0x0000 },         // Alt+TenKey(9)
          { 0x50, 0x0050, 0x0000 },         // Delete Key(Alt+Ctrl)
          { 0x08, 0x0040, 0x0000 },         // APL (Alt)
          { 0x09, 0x0040, 0x0000 },         // APL (Alt)
          { 0x0A, 0x0040, 0x0000 },         // APL (Alt)
          { 0x0B, 0x0040, 0x0000 },         // APL (Alt)
          { 0x15, 0x0040, 0x0000 },         // APL (Alt)
          { 0x16, 0x0040, 0x0000 },         // APL (Alt)
          { 0x17, 0x0040, 0x0000 },         // APL (Alt)
          { 0x22, 0x0040, 0x0000 },         // APL (Alt)
          { 0x23, 0x0040, 0x0000 },         // APL (Alt)
          { 0x30, 0x0040, 0x0000 },         // APL (Alt)
          { 0x0B, 0x182A, 0x0000 },         // APL (AlphaHankakuUpper)
          { 0x2D, 0x1821, 0x0000 },         // APL (AlphaHankakuUpper)
          { 0x2D, 0x1824, 0x0000 },         // APL (AlphaHankakuUpper)
          { 0x4F, 0x00A0, 0x0000 },         // Insert Key(w/o Ctrl/Alt)
          { 0x75, 0x0020, 0x0000 },         // Scroll Key(w/o Ctrl)
          { 0x74, 0x0040, 0x0000 },         // Print Key(Alt)
          { 0x74, 0x0020, 0x0000 },         // Print Key(w/o Ctrl)
          { 0x40, 0x0040, 0x0000 },         // Click Key(Alt)
          { 0xFF, 0x0000, 0x0000 } }};      // End Mark

UCHAR   dos_special_tbl[] =
        { 0x08, 0x09, 0x0A, 0x0B,
                                        0x15, 0x16, 0x17,
                      0x22, 0x23,
                                        0x2D,
          0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36,
                                                    0x47,
                                                    0x4F,
          0x50,                         0x55,       0x57,
          0x58, 0x59, 0x5A, 0x5B, 0x5C, 0x5D, 0x5E, 0x5F,
                                  0x74, 0x75, 0xFF };

BYTE    RomanKanaModule[] =
        { 0x31, 0xC0,                                       // Xor AX, AX
          0x31, 0xD2,                                       // Xor DX, DX
          0xCB,                                             // RetF
          0x90, 0x90, 0x90,                                 // NOP
          0x90, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90,   // NOP
          0x90, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90,   // NOP
          0x90, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90,   // NOP
          0x90, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90,   // NOP
          0x90, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90 }; // NOP


DBCSVECTOR DBCSVect[] =
        { {0x81, 0x9F},
          {0xE0, 0xFC},
          {0x00, 0x00} };

BYTE PaddingData[] =  //  80 space chars on to the 25th line in DOSV   //j-mi02
        { 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,  //j-mi02  1
          0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,  //j-mi02  2
          0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,  //j-mi02  3
          0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,  //j-mi02  4
          0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,  //j-mi02  5
          0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,  //j-mi02  6
          0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,  //j-mi02  7
          0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,};//j-mi02  8

// array of graph key table address                                             //j-mi1022
PVOID  OriginalTableAddress[] = {  &dos_base_alpha_han ,                        //j-mi1022
                                   &dos_base_alpha_zen ,                        //j-mi1022
                                   &dos_base_hira_zen  ,                        //j-mi1022
                                   &dos_base_hira_zen  ,                        //j-mi1022
                                   &dos_base_kata_han  ,                        //j-mi1022
                                   &dos_base_kata_zen  ,                        //j-mi1022
                                   &dos_upper_alpha_han,                        //j-mi1022
                                   &dos_upper_alpha_zen,                        //j-mi1022
                                   &dos_upper_hira_zen ,                        //j-mi1022
                                   &dos_upper_hira_zen ,                        //j-mi1022
                                   &dos_upper_kata_han ,                        //j-mi1022
                                   &dos_upper_kata_zen ,                        //j-mi1022
                                   &dos_ctrl_alpha_han ,                        //j-mi1022
                                   &dos_ctrl_alpha_han ,                        //j-mi1022
                                   &dos_ctrl_alpha_han ,                        //j-mi1022
                                   &dos_ctrl_alpha_han ,                        //j-mi1022
                                   &dos_ctrl_alpha_han ,                        //j-mi1022
                                   &dos_ctrl_alpha_han ,                        //j-mi1022
                                   &dos_alt_alpha_han  ,                        //j-mi1022
                                   &dos_alt_alpha_han  ,                        //j-mi1022
                                   &dos_alt_alpha_han  ,                        //j-mi1022
                                   &dos_alt_alpha_han  ,                        //j-mi1022
                                   &dos_alt_alpha_han  ,                        //j-mi1022
                                   &dos_alt_alpha_han  ,      };                //j-mi1022

// effective data length of key table  (Tables are allocated on memory with)    //j-mi1022
//                       (byte)        (these value, actually.             )    //j-mi1022
                                                                                //j-mi1022
#define BASEALPHAHANLEN    49                                                   //j-mi1022
#define BASEALPHAZENLEN    78                                                   //j-mi1022
#define BASEHIRAZENLEN     55                                                   //j-mi1022
#define BASEKATAHANLEN     49                                                   //j-mi1022
#define BASEKATAZENLEN     55                                                   //j-mi1022
#define UPPERALPHAHANLEN   49                                                   //j-mi1022
#define UPPERALPHAZENLEN   93                                                   //j-mi1022
#define UPPERHIRAZENLEN    77                                                   //j-mi1022
#define UPPERKATAHANLEN    51                                                   //j-mi1022
#define UPPERKATAZENLEN    75                                                   //j-mi1022
#define CTRLALPHAHANLEN    49                                                   //j-mi1022
#define ALTALPHAHANLEN     77                                                   //j-mi1022
#define GRAPHKEYTABLELEN   BASEALPHAHANLEN  + BASEALPHAZENLEN + BASEHIRAZENLEN   +  \
                           BASEKATAHANLEN   + BASEKATAZENLEN  + UPPERALPHAHANLEN +  \
                           UPPERALPHAZENLEN + UPPERHIRAZENLEN + UPPERKATAHANLEN  +  \
                           UPPERKATAZENLEN  + CTRLALPHAHANLEN + ALTALPHAHANLEN

USHORT EffectiveLenOfKeyTable []= { BASEALPHAHANLEN  ,                          //j-mi1022
                                    BASEALPHAZENLEN  ,                          //j-mi1022
                                    BASEHIRAZENLEN   ,                          //j-mi1022
                                    BASEHIRAZENLEN   ,                          //j-mi1022
                                    BASEKATAHANLEN   ,                          //j-mi1022
                                    BASEKATAZENLEN   ,                          //j-mi1022
                                    UPPERALPHAHANLEN ,                          //j-mi1022
                                    UPPERALPHAZENLEN ,                          //j-mi1022
                                    UPPERHIRAZENLEN  ,                          //j-mi1022
                                    UPPERHIRAZENLEN  ,                          //j-mi1022
                                    UPPERKATAHANLEN  ,                          //j-mi1022
                                    UPPERKATAZENLEN  ,                          //j-mi1022
                                    CTRLALPHAHANLEN  ,                          //j-mi1022
                                    CTRLALPHAHANLEN  ,                          //j-mi1022
                                    CTRLALPHAHANLEN  ,                          //j-mi1022
                                    CTRLALPHAHANLEN  ,                          //j-mi1022
                                    CTRLALPHAHANLEN  ,                          //j-mi1022
                                    CTRLALPHAHANLEN  ,                          //j-mi1022
                                    ALTALPHAHANLEN   ,                          //j-mi1022
                                    ALTALPHAHANLEN   ,                          //j-mi1022
                                    ALTALPHAHANLEN   ,                          //j-mi1022
                                    ALTALPHAHANLEN   ,                          //j-mi1022
                                    ALTALPHAHANLEN   ,                          //j-mi1022
                                    ALTALPHAHANLEN   , };                       //j-mi1022

//* end of VKBDXTBL.H
