/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1992 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 source code is provided to you solely for       */
/*    the purpose of assisting you in your development of OS/2 device        */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Developer Connection Device Driver       */
/*    Source Kit for OS/2. This Copyright statement may not be removed.      */
/*                                                                           */
/*****************************************************************************/
/**************************************************************************
 *
 * SOURCE FILE NAME = vkbdp.h
 *
 * DESCRIPTIVE NAME = Virtual Keyboard Device Driver (VKBD)
 *
 *
 * VERSION = V2.0
 *
 * DATE   05/12/91
 *
 * DESCRIPTION
 *
 *      VKBD private constants, types, macros and function declarations.
 *
 *      Include file hierarchy:
 *
 *        vkbdp.h
 *          /src/inc/vkbd.h
 *          /src/inc/vkbdpdd.h
 *
 * FUNCTIONS
 *
 * ENTRY POINTS:
 *
 * DEPENDENCIES:
 *
 * NOTES
 *
 * STRUCTURES
 *
 * EXTERNAL REFERENCES
 *
 * EXTERNAL FUNCTIONS
 *
*/

#include <kbd.h>                      /* public keyboard constants           */
#include <beep.h>                     /* beep equates                        */
#include <vkbdpdd.h>                  /* public/exported vkbd-pkbd stuff     */

/*
** Per-VDM flags
*/
#define  VDM_WINDOWED  0x00001
#define  VDM_FGND      0x00002
#define  VDM_FOCUS     0x00004
#define  VDM_PASTING   0x00008        /* pasting in progress                 */
#define  VDM_PASTEINIT 0x00010        /* pasting initialization done         */
#define  VDM_PASTEPAUSE 0x00020       /* pasting currently paused            */
#define  VDM_PASTEDONE 0x00040        /* shield has no more paste data       */
#define  VDM_ENDPASTING 0x00080       /* pasting has been aborted by user    */
#define  VDM_XFERPENDING 0x00100
#define  VDM_EOIPENDING 0x00200
#define  VDM_IRETPENDING 0x00400
#define  VDM_INT15RET  0x00800
#define  VDM_EXTRAKEYS 0x01000     /* enlarged key buffer enabled (default)  */
#define  VDM_FASTPASTE 0x02000     /* fast (INT 16h) pasting enabled (NOT    */
                                   /*                               DEFAULT) */
#define  VDM_PASTEDATA 0x04000     /* buffer has not been emptied since      */
                                   /* last paste                             */
#define  VDM_KBDRESTRICT 0x08000   /* keyboard controller commands           */
                                   /* restricted                             */
#define  VDM_TIMERARMED 0x10000    /* timer has been armed                   */
#define  VDM_1ST_SG_GOT  0x20000   /* Got Creation Screen Group notice 152436*/


/*
** flhkVDM
*/
#define  VDM_NONE      0x00000        /* all control sequences               */
#define  VDM_ALTESC    0x00001        /*                                     */
#define  VDM_CTRLESC   0x00002        /*                                     */
#define  VDM_ALTHOME   0x00004        /*                                     */

#define VDM_VBIOSJ              0xFFFF                               //ss0001
#define VDM_VBIOSUS             0x0000                               //ss0001

#define VDM_INVISIBLE07         0x0001                               //ss0002
#define VDM_INVISIBLE85         0x0002                               //ss0002

/*
** Input flags for VKAddScan
*/
#define  ADDSCAN_TASK  0x0000         /* task-time                           */
#define  ADDSCAN_INTERRUPT 0x0001     /* interrupt-time                      */
#define  ADDSCAN_INPUT 0x0002         /* normal input                        */
#define  ADDSCAN_PASTEINPUT 0x0004    /* paste input                         */
#define  ADDSCAN_RESPONSE 0x0008      /* command response                    */

/*
** Result codes from VKPeekScan
*/
#define  PEEKSCAN_NONE 0           /* no scan code available                 */
#define  PEEKSCAN_PAUSE 1          /* no scan code available (pasting        */
                                   /*                         breather)      */
#define  PEEKSCAN_WAITEOI 2        /* interrupt should be simulated at EOI   */
#define  PEEKSCAN_WAITIRET 3       /* interrupt should be simulated at IRET  */

/*
** Private flag bits in scan code buffer
*/
#define  FKEYPKT_WAITEOI 0x01     /* indicates no wait interrupt simulation  */

/*
** Implementation-related constants (tunable)
*/
#define  MAX_SCANS     64        /* maximum codes our virtual kbd buffers    */
#define  SCANBUF_THRESHOLD 16    /* free space threshold to restart pasting  */
#define  KEYSBUF_THRESHOLD 3     /* free space threshold for fast pasting    */
#define  MAX_EXTRAKEYS 64             /* maximum "extra" keys bufferable     */
#define  NUM_SHIFTS    6              /* number of shift table entries       */
#define  MAX_PASTEEXPAND 16           /* max. paste scan expansion           */
#define  MAX_NUMSCANS  10             /* max. number of numpad scans         */
#define  IRET_TIMEOUT  250            /* iret timeout in msec                */

/*
** Miscellaneous equates
*/
#define  ASC_ESC       0x1b           /* ascii code for the escape key       */

/*
**    Subcomponent-specific types
*/

typedef struct tls_s
{
  PCHAR tls_pchList;
  PULONG tls_pulVal;
} TLS;
                                      /* tls frame list value pair           */
typedef TLS *PTLS;
typedef(PASCAL *PFNSYSRQ)(HVDM,ULONG,PVOID,ULONG,PVOID);
typedef struct cpentry_s
{
  struct cpentry_s *cp_pcpPrev;       /* backward link                       */
  struct cpentry_s *cp_pcpNext;       /* forward link                        */
  USHORT cp_usCodePage;               /* codepage value                      */
  USHORT cp_hCodePage;                /* codepage table handle               */
  USHORT cp_cReference;               /* reference count                     */
  RXTABLE cp_RXTable;                 /* rev xlate table                     */
  SHTABLE cp_ShTable;                 /* shift scan table                    */
  NUMTABLE cp_NumTable;               /* num scan table                      */
} CPENTRY;

typedef CPENTRY *PCPENTRY;
typedef PCPENTRY *PPCPENTRY;

/*
** definitions for INT 16H AH=06H support
**
*/

/*
** indicator which table has been referred or changed.
*/
#define CHGBASEALPHAHAN         0x00000001                              /* j-mi1022 */
#define CHGBASEALPHAZEN         0x00000002                              /* j-mi1022 */
#define CHGBASEHIRAHAN          0x00000004                              /* j-mi1022 */
#define CHGBASEHIRAZEN          0x00000008                              /* j-mi1022 */
#define CHGBASEKATAHAN          0x00000010                              /* j-mi1022 */
#define CHGBASEKATAZEN          0x00000020                              /* j-mi1022 */
#define CHGUPPERALPHAHAN        0x00000040                              /* j-mi1022 */
#define CHGUPPERALPHAZEN        0x00000080                              /* j-mi1022 */
#define CHGUPPERHIRAHAN         0x00000100                              /* j-mi1022 */
#define CHGUPPERHIRAZEN         0x00000200                              /* j-mi1022 */
#define CHGUPPERKATAHAN         0x00000400                              /* j-mi1022 */
#define CHGUPPERKATAZEN         0x00000800                              /* j-mi1022 */
#define CHGCTLALPHAHAN          0x00001000                              /* j-mi1022 */
#define CHGCTLALPHAZEN          0x00002000                              /* j-mi1022 */
#define CHGCTLHIRAHAN           0x00004000                              /* j-mi1022 */
#define CHGCTLHIRAZEN           0x00008000                              /* j-mi1022 */
#define CHGCTLKATAHAN           0x00010000                              /* j-mi1022 */
#define CHGCTLKATAZEN           0x00020000                              /* j-mi1022 */
#define CHGALTALPHAHAN          0x00040000                              /* j-mi1022 */
#define CHGALTALPHAZEN          0x00080000                              /* j-mi1022 */
#define CHGALTHIRAHAN           0x00100000                              /* j-mi1022 */
#define CHGALTHIRAZEN           0x00200000                              /* j-mi1022 */
#define CHGALTKATAHAN           0x00400000                              /* j-mi1022 */
#define CHGALTKATAZEN           0x00800000                              /* j-mi1022 */
#define CHGFUNCBASE             0x01000000                              /* ss0042 */
#define CHGFUNCUP               0x02000000                              /* ss0042 */
#define CHGFUNCCTL              0x04000000                              /* ss0042 */
#define CHGFUNCALT              0x08000000                              /* ss0042 */

/*
**    key table name and its ordinal number
*/
#define     BASEALPHAHAN       1                                        /* j-mi1022 */
#define     BASEALPHAZEN       2                                        /* j-mi1022 */
#define     BASEHIRAHAN        3                                        /* j-mi1022 */
#define     BASEHIRAZEN        4                                        /* j-mi1022 */
#define     BASEKATAHAN        5                                        /* j-mi1022 */
#define     BASEKATAZEN        6                                        /* j-mi1022 */
#define     UPPERALPHAHAN      7                                        /* j-mi1022 */
#define     UPPERALPHAZEN      8                                        /* j-mi1022 */
#define     UPPERHIRAHAN       9                                        /* j-mi1022 */
#define     UPPERHIRAZEN      10                                        /* j-mi1022 */
#define     UPPERKATAHAN      11                                        /* j-mi1022 */
#define     UPPERKATAZEN      12                                        /* j-mi1022 */
#define     CTRLALPHAHAN      13                                        /* j-mi1022 */
#define     CTRLALPHAZEN      14                                        /* j-mi1022 */
#define     CTRLHIRAHAN       15                                        /* j-mi1022 */
#define     CTRLHIRAZEN       16                                        /* j-mi1022 */
#define     CTRLKATAHAN       17                                        /* j-mi1022 */
#define     CTRLKATAZEN       18                                        /* j-mi1022 */
#define     ALTALPHAHAN       19                                        /* j-mi1022 */
#define     ALTALPHAZEN       20                                        /* j-mi1022 */
#define     ALTHIRAHAN        21                                        /* j-mi1022 */
#define     ALTHIRAZEN        22                                        /* j-mi1022 */
#define     ALTKATAHAN        23                                        /* j-mi1022 */
#define     ALTKATAZEN        24                                        /* j-mi1022 */

#define     KEYTABLESIZE      ALTKATAZEN   /* total of the graph key table j-mi1022 */

/*
** NLS shift status definition
*/
#define NLSSHIFT_HANKAKU_STATE       0x00                               /* j-mi1022 */
#define NLSSHIFT_ZENKAKU_STATE       0x01                               /* j-mi1022 */
#define NLSSHIFT_KATAKANA_HANKAKU    0x02                               /* j-mi1022 */
#define NLSSHIFT_HIRAGANA_HANKAKU    0x04                               /* j-mi1022 */
#define NLSSHIFT_MASK_ALPHANUMERIC   0x06 /* for mask ONLY */           /* j-mi1022 */
#define NLSSHIFT_ROMAJI_MODE         0x40                               /* j-mi1022 */
#define NLSSHIFT_KANA_KANJI_MODE     0x80                               /* j-mi1022 */

typedef struct shift_table {           /* struct for Shift Table */     /* ss0004 */
    UCHAR   RawScan;                                                    /* ss0004 */
    USHORT  AltFunc;                                                    /* ss0004 */
    USHORT  CtlFunc;                                                    /* ss0004 */
    USHORT  UpFunc;                                                     /* ss0004 */
    USHORT  BaseFunc;                                                   /* ss0004 */
} SHIFTTBL;                                                             /* ss0004 */
                                                                        /* ss0004 */
typedef SHIFTTBL *PSHIFTTBL;                                            /* ss0004 */

typedef struct xcode_table {           /* struct for Function key tables   ss0016 */
    UCHAR   Header;                                                     /* ss0016 */
    UCHAR   TCode[0x4F];                                                /* ss0016 */
    USHORT  ECode[0x1F];                                                /* ss0016 */
} XCODETBL;                                                             /* ss0016 */
                                                                        /* ss0016 */
typedef XCODETBL *PXCODETBL;                                            /* ss0016 */

typedef struct xcode_table2 {          /* struct for Graph key tables      j-mi1022 */
    UCHAR   Header;                                                     /* j-mi1022 */
    UCHAR   TCode[0x30];                                                /* j-mi1022 */
    USHORT  ECode[0x1F];                                                /* j-mi1022 */
} XCODETBL2;                                                            /* j-mi1022 */
                                                                        /* j-mi1022 */
typedef XCODETBL2 *PXCODETBL2;                                          /* j-mi1022 */

typedef struct key_table {             /* struct for Graph key table array j-mi1019 */
   PXCODETBL2  pOriginalKeyTable;                                       /* j-mi1019 */
   PXCODETBL2  pNewKeyTable;                                            /* j-mi1019 */
   USHORT      OriginalKeyTableLen;                                     /* j-mi1019 */
   USHORT      NewKeyTableLen;                                          /* j-mi1019 */
} KEYTABLE;                                                             /* j-mi1019 */
                                                                        /* j-mi1019 */
typedef KEYTABLE *PKEYTABLE;                                            /* j-mi1019 */

typedef struct special_tbl {           /* struct for Special key Table     ss0016 */
    UCHAR   RawScan;                                                    /* ss0016 */
    USHORT  Shift;                                                      /* ss0016 */
    USHORT  Offset;                                                     /* ss0016 */
    USHORT  Segment;                                                    /* ss0016 */
} SPECIALTBL;                                                           /* ss0016 */
                                                                        /* ss0016 */
typedef SPECIALTBL *PSPECIALTBL;                                        /* ss0016 */

typedef struct original_tbl {                                           /* ss0020 */
    UCHAR   RawScan;                                                    /* ss0020 */
    USHORT  Shift;                                                      /* ss0020 */
    USHORT  Offset;                                                     /* ss0020 */
} ORGSPETBL;                                                            /* ss0020 */
                                                                        /* ss0020 */
typedef ORGSPETBL *PORGSPETBL;                                          /* ss0020 */

typedef struct special_org {                                            /* ss0020 */
    ULONG       Header;                                                 /* ss0020 */
    ORGSPETBL   Entry[41];                                              /* ss0020 */
} SPECIALORG;                                                           /* ss0020 */
                                                                        /* ss0020 */
typedef SPECIALORG *PSPECIALORG;                                        /* ss0020 */

typedef struct dbcs_vector {                                            /* ss0024 */
    UCHAR   start;                                                      /* ss0024 */
    UCHAR   end;                                                        /* ss0024 */
} DBCSVECTOR;                                                           /* ss0024 */
                                                                        /* ss0024 */
typedef DBCSVECTOR *PDBCSVECTOR;                                        /* ss0024 */


#ifdef   MYDEBUG
   #define  MAX_DEBUG_ENTRIES 8192
typedef struct debugentry_s
{
  UCHAR de_op;
  UCHAR de_value;
} DEBUGENTRY;

typedef DEBUGENTRY *PDEBUGENTRY;
VOID PRIVENTRY VKAddDebugEntry(HVDM,UCHAR,UCHAR);
   #define  ADDDEBUG(hvdm,op,value) VKAddDebugEntry(hvdm,op,value)

#else
   #define  ADDDEBUG(hvdm,op,value)
#endif
/*
** c-begin
*/

/*
**    Subcomponent-specific macros
*/

#define  VKBeep()      VDHDevBeep(KBDBEEP_FREQ, KBDBEEP_DURATION)
/*
** c-end
*/

/*
**   These are "extended scan codes" assigned by IBM's ROM BIOS to various
**   key combinations.  They are returned to the VDM along with a NULL
**   character code.  Because these are post-translation values, it's
**   reasonably OK to use them throughout the driver, as long as they're
**   used as such.  For many of the unshifted keys, the EXTSCAN_ value is the
**   same SCAN_ value, but that's only an interesting bit of trivia, not
**   something you should ever depend on.
**
**   Those keys marked as "ENHANCED BIOS" are only supported by enhanced
**   ROM BIOS (the kind you'd find on a 101-key system, although a 101-key
**   keyboard is not a strict requirement), and should only be readable via an
**   extended BIOS read (INT 16h, AH=10h instead AH=00h).
*/

#define  EXTSCAN_ALTESC 0x01          /* Alt Esc ENHANCED BIOS               */
#define  EXTSCAN_NULL  0x03           /* Null                                */
#define  EXTSCAN_ALTBKSP 0x0E         /* Alt Backspace ENHANCED BIOS         */
#define  EXTSCAN_ALTBKTAB 0x0F        /* Backtab                             */
#define  EXTSCAN_ALTQ  0x10           /* Alt Q                               */
#define  EXTSCAN_ALTW  0x11           /* Alt W                               */
#define  EXTSCAN_ALTE  0x12           /* Alt E                               */
#define  EXTSCAN_ALTR  0x13           /* Alt R                               */
#define  EXTSCAN_ALTT  0x14           /* Alt T                               */
#define  EXTSCAN_ALTY  0x15           /* Alt Y                               */
#define  EXTSCAN_ALTU  0x16           /* Alt U                               */
#define  EXTSCAN_ALTI  0x17           /* Alt I                               */
#define  EXTSCAN_ALTO  0x18           /* Alt O                               */
#define  EXTSCAN_ALTP  0x19           /* Alt P                               */
#define  EXTSCAN_ALTLB 0x1A           /* Alt [ ENHANCED BIOS                 */
#define  EXTSCAN_ALTRB 0x1B           /* Alt ] ENHANCED BIOS                 */
#define  EXTSCAN_ALTENTER 0x1C        /* Alt Enter ENHANCED BIOS             */
#define  EXTSCAN_ALTA  0x1E           /* Alt A                               */
#define  EXTSCAN_ALTS  0x1F           /* Alt S                               */
#define  EXTSCAN_ALTD  0x20           /* Alt D                               */
#define  EXTSCAN_ALTF  0x21           /* Alt F                               */
#define  EXTSCAN_ALTG  0x22           /* Alt G                               */
#define  EXTSCAN_ALTH  0x23           /* Alt H                               */
#define  EXTSCAN_ALTJ  0x24           /* Alt J                               */
#define  EXTSCAN_ALTK  0x25           /* Alt K                               */
#define  EXTSCAN_ALTL  0x26           /* Alt L                               */
#define  EXTSCAN_ALTSEMI 0x27         /* Alt ; ENHANCED BIOS                 */
#define  EXTSCAN_ALTSQ 0x28           /* Alt ' ENHANCED BIOS                 */
#define  EXTSCAN_ALTBQ 0x29           /* Alt ` ENHANCED BIOS                 */
#define  EXTSCAN_ALTBSLASH 0x2B       /* Alt \ ENHANCED BIOS                 */
#define  EXTSCAN_ALTZ  0x2C           /* Alt Z                               */
#define  EXTSCAN_ALTX  0x2D           /* Alt X                               */
#define  EXTSCAN_ALTC  0x2E           /* Alt C                               */
#define  EXTSCAN_ALTV  0x2F           /* Alt V                               */
#define  EXTSCAN_ALTB  0x30           /* Alt B                               */
#define  EXTSCAN_ALTN  0x31           /* Alt N                               */
#define  EXTSCAN_ALTM  0x32           /* Alt M                               */
#define  EXTSCAN_ALTCOMMA 0x33        /* Alt , ENHANCED BIOS                 */
#define  EXTSCAN_ALTPERIOD 0x34       /* Alt . ENHANCED BIOS                 */
#define  EXTSCAN_ALTSLASH 0x35        /* Alt / ENHANCED BIOS                 */
#define  EXTSCAN_ALTKPMULT 0x37       /* Alt Keypad * ENHANCED BIOS          */
#define  EXTSCAN_ALT   0x38           /* Alt alone make code  70207          */
#define  EXTSCAN_F1    0x3B           /* F1                                  */
#define  EXTSCAN_F2    0x3C           /* F2                                  */
#define  EXTSCAN_F3    0x3D           /* F3                                  */
#define  EXTSCAN_F4    0x3E           /* F4                                  */
#define  EXTSCAN_F5    0x3F           /* F5                                  */
#define  EXTSCAN_F6    0x40           /* F6                                  */
#define  EXTSCAN_F7    0x41           /* F7                                  */
#define  EXTSCAN_F8    0x42           /* F8                                  */
#define  EXTSCAN_F9    0x43           /* F9                                  */
#define  EXTSCAN_F10   0x44           /* F10                                 */
#define  EXTSCAN_HOME  0x47           /* Home                                */
#define  EXTSCAN_UP    0x48           /* Up                                  */
#define  EXTSCAN_PGUP  0x49           /* PgUp                                */
#define  EXTSCAN_ALTKPMINUS 0x4A      /* Alt Keypad - ENHANCED BIOS          */
#define  EXTSCAN_LEFT  0x4B           /* Left                                */
#define  EXTSCAN_CENTER 0x4C          /* Center ENHANCED BIOS                */
#define  EXTSCAN_RIGHT 0x4D           /* Right                               */
#define  EXTSCAN_ALTKPPLUS 0x4E       /* Alt Keypad + ENHANCED BIOS          */
#define  EXTSCAN_END   0x4F           /* End                                 */
#define  EXTSCAN_DOWN  0x50           /* Down                                */
#define  EXTSCAN_PGDN  0x51           /* PgDn                                */
#define  EXTSCAN_INS   0x52           /* Ins                                 */
#define  EXTSCAN_DEL   0x53           /* Del                                 */
#define  EXTSCAN_SHIFTF1 0x54         /* Shift F1                            */
#define  EXTSCAN_SHIFTF2 0x55         /* Shift F2                            */
#define  EXTSCAN_SHIFTF3 0x56         /* Shift F3                            */
#define  EXTSCAN_SHIFTF4 0x57         /* Shift F4                            */
#define  EXTSCAN_SHIFTF5 0x58         /* Shift F5                            */
#define  EXTSCAN_SHIFTF6 0x59         /* Shift F6                            */
#define  EXTSCAN_SHIFTF7 0x5A         /* Shift F7                            */
#define  EXTSCAN_SHIFTF8 0x5B         /* Shift F8                            */
#define  EXTSCAN_SHIFTF9 0x5C         /* Shift F9                            */
#define  EXTSCAN_SHIFTF10 0x5D        /* Shift F10                           */
#define  EXTSCAN_CTRLF1 0x5E          /* Ctrl F1                             */
#define  EXTSCAN_CTRLF2 0x5F          /* Ctrl F2                             */
#define  EXTSCAN_CTRLF3 0x60          /* Ctrl F3                             */
#define  EXTSCAN_CTRLF4 0x61          /* Ctrl F4                             */
#define  EXTSCAN_CTRLF5 0x62          /* Ctrl F5                             */
#define  EXTSCAN_CTRLF6 0x63          /* Ctrl F6                             */
#define  EXTSCAN_CTRLF7 0x64          /* Ctrl F7                             */
#define  EXTSCAN_CTRLF8 0x65          /* Ctrl F8                             */
#define  EXTSCAN_CTRLF9 0x66          /* Ctrl F9                             */
#define  EXTSCAN_CTRLF10 0x67         /* Ctrl F10                            */
#define  EXTSCAN_ALTF1 0x68           /* Alt F1                              */
#define  EXTSCAN_ALTF2 0x69           /* Alt F2                              */
#define  EXTSCAN_ALTF3 0x6A           /* Alt F3                              */
#define  EXTSCAN_ALTF4 0x6B           /* Alt F4                              */
#define  EXTSCAN_ALTF5 0x6C           /* Alt F5                              */
#define  EXTSCAN_ALTF6 0x6D           /* Alt F6                              */
#define  EXTSCAN_ALTF7 0x6E           /* Alt F7                              */
#define  EXTSCAN_ALTF8 0x6F           /* Alt F8                              */
#define  EXTSCAN_ALTF9 0x70           /* Alt F9                              */
#define  EXTSCAN_ALTF10 0x71          /* Alt F10                             */
#define  EXTSCAN_CTRLPRTSC 0x72       /* Ctrl PrtSc                          */
#define  EXTSCAN_CTRLLEFT 0x73        /* Ctrl Left                           */
#define  EXTSCAN_CTRLRIGHT 0x74       /* Ctrl Right                          */
#define  EXTSCAN_CTRLEND 0x75         /* Ctrl End                            */
#define  EXTSCAN_CTRLPGDN 0x76        /* Ctrl PgDn                           */
#define  EXTSCAN_CTRLHOME 0x77        /* Ctrl Home                           */
#define  EXTSCAN_ALT1  0x78           /* Alt 1                               */
#define  EXTSCAN_ALT2  0x79           /* Alt 2                               */
#define  EXTSCAN_ALT3  0x7A           /* Alt 3                               */
#define  EXTSCAN_ALT4  0x7B           /* Alt 4                               */
#define  EXTSCAN_ALT5  0x7C           /* Alt 5                               */
#define  EXTSCAN_ALT6  0x7D           /* Alt 6                               */
#define  EXTSCAN_ALT7  0x7E           /* Alt 7                               */
#define  EXTSCAN_ALT8  0x7F           /* Alt 8                               */
#define  EXTSCAN_ALT9  0x80           /* Alt 9                               */
#define  EXTSCAN_ALT0  0x81           /* Alt 0                               */
#define  EXTSCAN_ALTMINUS 0x82        /* Alt -                               */
#define  EXTSCAN_ALTEQUAL 0x83        /* Alt =                               */
#define  EXTSCAN_CTRLPGUP 0x84        /* Ctrl PgUp                           */
#define  EXTSCAN_F11   0x85           /* F11 ENHANCED BIOS                   */
#define  EXTSCAN_F12   0x86           /* F12 ENHANCED BIOS                   */
#define  EXTSCAN_SHIFTF11 0x87        /* Shift F11 ENHANCED BIOS             */
#define  EXTSCAN_SHIFTF12 0x88        /* Shift F12 ENHANCED BIOS             */
#define  EXTSCAN_CTRLF11 0x89         /* Ctrl F11 ENHANCED BIOS              */
#define  EXTSCAN_CTRLF12 0x8A         /* Ctrl F12 ENHANCED BIOS              */
#define  EXTSCAN_ALTF11 0x8B          /* Alt F11 ENHANCED BIOS               */
#define  EXTSCAN_ALTF12 0x8C          /* Alt F12 ENHANCED BIOS               */
#define  EXTSCAN_CTRLUP 0x8D          /* Ctrl Up ENHANCED BIOS               */
#define  EXTSCAN_CTRLKPMINUS 0x8E     /* Ctrl Keypad - ENHANCED BIOS         */
#define  EXTSCAN_CTRLCENTER 0x8F      /* Ctrl Center ENHANCED BIOS           */
#define  EXTSCAN_CTRLKPPLUS 0x90      /* Ctrl Keypad + ENHANCED BIOS         */
#define  EXTSCAN_CTRLDOWN 0x91        /* Ctrl Down ENHANCED BIOS             */
#define  EXTSCAN_CTRLINS 0x92         /* Ctrl Ins ENHANCED BIOS              */
#define  EXTSCAN_CTRLDEL 0x93         /* Ctrl Del ENHANCED BIOS              */
#define  EXTSCAN_CTRLTAB 0x94         /* Ctrl Tab ENHANCED BIOS              */
#define  EXTSCAN_CTRLKPSLASH 0x95     /* Ctrl Keypad / ENHANCED BIOS         */
#define  EXTSCAN_CTRLKPMULT 0x96      /* Ctrl Keypad * ENHANCED BIOS         */
#define  EXTSCAN_ALTHOME 0x97         /* Alt Home ENHANCED BIOS              */
#define  EXTSCAN_ALTUP 0x98           /* Alt Up ENHANCED BIOS                */
#define  EXTSCAN_ALTPGUP 0x99         /* Alt PgUp ENHANCED BIOS              */
#define  EXTSCAN_ALTLEFT 0x9B         /* Alt Left ENHANCED BIOS              */
#define  EXTSCAN_ALTRIGHT 0x9D        /* Alt Right ENHANCED BIOS             */
#define  EXTSCAN_ALTEND 0x9F          /* Alt End ENHANCED BIOS               */
#define  EXTSCAN_ALTDOWN 0xA0         /* Alt Down ENHANCED BIOS              */
#define  EXTSCAN_ALTPGDN 0xA1         /* Alt PgDn ENHANCED BIOS              */
#define  EXTSCAN_ALTINS 0xA2          /* Alt Ins ENHANCED BIOS               */
#define  EXTSCAN_ALTDEL 0xA3          /* Alt Del ENHANCED BIOS               */
#define  EXTSCAN_ALTKPSLASH 0xA4      /* Alt Keypad / ENHANCED BIOS          */
#define  EXTSCAN_ALTTAB 0xA5          /* Alt Tab ENHANCED BIOS               */
#define  EXTSCAN_ALTKPENTER 0xA6      /* Alt Keypad Enter ENHANCED BIOS      */

/*
*/
#define  EXTSCAN_F13   0xEC           /* F13 ENHANCED BIOS                   */
#define  EXTSCAN_F14   0xED           /* F14 ENHANCED BIOS                   */
#define  EXTSCAN_F15   0xEE           /* F15 ENHANCED BIOS                   */
#define  EXTSCAN_F16   0xEF           /* F16 ENHANCED BIOS                   */
#define  EXTSCAN_F17   0xF4           /* F17 ENHANCED BIOS                   */
#define  EXTSCAN_F18   0xF5           /* F18 ENHANCED BIOS                   */
#define  EXTSCAN_F19   0xF6           /* F19 ENHANCED BIOS                   */
#define  EXTSCAN_F20   0xF7           /* F20 ENHANCED BIOS                   */
#define  EXTSCAN_F21   0xF8           /* F21 ENHANCED BIOS                   */
#define  EXTSCAN_F22   0xF9           /* F22 ENHANCED BIOS                   */
#define  EXTSCAN_F23   0xFA           /* F23 ENHANCED BIOS                   */
#define  EXTSCAN_F24   0xC0           /* F24 ENHANCED BIOS                   */
#define  EXTSCAN_SHIFTF13 0xC1        /* Shift F13 ENHANCED BIOS             */
#define  EXTSCAN_SHIFTF14 0xC3        /* Shift F14 ENHANCED BIOS             */
#define  EXTSCAN_SHIFTF15 0xC4        /* Shift F15 ENHANCED BIOS             */
#define  EXTSCAN_SHIFTF16 0xC5        /* Shift F16 ENHANCED BIOS             */
#define  EXTSCAN_SHIFTF17 0xC6        /* Shift F17 ENHANCED BIOS             */
#define  EXTSCAN_SHIFTF18 0xC7        /* Shift F18 ENHANCED BIOS             */
#define  EXTSCAN_SHIFTF19 0xC8        /* Shift F19 ENHANCED BIOS             */
#define  EXTSCAN_SHIFTF20 0xC9        /* Shift F20 ENHANCED BIOS             */
#define  EXTSCAN_SHIFTF21 0xCA        /* Shift F21 ENHANCED BIOS             */
#define  EXTSCAN_SHIFTF22 0xCB        /* Shift F22 ENHANCED BIOS             */
#define  EXTSCAN_SHIFTF23 0xCC        /* Shift F23 ENHANCED BIOS             */
#define  EXTSCAN_SHIFTF24 0xCD        /* Shift F24 ENHANCED BIOS             */
#define  EXTSCAN_CTRLF13 0xCE         /* Ctrl F13 ENHANCED BIOS              */
#define  EXTSCAN_CTRLF14 0xCF         /* Ctrl F14 ENHANCED BIOS              */
#define  EXTSCAN_CTRLF15 0xD0         /* Ctrl F15 ENHANCED BIOS              */
#define  EXTSCAN_CTRLF16 0xD1         /* Ctrl F16 ENHANCED BIOS              */
#define  EXTSCAN_CTRLF17 0xD2         /* Ctrl F17 ENHANCED BIOS              */
#define  EXTSCAN_CTRLF18 0xD3         /* Ctrl F18 ENHANCED BIOS              */
#define  EXTSCAN_CTRLF19 0xD4         /* Ctrl F19 ENHANCED BIOS              */
#define  EXTSCAN_CTRLF20 0xD5         /* Ctrl F20 ENHANCED BIOS              */
#define  EXTSCAN_CTRLF21 0xD6         /* Ctrl F21 ENHANCED BIOS              */
#define  EXTSCAN_CTRLF22 0xD7         /* Ctrl F22 ENHANCED BIOS              */
#define  EXTSCAN_CTRLF23 0xD8         /* Ctrl F23 ENHANCED BIOS              */
#define  EXTSCAN_CTRLF24 0xD9         /* Ctrl F24 ENHANCED BIOS              */
#define  EXTSCAN_ALTF13 0xDA          /* Alt F13 ENHANCED BIOS               */
#define  EXTSCAN_ALTF14 0xDB          /* Alt F14 ENHANCED BIOS               */
#define  EXTSCAN_ALTF15 0xDC          /* Alt F15 ENHANCED BIOS               */
#define  EXTSCAN_ALTF16 0xDD          /* Alt F16 ENHANCED BIOS               */
#define  EXTSCAN_ALTF17 0xDE          /* Alt F17 ENHANCED BIOS               */
#define  EXTSCAN_ALTF18 0xDF          /* Alt F18 ENHANCED BIOS               */
#define  EXTSCAN_ALTF19 0xE2          /* Alt F19 ENHANCED BIOS               */
#define  EXTSCAN_ALTF20 0xE3          /* Alt F20 ENHANCED BIOS               */
#define  EXTSCAN_ALTF21 0xE4          /* Alt F21 ENHANCED BIOS               */
#define  EXTSCAN_ALTF22 0xE5          /* Alt F22 ENHANCED BIOS               */
#define  EXTSCAN_ALTF23 0xE6          /* Alt F23 ENHANCED BIOS               */
#define  EXTSCAN_ALTF24 0xE7          /* Alt F24 ENHANCED BIOS               */
#define  EXTSCAN_CLEAR 0xFB           /* CLEAR ENHANCED BIOS                 */
#define  EXTSCAN_SHIFTCLEAR 0xFB      /* SHIFT CLEAR ENHANCED BIOS           */
#define  EXTSCAN_CTRLCLEAR 0xFC       /* CTRL CLEAR ENHANCED BIOS            */
#define  EXTSCAN_ALTCLEAR 0xFD        /* ALT CLEAR ENHANCED BIOS             */
#define  EXTSCAN_ERASEEOF 0xF0        /* ERASEEOF ENHANCED BIOS              */
#define  EXTSCAN_SHIFTEEOF 0xF1       /* SHIFTEEOF ENHANCED BIOS             */
#define  EXTSCAN_CTRLEEOF 0xF2        /* CTRLEEOF ENHANCED BIOS              */
#define  EXTSCAN_ALTEEOF 0xF3         /* ALTEEOF ENHANCED BIOS               */
#define  EXTSCAN_PA1   0xE8           /* PA1 ENHANCED BIOS                   */
#define  EXTSCAN_SHIFTPA1 0xE9        /* SHIFT PA1 ENHANCED BIOS             */
#define  EXTSCAN_CTRLPA1 0xEA         /* CTRL PA1 ENHANCED BIOS              */
#define  EXTSCAN_ALTPA1 0xEB          /* ALT PA1 ENHANCED BIOS               */

/*
** reduce queue size for memory reduction
*/
/*#define MaxEventQue     100                                     ss0001 */
/*#define MaxWVDMQue       50                                     ss0006 */
#define MaxEventQue      50                                       /* ss0030 */
#define MaxWVDMQue       30                                       /* ss0030 */

#define CreateEventSem(phev) \
            VDHCreateSem(phev, VDH_EVENTSEM)                      /* ss0001 */
#define DestroyEventSem(hev) \
            VDHDestroySem(hev)                                    /* ss0001 */
#define ResetEventSem(hev) \
            VDHResetEventSem(hev)                                 /* ss0001 */
#define PostEventSem(hev) \
            VDHPostEventSem(hev)                                  /* ss0001 */
#define WaitEventSem(hev) \
            VDHWaitEventSem(hev, SEM_INDEFINITE_WAIT)             /* ss0001 */

/*
**    Private Function Prototypes
*/

/*
** File: vkbd.c
*/
BOOL EXPENTRY VDDInit(PSZ);

BOOL HOOKENTRY VKExit(VOID);
BOOL HOOKENTRY VKCreateVDM(HVDM);
#ifdef DBCSVDM
BOOL HOOKENTRY VKCreateDoneVDM(HVDM);                             /* ss0033 */
#endif
BOOL HOOKENTRY VKTerminateVDM(HVDM);
BOOL HOOKENTRY VKSetFgnd(HVDM);
BOOL HOOKENTRY VKSetBgnd(HVDM);
BOOL HOOKENTRY VKSetCodePage(ULONG);
BOOL PRIVENTRY vkCreateRX(ULONG,PPCPENTRY);
VOID PRIVENTRY vkDestroyRX(PCPENTRY);
ULONG EXPENTRY VKSetExtraKeys(ULONG,HVDM,ULONG,PCHAR);
ULONG EXPENTRY VKSetFastPaste(ULONG,HVDM,ULONG,PCHAR);
ULONG EXPENTRY VKSetKbdRestrict(ULONG,HVDM,ULONG,PCHAR);

ULONG EXPENTRY VKAltHome(ULONG,HVDM,ULONG,PCHAR);
ULONG EXPENTRY VKHotKeyBypass(ULONG,HVDM,ULONG,PCHAR);
PCHAR PASCAL VKgetTheValue(PCHAR,ULONG,PULONG);
VOID VDHENTRY VDHRegisterScreenProc(PFNSCRNP);
#ifdef DBCSVDM
VOID PRIVENTRY VKInitBIOSJData(USHORT);                           /* ss0002 */
VOID PRIVENTRY VKInitBIOSVData(VOID);                             /* j-mi02 */
USHORT PRIVENTRY VKSetKbdType( USHORT );                          /* ss0024 */
#endif
USHORT VDHENTRY VDHQueryKeyShift(HVDM);

/*
** File: vkbdint.c
*/
SBOOL VDDENTRY VKPDDProc(ULONG,F16PVOID,F16PVOID);
VOID HOOKENTRY VKPasteTimeout(PVOID,PCRF);
VOID HOOKENTRY VKHotPlugEvent(PHVDM,PCRF);
VOID PRIVENTRY VKKbdChanged(HVDM,ULONG);
VOID HOOKENTRY VKIntEvent(ULONG,PCRF);
VOID HOOKENTRY VKEOIProc(PCRF);
VOID HOOKENTRY VKIRETProc(PCRF);
BOOL HOOKENTRY VKInt09Proc(PCRF);
VOID HOOKENTRY VKInt09PostInt15(PVOID,PCRF);
BOOL PRIVENTRY VKInt09Translate(PCRF,PKKEY);
VOID HOOKENTRY VKInt09PauseReturn(PVOID,PCRF);
VOID HOOKENTRY VKInt09PostBreak(PVOID,PCRF);
VOID HOOKENTRY VKInt09PostPrtSc(PVOID,PCRF);
VOID HOOKENTRY VKInt09PostSysReq(PVOID,PCRF);
VOID PRIVENTRY VKInt09Complete(PCRF);
VOID PRIVENTRY VKInt09IntRet(PCRF);
VOID HOOKENTRY VKInt09PostIntReturn(PVOID,PCRF);
VOID PRIVENTRY VKInt09Return(PCRF);
VOID PRIVENTRY VKDisableKbd(VOID);
VOID PRIVENTRY VKUpdateLEDs(HVDM);
VOID PRIVENTRY VKEnableKbd(VOID);
BOOL HOOKENTRY VKInt16Proc(PCRF);
#ifdef DBCSVDM
BOOL PRIVENTRY VKInt16JProc(PCRF);                                /* ss0001 */
#endif
VOID PRIVENTRY VKInt16PostVDD(ULONG);
VOID HOOKENTRY VKInt16ProcReturn(PVOID,PCRF);
#ifdef DBCSVDM
VOID HOOKENTRY VKInt16VProcReturn(PVOID, PCRF);                   
VOID HOOKENTRY VKInt16JReadChar(PVOID, PCRF);                     /* ss0001 */
#endif
USHORT PRIVENTRY VKGetEnhancedShift(HVDM);
VOID PRIVENTRY VKPutEnhancedShift(PKKEY);
VOID PRIVENTRY VKModifyNormalKey(PKKEY);
#ifdef DBCSVDM
VOID PRIVENTRY VKSetUSShift(HVDM,USHORT);                         /* ss0002 */
VOID PRIVENTRY VKSetDBCSShift(HVDM,UCHAR,UCHAR);                  /* ss0001 */
VOID PRIVENTRY VKSetDBCSStatus(HVDM,UCHAR,UCHAR);                 /* ss0001 */
UCHAR PRIVENTRY VKChangeDisplay(HVDM,UCHAR);                      /* j-mi16 */
VOID PRIVENTRY VKGetKeyboardType(PCRF);                           /* ss0001 */
UCHAR PRIVENTRY VKConvScanToEpoch(HVDM,UCHAR,UCHAR);              /* ss0035 */
UCHAR PRIVENTRY VKMapPhuketToFerrari(UCHAR);                      /* ss0009 */
UCHAR PRIVENTRY VKCheckScanType(USHORT,UCHAR);                    /* ss0011 */
BOOL PRIVENTRY VKInt16VProc(PCRF);                                /* j-mh0001 */
VOID HOOKENTRY VKInt16VProcPostDisDisp(PVOID,PCRF);               /* j-mi02 */
VOID PRIVENTRY VKChgVDisp(HVDM,PCRF);                             /* j-mi02 */
VOID PRIVENTRY VKSetVDBCSShift(HVDM, UCHAR);                      /* j-mh0001 */
BOOL PRIVENTRY VKCheckShiftTable(UCHAR, USHORT);                  /* ss0019 */
USHORT PRIVENTRY VKConvShiftState(USHORT,USHORT);                 /* ss0016 */
BOOL PRIVENTRY VKConvScanToChar(UCHAR, PKKEY);                    /* ss0016 */
BOOL PRIVENTRY VKCheckSpecialKey(PCRF, USHORT);                   /* ss0019 */
USHORT PRIVENTRY VKMakeShiftMask(USHORT, USHORT);                 /* ss0020 */
VOID PRIVENTRY VKChangeXlateTbl(PCRF);                            /* ss0016 */
VOID HOOKENTRY VKChangeSpecialTbl(PVOID, PCRF);                   /* ss0016 */
VOID PRIVENTRY VKCompXlateTbl(VOID);                              /* ss0042 */
BOOL PRIVENTRY vkNComp(PULONG,PULONG,USHORT);                     /* ss0042 */
#endif

/*
** File: vkbdbuf.c
*/
PKEYPKT PRIVENTRY VKNextScanPtr(PKEYPKT);
PKEYPKT PRIVENTRY VKPrevScanPtr(PKEYPKT);
BOOL PRIVENTRY VKAddScan(HVDM,PKEYPKT,ULONG);
RETCODE PRIVENTRY VKPeekScan(HVDM);
BYTE PRIVENTRY VKRemoveScan(HVDM,BOOL);
VOID PRIVENTRY VKClearScan(HVDM);
VOID HOOKENTRY VKTransferScanHook(PHVDM,PCRF);
VOID HOOKENTRY VKTransferScan(HVDM,BOOL);
VOID PRIVENTRY VKSimulateInt(HVDM);
BOOL PRIVENTRY VKAddKey(HVDM,UCHAR,UCHAR);
USHORT PRIVENTRY VKNextKeyPtr(HVDM,USHORT);
VOID PRIVENTRY VKClearKeys(HVDM);
BOOL PRIVENTRY VKAddExtraKey(HVDM,UCHAR,UCHAR);
ULONG PRIVENTRY VKNextExtraKeyPtr(ULONG);
VOID PRIVENTRY VKTransferExtraKey(VOID);
#ifdef DBCSVDM
VOID PRIVENTRY VKAdjustKeyPtr(HVDM, SHORT);                       /* ss0038 */
BOOL PRIVENTRY vkPushEvent(HVDM, register VKEVENT *);             /* ss0006 */
VOID PRIVENTRY vkPushKeyToFVDM(register VKEVENT *);               /* ss0006 */
VOID PRIVENTRY vkPushKeyToWVDM(HVDM, register VKEVENT *);         /* ss0006 */
VOID PRIVENTRY vkPopEvent(register PVOID);                        /* ss0001 */
VOID PRIVENTRY vkPopEventWVDM(HVDM, register PVOID);              /* ss0006 */
VOID PRIVENTRY vkPushScan(HVDM, UCHAR, BOOL);                     /* ss0020 */
UCHAR PRIVENTRY vkPopScan(HVDM, BOOL);                            /* ss0020 */
UCHAR PRIVENTRY vkPeekScanBuff(HVDM, BOOL);                       /* ss0020 */
#endif

/*
** File: vkbdreq.c
*/
LONG EXPENTRY VKSysReqProc(SGID,ULONG,ULONG,PVOID,ULONG,PVOID);
LONG PRIVENTRY vkSysSetAccess(HVDM,BOOL,PVOID,ULONG,PVOID);
VOID PRIVENTRY vkSysAddExpandScan(HVDM,UCHAR);
VOID PRIVENTRY vkSysXferExpandScan(HVDM);
VOID PRIVENTRY vkSysSyncShift(HVDM,USHORT,USHORT);
LONG PRIVENTRY vkSysSetFocus(HVDM,ULONG,PSHIFTPKT,ULONG,PVOID);
VOID PRIVENTRY vkSysEndPaste(HVDM);
LONG PRIVENTRY vkSysPostScan(HVDM,ULONG,PKEYPKT,ULONG,PULONG);
VOID PRIVENTRY vkSysSimCtrlAltUps(HVDM,PUSHORT);
VOID PRIVENTRY vkSysAddNumScans(HVDM,UCHAR);
VOID PRIVENTRY vkSysReverseXlate(HVDM,UCHAR,PUSHORT);
LONG PRIVENTRY vkSysPostChar(HVDM,ULONG,PUCHAR,ULONG,PULONG);
#ifdef DBCSVDM
CHAR PRIVENTRY vkSysDBCSXlate(HVDM, UCHAR);                       /* ss0024 */
CHAR PRIVENTRY vkChkDBCS(HVDM, UCHAR);                            /* j-mh0011 */
LONG PRIVENTRY vkSysMonRegist(HVDM, ULONG, PVOID, ULONG, PVOID);    /* ss0001 */
LONG PRIVENTRY vkSysMonDeregist(HVDM, ULONG, PVOID, ULONG, PVOID);  /* ss0001 */
LONG PRIVENTRY vkSysMonRead(HVDM, ULONG, PVOID, ULONG, VKEVENT *);  /* ss0001 */
LONG PRIVENTRY vkSysMonWrite(HVDM, ULONG, VKEVENT *, ULONG, PVOID); /* ss0001 */
LONG PRIVENTRY vkSysSetShift(HVDM, ULONG, VKEVENT *, ULONG, PVOID); /* ss0001 */
LONG PRIVENTRY vkSysGetShift(HVDM, ULONG, PVOID, ULONG, VKEVENT *); /* ss0001 */
LONG PRIVENTRY vkSysRegWVDM(HVDM, ULONG, PVOID, ULONG, PVOID);      /* ss0006 */
LONG PRIVENTRY vkSysDeregWVDM(HVDM, ULONG, PVOID, ULONG, PVOID);    /* ss0006 */
LONG PRIVENTRY vkSysReadWVDM(HVDM, ULONG, PVOID, ULONG, VKEVENT *); /* ss0006 */
LONG PRIVENTRY vkSysWriteWVDM(HVDM, ULONG, VKEVENT *, ULONG, PVOID);/* ss0006 */
BOOL PRIVENTRY VKNoneedKey(register UCHAR);                         /* j-mh0003 */
#endif

/*
** File: vkbdio.c
*/
BYTE HOOKENTRY VKReadCmd(ULONG,PCRF);
VOID HOOKENTRY VKWriteCmd(BYTE,ULONG,PCRF);
BYTE HOOKENTRY VKReadBuff(ULONG,PCRF);
VOID HOOKENTRY VKWriteBuff(BYTE,ULONG,PCRF);
VOID PRIVENTRY VKCheckKbdCmd(BYTE);

/*
** File: vpol.c   polling detection initialization and creation
*/
RETCODE NEAR PASCAL VPLCreate(HVDM);
VOID NEAR PASCAL VPLInit(VOID);
VOID VDHENTRY VDHNoIdle(HVDM,ULONG); 

/*
**   If VDDSTRICT is defined, the Assert macros generate appropriate code.
**
**   If VDDSTRICT is not defined, the Assert macros are NO-OPs (with the
**   exception of AssertRC, in which case the function is still called, but
**   the return code is not checked).
**
**   If VDDDEBUG is defined, debug printfs (PRINTDEBUGs) are generated, and
**   failed assertions (assuming VDDSTRICT is defined) break at the assertion
**   rather than in the kernel's "panic" service.  VDDDEBUG requires the
**   kernel debugger, in other words.
**
**   If VDDDEBUG is not defined, debug printfs (PRINTDEBUGs) are NOT
**   generated, and failed assertions (assuming VDDSTRICT is defined) simply
**   panics.
*/

#ifdef   VDDSTRICT

/*
** c-begin
*/

extern CHAR szAssertMsg[];
#define MODNAME static CHAR szFile[]

#ifdef VDDDEBUG
#define Assert(t) { \
                    if (!(t)) { \
                      PRINTDEBUG(szAssertMsg, szFile, __LINE__); \
                      INT3(); \
                    } \
                  }
#else
#define Assert(t) { \
                    if (!(t)) { \
                      PANIC(szAssertMsg, szFile, __LINE__); \
                    } \
                  }
#endif

#define AssertTRUE(t)   Assert(t)
#define AssertFALSE(t)  Assert(!(t))
#define AssertZERO(t)   Assert(!(t))
#define AssertNONZERO(t)Assert(t)
#define AssertRC(t)     Assert(t)       /* verify function return code good */

/*
** c-end
*/

#else

/*
** c-begin
*/

#define     Assert(t)
  #define  AssertTRUE(t)
  #define  AssertFALSE(t)
  #define  AssertZERO(t)
  #define  AssertNONZERO(t)
  #define  AssertRC(t)   (t)        /* perform function, but don't verify   */

/*
** c-end
*/

#endif

/*
** Random debugging support
*/

#ifdef   VDDDEBUG

/*
** c-begin
*/

extern CHAR szModule[];
   #undef   PRINTDEBUG
   #define  PRINTDEBUG    printf(szModule);                                 \
                          printf
/*
** c-end
*/
#endif

/******************************************************************************
**************************************************
*    Design Report for Defect 152436             *
**************************************************
*Survey Results:
*
*1) Old Fix -- ALT-HOME(70207)
*   In VKSysSetAccess of VKBDREQ.C:
*   Whenever a DOS session changes between Full Screen and Virtual Winodw
*   by pressing ALT-HOME, it always generates 3 codes :
*         1) alt-break.
*         2) extended-code.
*         3) alt-break.
*   This is because the ALT-HOME will send only two codes to DOS session
*         1) alt-make.
*         2) home-make.
*   The other two codes, alt-break and home-break, get lost during the
*   screen transition.
*
*   No one complained about this old fix. I guess it's because if it causes
*   problems, users just open the DOS session at the screen mode they want or
*   they just press alt key once more to togle the side effect back
*   occasionally.
*
*   But this old fix will generate those extra break codes during the coming
*   up of a full screen DOS or a full screen WINOS2, even there is no ALT-HOME
*   hot key pressed. Those extra codes never cause problems in Full screen
*   WINOS2. But it might cause problems in Full Screen DOS.
*
*2) DOS full screen
*   While the screen group is changing, some functions (probably in PMSHELL.
*   Detail unknown) will call KBDIOCTL of KBD with GIOFunction of request
*   packet == 41h and GIOCategory == 0Bh. This request happens at the New
*   Screen-Group Creations and the Screen-Group switchings.
*   Later, it will call SGController to execute the request.
*   SGController then calls Update_SG_SS to sync the shift-ctl-alt states of
*       Screen Group.
*   Update_SG_SS then call Send_SScans to sync shift-ctl-alt states.
*
*   The rule of synchronization should be as the comment of function
*   Update_SG_SS:
*     This routine will synch up the logical and physical
*     shift states for both the incoming and outgoing
*     screen group. It will set a bit in the Sendit field
*     in the ShiftKeyTable which indicates which shift ke
*     scan code must be send to both in outgoing and
*     incoming screen groups.
*
*     This means, I think, if any of shift, ctrl or alt keys is pressed down.
*     Update_GS_SS will send shift-break, ctrl-break or alt-break code
*     accordingly to the outgoing Screen Group.
*     and send shift-make, ctrl-make or alt-make code to the new screen group.
*     The screen group means an independent screen used by one or more session.
*     Such as: DOS Full Screen/WINOS2 full screen,
*              OS/2 PM + Seamless WinOS2.
*
*   It's an orginal design, not an old fix. I don't think we should take away
*   this design.
*
*3) The VKSysSyncShift is called to sync the alt-ctrl-shift status.
*   It's calledd in the following functions:
*   a) VKSysSetAccess -- This function is called at a VDM creation, termination
*                        and whenever a DOS switches between Full Screen
*                        and Virtual Screen by ALT-Home. But if DOS gets back
*                        focus but not changes its own screen group, this
*                        function won't be called.
*
*                        If the VDM is valid, VKSysSyncShift is called to sync
*                        the shift status. But there is something       with its
*                        source shift-status flag - fsPMShift. No one really
*                        maintain the flag up to date. The flag should not be
*                        referenced. That's     70207 came into place. However,
*                        70207 just blindly sends out break-codes to kill all
*                        the diseases without maintaining the flag.
*                        (Defect 70207 will always add extra break codes
*                          when DOS turn to full screen. See result point 1.)
*
*   b) VKSetFocus     -- Called Whenever a DOS session get focus or lose focus
*
*                        If the VDM is valid, DOS session is getting focus and
*                        the keyboard scan codes all sent to the DOS,
*                        VKSysSyncShift will be called to sync the shift status.
*                        The comment says if the DOS session is getting
*                        focus and the keyboard scan codes is not fully sent to
*                        DOS session. No further sync action will be taken.
*
*   c) VKEndPaste     -- This function is not related to hot-keys.
*                        VKSysSyncShift is called to handle the shift-status
*                        during pasting.
*
*4) When a DOS session is switching from Full Screen to Virtual Window by
*   ALT-Home, we always get 38 E0 E0 B8.
*     38 -- ALT-make, generate by PKBD because of the keyboard stroke
*     E0 -- The extended code of HOME0Make.
*        PKBD eats: 47 -- The HOME-Make code
*     E0 -- The extended code of HOME-Break code.
*        PKBD eats: C7 -- The HOME-Break code
*     B8 -- ALT-Break code.
*           This code is generated in two ways.
*           a) If we pressed the ALT-home quickly without holding the key down.
*              It's generated by PKBD because of the keyboard stroke.
*           b) If we pressed the ALT-home slowly by holding the key down for a
*              while. It's generated Update_SG_SS, see result point 2.
*   This does not cause problems because two E0 codes make these codes
*   nonsense to DOS. So both of them are ignored by DOS/WINOS2, I think.
*
***************************************************
*New problems --
*1) Stick Key Problem --
*   The purposes of the old fixes are solving the sticky problem. The sticky
*   problem means while switch focus out or in, DOS gets ALT-make code and
*   think the ALT-key is pressed. So, it translates any following key as
*   ALT-x code, which make no sense to application and user think the
*   keyboard is not functioning.
*
*   Once we take away the old fixes and implement the timer solution. We
*   solve most of the sticky problems but not all. For example the following
*   scenario will cause sticky problem:
*   A user tries to press ALT-ESC to switch out focus. But he presses the
*   ALT key a little longer than usual. He will generates one or more
*   repeated ALT-make code. We will send out the first ALT-make code once
*   we receive the next ALT-make code. Our solution will be able to kill the
*   last ALT-make code. But, it can not take back the sent ALT-make codes.
*   The sticky problem happens when the DOS session gets back focus.
*
*   We need to prevent the new sticky problems if we take off the old fixes.
*
*2) Potential Problem:
*   When we use the ALT-Esc to set focus back to DOS Full Screen session.
*   If we release the ALT-Esc key really quickly, some sticky problems might
*   happen.
*
*   VKSysSetFocus occurs the earliest in this scenario. Then the request
*   of Update_SG_SS. If the ALT-Break code is sent into PKBD between
*   VKSysSetFocus and Update_SG_SS. Then the sticky problem will happen.
*   Because, the VKSysSetFocus will sync the ALT key status, which will
*   send an ALT-Make code to DOS. Then the ALT-Break comes in and erase
*   the ALT-key-is-down status. ALt-Break code won't sent to to the DOS
*   session, either. DOS will think the ALT key is still down. So,
*   all the following keyboard strokes will be ignored, because they are
*   taken as ALT-x keys.
*
*   I put some debugging-display commands in VKBD to postpone the performance,
*   I was able to produced this problem easily. But, I can not reproduce the
*   problem without delaying the performance.
*
*   I guess in some slow, RAM-insufficient PCs or when OS/2 is running a lot
*   of applications, its performance slows down a lot, this potential problem
*   might occur.
*
*   Actually, before I came in IBM, I hit some problems like this before.
*   It happens once a while when I was using a lot of applications. And it
*   really bothered me. Because, I thought the application running in
*   DOS full screen is dead and I can not save what I did in that application.
*
*
***************************************************
*Problems, comments and Solutions--
*
*1) Problem:
*     Old Fix - ALT-Home(70207)
*     It causes problems in defect#152436. Mostly because it sends three
*     scan codes during a Full Screen DOS coming up.
*
*     It might cause problems in the other scenario of Screen Group being
*     changed by ALT-HOME. But Users won't ask for troubles by pressing
*     ALT-Home in those cases.
*
*   Solution:
*     To minimize our fix, we only kill the extra scan codes which are sent
*     during a Full Screen DOS coming up.
*
*     When the VKSysSetAccess is called at creation time (the first time),
*     don't send ALT-Break codes. After that, it's caused by ALT-Home,
*     the ALT-Break codes are needed.
*
*   Comments:
*     For future release:
*       a) In VKSysSetAccess, it already calls VKSysSyncShifts. The root cause
*          is: The parameter fsPMShift of VKSysSetAccess is not up to date.
*          The 70207 should be taken away and correctly call VKSysSyncShifts
*          instead.
*       b) Currently, VKSysSyncShifts depends on the BIOS Keyboard flags of DOS
*          session( 40:17, 40:18...) to decide what the current statuses
*          of ALT-SHIFT-CTRL are. But this is not a good algorithm. Because
*          VKBD does not directly send the scan codes into DOS. VKBD always
*          stores the scan codes in a queue and dispatches them to DOS through
*          VPIC.
*          When VKSysSyncShifts is called, VKBD might still has some scan codes
*          in the queue which might change the status of the BIOS Keyboard
*          flags. The best way to solve this problem is to monitor the
*          Keyboard flags by VKBD itself. So, It can always sync the Shifts
*          statuses correctly. This will also solve the BUGBUG comment in the
*          VKSysSetFocus, too.
*
*2) Problem:
*     The VKSysSyncShifts in VKSysSetFocus tries to sync the ALT key statuses.
*     This is necessary in Virtual Window DOS or Seamless WINOS2.
*
*     But in Full Screen DOS session, this won't be necessary. Because
*     whenever a Full Screen DOS session gets Focus also means its Screen
*     Group is changed back from the other Screen Group. And the Screen Group
*     changing will cause Update_SG_SS of PKBD to sync the key board statuses,
*     too.
*
*   Solution:
*     To minimize our fix, we only kill the ALT-Make scan codes from
*     VKSysSyncShifts of VKSysSetFocus when the DOS/WINOS2 is in Full Screen,
*     , which could cause a potential sticky problem, see New Problem point 2.
*
*   Comments:
*     For future release:
*     We need to figure out how many duplications between this two functions:
*     VKSysSyncShifts of VKBD and Update_SG_SS of PKBD. This kind of
*     duplication happens in two processes could cause difficult problems.
*
*3) Problem:
*     When using ALT-Esc to switch out focus in Full Screen, the ALT-make
*     code will be sent to DOS session. It causes sticky problems.
*     The old way is to generate a ALT-Break code before losing focus.
*     But in this way, VKBD generate an extra ALT key codes, which will
*     highlighted the menu of Windows.
*
*   Solution:
*     Designed by Mark Rogalski, Robert Rose and Diane Willis
*     Using a timer to delay the ALT-make to be sent to DOS session.
*     ( If DOS setting IDLE sensitivity > 75 then no delay at all.
*       Otherwise The timer should twice of the time of the repeat delay rate.)
*     That means we won't send ALT-make code or Extend Code + ALT-make code
*     to DOS unless one of the following coditions happen:
*        a) No delay at all
*        b) Time out of the timer.
*        c) Other scand codes come in.
*
*   New problem:
*     Once we install this solution, we will eliminate most of the extra
*     ALT-make codes. Of course, not all of them.
*
*     But the VKSysSyncShifts in VKSysSetFocus of Full Screen DOS/WINOS2
*     will still generate an ALT-Make code if it get back focus by ALT-Esc.
*     And the Update_SG_SS might generate an ALT-Make, whcih will be followed
*     by ALT-Break code, while the screen group changes back. This cause another
*     Windows Menu Highlighted problem.
*
*   New solution:
*     We need to implement the solution 2. And we need to kill the ALT-make
*     code from Update_SG_SS of PKBD.
*
*   Comments:
*     Making changes in Update_SG_SS of PKBD will affect the whole OS/2 system.
*     It's very risky.
*
*     The solution we do for this new problem is killing the ALT-Make and
*     extend-code + ALT-Make code in both of these coditions are true :
*       a) The DOS session is a Full Screen
*       b) The ALT-Make code is received within 0.5 second after VKSysSetFocus
*          is called.
*
*     For future release:
*       Set a flag inside the Scan Code Packet to identify itself as
*       a scan code generated by Update_SG_SS.
*************************************
** End of design for Defect 152436 **
*************************************
****/

/* Data structure definition for defect 152436 */
typedef
  struct ST_AltEsc_HotKey
    {
      BOOL   bTrigger;           /* TRUE : Do ALT-ESC handling              */
                                 /* False: No ALT-Esc Handling              */
      KEYPKT keypktExtend;       /* For saving the extended code            */
                                 /* Extended ALT-Make is one of HotKeys     */
      BOOL   bExtendedCodeSaved; /* TRUE : Extended Code is saved           */
                                 /* False: Extended Code is not saved       */
      KEYPKT keypktAltMake;      /* For saving the ALT-Make code            */
      BOOL   bAltMakeCodeSaved;  /* TRUE : ALTMake  Code is saved           */
                                 /* False: ALTMake  Code is not saved       */

      ULONG  ulGetFocusTime;     /* The time of DOS session gets focus      */
                                 /* Milisecond from booting.                */
                                 /* If it's zero, DOS not get any focus yet */
      BOOL   bAltLeftDown;       /* TRUE : ALT left  key is down            */
                                 /* TRUE : ALT left  key is down            */
      BOOL   bAltRightDown;      /* TRUE : ALT right key is down            */
                                 /* TRUE : ALT right key is down            */
    } ALTESC_HOTKEY;
typedef ALTESC_HOTKEY * PALTESC_HOTKEY;

extern ALTESC_HOTKEY stAltEsc_HotKey;/* Defined in VKBD, initialized in DOS  */
                                     /* Creation and ended at DSO termination*/
                                     /* See defect 152436                    */
#define pAltEscHotKey(hVdm) \
     ((PALTESC_HOTKEY)&REFHVDM(hVdm,ALTESC_HOTKEY,stAltEsc_HotKey))/* 152436 */

#define DEFAULT_LEVEL             75 /* move here from VPOL.C         152436 */

#define ALT_MAKE_CODE  0x38  /* ALT-Make scan code  */
#define ALT_BREAK_CODE 0xB8  /* ALT-Break scan code */
#define EXTENDED_CODE  0xE0  /* Extend code         */

#define MSEC_TO_DISCARD_HOT_KEY 500 /* 500 milisecond */

LONG vkHotKeyFilter(HVDM hvdm,PKEYPKT pkp,ULONG flType );
BOOL vkIsBuffEnough(HVDM hvdm, int iNum );                        /*152436   */
BOOL vkAddScanCode(HVDM hvdm, PKEYPKT pkp );                       /*152436   */
