;       SCCSID = @(#)vcomreq.asm        6.3 91/11/11

        Page    ,132
        NAME    VCOM
        TITLE   VCOM     - Virtual COM device driver
        SUBTTL  VCOMREQ.ASM - Request handler routines for VCOM
; ****************************************************************************
; *                                                                          *
; *                       IBM/Microsoft Confidential                         *
; *                                                                          *
; *                 Copyright (c) IBM Corporation  1987, 1990                *
; *                 Copyright (c) Microsoft Corp.  1987, 1990                *
; *                           All Rights Reserved                            *
; *                                                                          *
; ****************************************************************************

;;;;;;;;;;;;;;;;;;;;;;; START OF FILE SPECIFICATION ;;;;;;;;;;;;;;;;;;;;;;;;;;
;SOURCE FILE NAME: VCOMREQ.ASM
;
;DESCRIPTIVE NAME: VCOM Request handler routines
;
;FUNCTION:
;       This file contains procedures that handle various requests
;       (i.e. Set MCR, etc) for VCOM
;
;SUBROUTINES:
;       Open_Request
;       Close_Request
;       Set_DLLDLM_Request
;       Set_MCR_Request
;       Set_LCR_Request
;       Get_DLLDLM_Request
;       Get_MCR_Request
;       Get_LCR_Request
;       Get_MSR_Request
;       PDDProc_Handler
;       PDDProc_IOCTL_Handler
;       Popup_Display
;
;EXTERNAL REFERENCES:
;       VDHQuerySysValue
;       VDHPopUp
;       VDHKillVDM
;       VDHRemoveIOHook
;       VDHFreeHook
;
;;;;;;;;;;;;;;;;;;;;;;; END OF FILE SPECIFICATION ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;       Jin Kim
;       Yoshihiko Nishida
;       Allen C. Wynn
;       (c) International Business Machines Corporation
;       January 1989
;
;Modification History
;
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

        .386p

.xlist
include STRUC.INC
include VCOM.INC
include mvdm.inc
include error.inc
.list

include VDDSEG.INC
include VCOMDATA.INC

DefCode     EXPORT,SWAP,PASCAL            ;Start CSWAP_TEXT segment
         DefFn  PDDProc_Handler             ;Export definitions
         DefFn  PDDProc_IOCTL_Handler
         DefFn  Popup_Display
         DefFn  Open_Request
         DefFn  Close_Request
         DefFn  Set_DLLDLM_Request
         DefFn  Set_MCR_Request
         DefFn  Set_LCR_Request
         DefFn  Get_DLLDLM_Request
         DefFn  Get_MCR_Request
         DefFn  Get_LCR_Request
         DefFn  Get_MSR_Request
EndCode                                     ;End CSWAP_TEXT segment


DefCode     IMPORT,SWAP,PASCAL            ;Start CSWAP_TEXT segment
        DefFn   Virt_Clear_IIR              ;Import Definitions
EndCode                                     ;End CSWAP_TEXT segment

DefCode     IMPORT,GLOBAL,PASCAL            ;Start _TEXT segment
        DefFn   VDHQuerySysValue
        DefFn   VDHPopup
        DefFn   VDHKillVDM
        DefFn   VDHRemoveIOHook
        DefFn   VDHFreeHook
EndCode                                     ;End _TEXT segment

DefCode     PRIVATE,SWAP,PASCAL           ;Start CSWAP_TEXT segment

;********************** START OF SPECIFICATIONS ******************************
;SUBROUTINE NAME: Open_Request
;
;DESCRIPTIVE NAME: Open COM Port Request
;
;INPUT:
;       EDX = Port_ID
;       ESI -> Base address of PI for this port
;
;OUTPUT:
;       SUCCESS  AH = RETURNGOOD (0)
;       FAILURE  AH = Error      (!0)
;
;RELATED DATA OBJECTS:
;  Instance Data per VDM:
;       NONE
;  Global Data:
;       Variables in Port_Info_Tab (PI table):
;          hVDM_PI
;          VLCR
;          VMCR
;          VMSR
;          VDLL
;          VDLM
;
;FUNCTION:
;       Open COM port and get MCR, MSR, LCR, and DLL,DLM informations.
;
;CALLED BY:
;       Check_Port_Owner
;
;INTERNAL REFERENCES:
;       Get_DLLDLM_Request
;       Get_MSR_Request
;       Get_LCR_Request
;       Get_MCR_Request
;       PDDProc_Handler
;
;EXTERNAL REFERENCES:
;
;NOTE:
;       EAX destroyed
;********************** END OF SPECIFICATIONS *********************************

Open_Request    proc    near

        push    ebx
        push    ecx
        push    edi

        .if <BIT iDOSProp and HW_COM>
            mov     cx,1
        .else
            xor     cx,cx
        .endif
        mov     ax,OPENPORT                 ; Set OPEN command for PCOM = 1h
        call PDDProc_Handler                ; Call PDDProc to open the
                                            ; COM port
        .if <ax eq SUCCESS> NEAR            ; If OPEN succeeded

             mov     eax,ihVDM               ; Set hVDM in PI from ihVDM
             mov     [esi].hVDM_PI,eax       ; to set ownership of the port

             mov     ax,ipdbCurrent          ; Set PDB in PI from current PDB
             mov     [esi].pdb_PI,ax         ; to set ownership of the port

             mov     [esi].flgStatus,0       ; Clear flags
             mov     [esi].flgRxOp,0
             mov     [esi].VIIR_Req,0


            .if <BIT iDOSProp and HW_COM>
                pushf                                    ;Don't want interrupts
                cli                                      ;while we clean up
               .if <iIOHooksDone ne 0>
                  lea     esi,PI

                  xor     ecx,ecx
                  .repeat
                      .if <[esi].Port_Addr ne 0>            ; Disable IO Hook
                          push    ecx
                          lea eax,IOHook                    ; IOHook parameter packet
                          movzx  ecx,[esi].Port_Addr        ; Port address to unhook
                          CallFn VDHRemoveIOHook,<ihVDM,ecx,8,eax>
                          pop     ecx
                          mov     eax,ihVDM
                      .endif
                      add     esi,size Port_Info_Tab  ; Advance to next PI
                      inc     ecx                     ; Next Port id
                  .until <cl ge (iIOHooksDone)>       ; Repeat for all IOHooks Done
                                                      ; (Should be all PI's except in
                                                      ;  case of error in creation)

               ;? CallFn VDHFreeHook,<hhookInt14ReturnHook>  ; Free Int14h hook

               .endif
                popf
            .else

                call    Get_DLLDLM_Request      ; Get DLL/DLM from PCOM and
                                                ; store in VDLL and VDLM
                call    Get_MSR_Request         ; Get MSR from PCOM and
                                                ; store in VMSR
                call    Get_LCR_Request         ; Get LCR from PCOM and
                                                ; store in VLCR
                call    Get_MCR_Request         ; Get MCR from PCOM and

            .endif

            mov     eax, RETURNGOOD         ;
        .else
            mov     eax, NOT RETURNGOOD     ;else failure
        .endif

Open_Ret:
        pop     edi
        pop     ecx
        pop     ebx
        ret                                    ; Return to the caller

Open_Request    endp


;********************** START OF SPECIFICATIONS ******************************
;SUBROUTINE NAME: Close_Request
;
;DESCRIPTIVE NAME: Close COM Port Request
;
;INPUT:
;       EDX = Port_ID
;       ESI -> Base address of PI for this port
;
;OUTPUT:
;       NONE
;
;RELATED DATA OBJECTS:
;  Instance Data per VDM:
;       None
;  Global Data:
;       Variables in Port_Info_Tab (PI table):
;          hVDM_PI
;          flgStatus, flgRxOp,
;
;FUNCTION:
;       Close COM port
;
;CALLED BY:
;       VCOM_VDMTerminate
;
;INTERNAL REFERENCES:
;       Virt_Clear_IIR
;       PDDProc_Handler
;
;EXTERNAL REFERENCES:
;
;NOTE:
;
;********************** END OF SPECIFICATIONS *********************************

Close_Request   proc    near             ;

        push    ecx
        push    eax
        mov     ax,CLOSEPORT             ; Set CLOSE command for PCOM = 2h
        call    PDDProc_Handler          ; Call PCOM to close the COM port

        mov     ah,ALLINT                ; Set all IIR clear command
        call    Virt_Clear_IIR           ; Clear all IIR
        xor     al,al                    ; Set aL to 0 (reduces space below)
        mov     [esi].VIER, al           ; Reset IER to default
        mov     [esi].flgStatus, al      ; Reset flags in PI
        mov     [esi].flgRxOp, al        ; Reset flags in PI
        mov     [esi].VIIR_Req, al       ; Reset VIIR_req to default
        mov     [esi].hVDM_PI,PORT_NOT_OWNED ; Clear hVDM in PI
        mov     [esi].pdb_PI,INVALID_PDB ; Clear PDB in PI
        mov     [esi].VIIR,NO_INT_PENDING; Reset IIR to default
        mov     [esi].VLSR, THRE+TEMT    ; Reset LSR to default
                                         ;** Other registers should         ***
                                         ;** remain the same.               ***
        pop     eax
        pop     ecx
        ret

Close_Request   endp


;********************** START OF SPECIFICATIONS ******************************
;SUBROUTINE NAME: Get_DLLDLM_Request
;
;DESCRIPTIVE NAME: "Get DLL and DLM request" call to PCOM
;
;INPUT:
;       EDX = Port_ID
;       ESI -> Base address of PI for this port
;
;OUTPUT:
;       VDLL, VDLM set
;
;RELATED DATA OBJECTS:
;  Instance Data per VDM:
;       None
;  Global Data:
;       Variables in Port_Info_Tab (PI table):
;          VDLL, VDLM
;FUNCTION:
;       Get PCOM's current DLL/DLM value, and set VDLL/VDLM.
;
;CALLED BY:
;       Open_Request
;
;INTERNAL REFERENCES:
;       PDDProc_Handler
;
;EXTERNAL REFERENCES:
;
;NOTE:
;       All registers saved
;********************** END OF SPECIFICATIONS *********************************

Get_DLLDLM_Request      proc    near
        push    eax
        push    ecx
        mov     ax,GETDLLDLM             ; = 5h
        call    PDDProc_Handler          ; Call PCOM to get DLL and DLM
        mov     [esi].VDLL,cl            ; Store DLL in VDLL
        mov     [esi].VDLM,ch            ; Store DLM in VDLM
        pop     ecx
        pop     eax
        ret                              ; Return to the caller

Get_DLLDLM_Request      endp


;********************** START OF SPECIFICATIONS ******************************
;SUBROUTINE NAME: Get_MSR_Request
;
;DESCRIPTIVE NAME: "Get MSR Request" call to PCOM
;
;INPUT:
;       EDX = Port_ID
;       ESI -> Base address of PI for this port
;
;OUTPUT:
;       VMSR set
;
;RELATED DATA OBJECTS:
;  Instance Data per VDM:
;       None
;  Global Data:
;       Variables in Port_Info_Tab (PI table):
;          VMSR
;          VMSR_delta
;FUNCTION:
;       Get PCOM's MSR value, and set VMSR to it, only when MSINT has
;       not been requested yet.
;
;CALLED BY:
;       Open_Request
;
;INTERNAL REFERENCES:
;
;EXTERNAL REFERENCES:
;       PDDProc_IOCTL_Handler
;
;NOTE:
;       All registers saved.
;********************** END OF SPECIFICATIONS *********************************

Get_MSR_Request proc    near                 ;

        push    eax
        pushfd                               ;save state of flags
        cli                                  ; Disable interrupts
        .if  <BIT [esi].VIIR_Req nand MSINT> ; If not MS Interrupt request,
                                             ; then VMSR needs to be updated.
            mov     ax,GETMSR                ; = 67h
            call    PDDProc_IOCTL_Handler    ; Call PCOM
            mov     al,[esi].Ioctl_Data_Pkt  ; ah = MSR from PCOM
            and     al,not DELTA_BITS        ; Clean up delta bit area, since
                                             ;  this is the initialized value.
            mov     [esi].VMSR,al            ; Set VMSR to it
            mov     [esi].VMSR_Delta,0       ; Set VMSR_Delta to 0 (first time)
        .endif
        popfd                                ; restore state of flags
        pop     eax
                                             ;
        ret                                  ; Return to the caller
Get_MSR_Request endp                         ;


;********************** START OF SPECIFICATIONS ******************************
;SUBROUTINE NAME: Get_LCR_Request
;
;DESCRIPTIVE NAME: "Get LCR Request" call to PCOM
;
;INPUT:
;       EDX = Port_ID
;       ESI -> Base address of PI for this port
;
;OUTPUT:
;       VLCR set
;
;RELATED DATA OBJECTS:
;  Instance Data per VDM:
;       None
;  Global Data:
;       Variables in Port_Info_Tab (PI table):
;          VLCR
;FUNCTION:
;       Get PCOM's LCR value, and set VLCR to it.
;
;CALLED BY:
;       Open_Request
;
;INTERNAL REFERENCES:
;       PDDProc_IOCTL_Handler
;
;EXTERNAL REFERENCES:
;
;NOTE:
;       All registers saved
;********************** END OF SPECIFICATIONS *********************************

Get_LCR_Request proc    near

        push    eax                             ; Save EAX

        mov     ax,GETLCR                       ; = 62h
        call    PDDProc_IOCTL_Handler           ;
                                                ;
        xor     al,al                           ;

        mov     ah,[esi].Ioctl_Data_Pkt.Data_Bits_Data ; Data Bits Setting

        .if <ah ge DATA_BITS5> and              ; If within the range,
        .if <ah le DATA_BITS8>                  ;
            sub  ah, DATA_BITS5                 ;
            or   al, ah                         ; Set Word Length of data bits
        .endif

        mov     ah,[esi].Ioctl_Data_Pkt.Parity_Data  ; Parity Setting

        .if <ah ne PARITY_NONE>                 ; If there is Parity,then
            or  al,PENBIT                       ; Set Parity Enable bit
            .if <ah ge PARITY_STICK_ODD>        ; If Stick Parity
                or  al,STICKPBIT                ; Set Stick Parity
                sub ah,2                        ; Make ah to PARITY_EVEN/ODD
            .endif
            .if <ah eq PARITY_EVEN>             ; If Even Parity
                or  al,EPSBIT                   ;  Set Even Parity
            .endif
        .endif

        mov     ah,[esi].Ioctl_Data_Pkt.Stop_Bits_Data   ; Stop Bits Setting

        .if <ah ne STOP_BIT1>                   ; If not Stop Bit 1, then
            or  al,STBIT                        ; Set Stop Bit for 1.5 or 2
        .endif


        mov     ah,[esi].Ioctl_Data_Pkt.Tx_Break_Data  ; Transmitting Break

        .if <ah ne 0 >
            or  al,BREAKBIT
        .endif

        mov     [esi].VLCR,al                   ; Initialize VLCR to AL

        pop     eax                             ; Restore EAX
        ret

Get_LCR_Request endp


;********************** START OF SPECIFICATIONS ******************************
;SUBROUTINE NAME: Get_MCR_Request
;
;DESCRIPTIVE NAME: "Get MCR Request" call to PCOM
;
;INPUT:
;       EDX = Port_ID
;       ESI -> Base address of PI for this port
;
;OUTPUT:
;       VMCR set
;
;RELATED DATA OBJECTS:
;  Instance Data per VDM:
;       None
;  Global Data:
;       Variables in Port_Info_Tab (PI table):
;          VMCR
;FUNCTION:
;       Get PCOM's MCR value, and set VMCR to it.
;
;CALLED BY:
;       Open_Request
;
;INTERNAL REFERENCES:
;       PDDProc_IOCTL_Handler
;
;EXTERNAL REFERENCES:
;
;NOTE:
;       All registers saved
;********************** END OF SPECIFICATIONS *********************************

Get_MCR_Request proc    near

        push    eax
        mov     ax,GETMCR                       ; = 66h
        call    PDDProc_IOCTL_Handler           ;Call PCOM
        mov     ah,[esi].Ioctl_Data_Pkt          ;Get the returned byte
        and     ah,(DTR+RTS)                    ;Clean up except for DTR, RTS.
        and     [esi].VMCR, not (DTR+RTS)
        or      [esi].VMCR, ah                  ;Update VMCR except for OUT2
        pop     eax
        ret

Get_MCR_Request endp


;********************** START OF SPECIFICATIONS ******************************
;SUBROUTINE NAME: Set_LCR_Request
;
;DESCRIPTIVE NAME: "Set LCR Request" call to PCOM
;
;INPUT:
;       EDX = Port_ID
;       ESI -> Base address of PI for this port
;       VLCR
;
;OUTPUT:
;       None
;
;RELATED DATA OBJECTS:
;  Instance Data per VDM:
;       None
;  Global Data:
;       Variables in Port_Info_Tab (PI table):
;          VLCR
;FUNCTION:
;       Request PCOM to set LCR with PDDProc
;
;CALLED BY:
;       Int14h_Init
;       Int14h_xInit
;       Virt_ComOut
;
;INTERNAL REFERENCES:
;       PDDProc_IOCTL_Handler
;
;EXTERNAL REFERENCES:
;
;NOTE:
;       All registers saved
;********************** END OF SPECIFICATIONS *********************************

Set_LCR_Request proc    near                     ;


        push    eax                              ;Save Registers
        push    ebx

        mov     al,[esi].VLCR                    ; al = VLCR
                                                 ;
        mov     ah,al                            ; Compute Data Bits value
        and     ah,WLSBITS                       ; from VLCR
        add     ah,DATA_BITS5                    ; Convert to IOCTL interface

        mov [esi].Ioctl_Parm_Pkt.Data_Bits_Parm,ah ; Enter the Data Bits param.
                                                 ;
        mov     bh,al                            ;
        and     bh,STBIT                         ; If Bit 2 is off
        .if     z                                ;
            mov ah,STOP_BIT1                     ;   Set 1 Stop Bit (=0)
        .else                                    ; If Bit 2 is on
            .if <ah eq DATA_BITS5>               ;   If 5 Data Bits
                mov ah,STOP_BIT15                ;      Set 1.5 Stop Bit
            .else                                ;   Else (6,7,or 8 Data Bits)
                mov ah,STOP_BIT2                 ;      Set 2 Stop Bit
            .endif                               ;
        .endif                                   ;
        mov [esi].Ioctl_Parm_Pkt.Stop_Bits_Parm,ah ; Enter the Stop Bit param
                                                 ;
        mov     bh,al                            ;
        and     bh,PENBIT                        ;
        .if     z                                ; If Parity Enable bit is off
            mov ah,PARITY_NONE                   ;   No Parity
        .else                                    ; Else
            xor ah,ah                            ;
            mov bh,al                            ;
            and bh,EPSBIT                        ;
            .if z                                ;   If Even Parity bit is off
                mov   ah, PARITY_ODD             ;     = 1
            .else                                ;   Else (Even Parity)
                mov   ah, PARITY_EVEN            ;     = 2
            .endif                               ;
            mov bh,al                            ;
            and bh,STICKPBIT                     ;
            .if nz                               ;   If Stick Parity bit is on
                add   ah,(PARITY_STICK_ODD-PARITY_ODD) ; Add difference(=2)
            .endif                               ;      3 for Stick Odd parity
        .endif                                   ;      4 for Stick Even parity
                                                 ;
        mov     [esi].Ioctl_Parm_Pkt.Parity_Parm,ah  ; Enter the Parity param
        mov     ax,SETLCR                        ; = 42h
        call    PDDProc_IOCTL_Handler            ; Call PCOM
                                                 ;
        mov     al,[esi].VLCR                    ; al = VLCR
        and     al,BREAKBIT                      ;
        .if     z                                ;
            mov ax,SETBREAKOFF                   ; = 45h
        .else                                    ;
            mov ax,SETBREAKON                    ; = 4Bh
        .endif                                   ;
        call    PDDProc_IOCTL_Handler            ; Call PCOM
        pop     ebx
        pop     eax
        ret
Set_LCR_Request endp


;********************** START OF SPECIFICATIONS ******************************
;SUBROUTINE NAME: Set_MCR_Request
;
;DESCRIPTIVE NAME: "Set MCR Request" call to PCOM
;
;INPUT:
;       EDX = Port_ID
;       ESI -> Base address of PI for this port
;       VMCR
;
;OUTPUT:
;       None
;
;RELATED DATA OBJECTS:
;  Instance Data per VDM:
;       None
;  Global Data:
;       Variables in Port_Info_Tab (PI table):
;          VMCR
;FUNCTION:
;       Request PCOM to set MCR with PDDProc.
;
;CALLED BY:
;       Virt_ComOut
;       Int14h_xCtl
;       Int14h_Rx
;       Int14h_Tx
;
;INTERNAL REFERENCES:
;       PDDProc_IOCTL_Handler
;
;EXTERNAL REFERENCES:
;
;NOTE:
;       All registers saved
;********************** END OF SPECIFICATIONS *********************************

Set_MCR_Request proc    near                    ;
        push    eax                             ; Save registers
        push    ebx

        mov     al,[esi].VMCR                   ; al = VMCR
        and     al,DTR                          ;
        .if     nz                              ; If DTR bit is on, then
            mov   bh, SETDTR_ON_MASK            ;   Mask on for Set DTR
            mov   bl, SETDTR_OFF_MASK           ;   Mask off for Set DTR
        .else                                   ; else
            mov   bh, CLEARDTR_ON_MASK          ;   Mask on for Clear DTR
            mov   bl, CLEARDTR_OFF_MASK         ;   Mask off for Clear DTR
        .endif

        mov     al,[esi].VMCR                   ;
        and     al,RTS                          ;
        .if     nz                              ; If RTS bit is on, then
            or    bh, SETRTS_ON_MASK            ;   Mask on for Set RTS
            and   bl, SETRTS_OFF_MASK           ;   Mask off for Set RTS
        .else                                   ; else
            or    bh, CLEARRTS_ON_MASK          ;   Mask on for Clear RTS
            and   bl, CLEARRTS_OFF_MASK         ;   Mask off for Clear RTS
        .endif

        mov     al,[esi].VMCR                   ;
        and     al,LOOPBIT                      ;
        .if     nz                              ; If RTS bit is on, then
            or    bh, SETLOOP_ON_MASK           ;   Mask on for Set RTS
            and   bl, SETLOOP_OFF_MASK          ;   Mask off for Set RTS
        .else                                   ; else
            or    bh, CLEARLOOP_ON_MASK         ;   Mask on for Clear RTS
            and   bl, CLEARLOOP_OFF_MASK        ;   Mask off for Clear RTS
        .endif

        mov     [esi].Ioctl_Parm_Pkt.MC_Mask_On_Parm,bh  ; Mask on byte
        mov     [esi].Ioctl_Parm_Pkt.MC_Mask_Off_Parm,bl ; Mask off byte

        mov     ax,SETMCR                       ; = 46h
        call PDDProc_IOCTL_Handler              ; Call PCOM to set MCR

        pop     ebx
        pop     eax
        ret                                     ; Return to the caller
                                                ;
Set_MCR_Request endp                            ;


;********************** START OF SPECIFICATIONS ******************************
;SUBROUTINE NAME: Set_DLLDLM_Request
;
;DESCRIPTIVE NAME: "Set DLL/DLM Request" call to PCOM
;
;INPUT:
;       EDX = Port_ID
;       ESI -> Base address of PI for this port
;       VDLL
;       VDLM
;
;OUTPUT:
;       None
;
;RELATED DATA OBJECTS:
;  Instance Data per VDM:
;       None
;  Global Data:
;       Variables in Port_Info_Tab (PI table):
;          VDLL
;          VDLM
;FUNCTION:
;       Set DLL/DLM Request to PCOM
;
;CALLED BY:
;       Virt_ComOut
;       Int14h_Init
;       Int14h_xInit
;
;INTERNAL REFERENCES:
;       PDDProc_Handler
;
;EXTERNAL REFERENCES:
;
;NOTE:
;       All registers saved
;********************** END OF SPECIFICATIONS *********************************

Set_DLLDLM_Request      proc    near
        push    eax
        push    ecx
        mov     cl,[esi].VDLL                   ; Set CL = DLL
        mov     ch,[esi].VDLM                   ; Set CH = DLL
        .if <cx ne 0>
            mov     ax,SETDLLDLM                ; = 6
            call    PDDProc_Handler             ; Call PCOM to set DLL/DLM
        .endif
        pop     ecx
        pop     eax
        ret
Set_DLLDLM_Request      endp


;********************** START OF SPECIFICATIONS ******************************
;SUBROUTINE NAME: PDDProc_Handler
;
;DESCRIPTIVE NAME: Calls PDDProc
;
;INPUT: EDX = Port_ID
;       ESI -> Base address of PI for this port
;
;OUTPUT:
;       None
;
;RELATED DATA OBJECTS:
;  Instance Data per VDM:
;       None
;  Global Data:
;       PCOMEntry
;
;FUNCTION:
;       Calls PDDProc of PCOM
;
;CALLED BY:
;       Open_Request
;       Close_Request
;       Virt_Get_Byte
;       Virt_ComOut
;       Get_DLLDLM_Request
;       Set_DLLDLM_Request
;
;INTERNAL REFERENCES:
;       PCOMEntry
;
;EXTERNAL REFERENCES:
;       NONE
;
;NOTE:
;
;********************** END OF SPECIFICATIONS *********************************

;This procedure is for the future change, when PCOM expects stack based
; convention.
PDDProc_Handler proc    near

        call PCOMEntry
        ret
PDDProc_Handler endp


;********************** START OF SPECIFICATIONS ******************************
;SUBROUTINE NAME: PDDProc_IOCTL_Handler
;
;DESCRIPTIVE NAME: Calls PDDProc for IOCTL request
;
;INPUT: EDX = Port_ID
;       ESI -> Base address of PI for this port
;
;OUTPUT:
;       None
;
;RELATED DATA OBJECTS:
;  Instance Data per VDM:
;       None
;  Global Data:
;       PCOMEntry
;
;FUNCTION:
;       Set ES:SI, ES:DI pointing to IOCTL input/Output packet
;         using 16:16 convention.
;       Calls PDDProc of PCOM for IOCTL call
;
;CALLED BY:
;       Get_MSR_Request
;       Get_MCR_Request
;       Get_LCR_Request
;       Set_MCR_Request
;       Set_LCR_Request
;
;INTERNAL REFERENCES:
;       PCOMEntry
;
;EXTERNAL REFERENCES:
;       NONE
;
;NOTE:
;
;********************** END OF SPECIFICATIONS *********************************

PDDProc_IOCTL_Handler   proc    near
        push    esi                             ;Save registers
        push    edi
        push    ecx

        lea     edi, off_PICOMS                 ;Get 16 bit offset value
        add     edi, edx                        ; for this COM port.
        add     edi, edx                        ; (WORD, so add twice)
        mov     si, word ptr [edi]
        mov     di, si                          ;Now, SI=DI->PI for the port
        add     si, Ioctl_Parm_Pkt              ; SI -> Ioctl_Parm_Pkt
        add     di, Ioctl_Data_Pkt              ; DI -> Ioctl_Data_Pkt
        push    es                              ;Save our ES
        mov     es, sel_glbDATA                 ;ES = GDT sel for our Global
        assume  es:nothing                      ;  data area.
        call    PCOMEntry                       ;Calls PCOM
        pop     es                              ;Restore ES
        assume  es:FLAT

        pop     ecx
        pop     edi                             ;Restore registers
        pop     esi
        ret
PDDProc_IOCTL_Handler   endp


;********************** START OF SPECIFICATIONS ******************************
;SUBROUTINE NAME: Popup_Display
;
;DESCRIPTIVE NAME: Popup a message and get the user response
;
;INPUT: EDX = Port_ID
;       AX = Message ID
;
;OUTPUT: SUCCESS
;          AH = User Response
;               Response number = 1 : Terminate VDM
;               Response number = 2 : Retry
;               Response number = 3 : Ignore
;
;        FAILURE
;          Hard Error
;
;RELATED DATA OBJECTS:
;  Instance Data per VDM:
;       ihVDM
;
;  Global Data:
;       Subst_String_Tabl
;       Response_Num
;
;
;FUNCTION:
;       Display a Popup message, and get response from the user.
;
;CALLED BY:
;       Check_PortOwner
;
;INTERNAL REFERENCES:
;       NONE
;
;EXTERNAL REFERENCES:
;       VDHPopup
;       VDHKillVDM
;
;NOTE:
;       EAX destroyed
;********************** END OF SPECIFICATIONS *********************************

Popup_Display   proc    near

        ;
        ; Required parameters for VDHPopup:
        ;
        ;    Pointer to Table of Substitution strings (Subst_String_Tabl),
        ;    Number of substitution strings,
        ;    Pointer to an ASCIIZ message file (MsgFile),
        ;    Message ID number,
        ;    Pointer to the returning response number - Response_Num.

        push    ebx
        push    ecx
        push    edx
        push    esi
        push    edi
        xor     ecx,ecx
        mov     cx,ax                           ; Set up the parameter
        add     dl,'1'                          ; Make port number to ASCII
        mov     al,dl                           ;   for VDHPopup
        lea     edx,Subst_String_Tabl           ;
        mov     Subst_Num, al                   ;
        mov     eax,NULL                        ;
        lea     ebx,Response_Num                ;
        mov     esi, VDHP_RETRY+VDHP_IGNORE+VDHP_TERMINATE_SESSION
        mov     edi,1

        CallFn VDHPopup,<edx,edi,ecx,ebx,esi,eax> ; Popup the error/warning
        .if     <eax eq VDH_FAILURE>            ; If Popup fails
            push    ecx
            CallFn VDHKillVDM,<ihVDM>           ; Teminate current VDM
            pop     ecx
            mov     ah, VDH_FAILURE
        .endif

        mov     eax,Response_Num                ; EAX = user response
        shl     ax, 8                           ; move user response to AH

        .if <ah eq VDHP_TERMINATE_SESSION>      ; If user response = TERMINATE
            push    ecx
            CallFn VDHKillVDM,<ihVDM>           ; Terminate current VDM
            pop     ecx
            mov     ah, VDHP_TERMINATE_SESSION
        .endif

        pop     edi
        pop     esi
        pop     edx
        pop     ecx
        pop     ebx
        ret                                     ; Return to the caller

Popup_Display   endp

EndCode                                     ;End CSWAP_TEXT segment
        END
