/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1992 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 source code is provided to you solely for       */
/*    the purpose of assisting you in your development of OS/2 device        */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Developer Connection Device Driver       */
/*    Source Kit for OS/2. This Copyright statement may not be removed.      */
/*                                                                           */
/*****************************************************************************/
#define INCL_WIN
#define INCL_GPI
#define INCL_DOSPROCESS
#include <os2.h>
#include <stdio.h>
#include <cal.h>
#include <calres.h>
#include "penei.h"

HAB  habMain;
HMQ  hmqMain;
FONTMETRICS  fm;

char  IOName[20]  = "\\dev\\PENDD$";
char _DriverName[SIZEOF_DEVICE_NAME+1];
char _DeviceName[SIZEOF_DEVICE_NAME+1];
char  appName[] = "CAL";
ULONG scrWidth,scrHeight;
#ifdef DEBUG
BOOL  dbfile;
FILE  *stream;
#endif
BOOL  yinvert;

LONG createAlign (HWND owner);
void destroyAlign(void);
void registerAlign(void);

void main(int argc,char * argv[])
{
   ULONG flCreateFlags;
   QMSG qmsg;
   HPS  hpsTemp;

#ifdef DEBUG
// debug log file. Use presence of the file as a flag to use the file.
// If its not there, then don't create one.

   dbfile = FALSE;
   if ((stream=fopen("pencal.log","r"))!=NULL) {
      fclose(stream);
      if ((stream=fopen("pencal.log","w"))!=NULL) {
         fprintf(stream,"debug file open\n");
         dbfile = TRUE;
      } /* endif */
   } /* endif */
#endif

// process parm line

   if (argc > 1) {
      strcpy(&(_DriverName),argv[1]);
   } /* endif */

   if (argc > 2) {
      strcpy(&(_DeviceName),argv[2]);
   } /* endif */

#ifdef DEBUG
   if (dbfile) {
      fprintf(stream,"DriverName=%s DeviceName=%s\n",
              _DriverName,_DeviceName);
   }
#endif

// start doing PM stuff

   habMain=WinInitialize(0);
   hmqMain=WinCreateMsgQueue(habMain,0);

// Query screen size, used in several places ahead

   scrWidth=WinQuerySysValue(HWND_DESKTOP,SV_CXSCREEN);
   scrHeight=WinQuerySysValue(HWND_DESKTOP,SV_CYSCREEN);

   hpsTemp = WinGetPS    (HWND_DESKTOP);
   GpiQueryFontMetrics (hpsTemp,(LONG)sizeof fm, &fm);
   WinReleasePS(hpsTemp);

// create a client window for alignment

   registerAlign ();
   createAlign (HWND_DESKTOP);

// main processing loop

   while (WinGetMsg(habMain,&qmsg,(HWND)NULL,0,0)) {
      WinDispatchMsg(habMain,&qmsg);
   } /* endwhile */

// clean up and terminate

   destroyAlign();
   WinDestroyMsgQueue(hmqMain);
   WinTerminate(habMain);
#ifdef DEBUG
   if (dbfile) {
      dbfile = FALSE;
      fclose (stream);
   }
#endif

   DosExit (EXIT_PROCESS,0);
}
