/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1992 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 source code is provided to you solely for       */
/*    the purpose of assisting you in your development of OS/2 device        */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Developer Connection Device Driver       */
/*    Source Kit for OS/2. This Copyright statement may not be removed.      */
/*                                                                           */
/*****************************************************************************/
/***************************************************************************\
 *
 *  penPM calls
 *
\***************************************************************************/
#define INCL_DOSFILEMGR   /* File Manager values */
#define INCL_DOSDEVICES   /* Device values */
#include <os2.h>
#include <stdio.h>
#include <penpm.h>
#include "penei.h"
#include "penioctl.h"

#ifdef DEBUG
extern BOOL  dbfile;
extern FILE  *stream;
#endif
extern BOOL  yinvert;
extern char _DriverName[];
extern char _DeviceName[];

LONG doIO  (ULONG category, ULONG function,
             PVOID pParams, LONG pcbParmLen,
             PVOID pData, LONG pcbDataLen);



#ifdef DEBUG
void dumpSlusd(char * header,SLUSD * pslusd)
{
   if (dbfile) {
      fprintf(stream,"%s\n",header);
      fprintf(stream,"  XoriginDefault=%d Xorigin=%d Xmeasured=%d\n",
              pslusd->XoriginDefault,pslusd->Xorigin,pslusd->XmeasuredExtent);
      fprintf(stream,"  YoriginDefault=%d Yorigin=%d Ymeasured=%d\n",
              pslusd->YoriginDefault,pslusd->Yorigin,pslusd->YmeasuredExtent);
   } /* endif */
}
#endif

LONG getSLUSD(LCAP * plcap,SLUSD * pslusd)
{
   PQUSD pqusd;
   LONG  rc;

   pqusd.unit  = plcap->ccap.unit;
   pqusd.byteCount=sizeof(SLUSD);
   rc=doIO (PEN_CAT_DRIVER,PEN_FUNC_QUSD,
           &pqusd,sizeof(PQUSD),
           pslusd,sizeof(SLUSD));

   yinvert = FALSE;
   if ((pqusd.capabilities & QUSD_Y_INVERT) != 0) {
#ifdef DEBUG
       if (dbfile) fprintf(stream,"Y IS INVERTED\n");
#endif
       yinvert = TRUE;
   }
#ifdef DEBUG
   dumpSlusd("getSLUSD",pslusd);
#endif
   return (rc);
}


LONG setSLUSD(LCAP * plcap,SLUSD * pslusd)
{
   PSUSD psusd;
   LONG  rc;

   psusd.unit  = plcap->ccap.unit;
   psusd.byteCount=sizeof(SLUSD);
#ifdef DEBUG
   dumpSlusd("setSLUSD",pslusd);
#endif
   rc=doIO (PEN_CAT_DRIVER,PEN_FUNC_SUSD,
           &psusd, sizeof(PSUSD),
           pslusd, sizeof(SLUSD));
   return (rc);
}


LONG wrtQuery(SLUSD * pslusd)
{
   ULONG pqusd;
   LONG  rc;
   pqusd = sizeof(SLUSD);

   rc= WrtQueryInputDeviceVariable( (PSZ)_DriverName,
                                (PSZ)_DeviceName,
                                PPMID_DEVICE_PARMS,
                                (LONG)NULL,
                                &pqusd,
                                pslusd
                                );

#ifdef DEBUG
   dumpSlusd("wrtQuery",pslusd);
#endif
   return (rc);
}


LONG wrtSet(SLUSD * pslusd)
{
   LONG  rc;

#ifdef DEBUG
   dumpSlusd("wrtSet",pslusd);
#endif
   rc= WrtSetInputDeviceVariable( _DriverName,
                                  _DeviceName,
                                  PPMID_DEVICE_PARMS,
                                  (LONG)NULL,
                                  (ULONG)sizeof(SLUSD),
                                  pslusd
                                  );
   return (rc);
}

#ifdef DEBUG
LONG savSLUSD(LCAP * plcap,SLUSD * pslusd)
{
   if (dbfile) fprintf(stream,"PENTL command \n");
   if (dbfile) fprintf(stream,"susd %d %d %d %d %d\n",
           plcap->ccap.unit,
           pslusd->Xorigin,
           pslusd->XmeasuredExtent,
           pslusd->Yorigin,
           pslusd->YmeasuredExtent);
}
#endif
