;      /*****************************************************************/
;      /*                                                               */
;      /*           Copyright (c) IBM Corporation  1987, 1992           */
;      /*                     All Rights Reserved                       */
;      /*                                                               */
;      /*****************************************************************/
;      /******************* START OF SPECIFICATIONS *********************/
;      /*                                                               */
;      /*  SOURCE FILE NAME: SERIAL.INC                                 */
;      /*                                                               */
;      /*  DESCRIPTIVE NAME: Serial COM IO equates                      */
;      /*                                                               */
;      /*  COPYRIGHT:  IBM Corp. 1992                                   */
;      /*                                                               */
;      /*  STATUS:  Version 1.0                                         */
;      /*                                                               */
;      /*  NOTES:                                                       */
;      /*                                                               */
;      /*  ENTRY POINTS:                                                */
;      /*      See public statements                                    */
;      /*  EXTERNAL REFERENCES:                                         */
;      /*      See extrn statements                                     */
;      /*                                                               */
;      /******************* END  OF  SPECIFICATIONS *********************/

Serial struc
  comPort        db ?           ; com port number
  port           dw ?           ; base IO port address
  interruptLevel db ?           ; interrupt level
  comdivisor     db ?           ; baud rate divisor value
  comLCR         db ?           ; line control register value
  comMCR         db ?           ; modem control register value
  fcomFIFO       db ?           ; FIFO flag, 1=use it, 0=don't
  comFCR         db 0C7h        ; FIFO control register value
  @processByte   dw 0           ; Addr of routine to process bytes
  @intHandler    dw 0           ; Addr of interrupt handler stub
  @initRtn       dw 0           ; Addr of initialization routine
  @errorRtn      dw 0           ; Addr of initialization routine
  @DCB           dw 0           ; dcb address for this device
  serialStatus   dw 0           ; status flag word
  enable_8259    db 0           ; mask to enable PIC
  disable_8259   db 0           ; mask to disable PIC
Serial ends


; bits for serialStatus word
ABIOSLID     EQU 0001h  ; Com port get ABIOS LID failed
COMEXIST     EQU 0002h  ; com port does not exist
SETIRQ_DONE  EQU 0004h  ; SetIRQ successful

; Modem control registers

IIRMASK       EQU 11111000B     ; Interrupt ID Register permanent Mask bits
MCRMASK       EQU 00001011B     ; Modem Control Register Mask
IERMASK       EQU 00000001B     ; Interrupt Enable Register Mask
LCRMASK       EQU 00000011B     ; Line Control Reg Mask, 8 data bits 1 stop bit

;-------------------------------------------------------------------
;  Below are the offsets from the Port Base Address to the various -
;            Serial Port register addresses                        -
;-------------------------------------------------------------------

TXB              EQU          0     ; Transmit buffer
RXB              EQU          0     ; Receive buffer
LATLSB           EQU          0     ; Divisor latch least sig bits
LATMSB           EQU          1     ; Divisor latch most sig bits
IER              EQU          1     ; Interrupt enable register
IIR              EQU          2     ; Interrupt indentification register
FCR              EQU          2     ; FIFO Control Register
LCR              EQU          3     ; Line control register
MCR              EQU          4     ; Modem control register
LSR              EQU          5     ; Line status register
MSR              EQU          6     ; Modem status register
SCR              EQU          7     ; Scratch register

; These are the values that are written into the divisor latch for the
;       various baud rates. They are obtained by dividing the clock rate
;       (1.8432 MHz) by 16x the desired baud rate.
;

DIV_50          EQU     900h
DIV_75          EQU     600h
DIV_110         EQU     417h
DIV_150         EQU     300h
DIV_300         EQU     180h
DIV_600         EQU     0C0h
DIV_1200        EQU     060h
DIV_1800        EQU     040h
DIV_2000        EQU     03Ah
DIV_2400        EQU     030h
DIV_3600        EQU     020h
DIV_4800        EQU     018h
DIV_7200        EQU     010h
DIV_9600        EQU     00Ch
DIV_19200       EQU     006h

;
;** Interrupt enable masks
;

IE_RX           EQU     00000001b       ; read data available
IE_TX           EQU     00000010b       ; transmit buffer empty
IE_LX           EQU     00000100b       ; line status change
IE_MX           EQU     00001000b       ; modem status change

IERMASK         EQU     00000001B       ; Interrupt Enable Register Mask

;
;** Interrupt identification masks
;

II_PENDING      EQU     00000001b       ; Clear if interrupt pending.
IIRMASK         EQU      0F8H       ; Interrupt ID Register permanent Mask bits

;** FIFO control masks
FIFO_ENABLE     EQU     00000001b
FIFO_DISABLE    EQU     00000000b
FIFOMASK        EQU     01000000b

;
;** Line control masks
;

LC_BMASK        EQU     00000011b       ; data bits mask
LC_BITS5        EQU     00000000b       ; 5 data bits
LC_BITS6        EQU     00000001b       ; 6 data bits
LC_BITS7        EQU     00000010b       ; 7 data bits
LC_BITS8        EQU     00000011b       ; 8 data bits

LC_SMASK        EQU     00000100b       ; stop bits mask
LC_STOP1        EQU     00000000b       ; 1 stop bit
LC_STOP2        EQU     00000100b       ; 2 stop bits (1.5 if 5 data bits)

LC_PMASK        EQU     00111000b       ; parity mask
LC_PNONE        EQU     00000000b       ; none parity
LC_PODD         EQU     00001000b       ; odd parity
LC_PEVEN        EQU     00011000b       ; even parity
LC_PMARK        EQU     00101000b       ; mark parity
LC_PSPACE       EQU     00111000b       ; space parity

LC_BREAK        EQU     01000000b       ; transmit break
LC_DLAB         EQU     10000000b       ; divisor latch access bit
LC_MASK         EQU     01111111b       ; documented line control register bits

;
;** Modem control register masks
;

MC_DTR          EQU     00000001b       ; data terminal ready
MC_RTS          EQU     00000010b       ; request to send
MC_OUT1         EQU     00000100b       ; output 1
MC_OUT2         EQU     00001000b       ; output 2
MC_LOOP         EQU     00010000b       ; loopback mode

MCRMASK         EQU     00001011B       ; Modem Control Register Mask

;
;** Line status register masks
;

LS_DR           EQU     00000001b       ; data ready
LS_OERR         EQU     00000010b       ; overrun error
LS_PERR         EQU     00000100b       ; parity error
LS_FERR         EQU     00001000b       ; framing error
LS_BI           EQU     00010000b       ; break interrupt
LS_THRE         EQU     00100000b       ; TX holding register empty
LS_TSRE         EQU     01000000b       ; TX shift register empty

;
;** Modem status register definitions:
;

MS_DCTS         EQU     00000001b       ; delta clear to send
MS_DDSR         EQU     00000010b       ; delta data set ready
MS_TERI         EQU     00000100b       ; trailing edge of ring indicator
MS_DDCD         EQU     00001000b       ; delta receiver line signal detect
MS_CTS          EQU     00010000b       ; clear to send
MS_DSR          EQU     00100000b       ; data set ready
MS_RI           EQU     01000000b       ; ring indicator
MS_DCD          EQU     10000000b       ; receiver line signal detect

;************************************************************************
;**     MyIODelay - Perform an IO delay as needed for hardware
;                   Example Code Only
;
;MyIODelay MACRO
;
;  push ax
;  DevIODelay <ax>              ; Trashes AX reg
;  pop  ax
;
;ENDM


