/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1992 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 source code is provided to you solely for       */
/*    the purpose of assisting you in your development of OS/2 device        */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Developer Connection Device Driver       */
/*    Source Kit for OS/2. This Copyright statement may not be removed.      */
/*                                                                           */
/*****************************************************************************/
/*************************************************************************/
/*                                                                       */
/*                                                                       */
/*************************************************************************/
/******************* START OF SPECIFICATIONS *****************************/
/*                                                                       */
/*  SOURCE FILE NAME: PENIDC.H                                           */
/*                                                                       */
/*  DESCRIPTIVE NAME: Pen driver IDC interface                           */
/*                                                                       */
/*                                                                       */
/*  STATUS:  Version 1.0                                                 */
/*                                                                       */
/*  NOTES:                                                               */
/*                                                                       */
/*  ENTRY POINTS:                                                        */
/*      See public statements                                            */
/*  EXTERNAL REFERENCES:                                                 */
/*      See extrn statements                                             */
/*                                                                       */
/******************* END  OF  SPECIFICATIONS *****************************/
/**********************************************************************/
/* General Equates */

#define PEN_DDS_LEV_MAJOR  0       /* level of this specification */
#define PEN_DDS_LEV_MINOR  3       /* level of this specification */

/* DevHlp_RegisterDevicClase Values */

#define DEVCLASS_INPUT  2         /* Device Class for Register Device Class*/

/* defines for DCFlags */
#define REG_EXT_IF      0x0001    /* Supports extended interface */
#define REG_AUX         0x8000    /* Keyboard AUX port used      */

/*/********************************************************************/
/* Pen Driver IDC Fucntions */

/* These functions are provided by the Pen Driver at the RegisterDeviceClass */
/* driver entry point.                                                       */

/* calls by unit */

#define QUERY_CAPIBILITIES 1   /* request unit capabilities                     */
                               /*   bl = unit                                   */
                               /*   es: di = area to copy capabilities packet   */
                               /*            first word has size of copy buffer */
                               /* successfull return                            */
                               /*   nc, ax = 0, packet copied                   */
                               /* error return                                  */
                               /*   cy, ax == error code                        */

#define QUERY_DEV_CONFIG  2    /* Query optional device configuration           */
                               /*   bl = unit                                   */
                               /*   es: di = target DevData packet address      */

#define START_LOGICAL_DEVICE 3 /* Start Logical Device                          */
                               /*   bl = unit                                   */
                               /*   es: di = SINFO packet                       */
                               /* successfull return                            */
                               /*   nc, ax = 0, registration accepted           */
                               /* error return                                  */
                               /*   cy, ax == error code                        */

/* 4 and 5 are reserved for future 'by unit' calls */

/* global calls to driver */

#define READ_ENABLE       6    /* enable reporting of events                 */
                               /* pass   cx: dx style capabilites to drvier  */
                               /* return cx: dx style request to services    */
#define READ_DISABLE      7    /* disable reporting of events                */
#define ENABLE_DEVICE     8    /* enable the device to interrupt             */
#define DISABLE_DEVICE    9    /* disable the device from interrupting       */
#define ACTIVITY_CALLBACK 10   /* System activity callback. Called as        */
                               /* result of REQUEST_CALLBACK                 */
#define VIDEO_MODE_CHANGE 11   /* Video Mode change                          */
                               /*   es: di = VINFO packet                    */

/* style capabilities for READ_ENABLE  CX register is reserved, must be zero */

/* style capabilities for READ_ENABLE  DX register */
#define STYLE_NOTIFY_VMCHANGE 0x0001 /* report VM_CHANGE */
                              /* on= DON'T report, reset to receive events */

/* error codes */

#define DRV_ERR_GEN_ERROR   1  /* general error                              */
#define DRV_ERR_NOT_FOUND   2  /* unit number not found                      */
#define DRV_ERR_BUFF_TRUNC  3  /* registration packet truncated, buffer small*/
#define DRV_ERR_LEVEL       4  /* level mismatch                             */
#define DRV_ERR_NOT_ALLOWED 5  /* request not allowed at this time           */
#define DRV_ERR_NO_FUNC     6  /* function not supported                     */

/* This packet is passed on READ_ENABLE. The packet and service routine is */
/* valid only during the READ_ENABLE call. */

typedef struct _SINFO        {    /* sinfo */                               */
  USHORT length;                  /* total length of packet                 */
  UCHAR  eif_major;               /* major level (PEN_EI_LEV_MAJOR)         */
  UCHAR  eif_minor;               /* minor level (PEN_EI_LEV_MINOR)         */
  UCHAR  idc_major;               /* major level (PEN_DDS_LEV_MAJOR)        */
  UCHAR  idc_minor;               /* minor level (PEN_DDS_LEV_MINOR)        */
  USHORT service_ds;              /* data segment to load for service routine */
  ULONG  service_rtn;             /* 16:16 address for service routine      */

} SINFO;

/* This packet is passed on VIDEO_MODE_CHANGE. */

typedef struct _VINFO        {    /* vinfo */
  UCHAR  Mtype;               /* video mode type              */
  UCHAR  Color;               /* number of colors             */
  USHORT TCol_res;            /* text colomn resolution       */
  USHORT TRow_res;            /* text row resolution          */
  USHORT GCol_res;            /* graphics colomn resolution   */
  USHORT GRow_res;            /* graphics row resolution      */
} VINFO;

/* defines for vinfo.Mtype */
#define MTYPE_GRAPHICS  0x0002    /*Graphics mode*/

/* Device Data Strucutue is returned by locator devices on QUERY_DEV_CONFIG. */
/* The other devices do not have device configuration data to return. */

typedef struct _DevData  {        /* DevData */
  USHORT CfgDataLen;              /* length of data          */
  UCHAR  NumMics;                 /* number mickeys/cm       */
  UCHAR  NumButt;                 /* number of buttons       */
  UCHAR  IRQ;                     /* IRQ level               */
  UCHAR  MouseType;               /* mouse type attached     */
  UCHAR  ComPortNum;              /* com port number         */
  USHORT ComPortAddr;             /* com port address        */
} DevData;

/*********************************************************************/
/* Device Service IDC Fucntions                                      */
/*                                                                   */
/* These functions are provided at the device service entry point.   */

#define REGISTER_DEVICE       1       /* report event                         */
                                      /* es: di = capibilities packet         */
#define REPORT_EVENT          2       /* report event                         */
                                      /* es: di = event packet                */
#define UPDATE_CAPS           3       /* update registration packet           */
                                      /* es: di = capbilities packet          */
#define QUERY_ACTIVITY        4       /* query user input activity            */
                                      /* returns     dx = low word count      */
                                      /*             cx = high word count     */
                                      /*            edx = dword count         */
#define REQUEST_CALLBACK      5       /* request callback for system activity */
                                      /* cl = driver device id                */
#define CANCEL_CALLBACK       6       /* cancel  callback for system activity */
                                      /* cl = driver device id                */
#define SUPPRESS_STROKE       7       /* suppress stroke                      */
                                      /* cl = driver device id                */
#define DISABLE_SUPPORT       8       /* disable driver                       */
                                      /* cl = driver device id                */
