/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1992 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 source code is provided to you solely for       */
/*    the purpose of assisting you in your development of OS/2 device        */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Developer Connection Device Driver       */
/*    Source Kit for OS/2. This Copyright statement may not be removed.      */
/*                                                                           */
/*****************************************************************************/
/* SCCSID = "src/dev/usb/usbprt/prttype.h, physdd.usbprt, c.basedd 99/11/09" */
/*
*
*/
/************************** START OF SPECIFICATIONS ***************************/
/*                                                                            */
/*   SOURCE FILE NAME: PRTTYPE.H                                              */
/*                                                                            */
/*   DESCRIPTIVE NAME: USB Printer Device Driver typedefs                     */
/*                                                                            */
/*   FUNCTION: This module is the USB Printer Device Driver typedef include   */
/*             file.                                                          */
/*                                                                            */
/*   NOTES: The PDRVCFG structure must be defined precisely the same way      */
/*          in the DDK\WPSHELL\SRC\WPSH\USBPRT\PDRTYPES.H file                */
/*          of the USB Printer Port driver (USBPRT.PDR)                       */
/*                                                                            */
/*      DEPENDENCIES: None                                                    */
/*      RESTRICTIONS: None                                                    */
/*                                                                            */
/*   ENTRY POINTS: None                                                       */
/*                                                                            */
/*   EXTERNAL REFERENCES: None                                                */
/*                                                                            */
/* Change Log                                                                 */
/*                                                                            */
/*  Mark    yy/mm/dd  Programmer      Comment                                 */
/*  ----    --------  ----------      -------                                 */
/*          99/01/11  LR                                                      */
/*  1123    99/11/23  LR              Updated OFH and DCB structures for      */
/*                                    extended USB printer identification.    */
/*                                                                            */
/**************************** END OF SPECIFICATIONS ***************************/

#include <bsedev.h>

#define  MAX_PRTS    32             // Max number of Printers
#define  MAX_COMS    16             // Max number of COM drivers. Must be equal
                                    //  to COMNMAX in PRTSEGS.ASM.
#define  MAX_OFHS    64             // Max number of Opened File Handles
#define  MAX_SEMS    64             // Max number of registered Semaphores

#define  MAX_PACKET_SIZE_0    64    // Maximum packet size for endpoint zero
                                    //    (only 8, 16, 32, or 64 are valid, USB 1.0/1)
#define  MAX_BULK_BUFFLEN     1024  // Max buffer length for bulk USBD transfers
/*
   Initialization time message IDs
*/   
#define  INIT_MESSAGE_LOADED     0
#define  INIT_MESSAGE_SERIAL     1
#define  INIT_MESSAGE_NO_USBD    2
#define  INIT_MESSAGE_UNKNOWNKWD 3
#define  INIT_MESSAGE_INVNUMERIC 4

#define MAX_INIT_MESSAGE_COUNT   2
#define MSG_REPLACEMENT_STRING   1178
/*
         Class-Specific Codes
*/
#define  INTERFACE_CLASS_PRT           7  // Base class for printers
#define  INTERFACE_SUBCL_PRT           1  // Printers
#define  INTERFACE_PROTOCOL_UNIDIR     1  // Unidirectional
#define  INTERFACE_PROTOCOL_BIDIR      2  //  Bidirectional
/*
         Class-Specific Requests
*/
#define  GET_DEVICE_ID        0  // Returns a IEEE 1284 device ID string
#define  GET_PORT_STATUS      1  // Returns the current status of the parallel port
#define  SOFT_RESET           2  // Flushes all buffers and resets bulk out/in pipes
/*
         String            Index
*/
#define  MANUFACTURER_STR     0
#define  PRODUCT_STR          1
#define  SERIALN_STR          2  // Serial Number
#define  IEEE1284ID_STR       3

#define  MAX_PRT_STR       (IEEE1284ID_STR+1)

#define  MAX_STR_LEN        256

#define  UNICODE_LANGID_DEFAULT       0
/*
         IRQs
*/   
#define  IRQ_SET_CONFIG          0
#define  IRQ_GET_STRINGD_LEN     1
#define  IRQ_GET_STRINGD         2
#define  IRQ_GET_DEVICEID_LEN    3
#define  IRQ_GET_DEVICEID        4
#define  IRQ_GET_PORT_STATUS     5
#define  IRQ_SOFT_RESET          6
#define  IRQ_WRITE_DATA          7
#define  IRQ_READ_DATA           8
#define  IRQ_WRITE_BYTE          9
#define  IRQ_SET_INTF            10 // 02/18/2000 MB
/*
         IOCtl Codes
*/
#define  IOC_SE               1  // SErial device control (IOCTL.H)
#define  IOC_PC               5  // Printer Control (IOCTL.H)
#define  IOC_PC_SPEC       0x95  // Special USB Printer Control
#define  MIN_COM_IOCTLF    0x41  // Set Bit Rate
#define  MAX_COM_IOCTLF    0x73  // Query Device Control Block
#define  MIN_PRT_IOCTLF    0x42  // Set Frame Control
#define  MAX_PRT_IOCTLF    0x76  // Assign USB Printer
#define  IOCTLF_INIT       0x46  // Initialize Printer
#define  IOCTLF_GET_STATUS 0x66  // Query Printer Status
#define  IOCTLF_REG_SEM    0x41  //   Register Semaphore
#define  IOCTLF_DEREG_SEM  0x42  // Deregister Semaphore

#define  SELECTOR_MASK  0xFFF8
/*
         Flags
*/
#define  WRITE_DATA_INPROGRESS      1
#define  WRITE_DATA_TOGGLE          2
#define  FLUSH_OUT_INPROGRESS       4
#define  WRITE_BYTE_INPROGRESS      8
#define  STOP_TRANSMIT             16
#define  WRITE_DATA_ERROR          32

#define  READ_DATA_INPROGRESS     256  
#define  READ_DATA_TOGGLE         512
#define  FLUSH_IN_INPROGRESS     1024
#define  READ_DATA_ERROR         2048

#define  FLUSH_CTL_INPROGRESS    8192
/*
         Request Packet Index
*/
#define  FIRST          0
#define  SECOND         1
#define  LAST           1
#define  CURRENT        2

#define  NUM_POINTERS   (CURRENT+1)
/*
         GDT Selector   Index
*/
#define  READ_SEL          0
#define  WRITE_SEL         1

#define  MAX_GDT_SEL       2
/*
         PRT TimeOuts   Index
*/
#define  READ_IDLE_TO      0
#define  READ_TO           1
#define  WRITE_IDLE_TO     2
#define  WRITE_TO          3
#define  LOGICAL_CHANNEL   4

#define  NUM_TIMEOUTS   (LOGICAL_CHANNEL+1)

#define  DEFAULT_READ_IDLE_TO    60000    // = 0xEA60 milliseconds = 60 s = 1 min
#define  DEFAULT_READ_TO          1000    // = 0x03E8 milliseconds =  1 s
#define  DEFAULT_WRITE_IDLE_TO   60000    // = 0xEA60 milliseconds = 60 s = 1 min
#define  DEFAULT_WRITE_TO         1000    // = 0x03E8 milliseconds =  1 s

#define  DEFAULT_LOGICAL_CHANNEL     1    // data channel for data transfers
/*
         Communication Modes (IEEE 1284 Data Transfer Modes)
*/
#define  COMM_MODE_COMPATIBLE    1  // Compatibility mode, "Centronics" or standard mode
#define  COMM_MODE_NIBBLE        2  // Nibble (4 bits) mode for reverse channel data transfer
#define  COMM_MODE_BYTE          3  // Byte mode for reverse channel data transfer or Bidirectional mode
#define  COMM_MODE_ECP           4  // Extended Capability Port mode
#define  COMM_MODE_ECP_RLE       5  // Extended Capability Port mode with Run Length Encoding data compression
#define  COMM_MODE_EPP           6  // Enhanced Parallel Port mode
/*
         Frame control values
*/
#define  CPL_80     80     //  80 chars per line horizontal spacing
#define  CPL_132   132     // 132 chars per line horizontal spacing
#define  LPI_6       6     //   6 lines per inch vertical   spacing
#define  LPI_8       8     //   8 lines per inch vertical   spacing
/*
         Printer control codes for IBM/Epson compatible printers
*/
#define  START_COMPRESSED  15    // start compressed (condensed) mode printing (132 cps)
#define  END_COMPRESSED    18    //   end compressed (condensed) mode printing ( 80 cps)
#define  ESCape            27    // lead-in code for multicharacter sequences:
#define  START_8_LPI       48    //   = 0x30 = '0'
#define  START_6_LPI       50    //   = 0x32 = '2'
/*
         Bit Rates (bits per second)
*/
#define  MIN_BITRATE          300   // 600, 1200,...
#define  MAX_BITRATE_WORD   57600
#define  MAX_BITRATE       921600   // 460800, 230400, 115200,...
#define  DEFAULT_BITRATE     9600

#define  DEFAULT_DATABITS  8
/*
         Parity
*/
#define  NO_PARITY      0
#define  ODD_PARITY     1
#define  EVEN_PARITY    2
#define  MARK_PARITY    3           // parity bit always 1
#define  SPACE_PARITY   4           // parity bit always 0
#define  DEFAULT_PARITY NO_PARITY
/*
         Stop Bits
*/
#define  ONE_STOPBIT       0
#define  ONE5_STOPBITS     1        // 1.5 stop bits
#define  TWO_STOPBITS      2
#define  DEFAULT_STOPBITS  ONE_STOPBIT
/*
         Device Control Block Flags
*/
//       Flags 1 == dcb.fbCtlHndShake
#define  F1_DTR_MASK       0x03     // DTR control mask (bits 1,0)
#define  F1_DTR_ENABLE     0x01     //  DTR enable
#define  F1_DTR_FLOW       0x02     //  DTR input handshaking
#define  F1_DTR_INVALID    0x03     //  DTR invalid input
#define  F1_OUT_FLOW       0x38     // Output handshaking mask (bits 5,4,3)
#define  F1_OUT_CTS_FLOW   0x08     //  output handshaking using CTS
#define  F1_OUT_DSR_FLOW   0x10     //  output handshaking using DSR
#define  F1_OUT_DCD_FLOW   0x20     //  output handshaking using DCD
#define  F1_IN_DSR_SENSE   0x40     // Enable input sensitivity using DSR
#define  F1_RESERVED       0x84     // Reserved bits 7,2. Set to 0
//       Flags 2 == dcb.fbFlowReplace
#define  F2_ERR_CHAR       0x04     // Enable error replacement character
#define  F2_NULL_STRIP     0x08     // Enable null stripping
#define  F2_BRK_CHAR       0x10     // Enable break replacement character
#define  F2_RTS_MASK       0xC0     // RTS control mask (bits 7,6)
#define  F2_RTS_ENABLE     0x40     //  RTS enable
#define  F2_RTS_FLOW       0x80     //  RTS input handshaking
#define  F2_RTS_TOGGLE     0xC0     //  RTS toggling on transmit
//       Flags 3 == dcb.fbTimeout
#define  F3_W_INF_TO       0x01     // Enable Write Infinite Timeout processing
#define  F3_READ_TO_MASK   0x06     // Read Timeout mask (bits 2,1)
#define  F3_READ_TO_BAD    0x00     //  Invalid input. Results in a general failure error
#define  F3_READ_TO_NORM   0x02     //  Normal Read Timeout processing
#define  F3_READ_TO_WFS    0x04     //  Wait-For-Something Read Timeout processing
#define  F3_READ_TO_NW     0x06     //  No-Wait Read Timeout processing
/*
         Modem Control Register
*/
#define  MCR_DTR  1
#define  MCR_RTS  2
/*
         Modem Status Register
*/
#define  MSR_DCD    128    // Data Carrier Detect  (V.24 signal 109)
#define  MSR_DSR     32    // Data Set Ready       (V.24 signal 107)
#define  MSR_CTS     16    // Clear To Send        (V.24 signal 106)
/*
         Initial COM TimeOuts. The value is in units of .01 seconds based on 0 (where 0=.01 seconds).
*/
#define  DEFAULT_COM_WRITE_TO    6000  // 60.01 seconds
#define  DEFAULT_COM_READ_TO     6000  // 60.01 seconds

#define  DEFAULT_XON             0x11  // DC1 ^Q
#define  DEFAULT_XOFF            0x13  // DC3 ^S
/*
         COM Event Word
*/
#define  COMEVENT_RING     256   // Trailing Edge Ring Indicator (MSR bit 2)
#define  COMEVENT_ERROR    128   // COM Error Word
#define  COMEVENT_BREAK     64   // Break Interrupt (LSR bit 4)
#define  COMEVENT_DCD       32   // Delta Data Carrier Detect (MSR bit 3)
#define  COMEVENT_DSR       16   // Delta Data Set Ready (MSR bit 1)
#define  COMEVENT_CTS        8   // Delta Clear to Send (MSR bit 0)
#define  COMEVENT_LAST       4   // last byte is sent
#define  COMEVENT_INQ        1   // byte is placed in IN Queue

typedef struct _SDATA
{                                   // String DATA array element
   USHORT   stringLength;
   ULONG    stringAddr;

} SDATA, *NPSDATA, FAR *PSDATA;

struct DeviceList                   // Attached printer array element
{
   UCHAR           bAttached;       // TRUE or FALSE
   UCHAR           bAssigned;       // DCB or OFH index

   DeviceInfo FAR *pDeviceInfo;     // controller, USB address, config, device descriptor
   UCHAR           bInterface;
   UCHAR           altInterface;    // alternate setting for the interface
   UCHAR           bProtocol;       // bidirectional or unidirectional
   UCHAR           writeEndpoint;   // mandatory
   UCHAR           readEndpoint;    // optional (bidirectional protocol)
   USHORT          wWriteMax;       // maximum packet size writeEndpoint is capable of sending
   USHORT          wReadMax;        // maximum packet size  readEndpoint is capable of receiving

   USHORT          wFlags;
   USHORT          openCount;                // for COM#
   SEL             wGDTSel[MAX_GDT_SEL];     // GDT selectors for the read and write buffers
   PRP_GENIOCTL    pRPCtl[NUM_POINTERS];     // Control Request Packet list
   PRP_RWV         pRPWrite[NUM_POINTERS];   // Write Request Packet list
   PUCHAR          pWBuffer;
   WORD            wWReqCount;
   WORD            wWCount;
   PRP_RWV         pRPRead[NUM_POINTERS];    // Read Request Packet list
   PUCHAR          pRBuffer;
   WORD            wRReqCount;
   WORD            wRCount;

   ULONG           dwTO[NUM_TIMEOUTS];       // PRT TimeOuts
   USHORT          wCommMode;                // PRT Communication Mode
   UCHAR           bShareMode;
   UCHAR           bPortStatus;              // PRT Status
   UCHAR           bInfinRetry;              // Infinite retry: 0 - disabled, 1 - enabled
   UCHAR           bCharsPerLine;
   UCHAR           bLinesPerInch;
   
   SetupPacket     setupPack;

   UCHAR           buffer[MAX_PACKET_SIZE_0];
   SDATA           string[MAX_PRT_STR];
};

typedef struct _LineCoding
{
   ULONG    dwDTERate;     // Data terminal rate, in bits per second
   UCHAR    bCharFormat;   // Stop bits: 0 - 1, 1 - 1.5, 2 - 2
   UCHAR    bParityType;   // Parity: 0 - None, 1 - Odd, 2 - Even, 3 - Mark, 4 - Space
   UCHAR    bDataBits;     // Data bits (5, 6, 7, 8 or 16???)

} LineCoding;

struct DCB                          // Device Control Block
{
   UCHAR    configured;             // TRUE or FALSE
   UCHAR    deviceIndex;            // in Attached Printer Array
   UCHAR    altInterface;
   USHORT   idVendor;
   USHORT   idProduct;
   USHORT   bcdDevice;              // device release number in binary-coded decimal

   DCBINFO     dcb;                 // COM device control block
   LineCoding  line;
   USHORT      wEvent;
   USHORT      wError;
   UCHAR       bMCR;                // Modem Control Register
   UCHAR       bMSR;                // Modem Status  Register
   UCHAR       bTxImm;
   UCHAR       bTxBreak;

   SDATA       string[MAX_PRT_STR];
};

struct OFH
{                                   // Opened File Handle array element
   UCHAR    configured;             // TRUE or FALSE
   UCHAR    prtIndex;
   USHORT   fileHandle;             // System File Number
   UCHAR    shareMode;
   UCHAR    altInterface;
   USHORT   idVendor;
   USHORT   idProduct;
   USHORT   bcdDevice;              // device release number in binary-coded decimal
   SDATA    string[MAX_PRT_STR];
};

typedef struct _BITRATE
{
   ULONG    dwBitRate;
   UCHAR    bBitRate;
   ULONG    dwMin;
   UCHAR    bMin;
   ULONG    dwMax;
   UCHAR    bMax;

}  BITRATE, FAR *PBITRATE;
/*
   The following 2 additional special IOCtls use the PDRVCFG structure:
   - IOCtl Category 5, Function 0x75;
   - IOCtl Category 5, Function 0x76.
   
   NOTE: The PDRVCFG structure must be defined precisely the same way
         in the DDK\WPSHELL\SRC\WPSH\USBPRT\PDRTYPES.H file
         of the USB Printer Port driver (USBPRT.PDR)   
*/
typedef struct _prtconf_
{
   USHORT   cIndex;                 // (00) call index
   UCHAR    ctrlID;                 // (02) controller ID
   UCHAR    deviceAddress;          // (03) USB device address
   UCHAR    entryName[9];           // (04) driver's entry name
   USHORT   altIntfce;              // (13) alternate interface index
   USHORT   idVendor;               // (15) Vendor ID
   USHORT   idProduct;              // (17) Product ID
   USHORT   bcdDevice;              // (19) Device release number
   USHORT   rStringCount;           // (21) string count packed in buffer
   USHORT   strBuffLen;             // (23) string buffer length
   UCHAR    id[];                   // (25) string buffer

}  PDRVCFG;

// big/small endian conversion macro
#define  MAKEUSINTEL(w)                MAKEUSHORT(HIBYTE(w),LOBYTE(w))

