; SCCSID = %W% %E%
;
;   Licensed Material -- Property of IBM
;
;   (c) Copyright IBM Corp. 1999  All Rights Reserved
;
        .XCREF
        .XLIST
;        INCLUDE devhdr.inc
        INCLUDE devsym.inc
        .LIST
        .CREF

COMNMAX =      16       ; Max number of COM headers. Must be equal to
                        ;  MAX_COMS in PRTTYPE.C

; offset to COM strategy routine
OFFSTR  MACRO   N
        DW      OFFSET  Strat&N
        ENDM

; Strategy Entry
STRATEN MACRO   N

Strat&N:
        MOV	BYTE PTR es:[bx+ReqUnit], N
        JMP     _Strategy
        ENDM

; COM driver name
COMNAME MACRO   N
        LOCAL   name
name    DB      "COM&N&$"
        DB      (DEV_CBNAME - ($ - name)) dup (' ')
        ENDM

        EXTRN   _Strategy:NEAR
        EXTRN   _IDCEntry:FAR
        PUBLIC  _gHead

HEADERS SEGMENT WORD PUBLIC 'HEADERS'
        EVEN
                                        ; additional USB Printer Device Driver Header
        DW      _gHead                  ; pointer to main USB Printer Device Driver Header
        DW      ?
        DW      DEV_CHAR_DEV OR DEVLEV_3 ; attribute
        DW      OFFSET Strat0           ; offset to strategy routine
        DW      ?                       ; offset to IDC entry point
        DB      "LPTx$   "              ; driver name
        DW      ?                       ; protect-mode CS strategy selector
        DW      ?                       ; protect-mode DS selector
        DW      ?                       ; real-mode CS strategy segment
        DW      ?                       ; real-mode DS segment
        DD      ?                       ; capabilities bit strip

_gHead  LABEL   WORD                    ; main USB Printer Device Driver Header

        DW      COMHS                   ; pointer to COM headers
        DW      ?
        DW      DEV_CHAR_DEV OR DEV_IOCTL OR DEVLEV_3 OR DEV_30 ; attribute
        DW      OFFSET Strat0           ; offset to strategy routine
        DW      OFFSET _IDCEntry        ; offset to IDC entry point
        DB      "$USBPRT "              ; driver name
        DW      ?                       ; protect-mode CS strategy selector
        DW      ?                       ; protect-mode DS selector
        DW      ?                       ; real-mode CS strategy segment
        DW      ?                       ; real-mode DS segment
        DD      DEV_INITCOMPLETE        ; capabilities bit strip

COMHS   LABEL   WORD                    ; USB Printer Device Driver COM Headers

COMN    =       1
        REPT    COMNMAX
        
        IF      COMN EQ COMNMAX
        DD      -1
        ELSE
        DW      $ + SIZE SysDev3
        DW      ?
        ENDIF

        DW      DEV_CHAR_DEV OR DEVLEV_3 OR DEV_30
        OFFSTR  %COMN
        DW      ?
        COMNAME %COMN
        DW      ?
        DW      ?
        DW      ?
        DW      ?
        DD      ?
COMN    =       COMN + 1
        ENDM
        
HEADERS ENDS

_DATA   segment word public 'DATA'
_DATA   ends

CONST   segment word public 'CONST'
CONST   ends

_BSS    segment word public 'BSS'
_BSS    ends

RMCode  segment word public 'CODE'
RMCode  ends

Code    segment word public 'CODE'
Code    ends

_TEXT   SEGMENT WORD PUBLIC 'CODE'
	ASSUME	CS: _TEXT
        
COMN    =       0
        REPT    COMNMAX + 1
        STRATEN %COMN
COMN    =       COMN + 1
        ENDM
_TEXT   ENDS

; Programmer cannot control location of CONST and _BSS class segments
; being grouped.  They are always last.  Do not put anything in these
; segments since they will be truncated after device driver initialization.
DGROUP  GROUP   HEADERS, CONST, _BSS, _DATA
CGROUP  GROUP   RMCode, Code, _TEXT
        END

