/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1992 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 source code is provided to you solely for       */
/*    the purpose of assisting you in your development of OS/2 device        */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Developer Connection Device Driver       */
/*    Source Kit for OS/2. This Copyright statement may not be removed.      */
/*                                                                           */
/*****************************************************************************/
/* SCCSID = "src/dev/usb/usbprt/prtproto.h, physdd.usbprt, c.basedd 99/10/21" */
/*
*
*/
/************************** START OF SPECIFICATIONS ***************************/
/*                                                                            */
/*   SOURCE FILE NAME: PRTPROTO.H                                             */
/*                                                                            */
/*   DESCRIPTIVE NAME: USB Printer Device Driver function prototypes          */
/*                                                                            */
/*   FUNCTION: This module is the USB Communication Device Class Driver       */
/*             function prototype include file.                               */
/*                                                                            */
/*   NOTES:                                                                   */
/*                                                                            */
/*      DEPENDENCIES: None                                                    */
/*      RESTRICTIONS: None                                                    */
/*                                                                            */
/*   ENTRY POINTS: None                                                       */
/*                                                                            */
/*   EXTERNAL REFERENCES: None                                                */
/*                                                                            */
/* Change Log                                                                 */
/*                                                                            */
/*  Mark      yy/mm/dd  Programmer    Comment                                 */
/*  ------    --------  ----------    -------                                 */
/*            99/01/11  LR                                                    */
/*  1123      99/11/23  LR            Added CompIEEEStrings and ComparePRT    */
/*                                    function prototypes.                    */
/* 02/18/2000 00/02/18 MB             Added SetIntfReq prototype              */
/*                                                                            */
/**************************** END OF SPECIFICATIONS ***************************/
/*
      PRTDATA.C
*/      
void (*gStratList[])(PRPH pRP);
void (*gComFunc[])(PRP_GENIOCTL pRP);
void (*gPrtFunc[])(PRP_GENIOCTL pRP);
/*
         PRTSTRAT.C                       Cmd defined in DEVCMD.H
*/
void far Strategy (void);
void     CmdError (PRPH pRP);          // Unknown

void     Read (PRPH pRP);              // CMDINPUT          =  4
void     InputStatus (PRPH pRP);       // CMDInputS         =  6
void     InputFlush (PRPH pRP);        // CMDInputF         =  7

void     FlushInPRT (USHORT unit, USHORT sfn, USHORT prtIndex);

void     Write (PRPH pRP);             // CMDOUTPUT         =  8
void     OutputStatus (PRPH pRP);      // CMDOutputS        = 10 = 0x0A
void     OutputFlush (PRPH pRP);       // CMDOutputF        = 11 = 0x0B

void     FlushOutPRT (USHORT unit, USHORT sfn, USHORT prtIndex);

void     Open (PRPH pRP);              // CMDOpen           = 13 = 0x0D
void     Close (PRPH pRP);             // CMDClose          = 14 = 0x0E
void     IOCtl (PRPH pRP);             // CMDGenIOCTL       = 16 = 0x10
void     InitComplete (PRPH pRP);      // CMDInitComplete   = 31 = 0x1F

void     FlushCtlPRT (USHORT sfn, USHORT prtIndex);
void     RemoveRP (PRPH *pRPList, PRPH pRP);
/*
         PRTINIT.C
*/         
void     Init (RPH FAR *pRP);          // CMDInit           = 0
/*
         PRTIDC.C
*/       
void far IDCEntry (PRP_GENIOCTL pRP_GENIOCTL);
void     ResetPRT (USHORT prtIndex);
void     ResetDCB (USHORT dcbIndex);
/*
         PRTIRQ.C
*/         
void     IRQSwitch (PRP_GENIOCTL pRP_GENIOCTL);
void     AttachCompleted (USHORT prtIndex);
void     GetString (USHORT prtIndex, USHORT prtStrIndex);
BOOL     CompIEEEStrings (PSZ source, PSZ target);
BOOL     ComparePRT (USHORT prtIndex, BOOL ofhdcb, USHORT index);
/*
         PRTREQ.C
*/     
void     GetStringD (USHORT prtIndex, USHORT strType, USHORT iStringD, PUCHAR pStringData);
void     GetDeviceID (USHORT prtIndex, PUCHAR pStringData);
PUCHAR   BufferAddr (USHORT prtIndex, PUCHAR pStringData);
void     GetPortStatus (USHORT prtIndex);
void     SoftReset (USHORT prtIndex);
void     WriteData (USHORT prtIndex);
void     WriteByte (USHORT prtIndex);
void     ReadData (USHORT prtIndex);
void     SetIntfReq (USHORT prtIndex); // 02/18/2000 MB
void     CancelRequests (USHORT prtIndex, USHORT endPoint);
/*
     PRTIOCTL.C                     Category 5, Function
*/
void FuncError (PRP_GENIOCTL pRP);              // Unknown

void SetFrameCtrl (PRP_GENIOCTL pRP);           // 0x42
void SetInfinRetry (PRP_GENIOCTL pRP);          // 0x44
void SetWriteTO (PRP_GENIOCTL pRP);             // 0x4E
void SetShareMode (PRP_GENIOCTL pRP);           // 0x51
void SetCommMode (PRP_GENIOCTL pRP);            // 0x52
void SetDataMode (PRP_GENIOCTL pRP);            // 0x53
void QueryFrameCtrl (PRP_GENIOCTL pRP);         // 0x62
void QueryInfinRetry (PRP_GENIOCTL pRP);        // 0x64
void QueryWriteTO (PRP_GENIOCTL pRP);           // 0x6E
void QueryShareMode (PRP_GENIOCTL pRP);         // 0x71
void QueryCommMode (PRP_GENIOCTL pRP);          // 0x72
void QueryDataMode (PRP_GENIOCTL pRP);          // 0x73
void QueryDeviceID (PRP_GENIOCTL pRP);          // 0x74

void GetPRTInfo (PRP_GENIOCTL pRP);             // 0x75
void AssignPRT (PRP_GENIOCTL pRP);              // 0x76

void   QueueRP (PRP_GENIOCTL pRPCtl);

//                               Category 0x95, Function

void  RegisterSemaphore (PRP_GENIOCTL pRP);     // 0x41
void  DeregisterSemaphore (PRP_GENIOCTL pRP);   // 0x42

USHORT VerifyParam (PRP_GENIOCTL pRP, USHORT packetLength);
USHORT VerifyData (PRP_GENIOCTL pRP, USHORT dataLength);
/*
     COMIOCtl.C                   Category = 1, Function
*/   
void SetBitRate (PRP_GENIOCTL pRPIOCtl);        // 0x41
void SetLine (PRP_GENIOCTL pRPIOCtl);           // 0x42
void SetBitRateExt (PRP_GENIOCTL pRPIOCtl);     // 0x43
void TransmitImm (PRP_GENIOCTL pRPIOCtl);       // 0x44
void SetBreakOff (PRP_GENIOCTL pRPIOCtl);       // 0x45
void SetMdmCtrl (PRP_GENIOCTL pRPIOCtl);        // 0x46
void StopTransmit (PRP_GENIOCTL pRPIOCtl);      // 0x47
void StartTransmit (PRP_GENIOCTL pRPIOCtl);     // 0x48
void SetBreakOn (PRP_GENIOCTL pRPIOCtl);        // 0x4B
void SetDCB (PRP_GENIOCTL pRPIOCtl);            // 0x53
void GetBitRate (PRP_GENIOCTL pRPIOCtl);        // 0x61
void GetLine (PRP_GENIOCTL pRPIOCtl);           // 0x62
void GetBitRateExt (PRP_GENIOCTL pRPIOCtl);     // 0x63
void GetStatus (PRP_GENIOCTL pRPIOCtl);         // 0x64
void GetTxStatus (PRP_GENIOCTL pRPIOCtl);       // 0x65
void GetModemOutput (PRP_GENIOCTL pRPIOCtl);    // 0x66
void GetModemInput (PRP_GENIOCTL pRPIOCtl);     // 0x67
void GetInQueue (PRP_GENIOCTL pRPIOCtl);        // 0x68
void GetOutQueue (PRP_GENIOCTL pRPIOCtl);       // 0x69
void GetError (PRP_GENIOCTL pRPIOCtl);          // 0x6D
void GetEvent (PRP_GENIOCTL pRPIOCtl);          // 0x72
void GetDCB (PRP_GENIOCTL pRPIOCtl);            // 0x73
void GetEnhMode (PRP_GENIOCTL pRPIOCtl);        // 0x74

void SimulateModem (USHORT dcbIndex);
/*
   USHORT APIENTRY DevHelp_Yield(); in DHCALLS.H causes
   warning C4071: 'DevHelp_Yield' : no function prototype given
*/
USHORT APIENTRY DevHelp_Yield(void);

