/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1992 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 source code is provided to you solely for       */
/*    the purpose of assisting you in your development of OS/2 device        */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Developer Connection Device Driver       */
/*    Source Kit for OS/2. This Copyright statement may not be removed.      */
/*                                                                           */
/*****************************************************************************/
/* SCCSID = "%W% %E%" */
/*
*
*/
/************************** START OF SPECIFICATIONS ***************************/
/*                                                                            */
/*   SOURCE FILE NAME: PRTEXTRN.H                                             */
/*                                                                            */
/*   DESCRIPTIVE NAME: USB Printer Device Driver external data declarations   */
/*                                                                            */
/*   FUNCTION: This module is the USB Printer Device Driver external data     */
/*             declarations include file. See PRTDATA.C for the data items    */
/*             being externalized.                                            */
/*                                                                            */
/*   NOTES:                                                                   */
/*                                                                            */
/*      DEPENDENCIES: None                                                    */
/*      RESTRICTIONS: None                                                    */
/*                                                                            */
/*   ENTRY POINTS: None                                                       */
/*                                                                            */
/*   EXTERNAL REFERENCES: None                                                */
/*                                                                            */
/* Change Log                                                                 */
/*                                                                            */
/*  Mark    yy/mm/dd  Programmer      Comment                                 */
/*  ----    --------  ----------      -------                                 */
/*          99/01/11  LR                                                      */
/*                                                                            */
/**************************** END OF SPECIFICATIONS ***************************/

extern         UCHAR      gNPRTs;    // Number of attached Printers
extern struct  DeviceList gPRT[];    // attached Printer array
extern struct  DCB        gDCB[];    // Device Control Block array
extern struct  OFH        gOFH[];    // Opened File Handle array
extern         ULONG      gSEM[];    // Semaphore array

extern   WORD     gHead;
extern   PFN      Device_Help;
extern   BYTE     gPortCount;    // number of COM drivers

extern   PUSBIDCEntry   gpUSBDIDC;
extern   USHORT         gdsUSBDIDC;
extern   USHORT         gMaxBufferLength;     // max buffer length for bulk USBD transfers

extern   UCHAR    gMFGKey[4], gMDLKey[4], gDESKey[4], gCLSKey[13];

#ifdef   DEBUG
extern   USHORT   gPRTMsg;       // debug message level
#endif
/*---------------------------------------------------------------------------*/
/*                         Initialization Data                               */
/*---------------------------------------------------------------------------*/
extern   BYTE  gInitDataStart;
extern   BYTE  gFirstInit;
extern   BYTE  gSetLPT;

extern   IDCTABLE       gIDCTable;

extern   char  gDDName[];
extern   char  gDDDesc[];
extern   char  gVendorID[];
extern   char  gAdapterName[];

extern   DRIVERSTRUCT   gDriverStruct;
extern   ADAPTERSTRUCT  gAdapterStruct;

extern   HDRIVER  ghDriver;
extern   HADAPTER ghAdapter;

extern   USHORT   gVerbose;
extern   USHORT   gMessageIDs[MAX_INIT_MESSAGE_COUNT];
extern   PSZ      gVMessages[];
extern   USHORT   gMessageCount;

