/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1992 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 source code is provided to you solely for       */
/*    the purpose of assisting you in your development of OS/2 device        */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Developer Connection Device Driver       */
/*    Source Kit for OS/2. This Copyright statement may not be removed.      */
/*                                                                           */
/*****************************************************************************/
/* SCCSID = "src/dev/usb/usbprt/prtdata.c, physdd.usbprt, c.basedd 99/11/09" */
/*
*
*/
/************************** START OF SPECIFICATIONS ***************************/
/*                                                                            */
/*   SOURCE FILE NAME: PRTDATA.C                                              */
/*                                                                            */
/*   DESCRIPTIVE NAME: USB Printer driver Data segment                        */
/*                                                                            */
/*   FUNCTION: This module allocates the global data area                     */
/*             for the USB printer driver.                                    */
/*                                                                            */
/*   NOTES:                                                                   */
/*                                                                            */
/*      DEPENDENCIES: None                                                    */
/*      RESTRICTIONS: None                                                    */
/*                                                                            */
/*   ENTRY POINTS: None                                                       */
/*                                                                            */
/*   EXTERNAL REFERENCES: None                                                */
/*                                                                            */
/* Change Log                                                                 */
/*                                                                            */
/*  Mark    yy/mm/dd  Programmer      Comment                                 */
/*  ----    --------  ----------      -------                                 */
/*          99/01/11  LR                                                      */
/*                                                                            */
/**************************** END OF SPECIFICATIONS ***************************/

#include "prt.h"

UCHAR             gNPRTs;           // Number of attached Printers
struct DeviceList gPRT[MAX_PRTS];   // attached Printer array
struct DCB        gDCB[MAX_COMS];   // Device Control Block array
struct OFH        gOFH[MAX_OFHS];   // Opened File Handle array
ULONG             gSEM[MAX_SEMS];   // Semaphore array
/*
      Dispatch table for strategy commands
*/   
void (*gStratList[])() =
{
   Init,             // 0x00  initialize device driver
   CmdError,         // 0x01  check the media
   CmdError,         // 0x02  build BPB
   CmdError,         // 0x03  reserved
   Read,             // 0x04  read
   CmdError,         // 0x05  non-destructive read
   InputStatus,      // 0x06  input status
   InputFlush,       // 0x07  input flush
   Write,            // 0x08  write
   CmdError,         // 0x09  write with verify
   OutputStatus,     // 0x0A  output status
   OutputFlush,      // 0x0B  flush output
   CmdError,         // 0x0C  reserved
   Open,             // 0x0D  open
   Close,            // 0x0E  close
   CmdError,         // 0x0F  removable media
   IOCtl,            // 0x10  generic IOCTL
   CmdError,         // 0x11  reset uncertain media
   CmdError,         // 0x12  get Logical Drive Map
   CmdError,         // 0x13  set Logical Drive Map
   CmdError,         // 0x14  de-Install this device
   CmdError,         // 0x15  reserved
   CmdError,         // 0x16  get number of partitions
   CmdError,         // 0x17  get unit map
   CmdError,         // 0x18  no caching read
   CmdError,         // 0x19  no caching write
   CmdError,         // 0x1A  no caching write/verify
   CmdError,         // 0x1B  initialize base device driver
   CmdError,         // 0x1C  reserved for Request List code
   CmdError,         // 0x1D  get driver capabilities
   CmdError,         // 0x1E  reserved
   InitComplete      // 0x1F  initialization complete
};
/*
      Dispatch Table for IOCtl Category 1 Functions
*/
void (*gComFunc[])() =
{
   SetBitRate,        // 0x41  set bit rate
   SetLine,           // 0x42  set line characteristics (data bits, parity, stop bits)
   SetBitRateExt,     // 0x43  extended set bit rate
   TransmitImm,       // 0x44  transmit byte immediate
   SetBreakOff,       // 0x45  set break off
   SetMdmCtrl,        // 0x46  set modem control signals
   StopTransmit,      // 0x47  behave as if XOFF received (stop  transmit)
   StartTransmit,     // 0x48  behave as if XON  received (start transmit)
   FuncError,         // 0x49  reserved
   FuncError,         // 0x4A
   SetBreakOn,        // 0x4B  set break on
   FuncError,         // 0x4C
   FuncError,         // 0x4D
   FuncError,         // 0x4E
   FuncError,         // 0x4F
   FuncError,         // 0x50
   FuncError,         // 0x51
   FuncError,         // 0x52
   SetDCB,            // 0x53  set Device Control Block (DCB) info
   FuncError,         // 0x54  set enhanced mode parameters, this IOCtl is not supported
   FuncError,         // 0x55
   FuncError,         // 0x56
   FuncError,         // 0x57
   FuncError,         // 0x58
   FuncError,         // 0x59
   FuncError,         // 0x5A
   FuncError,         // 0x5B
   FuncError,         // 0x5C
   FuncError,         // 0x5D
   FuncError,         // 0x5E
   FuncError,         // 0x5F
   FuncError,         // 0x60
   GetBitRate,        // 0x61  query current bit rate
   GetLine,           // 0x62  query line characteristics
   GetBitRateExt,     // 0x63  extended query bit rate
   GetStatus,         // 0x64  query status
   GetTxStatus,       // 0x65  query transmit data status
   GetModemOutput,    // 0x66  query modem control output signals (MCR)
   GetModemInput,     // 0x67  query current modem input  signals (MSR)
   GetInQueue,        // 0x68  query number of characters in receive  queue
   GetOutQueue,       // 0x69  query number of characters in transmit queue
   FuncError,         // 0x6A
   FuncError,         // 0x6B
   FuncError,         // 0x6C
   GetError,          // 0x6D  query error information
   FuncError,         // 0x6E
   FuncError,         // 0x6F
   FuncError,         // 0x70
   FuncError,         // 0x71
   GetEvent,          // 0x72  query event information
   GetDCB             // 0x73  query Device Control Block (DCB) parameters
// GetEnhMode         // 0x74  query enhanced mode parameters, this IOCtl is not supported
};
/*
   Dispatch Table for IOCtl Category 5 Functions.
   
   The USB Printer Device Driver does not support character monitors and
   therefore does not support the category 0x0A and 0x0B monitor IOCtl commands.
   It also does not support the following category 5 IOCtl functions related to
   code page and font switching (previously performed by a character monitor):
      - Activate Font (function 0x48),
      - Query Active Font (function 0x69),
      - Verify Font (function 0x6A).
*/
void (*gPrtFunc[])() =
{
   SetFrameCtrl,        // 0x42  set frame control
   FuncError,           // 0x43
   SetInfinRetry,       // 0x44  set infinite retry
   FuncError,           // 0x45
   QueueRP,             // 0x46  initialize printer
   FuncError,           // 0x47
   FuncError,           // 0x48  - activate font
   FuncError,           // 0x49
   FuncError,           // 0x4A
   FuncError,           // 0x4B
   FuncError,           // 0x4C
   FuncError,           // 0x4D  -??? set print-job title
   SetWriteTO,          // 0x4E  set write timeout value
   FuncError,           // 0x4F
   FuncError,           // 0x50
   SetShareMode,        // 0x51  set share         mode
   SetCommMode,         // 0x52  set communication mode
   SetDataMode,         // 0x53  set data transfer mode
   FuncError,           // 0x54
   FuncError,           // 0x55
   FuncError,           // 0x56
   FuncError,           // 0x57
   FuncError,           // 0x58
   FuncError,           // 0x59
   FuncError,           // 0x5A
   FuncError,           // 0x5B
   FuncError,           // 0x5C
   FuncError,           // 0x5D
   FuncError,           // 0x5E
   FuncError,           // 0x5F
   FuncError,           // 0x60
   FuncError,           // 0x61
   QueryFrameCtrl,      // 0x62  query frame control
   FuncError,           // 0x63
   QueryInfinRetry,     // 0x64  query infinite retry
   FuncError,           // 0x65
   QueueRP,             // 0x66  query status
   FuncError,           // 0x67
   FuncError,           // 0x68
   FuncError,           // 0x69  - query active font
   FuncError,           // 0x6A  - verify font
   FuncError,           // 0x6B
   FuncError,           // 0x6C
   FuncError,           // 0x6D
   QueryWriteTO,        // 0x6E  query write timeout value
   FuncError,           // 0x6F
   FuncError,           // 0x70
   QueryShareMode,      // 0x71  query share         mode
   QueryCommMode,       // 0x72  query communication mode
   QueryDataMode,       // 0x73  query data transfer mode
   QueryDeviceID,       // 0x74  query device id
                        //       two additional USB printer functions
   GetPRTInfo,          // 0x75  get attached USB printer information
   AssignPRT            // 0x76  assign USB printer
};

PFN   Device_Help = NULL;  // pointer to DevHlp routines

PUSBIDCEntry   gpUSBDIDC = NULL;
USHORT         gdsUSBDIDC = NULL;
USHORT         gMaxBufferLength = 0;   // max buffer length for bulk USBD transfers

UCHAR gPortCount = 0;   // number of COM drivers
/*
      IEEE-1284 Device ID Keys for the MakeDeviceID function in the PRTIRQ.C file.
      See also the PRTEXTRN.H file.
*/
UCHAR gMFGKey[4]  = "MFG:",         // manufacturer
      gMDLKey[4]  = "MDL:",         // model
      gDESKey[4]  = "DES:",         // description
      gCLSKey[]   = "CLS:PRINTER;"; // class

#ifdef DEBUG
USHORT gPRTMsg = 0xFF;  // DBG_CRITICAL   // debug message level
#endif
/*---------------------------------------------------------------------------*/
/*                         Initialization Data                               */
/*---------------------------------------------------------------------------*/
BYTE  gInitDataStart = TRUE;
BYTE  gFirstInit     = TRUE;
BYTE  gSetLPT        = TRUE;

IDCTABLE gIDCTable = {{ 0, 0, 0}, 0, 0}; //	structure used by DevHlp AttachDD

// Global variables for RM
ULONG RMFlags  = 0L;
PFN   RM_Help0 = 0L;
PFN   RM_Help3 = 0L;

DRIVERSTRUCT gDriverStruct =  // Driver Description
{
   gDDName,                   // DrvrName
   gDDDesc,                   // DrvrDescript
   gVendorID,                 // VendorName
   CMVERSION_MAJOR,           // MajorVer
   CMVERSION_MINOR,           // MinorVer
   1999,12,13,                // Date (year,month,day)
   DRF_STATIC,                // DrvrFlags
   DRT_OS2,                   // DrvrType
   DRS_CHAR,                  // DrvrSubType
   NULL                       // DrvrCallback
};
ADAPTERSTRUCT gAdapterStruct =   // Adapter Description
{
   gAdapterName,                 // AdaptDescriptName
   AS_NO16MB_ADDRESS_LIMIT,      // AdaptFlags
   AS_BASE_COMM,                 // BaseType
   AS_SUB_PARALLEL,              // SubType
   AS_INTF_BIDI,                 // InterfaceType
   NULL,                         // HostBusType
   NULL,                         // HostBusWidth
   NULL,                         // pAdjunctList
   NULL                          // reserved
};

// Global handle variables
HDRIVER  ghDriver = NULL;
HADAPTER ghAdapter = NULL;

USHORT gVerbose       = 0;
USHORT gMessageCount  = 0;
USHORT gMessageIDs[MAX_INIT_MESSAGE_COUNT];
PSZ    gVMessages[] =
{
   "IUSBPRT.SYS: USB Printer Device Class Driver V.%dd.%dd loaded",
   "IUSBPRT.SYS: Number of Serial Entries: %dd, First Name: COM%dd",
   "EUSBPRT.SYS: USBD Driver not found",
   "EUSBPRT.SYS: Invalid parameter in CONFIG.SYS line at column %dd",
   "EUSBPRT.SYS: Invalid numeric value in CONFIG.SYS line at column %dd"
};
// structure used to write out message during initialization
MSGTABLE gInitMsg = {MSG_REPLACEMENT_STRING, 1, 0};

